@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem Use Tiny C compiler to have small code size, see http://www.bellard.org/tcc/

:Main
for %%x in ( saferun ) do call :CompileProg %%x
goto :EOF

:CompileProg
if "%~1" == "" goto :EOF
if exist %1.exe del /F %1.exe
if exist %1.exe ( call :NotifyFailure "Could not delete file %1.exe." & goto :EOF )
if not exist %1.c ( call :NotifyFailure "Could not find source file %1.c." & goto :EOF )
unix tcc %1.c -luser32 -ladvapi32
for %%i in (%1.exe) do call :NotifySuccess "%%~nxi compiled, %%~zi bytes."
if not exist %1.exe call :NotifyFailure "Could not compile %1.c"
goto :EOF

:NotifySuccess
if "%~1" == "" goto :EOF
unix tooltip-notifier text "%~1" bkcolor green fontsize 24 delay 15000
echo Success: %~1
goto :EOF

:NotifyFailure
if "%~1" == "" goto :EOF
unix tooltip-notifier text "%~1" bkcolor red fontsize 24 delay 15000
echo Failure: %~1
goto :EOF


