@echo off
@SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2018 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Get (summary) size of given file/mask in given units
:: Note: due to 32-bit counter fails on files over 2 GB
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
:CheckOptions
@if "%~1" == ""          ( call :Help %~n0 & goto :EOF )
@if "%~1" == "/?"        ( call :Help %~n0 & goto :EOF )
@if "%~1" == "-h"        ( call :Help %~n0 & goto :EOF )
@if "%~1" == "--help"    ( call :Help %~n0 & goto :EOF )
@if "%~1" == "--version" ( call :Version %~n0 & goto :EOF )
:MainProcessing
@call :SetErrorLevel 0
@set /a "bsize=0"
@set /a "nsize=0"
@set /a "nfact=1"
@set /a "kb=1024"
@set /a "mb=kb*kb"
@set /a "gb=mb*kb"
@if not "%~2" == "" set /a "nfact=%~2"
@if %nfact% LEQ 1 set /a "nfact=1"
@call :GetFileSize %1
@set /a "psize=nsize"
@set /a "nceil=nfact"
@if "%~3" == "--ceil"  set /a "nceil=1"
@if "%~3" == "--floor" set /a "nceil=nfact"
@if "%~3" == "--round" set /a "nceil=nfact/2"
@if %nfact% GTR 1 if %bsize% GEQ %nceil% set /a "psize+=1"
@echo %psize%
@goto :EOF

:GetFileSize
@if "%~1" == "" goto :EOF
@if not exist "%~1" goto :EOF
@for /f "delims=" %%i in ('dir /s /b %1') do ( 
 @set /a "fsize=%%~zi"
 @set /a "nsize=nsize+(bsize+fsize)/nfact"
 @set /a "bsize=(bsize+fsize)%%nfact"
)
@goto :EOF

:Version
@echo %~1 version 1.0
@goto :EOF

:Help
@echo.
@call :Version %1
@echo Copyright^(c^) 2018 Alexey Kuryakin kouriakine@mail.ru
@echo Get summary size of given file/mask, in given units.
@echo Note: due to 32-bit counter fails on files over 2gb.
@echo Usage :
@echo  call %1 f [n] [r]
@echo       where f = regular file name or file mask
@echo             n = divider option ^(=1 by default^)
@echo             kb/mb/gb mean kilo/mega/giga bytes
@echo             r = rounding mode: --ceil, --round
@echo             by default rounding mode = --floor
@echo Examples:
@echo  call %1 c:\Crw32exe\Crw32.exe    get regular file size, bytes
@echo  call %1 c:\Crw32exe\* 1000       file size in 1000-byte units
@echo  call %1 c:\Crw32exe\* kb         summary file size, kilobytes
@echo  call %1 c:\Crw32exe\* mb         summary file size, megabytes
@echo  call %1 c:\Crw32exe\* mb --ceil  file size, mb, upper rounded
@echo.
@goto :EOF

:SetErrorLevel
@exit /b %1
@goto :EOF
