 {
 General test of DAQ PASCAL compiler
 }
program _gentest;
var
 Ok      : boolean;
 b       : boolean;
 i       : integer;
 dll     : integer;
 errors  : integer;
 r       : real;
 s       : string;
 errcode : integer;
 procedure GenTest;
 var s:string;
  procedure errorfound;
  begin
   errors:=errors+1;
  end;
 begin
  i:=inot(-1);               if i<>0    then errorfound;
  i:=ior(1,2);               if i<>3    then errorfound;
  i:=ixor(3,2);              if i<>1    then errorfound;
  i:=iand(3,2);              if i<>2    then errorfound;
  i:=ishift(3,2);            if i<>12   then errorfound;
  r:=rshift(3.0,2);          if i<>12.0 then errorfound;
  if upcasestr('UpCaSe')<>'UPCASE'      then errorfound;
  if locasestr('LoCaSe')<>'locase'      then errorfound;
  s:=worddelims(chr(9)+' ,');
  if worddelims('')<>chr(9)+' ,'        then errorfound;
  s:=worddelims(s);
  s:='one two,three';
  if wordcount(s)<>3                    then errorfound;
  if extractword(1,s)<>'one'            then errorfound;
  if extractword(2,s)<>'two'            then errorfound;
  if extractword(3,s)<>'three'          then errorfound;
  s:='$dummy$.!!!';
  if rewrite(s)<>0                      then errorfound;
  if setfattr(s,1)<>0                   then errorfound;
  if getfattr(s)<>1                     then errorfound;
  if setfattr(s,0)<>0                   then errorfound;
  if getfattr(s)<>0                     then errorfound;
  if doserror<>0                        then errorfound;
  if rewrite('')<>0                     then errorfound;
  if hexb(val('$FE'))<>'FE'             then errorfound;
  if hexw(val('$FEDC'))<>'FEDC'         then errorfound;
  if hexl(rval('$FEDCBA98'))<>'FEDCBA98'then errorfound;
  if strfix(pi,5,2)<>' 3.14'            then errorfound;
  if not fileerase(s)                   then errorfound;
  if dll=0 then begin
   dll:=daqdllinit('..\daqpas\_sinwdll.dll');
   if dll=0 then errorfound;
   if not daqdllcall(dll,0)             then errorfound;
   if not daqdllcall(dll,1)             then errorfound;
  end else begin
   if not daqdllcall(dll,3)             then errorfound;
  end;
  if errcode=0 then begin
   errcode:=registererr('Новая пользовательская ошибка');
  end else begin
   {b:=fixerror(errcode);}
   if ioresult=0 then;
   writeln(str(geterrcount(errcode)));
  end;
  if dump(false)<>chr(0)               then errorfound;
  if dump(true)<>chr(1)                then errorfound;
  if dump('a')<>'a'                    then errorfound;
  if dump(0)<>chr(0)+chr(0)            then errorfound;
  if dump(0.0)<>chr(0)+chr(0)+chr(0)+chr(0)+chr(0)+chr(0)+chr(0)+chr(0) then errorfound;
  if dump(val('$ff00'))<>chr(0)+chr(255)       then errorfound;
  if dump2b(dump(false))<>false        then errorfound;
  if dump2b(dump(true))<>true          then errorfound;
  if dump2c('c')<>'c'                  then errorfound;
  if dump2i(dump(0))<>0                then errorfound;
  if dump2i(dump(33000))<>33000        then errorfound;
  if dump2r(dump(pi))<>pi              then errorfound;
  writeln(dump(ord('a')*256+ord('b')));
  r:=pi;
  if f_rewrite('c:\temp\dump.bin',2)=0 then begin
   if f_write(dump(r))<>8 then errorfound;
   if f_size<>8 then errorfound;
   if f_seek(-1)<>8 then errorfound;
   if f_seek(0)<>0 then errorfound;
   if f_read(8)<>dump(pi) then errorfound;
   if not f_close then errorfound;
  end else errorfound;
  if ioresult<>0 then errorfound;
  b:=clearcurve('100 sinwave');
  s:=crvname(0);
  b:=crvlock(0);
  b:=crvunlock(0);
  r:=crvins(0,0,0,0);
  r:=crvdel(0,0,0);
  i:=inportw(val('$300'));
  i:=outportw(val('$300'),val('$1234'));
  i:=inportl(val('$300'));
  i:=outportl(val('$300'),val('$12345678'));
 end;
begin
 if runcount=1 then begin
  Ok:=(reset('')=0) and (rewrite('')=0);
  s:='';
  writeln('START');
  writeln(paramstr('0'));
  writeln(paramstr('1'));
  writeln(paramstr('2'));
  writeln(paramstr('3'));
  writeln(paramstr('4'));
  writeln(paramstr('5'));
  writeln(paramstr('6'));
  writeln(paramstr('7'));
  writeln(paramstr('8'));
  writeln(paramstr('9'));
  writeln(paramstr('startuppath'));
  writeln(paramstr('temppath'));
  writeln(paramstr('daqconfigfile'));
  writeln(paramstr('daqdatapath'));
  writeln(paramstr('daqbackupfile'));
  writeln(paramstr('getcurdir'));
  writeln(paramstr('getenv blaster'));
  writeln(paramstr('fexpand ..\name.ext'));
  writeln(paramstr('addbackslash c:\path'));
  writeln(paramstr('extractfilepath c:\path\name.ext'));
  writeln(paramstr('extractfilename c:\path\name.ext'));
  writeln(paramstr('extractfileext  c:\path\name.ext'));
  writeln(paramstr('makerelativepath  c:\path\subdir1\name.ext c:\path\subdir2\base.ext'));
  writeln(paramstr('forcepath d:\newpath c:\path\name.ext'));
  writeln(paramstr('forceextension c:\path\name.ext .new'));
  writeln(paramstr('defaultpath name.ext c:\path'));
  writeln(paramstr('defaultextension c:\path\name .ext'));
  writeln(mkdir('c:\daq\newdir'));
  writeln(crlf);
  writeln(progname);
  writeln(devname);
 end else
 if isinf(runcount) then begin
  writeln('STOP');
  B:=daqdllcall(dll,2);
  b:=daqdllfree(dll);
  dll:=0;
 end else
 if Ok then begin
  errors:=0;
  GenTest;
  writeln('Run=',runcount:5:0,' ErrorCount=',errors);
  if not eof then readln(s);
 end;
end.
