@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ***************************
rem DIM Client config generator
rem ***************************

chcp 65001

:Main
call :InitializeVariables
pushd "%~dp0" && call :DIMClientCfg
pushd "%~dp0" && call :DIMClientCrc
popd
goto :EOF

:InitializeVariables
set clientcrc=..\Circuits\%~n0.crc
set ctrlcrc=..\Circuits\ddim_ctrl.crc
set clientcfg=%~n0.cfg
set diccfg=ddim_dic.cfg
set ctrlcfg=ddim_ctrl.cfg
set tagscfg=ddim_tags.cfg
set initcfg=ddim_init.cfg
goto :EOF

:DIMClientCfg
call :DeleteFile %clientcfg%
call :CFG_Client >> %clientcfg%
echo Cfg-file generation...Done
goto :EOF

:DIMClientCrc
call :DeleteFile %clientcrc%
call :CRC_Client >> %clientcrc%
echo Crc-file generation...Done
goto :EOF

:CFG_Client
type %diccfg%
type %ctrlcfg%
call :CFG_Client_Window
type %tagscfg%
type %initcfg%
goto :EOF

:CRC_Client
call :CRC_Client_Header
type %ctrlcrc%
goto :EOF

:CFG_Client_Window
echo ;**********************
echo ; Client control window
echo ;**********************
echo [Windows]
echo DDIM.CTRL = Circuit_Window
echo [DDIM.CTRL]
echo Circuit = ..\Circuits\ddim_client.crc
echo Link sensor DDIM.CLOCK  with tag DDIM.CLOCK  device ^&DDIM.CTRL
echo Link sensor DDIM.SERVID with tag DDIM.SERVID device ^&DDIM.CTRL
echo Link sensor DDIM.TITLE  with                 device ^&DDIM.CTRL
echo []
goto :EOF

:CRC_Client_Header
echo [Circuit]
echo GeneralMap = ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_700_700_24_silver.bmp
echo Hint = Панель управления DDIM
echo ToolBarHeight = 2
echo []
echo [ConfigFileList] ; Include the Painter GUI Library
echo ConfigFile = ~~\Resource\DaqSite\Default\Painter.crc
echo ConfigFile = ddim_ctrl.crc
echo []
echo ;****************
echo ; Toolbar buttons
echo ;****************
echo [SensorList]
echo Sensor = @cron+@cron.run+DDIM.CTRL.HIDE
echo [@cron+@cron.run+DDIM.CTRL.HIDE]
echo Pos = 630, 1000
echo Painter(v) = (glButtonBevel=2)
echo Painter(v) = [Painter(v).GuiLib.Cmd.Close]
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_32_32_24_silver.bmp
echo Hint = Закрыть окно DDIM.CTRL
echo ToolBarOpaque = 1
echo ToolBarBorder = 0
echo ToolBarSpace  = 2
echo ToolBarKey    = 1
echo []
goto :EOF

:DeleteFile
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFile
goto :EOF
