@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem *****************************
rem WIKA devices config generator
rem WIKA are sensors by WIKA.com
rem ******************************


chcp 65001


:Main
call :InitializeVariables
pushd "%~dp0" && call :WikaDevices
popd
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set tabcrc=..\Circuits\%~n0.crc
set devmsg=devPostMsg
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=450
set /a CTRL_TOP_STEP=50
set /a MAIN_HEIGHT=160
set /a MAIN_H_STEP=50
set /a TABCRC_TOP=0
set /a TABCRC_STEP=50
set MAIN_CTRL=WIKA.MAIN.CTRL
set PARAM_PLOT=WIKA.PARAM.PLOT
set STATE_PLOT=WIKA.STATE.PLOT
goto :EOF

:WikaDevices
call :DeleteFiles %hdwcfg% %simcfg% %diccfg% %discfg% %tabcrc%
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::: Device  Facility   Identitier PortNum Polling  Model
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
call :WIKA    DEMO.WIKA  WIK1       1       50       "D-10-P"
::call :WIKA    DEMO.WIKA  WIK2       1       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK3       3       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK4       4       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK5       5       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK6       6       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK7       7       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK8       8       20       "D-10"
::call :WIKA    DEMO.WIKA  WIK9       9       20       "D-10"
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
call :WIKA_DONE >> %hdwcfg%
type %hdwcfg% %simcfg%
goto :EOF

:WIKA_DONE
echo.
echo [^&CronSrv.StartupScript]
echo @cron.job %MAIN_CTRL%.HOME @async @async @WinDraw %MAIN_CTRL%^|Height=%MAIN_HEIGHT%
echo []
echo.
goto :EOF

:WIKA
call :WIKA_HDW %* >> %hdwcfg%
call :WIKA_SIM %* >> %simcfg%
call :WIKA_DIC %* >> %diccfg%
call :WIKA_DIS %* >> %discfg%
call :WIKA_TABCRC >> %tabcrc%
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a MAIN_HEIGHT+=MAIN_H_STEP
goto :EOF

:WIKA_HDW
set "FACN=%~1"       & shift    & :: Facility name
set "IDEN=%~1"       & shift    & :: Device identifier name
set "ComPort=%~1"    & shift    & :: COM port number
set "ComPolling=%~1" & shift    & :: COM port polling period, ms
set "ModelName=%~1"  & shift    & :: Device model name
set "FACP=%FACN:.=/%"           & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"           & :: Facility file name, i.e. FACN name with . to _ replacement
echo ;**********************
echo ; WIKA Driver for %IDEN%
echo ;**********************
echo.
echo [SerialPort-COM%ComPort%]
echo Port     = COM%ComPort%
echo BaudRate = 9600
echo Parity   = NONE
echo DataBits = 8
echo StopBits = 1
echo DcbFlags = $1010 ; RTS=$1000 + DTR=$0010 uses as instrument supply voltage
echo []
echo.
echo [TagList]
echo %FACN%.%IDEN%.DIMGUICLICK = string  ?               ; The DIM click sensor data
echo %FACN%.%IDEN%.POLL_ENABLE = integer 0               ; Enable polling flag
echo %FACN%.%IDEN%.POLL_RATE   = real    0               ; Polling rate, poll/sec
echo %FACN%.%IDEN%.ERROR_CNT   = real    0               ; Device error counter
echo %FACN%.%IDEN%.ID_NAME     = string  %IDEN%          ; Device identifier, e.g WIK1
echo %FACN%.%IDEN%.ID_IDN      = string  ?               ; Device model identifier, e.g. D-10
echo %FACN%.%IDEN%.PAR_MA      = real    0               ; MA - Lower limit of range (MBA)
echo %FACN%.%IDEN%.PAR_ME      = real    0               ; ME - Upper limit of range (MBE)
echo %FACN%.%IDEN%.PAR_PZ      = real    0               ; PZ - Measure pressure value as physical unit
echo %FACN%.%IDEN%.PAR_PZMU    = string  ?               ;      Measuring method and physical units
echo %FACN%.%IDEN%.PAR_PZM     = integer 0               ;      Measuring method 0/1=rel/abs
echo %FACN%.%IDEN%.PAR_PZU     = integer 0               ;      Physical units: 0/1/2/3/4/5=bar/psi/mmHg/inHg/mWs/inWs
echo %FACN%.%IDEN%.PAR_PK      = real    0               ; PK - Measure pressure value in digits
echo %FACN%.%IDEN%.PAR_PKS     = integer 0               ;      Pressure Status 0/1=Good/Fail
echo %FACN%.%IDEN%.PAR_KN      = string  ?               ; KN - Instrument number
echo %FACN%.%IDEN%.PAR_TW      = real    0               ; TW - Measure temperature, °C
echo %FACN%.%IDEN%.PAR_AZ      = integer 0               ; AZ - Response time in polling mode
echo []
echo.
echo [DataStorage]
echo %FACN%.%IDEN%.POLL_RATE   = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.ERROR_CNT   = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_MA      = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_ME      = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_PZ      = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_PZM     = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_PZU     = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_PK      = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_PKS     = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_TW      = Curve 0 10 Black 15 1
echo %FACN%.%IDEN%.PAR_AZ      = Curve 0 10 Black 15 1
echo []
echo.
echo [DeviceList]
echo ^&%FACN%.%IDEN%.CTRL = device software program
echo [^&%FACN%.%IDEN%.CTRL]
echo Comment        = Hardware driver for WIKA D1X sensor %IDEN%.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpHigher
echo ProgramSource  = ..\DaqPas\wika_d1x_drv.pas
echo StartupScript  = [^&%FACN%.%IDEN%.CTRL.StartupScript]
echo FinallyScript  = [^&%FACN%.%IDEN%.CTRL.FinallyScript]
echo DigitalFifo    = 1024
echo AnalogFifo     = 1024
echo DebugFlags     = 3
echo OpenConsole    = 2
echo Simulator      = 0
echo ComPort        = %ComPort%
echo ComTimeOut     = 250
echo ComTimeGap     = 10
echo PollPeriod     = %ComPolling%
echo ModelName      = %ModelName%
echo tagPrefix      = %FACN%.%IDEN%
echo HelpFile       = ..\Help\wika.htm
echo EncryptMethod  = RC6
echo TrustedUsers   = [TrustedUsers]
echo AnalogOutputs  = 11
echo Link AnalogOutput  0 with curve %FACN%.%IDEN%.POLL_RATE    history 1000
echo Link AnalogOutput  1 with curve %FACN%.%IDEN%.ERROR_CNT    history 1000
echo Link AnalogOutput  2 with curve %FACN%.%IDEN%.PAR_MA       history 1000
echo Link AnalogOutput  3 with curve %FACN%.%IDEN%.PAR_ME       history 1000
echo Link AnalogOutput  4 with curve %FACN%.%IDEN%.PAR_PZ       history 1000
echo Link AnalogOutput  5 with curve %FACN%.%IDEN%.PAR_PZM      history 1000
echo Link AnalogOutput  6 with curve %FACN%.%IDEN%.PAR_PZU      history 1000
echo Link AnalogOutput  7 with curve %FACN%.%IDEN%.PAR_PK       history 1000
echo Link AnalogOutput  8 with curve %FACN%.%IDEN%.PAR_PKS      history 1000
echo Link AnalogOutput  9 with curve %FACN%.%IDEN%.PAR_TW       history 1000
echo Link AnalogOutput 10 with curve %FACN%.%IDEN%.PAR_AZ       history 1000
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%FACN%.%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FACF%_%IDEN%_Custom.Ini
echo CustomIniSection  = [%FACN%.%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FACF%_%IDEN%_Custom.ini
echo []
echo [%FACN%.%IDEN%.CustomParameters.TagList]
echo TagList = %FACN%.%IDEN%.POLL_ENABLE
echo TagList = %FACN%.%IDEN%.PAR_AZ
echo []
echo [^&%FACN%.%IDEN%.CTRL.StartupScript]
echo @cron @cron.tab %FACN%.%IDEN%.CTRL.StartupLoadIni 0 0 0
echo @cron @cron.pul %FACN%.%IDEN%.CTRL.StartupLoadIni 3000 1
echo @cron @cron.job %FACN%.%IDEN%.CTRL.StartupLoadIni @DevPostMsg ^&%FACN%.%IDEN%.CTRL @LoadIni
echo @cron @cron.job %FACN%.%IDEN%.CTRL.StartupLoadIni @cron.del %FACN%.%IDEN%.CTRL.StartupLoadIni
echo []
echo [^&%FACN%.%IDEN%.CTRL.FinallyScript]
echo []
echo.
echo [Windows]
echo %FACN%.%IDEN%.CTRL = Circuit_Window 
echo [%FACN%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\wika_ctrl.crc
echo Link sensor POLL_ENABLE       with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ERROR_CNT         with curve %FACN%.%IDEN%.ERROR_CNT   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor POLL_RATE         with curve %FACN%.%IDEN%.POLL_RATE   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor POLL_MEMO         with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_NAME           with tag   %FACN%.%IDEN%.ID_NAME     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_IDN            with tag   %FACN%.%IDEN%.ID_IDN      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_MA            with curve %FACN%.%IDEN%.PAR_MA      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_ME            with curve %FACN%.%IDEN%.PAR_ME      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PZ            with curve %FACN%.%IDEN%.PAR_PZ      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PZMU          with tag   %FACN%.%IDEN%.PAR_PZMU    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PK            with curve %FACN%.%IDEN%.PAR_PK      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PKS           with curve %FACN%.%IDEN%.PAR_PKS     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_KN            with tag   %FACN%.%IDEN%.PAR_KN      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_TW            with curve %FACN%.%IDEN%.PAR_TW      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_AZ            with tag   %FACN%.%IDEN%.PAR_AZ      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @BrowseHelp                                       with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@LoadIni                                  with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@SaveIni                                  with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @OpenConsole                                      with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @MenuToolsOpen                                    with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor DIM+FallBack+Mode with tag   ^&DimSrv.FallBackMode     device ^&%FACN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinShow %FACN%.%IDEN%.CTRL
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=670^|Height=312
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SHOW @WinShow %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HIDE @WinHide %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SELECT @WinSelect %FACN%.%IDEN%.CTRL
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.CTRL.HOME
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.CTRL.HIDE
echo []
echo.
echo [%MAIN_CTRL%]
echo Link sensor %IDEN%.CTRL        with                                 device ^&%MAIN_CTRL%
echo Link sensor %IDEN%.POLL_ENABLE with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.POLL_RATE   with curve %FACN%.%IDEN%.POLL_RATE   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_PZ      with curve %FACN%.%IDEN%.PAR_PZ      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_PZMU    with tag   %FACN%.%IDEN%.PAR_PZMU    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_MA      with curve %FACN%.%IDEN%.PAR_MA      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_ME      with curve %FACN%.%IDEN%.PAR_ME      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_TW      with curve %FACN%.%IDEN%.PAR_TW      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_PKS     with curve %FACN%.%IDEN%.PAR_PKS     device ^&%FACN%.%IDEN%.CTRL
echo []
echo.
echo [%PARAM_PLOT%]
echo CurveList = %FACN%.%IDEN%.PAR_MA
echo CurveList = %FACN%.%IDEN%.PAR_ME
echo CurveList = %FACN%.%IDEN%.PAR_PZ
echo CurveList = %FACN%.%IDEN%.PAR_PK
echo CurveList = %FACN%.%IDEN%.PAR_TW
echo []
echo.
echo [%STATE_PLOT%]
echo CurveList = %FACN%.%IDEN%.POLL_RATE
echo CurveList = %FACN%.%IDEN%.ERROR_CNT
echo CurveList = %FACN%.%IDEN%.PAR_PZM
echo CurveList = %FACN%.%IDEN%.PAR_PZU
echo CurveList = %FACN%.%IDEN%.PAR_PKS
echo CurveList = %FACN%.%IDEN%.PAR_AZ
echo []
echo.
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.PAR_MA
echo CurveList = %FACN%.%IDEN%.PAR_ME
echo CurveList = %FACN%.%IDEN%.PAR_PZ
echo CurveList = %FACN%.%IDEN%.PAR_PK
echo CurveList = %FACN%.%IDEN%.PAR_TW
echo CurveList = %FACN%.%IDEN%.POLL_RATE
echo CurveList = %FACN%.%IDEN%.ERROR_CNT
echo CurveList = %FACN%.%IDEN%.PAR_PZM
echo CurveList = %FACN%.%IDEN%.PAR_PZU
echo CurveList = %FACN%.%IDEN%.PAR_PKS
echo CurveList = %FACN%.%IDEN%.PAR_AZ
echo []
goto :EOF

:WIKA_SIM 
if "%numhdwcfg%" == "0" ( call :WIKA_SIM_ONCE & set /a numhdwcfg+=1 )
set /a ComPair=ComPort+10
echo [DeviceList]
echo ^&%FACN%.%IDEN%.SIM = device software program
echo [^&%FACN%.%IDEN%.SIM]
echo Comment        = Simulation for WIKA D1X sensor %IDEN%.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpNormal
echo ProgramSource  = ..\DaqPas\wika_d1x_drv.pas
echo StartupScript  = [^&%FACN%.%IDEN%.SIM.StartupScript]
echo FinallyScript  = [^&%FACN%.%IDEN%.SIM.FinallyScript]
echo DebugFlags     = 3
echo OpenConsole    = 2
echo Simulator      = 1
echo ComPort        = %ComPair%
echo ComAddr        = %ComAddr%
echo ComTimeOut     = 250
echo ComTimeGap     = 20
echo PollPeriod     = %ComPolling%
echo ModelName      = %ModelName%
echo tagPrefix      = %FACN%.%IDEN%
echo []
echo [^&%FACN%.%IDEN%.SIM.StartupScript]
echo @Simulate az 0
echo []
echo [^&%FACN%.%IDEN%.SIM.FinallyScript]
echo []
echo.
echo [SerialPort-COM%ComPort%]
echo PipeName    = %IDEN%.com%ComPort%.sim
echo PipePolling = 1, tpHighest
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo [SerialPort-COM%ComPair%]
echo PipeName    = .\%IDEN%.com%ComPort%.sim
echo PipePolling = 1, tpHighest
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo.
goto :EOF
:WIKA_SIM_ONCE
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:WIKA_TABCRC
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.CTRL
echo [%IDEN%.CTRL]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Size:28\Style:[Bold]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_6_28_4_aqua_ptmono.bmp %IDEN%
echo Hint = %IDEN%.CTRL: Датчик %IDEN%.
echo []
echo.
echo [Circuit.StartupScript]
echo %IDEN%_poll_enab = 0
echo %IDEN%_poll_rate = 0
echo %IDEN%_poll_norm = 5
echo %IDEN%_poll_gtrz = 0
echo %IDEN%_poll_good = 0
echo []
echo.
set /a YPOS=TABCRC_TOP+75
echo [SensorList]
echo Sensor = %IDEN%.PAR_PZ
echo [%IDEN%.PAR_PZ]
echo Pos = 150, %YPOS%
echo LED = 9, 0, 3, %%9.3f, Name:PT_Mono\Size:18\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_11_18_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_11_18_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_PZ - Давление в Физических Единицах (pressure in physical units).
echo []
echo.
set /a YPOS=TABCRC_TOP+59
echo [SensorList]
echo Sensor = %IDEN%.PAR_PZMU
echo [%IDEN%.PAR_PZMU]
echo Pos = 224, %YPOS%
echo LED = 9, 0, 0, %%s, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_10_10_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_10_10_4_lime_ptmono.bmp
echo Hint = %IDEN%.PAR_PZMU - Метод и Единицы Измерения Давления (measuring method and units).
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.PAR_ME
echo [%IDEN%.PAR_ME]
echo Pos = 310, %YPOS%
echo LED = 7, 0, 3, %%7.5g, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_ME - Верхний Диапазон Давления (upper range).
echo []
echo.
set /a YPOS=TABCRC_TOP+87
echo [SensorList]
echo Sensor = %IDEN%.PAR_MA
echo [%IDEN%.PAR_MA]
echo Pos = 310, %YPOS%
echo LED = 7, 0, 3, %%7.5g, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_MA - Нижний Диапазон Давления (lower range).
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.PAR_PKS
echo [%IDEN%.PAR_PKS]
echo Pos = 380, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good*(1+ne(v,0))
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_silver_ptmono.bmp Offline
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_lime_ptmono.bmp   Normal
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_red_ptmono.bmp    Failure
echo Hint = %IDEN%.PAR_PKS - Статус питания датчика (status of instrument supply voltage).
echo []
echo.
set /a YPOS=TABCRC_TOP+87
echo [SensorList]
echo Sensor = %IDEN%.PAR_TW
echo [%IDEN%.PAR_TW]
echo Pos = 380, %YPOS%
echo LED = 7, 0, 3, %%7.5g, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_10_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_TW - Температура, °С (temperature in Celsius).
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.POLL_RATE
echo [%IDEN%.POLL_RATE]
echo Pos = 455, %YPOS%
echo LED = 2, 0, 0, %%2.0f, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_enab*(1+(%IDEN%_poll_gtrz=gt(%IDEN%_poll_rate=v,0))+(%IDEN%_poll_good=gt(v,%IDEN%_poll_norm)))
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_10_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_10_4_red_ptmono.bmp
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_10_4_yellow_ptmono.bmp
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_10_4_lime_ptmono.bmp
echo Hint = %IDEN%.POLL_RATE - Частота опроса, Герц.
echo []
echo.
set /a YPOS=TABCRC_TOP+80
echo [SensorList]
echo Sensor = %IDEN%.POLL_ENABLE
echo [%IDEN%.POLL_ENABLE]
echo Pos = 455, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:12\Style:[Bold]
echo TagEval(v) = (%IDEN%_poll_enab=isbit(v,0))*(1+%IDEN%_poll_gtrz+%IDEN%_poll_good)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=2)
echo Painter(v) = (glButtonMoveX=2)+(glButtonMoveY=2)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_22_4_silver_ptmono.bmp Опрос
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_22_4_red_ptmono.bmp    Опрос
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_22_4_yellow_ptmono.bmp Опрос
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_22_4_lime_ptmono.bmp   Опрос
echo Hint = %IDEN%.POLL_ENABLE - Разрешение опроса COM порта.
echo []
echo.
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:WIKA_DIS
unix dimcfg ^
  -n section  "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/POLL_ENABLE ^
  -n tag      %FACN%.%IDEN%.POLL_ENABLE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/POLL_RATE ^
  -n tag      %FACN%.%IDEN%.POLL_RATE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ERROR_CNT ^
  -n tag      %FACN%.%IDEN%.ERROR_CNT ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ID_IDN ^
  -n tag      %FACN%.%IDEN%.ID_IDN ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_MA ^
  -n tag      %FACN%.%IDEN%.PAR_MA ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_ME ^
  -n tag      %FACN%.%IDEN%.PAR_ME ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PZ ^
  -n tag      %FACN%.%IDEN%.PAR_PZ ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PZMU ^
  -n tag      %FACN%.%IDEN%.PAR_PZMU ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PZM ^
  -n tag      %FACN%.%IDEN%.PAR_PZM ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PZU ^
  -n tag      %FACN%.%IDEN%.PAR_PZU ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PK ^
  -n tag      %FACN%.%IDEN%.PAR_PK ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PKS ^
  -n tag      %FACN%.%IDEN%.PAR_PKS ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_KN ^
  -n tag      %FACN%.%IDEN%.PAR_KN ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_TW ^
  -n tag      %FACN%.%IDEN%.PAR_TW ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_AZ ^
  -n tag      %FACN%.%IDEN%.PAR_AZ ^
  -n end ^
  -n
goto :EOF

:WIKA_DIC
unix dimcfg ^
  -n section  "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/POLL_ENABLE ^
  -n tag      %FACN%.%IDEN%.POLL_ENABLE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.POLL_ENABLE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/POLL_RATE ^
  -n tag      %FACN%.%IDEN%.POLL_RATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.POLL_RATE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ERROR_CNT ^
  -n tag      %FACN%.%IDEN%.ERROR_CNT ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ERROR_CNT" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ID_IDN ^
  -n tag      %FACN%.%IDEN%.ID_IDN ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ID_IDN" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_MA ^
  -n tag      %FACN%.%IDEN%.PAR_MA ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_MA" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_ME ^
  -n tag      %FACN%.%IDEN%.PAR_ME ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_ME" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PZ ^
  -n tag      %FACN%.%IDEN%.PAR_PZ ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PZ" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PZMU ^
  -n tag      %FACN%.%IDEN%.PAR_PZMU ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PZMU" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PZM ^
  -n tag      %FACN%.%IDEN%.PAR_PZM ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PZM" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PZU ^
  -n tag      %FACN%.%IDEN%.PAR_PZU ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PZU" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PK ^
  -n tag      %FACN%.%IDEN%.PAR_PK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PK" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PKS ^
  -n tag      %FACN%.%IDEN%.PAR_PKS ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PKS" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_KN ^
  -n tag      %FACN%.%IDEN%.PAR_KN ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_KN" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_TW ^
  -n tag      %FACN%.%IDEN%.PAR_TW ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_TW" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_AZ ^
  -n tag      %FACN%.%IDEN%.PAR_AZ ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_AZ" ^
  -n end ^
  -n
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
