---

[[toc]]

---

# Справка по драйверу VMCD

---

Документация:
**[worksheet/](worksheet/)**  
**[ЛЦМК 239000000000-04 РЭ](worksheet/лцмк239000000000-04рэ.djvu)** - Руководство по эксплуатации  

---

## Назначение

**VMCD** - Вакуумметр магниторазрядный цифровой **ВМ-Ц01**

Драйвер разработан с использованием библиотеки 
**[NetLibrary](../../../../crwdaq/resource/daqsite/stdlib/include/_man_netlibrary.htm)** 
и использует клиент **[&ModbusProxy](../../../../crwdaq/resource/daqsite/modbusserver/modbusproxy.htm)** в 
котором реализован протокол приемо-передачи **[MODBUS](../../../../crwdaq/resource/tools/modbus/reference/)**

Вакуумметр является средством технологического контроля и предназначено для преобразования абсолютного давления 
негорючих газов в диапазоне от 1\*10^-2^ до 1\*10^-5^ Па в электрический цифровой сигнал в автоматизированных 
вакуумных системах приборов и установок промышленного, экспериментального и учебного значения.

---

## Интерфейс передачи данных

Вакуумметр предназначен для работы в сети передачи данных RS-485 со следующими параметрами:

- адрес устройства настраиваемый в диапазоне от _1_ до _254_ (по умолчанию установлен адрес _10_);
- скорость передачи данных может иметь следующие значения: _9600, 19200, 38400, 57600_ бод/с (по умолчанию _19200_ бод/с);
- контроль четности - настраиваемый и может иметь следующие значения: _none, even, odd_ (по умолчанию установлен _none_);
- количество бит данных - _8_;
- количество стоповых бит - _1_.

---

## Установка скорости передачи данных и контроля четности

В таблице ниже приведены значения регистра 1000 для хранения параметров последовательного порта
в зависимости от скорости передачи данных и контроля четности.

_Таблица 1_

|             | NONE | ODD | EVEN |
|-------------|------|-----|------|
| 9600 бод/с  | 0    | 8   | 16   |
| 19200 бод/с | 1    | 9   | 17   |
| 38400 бод/с | 2    | 10  | 18   |
| 57600 бод/с | 3    | 11  | 19   |

Значение регистра задается с помощью команды _@PARAM.SERIAL N_, где N значение регистра из таблицы 1.

---

## Порядок работы

При достижении в измеряемом объёме давления ниже _1 Па_ включить источник высокого напряжения, записав 1 в регистр флагов _1000_.

Давление считывается из регистров входа _1000_, _1001_ в формате float.

Необходимо непрерывно контроллировать давление в измеряемом объёме при помощи вакуумметра низкого вакуума (например, 
ВТ-РЦ01) и своевременно отключать источник высокого напряжения при повышении давления выше _1 Па_.

Програмный драйвер вакуумметра автоматически отключает источник высокого напряжения при достижении давления выше _1 Па_.

---

## Команды управления
``` ini
@PARAM.WRITEADDRESS - Запись нового адреса в EEPROM
@ENABLE.HIGHVOLTAG  - Включение режима высокого напряжения. Используется для приёма внешнего сигнала
@PARAM.ADDRESS n    - Установка адреса n вакууметра
@PARAM.SERIAL n     - Установка скорости n передачи данных и контроля четности (см. таблицу 1)
```

---

> **VMCD** developed by DaqGroupTeam, Sarov, Russia, 2023.  
> **CRW-DAQ** Copyright (c) 2001-2023 Alexey Kuryakin <daqgroup@mail.ru>.

---
