 {
 Smart-UPS 420 device driver
 Uses linked Adam_Slot device for RS-232 or RS-485 connection.
 }
program UPS_MAIN;
const                      { Коды adam_status:                                       }
 rs_NotAvail   = 0;        { RS-485 недоступен, вероятно, неверен Adam_Slot_Device   }
 rs_NoRequest  = 1;        { Запрос очищен - можно слать новый запрос Adam_Request   }
 rs_WaitQueue  = 2;        { Запрос послан в слот, ждем его передачи на линию RS     }
 rs_WaitAnswer = 3;        { Запрос послан, передан на линию RS, ждем ответа с линии }
 rs_Answer     = 4;        { Пришел ответ Adam_Get('Answer') на запрос               }
 rs_TimeOut    = 5;        { TimeOut - не пришел ответ в течение заданного срока     }
 SndOk         = 'нажато'; { звук при нажатии кнопки   }
 SndErr        = 'айяйяй'; { звук при ошибке           }
 MaxNumCmd     = 32;       { размер таблицы команд     }
 Debug         = false;    { отладка в консольное окно }
 Console       = false;    { вывод строк на консоль    }
var
 b             : boolean;
 Ok            : boolean;
 errors        : integer;
 error1        : integer;
 error2        : integer;
 SpecChars     : string;
 cmdtab        : record
  cnt          : integer;
  cur          : integer;   
  cmd          : array[0..MaxNumCmd] of char;
  fmt          : array[0..MaxNumCmd] of char;
  ena          : array[0..MaxNumCmd] of char;
  nao          : array[0..MaxNumCmd] of integer;
  ndo          : array[0..MaxNumCmd] of integer;
  tot          : array[0..MaxNumCmd] of integer;
  res          : array[0..MaxNumCmd] of integer;
 end;
 cur           : integer;
 tagOnOff      : integer;
 tag220        : integer;
 tagBat        : integer;
 tagChr        : integer;
 tagTimeOut    : integer;
 tagTest       : integer;
 LastOnOff     : integer;
 Status        : integer;
 SendPrefix    : string;
 RecvPrefix    : string;
 HavePrefix    : boolean;
 UsesCheckSum  : boolean;
 FirstClick    : boolean;
 TimeOfStart   : real;
 {
 Show UPS control window
 }
 procedure ShowUpsControl;
 var s:string; n,t,l,w,h:integer;
 begin
  s:=readini('winUpsControl');
  n:=val(readini('IndexNumber'));
  if (s<>'') and (n>0) then begin
    w:=200;
    h:=310;
    t:=((n-1) div 4)*h;
    l:=((n-1) mod 4)*w+170;
    b:=windraw(s+'|top='+str(t)+'|width='+str(w)+'|height='+str(h)+'|left='+str(l));
  end;
  s:='';
 end;
 {
 Function calculates checksum of string
 **************************************
 }
 function CalcCheckSum(s:string):integer;
 var
  i : integer;
  c : integer;
 begin
  c:=0;
  for i:=1 to length(s) do c:=c+ord(s[i]);
  CalcCheckSum:=c;
 end;
 {
 Function to send command to RS-485
 **********************************
 }
 function SendCmd(cmd:char;tot:integer):boolean;
 begin
  if HavePrefix then begin
   if UsesCheckSum 
   then SendCmd:=Adam_Request(SendPrefix+cmd+hexb(CalcCheckSum(SendPrefix+cmd))+chr(13),tot)
   else SendCmd:=Adam_Request(SendPrefix+cmd+chr(13),tot);
  end else begin
   SendCmd:=Adam_Request(cmd,tot);
  end;
 end;
 {
 Procedure to receive answer from RS-485
 ***************************************
 }
 procedure RecvAns(var Answer:string; var AnsTime:real);
 var
  anspos : integer;
  anslen : integer;
 begin
  {
  Get data from RS-232 or RS-485
  }
  Answer:=Adam_Get('Answer');
  AnsTime:=Adam_ReqTime;
  {
  If uses RS-485, check and remove prefix and checksum
  }
  if HavePrefix then begin
   {
   Find expected answer position and length.
   }
   anspos:=length(RecvPrefix)+1;
   anslen:=length(Answer)-length(RecvPrefix)-2*ord(UsesCheckSum);
   {
   Check for prefix and answer length.
   }
   if (pos(RecvPrefix,Answer)=1) and (anslen>0) then begin
    {
    Test for checksum, if need.
    }
    if UsesCheckSum then begin
     if hexb(CalcCheckSum(copy(Answer,1,length(Answer)-2)))<>copy(Answer,length(Answer)-1,2) then begin
      if Debug then writeln('UPS-420-> invalid checksum:',Answer);
      Answer:='';
     end;
    end;
    {
    If checksum Ok, remove prefix and checksum.
    }
    if length(Answer)>0 then Answer:=copy(Answer,anspos,anslen);
   end else begin
    if Debug then writeln('UPS-420-> invalid answer:',Answer);
    Answer:='';
   end;
  end;
 end;
 {
 Procedure to initialize command table
 *************************************
 }
 procedure SetCmd(cmd,fmt,ena:char; nao,ndo,tot,res:integer);
 begin
  if cmdtab.cnt<MaxNumCmd then begin
   cmdtab.cmd[cmdtab.cnt]:=cmd;
   cmdtab.fmt[cmdtab.cnt]:=fmt;
   cmdtab.ena[cmdtab.cnt]:=ena;
   cmdtab.nao[cmdtab.cnt]:=nao;
   cmdtab.ndo[cmdtab.cnt]:=ndo;
   cmdtab.tot[cmdtab.cnt]:=tot;
   cmdtab.res[cmdtab.cnt]:=res;
   cmdtab.cnt:=cmdtab.cnt+1;
  end;
 end;
 {
 Procedure calls when RS-485 is not available
 ********************************************
 }
 procedure OnNotAvail;
 begin
  b:=fixError(error1);
  if Debug then writeln('RS-485 is not available!');
 end;
 {
 Procedure uses to send request to RS-485 line
 *********************************************
 }
 procedure OnNoRequest;
 var
  i   : integer;
  cmd : char;
  tot : integer;
 begin
  { 
  Pass disabled commands... 
  }
  i:=0;
  while (i<MaxNumCmd) and (cmdtab.ena[cmdtab.cur]<>'+') do begin
   cmdtab.cur:=cmdtab.cur+1;
   if cmdtab.cur>=cmdtab.cnt then cmdtab.cur:=0;
   i:=i+1;
  end;
  { 
  If has command to send, try to send this command...
  }
  if cmdtab.ena[cmdtab.cur]='+' then begin
   cur:=cmdtab.cur;
   cmd:=cmdtab.cmd[cur];
   tot:=cmdtab.tot[cur];
   if SendCmd(cmd,tot) then begin
    if Debug then writeln('UPS-420-> request:',cmd);
    cmdtab.cur:=cmdtab.cur+1;
    if cmdtab.cur>=cmdtab.cnt then cmdtab.cur:=0;
   end else begin
    b:=fixerror(error1);
    if Debug then writeln('UPS-420-> could not raise request:',cmd);
   end;
  end;
 end;
 {
 Procedure calls when wait RS-485 queue...
 *****************************************
 }
 procedure OnWaitQueue;
 begin
  if Debug then writeln('UPS-420-> wait queue.');
 end;
 {
 Procedure calls when wait RS-485 answer after request was sent
 **************************************************************
 }
 procedure OnWaitAnswer;
 begin
  if Debug then writeln('UPS-420-> wait answer.');
 end;
 {
 Procedure calls when RS-485 answer received
 *******************************************
 }
 procedure OnAnswer;
 var
  c       : char;
  r       : real;
  i       : integer; 
  cmd     : char;
  fmt     : char;
  nao     : integer;
  ndo     : integer;
  ans     : string;
  Answer  : string;
  AnsTime : real;
 begin
  {
  Read answer string and time, pass special chars...
  }
  ans:='';
  Answer:='';
  RecvAns(Answer,AnsTime);
  for i:=1 to length(Answer) do begin
   c:=Answer[i];
   if pos(c,SpecChars)=0 then ans:=ans+c else begin
    { 
    Special chars are:
     LF line feed 
     !  battery on 
     $  220 V on 
     ?  UPS button on
     %  low battery
     +  15 % battery
     |  accept edit params
    In current version ignore special chars, because has all information
    when polling status.
    }
   end;
  end;
  if Debug then writeln('UPS-420-> answer:'+Answer);
  Answer:='';
  {
  Disable command if reset flag bit 0 raised, then read command settings...
  }
  if iand(1,cmdtab.res[cur])>0 then cmdtab.ena[cur]:='-';
  cmd:=cmdtab.cmd[cur];
  fmt:=cmdtab.fmt[cur];
  nao:=cmdtab.nao[cur];
  ndo:=cmdtab.ndo[cur];
  {
  Handle commands with float point format...
  }
  if fmt='f' then begin
   r:=rval(ans);
   if isnan(r) then b:=fixerror(error2) else begin
    if nao>=0 then b:=putao(nao,AnsTime,r);
    if ndo>=0 then b:=putdo(ndo,AnsTime,r);
   end;
  end;
  {
  Handle commands with hexadecimal format, analize status command Q...
  }
  if fmt='h' then begin
   r:=rval('$'+ans);
   if isnan(r) then b:=fixerror(error2) else begin
    if nao>=0 then b:=putao(nao,AnsTime,r);
    if ndo>=0 then b:=putdo(ndo,AnsTime,r);
    if cmd='Q' then begin
     b:=isettag(tag220,ord(isbit(r,3)));
     b:=isettag(tagBat,ord(isbit(r,4)));
     b:=isettag(tagChr,ord(isbit(r,6)));
     if FirstClick then begin
      FirstClick:=false;
      if igettag(tag220)+igettag(tagBat)>0 then begin
       b:=isettag(tagOnOff,1);
       LastOnOff:=igettag(tagOnOff);
      end;
     end;
    end;
   end;
  end;
  {
  Handle commands with string format...
  }
  if fmt='S' then begin
   if Console then writeln(ans);
  end;
  {
  It's Ok, reset TimeOut indicator and raise new request...
  }
  b:=isettag(tagTimeOut,0);
  ans:='';
  OnNoRequest;
 end;
 {
 Procedure calls on TimeOut
 **************************
 }
 procedure OnTimeOut;
 begin
  {
  Fix timeout, disable command if reset flag bit 1 raised, then raise next request.
  }
  b:=isettag(tagTimeOut,1);
  if Debug then writeln('UPS-420-> timeout.');
  if iand(2,cmdtab.res[cur])<>0 then cmdtab.ena[cur]:='-';
  OnNoRequest;
 end;
 {
 Procedure to fix error
 **********************
 }
 procedure ErrorFound;
 begin
  errors:=errors+1;
 end;
 {
 Tag initialization and test
 ***************************
 }
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 INIFIALIZATION
 **************
 }
 if runcount=1 then begin
  errors:=0;
  error1:=registererr('FATAL ERROR IN '+devname);
  error2:=registererr('I/O ERROR IN '+devname);
  {
  Initialize tags
  }
  InitTag( tagOnOff,   readini('tagOnOff'),   1);
  InitTag( tag220,     readini('tag220'),     1);
  InitTag( tagBat,     readini('tagBat'),     1);
  InitTag( tagChr,     readini('tagChr'),     1);
  InitTag( tagTimeOut, readini('tagTimeOut'), 1);
  InitTag( tagTest,    readini('tagTest'),    1);
  b:=isettag(tagOnOff,0);
  b:=isettag(tag220,0);
  b:=isettag(tagBat,0);
  b:=isettag(tagChr,0);
  b:=isettag(tagTimeOut,0);
  b:=isettag(tagTest,0);
  {
  Initialize variables and I/O files
  }
  LastOnOff:=0;
  SpecChars:=chr(10)+'!$?%+|';
  SendPrefix:=readini('SendPrefix');
  RecvPrefix:=readini('RecvPrefix');
  HavePrefix:=(length(SendPrefix)>0) and (length(RecvPrefix)>0);
  UsesCheckSum:=(val(readini('UsesCheckSum'))>0);
  if reset('')<>0 then ErrorFound;
  if rewrite('con:')<>0 then ErrorFound;
  if ioresult<>0 then ErrorFound;
  FirstClick:=true;
  {
  Setup UPS command set table
  }
  cmdtab.cnt:=0;
  cmdtab.cur:=0;
  SetCmd( 'Y',     's', '+', -1, -1, 200,  0 ); { 0  - Разрешение RS-232 }
  SetCmd( chr(1),  'S', '+', -1, -1, 200,  1 ); { 1  - Чтение имени UPS  }
  SetCmd( 'z',     's', '+', -1, -1, 200,  1 ); { 2  - Заводские уставки }
  SetCmd( chr(14), 's', '-', -1, -1, 1500, 3 ); { 3  - 1-я ком. вкл. UPS }
  SetCmd( chr(14), 's', '-', -1, -1, 200,  3 ); { 4  - 2-я ком. вкл. UPS }
  SetCmd( 'Z',     's', '-', -1, -1, 1500, 3 ); { 5  - 1-я ком. выкл.UPS }
  SetCmd( 'Z',     's', '-', -1, -1, 200,  3 ); { 6  - 2-я ком. выкл.UPS }
  SetCmd( 'A',     'S', '-', -1, -1, 200,  3 ); { 7  - Тест индикаторов  }
  SetCmd( 'W',     'S', '-', -1, -1, 200,  3 ); { 8  - Самотестирование  }
  SetCmd( 'Q',     'h', '+', -1, -1, 200,  0 ); { 9  - Чтение статуса    }
  SetCmd( 'L',     'f', '+',  0, -1, 200,  0 ); { 10 - Напряж сети 220 V }
  SetCmd( 'O',     'f', '+',  1, -1, 200,  0 ); { 11 - Напряж выхода UPS }
  SetCmd( 'Q',     'h', '+', -1, -1, 200,  0 ); { 12 - Чтение статуса    }
  SetCmd( 'o',     'f', '+',  2, -1, 200,  0 ); { 13 - Напряж выхода BAT }
  SetCmd( 'B',     'f', '+',  3, -1, 200,  0 ); { 14 - Напряж батареи,DC }
  SetCmd( 'Q',     'h', '+', -1, -1, 200,  0 ); { 15 - Чтение статуса    }
  SetCmd( 'f',     'f', '+',  4, -1, 200,  0 ); { 16 - Разряд батареи %  }
  SetCmd( 'P',     'f', '+',  5, -1, 200,  0 ); { 17 - Нагрузка в % макс }
  SetCmd( 'Q',     'h', '+', -1, -1, 200,  0 ); { 18 - Чтение статуса    }
  SetCmd( 'F',     'f', '+',  6, -1, 200,  0 ); { 19 - Частота сети Гц   }
  {
  Show UPS control window, fix time of start
  }
  ShowUpsControl;
  TimeOfStart:=msecnow;
  {
  It's Ok?
  }
  Ok:=(errors=0);
  if not Ok then b:=fixerror(Error1);
 end else
 {
 FINALIZATION

 ************
 }
 if isinf(runcount) then begin
  b:=isettag(tagOnOff,0);
  b:=isettag(tag220,0);
  b:=isettag(tagBat,0);
  b:=isettag(tagChr,0);
  b:=isettag(tagTimeOut,0);
  b:=isettag(tagTest,0);
  LastOnOff:=0;
  SpecChars:='';
  SendPrefix:='';
  RecvPrefix:='';
 end else 
 {
 MAIN LOOP
 *********
 }
 if Ok and (msecnow-TimeOfStart>2000) then begin
  { 
  Handle RS-485 requests...
  }
  Status:=Adam_Status;
  if (Status<rs_NotAvail) or (Status>rs_TimeOut) then begin
   b:=FixError(error1);
   if Debug then writeln('Invalid status value!');
  end else begin
   case Status of
    rs_NotAvail   : OnNotAvail;
    rs_NoRequest  : OnNoRequest;
    rs_WaitQueue  : OnWaitQueue;
    rs_WaitAnswer : OnWaitAnswer;
    rs_Answer     : OnAnswer;
    rs_TimeOut    : OnTimeOut;
   end;
  end;
  {
  When OnOff button pressed, enable ON commands ^N,^N or OFF commands Z,Z
  }
  if LastOnOff<>igettag(tagOnOff) then begin
   if igettag(tagOnOff)>0 then begin
    cmdtab.ena[3]:='+';
    cmdtab.ena[4]:='+';
   end else begin
    cmdtab.ena[5]:='+';
    cmdtab.ena[6]:='+';
   end;
   LastOnOff:=igettag(tagOnOff);
  end;
  {
  When Test button pressed, enable test commands A,W
  }
  if igettag(tagTest)>0 then begin
   cmdtab.ena[7]:='+';
   cmdtab.ena[8]:='+';
   b:=isettag(tagTest,0);
  end;
  {
  Handle buttons click...
  }
  if clickbutton>0 then begin
   if clicktag=tagOnOff then begin
    b:=isettag(tagOnOff,ord(igettag(tagOnOff)=0));
    b:=voice(SndOk);
   end;
   if clicktag=tagTest then begin
    b:=isettag(tagTest,ord(igettag(tagTest)=0));
    b:=voice(SndOk);
   end;
  end;
 end;
end.
