program TRF_CTRL;  { TRITON FORMULATORS CONTROL }
const
 snd_Click   = 'Click'; { Sound on button click            }
 snd_Fails   = 'Fails'; { Sound on operation failure       }
 snd_Cancel  = 'БУЛЬК'; { Sound on operation cancel        }
 snd_Error   = 'ОШИБКА';{ Sound on operation error         }
 snd_Ok      = 'ЧИК';   { Sound on operation Ok            }
 dfTrouble   = 1;       { DebugFlags - Trouble             }
 dfSuccess   = 2;       { DebugFlags - Success             }
 dfViewExp   = 4;       { DebugFlags - ViewExp             }
 dfViewImp   = 8;       { DebugFlags - ViewImp             }
 P2C         = true;    { Pressure to current              }
 C2P         = false;   { CurrentToPressure                }
 nfClear     = 0;
 nfOk        = 1;
 nfCancel    = 2;
 SysConsole  = 'ГЛАВНАЯ КОНСОЛЬ';
 dlgF1       = 'Формулятор газовой накачки';
 dlgF2       = 'Формулятор напуска смеси';
 dlgF3       = 'Формулятор роспуска смеси';
 Imax        = 19.7;
 T0K         = 273.15;
 V1          = 0.06986;
 V2          = 1.99034;
 V3          = 0.43181;
var
 b                 : boolean;
 Ok                : boolean; 
 i                 : integer;
 errors            : integer;
 errorcode         : integer;
 tagF1             : record Notify, Vl, Vx, Choice, Temp, Vt, Pt, Ct : integer; end;
 tagF2             : record Notify, Vl, Vx, Choice, Temp, Vt, Pt, Ct, Vj, Vf, Pj : integer; end;
 tagF3             : record Notify, Vl, Vx, Choice, Temp, Vt, Pt, Ct, Vm, Tm : integer; end;
 r, c, a, vF1, vF2, vF3, vj, vf, vm, Volume, Current, Pressure, Curr : real;
 {
 Convert SAPFIR current (mA) to pressure (Bar) and back
 ******************************************************
 }
 procedure Sapfir(var Pressure,Current:real; PressureToCurrent:boolean);
 begin
  if PressureToCurrent then Current:=calibr(0, Pressure, 0) else Pressure:=calibr(1, Current, 0);
 end;
 {
 Write message when current has invalid value
 ********************************************
 }
 procedure InvalidCurrent(Current:real; dlg:string);
 var b:boolean;
 begin
  writeln('СООБЩЕНИЕ ОТ "',dlg,'":');
  writeln(' Слишком большой ток САПФИРА!');
  writeln(' I    =',Current:7:3,' мА.');
  writeln(' Imax =',Imax:7:3,' мА.');
  b:=voice(snd_Error);
  b:=winselect(SysConsole);
  b:=winhide(dlg);
 end;
 {
 Show TRF.CTRL window
 }
 procedure ShowTrfCtrl;
 var win:String;
 begin
  win:=sGetTag(findtag('TRF.MainWin'));
  if Length(win)>0 then begin
   b:=winshow(win);
   b:=windraw(win+'|left=167|top=317|width=265|height=160');
   b:=windraw(win+'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll');
   b:=winselect(win);
  end;
  win:='';
 end;
 {
 Test and init tag
 *****************
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 *****************************
 Действия при старте программы
 *****************************
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  if rewrite('CON:')<>0 then errors:=errors+1;
  ShowTrfCtrl;
  {
  Инициализация тегов
  *******************
  }
  InitTag( tagF1.Notify, 'TRF.F1.Notify', 1); 	
  InitTag( tagF1.Vl,     'TRF.F1.Vl',     1);
  InitTag( tagF1.Vx,     'TRF.F1.Vx',     2);
  InitTag( tagF1.Vt,     'TRF.F1.Vt',     2);
  InitTag( tagF1.Choice, 'TRF.F1.Choice', 1);
  InitTag( tagF1.Pt,     'TRF.F1.Pt',     2);
  InitTag( tagF1.Temp,   'TRF.F1.Temp',   2);
  InitTag( tagF1.Ct,     'TRF.F1.Ct',     2);
  InitTag( tagF2.Notify, 'TRF.F2.Notify', 1);
  InitTag( tagF2.Vl,     'TRF.F2.Vl',     1);
  InitTag( tagF2.Vx,     'TRF.F2.Vx',     2);
  InitTag( tagF2.Vj,     'TRF.F2.Vj',     2);
  InitTag( tagF2.Vf,     'TRF.F2.Vf',     2);
  InitTag( tagF2.Vt,     'TRF.F2.Vt',     2);
  InitTag( tagF2.Choice, 'TRF.F2.Choice', 1);
  InitTag( tagF2.Pj,     'TRF.F2.Pj',     2);
  InitTag( tagF2.Pt,     'TRF.F2.Pt',     2); 
  InitTag( tagF2.Temp,   'TRF.F2.Temp',   2);
  InitTag( tagF2.Ct,     'TRF.F2.Ct',     2);
  InitTag( tagF3.Notify, 'TRF.F3.Notify', 1);
  InitTag( tagF3.Choice, 'TRF.F3.Choice', 1); 
  InitTag( tagF3.Vl,     'TRF.F3.Vl',     1);
  InitTag( tagF3.Vx,     'TRF.F3.Vx',     2);
  InitTag( tagF3.Vm,     'TRF.F3.Vm',     2);
  InitTag( tagF3.Tm,     'TRF.F3.Tm',     2);
  InitTag( tagF3.Temp,   'TRF.F3.Temp',   2);
  InitTag( tagF3.Vt,     'TRF.F3.Vt',     2);
  InitTag( tagF3.Pt,     'TRF.F3.Pt',     2); 
  InitTag( tagF3.Ct,     'TRF.F3.Ct',     2);
  b:=winhide(sgettag(findtag('HDT.MainWin')));
  if(errors<>0) then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 *******************************
 Действия при останове программы
 *******************************
 }
 if isinf(runcount) then begin
  i:=rewrite('');
 end else
 {
 *********************************
 Действия в цикле опроса программы
 *********************************
 }
 if Ok then begin
  {
  Формулятор 1
  ************
  }
  if igettag(tagF1.Notify)=nfOk then begin
   b:=voice(snd_Ok);
   vF1:=0;
   if isbit(igettag(tagF1.Vl),0) then vF1:=vF1+V1;
   if isbit(igettag(tagF1.Vl),1) then vF1:=vF1+V2;
   if isbit(igettag(tagF1.Vl),2) then vF1:=vF1+V3;
   if isbit(igettag(tagF1.Vl),3) then vF1:=vF1+rgettag(tagF1.Vx);
   if igettag(tagF1.Choice)=0 then begin
    Pressure:=(rgettag(tagF1.Vt)*(rgettag(tagF1.Temp)+T0K))/(vF1*T0K);
    b:=rsettag(tagF1.Pt, Pressure);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF1.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF1);
   end;
   if igettag(tagF1.Choice)=1 then begin   
    Volume:=vF1*rgettag(tagF1.Pt)*T0K/(rgettag(tagF1.Temp)+T0K);
    b:=rsettag(tagF1.Vt, Volume);
    Pressure:=rgettag(tagF1.Pt);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF1.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF1);
   end;
   if igettag(tagF1.Choice)=2 then begin
    Current:=rgettag(tagF1.Ct);
    if Current>Imax then InvalidCurrent(Current, dlgF1); 
    Sapfir(Pressure,Current,C2P);
    b:=rsettag(tagF1.Pt, Pressure);
    Volume:=vF1*rgettag(tagF1.Pt)*T0K/(rgettag(tagF1.Temp)+T0K);
    b:=rsettag(tagF1.Vt, Volume);
   end;
   r:=devmsg('&TRF.F1 Confirm='+str(nfCancel));
   b:=isettag(tagF1.Notify,nfClear);
  end;
  if igettag(tagF1.Notify)=nfCancel then begin
   b:=voice(snd_Cancel);
   b:=isettag(tagF1.Notify,nfClear);
   b:=winhide(dlgF1);
  end;
  {
  Формулятор 2
  ************
  }
  if igettag(tagF2.Notify)=nfOk then begin
   b:=voice(snd_Ok);
   vj:=0;
   vf:=0;
   vF2:=0;
   if isbit(igettag(tagF2.Vl),0) then vF2:=vF2+V1;
   if isbit(igettag(tagF2.Vl),1) then vF2:=vF2+V2;
   if isbit(igettag(tagF2.Vl),2) then vF2:=vF2+V3;
   if isbit(igettag(tagF2.Vl),3) then vF2:=vF2+rgettag(tagF2.Vx);
   if isbit(igettag(tagF2.Vl),4) then vj:=rgettag(tagF2.Vj);
   if isbit(igettag(tagF2.Vl),5) then vf:=rgettag(tagF2.Vf); 
   if igettag(tagF2.Choice)=0 then begin
    Pressure:=((rgettag(tagF2.Vt)+vf)*(rgettag(tagF2.Temp)+T0K)+vj*rgettag(tagF2.Pj)*T0K)/(vF2*T0K);
    b:=rsettag(tagF2.Pt, Pressure);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF2.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF2); 
   end;
   if igettag(tagF2.Choice)=1 then begin   
    Volume:=((vF2*rgettag(tagF2.Pt)-vj*rgettag(tagF2.Pj))*T0K/(rgettag(tagF2.Temp)+T0K))-vf;
    b:=rsettag(tagF2.Vt, Volume);
    Pressure:=rgettag(tagF2.Pt);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF2.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF2);
   end;
   if igettag(tagF2.Choice)=2 then begin
    Current:=rgettag(tagF2.Ct);
    if Current>Imax then InvalidCurrent(Current, dlgF2);
    Sapfir(Pressure,Current,C2P);
    b:=rsettag(tagF2.Pt, Pressure);
    Volume:=((vF2*rgettag(tagF2.Pt)-vj*rgettag(tagF2.Pj))*T0K/(rgettag(tagF2.Temp)+T0K))-vf;
    b:=rsettag(tagF2.Vt, Volume);
   end;  
   r:=devmsg('&TRF.F2 Confirm='+str(nfCancel));
   b:=isettag(tagF2.Notify,nfClear);
  end;
  if igettag(tagF2.Notify)=nfCancel then begin
   b:=voice(snd_Cancel);
   b:=isettag(tagF2.Notify,nfClear);
   b:=winhide(dlgF2);
  end;
  {
  Формулятор 3
  ************
  }
  if igettag(tagF3.Notify)=nfOk then begin
   b:=voice(snd_Ok);
   vF3:=0;
   vm:=0;
   if isbit(igettag(tagF3.Vl), 0) then vF3:=vF3+V1;
   if isbit(igettag(tagF3.Vl), 1) then vF3:=vF3+V2;
   if isbit(igettag(tagF3.Vl), 2) then vF3:=vF3+V3;
   if isbit(igettag(tagF3.Vl), 3) then vF3:=vF3+rgettag(tagF3.Vx);
   if isbit(igettag(tagF3.Vl), 4) then vm:=rgettag(tagF3.Vm);
   if igettag(tagF3.Choice)=0 then begin
    a:=rgettag(tagF3.Vt)*(rgettag(tagF3.Temp)+T0K)*(rgettag(tagF3.Tm)+T0K);
    c:=(vF3*(rgettag(tagF3.Tm)+T0K)+vm*(rgettag(tagF3.Temp)+T0K))*T0K;
    Pressure:=a/c;
    b:=rsettag(tagF3.Pt, Pressure);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF3.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF3); 
   end;
   if igettag(tagF3.Choice)=1 then begin   
    Volume:=vF3*rgettag(tagF3.Pt)*T0K/(rgettag(tagF3.Temp)+T0K)+vm*rgettag(tagF3.Pt)*T0K/(rgettag(tagF3.Tm)+T0K);
    b:=rsettag(tagF3.Vt, Volume);
    Pressure:=rgettag(tagF3.Pt);
    Sapfir(Pressure,Current,P2C);
    b:=rsettag(tagF3.Ct, Current);
    if Current>Imax then InvalidCurrent(Current, dlgF3);
   end;
   if igettag(tagF3.Choice)=2 then begin
    Current:=rgettag(tagF3.Ct);
    if Current>Imax then InvalidCurrent(Current, dlgF3);
    Sapfir(Pressure,Current,C2P);
    b:=rsettag(tagF3.Pt, Pressure);
    Volume:=vF3*rgettag(tagF3.Pt)*T0K/(rgettag(tagF3.Temp)+T0K)+vm*rgettag(tagF3.Pt)*T0K/(rgettag(tagF3.Tm)+T0K);
    b:=rsettag(tagF3.Vt, Volume);
   end;
   r:=devmsg('&TRF.F3 Confirm='+str(nfCancel));
   b:=isettag(tagF3.Notify,nfClear);
  end;
  if igettag(tagF3.Notify)=nfCancel then begin 
   b:=voice(snd_Cancel);
   b:=isettag(tagF3.Notify,0);
   b:=winhide(dlgF3);
  end;
  {
  Действия при нажатии кнопок
  ***************************
  }
  if clickbutton=1 then begin
   for i:=1 to 3 do
   if clicksensor='TRF.F'+str(i)+'.BTN' then begin
    b:=voice(snd_Click);
    b:=action('&TRF.F'+str(i));
   end;								
   if clicksensor='TRF.F4.BTN' then begin
    b:=voice(snd_Click);
    b:=winshow(sgettag(findtag('HDT.MainWin')));
    b:=winselect(sgettag(findtag('HDT.MainWin')));
   end;								
  end;
 end;
end.
