 {
 ***********************************************************************
 Daq Pascal application program for test and debug purposes.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Test n m      - Start test number n; m iterations.
|       0        - Stop testing.
|       1        - devSend ping/pong with empty data.
|       2        - devSend ping/pong with @demo data.
|       3        - devMsg  ping/pong with empty data.
|       4        - devMsg  ping/pong with @demo data.
|       5        - devPost ping/pong with empty data.
|       6        - devPost ping/pong with @demo data.
| @Demo msg      - Just demo message.
|********************************************************
[]
 }
program Demo_TestSend;           { Test devSend, devMsg, devPost    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 TestNumber : Integer;           { Number of test to run            }
 TestCounts : Integer;           { Number of counts to send loop    }
 devSend1   : Integer;           { &TEST_SEND1                      }
 devSend2   : Integer;           { &TEST_SEND2                      }
 cmd_Test   : Integer;           { @Test                            }
 cmd_Demo   : Integer;           { @Demo                            }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Find pair device to send message.
 }
 function devPair:Integer;
 begin
  if devMySelf=devSend1 then devPair:=devSend2 else devPair:=devSend1;
 end;
 {
 Test devSend with empty string.
 }
 procedure TestSendEmpty(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devSend(devPair,''));
  until n<1;
 end;
 {
 Test devSend with some data.
 }
 procedure TestSendRunCount(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devSend(devPair,'@Demo '+DevName+' RunCount '+Str(RunCount)+CRLF));
  until n<1;
 end;
 {
 Test devMsg with empty string.
 }
 procedure TestMsgEmpty(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devMsg(RefInfo(devPair,'Name')));
  until n<1;
 end;
 {
 Test devMsg with some data.
 }
 procedure TestMsgRunCount(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devMsg(RefInfo(devPair,'Name')+' @Demo '+DevName+' RunCount '+Str(RunCount)+CRLF));
  until n<1;
 end;
 {
 Test devPost with empty string.
 }
 procedure TestPostEmpty(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devPost(devPair,''));
  until n<1;
 end;
 {
 Test devPost with some data.
 }
 procedure TestPostRunCount(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devPost(devPair,'@Demo '+DevName+' RunCount '+Str(RunCount)+CRLF));
  until n<1;
 end;
 {
 Test devSendMsg with empty string.
 }
 procedure TestSendMsgEmpty(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devSendMsg(RefInfo(devPair,'Name')));
  until n<1;
 end;
 {
 Test devSendMsg with some data.
 }
 procedure TestSendMsgRunCount(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devSendMsg(RefInfo(devPair,'Name')+' @Demo '+DevName+' RunCount '+Str(RunCount)+CRLF));
  until n<1;
 end;
 {
 Test devPostMsg with empty string.
 }
 procedure TestPostMsgEmpty(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devPostMsg(RefInfo(devPair,'Name')));
  until n<1;
 end;
 {
 Test devPostMsg with some data.
 }
 procedure TestPostMsgRunCount(n:Integer);
 begin
  repeat
   n:=n-1;
   rNul(devPostMsg(RefInfo(devPair,'Name')+' @Demo '+DevName+' RunCount '+Str(RunCount)+CRLF));
  until n<1;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitDevice(devSend1,'&Test_Send1',1);
  InitDevice(devSend2,'&Test_Send2',1);
  cmd_Test := RegisterStdInCmd('@Test','');
  cmd_Demo := RegisterStdInCmd('@Demo','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if TestNumber=1  then TestSendEmpty(TestCounts);
  if TestNumber=2  then TestSendRunCount(TestCounts);
  if TestNumber=3  then TestMsgEmpty(TestCounts);
  if TestNumber=4  then TestMsgRunCount(TestCounts);
  if TestNumber=5  then TestPostEmpty(TestCounts);
  if TestNumber=6  then TestPostRunCount(TestCounts);
  if TestNumber=7  then TestSendMsgEmpty(TestCounts);
  if TestNumber=8  then TestSendMsgRunCount(TestCounts);
  if TestNumber=9  then TestPostMsgEmpty(TestCounts);
  if TestNumber=10 then TestPostMsgRunCount(TestCounts);
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; i,n:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Demo &Test_Send1 RunCount 234
   }
   if (cmdid=cmd_Demo) then begin
    r:=rValDef(ExtractWord(3,arg),0);
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+arg);
    Data:='';
   end else
   {
   @Test 1 10
   }
   if (cmdid=cmd_Test) then begin
    i:=iEvalDef(ExtractWord(1,arg),0);
    n:=iValDef(ExtractWord(2,arg),1);
    if (i<>TestNumber) or (n<>TestCounts)
    then rNul(devPost(devPair,Data+CRLF));
    TestNumber:=i; TestCounts:=n;
    Success(cmd+'='+Str(TestNumber)+' '+Str(TestCounts));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
