 {
 ***********************************************************************
 Daq Pascal application program for test and debug purposes.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Test n        - Run test number n, for demo and debug.
|********************************************************
[]
 }
program Demo_TestBench;          { Test bench for demo and debug    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_DbLibrary}             { Include all DbLibrary constants  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_DbLibrary}             { Include all DbLibrary variables  }
 TestNumber : Integer;           { Number of test to run            }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_DbLibrary}             { Include all DbLibrary functions  }

 {
 Test -1.
 Generate fatal bug: integer division by zero.
 Uses to test error handling.
 }
 procedure TestMinus1;
 begin
  Writeln(1 div 0);
 end;
 {
 Test -2.
 Generate fatal bug: array index out of range.
 Uses to test error handling.
 }
 procedure TestMinus2;
 var x:array[1..2] of Integer;
 begin
  Writeln(x[0]);
 end;
 {
 Test -3.
 Generate fatal bug: infinite loop (hanging) with low stress.
 Uses to test error handling.
 }
 procedure TestMinus3;
 begin
  while True do bNul(Sleep(1));
 end;
 {
 Test -4.
 Generate fatal bug: infinite loop (hanging) with high stress.
 Uses to test error handling.
 }
 procedure TestMinus4;
 begin
  while True do bNul(false);
 end;
 {
 Test 1.
 VDPM operations benchmark, i.e. measure number of VDPM operations per Daq Pascal operations.
 VDPM is Virtual Dad Pascal Machine. Note that each simple VDPM P-code operation takes about
 20 native CPU operations. For example, for CPU 1.2 GHz it takes about 17 ns of real time.
 Of course, this value depend on operation: hard operations takes more CPU.
 }
 procedure Nothing; begin end; // Just to measure time of call.
 procedure Test1;
 var op1,op2,opa,opb,opc:Real; b:Boolean;
 begin
  b:=true;
  writeln;
  writeln(GetDateTime(mSecNow));
  writeln('VDPM benchmark: how many Daq Pascal opeartions it takes.');
  {}
  op1:=vdpm_opcount;
  op2:=vdpm_opcount;
  opa:=op2-op1;
  writeln('Value Assignment  = ',opa:1:0);
  {}
  op1:=vdpm_opcount;
  Nothing;
  op2:=vdpm_opcount;
  opc:=op2-op1-opa;
  writeln('Call Procedure    = ',opc:1:0);
  {}
  op1:=vdpm_opcount;
  bNul(b);
  op2:=vdpm_opcount;
  opb:=op2-op1-opa;
  writeln('Call Procedure(x) = ',opb:1:0);
  {}
  op1:=vdpm_opcount;
  if b then Nothing;
  op2:=vdpm_opcount;
  writeln('If ... Then       = ',(op2-op1-opc-opa):1:0);
 end;
 {
 Test 2.
 Call of msecnow.
 }
 procedure Test2;
 var i,n:Integer; t,dt:Real;
 begin
  write(GetDateTime(mSecNow)+': ');
  //n:=1; dt:=mSecNow; while mSecNow-dt<200 do n:=n+1;
  n:=1000*1000*10; dt:=mSecNow; for i:=1 to n do t:=mSecNow;
  dt:=mSecNow-dt;
  writeln('mSecNow takes ',dt*1e6/n:1:3,' ns per call');
 end; 
 {
 Test 3.
 Check Command Line parsing functions.
 }
 procedure Test3;
  procedure Test(cmdline:String);
  var args,arg,del:String; parnum,optnum:Integer;
  begin
   del:=WordDelims(' '+CRLF);
   parnum:=0; optnum:=0;
   args:=cmdline; arg:='';
   writeln('Process Command Line: ',args);
   while not IsEmptyStr(args) do begin
    arg:=ExtractFirstParam(args,QuoteMark);
    args:=SkipFirstParam(args,QuoteMark);
    if IsOption(arg,'') then begin
     optnum:=optnum+1;
     writeln(' Found option[',optnum:1,']: ',arg);
     if IsOption(arg,'-h,--help')  then writeln(' Option is --help');
     if IsOption(arg,'--verbose')  then writeln(' Option is --verbose');
     if IsOption(arg,'--filename') then writeln(' Option is --filename with param '+GetOptionValue(arg));
    end else begin
     writeln(' Found parameter[',parnum:1,']: '+AnsiQuotedIfNeed(arg,QuoteMark));
     parnum:=parnum+1;
    end;
   end;
   del:=WordDelims(del);
   args:=''; arg:=''; del:='';
  end;
 begin
  writeln;
  writeln;
  Test('demo /h');
  Test('demo --help');
  Test('demo --version');
  Test('demo --verbose --filename=note.txt "Test is OK" "Life is good" Bye!');
 end;
 {
 Test 4.
 Check IsLexeme parsing.
 }
 procedure Test4;
 var i,n,nerr,rex:Integer; ms:Real; b:Boolean; arg:String;
  procedure Timing(who:String; nn:Integer);
  begin
   n:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/n:1:3,' mks,  ',ms:1:0,' ms');
   end;
  end;
  procedure CheckLex(arg:String; typ:Integer; expect:Boolean);
  var cond:Boolean;
  begin
   cond:=IsLexeme(arg,typ);
   if (ord(cond)=ord(expect))
   then writeln('Check ',arg:20,' Good ',cond:5,' ',expect:5)
   else writeln('Check ',arg:20,' FAIL ',cond:5,' ',expect:5);
   if (ord(cond)<>ord(expect)) then nerr:=nerr+1;
  end;
 begin
  arg:=''; nerr:=0;
  writeln('Test4: check IsLexeme.');
  writeln(IsLexeme('',lex_name):6, IsLexeme(' ',lex_name):6,IsLexeme('x',lex_name):6,IsLexeme(CRLF,lex_name):6);
  CheckLex('',      lex_Ansi,   false); // Empty string
  CheckLex('Ansi!', lex_Ansi,   true); // Valid string
  CheckLex('УТФ8',  lex_utf8,   true); // Valid utf8 string
  CheckLex(Copy('УТФ8',2), lex_utf8,   false); // Invalid utf8 string
  CheckLex('',      lex_Name,   false); // Invalid Name - empty string
  CheckLex(' Var',  lex_Name,   false); // Invalid Name - leading space
  CheckLex('1var',  lex_Name,   false); // Invalid Name - start with digit
  CheckLex('Var1',  lex_Name,   true);  // Valid   Name
  CheckLex('_V1x',  lex_Name,   true);  // Valid   Name
  CheckLex('12345', lex_iParam, true);  // Valid   Integer
  CheckLex(' 123 ', lex_iParam, false); // Invalid Integer - spaces
  CheckLex('12.34', lex_fParam, true);  // Valid   Float
  CheckLex('1.2e4', lex_fParam, true);  // Valid   Float
  CheckLex('1.2.4', lex_fParam, false); // Invalid Float - bad format
  CheckLex(' 1.2 ', lex_fParam, false); // Invalid Float - spaces
  CheckLex('abcde', lex_sParam, true);  // Valid   String parameter - simple
  CheckLex('"a b"', lex_sParam, true);  // Valid   String parameter - quoted
  CheckLex('ab de', lex_sParam, false); // Invalid String parameter - space inside
  CheckLex(base64_encode( GetDateTime(msecnow)), lex_Base64, true);
  CheckLex('!'+base64_encode( GetDateTime(msecnow)), lex_Base64, false);
  CheckLex('&Dead', lex_FsmName, true);          // Valid   FSM name
  CheckLex('A::BC', lex_SmiName, true);          // Valid   SMI name
  CheckLex('A:!BC', lex_FsmName, false);         // Invalid FSM name
  CheckLex('A+B/C', lex_DimName, true);          // Valid   DIM  name
  CheckLex('A|B/C', lex_DimName, false);         // Invalid DIM  name
  CheckLex('[S n]', lex_Section, true);          // Vaid    Section name
  CheckLex(' [Sn]', lex_Section, false);         // Invalid Section name
  CheckLex('[Sn] ', lex_Section, false);         // Invalid Section name
  CheckLex('@cmd ', lex_AtCall,  true);          // Valid   @Command
  CheckLex('@!cmd', lex_AtCall,  true);          // Valid   @Command
  CheckLex('@ cmd', lex_AtCall,  false);         // Invalid @Command
  CheckLex(' @cmd', lex_AtCall,  false);         // Invalid @Command
  CheckLex('alex-123',lex_DomName,true);         // Valid   domain name
  CheckLex('alex_123',lex_DomName,false);        // Invalid domain name
  CheckLex('Alex-123',lex_DomName,true);         // Valid   domain name
  CheckLex('Alex_123',lex_DomName,false);        // Invalid domain name
  CheckLex('alex.123',lex_DnsHost,true);         // Valid   dns hostname
  CheckLex('.alex.12',lex_DnsHost,false);        // Invalid dns hostname
  CheckLex('Alex.123',lex_DnsHost,true);         // Valid   dns hostname
  CheckLex('alex.12.',lex_DnsHost,false);        // Invalid dns hostname
  CheckLex('alex_1968$',lex_adduser,true);       // Valid   linux user name
  CheckLex('-alex_1968',lex_adduser,false);      // Invalid linux user name
  CheckLex('alex-_1968',lex_adduser,true);       // Valid   linux user name
  CheckLex('Alex-_1968',lex_adduser,false);      // Invalid linux user name
  CheckLex('alex_-1968',lex_domuser,true);       // Valid   domain username
  CheckLex('alex_1968$',lex_domuser,false);      // Invalid domain username
  CheckLex('alex@mail.ru',lex_usrhost,true);     // Valid   user@host
  CheckLex('192.168.1.1',lex_Ip4Addr,true);      // Valid   IPv4
  CheckLex('256.256.256.256',lex_Ip4Addr,false); // Invalid IPv4
  CheckLex('127.0.0.1',lex_Ip4Addr,true);        // Valid   IPv4
  CheckLex('127.0.0.a',lex_Ip4Addr,false);       // Invalid IPv4
  CheckLex('0.0.0.0',lex_Ip4Addr,true);          // Valid   IPv4
  CheckLex('255.255.255.255',lex_Ip4Addr,true);  // Valid   IPv4
  CheckLex('999.999.999.999',lex_Ip4Addr,false); // Invalid IPv4
  CheckLex('1.2.3.4',lex_Ip4Addr,true);          // Valid   IPv4
  CheckLex('1.2.3',lex_Ip4Addr,false);           // Invalid IPv4
  CheckLex('0001.2.3.4',lex_Ip4Addr,false);      // Invalid IPv4
  CheckLex('1.2.3.5.6.7.8.9',lex_Ip4Addr,false); // Invalid IPv4
  CheckLex('1.2.3.5.0000001',lex_Ip4Addr,false); // Invalid IPv4
  CheckLex('::1',lex_Ip6Addr,true);              // Valid   IPv6
  CheckLex('123',lex_Ip6Addr,false);             // Invalid IPv6
  CheckLex('fe80::6990:c8b:b658:d179%8',lex_Ip6Addr,true); // Valid   IPv6
  CheckLex('fec0:0:0:ffff::1%1',lex_Ip6Addr,false);        // Invalid IPv6
  CheckLex('fe80::800:27ff:fe00:0',lex_Ip6Addr,true);      // Valid   IPv6
  CheckLex('2a:72:b3:c9:53:44',lex_MacAddr,true);          // Valid   MAC-48
  CheckLex('2a:72:b3:c9:53.44',lex_MacAddr,false);         // Invalid MAC-48
  CheckLex('2a-72-b3-c9-53-44',lex_MacAddr,true);          // Valid   MAC-48
  CheckLex('2a-72-b3-c9-53_44',lex_MacAddr,false);         // Invalid MAC-48
  CheckLex('ab.cd.ef',lex_DotName,true);         // Valid   dot-name
  CheckLex('ab.cd._d',lex_DotName,true);         // Valid   dot-name
  CheckLex('ab..cdef',lex_DotName,false);        // Invalid dot-name
  CheckLex('scheme://auth/path?query#fragment',lex_UriAddr,true); // Valid URI address
  {
  CheckLex('',lex_,true); // Valid
  CheckLex('',lex_,false); // Invalid
  }
  rex:=regexp_init(0,'/^[_a-zA-z]+[_a-zA-Z0-9]*$/i');
  CheckLex('Var1',  rex,   true);  // Valid   Name
  CheckLex(' Var',  rex,   false); // Invalid Name - leading space
  FreeAndZero(rex);
  writeln(nerr:1,' Error(s) found.');
  arg:='Sun_Shine_'; for i:=1 to 2 do arg:=arg+arg; writeln(length(arg):1);
  Timing('',1000*1000); for i:=1 to n do b:=(arg<>'');              Timing('Compare',n);
  Timing('',1000*1000); for i:=1 to n do b:=Length(arg)>0;          Timing('Length',n);
  Timing('',1000*1000); for i:=1 to n do b:=IsLexeme(arg,lex_name); Timing('IsLexeme',n);
  // Measured timing was 54+2.3*length(arg) ns per IsLexeme(arg) call on i7-4700MQ-2.4GHz
  TestNumber:=0;
  arg:='';
 end;
 {
 Test 5.
 Check RegExp (regexp_xxx) parsing.
 }
 procedure Test5;
 var rex,errors,i,j,n,m:Integer; pat,inp,rep:String;
 begin
  writeln('Test5: check regexp_xxxx functions.');
  errors:=0;
  pat:=''; inp:=''; rep:='';
  // DateTime parsing demo
  pat:='(\d{2}):(\d{2}):(\d{2})';
  rex:=regexp_init(regexp_def,pat);
  writeln('Engine=',regexp_ctrl(rex,'Engine'),' ref = ',regexp_ref(rex));
  writeln('Engines=',StringReplace(Trim(regexp_ctrl(rex,'Engines')),EOL,',',rfReplaceAll));
  writeln('Version=',regexp_ctrl(rex,'Version'));
  writeln('Modifiers=',regexp_ctrl(rex,'Modifiers'));
  writeln('Modifiers=',regexp_ctrl(rex,'Modifiers=im-g'));
  writeln('UseSubst=',regexp_ctrl(rex,'UseSubst=1'));
  writeln('ExecMax=',regexp_ctrl(rex,'ExecMax=100'));
  writeln('Escape: '+regexp_escape('(1.23+3.45)*5'+Chr(9)+Chr(0)+EOL));
  inp:=GetDateTime(msecnow);
  if regexp_test(rex,inp) then begin
   writeln('String ',inp,' is valid.');
   rep:='$3:$2:$1';
   writeln(regexp_replace(rex,inp,rep));
   writeln('Match count is ',regexp_exec(rex,inp):1);
   if regexp_exec(rex,inp)>0 then begin
    n:=regexp_matchnum(rex,0);
    writeln('Found ',n,' matches.');
    for i:=1 to regexp_matchnum(rex,0) do begin
     writeln('Match[',i:1,'] is ',regexp_matchpos(rex,i,0):2,' ',regexp_matchlen(rex,i,0):2,' ',regexp_matchstr(rex,i,0));
     for j:=1 to regexp_matchnum(rex,i) do begin
      writeln('SubMatch[',j:1,'] is ',regexp_matchpos(rex,i,j):2,' ',regexp_matchlen(rex,i,j):2,' ',regexp_matchstr(rex,i,j));
     end;
    end;
   end;
  end;
  FreeAndZero(rex);
  pat:=''; inp:=''; rep:='';
 end;
 {
 Test 6.
 Check backslash_encode/decode.
 }
 procedure Test6;
 var i,n:Integer; ms:Real; b:Boolean; arg:String;
  procedure Timing(who:String; nn:Integer);
  begin
   n:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/n:1:3,' mks,  ',ms*1e6/n/length(arg):1:3,' ns/char,  ',ms:1:0,' ms');
   end;
  end;
  function StringOfCharRange(a,b:Char):String;
  var i:Integer; s:String;
  begin
   s:='';
   for i:=Ord(a) to Ord(b) do s:=s+Chr(i);
   StringOfCharRange:=s; s:='';
  end;
  function backslash_encoder_self_test(n:Integer; esclist,hexlist:String):Boolean;
  var data:String; i:Integer; b:Boolean;
  begin
   data:='';
   for i:=1 to n do data:=data+StringOfCharRange(Chr(0),Chr(255));
   sNul(backslash_encoder_ctrl('esclist='+esclist));
   sNul(backslash_encoder_ctrl('hexlist='+hexlist));
   writeln(backslash_encode(data));
   b:=(backslash_decode(backslash_encode(data))=data);
   sNul(backslash_encoder_ctrl('esclist='));
   sNul(backslash_encoder_ctrl('hexlist='));
   backslash_encoder_self_test:=b;
   data:='';
  end;
  function percent_encoder_self_test(n:Integer; esclist:String):Boolean;
  var data:String; i:Integer; b:Boolean;
  begin
   data:='';
   for i:=1 to n do data:=data+StringOfCharRange(Chr(0),Chr(255));
   sNul(percent_encoder_ctrl('reserved='+esclist));
   writeln(percent_encode(data));
   b:=(percent_decode(percent_encode(data))=data);
   sNul(percent_encoder_ctrl('reserved='));
   percent_encoder_self_test:=b;
   data:='';
  end;
 begin
  arg:='';
  writeln('Test6: check backslash_encode functions.');
  writeln('Test1 ',backslash_encoder_self_test(1,'',''));
  writeln('Test2 ',backslash_encoder_self_test(1,StringOfCharRange(Chr(0),Chr(255)),''));
  writeln('Test3 ',backslash_encoder_self_test(1,'',StringOfCharRange(Chr(0),Chr(255))));
  writeln('Test4 ',backslash_encoder_self_test(1,StringOfCharRange(Chr(0),Chr(255)),StringOfCharRange(Chr(0),Chr(255))));
  writeln(backslash_encode(StringOfCharRange(Chr(0),Chr(255))));
  writeln('Test6a: check percent_encode functions.');
  writeln('Test1 ',percent_encoder_self_test(1,''));
  writeln('Test2 ',percent_encoder_self_test(1,StringOfCharRange(Chr(0),Chr(255))));
  writeln(percent_encode(StringOfCharRange(Chr(0),Chr(255))));
  writeln(percent_encode(percent_encoder_ctrl('Reserved')));
  arg:=StringOfCharRange(Chr(0),Chr(255));
  Timing('',1000*20); for i:=1 to n do sNul(mime_encode(arg));                        Timing('mime_encode',n);
  Timing('',1000*10); for i:=1 to n do sNul(mime_decode(mime_encode(arg)));           Timing('mime_encode/decode',n);
  Timing('',1000*10); for i:=1 to n do sNul(hex_encode(arg));                         Timing('hex_encode',n);
  Timing('',1000*10); for i:=1 to n do sNul(hex_decode(hex_encode(arg)));             Timing('hex_encode/decode',n);
  Timing('',1000*10); for i:=1 to n do sNul(backslash_encode(arg));                   Timing('backslash_encode',n);
  Timing('',1000*10); for i:=1 to n do sNul(backslash_decode(backslash_encode(arg))); Timing('backslash_encode/decode',n);
  Timing('',1000*10); for i:=1 to n do sNul(percent_decode(percent_encode(arg)));     Timing('percent_encode/decode',n);
  arg:='';
 end;
 {
 Test 7.
 Check ColorToString.
 }
 procedure Test7;
 var errors:integer;
  procedure TestColor(code:Integer; name:String);
  var b:Boolean;
  begin
   b:=IsSameText(name,ColorToString(code)) and (code=StringToColor(name));   
   writeln('Color [',StrFmt('$%.8X',code),' ',name:10,'] = (',StrFmt('$%.8X',StringToColor(name)),' ',ColorToString(code):10,') => ',b:5);
   errors:=errors+Ord(not b);
  end;
 begin
  errors:=0;
  writeln('Test7: check Color<=>String routines.');
  TestColor(clNone,    '_None');
  TestColor(clBlack,   'Black');
  TestColor(clMaroon,  'Maroon');
  TestColor(clGreen,   'Green');
  TestColor(clOlive,   'Olive');
  TestColor(clNavy,    'Navy');
  TestColor(clPurple,  'Purple');
  TestColor(clTeal,    'Teal');
  TestColor(clGray,    'Gray');
  TestColor(clSilver,  'Silver');
  TestColor(clRed,     'Red');
  TestColor(clLime,    'Lime');
  TestColor(clYellow,  'Yellow');
  TestColor(clBlue,    'Blue');
  TestColor(clFuchsia, 'Fuchsia');
  TestColor(clAqua,    'Aqua');
  TestColor(clWhite,   'White');
  writeln(StringToColor('xx'):1,' ',StringToColorDef('xx',clBlack):1);
  writeln(errors:1,' error(s) found.');
 end;
 {
 Test 8.
 Check FSM functions.
 }
 procedure Test8;
 var n:Integer; ms:Real;
  procedure Timing(who,arg:String; nn:Integer);
  begin
   n:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/n:1:3,' mks,  ',ms*1e6/n/length(arg):1:3,' ns/char,  ',ms:1:0,' ms');
   end;
  end;
  procedure FsmTest1;
  var fsm,dom,i:Integer;
  begin
   Success(GetDateTime(msecnow)+' => FSM Test1.');
   fsm:=fsm_new;                                             // create FsmManager
   dom:=fsm_add(fsm,fsm_type_domain,'DEMO');                 // add domain DEMO
   dom:=fsm_add(fsm,fsm_type_domain,'TEST');                 // add domain TEST
   for i:=0 to fsm_count(fsm,fsm_type_domain)-1              // for all domains
   do writeln(fsm_name(fsm_items(fsm,fsm_type_domain,i)));   // print domain name
   FreeAndZero(fsm);                                          // free FsmManager
   if IsLexeme('DEMO',fsm_name_rule(fsm_type_domain)) then writeln('DEMO is good domain name');
   if IsLexeme('D::O',fsm_name_rule(fsm_type_domain)) then writeln('D::O is good domain name');
   if IsLexeme('DEMO',fsm_name_rule(fsm_type_object)) then writeln('DEMO is good object name');
   if IsLexeme('D::O',fsm_name_rule(fsm_type_object)) then writeln('D::O is good object name');
  end;
  procedure FsmTest2;
  var fsm,dom,par,i:Integer;
  begin
   Success(GetDateTime(msecnow)+' => FSM Test2.');
   fsm:=fsm_new;                                             // create FsmManager
   dom:=fsm_add(fsm,fsm_type_domain,'DEMO');                 // add domain DEMO
   par:=fsm_add(dom,fsm_type_int,'NUMBER');                  // add domain parameter int NUMBER
   bNul(fsm_set_iparam(par,123));                            // set parameter value
   par:=fsm_add(dom,fsm_type_float,'VOLT');                  // add domain parameter float VOLT
   bNul(fsm_set_fparam(par,pi));                             // set parameter value
   par:=fsm_add(dom,fsm_type_string,'USER');                 // add domain parameter string USER
   bNul(fsm_set_sparam(par,paramstr('username')));           // set parameter value
   for i:=0 to fsm_count(dom,fsm_type_parameter)-1 do begin  // for all domain parameters
    par:=fsm_items(dom,fsm_type_parameter,i);                // reference of parameter[i]
    write(fsm_name(par));                                    // print parameter name
    if fsm_type(par)=fsm_type_int then write(' = ',fsm_get_iparam(par));    // int value
    if fsm_type(par)=fsm_type_float then write(' = ',fsm_get_fparam(par));  // float value
    if fsm_type(par)=fsm_type_string then write(' = ',fsm_get_sparam(par)); // string value
    writeln;
   end;
   FreeAndZero(fsm);                                          // free FsmManager
  end;
  procedure FsmTest3(ndom,nobj,nsta,nact,npar:Integer);
  var fsm,dom,obj,sta,act,par,idom,iobj,ista,iact,ipar,ref,nerr,i:Integer; key:String;
  begin
   key:='';
   Success(GetDateTime(msecnow)+' => FSM Test3.');
   nerr:=0;
   fsm:=fsm_new;                                             
   if not IsSameText(fsm_name(fsm),'FsmManager') then nerr:=nerr+1;
   for idom:=1 to ndom do begin
    dom:=fsm_add(fsm,fsm_type_domain,StrFmt('domain_%d',idom));
    if (fsm_type(dom)<>fsm_type_domain) then nerr:=nerr+1;
    if (fsm_type(fsm_root(dom))<>fsm_type_manager) then nerr:=nerr+1;
    if (fsm_type(fsm_parent(dom))<>fsm_type_manager) then nerr:=nerr+1;
    for iobj:=1 to nobj do begin
     obj:=fsm_add(dom,fsm_type_object,StrFmt('object_%d',iobj));
     if (fsm_type(obj)<>fsm_type_object) then nerr:=nerr+1;
     if (fsm_type(fsm_root(obj))<>fsm_type_manager) then nerr:=nerr+1;
     if (fsm_type(fsm_parent(obj))<>fsm_type_domain) then nerr:=nerr+1;
     for ista:=1 to nsta do begin
      sta:=fsm_add(obj,fsm_type_state,StrFmt('state_%d',ista));
      if (fsm_type(sta)<>fsm_type_state) then nerr:=nerr+1;
      if (fsm_type(fsm_root(sta))<>fsm_type_manager) then nerr:=nerr+1;
      if (fsm_type(fsm_parent(sta))<>fsm_type_object) then nerr:=nerr+1;
      for iact:=1 to nact do begin
       act:=fsm_add(sta,fsm_type_action,StrFmt('action_%d',iact));
       if (fsm_type(act)<>fsm_type_action) then nerr:=nerr+1;
       if (fsm_type(fsm_root(act))<>fsm_type_manager) then nerr:=nerr+1;
       if (fsm_type(fsm_parent(act))<>fsm_type_state) then nerr:=nerr+1;
      end;
     end;
    end;
   end;
   //
   key:=StrFmt('state_%d',nsta);
   if not IsSameText(fsm_name(fsm_get_state(obj)),'STATE_1') then nerr:=nerr+1;
   if not IsSameText(fsm_name(fsm_set_state(obj,key)),key) then nerr:=nerr+1;
   if not IsSameText(fsm_name(fsm_set_state(obj,'STATE_1')),'STATE_1') then nerr:=nerr+1;
   if not IsSameText(fsm_name(fsm_set_state(obj,StrFmt('state_%d',nsta))),key) then nerr:=nerr+1;
   if not IsSameText(fsm_name(fsm_set_state(obj,'STATE_1')),'STATE_1') then nerr:=nerr+1;
   //
   //writeln(trim(fsm_ctrl(fsm,'catalog')));
   writeln('last action: ',fsm_path(fsm_ref(act)));
   key:=StrFmt('domain_%d',ndom)+'::'+StrFmt('object_%d',nobj)+'/'+StrFmt('state_%d',nsta)+'/'+StrFmt('action_%d',nact);
   if not IsSameText(fsm_path(act),key) then nerr:=nerr+1;
   ref:=fsm_find(fsm,fsm_type_any,key); if (ref<>act) then nerr:=nerr+1;
   //
   Timing('',key,1000*20);
   for i:=1 to n do ref:=fsm_find(fsm,fsm_type_any,key);
   Timing('fsm_find path',key,n);
   //
   key:=StrFmt('action_%d',nact);
   ref:=fsm_find(sta,fsm_type_any,key); if (ref<>act) then nerr:=nerr+1;
   Timing('',key,1000*100);
   for i:=1 to n do ref:=fsm_find(sta,fsm_type_any,key);
   Timing('fsm_find name',key,n);
   //
   key:=StrFmt('state_%d',nsta);
   ref:=fsm_set_state(obj,sta); if (ref<>sta) then nerr:=nerr+1;
   ref:=fsm_get_state(obj); if (ref<>sta) then nerr:=nerr+1;
   Timing('',key,1000*1000);
   for i:=1 to n do ref:=fsm_get_state(obj);
   Timing('fsm_get_state fast',key,n);
   Timing('',key,1000*500);
   for i:=1 to n do ref:=fsm_set_state(obj,sta);
   Timing('fsm_set_state fast',key,n);
   //
   key:=StrFmt('state_%d',nsta);
   ref:=fsm_find(obj,fsm_type_state,fsm_ctrl(obj,'state='+key)); if (ref<>sta) then nerr:=nerr+1;
   ref:=fsm_find(obj,fsm_type_state,fsm_ctrl(obj,'state')); if (ref<>sta) then nerr:=nerr+1;
   Timing('',key,1000*50);
   for i:=1 to n do ref:=Ord(fsm_ctrl(obj,'state')<>'');
   Timing('fsm_get_state slow',key,n);
   Timing('',key,1000*50);
   for i:=1 to n do ref:=Ord(fsm_ctrl(obj,'state='+key)<>'');
   Timing('fsm_set_state slow',key,n);
   Timing('',key,1000*50);
   for i:=1 to n do ref:=fsm_set_state(obj,key);
   Timing('fsm_set_state strn',key,n);
   //
   key:='tag';
   Timing('',key,1000*100);
   writeln('Link ',fsm_link(obj,'tag=123'):1);
   for i:=1 to n do ref:=fsm_link(obj,key);
   Timing('fsm_link',key,n);
   //
   obj:=fsm_find(fsm,fsm_type_object,'domain_2::object_3');
   sta:=fsm_find(obj,fsm_type_state,'state_4');
   iNul(fsm_modified(sta,1));
   writeln(fsm_path(sta),' ',fsm_modified(sta,-1):1,' ',fsm_modified(obj,-1):1,' ',fsm_modified(fsm,-1):1);
   if fsm_modified(fsm,0)>0 then
   for idom:=0 to fsm_count(fsm,fsm_type_domain)-1 do begin
    dom:=fsm_items(fsm,fsm_type_domain,idom); 
    if fsm_modified(dom,0)>0 then
    for iobj:=0 to fsm_count(dom,fsm_type_object)-1 do begin
     obj:=fsm_items(dom,fsm_type_object,iobj);
     if fsm_modified(obj,0)>0 then begin
      writeln('Object '+fsm_path(obj)+' was modified.');
     end;
    end;
   end;
   //
   key:='fsm_modified';
   Timing('',key,1000*1000);
   for i:=1 to n do ref:=fsm_modified(obj,0);
   Timing('fsm_modified',key,n);
   //
   //
   FreeAndZero(fsm);
   writeln(nerr:1,' error(s) found in Test3.');
   key:='';
  end;
 begin
  FsmTest1;
  FsmTest2;
  FsmTest3(2,3,10,10,3);
 end;
 {
 Test 9.
 Check UpCase/LoCase.
 }
 procedure Test9;
 var ic,ne:Integer; ci,cu,cl:Char;
 begin
  Success('Test9: Check UpCase/LoCase.');
  ne:=0;
  for ic:=0 to 255 do begin
   ci:=chr(ic);
   cu:=upcase(ci);
   cl:=locase(ci);
   if (ci<>cu) or (ci<>cl) then writeln(HexB(ic),'  lo:',cl,'    up:',cu);
   if (cu<>upcase(cl)) or (cl<>locase(cu)) then ne:=ne+1;
  end;
  writeln(ne:1,' error(s) found');
 end;
 {
 Test 10.
 Check htonl/ntohl.
 }
 procedure Test10;
 var i,j,n:Integer; ms:Real;
  procedure Timing(who:String; nn:Integer);
  begin
   n:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/n:1:3,' mks/call,  ',ms*1e6/n:1:3,' ns/call,  ',ms:1:0,' ms');
   end;
  end;
  procedure TestHtonl;
  var hl,nl,hs,ns,ne:Integer;
  begin
   ne:=0;
   hl:=Val('$D0C0B0A0'); nl:=htonl(hl);  writeln(' $',hexl(hl):8,' $',hexl(nl):8,' - ',(hl=ntohl(nl)):1); ne:=ne+ord(hl<>ntohl(nl));
   nl:=Val('$D0C0B0A0'); hl:=ntohl(nl);  writeln(' $',hexl(hl):8,' $',hexl(nl):8,' - ',(nl=htonl(hl)):1); ne:=ne+ord(nl<>htonl(hl));
   hs:=Val('$DCBA');     ns:=htons(hs);  writeln(' $',hexw(hs):8,' $',hexw(ns):8,' - ',(hs=ntohs(ns)):1); ne:=ne+ord(hs<>ntohs(ns));
   ns:=Val('$DCBA');     hs:=ntohs(ns);  writeln(' $',hexw(hs):8,' $',hexw(ns):8,' - ',(ns=htons(hs)):1); ne:=ne+ord(ns<>htons(hs));
   writeln(ne:1,' error(s) found');
  end;
 begin
  Success('Test10: Check htonl/ntohl.');
  TestHtonl;
  Timing('',1000*1000*10);  for i:=1 to n do ;            Timing('for empty loop',n);
  Timing('',1000*1000);     for i:=1 to n do j:=htonl(i); Timing('htonl',n);
  Timing('',1000*1000);     for i:=1 to n do j:=ntohl(i); Timing('ntohl',n);
  Timing('',1000*1000);     for i:=1 to n do j:=htons(i); Timing('htons',n);
  Timing('',1000*1000);     for i:=1 to n do j:=ntohs(i); Timing('ntohs',n);
 end;
 {
 Test 11.
 Check case.
 }
 procedure Test11;
 var i,n,m:Integer; c:char;
 begin
  Success('Test11: Check case statement.');
  n:=0; m:=0;
  for i:=1 to 4 do begin
   write(i:1);
   case i of
    1: begin write(' case 1'); n:=n+1; end;
    2: begin write(' case 2'); n:=n+1; end;
   end;
   writeln(' done ',i:1); m:=m+1;
  end;
  for c:='a' to 'd' do begin
   write(c:1);
   case c of
    'a': begin write(' case a'); n:=n+1; end;
    'b': begin write(' case b'); n:=n+1; end;
   end;
   writeln(' done ',c:1); m:=m+1;
  end;
  if (n=4) and (m=8)
  then writeln('case test success')
  else writeln('case test failed');
  writeln;
 end;
 {
 Test 12,13,14.
 Database routines.
 }
 procedure Test12;
 var con,rst,ern:Integer; constr,sqlcmd,pwd,dbf:String;
  procedure Cleanup;
  begin
   constr:=''; sqlcmd:=''; pwd:=''; dbf:=''; ern:=0;
  end;
  function FormatRow(rst:Integer):String;
  var id,res:String; i,tp:Integer;
  begin
   id:=''; res:='';
   if db_bof(rst) then begin
    for i:=0 to db_fieldscount(rst)-1 do begin
     id:=db_fieldsnames(rst,i); tp:=db_fieldstypes(rst,id);
     res:=res+' '+id+':'+db_FieldTypeToString(tp)+';';
    end;
    res:=res+EOL;
   end;
   for i:=0 to db_fieldscount(rst)-1 do begin
    id:=db_fieldsnames(rst,i); tp:=db_fieldstypes(rst,id);
    res:=res+' '+id+'='+Str(tp)+','+db_fieldsasstring(rst,id,'r','')+';';
   end;
   FormatRow:=res; id:=''; res:='';
  end;
 begin
  Cleanup;
  Success(StrFmt('Test%d: Check Database routines.',TestNumber));
  // Set Engine to use...
  db_engine_uses_assign(db_engine_ado);
  db_engine_uses_assign(db_engine_zeos);
  db_engine_uses_assign(db_engine_sqldb);
  Success('Uses engine '+Str(db_engine_uses)+' '+db_engine_uses_name);
  Success('Engine DB types '+db_supporteddbtypes);
  Success('All DB types '+db_allsupporteddbtypes);
  // Prepare connection string and SQL command...
  case TestNumber of
   12: begin
        dbf:=AdaptFileName('c:\opt\crwdaq\demo\demo_data\employee.fdb');
        constr:='Provider=LCPI.IBProvider.5.Free;Location=localhost:employee;'
               +'User ID=SYSDBA;Password=masterkey;ctype=win1251;';
        constr:='Provider=LCPI.IBProvider.5.Free;Location=localhost:'+dbf+';'
               +'User ID=SYSDBA;Password=masterkey;ctype=win1251;';
        constr:='Provider=MSDASQL;DRIVER=Firebird/InterBase(r) driver;'
               +'DBNAME=localhost:employee;UID=SYSDBA;PWD=masterkey;';
        constr:='Provider=MSDASQL;DRIVER=Firebird/InterBase(r) driver;'
               +'DBNAME=localhost:'+dbf+';UID=SYSDBA;PWD=masterkey;';
        sqlcmd:='select first 10 EMPLOYEE.* from EMPLOYEE';
        sqlcmd:='select first 10 COUNTRY.* from COUNTRY';
       end;
   13: begin
        dbf:=AdaptFileName('c:\opt\crwdaq\demo\demo_data\toc.db');
        constr:='Provider=MSDASQL;DRIVER=SQLite3 ODBC Driver;Database='+dbf+';'
               +'LongNames=0;Timeout=1000;NoTXN=0;SyncPragma=NORMAL;StepAPI=0;';
        constr:='Provider=MSDASQL;DRIVER=SQLite3 ODBC Driver;Database='+dbf+';';
        sqlcmd:='select * from toc';
       end;
   14: begin // Build ConnectionString from templates; use password encryption
        dbf:=AdaptFileName('c:\opt\crwdaq\demo\demo_data\employee.fdb');
        pwd:='8KGjli65aKi2'; // masterkey encrypted with mode 6, just for test
        constr:=db_build_connectionstring('Firebird','localhost',dbf,'SYSDBA',pwd,'',6);
        sqlcmd:='select * from EMPLOYEE';
        writeln('Supported ALL DB types: ',db_allsupporteddbtypes);
        writeln('Supported DB types: ',db_supporteddbtypes);
        writeln(Trim(TextToString(_DbLibrary_Internals_.selectalltables_samples)));
        writeln(db_build_selectalltables('MySQL',''));
        writeln(db_build_selectalltables('SQLite3',''));
        writeln(db_build_selectalltables('Firebird',''));
        writeln(db_build_selectalltables('PostgreSQL',''));
        writeln('database_file_samples',EOL,Trim(TextToString(_DbLibrary_Internals_.database_file_samples)));
       end;
  end;
  writeln('test ',db_build_connectionstring('Firebird','localhost','c:/demo/test.db','SYSDBA',pwd,'',6));
  if (db_engine_uses=db_engine_sqldb) or (db_engine_uses=db_engine_zeos) then begin
   constr:=db_validate_known_providers(constr);
   if IsUnix then constr:=StringReplace(constr,'localhost:','',rfIgnoreCase);
   writeln('ConStr = ',constr);
  end;
  // Connect and get data...
  con:=db_connection(db_engine_uses,constr);
  if (con=0) then ern:=ern+1 else begin
   sNul(db_ctrl(con,'BugReportPrefix=@!EEchoException: ')); // Bug report mode: [Soft,Echo,Hide]
   Success(db_ctrl(con,'EngineName')+' version '+db_ctrl(con,'Version')+' with Provider '+db_ctrl(con,'Provider'));
   Success('ConnectionString = '+db_ctrl(con,'ConnectionString')); 
   if db_open(con,adConnectUnspecified) then begin
    Success('Database opened');
    if db_begintrans(con)>0 then begin
     Success('Transaction started, execute...');
     rst:=db_execute(con,sqlcmd,adCmdText);
     if (rst<>0) then begin
      Success('Got data records, reading data:');
      if db_fieldscount(rst)>0 then
      while not db_eof(rst) do begin
       writeln(FormatRow(rst));
       bNul(db_movenext(rst));
      end;
     end else ern:=ern+1;
     if db_committrans(con) then Success('Transaction done');
    end else ern:=ern+1;
    bNul(db_close(con));
   end else ern:=ern+1;
   FreeAndZero(con);
  end;
  if (ern=0)
  then Success('Success.')
  else Problem(StrFmt('%d error(s) found',ern));
  writeln;
  TestNumber:=0;
  Cleanup;
 end;
 {
 Test 15.
 Check poseol.
 }
 procedure Test15;
 var i,nt,ne,nl,n:Integer; c:char; s:String; testtemp,testchar:Boolean; ms:Real;
  procedure Cleanup;
  begin
   s:=''; ne:=0; nt:=0; nl:=0;
  end;
  procedure CheckPosEol(e:Integer; s:String; start,skip:Integer);
  var p:Integer;
  begin
   nt:=nt+1;
   if testchar and (length(s)=1) then p:=PosEol(StrFetch(s,1),start,skip) else
   if testtemp then p:=PosEol((s+''),start,skip) else p:=PosEol(s,start,skip);
   writeln('Test',nt:2,': ',(e=p):5,' Expect:',e:2,', Real:',p:2,
    ' Start:',start:2,' Skip:',skip:2,' s='+backslash_encode(s));
   if (e<>p) then ne:=ne+1;
  end;
  procedure Timing(who:String; nn:Integer);
  begin
   n:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/n:1:3,' mks/call,  ',ms*1e6/n:1:3,' ns/call,  ',ms:1:0,' ms');
   end;
  end;
  // Procedure to handle line number n.
  procedure HandleLine(n:Integer; line:String);
  begin
   writeln('Line ',n:1,' = ',line);
  end;
  // Handle lines in buffer, return num.lines.
  function HandleLines(var buf:String):Integer;
  var p,s,n,l:Integer;
  begin
   p:=1;s:=1;n:=0;l:=Length(buf);
   while (p>=1) and (p<=l) do begin
    p:=PosEol(buf,s,0); // Find EOL
    if (p>0) then begin // EOL found
     HandleLine(n,Copy(buf,s,p-s));
     s:=PosEol(buf,p,1); // Skip EOL
     n:=n+1; // inc line counter
    end else // handle last line
    if (s<=l) then begin // Has tail
     HandleLine(n,Copy(buf,s,l-s+1));
     n:=n+1; // inc line counter
    end;
   end;
   HandleLines:=n; // return number of lines
  end;
 begin
  Cleanup;
  Success('Test15: Check PosEol.');
  testtemp:=false; testchar:=false;
  {}
  s:='';
  writeln('Empty line:');
  CheckPosEol(0,s,0,0);
  CheckPosEol(0,s,1,0);
  CheckPosEol(0,s,0,1);
  CheckPosEol(0,s,1,1);
  CheckPosEol(0,s,1,2);
  {}
  s:='0';
  testchar:=true;
  writeln('Char 0:');
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,2,0);   // Invalid start
  CheckPosEol(0,s,1,0);   // Eol not found
  CheckPosEol(2,s,1,1);   // Pos after line if skip lines
  CheckPosEol(2,s,1,2);   // Pos after line if skip lines
  {}
  s:=Chr(13);
  testchar:=true;
  writeln('Char CR:');
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,2,0);   // Invalid start
  CheckPosEol(1,s,1,0);   // Eol found at 1
  CheckPosEol(2,s,1,1);   // Pos after line if skip lines
  CheckPosEol(2,s,1,2);   // Pos after line if skip lines
  CheckPosEol(2,s,1,3);   // Pos after line if skip lines
  {}
  s:=Chr(13);
  testchar:=false;
  writeln('String CR:');
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,2,0);   // Invalid start
  CheckPosEol(1,s,1,0);   // Eol found at 1
  CheckPosEol(2,s,1,1);   // Pos after line if skip lines
  CheckPosEol(2,s,1,2);   // Pos after line if skip lines
  CheckPosEol(2,s,1,3);   // Pos after line if skip lines
  {}
  testtemp:=true;
  writeln('String temporary with CRLF, incomplete');
  s:='123'+CRLF+'45'+CRLF+'67';
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,12,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(6,s,1,1);   // Goto line2 start
  CheckPosEol(10,s,1,2);  // Goto line3 start
  CheckPosEol(12,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(12,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with CRLF, incomplete');
  s:='123'+CRLF+'45'+CRLF+'67';
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,12,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(6,s,1,1);   // Goto line2 start
  CheckPosEol(10,s,1,2);  // Goto line3 start
  CheckPosEol(12,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(12,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with CRLF, incomplete, tail CR');
  s:='123'+CRLF+'45'+CRLF+'67'+Chr(13);
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,13,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(6,s,1,1);   // Goto line2 start
  CheckPosEol(10,s,1,2);  // Goto line3 start
  CheckPosEol(13,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(13,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with CRLF, complete, tail CRLF');
  s:='123'+CRLF+'45'+CRLF+'67'+CRLF;
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,14,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(6,s,1,1);   // Goto line2 start
  CheckPosEol(10,s,1,2);  // Goto line3 start
  CheckPosEol(14,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(14,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with CR, complete, tail CR');
  s:='123'+Chr(_CR)+'45'+Chr(_CR)+'67'+Chr(_CR);
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,11,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(7,s,6,0);   // Goto line2 eol
  CheckPosEol(5,s,1,1);   // Goto line2 start
  CheckPosEol(8,s,1,2);   // Goto line3 start
  CheckPosEol(11,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(11,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with LF, complete, tail LF');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+'67'+Chr(_LF);
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,11,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(7,s,6,0);   // Goto line2 eol
  CheckPosEol(5,s,1,1);   // Goto line2 start
  CheckPosEol(8,s,1,2);   // Goto line3 start
  CheckPosEol(11,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(11,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with LF, incomplete');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+'67';
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,10,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(7,s,6,0);   // Goto line2 eol
  CheckPosEol(5,s,1,1);   // Goto line2 start
  CheckPosEol(8,s,1,2);   // Goto line3 start
  CheckPosEol(10,s,1,3);  // Goto line4 start (out of string)
  CheckPosEol(10,s,1,4);  // Goto line5 start (out of string)
  {}
  testtemp:=false;
  writeln('String variable with LF, complete, tail LF');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+Chr(_LF)+'67'+Chr(_LF);
  CheckPosEol(0,s,0,0);   // Invalid start
  CheckPosEol(0,s,12,0);  // Invalid start
  CheckPosEol(4,s,1,0);   // Goto line1 eol
  CheckPosEol(7,s,6,0);   // Goto line2 eol
  CheckPosEol(5,s,1,1);   // Goto line2 start
  CheckPosEol(8,s,1,2);   // Goto line3 start
  CheckPosEol(9,s,1,3);   // Goto line4 start
  CheckPosEol(12,s,1,4);  // Goto line5 start (out of string)
  CheckPosEol(12,s,1,5);  // Goto line6 start (out of string)
  {}
  testtemp:=false;
  writeln('String lines loop; CRLF, incomplete');
  s:='123'+CRLF+'45'+CRLF+'67';
  nl:=HandleLines(s);
  if (nl<>3) then ne:=ne+1;
  {}
  testtemp:=false;
  writeln('String lines loop; CRLF, complete');
  s:='123'+CRLF+'45'+CRLF+'67'+CRLF;
  nl:=HandleLines(s);
  if (nl<>3) then ne:=ne+1;
  {}
  testtemp:=false;
  writeln('String lines loop; LF, incomplete');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+'67';
  nl:=HandleLines(s);
  if (nl<>3) then ne:=ne+1;
  {}
  testtemp:=false;
  writeln('String lines loop; LF, complete');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+'67'+Chr(_LF);
  nl:=HandleLines(s);
  if (nl<>3) then ne:=ne+1;
  {}
  testtemp:=false;
  writeln('String lines loop; LFCR, complete');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+Chr(_CR)+'67'+Chr(_LF);
  nl:=HandleLines(s);
  if (nl<>3) then ne:=ne+1;
  {}
  testtemp:=false;
  writeln('String lines loop; LF, complete');
  s:='123'+Chr(_LF)+'45'+Chr(_LF)+Chr(_LF)+'67'+Chr(_LF);
  nl:=HandleLines(s);
  if (nl<>4) then ne:=ne+1;
  {}
  writeln('Timing of PosEol');
  s:=GetEnv('CommonProgramFiles')+EOL+GetEnv('ProgramFiles');
  writeln('Test string ',backslash_encode(s));
  Timing('',1000*1000*2); for i:=1 to n do nl:=PosEol(s,1,0); Timing('PosEol(s,1,0)',n); writeln(nl);
  Timing('',1000*1000*2); for i:=1 to n do nl:=PosEol(s,1,1); Timing('PosEol(s,1,1)',n); writeln(nl);
  Timing('',1000*1000*2); for i:=1 to n do nl:=PosEol(s,1,2); Timing('PosEol(s,1,2)',n); writeln(nl);
  {}
  TestNumber:=0;
  writeln(ne:1,' error(s) found in poseol test');
  writeln;
  Cleanup;
 end;
 {
 Test 16.
 Database routines - recordset.
 }
 procedure Test16;
 var con,rst,ern,varnum:Integer; constr,sqlcmd,sample,testfdb,tabs:String; ms:Real;
  procedure Cleanup;
  begin
   constr:=''; sqlcmd:=''; sample:=''; testfdb:=''; tabs:=''; ern:=0; con:=0;
  end;
  function FormatRow(rst:Integer):String;
  var id,res:String; i,tp:Integer;
  begin
   id:=''; res:='';
   for i:=0 to db_fieldscount(rst)-1 do begin
    id:=db_fieldsnames(rst,i); tp:=db_fieldstypes(rst,id);
    res:=res+' '+id+'='+Str(tp)+','+db_fieldsasstring(rst,id,'r','')+';';
   end;
   FormatRow:=res; id:=''; res:='';
  end;
  procedure ValidateConstr;
  begin
   if (constr<>'') then
   if (db_engine_uses=db_engine_sqldb) or (db_engine_uses=db_engine_zeos) then begin
    constr:=db_validate_known_providers(constr);
    if IsUnix then constr:=StringReplace(constr,'localhost:','',rfIgnoreCase);
   end;
  end;
 begin
  Cleanup;
  ms:=mSecNow;
  db_engine_uses_assign(db_engine_ado);  
  db_engine_uses_assign(db_engine_zeos);
  db_engine_uses_assign(db_engine_sqldb);
  testfdb:=AdaptFileName(AddPathDelim(ParamStr('DAQDATAPATH'))+'test.fdb');
  Success(StrFmt('Test%d: Check Database routines.',TestNumber));
  sample:=ExpEnv('%CRW_DAQ_SYS_HOME_DIR%\demo\demo_data\sample.fdb');
  constr:=db_build_connectionstring('Firebird','localhost',sample,'SYSDBA','masterkey','',0);
  ValidateConstr;
  writeln('constr = '+constr);
  sqlcmd:='select * from EMPLOYEE';
  //
  // Create local FDB file if one not exists.
  // Uses library call (db_create_local_fdb).
  //
  if db_create_local_fdb(testfdb,'SYSDBA','8KGjli65aKi2','PageSize = 4096','',6)
  then Success('Create DB: '+testfdb)
  else Trouble('Failed DB: '+testfdb);
  //
  // Obsolete version of (direct) database creation.
  //
  if false then // Skip it
  if not FileExists(testfdb) then begin
   constr:=db_build_connectionstring('Firebird','localhost',sample,'SYSDBA','masterkey','',0);
   ValidateConstr;
   sqlcmd:='create database '+AnsiQuotedStr(testfdb,Apostrophe)
          +' user '+AnsiQuotedStr('SYSDBA',Apostrophe)
          +' password '+AnsiQuotedStr('masterkey',Apostrophe);
   writeln('constr = '+constr);
   con:=db_connection(db_engine_uses,constr);
   if db_open(con,adConnectUnspecified) then begin
    if db_begintrans(con)>0 then begin
     Success('Creating Databadse...');
     rst:=db_execute(con,sqlcmd,adCmdText);
     if (rst<>0) then begin
      Success('Created: '+testfdb);
     end else ern:=ern+1;
     if db_committrans(con) then Success('Transaction done');
    end else ern:=ern+1;
   end;
   FreeAndZero(con);
  end;
  //
  // Read list of tables (tabs) in database (testfdb).
  //
  constr:=db_build_connectionstring('Firebird','localhost',testfdb,'SYSDBA','masterkey','',0);
  ValidateConstr;
  writeln('constr = '+constr);
  writeln('query_showtables');
  tabs:=db_query_showtables(constr,db_sym_Firebird);
  //
  // If table 'test' is not found, create new table 'test'.
  // Then insert a single row in table.
  //
  if (WordIndex('test',tabs)=0) then begin
   sqlcmd:='create table test (x timestamp not null primary key, y double precision not null)';
   if db_easy_sql_query(constr,sqlcmd)
   then Success('Create table')
   else Trouble('Failed table');
   sqlcmd:='insert into test (x,y) values (''01.01.1970 12:30:45'',3.14)';
   if db_easy_sql_query(constr,sqlcmd)
   then Success('Insert table')
   else Trouble('Insert table');
  end;
  tabs:=db_query_showtables(constr,db_sym_Firebird);
  writeln('Tables found: '+StringReplace(Trim(tabs),EOL,',',rfReplaceAll));
  //
  // If database found, open connection and add new (x,y) record
  // by recordset methods addnew/update (without direct SQL command).
  // SQL query (sqlcmd) uses by recordset to read first record,
  // just to extract list of table fields names.
  // Two variants of recordset usage available:
  //  1. Recordset opens (indirect) new connection with same connection string.
  //  2. Recordset uses existing opened connection to add/update data.
  // Note:
  //  CursorType,LockType should be set before open recordset.
  //
  if FileExists(testfdb) then begin
   constr:=db_build_connectionstring('Firebird','localhost',testfdb,'SYSDBA','masterkey','',0);
   ValidateConstr;
   writeln('constr = '+constr);
   sqlcmd:='select first 1 * from test';
   con:=db_connection(db_engine_uses,constr);
   varnum:=2;
   if (varnum=1) then begin
    //
    // Variant 1: recordset uses new (indirect) connection.
    //
    rst:=db_recordset(con,sqlcmd);
    if (rst<>0) then begin
     Success('Create recordset');
     sNul(db_ctrl(rst,StrFmt('CursorType=%d',adOpenStatic)));
     sNul(db_ctrl(rst,StrFmt('LockType=%d',adLockPessimistic)));
     if db_open(rst,adConnectUnspecified) then begin
      Success('Open recordset');
      if db_addnew(rst,'') then Success('Add new record');
      rNul(db_fieldsAsFloat(rst,dump('x'),'w',MsToOleTime(msecnow)));
      rNul(db_fieldsAsFloat(rst,dump('y'),'w',runcount));
      if db_update(rst) then Success('Update recordset');
     end else ern:=ern+1;
    end;
   end else begin
    //
    // Variant 2: recordset uses existing (opened) connection.
    //
    if db_open(con,adConnectUnspecified) then begin
     if db_begintrans(con)>0 then begin
      rst:=db_recordset(con,sqlcmd);
      if (rst<>0) then begin
       Success('Create recordset');
       sNul(db_ctrl(rst,StrFmt('CursorType=%d',adOpenStatic)));
       sNul(db_ctrl(rst,StrFmt('LockType=%d',adLockPessimistic)));
       if db_open(rst,adConnectUnspecified) then begin
        Success('Open recordset');
        if db_addnew(rst,'') then Success('Add new record');
        rNul(db_fieldsAsFloat(rst,dump('x'),'w',MsToOleTime(msecnow)));
        rNul(db_fieldsAsFloat(rst,dump('y'),'w',runcount));
        if db_update(rst) then Success('Update recordset');
       end else ern:=ern+1;
      end;
      if db_committrans(con) then Success('Transaction done');
     end else ern:=ern+1;
    end;
   end;
   FreeAndZero(con);   
  end;
  //
  // Connect and make 'select * from test' to view table updates.
  //
  if FileExists(testfdb) then begin
   constr:=db_build_connectionstring('Firebird','localhost',testfdb,'SYSDBA','masterkey','',0);
   ValidateConstr;
   writeln('constr = '+constr);
   sqlcmd:='select * from test';
   con:=db_connection(db_engine_uses,constr);
   if (con=0) then ern:=ern+1 else begin
    db_bugreport_mode(con,db_brm_uses);
    Success(db_ctrl(con,'EngineName')+' version '+db_ctrl(con,'Version')+' with Provider '+db_ctrl(con,'Provider'));
    if db_open(con,adConnectUnspecified) then begin
     Success('Database opened');
     if db_begintrans(con)>0 then begin
      Success('Transaction started, execute...');
      rst:=db_execute(con,sqlcmd,adCmdText);
      if (rst<>0) then begin
       Success('Got data records, reading data:');
       if db_fieldscount(rst)>0 then
       while not db_eof(rst) do begin
        writeln(FormatRow(rst));
        bNul(db_movenext(rst));
       end;
      end else ern:=ern+1;
      if db_committrans(con) then Success('Transaction done');
     end else ern:=ern+1;
     bNul(db_close(con));
    end else ern:=ern+1;
    FreeAndZero(con);
   end;
  end;
  writeln('Detected DB type: '+db_detect_dbtype(0,constr));
  writeln('SQLite3 sample: '+db_sample_database_file('SQLite3'));
  writeln('Firebird sample: '+db_sample_database_file('Firebird'));
  if (ern=0)
  then Success('Success.')
  else Problem(StrFmt('%d error(s) found',ern));
  Success(StrFmt('Execution Time %1.0f ms',mSecNow-ms));
  TestNumber:=0;
  writeln;
  Cleanup;
 end;
 {
 Test 17.
 Check StrTimeFmt.
 Result: StrTimeFmt/GetDateTimeNew/GetDateTimeOld=2.2/2.2/6.6 mks/call with CPU i7-4700MQ-2.4GHz.
 }
 procedure Test17;
 var s1,s2:String; ner,nt,i:Integer; ms:Real;
  procedure Cleanup;
  begin
   s1:=''; s2:=''; ner:=0;
  end;
  procedure Timing(who:String; nn:Integer);
  begin
   nt:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/nt:1:3,' mks/call,  ',ms*1e6/nt:1:3,' ns/call,  ',ms:1:0,' ms');
   end;
  end;
  // Old, obsolete version of GetDateTime
  function GetDateTimeOld(ms:Real):String;
  begin
   GetDateTimeOld:=StrFmt('%4.4d.',ms2year(ms))+StrFmt('%2.2d.',ms2month(ms))+StrFmt('%2.2d-',ms2day(ms))
                  +StrFmt('%2.2d:',ms2hour(ms))+StrFmt('%2.2d:',ms2min(ms))+StrFmt('%2.2d',ms2sec(ms));
  end;
  function GetDateTimeNew(ms:Real):String;
  begin
   GetDateTimeNew:=StrTimeFmt('yyyy.mm.dd-hh:nn:ss',ms);
  end;
 begin
  Cleanup;
  Success('Test17: Check StrTimeFmt.');
  {}
  ms:=msecnow;
  s1:=GetDateTimeNew(ms);
  s2:=GetDateTimeOld(ms);
  writeln('MSecRangeMin = ',StrFmt('%g',MSecRangeMin),' = ',StrTimeFmt('yyyy.mm.dd-hh:nn:ss.zzz',MSecRangeMin));
  writeln('MSecRangeMax = ',StrFmt('%g',MSecRangeMax),' = ',StrTimeFmt('yyyy.mm.dd-hh:nn:ss.zzz',MSecRangeMax));
  writeln(StrTimeFmt('yyyymmdd-hhnnss.zzz',ms));
  writeln(StrTimeFmt('yyyy.mm.dd-hh:nn:ss.zzz: => ',ms),'Prompt');
  writeln('Time New: ',s1,', Old: ',s2);
  if not IsSameText(s1,s2) then ner:=ner+1;
  {}
  Timing('',100000);
  for i:=1 to nt do s1:=StrTimeFmt('yyyy.mm.dd-hh:nn:ss',ms);
  Timing('StrTimeFmt: ',nt);
  {}
  Timing('',100000);
  for i:=1 to nt do s1:=GetDateTimeNew(ms);
  Timing('GetDateTimeNew: ',nt);
  {}
  Timing('',100000);
  for i:=1 to nt do s2:=GetDateTimeOld(ms);
  Timing('GetDateTimeOld: ',nt);
  {}
  if (ner=0)
  then writeln('Test success')
  else writeln(ner:1,' error(s) found');
  writeln;
  Cleanup;
 end;
 {
 Test 18.
 Dec/Hex/Oct/Bin constants.
 }
 procedure Test18;
 const x10=255; x16=$ff; x8=&377; x2=%11111111;
  var s:String; ner,n1,n2:Integer;
  procedure Cleanup;
  begin
   s:=''; ner:=0;
  end;
  procedure Test(nb,nd:Integer; s:String);
  begin
   writeln(nb,' ',nd,' ',s);
   if (nb<>nd) then ner:=ner+1;
  end;
 begin
  Cleanup;
  Success('Test18: Check $Hex &Oct %Bin constants.');
  {}
  Test($a,10,'$a');
  Test(x16,x10,'$ff');
  Test(x8,x10,'&377');
  Test(x2,x10,'%11111111');
  Test($FFFFffff,-1,'$FFFFFFFF');
  Test(&37777777777,-1,'&37777777777');
  Test(%11111111111111111111111111111111,-1,'%11111111111111111111111111111111');
  Test($7FFFffff,MaxInt,'$7FFFFFFF');
  Test(&17777777777,MaxInt,'&17777777777');
  Test(%01111111111111111111111111111111,MaxInt,'%01111111111111111111111111111111');
  n1:=255;
  writeln(n1,' %'+IntToStrBase(n1,2,0),' &'+IntToStrBase(n1,8,0),' $'+IntToStrBase(n1,16,0));
  n1:=MaxInt;
  writeln(n1,' %'+IntToStrBase(n1,2,0),' &'+IntToStrBase(n1,8,0),' $'+IntToStrBase(n1,16,0));
  s:='11111111';  writeln(s,' ',StrToIntBase(s,2,0):1);
  s:='%11111111'; writeln(s,' ',StrToIntBase(s,0,0):1);
  s:='377';       writeln(s,' ',StrToIntBase(s,8,0):1);
  s:='&377';      writeln(s,' ',StrToIntBase(s,0,0):1);
  s:='ff';        writeln(s,' ',StrToIntBase(s,16,0):1);
  s:='$ff';       writeln(s,' ',StrToIntBase(s,0,0):1);
  s:='255';       writeln(s,' ',StrToIntBase(s,10,0):1);
  {
  IsUnix                = true
  IsLinux               = true
  IsWindows             = false
  SizeOfPointer         = 8
  PathDelim             = /
  PathSep               = :
  DefaultSystemCodePage = 65001
  CP_NONE               = 65535
  CP_UTF8               = 65001
  CP_1251               = 1251
  CP_866                = 866
  AdaptFileNameMode     = 63
     c:\opt\Crw\Daq.exe = /opt/crw/daq.exe
     c:\opt\Crw\Daq.exe = /opt/crw/daq
           /opt/Crw/Daq = /opt/crw/daq
           /opt/Crw/Daq = /opt/crw/daq
  }
  writeln('IsUnix                = ',IsUnix:1);
  writeln('IsLinux               = ',IsLinux:1);
  writeln('IsWindows             = ',IsWindows:1);
  writeln('SizeOfPointer         = ',SizeOfPointer:1);
  writeln('PathDelim             = ',PathDelim);
  writeln('PathSep               = ',PathSep);
  writeln('DefaultSystemCodePage = ',DefaultSystemCodePage:1);
  writeln('CP_NONE               = ',CP_NONE:1);
  writeln('CP_UTF8               = ',CP_UTF8:1);
  writeln('CP_1251               = ',CP_1251:1);
  writeln('CP_866                = ',CP_866:1);
  writeln('AdaptFileNameMode     = ',AdaptFileNameMode(-1):1);
  s:='c:\opt\Crw\Daq.exe';
  writeln(s:21,                ' = ',AdaptFileName(s));
  writeln(s:21,                ' = ',AdaptExeFileName(s));
  s:='/opt/Crw/Daq';
  writeln(s:21,                ' = ',AdaptFileName(s));
  writeln(s:21,                ' = ',AdaptExeFileName(s));
  {}
  if (ner=0)
  then writeln('Test success')
  else writeln(ner:1,' error(s) found');
  writeln;
  Cleanup;
 end;
 {
 Test 19.
 Vector function - dynamic arrays.
 }
 procedure Test19;
  var s,head:String; ner,nt,nn,i,n,si,sr:Integer; iv,rv:TVector; ms,rr:Real;
  procedure Cleanup;
  begin
   s:=''; head:=''; ner:=0; iv:=ivec_init(0); rv:=rvec_init(0);
  end;
  function GetOsName:String;
  var s:String; code:Integer;
  begin
   s:='';
   if IsWindows then s:=RunSysCommandAsText('unix detectwindows','','',code,3000);
   if IsUnix then s:=Trim(RunSysCommandAsText('uname -snorm','','',code,3000));
   if IsUnix then s:=s+' '+Trim(RunSysCommandAsText('lsb_release -sd','','',code,3000));
   GetOsName:=Trim(s);
   s:='';
  end;
  function ivecSum(var ivec:TVector):Integer;
  var i:Integer; sum:Integer;
  begin
   sum:=0; for i:=0 to ivec_length(ivec)-1 do begin sum:=sum+ivec_get(ivec,i); end;
   ivecSum:=sum;
  end;
  function rvecSum(var rvec:TVector):Real;
  var i:Integer; sum:Real;
  begin
   sum:=0; for i:=0 to rvec_length(rvec)-1 do begin sum:=sum+rvec_get(rvec,i); end;
   rvecSum:=sum;
  end;
  procedure Test(cond:Boolean);
  begin
   writeln(cond:5,' - ','Test ',head);
   if not cond then ner:=ner+1;
  end;
  procedure Timing(who:String; nn:Integer);
  begin
   nt:=nn;
   if (who='') then ms:=msecnow else begin
    ms:=msecnow-ms;
    writeln(who,' ',ms*1000/nt:1:3,' mks/call,  ',ms*1e6/nt:1:3,' ns/call,  ',ms:1:0,' ms');
   end;
  end;
 begin
  Cleanup;
  Success('Test19: Vectors and RunSysCommand.');
  {
  Test Vector init/length/get/set.
  }
  n:=100;
  iv:=ivec_init(n); head:='ivec_init'; Test(ivec_length(iv)=n);
  rv:=rvec_init(n); head:='rvec_init'; Test(rvec_length(rv)=n);
  si:=0; for i:=0 to ivec_length(iv)-1 do begin ivec_set(iv,i,i+1); si:=si+(i+1); end;
  sr:=0; for i:=0 to rvec_length(rv)-1 do begin rvec_set(rv,i,i-1); sr:=sr+(i-1); end;
  head:='ivec_get/set(summ)'; Test(ivecSum(iv)=si);
  head:='rvec_get/set(summ)'; Test(rvecSum(rv)=sr);
  {
  Test Vector setlength.
  }
  ivec_setlength(iv,n+10); head:='ivec_setlength'; Test(ivec_length(iv)=n+10);
  rvec_setlength(rv,n+10); head:='rvec_setlength'; Test(rvec_length(rv)=n+10);
  head:='ivec_get/set(summ)'; Test(ivecSum(iv)=si);
  head:='rvec_get/set(summ)'; Test(rvecSum(rv)=sr);
  {
  Timing for get.
  }
  nn:=1000*1000;
  Timing('',nn);
  for i:=1 to nt do si:=ivec_get(iv,5);
  Timing('ivec_get',nt);
  Timing('',nn);
  for i:=1 to nt do rr:=rvec_get(rv,5);
  Timing('rvec_get',nt);
  {
  Timing for set.
  }
  nn:=1000*1000;
  Timing('',nn);
  for i:=1 to nt do ivec_set(iv,5,si);
  Timing('ivec_set',nt);
  Timing('',nn);
  for i:=1 to nt do rvec_set(rv,5,rr);
  Timing('rvec_set',nt);
  {
  Test Vector free.
  }
  ivec_free(iv); head:='ivec_free'; Test(ivec_length(iv)=0);
  rvec_free(rv); head:='rvec_free'; Test(rvec_length(rv)=0);
  {
  Test RunSysCommandAsText - call OS name detection command.
  }
  s:=GetOsName;
  head:='RunSysCommandAsText'; Test(s<>'');
  writeln('Test GetOsName: ',s);
  {}
  if (ner=0)
  then writeln('Test success')
  else writeln(ner:1,' error(s) found');
  writeln;
  Cleanup;
 end;
 {
 Test 20.
 Comparsion and arithmetic operations with Nan and Inf.
 }
 procedure Test20;
 var Head:String; ner:Integer;
  procedure Cleanup;
  begin
   Head:=''; ner:=0;
  end;
  // Condition check for expected result
  procedure NanTest(cond,expect:Boolean; comment:String);
  begin
   comment:=RightPad(comment,15,' ');
   if cond=expect
   then writeln(comment+': ',expect,' : passed')
   else begin
    ner:=ner+1;
    writeln(comment+': ',expect,' : failed!');
   end;
  end;
 begin
  Cleanup;
  writeln(StrFmt('%-15.9s','Condition')+': Expected : Result');
  // Comparsion operators:
  NanTest(_nan>=0,              false,'Nan>=0');
  NanTest(_nan>=1,              false,'Nan>=1');
  NanTest(_nan<=0,              false,'Nan<=0');
  NanTest(_nan<=1,              false,'Nan<=1');
  NanTest(_nan>0,               false,'Nan>0');
  NanTest(_nan>1,               false,'Nan>1');
  NanTest(_nan<0,               false,'Nan<0');
  NanTest(_nan<1,               false,'Nan<1');
  NanTest(_nan=0,               false,'Nan=0');
  NanTest(_nan=1,               false,'Nan=1');
  NanTest(_nan<>0,              true, 'Nan<>0');
  NanTest(_nan<>1,              true, 'Nan<>1');
  NanTest(_nan=_nan,            false,'Nan=Nan');
  NanTest(_nan<>_nan,           true, 'Nan<>Nan');
  NanTest(_nan>_nan,            false,'Nan>Nan');
  NanTest(_nan<_nan,            false,'Nan<Nan');
  // Comparsion functions:
  NanTest(ge(_nan,0),           false,'ge(Nan,0)');
  NanTest(ge(_nan,1),           false,'ge(Nan,1)');
  NanTest(le(_nan,0),           false,'le(Nan,0)');
  NanTest(le(_nan,1),           false,'le(Nan,1)');
  NanTest(gt(_nan,0),           false,'gt(Nan,0)');
  NanTest(gt(_nan,1),           false,'gt(Nan,1)');
  NanTest(lt(_nan,0),           false,'lt(Nan,0)');
  NanTest(lt(_nan,1),           false,'lt(Nan,1)');
  NanTest(eq(_nan,0),           false,'eq(Nan,0)');
  NanTest(eq(_nan,1),           false,'eq(Nan,1)');
  NanTest(ne(_nan,0),           true, 'ne(Nan,0)');
  NanTest(ne(_nan,1),           true, 'ne(Nan,1)');
  NanTest(ge(_nan,_nan),        false,'ge(Nan,Nan)');
  NanTest(le(_nan,_nan),        false,'le(Nan,Nan)');
  NanTest(eq(_nan,_nan),        false,'eq(Nan,Nan)');
  NanTest(ne(_nan,_nan),        true, 'ne(Nan,Nan)');
  NanTest(gt(_nan,_nan),        false,'gt(Nan,Nan)');
  NanTest(lt(_nan,_nan),        false,'lt(Nan,Nan)');
  // Arithmetic operations:
  NanTest(isNan(0+_nan),        true,'Nan=0+Nan');
  NanTest(isNan(1+_nan),        true,'Nan=1+Nan');
  NanTest(isNan(0-_nan),        true,'Nan=0-Nan');
  NanTest(isNan(1-_nan),        true,'Nan=1-Nan');
  NanTest(isNan(0*_nan),        true,'Nan=0*Nan');
  NanTest(isNan(1*_nan),        true,'Nan=1*Nan');
  NanTest(isNan(0/_nan),        true,'Nan=0/Nan');
  NanTest(isNan(1/_nan),        true,'Nan=1/Nan');
  NanTest(isNan(_nan/0),        true,'Nan=Nan/0');
  NanTest(isNan(_nan/1),        true,'Nan=Nan/1');
  NanTest(isNan(0/0),           true,'Nan=0/0');
  NanTest(isNan(0*_inf),        true,'Nan=0*Inf');
  NanTest(isNan(0*_minusinf),   true,'Nan=0*(-Inf)');
  NanTest(isNan(_inf/_inf),     true,'Nan=Inf/Inf');
  NanTest(isNan(_inf-_inf),     true,'Nan=Inf-Inf');
  NanTest(isNan(ln(-1)),        true,'Nan=ln(-1)');
  NanTest(isNan(sqrt(-1)),      true,'Nan=sqrt(-1)');
  NanTest(isInf(_inf+_inf),     true,'Inf=Inf+Inf');
  NanTest(isInf(1*_inf),        true,'Inf=1*Inf');
  NanTest(isInf(_inf*_inf),     true,'Inf=Inf*Inf');
  NanTest(isInf(1/0),           true,'Inf=1/0');
  NanTest(isInf(ln(0)),         true,'Inf=ln(0)');
  NanTest(_minusinf=(_minusinf-_inf),true,'-Inf=-Inf-Inf');
  NanTest(_minusinf=(1*_minusinf),   true,'-Inf=1*(-Inf)');
  NanTest(_minusinf=(_inf*_minusinf),true,'-Inf=Inf*(-Inf)');
  NanTest(0=(0/_inf),           true,'0=0/Inf');
  NanTest(0=(0/_minusinf),      true,'0=0/(-Inf)');
  NanTest(0=(1/_inf),           true,'0=1/Inf');
  NanTest(0=(1/_minusinf),      true,'0=1/(-Inf)');
  NanTest(1=(power(1,_nan)),    true,'1=1^Nan');
  NanTest(1=(power(_nan,0)),    true,'1=Nan^0');
  writeln('Error count = '+Str(ner));
  Cleanup;
 end;
 {
 Test 21.
 Word and phrase parsing.
 }
 procedure Test21;
 var src:String; ner:Integer;
  procedure Cleanup;
  begin
   src:=''; ner:=0;
  end;
  // Condition check for expected result
  procedure Test(comment,actual,expect:String);
  begin
   comment:=RightPad(comment,18,' ');
   if (actual=expect) then begin
    writeln(comment,': ',actual:17,' == ',RightPad(expect,17,' '):17,' : passed');
   end else begin
    writeln(comment,': ',actual:17,' != ',RightPad(expect,17,' '):17,' : failed!');
    ner:=ner+1;
   end;
  end;
  {
  function DupeString(s:String; n:Integer):String;
  var t:String; i:Integer;
  begin
   t:='';
   if (s<>'') then
   for i:=1 to n do t:=t+s;
   DupeString:=t;
   t:='';
  end;
  function DupeString(s:String; n:Integer):String;
  begin
   if (s='') then DupeString:='' else
   if (n>1)  then DupeString:=DupeString(s,n-1)+s else
   if (n=1)  then DupeString:=s else DupeString:='';
  end;
  function DupeString(s:String; n:Integer):String;
  var t:String; i,m:Integer;
  begin
   t:='';
   if (n>0) then
   if (s<>'') then
   if (n<6) then begin
    // Catenate for small n
    for i:=1 to n do t:=t+s;
   end else begin
    m:=(n div 2); // Recursion for big n
    t:=DupeString(s,n-m)+DupeString(s,m);
   end;
   DupeString:=t;
   t:='';
  end;
  }
  procedure TestDupeString;
  var i:Integer; s,t:String; vop,cop:Real; b:Boolean;
  begin
   s:=''; t:='';
   writeln('Test DupeString:');
   t:='ab';
   for i:=0 to 40 do begin
    vop:=vdpm_opcount;
    b:=cpu_start;
    s:=DupeString(t,i);
    cop:=cpu_clock;
    vop:=vdpm_opcount-vop;
    writeln(i:2,'  ',s:80,'  ',vop:1:0,' vm.ops, ',cop:1:0,' cpu.ops');
   end;
   s:=''; t:='';
  end;
 begin
  Cleanup;
  TestDupeString;
  writeln('Test word and phrase parsing:');
  writeln('WordDelims=',backslash_encode(WordDelims('')));
  writeln('PhraseQuotes=',PhraseQuotes(''));
  src:=' one "two three" four ';
  Test('WordCount',Str(WordCount(src)),Str(4));
  Test('ExtractWord 1',ExtractWord(1,src),'one');
  Test('ExtractWord 2',ExtractWord(2,src),'"two');
  Test('ExtractWord 3',ExtractWord(3,src),'three"');
  Test('ExtractWord 4',ExtractWord(4,src),'four');
  Test('ExtractWord 5',ExtractWord(5,src),'');
  Test('SkipWords 1',SkipWords(1,src),'"two three" four ');
  Test('SkipWords 2',SkipWords(2,src),'three" four ');
  Test('SkipWords 3',SkipWords(3,src),'four ');
  Test('SkipWords 4',SkipWords(4,src),'');
  Test('PhraseCount',Str(PhraseCount(src)),Str(3));
  Test('ExtractPhrase 1',ExtractPhrase(1,src),'one');
  Test('ExtractPhrase 2',ExtractPhrase(2,src),'two three');
  Test('ExtractPhrase 3',ExtractPhrase(3,src),'four');
  Test('ExtractPhrase 4',ExtractPhrase(4,src),'');
  Test('SkipPhrases 1',SkipPhrases(1,src),'"two three" four ');
  Test('SkipPhrases 2',SkipPhrases(2,src),'four ');
  Test('SkipPhrases 3',SkipPhrases(3,src),'');
  Test('PhraseToText',backslash_encode(PhraseListToTextLines(src)),backslash_encode('one'+EOL+'two three'+EOL+'four'+EOL));
  Test('CookieScanAlter 1',CookieScanAlter('UserName=Astra;PWD=Linux;','UserName;User;UID',Ord(';')),'Astra');
  Test('CookieScanAlter 2',CookieScanAlter('User=Astra;PWD=Linux;','UserName;User;UID',Ord(';')),'Astra');
  Test('CookieScanAlter 3',CookieScanAlter('UID=Astra;PWD=Linux;','UserName;User;UID',Ord(';')),'Astra');
  Test('CookieScanAlter 4',CookieScanAlter('UID=Astra;Password=Linux;','Password;PWD',Ord(';')),'Linux');
  Test('CookieScanAlter 5',CookieScanAlter('UID=Astra;PWD=Linux;','Password;PWD',Ord(';')),'Linux');
  Test('CookieScanAlter 6',CookieScanAlter('UID=Astra;PWD=Linux;','No;None',Ord(';')),'');
  writeln('Error count = '+Str(ner));
  Cleanup;
 end;
 {
 Benchmark of paramstr(listof ..).
 }
 procedure Test22;
 var s:String; ner,n,cl,tx:Integer; ms,dt,pf:Real;
  procedure Cleanup;
  begin
   s:=''; ner:=0;
  end;
  procedure TestStrFuncSub;
  var s:String; wx,er:Integer;
   procedure ChkStrFS(m,a,b:String; eq:Boolean);
   var fl:Boolean;
   begin
    fl:=(a=b);
    if (Ord(fl)=Ord(eq))
    then writeln(RightPad(m,wx,' '),'  ',RightPad(a,wx,' '),'  ',RightPad(b,wx,' '),'  ',fl:5,'  ',eq:5,'  GOOD')
    else writeln(RightPad(m,wx,' '),'  ',RightPad(a,wx,' '),'  ',RightPad(b,wx,' '),'  ',fl:5,'  ',eq:5,'  FAIL');
   end;
   procedure ChkStrFB(m:String; a,b,eq:Boolean);
   var fl:Boolean;
   begin
    fl:=(Ord(a)=Ord(b));
    if (Ord(fl)=Ord(eq))
    then writeln(RightPad(m,wx,' '),'  ',a:5,'  ',b:5,'  ',fl:5,'  ',eq:5,'  GOOD')
    else writeln(RightPad(m,wx,' '),'  ',a:5,'  ',b:5,'  ',fl:5,'  ',eq:5,'  FAIL');
    if (Ord(fl)<>Ord(eq)) then er:=er+1;
   end;
  begin
   s:='';
   wx:=15;  er:=0;
   writeln('Test StringFunctions Lrft/RightStr etc:');
   s:='BeginBodyEnd';
   ChkStrFS('TailStr',copy(s,-1),'',True);
   ChkStrFS('TailStr',TailStr(s,-1),'',True);
   ChkStrFS('TailStr',TailStr(s,20),'',True);
   ChkStrFS('TailStr',TailStr(s,10),'End',True);
   ChkStrFS('LeftStr',LeftStr(s,5),'Begin',True);
   ChkStrFS('LeftStr',LeftStr(s,30),s,True);
   ChkStrFS('RightStr',RightStr(s,3),'End',True);
   ChkStrFS('RightStr',RightStr(s,30),s,True);
   ChkStrFS('StrAheadOf',StrAheadOf(s,'o'),'BeginB',True);
   ChkStrFS('StrAheadOf',StrAheadOf(s,'x'),'',True);
   ChkStrFS('StrAfterOf',StrAfterOf(s,'o'),'dyEnd',True);
   ChkStrFS('StrAfterOf',StrAfterOf(s,'x'),s,True);
   ChkStrFB('IsEmptyStr',IsEmptyStr('    '),True,True);
   ChkStrFB('IsEmptyStr',IsEmptyStr('Body'),False,True);
   ChkStrFB('IsNonEmptyStr',IsNonEmptyStr('    '),False,True);
   ChkStrFB('IsNonEmptyStr',IsNonEmptyStr('Body'),True,True);
   ChkStrFB('ContainsStr',ContainsStr(s,'Body'),True,True);
   ChkStrFB('ContainsStr',ContainsStr(s,'BodY'),False,True);
   ChkStrFB('StartsStr',StartsStr('Begin',s),True,True);
   ChkStrFB('StartsStr',StartsStr('BegiN',s),False,True);
   ChkStrFB('EndsStr',EndsStr('End',s),True,True);
   ChkStrFB('EndsStr',EndsStr('EnD',s),False,True); 
   ChkStrFB('ContainsText',ContainsText(s,'BODY'),True,True);
   ChkStrFB('ContainsText',ContainsText(s,'Bodg'),False,True);
   ChkStrFB('StartsText',StartsText('BEGIN',s),True,True);
   ChkStrFB('StartsText',StartsText('Begim',s),False,True);
   ChkStrFB('EndsText',EndsText('END',s),True,True);
   ChkStrFB('EndsText',EndsText('Emd',s),False,True);
   writeln(er:1,' error(s) found.');
   s:='';
  end;
  procedure TestBufferRW;
  var fname,buff:string;
  begin
   fname:=''; buff:='';
   writeln('Test ReadFileToBuffer/WriteBufferToFile:');
   fname:=AdaptFileName(ExpEnv('$CRW_DAQ_SYS_TMP_DIR/mymodules.txt'));
   if FileExists(fname) then bNul(FileErase(fname));
   buff:=ParamStr('ListOf modules');
   //writeln(buff);
   if WriteBufferToFile(fname,buff,0)>0
   then writeln('Luck write '+fname)
   else writeln('Fail write '+fname);
   if fileexists(fname) then begin
    buff:=ReadFileToBuffer(fname,0,0); // Read all file
    if (buff<>'')
    then writeln('File readback:',EOL,buff)
    else writeln('Error read file '+fname);
    writeln('File properties:',EOL,GetFileProperties(fname,''));
   end;
   fname:=''; buff:='';
  end;
  procedure TestDetectBlob;
  var blob,what:String;
  begin
   blob:=''; what:='';
   writeln('Test DetectBlobImageType');
   blob:=ReadFileToBuffer(AdaptFileName('c:\opt\crwkit\add\png\dim.png'),0,0);
   //what:=ParamStr('DetectBlobImageType b64 '+base64_encode(blob));
   what:=db_DetectBlobImageType(blob);
   if IsSameText(what,'png')
   then Success('Detected PNG blob.')
   else Problem('Wrong detect blob.'+' '+what);
   blob:=''; what:='';
  end;
  procedure TestSysLog(severity:Integer);
  var code,leng:Integer; name:String;
  begin
   name:='';
   name:=ParamStr('SysLogSeverityName '+Str(severity));
   code:=Val(ParamStr('SysLogSeverityCode '+name));
   writeln('Имя уровня значимости ',name);
   writeln('Код уровня значимости ',code:1);
   if SysLogNotable(severity)
   then writeln('Уровень ',severity:1,' ЗНАЧИМЫЙ')
   else writeln('Уровень ',severity:1,' НЕ_ЗНАЧИМЫЙ');
   leng:=SysLogNote(severity,DevName+'/TestSysLog - Это тестовая запись в Журнал.');
   if (leng>0)
   then writeln('Событие записано в журнал')
   else writeln('Событие проигнорировано');
   name:='';
  end;
 begin
  Cleanup;
  {}
  TestBufferRW;
  {}
  TestDetectBlob;
  {}
  TestStrFuncSub;
  {}
  writeln('Test ParamStr(ListOf ..):');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cl:=StringToColor('aqua'); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('StringToColor takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cl:=Val(ParamStr('listof colors where name=aqua,format=num')); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('ListOf colors takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  tx:=text_new;
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cl:=pidlist(tx); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('pidlist takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  FreeAndZero(tx);
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin s:=ParamStr('listof pids'); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('listof pids (all) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin s:=ParamStr('listof pids where pid='+Str(getpid)); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('listof pids (pid) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin s:=ParamStr('listof pids where name='+AdaptFileName('crwdaq.exe')); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('listof pids (name) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  writeln('Test SysLog:');
  TestSysLog(5);
  TestSysLog(15);
  TestSysLog(25);
  {}
  Cleanup;
 end;
 {
 Benchmark of inrange,ensurerange etc.
 }
 procedure Test23;
 var s:String; ner,n,ix,ia,ib:Integer; ms,dt,pf,rx,ra,rb:Real; cond:Boolean;
  procedure Cleanup;
  begin
   s:=''; ner:=0;
  end;
  procedure CheckIt(note:String; cond,expect:Boolean);
  begin
   if (cond=expect) then begin
    writeln(note+': succeed');
   end else begin
    writeln(note+': failure');
    ner:=ner+1;
   end;
  end;
 begin
  Cleanup;
  {}
  ix:=15; ia:=10; ib:=20;
  rx:=15; ra:=10; rb:=20;
  CheckIt('InRange(i,i,i)',InRange(ix,ia,ib),true);
  CheckIt('InRange(r,i,i)',InRange(rx,ia,ib),true);
  CheckIt('InRange(i,r,i)',InRange(ix,ra,ib),true);
  CheckIt('InRange(r,r,i)',InRange(rx,ra,ib),true);
  CheckIt('InRange(i,i,r)',InRange(ix,ia,rb),true);
  CheckIt('InRange(r,i,r)',InRange(rx,ia,rb),true);
  CheckIt('InRange(i,r,r)',InRange(ix,ra,rb),true);
  CheckIt('InRange(r,r,r)',InRange(rx,ra,rb),true);
  CheckIt('EnsureRange(i,i,i)',EnsureRange(ix,ia,ib)=ix,true);
  CheckIt('EnsureRange(r,i,i)',EnsureRange(rx,ia,ib)=ix,true);
  CheckIt('EnsureRange(i,r,i)',EnsureRange(ix,ra,ib)=ix,true);
  CheckIt('EnsureRange(r,r,i)',EnsureRange(rx,ra,ib)=ix,true);
  CheckIt('EnsureRange(i,i,r)',EnsureRange(ix,ia,rb)=ix,true);
  CheckIt('EnsureRange(r,i,r)',EnsureRange(rx,ia,rb)=ix,true);
  CheckIt('EnsureRange(i,r,r)',EnsureRange(ix,ra,rb)=ix,true);
  CheckIt('EnsureRange(r,r,r)',EnsureRange(rx,ra,rb)=ix,true);
  CheckIt('iEnsureRange(i,i,i)',iEnsureRange(ix,ia,ib)=ix,true);
  ix:=0; rx:=0;
  CheckIt('InRange(i,i,i)',InRange(ix,ia,ib),false);
  CheckIt('InRange(r,i,i)',InRange(rx,ia,ib),false);
  CheckIt('InRange(i,r,i)',InRange(ix,ra,ib),false);
  CheckIt('InRange(r,r,i)',InRange(rx,ra,ib),false);
  CheckIt('InRange(i,i,r)',InRange(ix,ia,rb),false);
  CheckIt('InRange(r,i,r)',InRange(rx,ia,rb),false);
  CheckIt('InRange(i,r,r)',InRange(ix,ra,rb),false);
  CheckIt('InRange(r,r,r)',InRange(rx,ra,rb),false);
  CheckIt('EnsureRange(i,i,i)',EnsureRange(ix,ia,ib)=ix,false);
  CheckIt('EnsureRange(r,i,i)',EnsureRange(rx,ia,ib)=ix,false);
  CheckIt('EnsureRange(i,r,i)',EnsureRange(ix,ra,ib)=ix,false);
  CheckIt('EnsureRange(r,r,i)',EnsureRange(rx,ra,ib)=ix,false);
  CheckIt('EnsureRange(i,i,r)',EnsureRange(ix,ia,rb)=ix,false);
  CheckIt('EnsureRange(r,i,r)',EnsureRange(rx,ia,rb)=ix,false);
  CheckIt('EnsureRange(i,r,r)',EnsureRange(ix,ra,rb)=ix,false);
  CheckIt('EnsureRange(r,r,r)',EnsureRange(rx,ra,rb)=ix,false);
  CheckIt('iEnsureRange(i,i,i)',iEnsureRange(ix,ia,ib)=ix,false);
  {}
  rx:=1; ra:=0; rb:=pi; ix:=1; ia:=0; ix:=3;
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cond:=InRange(rx,ra,rb); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('InRange(r,r,r) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cond:=(rx>=ra) and (rx<=rb); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('If/InRange(r,r,r) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cond:=InRange(ix,ia,ib); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('InRange(i,i,i) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin cond:=(ix>=ia) and (ix<=ib); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('If/InRange(i,i,i) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin rx:=rEnsureRange(rx,ra,rb); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('rEnsureRange(r,r,r) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin ix:=iEnsureRange(ix,ia,ib); n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('iEnsureRange(i,i,i) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin if (ix<ia) then ix:=ia else if (ix>ib) then ix:=ib; n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('If/EnsureRange(i,i,i) takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  n:=0; dt:=200; ms:=msecnow;
  while (msecnow-ms<=dt) do begin n:=n+1; end;
  ms:=msecnow-ms; pf:=1e3*ms/n;
  writeln('Empty loop takes ',ms:1:3,' ms, ',pf:1:3,' mks/op');
  {}
  writeln(ner:1,' error(s) found');
  {}
  Cleanup;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearDbLibrary;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitDbLibrary;
  PostMortalWill:='@system @async @compile device '+DevName+EOL
   +'@system @async @run -hide unix tooltip-notifier text "%date%-%time% - %CRW_DAQ_SYS_TITLE%: Failure on Device %DeviceName%." '
   +'delay 60000 bkColor red fontSize 14 font "PT Mono Bold" ico error.ico audio warning.wav'+EOL
   +'&CronSrv @Speak Device '+DevName+' failure.';
  UnixTooltipNotifier('text "Привет мой друг." delay 5000 audio help.wav');
  FreeAndZero_Verbosity:=1+2+4+8+16;
  TestNumber:=0;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeDbLibrary;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollDbLibrary then PollDbLibrary;
  case TestNumber of
   -1: TestMinus1;
   -2 :TestMinus2;
   -3: TestMinus3;
   -4: TestMinus4;
   +1: if SysTimer_Pulse(1000)>0 then Test1;
   +2: if SysTimer_Pulse(1000)>0 then Test2;
   +3: if SysTimer_Pulse(1000)>0 then Test3;
   +4: if SysTimer_Pulse(1000)>0 then Test4;
   +5: if SysTimer_Pulse(1000)>0 then Test5;
   +6: if SysTimer_Pulse(1000)>0 then Test6;
   +7: if SysTimer_Pulse(1000)>0 then Test7;
   +8: if SysTimer_Pulse(3000)>0 then Test8;
   +9: if SysTimer_Pulse(3000)>0 then Test9;
   10: if SysTimer_Pulse(3000)>0 then Test10;
   11: if SysTimer_Pulse(3000)>0 then Test11;
   12: if SysTimer_Pulse(5000)>0 then Test12;
   13: if SysTimer_Pulse(5000)>0 then Test12;
   14: if SysTimer_Pulse(5000)>0 then Test12;
   15: if SysTimer_Pulse(5000)>0 then Test15;
   16: if SysTimer_Pulse(5000)>0 then Test16;
   17: if SysTimer_Pulse(5000)>0 then Test17;
   18: begin Test18; TestNumber:=0; end;
   19: begin Test19; TestNumber:=0; end;
   20: begin Test20; TestNumber:=0; end;
   21: begin Test21; TestNumber:=0; end;
   22: begin Test22; TestNumber:=0; end;
   23: begin Test23; TestNumber:=0; end;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Test 1
   }
   if IsSameText(cmd,'@Test') then begin
    TestNumber:=iEvalDef(ExtractWord(1,arg),0);
    Success(cmd+'='+Str(TestNumber));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
