{
 Виноградов 28-10-2008
}
program SPEG_CTRL;
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }

 snd_Click         = 'Click'; { Sound on button click            }
 snd_Fails         = 'Fails'; { Sound on operation failure       }
 snd_Alert1        = 'Alert1';{ Sound on 1st alert level         }
 snd_Alert2        = 'Alert2';{ Sound on 2nd alert level         }

 updEmpty          = -1e300;  { Marker for empty update          }
 nPs               = 2;      { Number of Pressure sensors       }
 nTs               = 1;       { Number of Temperature sensors    }
 nHeats            = 1;       { Number of heats                  }

 wdtPOWx           = 500;     {для POW ms}
 {
  Блокировки H
 }
 blk_Heat1_TMAX     = 0;      { Block HEAT1 by TMAX }
 blk_Heat1_PMAX     = 1;      { Block HEAT1 by PMAX }
 {
  сообщения
 }
 speak_HEAT1   = 0;      { Speak BS1                 }


 aiTCJ    = 3;      { TCJ input index                  }

var
 s                 : String;  { Temporary                        }
 i                 : Integer; { Temporary                        }
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 StdIn_Line        : String;  { Temporary variable               }
 r                 : real;

 tagD              : array[1..nPs] of Integer; {Sensors     tags }
 tagDTYP           : array[1..nPs] of Integer; {тип датчика}
 tagDSHFmv         : array[1..nPs] of Integer; {смещение в нуль}
 tagDZEROmv        : array[1..nPs] of Integer; {значение выхода при нулевом давлении}
 tagP              : array[1..nPs] of Integer; {Pressure    tags }

 tagT              : array[1..nTs] of Integer; {Temperature tags }
 tagTCJ            : Integer;                     {Temperature tags }

 tagHeat           : array[1..nHeats] of record
  Ts               : Integer; { температура стабилизации         }
  BT               : Integer; { кнопка                           }
  ENB              : Integer; { Enabled                          }
  POW              : Integer; { Power on/off                     }
  SSR              : Integer; { SSR on/off                       }
  PER              : Integer; { period, ms                       }
  Q                : Integer; { Power, % of max                  }
  QMAX             : Integer; { max Power, %                     }
  Q1               : Integer; { начальный разогрев               }
  Q2               : Integer; { медленный разогрев в интервале DT}
  DT               : Integer; { интервал медленного разогрева    }
  BLK              : Integer; { блокировка-состояние             }
  BlkTenb          : Integer; { блокировка-разрешение            }
  BlkTmax          : Integer; { блокировка-значение              }
  BlkPenb          : Integer; { блокировка-разрешение            }
  BlkPmax          : Integer; { блокировка-значение              }
 end;
 lastBLK           : array[1..nHeats] of integer;{ блокировка  }
 wdtPOW            : array[1..nHeats] of real;   { ms  }
 wdtSSR            : array[1..nHeats] of real;   { ms  }
 HeatBase          : array[1..nHeats] of real;   { Heat base time  }

 tagSpeakSpd       : Integer; { слов в минуту              }
 tagSpeakVol       : Integer; { громкость              }
 tagSpeakPit       : Integer; { тон              }
 SpdCode           : integer;
 VolCode           : integer;
 PitCode           : integer;

 tagSpeakOpt       : Integer; {           }
 tagSpeakHeat1enb  : Integer; { разрешить/запретить             }
 tagSpeakHeat1per  : Integer; { период                           }

 lastSpeakSpd      : integer;
 lastSpeakVol      : integer;
 lastSpeakPit      : integer;

 tagBlkOpt         : Integer; {           }

 tagLoadParams     : Integer; { Load control parameters          }
 tagSaveParams     : Integer; { Save control parameters          }

 lastt             : real;

 wdt               : record;
  SpeakHeat1       : real;
 end;

 y                 : real;

 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,p,sect:Integer; b:Boolean;
 begin
  sect:=ReadIniSection(text_New,12,DaqFileRef(AdaptFileName(ReadIni('ProgramSource')),'.pas'),'[@Help]');
  for i:=0 to text_NumLn(sect)-1 do begin
   if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
   if AllowEcho then b:=echo(devname+' : '+Copy(text_GetLn(sect,i),p));
   Success(Copy(text_GetLn(sect,i),p));
  end;
  b:=text_Free(sect);
  if AllowEcho then b:=WinSelect(ParamStr('MainConsole'));
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Replace all "a" to "b" in string "s".
 Flag = 1 - Replace All, 2 - Not Case sensitive
 }
 function StrReplace(s,a,b:String; Flags:Integer):String;
 var p:Integer;
 begin
  if iAnd(Flags,1)=0
  then p:=Pos(a,s)
  else p:=Pos(UpCaseStr(a),UpCaseStr(s));
  if p=0 then StrReplace:=s else begin
   if iAnd(Flags,2)=0
   then StrReplace:=Copy(s,1,p-1)+b+Copy(s,p+Length(a))
   else StrReplace:=Copy(s,1,p-1)+b+StrReplace(Copy(s,p+Length(a)),a,b,Flags);
  end;
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+CRLF)>0;
  end;
 end;
 {
 Процедура установки и сброса бита
 }
 procedure SetBitTag(tag,mask:integer; on:boolean);
 var
  b : boolean;
  k : integer;
 begin
  k:=iand(igettag(tag),inot(mask));
  k:=k+mask*ord(on);
  b:=isettag(tag,k);
 end;
 {
 Функция получения бита
 }
 function GetBitTag(tag,mask:integer): integer;
 var
  b:boolean;
 begin
  b:=iand(igettag(tag),mask)>0;
  GetBitTag:=ord(b);
 end;
 {
 Update Analog Output n: put (t,y) event.
 }
 procedure UpdateAo(n:Integer; t,y:Real);
 var b:Boolean;
 begin
  if RefAo(n)<>0 then b:=putao(n,t,y);
 end;
 {
 Check if refresh needed.
 }
 function ShouldRefresh(var upd:Real; val:Real):Integer;
 begin
  ShouldRefresh:=0;
  if upd<>val then begin
   ShouldRefresh:=1;
   upd:=val;
  end;
 end;
 {
 Thread safe function to get last point Y of curve.
 }
 function crvGetLastY(ref:Integer):Real;
 var b:Boolean;
 begin
  b:=CrvLock(ref);
  crvGetLastY:=crvY(ref,crvLen(ref));
  b:=CrvUnlock(ref);
 end;
 {
 Inverted calibration
 }
 function invCalibr(n:Integer; y,z,a,b:Real):Real;
 const MaxIter=128;
 var i,k,ia,ib,it:Integer; t:Real;
 begin
  k:=0;
  if a>b then begin t:=a; a:=b; b:=t; end;
  ia:=Sign(Calibr(n,a,z)-y); k:=k+1;
  if ia=0 then t:=a else begin
   ib:=Sign(Calibr(n,b,z)-y); k:=k+1;
   if ib=0 then t:=b else begin
    i:=0;
    while i<MaxIter do begin
     t:=a+(b-a)*0.5;
     it:=Sign(Calibr(n,t,z)-y); k:=k+1;
     if t=a then i:=MaxIter else
     if t=b then i:=MaxIter else
     if it=0 then i:=MaxIter else
     if it*ia<0 then begin b:=t; ib:=it; end else
     if it*ib<0 then begin a:=t; ia:=it; end else begin t:=_NaN; i:=MaxIter; end;
     i:=i+1;
    end;
   end;
  end;
  invCalibr:=t;
 end;
 {
 Readout DO state, i.e. I7053 data
 }
 procedure DioReadout;
 begin
  {
  Readout state
  }
 end;
 {
 DIO control, i.e. calculate bits of 7043 control word
 }
 procedure DioControl;
 var b:Boolean; i,cw:Integer;
  procedure putcw1(tag,ncw: integer);
  begin
   cw:=0;
   cw:=iOr(cw, iShift(Ord(GetBitTag(tag,1)), 0));
   b:=PutDo(ncw,time,cw);
  end;

  procedure putcw2(tag,ncw: integer);
  begin
   cw:=0;
   b:=(GetBitTag(tag,1)=1);
   cw:=iOr(cw, iShift(Ord(b), 0));
   cw:=iOr(cw, iShift(Ord(not b), 1));
   b:=PutDo(ncw,time,cw);
  end;

  procedure putPOWcw(nPOW,ncw: integer);
  begin
   if wdtPOW[nPOW]>0 then if (msecnow-wdtPOW[nPOW])>wdtPOWx then wdtPOW[nPOW]:=0;
   if wdtPOW[nPOW]>0 then cw:=0;
   if wdtPOW[nPOW]=0 then begin
    cw:=0;
    cw:=iOr(cw, iShift(Ord(igettag(tagHeat[nPOW].POW)), 0));
    cw:=iOr(cw, iShift(Ord(igettag(tagHeat[nPOW].POW)), 1));
    b:=PutDo(ncw,time,cw); // реле срабатывает только при SSR=0
   end;
  end;

  procedure putSSRcw(nSSR,ncw: integer);
  begin
   cw:=0;
   if wdtPOW[nSSR]=0 then cw:=iOr(cw, iShift(Ord(igettag(tagHeat[nSSR].SSR)), 0));
   b:=PutDo(ncw,time,cw);
  end;

 begin
  for i:=1 to nPs do UpdateAo(i-1,time,rGetTag(tagDSHFmv[i]));

  {Формирование кривых для нагревателей}

  for i:=1 to nHeats do if igettag(tagHeat[i].BLK)<>lastBLK[i] then begin
   wdtSSR[i]:=msecnow; 
   wdtPOW[i]:=msecnow; 
   lastBLK[i]:=igettag(tagHeat[i].BLK);
  end;
  putPOWcw(1,1);
  putSSRcw(1,0);
 end;

 {
 Calculate time since tag switch on
 }
 procedure CalcWdtTime(tag:Integer; var wdt:Real);
 begin
  if iGetTag(tag)<>0 then begin
   if wdt<=0 then wdt:=msecnow;
  end else begin
   wdt:=0;
  end;
 end;
 {
 Calculate time since tag switch on
 }
 function GetWdtTime(wdt:Real):Real;
 begin
  if wdt>0 then GetWdtTime:=msecnow-wdt else GetWdtTime:=0;
 end;
 {
 ------------------------------------------------
 Device control
 ------------------------------------------------
 }
 procedure DevControl;
 const MaxPeriods = 10000;
 var b,blk:Boolean; i,n,Hit,nBlocks,CtrlCmd:Integer; Qi,r,tp,Period:Real;
 begin
  {
  Мощность (электромагнитное реле)
  }
  for i:=1 to nHeats do begin
   b:=iSetTag(tagHeat[i].POW,GetBitTag(tagHeat[i].BT,1)); 
   if iGetTag(tagHeat[i].ENB)=0 then b:=iSetTag(tagHeat[i].POW,0);
  end;
  {
  Блокировка нагревателей по TMAX
  }
  for i:=1 to nHeats do begin
   b:=isettag(tagHeat[i].BLK,0);
   if ((i=1) and (iAnd(iGetTag(tagBlkOpt),iShift(1,blk_Heat1_TMAX))<>0)) then
   begin
    if rgettag(tagT[i])>rgettag(tagHeat[i].BlkTmax) then begin
     b:=isettag(tagHeat[i].BLK,1);
     b:=iSetTag(tagHeat[i].POW,0);
    end;
   end;
  end;
  {
  Блокировка нагревателей по PMAX
  }
  if igettag(tagHeat[1].BLK)=0 then begin
   if iAnd(iGetTag(tagBlkOpt),iShift(1,blk_Heat1_PMAX))<>0 then 
   if rgettag(tagP[1])>rgettag(tagHeat[1].BlkPmax) then begin
    b:=isettag(tagHeat[1].BLK,1);
    b:=iSetTag(tagHeat[1].POW,0);
   end;
  end;
  {
  Формирование меандра для SSR
  }
  for i:=1 to nHeats do begin
   Hit:=0;
   if iGetTag(tagHeat[i].ENB)<>0 then if iGetTag(tagHeat[i].POW)<>0 then begin
    Period:=Max(1,iGetTag(tagHeat[i].PER));
    if msecnow>HeatBase[i]+MaxPeriods*Period then HeatBase[i]:=msecnow;
    tp:=(msecnow-HeatBase[i])/Max(1,iGetTag(tagHeat[i].PER));

    if rgettag(tagT[i])<(rgettag(tagHeat[i].Ts)-rgettag(tagHeat[i].DT)) then Qi:=rgettag(tagHeat[i].Q1) else 
    if rgettag(tagT[i])<rgettag(tagHeat[i].Ts) then Qi:=rgettag(tagHeat[i].Q2) else Qi:=0;

    Qi:=Min(Qi,rGetTag(tagHeat[i].QMAX));
    b:=rsettag(tagHeat[i].Q,Qi);
//    if Qi=0 then b:=iSetTag(tagHeat[i].POW,0); {!!!}
    Qi:=Max(0,Min(1,0.01*Max(0,Min(100,Qi))));

    Hit:=Ord(Frac(tp)<Qi);
//  writeln(i, Qi, tp, Hit);
   end;
   b:=iSetTag(tagHeat[i].SSR,Hit);
  end;
  {
  Состояние кнопок HeatBt
  }
  for i:=1 to nHeats do begin
   b:=igettag(tagHeat[i].SSR)=1;
   SetBitTag(tagHeat[i].BT,2,b);
   b:=igettag(tagHeat[i].BLK)=1;
   SetBitTag(tagHeat[i].BT,4,b);
   if b then begin
    SetBitTag(tagHeat[i].BT,2,false);
    b:=iSetTag(tagHeat[i].POW,0);
   end;
  end;
  {
  Индикация + сообщения
  }
  if true then begin
   if iAnd(iGetTag(tagSpeakOpt),iShift(1,speak_HEAT1))<>0 then b:=isettag(tagSpeakHeat1enb,1)
   else b:=isettag(tagSpeakHeat1enb,0);
   {
   Calculate watchdog times by tags
   }
   if igettag(tagHeat[1].blk)=1 then CalcWdtTime(tagSpeakHeat1enb,wdt.SpeakHeat1)
   else wdt.SpeakHeat1:=0;
   if GetWdtTime(wdt.SpeakHeat1)>=(rgettag(tagSpeakHeat1per)*1000) then begin
    if rgettag(tagT[1])>rgettag(tagHeat[1].blkTmax) then Speak('Блокировка БС1 по температуре');
    if rgettag(tagP[1])>rgettag(tagHeat[1].blkPmax) then Speak('Блокировка БС1 по ДЭ11');
    wdt.SpeakHeat1:=0;
   end;
 
  end;
 end;
 {
 Save [CustomParameters]
 }
 procedure SaveCustom;
 var f:String; i:Integer;
  procedure SaveTag(tag:Integer);
  begin
   if TypeTag(tag)=1 then Writeln(NameTag(tag),' = ',Str(iGetTag(tag)));
   if TypeTag(tag)=2 then Writeln(NameTag(tag),' = ',Str(rGetTag(tag)));
   if TypeTag(tag)=3 then Writeln(NameTag(tag),' = ',sGetTag(tag));
  end;
 begin
  f:=AdaptFileName(ReadIni('CustomFile'));
  if Length(f)>0 then begin
   i:=Rewrite(DaqFileRef(f,''));
   writeln(ReadIni('CustomSection'));

   SaveTag(tagSpeakSpd);
   SaveTag(tagSpeakVol);
   SaveTag(tagSpeakPit);

   SaveTag(tagSpeakOPt);
   SaveTag(tagBlkOPt);

   for i:=1 to nHeats do begin
    SaveTag(tagHeat[i].Qmax);
    SaveTag(tagHeat[i].Q1);
    SaveTag(tagHeat[i].Q2);
    SaveTag(tagHeat[i].DT);
    SaveTag(tagHeat[i].Per);
   end;

   for i:=1 to nHeats do begin
    SaveTag(tagHeat[i].BlkTenb);
    SaveTag(tagHeat[i].BlkTmax);
    SaveTag(tagHeat[i].BlkPenb);
    SaveTag(tagHeat[i].BlkPmax);
   end;

   for i:=1 to nPs do SaveTag(tagDTYP[i]);
   for i:=1 to nPs do SaveTag(tagDSHFmv[i]);

   i:=Append('');
  end;
  f:='';
 end;
 {
 Load [CustomParameters]
 }
 procedure LoadCustom;
 var f:String;
  procedure LoadTag(tag:Integer);
  var s:String;
  begin
   s:=ReadIni(f+' '+NameTag(tag));
   if Length(s)>0 then begin
    if TypeTag(tag)=1 then b:=iSetTag(tag,Val(s));
    if TypeTag(tag)=2 then b:=rSetTag(tag,rVal(s));
    if TypeTag(tag)=3 then b:=sSetTag(tag,s);
   end;
  end;
 begin
  f:=AdaptFileName(ReadIni('CustomFile'));
  if Length(f)>0 then begin
   f:=DaqFileRef(f,'')+' '+ReadIni('CustomSection');

   LoadTag(tagSpeakSpd);
   LoadTag(tagSpeakVol);
   LoadTag(tagSpeakPit);

   LoadTag(tagSpeakOpt);
   LoadTag(tagBlkOPt);

   for i:=1 to nHeats do begin
    LoadTag(tagHeat[i].Qmax);
    LoadTag(tagHeat[i].Q1);
    LoadTag(tagHeat[i].Q2);
    LoadTag(tagHeat[i].DT);
    LoadTag(tagHeat[i].Per);
   end;

   for i:=1 to nHeats do begin
    LoadTag(tagHeat[i].BlkTenb);
    LoadTag(tagHeat[i].BlkTmax);
    LoadTag(tagHeat[i].BlkPenb);
    LoadTag(tagHeat[i].BlkPmax);
   end;

   for i:=1 to nPs do LoadTag(tagDTYP[i]);
   for i:=1 to nPs do LoadTag(tagDSHFmv[i]);

  end;
  f:='';
 end;
 {
 Finalize SPEG system.
 }
 procedure SPEG_Free;
 begin
  SaveCustom;
 end;
 {
 Initialize SPEG system.
 }
 procedure SPEG_Init;
 var i:Integer; b:Boolean;
 begin
  {
   Timer
  }
  writeln('Standard timer quantum is', GetClockRes(0),'ms');
  writeln('Maximal timer quantum is', GetClockRes(1),'ms');
  writeln('Minimal timer quantum is', GetClockRes(2),'ms');
  writeln('Actual timer quantum is', GetClockRes(3),'ms');
  writeln('Now set clock about 1ms (1000Hz)');
  if SetClockRes(+1)=0 then writeln('Error');
  writeln('Actual timer quantum is', GetClockRes(3),'ms');
  writeln('Now disable fast clock, go back to standard value.');
  if SetClockRes(-1)=0 then writeln('Error');
  writeln('Actual timer quantum is', GetClockRes(3),'ms');
  {
  Initialize tags...
  }
  for i:=1 to nPs do begin
   InitTag(tagD[i],StrReplace(ReadIni('tagD'),'##',Str(i),3),1);
   InitTag(tagDTYP[i],StrReplace(ReadIni('tagDTYP'),'##',Str(i),3),1);
   InitTag(tagDSHFmv[i],StrReplace(ReadIni('tagDSHFmv'),'##',Str(i),3),2);
   InitTag(tagDZEROmv[i],StrReplace(ReadIni('tagDZEROmv'),'##',Str(i),3),2);
   InitTag(tagP[i],StrReplace(ReadIni('tagP'),'##',Str(i),3),2);
  end;

  for i:=1 to nTs do InitTag(tagT[i],StrReplace(ReadIni('tagT'),'##',Str(i),3),2);
  InitTag(tagTCJ,   ReadIni('tagTCJ'),   2);

  for i:=1 to nHeats do begin
   InitTag(tagHeat[i].Ts,  StrReplace(ReadIni('tagHeatTs'),  '##',Str(i),3), 2);
   InitTag(tagHeat[i].BT,  StrReplace(ReadIni('tagHeatBT'),  '##',Str(i),3), 1);
   InitTag(tagHeat[i].ENB, StrReplace(ReadIni('tagHeatENB'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].POW, StrReplace(ReadIni('tagHeatPOW'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].SSR, StrReplace(ReadIni('tagHeatSSR'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].PER, StrReplace(ReadIni('tagHeatPER'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].Q,   StrReplace(ReadIni('tagHeatQ'),   '##',Str(i),3), 2);
   InitTag(tagHeat[i].QMAX,StrReplace(ReadIni('tagHeatQMAX'),'##',Str(i),3), 2);
   InitTag(tagHeat[i].Q1,  StrReplace(ReadIni('tagHeatQ1'),  '##',Str(i),3), 2);
   InitTag(tagHeat[i].Q2,  StrReplace(ReadIni('tagHeatQ2'),  '##',Str(i),3), 2);
   InitTag(tagHeat[i].DT,  StrReplace(ReadIni('tagHeatDT'),  '##',Str(i),3), 2);

   InitTag(tagHeat[i].BLK,     StrReplace(ReadIni('tagHeatBLK'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkTenb, StrReplace(ReadIni('tagHeatBlkTenb'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkTmax, StrReplace(ReadIni('tagHeatBlkTmax'), '##',Str(i),3), 2);
   InitTag(tagHeat[i].BlkPenb, StrReplace(ReadIni('tagHeatBlkPenb'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkPmax, StrReplace(ReadIni('tagHeatBlkPmax'), '##',Str(i),3), 2);
   lastBLK[i]:=igettag(tagHeat[i].BLK);
   HeatBase[i]:=0;
   wdtPOW[i]:=0;
   wdtSSR[i]:=0;
  end;

  InitTag(tagSpeakSpd,    ReadIni('tagSpeakSpd'),1);
  InitTag(tagSpeakVol,    ReadIni('tagSpeakVol'),1);
  InitTag(tagSpeakPit,    ReadIni('tagSpeakPit'),1);

  InitTag(tagSpeakOpt,   ReadIni('tagSpeakOpt'),1);
  InitTag(tagSpeakHeat1enb,  ReadIni('tagSpeakHeat1enb'),1);
  InitTag(tagSpeakHeat1per,  ReadIni('tagSpeakHeat1per'),2);

  InitTag(tagBlkOpt,    ReadIni('tagBlkOpt')  ,1);
  InitTag(tagLoadParams,ReadIni('tagLoadParams'),1);
  InitTag(tagSaveParams,ReadIni('tagSaveParams'),1);
  {
  }
  LoadCustom;
  {
  }
  if igettag(tagSpeakSpd)<80 then b:=isettag(tagSpeakSpd,80);
  if igettag(tagSpeakSpd)>150 then b:=isettag(tagSpeakSpd,150);
  if igettag(tagSpeakVol)<0 then b:=isettag(tagSpeakVol,0);
  if igettag(tagSpeakVol)>100 then b:=isettag(tagSpeakVol,100);
  if igettag(tagSpeakPit)<100 then b:=isettag(tagSpeakPit,100);
  if igettag(tagSpeakPit)>200 then b:=isettag(tagSpeakPit,200);

  lastSpeakSpd:=igettag(tagSpeakSpd);
  lastSpeakVol:=igettag(tagSpeakVol);
  lastSpeakPit:=igettag(tagSpeakPit);
  SpdCode:=lastSpeakSpd;
  VolCode:=500*lastSpeakVol;
  PitCode:=lastSpeakPit;
  Speak('\spd='+str(SpdCode)+'\\vol='+str(VolCode)+'\\pit='+str(PitCode)+
        '\Тест звука.')
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  StdIn_Line:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var 
  cmd,arg:String; b,blk:Boolean; tag, nV:Integer;
  SHF,t: real;
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Help') then begin
    ShowHelp(true);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   for i:=1 to nPs do if IsSameText(cmd,'@D'+str(i)+'SHFmv') then begin
    t:=time;
    if i=1 then SHF:=rgettag(tagDZEROmv[i])+crvinteg(refai(4),t-0.3,t)/0.3;
    if i=2 then SHF:=rgettag(tagDZEROmv[i])+crvinteg(refai(5),t-0.3,t)/0.3;
    b:=rsettag(tagDSHFmv[i],SHF);
    Data:='';
   end;
   if IsSameText(cmd,'@HeatON') then begin
    i:=val(arg);
    if (i>0) and (i<=nHeats) then begin
     SetBitTag(tagHeat[i].BT,1,true);
     wdtPOW[i]:=msecnow;
     wdtSSR[i]:=msecnow;
    end;
    Data:='';
   end;

   if IsSameText(cmd,'@HeatOFF') then begin
    i:=val(arg);
    if (i>0) and (i<=nHeats) then begin
     SetBitTag(tagHeat[i].BT,1,false);
     wdtPOW[i]:=msecnow;
     wdtSSR[i]:=msecnow;
    end;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@SaveParams') then begin
    SaveCustom;
    Success(cmd);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@LoadParams') then begin
    LoadCustom;
    Success(cmd);
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=Val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success(ProgName+' script initialization:');
  {
  Initialize SPEG and connect to tags.
  }
  SPEG_Init;
  lastt:=time;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  SPEG_Free;
  ClearStrings;
  Success('Stop.');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  SPEG polling actions
  }
  if igettag(tagSpeakSpd)<80 then b:=isettag(tagSpeakSpd,80);
  if igettag(tagSpeakSpd)>150 then b:=isettag(tagSpeakSpd,150);
  if igettag(tagSpeakVol)<0 then b:=isettag(tagSpeakVol,0);
  if igettag(tagSpeakVol)>100 then b:=isettag(tagSpeakVol,100);
  if igettag(tagSpeakPit)<100 then b:=isettag(tagSpeakPit,100);
  if igettag(tagSpeakPit)>200 then b:=isettag(tagSpeakPit,200);

  if (igettag(tagSpeakSpd)<>lastSpeakSpd) or
     (igettag(tagSpeakVol)<>lastSpeakVol) or
     (igettag(tagSpeakPit)<>lastSpeakPit) then begin
   lastSpeakSpd:=igettag(tagSpeakSpd);
   SpdCode:=lastSpeakSpd;
   lastSpeakVol:=igettag(tagSpeakVol);
   VolCode:=655*lastSpeakVol;
   lastSpeakPit:=igettag(tagSpeakPit);
   PitCode:=lastSpeakPit;
   Speak('\spd='+str(SpdCode)+'\\vol='+str(VolCode)+'\\pit='+str(PitCode)+
        '\Тест звука.')
  end;

  for i:=1 to nPs do b:=rsettag(tagP[i],    getai_yn(i-1));
  for i:=1 to nTs do b:=rsettag(tagT[i],    getai_yn(i+1));
  b:=rsettag(tagTCJ, getai_yn(aiTCJ));

  DioReadout;         // Readout I7053 state
  DevControl;         // Device  control
  DioControl;         // Write   I7043 control word

 end;
end.
