 {
 Юрьев Дима 24.03.99
 Формулятор для вычисления площадей для установки 'TRITON'.
 Курякин А.В. 11.04.99
 }
library triton2;

uses _Huge, _Str, _crwdll, WinAPI, DOS,_dosfn;

const
 HromPeaks = 6; { число пиков хроматографа  }
 IonPeaks  = 3; { число пиков ионной камеры }
type
 THromData = array[0..HromPeaks-1] of double;   
 THromName = array[0..HromPeaks-1] of string[2];
 TIonData  = array[0..IonPeaks-1]  of double;
 TIonName  = array[0..IonPeaks-1]  of string[2];
const
 HromName    : THromName = ( 'H2', 'HD', 'HT', 'D2', 'DT', 'T2'); { имена пиков хроматографа }
{+}  HC   : THromData = (  1.0, 0.79, 0.63, 0.64, 0.55, 0.49);  { коэффициенты чувствительности хроматографа }
 IonName     : TIonName  = ( 'HT', 'DT', 'T2');  { имена пиков ионизационной камеры }
 IonCoeff    : TIonData =  (  0.5,  0.5,  1.0);  { коэффициенты чувствительности ионизационной камеры }
 hrH2 = 0;
 hrHD = 1;
 hrHT = 2;
 hrD2 = 3;
 hrDT = 4;
 hrT2 = 5;
 ioHT = 0;
 ioDT = 1;
 ioT2 = 2;
 IonToHrom : array[0..IonPeaks-1] of byte = ( hrHT, hrDT, hrT2 );

procedure User_Defined_Script;export;
label
 Return,ReDraw;
var
 DlgData : Record
  Hrom  : THromData;
{+}
  Coeff : THromData;
{-}
  Ion   : TIonData;
  Main  : word;
  Fname : string;
 end;
{+}
 HromCoeff       : THromData; { коэффициенты чувствительности хроматографа               }
{-}
 BaseHrom        : THromData; { исходные  площади пиков хроматографа                     }
 RealHrom        : THromData; { настоящие площади пиков хроматографа                     }
 PercentRealHrom : THromData; { настоящие площади пиков хроматографа в процентах         }
 NormHrom        : THromData; { перенормированные площади пиков хроматографа             }
 PercentNormHrom : THromData; { перенормированные площади пиков хроматографа в процентах }
 BaseIon         : TIonData;  { исходные площади пиков ионизационной камеры              }
 RealIon         : TIonData;  { настоящие площади пиков ионизационной камеры             }
 ComponentsHrom  : THromData; { количественный состав           }
 DlgCom          : word;      { Команда нажатой кнопки          }
 peak            : integer;   { Счетчик циклов                  }
 Norm            : Double;    { Переменная для перенормировок   }
 MainPeak        : integer;   { Тип нормирования (HT,DT,T2,none)}
 BeginY,EndY     : integer;   { Сдвиги по оси Y для массивов    }
 Buff            : PChar;
 f               : Text;
begin
 {
 Выделение памяти и начальная инициализация
 }
 Buff:=AllocateMemory($8000);
 fillchar(DlgData,sizeof(DlgData),0);
 fillchar(BaseHrom,sizeof(BaseHrom),0);
 fillchar(RealHrom,sizeof(RealHrom),0);
{+}
 fillchar(HromCoeff,sizeof(HromCoeff),0);
{-}
 fillchar(PercentRealHrom,sizeof(PercentRealHrom),0);
 fillchar(NormHrom,sizeof(NormHrom),0);
 fillchar(PercentNormHrom,sizeof(PercentNormHrom),0);
 fillchar(BaseIon,sizeof(BaseIon),0);
 fillchar(RealIon,sizeof(RealIon),0);
 fillchar(ComponentsHrom,sizeof(ComponentsHrom),0);
 DlgData.fname:='c:\data\0106.txt';
 format(8,6);
{+}
 HromCoeff:=HC;
 DlgData.Coeff:=HromCoeff;
{-}
 {
 НАЧАЛО ПРОРИСОВКИ ДИАЛОГА
 }
ReDraw:
 StrCopy(Buff,
  'Dialog 0   0   785  370  Калькулятор площадей для TRITON'+CR );
 {
 Названия столбцов верхней (большой) таблицы
 }
{+}
 StrPCat(Buff,
  'Text   25  40  198 55   S пиков xpоматографа'+CR+
  'Text   215 40  388 55   Коэфф. хроматографа'+CR+
  'Text   405 40  578 55   S пиков иониз.камеры'+CR+
  'Text   595 40  768 55   Молекулярный состав,%'+CR );
{-}
 {
 Столбцы верхней (большой) таблицы состоящие из 6 строк
 }
 BeginY:=60;
 EndY:=75;
 for peak:=0 to HromPeaks-1 do begin
  StrPCat(Buff,
   'Label 5   '+d2s(BeginY)+' 25  '+d2s(EndY)+' '+HromName[peak]+''+CR+
   'Input 25  '+d2s(BeginY)+' 198 '+d2s(EndY)+'  %f '+CR+
   'Text  595 '+d2s(BeginY)+' 768 '+d2s(EndY)+' '+f2s(PercentNormHrom[peak])+''+CR);
  BeginY:=BeginY+20;
  EndY:=EndY+20;
 end;
 {
 Столбцы верхней (большой) таблицы состоящие из 6 строк - коэффициенты
 }
{+}
 BeginY:=60;
 EndY:=75;
 for peak:=0 to HromPeaks-1 do begin
  StrPCat(Buff,
   'Input 215  '+d2s(BeginY)+' 388 '+d2s(EndY)+'  %f '+''+CR);
  BeginY:=BeginY+20;
  EndY:=EndY+20;
 end;
{-}
 {
 Столбцы верхней (большой) таблицы состоящие из 3 строк
 }
 BeginY:=100;
 EndY:=115;
 for peak:=0 to IonPeaks-1 do begin
  StrPCat(Buff,'Input 405 '+d2s(BeginY)+' 578 '+d2s(EndY)+'  %f '+CR);
    If peak=ioHT then begin
      BeginY:=BeginY+40;
      EndY:=EndY+40;
    end else begin
     BeginY:=BeginY+20;
     EndY:=EndY+20;
    end;
 end;
 {
 Выбор типа нормировщика
 }
 StrPCat(Buff,
  'Label  20  200 280 216   Перенормировать по'+CR+
  'Radio  20  220 280 290 4'+CR+
     'пику '+HromName[hrHT]+' ионизационной камеры'+CR+
     'пику '+HromName[hrDT]+' ионизационной камеры'+CR+
     'пику '+HromName[hrT2]+' ионизационной камеры'+CR+
     'не надо перенормировать'+CR);
 {
 Нижняя (маленькая) таблица
 }
 StrPCat(Buff,'Text  300 200 590 216 Изотопный состав'+CR);
 BeginY:=220;
 EndY:=236;
 For peak:=0 to HromPeaks-1 do begin
  if peak in [hrH2,hrD2,hrT2] then begin
   StrPCat(Buff,
    'Label 300 '+d2s(BeginY)+' 340 '+d2s(EndY)+' '+HromName[peak]+' = '+CR+
    'Text  340 '+d2s(BeginY)+' 403 '+d2s(EndY)+' '+f2s(ComponentsHrom[peak])+''+CR );
   BeginY:=BeginY+20;
   EndY:=EndY+20;
  end;
 end;
 {
 Имя файла
 }
 StrPCat(Buff,
  'Label  20  305 200 321 Имя файла анализа'+CR+
  'Input  200 305 495 321 %s'+CR);
 {
 Кнопки
 }
 StrPCat(Buff,
  'Button 230 325 300 350 '+d2s(cm_Cancel)+'Закрыть'+CR+
  'Button 315 325 395 350 '+d2s(cm_Ok)+'Считай' );
 {
 ПРОРИСОВКА ДИАЛОГА
 }
 DlgCom:=DialogBox(Buff,@DlgData);
 {
 Нажата кнопка 'Закрыть'?
 }
 if DlgCom=cm_Cancel then goto Return;
 {
 Нажата кнопка 'Ввод'?
 }
 if DlgCom=cm_OK then begin
  BaseHrom:=DlgData.Hrom;
{+}
  HromCoeff:=DlgData.Coeff;
{-}
  BaseIon:=DlgData.Ion;
  MainPeak:=DlgData.Main;
  {
  НАЧАЛО МАТЕМАТИКИ
  }
  {
  готовим истинные площади для пиков хроматографа и ионизационной камеры
  с учетом коэффициентов чувствительности
  }
  for peak:=0 to HromPeaks-1 do RealHrom[peak] := BaseHrom[peak]/HromCoeff[peak];
  for peak:=0 to IonPeaks-1  do RealIon[peak]  := BaseIon[peak] /IonCoeff[peak];
  {
  готовим процентные соотношения для пиков хроматографа
  }
  Norm:=0;
  for peak:=0 to HromPeaks-1 do Norm:=Norm+RealHrom[peak];
  for peak:=0 to HromPeaks-1 do PercentRealHrom[peak]:=(RealHrom[peak]/Norm)*100;
  {
  готовим перенормированные площади для хроматографа, если указана нормировка
  }
  NormHrom:=RealHrom;
  if MainPeak in [0..IonPeaks-1] then
  for peak:=0 to IonPeaks-1 do
  NormHrom[IonToHrom[peak]]:=RealHrom[IonToHrom[MainPeak]]*RealIon[peak]/RealIon[MainPeak];
  {
  готовим процентные соотношения перенормированных пиков
  }
  Norm:=0;
  for peak:=0 to HromPeaks-1 do Norm:=Norm+NormHrom[peak];
  for peak:=0 to HromPeaks-1 do PercentNormHrom[peak]:=(NormHrom[peak]/Norm)*100;
  {
  определяем количественный состав
  }
  ComponentsHrom[hrH2]:=PercentNormHrom[hrH2]+0.5*(PercentNormHrom[hrHD]+PercentNormHrom[hrHT]);
  ComponentsHrom[hrD2]:=PercentNormHrom[hrD2]+0.5*(PercentNormHrom[hrHD]+PercentNormHrom[hrDT]);
  ComponentsHrom[hrT2]:=PercentNormHrom[hrT2]+0.5*(PercentNormHrom[hrHT]+PercentNormHrom[hrDT]);
  if DlgData.Fname<>'' then begin
   format(11,4);
   assign(f,DefaultExtension(DlgData.Fname,'.txt'));
   rewrite(f);
   writeln(f,'********************************************************************************');
   writeln(f,'╒ЁюьрЄюуЁрЇшўхёъшщ рэрышч ',Date,',',Time);
   writeln(f,'  ',' ','S яшъют їЁюь.'    :20,' ','S яшъют шюэ.ърь.':20,' ','╠юыхъєы Ёэ√щ ёюёЄрт,%'   :20);
   writeln(f,'H2',' ',f2s(BaseHrom[hrH2]):20,' ','                ':20,' ',f2s(PercentNormHrom[hrH2]):20);
   writeln(f,'HD',' ',f2s(BaseHrom[hrHD]):20,' ','                ':20,' ',f2s(PercentNormHrom[hrHD]):20);
   writeln(f,'HT',' ',f2s(BaseHrom[hrHT]):20,' ',f2s(BaseIon[ioHT]):20,' ',f2s(PercentNormHrom[hrHT]):20);
   writeln(f,'D2',' ',f2s(BaseHrom[hrD2]):20,' ','                ':20,' ',f2s(PercentNormHrom[hrD2]):20);
   writeln(f,'DT',' ',f2s(BaseHrom[hrDT]):20,' ',f2s(BaseIon[ioDT]):20,' ',f2s(PercentNormHrom[hrDT]):20);
   writeln(f,'T2',' ',f2s(BaseHrom[hrT2]):20,' ',f2s(BaseIon[ioT2]):20,' ',f2s(PercentNormHrom[hrT2]):20);
   case MainPeak of
    0:writeln(f,'╧хЁхэюЁьшЁютър яю яшъє HT');
    1:writeln(f,'╧хЁхэюЁьшЁютър яю яшъє DT');
    2:writeln(f,'╧хЁхэюЁьшЁютър яю яшъє T2');
    else writeln(f,'╧хЁхэюЁьшЁютъш эх с√ыю');
   end;
   writeln(f,'╚чюЄюяэ√щ ёюёЄрт:');
   writeln(f,'H2',' ',f2s(ComponentsHrom[hrH2]):20);
   writeln(f,'D2',' ',f2s(ComponentsHrom[hrD2]):20);
   writeln(f,'T2',' ',f2s(ComponentsHrom[hrT2]):20);
   writeln(f,'********************************************************************************');
   writeln(f);
   close(f);
   if IOResult<>0 then Error('Ошибка записи файла!');
   formatold;
  end;
  goto ReDraw;
 end;
 {
 Освобождение памяти
 }
Return:
 DeallocateMemory(Buff);
 formatold;
end;

exports User_Defined_Script resident;
begin
end.