﻿
---

# Справка по P20

- Документация по **[P20](doc/)**. **[Спецификация](doc/p20_signal_specification.pdf)** сигналов.  
- Документация по измерительной карте **[e140](e140.htm)**.
- **[Команды](#toolbar-commands)** мнемосхемы **P20.MAIN.GUI**.  
- **[Кривые](#curve-names)**  - расшифровка имен.  
- **[Формулы](#eval-formulas)**  - для расчета частоты и поджига.  
- Справка по **[univent](univent.htm)**.  

---

<a name="toolbar-commands"></a>

## Команды мнемосхемы P20.MAIN.GUI


- ![](../bitmaps/p20_cmd_help0.bmp) - вызов этой справки.

- ![](../bitmaps/p20_cmd_show_a10.bmp) - вызов управления **A1** - картой **АЦП E140-14 №1**.

- ![](../bitmaps/p20_cmd_show_a20.bmp) - вызов управления **A2** - картой **АЦП E140-14 №2**.

- ![](../bitmaps/p20_cmd_show_a30.bmp) - вызов управления **A3** - картой **АЦП E140-14 №3**.

- ![](../bitmaps/p20_cmd_show_wk.bmp) - вызов управления **WK** - датчиками давления **WIKA**.

- ![](../bitmaps/p20_cmd_show_tr.bmp) - вызов управления **TR** - датчиками тензометрическими резистивными.

- ![](../bitmaps/p20_cmd_show_dp.bmp) - вызов управления **DP** - датчиками перемещения.

- ![](../bitmaps/p20_cmd_show_ar.bmp) - вызов управления **AR** - датчиками давления AR.

- ![](../bitmaps/p20_cmd_show_tp.bmp) - вызов управления **TP** - датчиками температуры термопарными.

- ![](../bitmaps/p20_cmd_show_fr.bmp) - вызов управления **FR** - датчиками тока поджига (**fire**).

- ![](../bitmaps/p20_cmd_show_ex.bmp) - вызов окна с графиками данных по экспозиции (**Exposition**).

- ![](../bitmaps/p20_cmd_open0.bmp) - вызов диалога загрузки файла данных **`*.dat`** или **`*.crw`**.

- ![](../bitmaps/p20_cmd_save0.bmp) - кнопка разрешения сохранения данных в формате **`*.dat`**.

- ![](../bitmaps/p20_cmd_loadini0.bmp) - кнопка загрузки параметров (балансировка,экспозиция) из файла **`*.ini`**.

- ![](../bitmaps/p20_cmd_saveini0.bmp) - кнопка записи параметров (балансировка,экспозиция) в файл **`*.ini`**.

- ![](../bitmaps/p20_cmd_close0.bmp) - кнопка диалога для завершения работы программы, перезагрузки и т.д.

---

<a name="curve-names"></a>

## Кривые - расшифровка имен

<pre style="font-size:1.2em;font-weight: bold;color:blue;">
   P20.TR1.EX                  - Установка P20, датчик тензометрический № 1, время в секундах от начала экспозиции
    |  |   |
    |  |   \___Тип данных:  MV - Milli Volt - "сырые" милливольты АЦП, время в часах от начала суток
    |  |                    CV - Calibrated Values - физические единицы после калибровки, время в часах от начала суток
    |  |                    PU - Physical Units - физические единицы после калибровки и сдвига, время в часах от начала суток
    |  |                    EX - Exposition - те же физические единицы, но время в секундах от начала экспозиции
    |  \_______Тип датчика: WK - датчик давления WIKA, bar
    |                       TR - датчик тензометрический резистивный, bar
   Имя                      DP - датчик перемещения, mkm
 физической                 AR - датчик давления AR, bar
 установки                  TP - датчик температуры термопарный, °C
                            FR - датчик тока поджига, mA
</pre>

---

<a name="eval-formulas"></a>

## Формулы частоты и поджига

<pre style="font-size:1.2em;font-weight: bold;color:blue;">
  Для расчета частоты (Герц на канал) и поджига или клапанов (логические 0 или 1)
  во время экспозиции используются формулы. При расчете поджига любое ненулевое
  число интерпретируется как логическая единица.
  При вычислениях доступны:
  Арифметические операции:
   + -    - сложение и вычитание
   * /    - умножение и деление
   ^ %    - возведение в степень и остаток от деления
   ()     - скобки для изменения порядка вычислений
  Заданные переменные:
   t       - время в секундах от начала экспозиции
  Функции:
   le(t,a) - "t is less    or equal a" - 1 при t &lt;= a, иначе 0
   lt(t,a) - "t is less    (strong) a" - 1 при t &lt;  a, иначе 0
   ge(t,a) - "t is greater or equal a" - 1 при t &gt;= a, иначе 0
   gt(t,a) - "t is greater (strong) a" - 1 при t &gt;  a, иначе 0
   eq(t,a) - "t is            equal a" - 1 при t <> a, иначе 0
   ne(t,a) - "t is        not equal a" - 1 при t  = a, иначе 0
  Например:
   200*le(t,5)+50*gt(t,5) - частота 200 Гц первые 5 секунд, затем 50 Гц
   ge(t,5)*le(t,6)        - включить  клапан между 5 и 6 секундой,
   lt(t,5)+gt(t,6)        - отключить клапан между 5 и 6 секундой.
  Проверка:
   Для проверки формул можно использовать графопостроитель в меню
   "Инструменты\График 2D", вызываемый по Alt+F10.
   В появившемся диалоге графопостроителя надо задать, например:
    Интервал t:     от 0 до 10
    В окне формулы: x=t
                    y=ge(t,5)*le(t,6)
   Графопостроитель покажет график интересующей величины.
</pre>

---
