 {
 ***********************************************************************
 Daq Pascal application program UH_CTRL.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @LoadIni       - Load UniHeat params from INI file.
| @SaveIni       - Save UniHeat params to   INI file.
|********************************************************
[]
 ***********************************************************************
 Программа стабилизации для управления печами UniHeat.
 Конфигурирование и описание: (здесь i-номер печи)
 1) К входам AnalogInput(1..30)  подключаются каналы температур печей.
    К входам DigitalInput(1..30) подключаются каналы давлений печей.
    На выходы AnalogOutput(1..30) выдается вычисленная скважность для
    подачи на вход генератора скважности &UH_PULSE.
    На выходы DigitalOutput(1..30) выдается сигнал блокировки печей.
 2) Число печей определяется по числу тегов номера печи UH_HNUMi.
    Следите за соответствием числа печей и тегов.
 3) Блокировка делается по:
    a) уровню давления    - порог в теге UH_PBLKi,
    b) уровню температуры - порог в теге UH_TBLKi,
    c) сторожу UH_WDTi, чтобы сигнализировать обрыв связи.
    d) внешней блокировки UH_EBLK, за которую целиком отвечает
       внешняя программа.
    Обрыв связи регистрируется по времени поступления последней точки
    давления и температуры.
    Значение WDTi=0 означает отмену WatchDog - контроля.
    Блокировка заключается в записи флага блокировки в тег UH_BLKi,
    а также в кривую DigitalOutput(i).
    Если к входу не подключено давление или температура, блокировка 
    по ним не делается.
    При блокировке периодически выдается сообщение "Блокировка i".
  4)Алгоритм вычисления скважности:
    if T<T0-dt1 then q:=Q1 else 
    if T<T0     then q:=Q2 else 
    if T<T0+dt2 then q:=Q3 else q:=0;
  5)Программа использует номера датчиков давления и температуры
    в тегах UH_PNUMi,UH_TNUMi. Также используются имена каналов
    UH_TNAMEi,UH_PNAMEi, которые вычисляются по списку имен датчиков
    UH_TNAMES,UH_PNAMES вида T1/T2/T3/... (разделитель- слеш).
    Следите за корректностью UH_TNAMES,UH_PNAMES - списков имен датчиков,
    типа T1/T2/T3/... (длина каждого названия датчика не более 4).
  6)При обнаружении сигнала UH_ICTRLi>0 при включенной кнопке печи
    регистрируется обрыв цепи и выдается периодическое сообщение "Разрыв i".
  7)На блокировки влияют флаги разрешения блокировок
    UH_TENABL,UH_PENABL,UH_WENABL.
  8)Печь можно запретить флагом UH_HENABL. 
    В этом случае всегда кнопка=0, блокировка=1 и скважность=0.
 20030202-Курякин-теперь блокировка включается при выключении нагрева.
          Однако теперь кривая BLK и тег BLK не совпадают. 
          Кривая используется для управления, тег для индикации превышения.
 ***********************************************************************
 Программа пользовательского интерфейса для управления печами UniHeat.
 Описание и конфигурирование:
 1) Программа отрабатывает нажатие
    a) Кнопок включения печей
    b) Кнопок вызова диалога настройки печей
    c) Кнопки подтверждения и отмены для диалога настройки печей
    d) Кнопки включения звука
    e) Кнопки разрешения печи и блокировок
    f) Всех полей ввода связанных с печью
 ***********************************************************************
 20000903 Курякин А.В.
 20131012 Курякин А.В.
 ***********************************************************************
 }
program UH_CTRL;                 { UniHeat control                  }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 snd_BLK           = 'Блокиров'; { Sound on blocking                }
 snd_ICTRL         = 'Обрыв';    { Sound on wire break              }
 spk_BLK           = 'Блокировка печи'; { Speaker message           }
 spk_ICTRL         = 'Обрыв печи';      { Speaker message           }
 MaxHeat           = 30;         { Max. number of heaters           }
 MsgPeriod         = 30;         { Period for sound messages        }
 NamesPeriod       = 100;        { Period to update sensor names    }
 SensorDelims      = '/|\';      { Delimeters for sensor list       }
 CtrlDlg           = '***_КОНТРОЛЬ_ПЕЧЕЙ_***';  { Heaters control   }
 PropDlg           = '***_НАСТРОЙКА_ПЕЧЕЙ_***'; { Heaters property  }
 UseSensorMenu     = True;       { Use menu to select sensors       }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 NumHeats          : Integer;    { Number of heaters                }
 tagHNUM           : array [1..MaxHeat] of Integer; { Heater number }
 tagTNUM           : array [1..MaxHeat] of Integer; { T sensor num  }
 tagPNUM           : array [1..MaxHeat] of Integer; { P sensor num  }
 tagHENABL         : array [1..MaxHeat] of Integer; { Enable heater }
 tagTENABL         : array [1..MaxHeat] of Integer; { Enab T block  }
 tagPENABL         : array [1..MaxHeat] of Integer; { Enab P block  }
 tagWENABL         : array [1..MaxHeat] of Integer; { Enab watchdog }
 tagBT             : array [1..MaxHeat] of Integer; { Button on/off }
 tagST             : array [1..MaxHeat] of Integer; { State 0..5    }
 tagQ1             : array [1..MaxHeat] of Integer; { Q1 starting   }
 tagQ2             : array [1..MaxHeat] of Integer; { Q2 underheat  }
 tagQ3             : array [1..MaxHeat] of Integer; { Q3 overheat   }
 tagTGOAL          : array [1..MaxHeat] of Integer; { Goal T stab   }
 tagDT1            : array [1..MaxHeat] of Integer; { dT1 underheat }
 tagDT2            : array [1..MaxHeat] of Integer; { dT2 overheat  }
 tagPBLK           : array [1..MaxHeat] of Integer; { P hi limit    }
 tagBLK            : array [1..MaxHeat] of Integer; { Blocking      }
 tagICTRL          : array [1..MaxHeat] of Integer; { Wire break    }
 tagWDT            : array [1..MaxHeat] of Integer; { Watchdog, sec }
 tagTBLK           : array [1..MaxHeat] of Integer; { T hi limit    }
 tagEBLK           : array [1..MaxHeat] of Integer; { Extern block  }
 tagPERIOD         : array [1..MaxHeat] of Integer; { Period, ms    }
 tagTNAME          : array [1..MaxHeat] of Integer; { T sensor name }
 tagPNAME          : array [1..MaxHeat] of Integer; { P sensor name }
 tagTNAMES         : Integer;    { List of T sensor names a/b/c/d   }
 tagPNAMES         : Integer;    { List of P sensor names a/b/c/d   }
 tagTNAMEX         : Integer;    { Editing TNAME                    }
 tagPNAMEX         : Integer;    { Editing PNAME                    }
 tagHNUMX          : Integer;    { Editing HNUM                     }
 tagQ1X            : Integer;    { Editing Q1                       }
 tagQ2X            : Integer;    { Editing Q2                       }
 tagQ3X            : Integer;    { Editing Q3                       }
 tagDT1X           : Integer;    { Editing dT1                      }
 tagDT2X           : Integer;    { Editing dT2                      }
 tagTNUMX          : Integer;    { Editing TNUM                     }
 tagPNUMX          : Integer;    { Editing PNUM                     }
 tagPBLKX          : Integer;    { Editing PBLK                     }
 tagTBLKX          : Integer;    { Editing TBLK                     }
 tagTREALX         : Integer;    { Editing TREAL                    }
 tagPREALX         : Integer;    { Editing PREAL                    }
 tagWDTX           : Integer;    { Editing WDT                      }
 tagSOUNDX         : Integer;    { Sound on/off                     }
 tagHENABLX        : Integer;    { Editing HENABL                   }
 tagTENABLX        : Integer;    { Editing TENABL                   }
 tagPENABLX        : Integer;    { Editing PENABL                   }
 tagWENABLX        : Integer;    { Editing WENABL                   }
 tagTGOALX         : Integer;    { Editing TGOAL                    }
 tStart            : Real;       { Start time                       }
 LastBLK           : array [1..MaxHeat] of Real; { Last BLK   voice }
 LastICTRL         : array [1..MaxHeat] of Real; { Last ICTRL voice }
 TheHNUM           : Integer;    { Current editing heater number    }
 UsesSpeakSrv      : Boolean;    { Uses SpeakSrv server or not      }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Check if heater number n is valid to use.
 }
 function ValidHNUM(n:Integer):Boolean;
 begin
  ValidHNUM:=((n>=1) and (n<=NumHeats));
 end;
 {
 Update T,P sensor names.
 }
 procedure UpdateSensorNames;
 var i:Integer; delims,tnames,pnames:String;
 begin
  delims:=WordDelims('');
  sNul(WordDelims(delims+SensorDelims));
  tnames:=sGetTag(tagTNAMES);
  pnames:=sGetTag(tagPNAMES);
  for i:=1 to NumHeats do begin
   bNul(sSetTag(tagTNAME[i],ExtractWord(iGetTag(tagTNUM[i]),tnames)));
   bNul(sSetTag(tagPNAME[i],ExtractWord(iGetTag(tagPNUM[i]),pnames)));
  end;
  if ValidHNUM(TheHNUM) then begin
   bNul(sSetTag(tagTNAMEX,ExtractWord(iGetTag(tagTNUMX),tnames)));
   bNul(sSetTag(tagPNAMEX,ExtractWord(iGetTag(tagPNUMX),pnames)));
  end;
  sNul(WordDelims(delims));
  delims:='';
  tnames:='';
  pnames:='';
 end;
 {
 Get number of sensors in list a/b/c/d.
 }
 function GetNumSensors(SensorNames:String):Integer;
 var n:Integer; delims:String;
 begin
  delims:=WordDelims('');
  sNul(WordDelims(delims+SensorDelims));
  n:=WordCount(SensorNames);
  sNul(WordDelims(delims));
  GetNumSensors:=n;
  delims:='';
 end;
 {
 Get sensors name from list a/b/c/d.
 }
 function GetSensorName(n:Integer; SensorNames:String):String;
 var delims:String;
 begin
  delims:=WordDelims('');
  sNul(WordDelims(delims+SensorDelims));
  GetSensorName:=ExtractWord(n,SensorNames);
  sNul(WordDelims(delims));
  delims:='';
 end;
 {
 Start menu list to select sensor.
 }
 procedure CheckStartSensorMenu(n,tag:Integer; SensorNames,Id:String);
 var i,ns,ne:Integer;
 begin
  if ClickTag=tag then if ValidHNUM(n) then if TypeTag(tag)=1 then
  if iGetTag(tagHENABL[n])=0 then bNul(Voice(snd_Error)) else begin
   ns:=GetNumSensors(SensorNames);
   if ns>0 then
   if ValidHNUM(n) then begin
    if EditState=0 then begin
     ne:=0;
     ne:=ne+Pos('?',Edit('(Выбор датчика печи '+Str(n)+' ... '));
     ne:=ne+Pos('?',Edit(' Датчик канала '+Id+':'));
     for i:=1 to ns do
     ne:=ne+Pos('?',Edit(' '+RightPad('Датчик '+Str(i),10,' ')+' '+GetSensorName(i,SensorNames)));
     ne:=ne+Pos('?',Edit(')MenuList MENU_'+NameTag(tag)+' '+Str(iGetTag(tag)-1)));
     if ne>0 then Warning('Error initializing MenuList!');
    end else Warning('Cannot edit right now!');
   end;
  end;
 end;
 {
 Check and accept sensor menu.
 }
 procedure CheckEditSensor(tag,nmin,nmax:Integer);
 var ns:Integer;
 begin
  if TypeTag(tag)=1 then
  if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(tag)) then begin
   if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
    ns:=Val(Edit('?ans 1'))+1;
    if (ns>=nmin) and (ns<=nmax) then bNul(iSetTag(tag,ns));
   end;
   sNul(Edit(''));
  end;
 end;
 {
 Close dialog & zero all property (.)X tags.
 }
 procedure CloseProperty;
 begin
  TheHNUM:=0;
  bNul(WinHide(PropDlg));
  bNul(iSetTag(tagHNUMX,   0));
  bNul(rSetTag(tagQ1X,     0));
  bNul(rSetTag(tagQ2X,     0));
  bNul(rSetTag(tagQ3X,     0));
  bNul(rSetTag(tagDT1X,    0));
  bNul(rSetTag(tagDT2X,    0));
  bNul(rSetTag(tagPBLKX,   0));
  bNul(iSetTag(tagPNUMX,   0));
  bNul(rSetTag(tagTBLKX,   0));
  bNul(iSetTag(tagTNUMX,   0));
  bNul(rSetTag(tagWDTX,    0));
  bNul(iSetTag(tagHENABLX, 0));
  bNul(iSetTag(tagTENABLX, 0));
  bNul(iSetTag(tagPENABLX, 0));
  bNul(iSetTag(tagWENABLX, 0));
  bNul(rSetTag(tagTGOALX,  0));
  bNul(sSetTag(tagTNAMEX, ''));
  bNul(sSetTag(tagPNAMEX, ''));
  bNul(rSetTag(tagPREALX,  0));
  bNul(rSetTag(tagTREALX,  0));
 end;
 {
 Start edit property: copy (.)j tags to (.)X tags. 
 Then open property editor dialog.
 }
 procedure StartEditProperty(j:Integer);
 begin
  if ValidHNUM(j) then begin
   TheHNUM:=j;
   DevPostCmdLocal('@WinOpen UH_PROPERTY');
   DevPostCmdLocal('@WinSelect '+PropDlg);
   bNul(iSetTag(tagHNUMX,  iGetTag(tagHNUM[TheHNUM])));
   bNul(rSetTag(tagQ1X,    rGetTag(tagQ1[TheHNUM])));
   bNul(rSetTag(tagQ2X,    rGetTag(tagQ2[TheHNUM])));
   bNul(rSetTag(tagQ3X,    rGetTag(tagQ3[TheHNUM])));
   bNul(rSetTag(tagDT1X,   rGetTag(tagDT1[TheHNUM])));
   bNul(rSetTag(tagDT2X,   rGetTag(tagDT2[TheHNUM])));
   bNul(rSetTag(tagPBLKX,  rGetTag(tagPBLK[TheHNUM])));
   bNul(iSetTag(tagPNUMX,  iGetTag(tagPNUM[TheHNUM])));
   bNul(rSetTag(tagTBLKX,  rGetTag(tagTBLK[TheHNUM])));
   bNul(iSetTag(tagTNUMX,  iGetTag(tagTNUM[TheHNUM])));
   bNul(rSetTag(tagWDTX,   rGetTag(tagWDT[TheHNUM])));
   bNul(iSetTag(tagHENABLX,iGetTag(tagHENABL[TheHNUM])));
   bNul(iSetTag(tagTENABLX,iGetTag(tagTENABL[TheHNUM])));
   bNul(iSetTag(tagPENABLX,iGetTag(tagPENABL[TheHNUM])));
   bNul(iSetTag(tagWENABLX,iGetTag(tagWENABL[TheHNUM])));
   bNul(rSetTag(tagTGOALX, rGetTag(tagTGOAL[TheHNUM])));
  end;
 end;
 {
 Stop edit property: accept changes and clear flag.
 }
 procedure StopEditProperty;
 begin
  if ValidHNUM(TheHNUM) then begin
   bNul(rSetTag(tagQ1[TheHNUM],     rGetTag(tagQ1X)));   
   bNul(rSetTag(tagQ2[TheHNUM],     rGetTag(tagQ2X)));   
   bNul(rSetTag(tagQ3[TheHNUM],     rGetTag(tagQ3X)));   
   bNul(rSetTag(tagDT1[TheHNUM],    rGetTag(tagDT1X)));   
   bNul(rSetTag(tagDT2[TheHNUM],    rGetTag(tagDT2X)));   
   bNul(rSetTag(tagPBLK[TheHNUM],   rGetTag(tagPBLKX)));   
   bNul(iSetTag(tagPNUM[TheHNUM],   iGetTag(tagPNUMX)));
   bNul(rSetTag(tagTBLK[TheHNUM],   rGetTag(tagTBLKX)));   
   bNul(iSetTag(tagTNUM[TheHNUM],   iGetTag(tagTNUMX)));
   bNul(rSetTag(tagWDT[TheHNUM],    rGetTag(tagWDTX)));   
   bNul(iSetTag(tagHENABL[TheHNUM], iGetTag(tagHENABLX)));
   bNul(iSetTag(tagTENABL[TheHNUM], iGetTag(tagTENABLX)));
   bNul(iSetTag(tagPENABL[TheHNUM], iGetTag(tagPENABLX)));
   bNul(iSetTag(tagWENABL[TheHNUM], iGetTag(tagWENABLX)));
   bNul(rSetTag(tagTGOAL[TheHNUM],  rGetTag(tagTGOALX)));   
   CloseProperty;
  end;
 end;
 {
 Check tag clicked, heater number n is Ok.
 If heater is enabled, start edit tag.
 }
 procedure CheckStartEditTag(n,tag:Integer; Comment:String);
 begin
  if ClickTag=tag then if ValidHNUM(n) then if TypeTag(tag)>0 then
  if iGetTag(tagHENABL[n])=0 then bNul(Voice(snd_Error)) else StartEditTag(tag,Comment);
 end;
 {
 Check start edit all tags of heater n.
 }
 procedure CheckStartEditHeater(n:Integer);
 begin
  if ValidHNUM(n) then begin
   CheckStartEditTag(n,tagQ1[n],'Скважность Q1 (%) печи '+Str(n));
   CheckStartEditTag(n,tagQ2[n],'Скважность Q2 (%) печи '+Str(n));
   CheckStartEditTag(n,tagQ3[n],'Скважность Q3 (%) печи '+Str(n));
   CheckStartEditTag(n,tagDT1[n],'Зазор dT1 (°C) недогрева печи '+Str(n));
   CheckStartEditTag(n,tagDT2[n],'Зазор dT2 (°C) перегрева печи '+Str(n));
   CheckStartEditTag(n,tagPBLK[n],'Давление блокировки печи '+Str(n));
   CheckStartEditTag(n,tagTBLK[n],'Температура(°C) блокировки печи '+Str(n));
   CheckStartEditTag(n,tagWDT[n],'Сторожевой таймер (сек) печи '+Str(n));
   CheckStartEditTag(n,tagTGOAL[n],'Целевая температура (°C) стабилизации печи '+Str(n));
   if UseSensorMenu then begin
    CheckStartSensorMenu(n,tagPNUM[n],sGetTag(tagPNAMES),'давления');
    CheckStartSensorMenu(n,tagTNUM[n],sGetTag(tagTNAMES),'температуры');
   end else begin
    CheckStartEditTag(n,tagPNUM[n],'Номер датчика давления печи '+Str(n));
    CheckStartEditTag(n,tagTNUM[n],'Номер датчика температуры печи '+Str(n));
   end;
  end;
 end;
 {
 Check start edit all tags of property dialog.
 }
 procedure CheckStartEditProperty(n:Integer);
 begin
  if ValidHNUM(n) then begin
   CheckStartEditTag(n,tagQ1X,'Скважность Q1 (%) печи '+Str(n));
   CheckStartEditTag(n,tagQ2X,'Скважность Q2 (%) печи '+Str(n));
   CheckStartEditTag(n,tagQ3X,'Скважность Q3 (%) печи '+Str(n));
   CheckStartEditTag(n,tagDT1X,'Зазор dT1 (°C) недогрева печи '+Str(n));
   CheckStartEditTag(n,tagDT2X,'Зазор dT2 (°C) перегрева печи '+Str(n));
   CheckStartEditTag(n,tagPBLKX,'Давление блокировки печи '+Str(n));
   CheckStartEditTag(n,tagTBLKX,'Температура (°C) блокировки печи '+Str(n));
   CheckStartEditTag(n,tagWDTX,'Сторожевой таймер (сек) печи '+Str(n));
   CheckStartEditTag(n,tagTGOALX,'Целевая температура (°C) стабилизации печи '+Str(n));
   if UseSensorMenu then begin
    CheckStartSensorMenu(n,tagPNUMX,sGetTag(tagPNAMES),'давления');
    CheckStartSensorMenu(n,tagTNUMX,sGetTag(tagTNAMES),'температуры');
   end else begin
    CheckStartEditTag(n,tagPNUMX,'Номер датчика давления печи '+Str(n));
    CheckStartEditTag(n,tagTNUMX,'Номер датчика температуры печи '+Str(n));
   end;
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then begin
   if iGetTag(tagSOUNDX)<>0  then Speak(s) else
   InfoBox(s);
  end;
 end;

 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var i:Integer;
 begin
  {
  Find number of heaters by max. number of tags UN_HNUMi
  }
  NumHeats:=0;
  for i:=1 to MaxHeat do if FindTag('UH_HNUM'+Str(i))<>0 then NumHeats:=i;
  {
  Initialize tags...
  }
  for i:=1 to NumHeats do begin
   InitTag( tagHNUM[i],   'UH_HNUM'+Str(i),   1);
   InitTag( tagTNUM[i],   'UH_TNUM'+Str(i),   1);
   InitTag( tagPNUM[i],   'UH_PNUM'+Str(i),   1);
   InitTag( tagHENABL[i], 'UH_HENABL'+Str(i), 1);
   InitTag( tagTENABL[i], 'UH_TENABL'+Str(i), 1);
   InitTag( tagPENABL[i], 'UH_PENABL'+Str(i), 1);
   InitTag( tagWENABL[i], 'UH_WENABL'+Str(i), 1);
   InitTag( tagBT[i],     'UH_BT'+Str(i),     1);
   InitTag( tagST[i],     'UH_ST'+Str(i),     1);
   InitTag( tagQ1[i],     'UH_Q1'+Str(i),     2);
   InitTag( tagQ2[i],     'UH_Q2'+Str(i),     2);
   InitTag( tagQ3[i],     'UH_Q3'+Str(i),     2);
   InitTag( tagTGOAL[i],  'UH_TGOAL'+Str(i),  2);
   InitTag( tagDT1[i],    'UH_DT1'+Str(i),    2);
   InitTag( tagDT2[i],    'UH_DT2'+Str(i),    2);
   InitTag( tagBLK[i],    'UH_BLK'+Str(i),    1);
   InitTag( tagICTRL[i],  'UH_ICTRL'+Str(i),  1);
   InitTag( tagPBLK[i],   'UH_PBLK'+Str(i),   2);
   InitTag( tagWDT[i],    'UH_WDT'+Str(i),    2);
   InitTag( tagTBLK[i],   'UH_TBLK'+Str(i),   2);
   InitTag( tagEBLK[i],   'UH_EBLK'+Str(i),   1);
   InitTag( tagPERIOD[i], 'UH_PERIOD'+Str(i), 2);
   InitTag( tagTNAME[i],  'UH_TNAME'+Str(i),  3);
   InitTag( tagPNAME[i],  'UH_PNAME'+Str(i),  3);
  end;
  InitTag( tagTNAMES,  'UH_TNAMES',  3);
  InitTag( tagPNAMES,  'UH_PNAMES',  3);
  InitTag( tagTNAMEX,  'UH_TNAMEX',  3);
  InitTag( tagPNAMEX,  'UH_PNAMEX',  3);
  InitTag( tagHNUMX,   'UH_HNUMX',   1);
  InitTag( tagQ1X,     'UH_Q1X',     2);
  InitTag( tagQ2X,     'UH_Q2X',     2);
  InitTag( tagQ3X,     'UH_Q3X',     2);
  InitTag( tagDT1X,    'UH_DT1X',    2);
  InitTag( tagDT2X,    'UH_DT2X',    2);
  InitTag( tagTNUMX,   'UH_TNUMX',   1); 
  InitTag( tagPNUMX,   'UH_PNUMX',   1); 
  InitTag( tagPBLKX,   'UH_PBLKX',   2);
  InitTag( tagTREALX,  'UH_TREALX',  2);
  InitTag( tagPREALX,  'UH_PREALX',  2);
  InitTag( tagTGOALX,  'UH_TGOALX',  2);
  InitTag( tagWDTX,    'UH_WDTX',    2);
  InitTag( tagTBLKX,   'UH_TBLKX',   2);
  InitTag( tagSOUNDX,  'UH_SOUNDX',  1);
  InitTag( tagHENABLX, 'UH_HENABLX', 1);
  InitTag( tagTENABLX, 'UH_TENABLX', 1);
  InitTag( tagPENABLX, 'UH_PENABLX', 1);
  InitTag( tagWENABLX, 'UH_WENABLX', 1);
  {
  Initialize timers
  }
  tStart:=Time;
  for i:=1 to NumHeats do begin
   LastICTRL[i]:=SecNow;
   LastBLK[i]:=SecNow;
  end;
  {
  Initialize GUI
  }
  UsesSpeakSrv:=(Val(ReadIni('UsesSpeakSrv'))>0) and (devSpeakSrv<>0);
  bNul(WinHide(PropDlg));
  TheHNUM:=0;
  {
  Startup script & INI
  }
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  {
  Finally script & INI
  }
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  {
  Finalize GUI
  }
  bNul(WinHide(PropDlg));
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i,j,nTs,nPs:Integer; BLK,isWDT:Boolean; TimeOut,qx,TReal,TGoal,dt1,dt2:Real;
 begin
  {
  Update T,P names
  }
  if SysTimer_Pulse(NamesPeriod)>0 then UpdateSensorNames;
  {
  For all heaters: calculate off-duty factor, blocking, button states
  }
  for i:=1 to NumHeats do begin
   {
   Blocking by P, T, WDT & external UH_EBLK
   }
   BLK:=False;
   if iGetTag(tagHENABL[i])<>0 then begin
    {
    Blocking by WDT
    }
    isWDT:=(iGetTag(tagWENABL[i])<>0) and (rGetTag(tagWDT[i])>0);
    TimeOut:=rGetTag(tagWDT[i])*1000/TimeUnits;
    {
    Blocking by T
    }
    if iGetTag(tagTENABL[i])<>0 then
    if RefAi(i)<>_Nil then begin
     if isWDT then
     BLK:=BLK or (Time-Max(GetAi_Xn(i),tStart)>TimeOut);
     BLK:=BLK or (GetAi_Yn(i)>rGetTag(tagTBLK[i]));
    end;
    {
    Blocking by P
    }
    if iGetTag(tagPENABL[i])<>0 then
    if RefDi(i)<>_Nil then begin
     if isWDT then
     BLK:=BLK or (Time-Max(GetDi_Xn(i),tStart)>TimeOut);
     BLK:=BLK or (GetDi_Yn(i)>rGetTag(tagPBLK[i]));
    end;
    {
    External blocking
    }
    BLK:=BLK or (iGetTag(tagEBLK[i])<>0);
   end;
   {
   Write blockings to tag & curve
   Blocking tag - by P, T overrange only
   Blocking curve - by P, T overrange & button OFF
   This helps to disconnect power in case of SSR shortcut.
   In general case use curve for hardware control
   }
   bNul(iSetTag(tagBLK[i],Ord(BLK)));
   if RefDo(i)<>_Nil 
   then bNul(PutDo(i,Time,Ord((iGetTag(tagBLK[i])>0) or (iGetTag(tagBT[i])=0))));
   {
   Voice on blocking
   }
   if BLK then begin
    if SecNow-LastBLK[i]>MsgPeriod then begin
     if iGetTag(tagSOUNDX)<>0 then begin
      if UsesSpeakSrv
      then Speak(spk_BLK+' '+Str(i))
      else bNul(Voice(snd_BLK+' '+Str(i)));
     end;
     LastBLK[i]:=SecNow;
    end;
   end else LastBLK[i]:=0;
   {
   Disabled heaters is always OFF
   }
   if iGetTag(tagHENABL[i])=0 then bNul(iSetTag(tagBT[i],0));
   {
   Off-duty factor calculation (0-100%):
   If button OFF or blocking present, off-duty = 0.
   If button ON and no blockings, return Q1,Q2,Q3,0 - depend on TReal vs TGoal. 
   Then write off-duty to curve.
   }
   qx:=0;
   if iGetTag(tagBT[i])<>0 then
   if iGetTag(tagBLK[i])=0 then begin
    TGoal:=rGetTag(tagTGOAL[i]);
    TReal:=GetAi_Yn(i);
    dt1:=rGetTag(tagDT1[i]);
    dt2:=rGetTag(tagDT2[i]);
    if TReal<TGoal-dt1 then qx:=rGetTag(tagQ1[i]) else 
    if TReal<TGoal     then qx:=rGetTag(tagQ2[i]) else
    if TReal<TGoal+dt2 then qx:=rGetTag(tagQ3[i]) else qx:=0;
   end;
   if RefAo(i)<>_Nil then bNul(PutAo(i,time,qx));
   {
   Heater button state UH_BTi:
   0 - Heater button OFF 
   1 - Heater button ON, qx=0
   2 - Heater button ON, qx>0
   3 - Heater button ON, ICTRL show wire cut
   4 - Heater button OFF, BLOCKING
   5 - Heater button OFF, BLOCKING
   Priority order: blocking, button, ICTRL, state of qx>0
   }
   if iGetTag(tagBLK[i])<>0 then bNul(iSetTag(tagST[i],4+iGetTag(tagBT[i]))) else
   if iGetTag(tagBT[i])=0 then bNul(iSetTag(tagST[i],0)) else 
   if iGetTag(tagICTRL[i])<>0 then bNul(iSetTag(tagST[i],3)) else
   if qx>0 then bNul(iSetTag(tagST[i],2)) else bNul(iSetTag(tagST[i],1));
   {
   Voice on UH_ICTRL
   }
   if iGetTag(tagST[i])=3 then begin
    if SecNow-LastICTRL[i]>MsgPeriod then begin
     if iGetTag(tagSOUNDX)<>0 then begin
      if UsesSpeakSrv
      then Speak(spk_ICTRL+' '+Str(i))
      else bNul(Voice(snd_ICTRL+' '+Str(i)));
     end;
     LastICTRL[i]:=SecNow;
    end;
   end else LastICTRL[i]:=0;
  end;
  {
  Update PREALX,TREALX tags, only in editing state
  }
  if ValidHNUM(TheHNUM) then begin
   bNul(rSetTag(tagPREALX,GetDi_Yn(iGetTag(tagHNUMX))));
   bNul(rSetTag(tagTREALX,GetAi_Yn(iGetTag(tagHNUMX))));
  end;
  {
  Handle sensor clicks
  }
  if (ClickButton=1)  then begin
   for i:=1 to NumHeats do begin
    {
    Press heater button if enabled
    }
    if IsSameText(ClickSensor,'UH_BT'+Str(i)) then 
    if iGetTag(tagHENABL[i])=0 then bNul(Voice(snd_Error)) else begin
     bNul(iSetTag(tagBT[i],Ord(iGetTag(tagBT[i])=0)));
     bNul(Voice(snd_Click));
    end;
    {
    Open Property dialog
    }
    if IsSameText(ClickSensor,'UH_CHECK'+Str(i)) then begin
     bNul(Voice(snd_Click));
     StartEditProperty(i);
    end;
    {
    Edit tags from main GUI
    }
    CheckStartEditHeater(i);
   end;
   {
   Edit tags from property dialog
   }
   if ValidHNUM(TheHNUM) then CheckStartEditProperty(TheHNUM);
   {
   Accept button pressed in property dialog
   }
   if ValidHNUM(TheHNUM) then
   if IsSameText(ClickSensor,'UH_CHECKX') then begin
    bNul(Voice(snd_Click));
    StopEditProperty;
   end;
   {
   Cancel button pressed in property dialog
   }
   if ValidHNUM(TheHNUM) then
   if IsSameText(ClickSensor,'UH_CANCELX') then begin
    bNul(Voice(snd_Click));
    CloseProperty;
   end;
   {
   SaveIni button pressed in property dialog
   }
   if ValidHNUM(TheHNUM) then
   if IsSameText(ClickSensor,'UH_SAVEINIX') then begin
    StopEditProperty;
    bNul(Voice(snd_Click));
    DevSendCmd(devMySelf,'@SaveIni');
   end;
   {
   LoadIni button pressed in property dialog
   }
   if ValidHNUM(TheHNUM) then
   if IsSameText(ClickSensor,'UH_LOADINIX') then begin
    DevSendCmd(devMySelf,'@LoadIni');
    bNul(Voice(snd_Click));
    CloseProperty;
   end;
   {
   Sound on/off button
   }
   if ValidHNUM(TheHNUM) then
   if ClickTag=tagSOUNDX then begin
    bNul(iSetTag(tagSOUNDX,Ord(iGetTag(tagSOUNDX)=0)));
    bNul(Voice(snd_Click));
   end;
   {
   Enable/disable buttons for heaters & blocking
   }
   if ValidHNUM(TheHNUM) then
   if (ClickTag=tagHENABLX) or (ClickTag=tagTENABLX)
   or (ClickTag=tagPENABLX) or (ClickTag=tagWENABLX) then begin
    bNul(iSetTag(ClickTag,Ord(iGetTag(ClickTag)=0)));
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   {
   Warning,Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then sNul(Edit(''));
   {
   Edit heater tags
   }
   nPs:=GetNumSensors(sGetTag(tagPNAMES));
   nTs:=GetNumSensors(sGetTag(tagTNAMES));
   CheckEditTagUpdate(tagQ1X,0,100);
   CheckEditTagUpdate(tagQ2X,0,100);
   CheckEditTagUpdate(tagQ3X,0,100);
   CheckEditTagUpdate(tagDT1X,0,1e4);
   CheckEditTagUpdate(tagDT2X,0,1e4);
   CheckEditTagUpdate(tagWDTX,0,1e4);
   CheckEditTagUpdate(tagTBLKX,_MinusInf,_PlusInf);
   CheckEditTagUpdate(tagPBLKX,_MinusInf,_PlusInf);
   CheckEditTagUpdate(tagTGOALX,_MinusInf,_PlusInf);
   CheckEditTagUpdate(tagTNUMX,1,nTs);
   CheckEditTagUpdate(tagPNUMX,1,nPs);
   CheckEditSensor(tagTNUMX,1,nTs);
   CheckEditSensor(tagPNUMX,1,nPs);
   for i:=1 to NumHeats do begin
    CheckEditTagUpdate(tagQ1[i],0,100);
    CheckEditTagUpdate(tagQ2[i],0,100);
    CheckEditTagUpdate(tagQ3[i],0,100);
    CheckEditTagUpdate(tagDT1[i],0,1e4);
    CheckEditTagUpdate(tagDT2[i],0,1e4);
    CheckEditTagUpdate(tagWDT[i],0,1e4);
    CheckEditTagUpdate(tagTBLK[i],_MinusInf,_PlusInf);
    CheckEditTagUpdate(tagPBLK[i],_MinusInf,_PlusInf);
    CheckEditTagUpdate(tagTGOAL[i],_MinusInf,_PlusInf);
    CheckEditTagUpdate(tagTNUM[i],1,nTs);
    CheckEditTagUpdate(tagPNUM[i],1,nPs);
    CheckEditSensor(tagTNUM[i],1,nTs);
    CheckEditSensor(tagPNUM[i],1,nPs);
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @LoadIni
   }
   if IsSameText(cmd,'@LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @SaveIni
   }
   if IsSameText(cmd,'@SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
