---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по GENDC

**GENDC** - система управления источниками питания
серии **[GENESYS series DC power supplies](https://www.tdk-lambda.com)**
производства **[TDK-Lambda](https://www.tdk-lambda.com)**.

Документация: **[Worksheet](worksheet/)**.

Спецификация **DIM**-сервера: <a href="worksheet/dim-spec-gendc.pdf">Worksheet/dim-spec-gendc.pdf</a>.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Возможности системы

1. Удаленное (по **RS-232**) управление источниками питания **GENESYS** - до **9** штук;  
2. Измерение напряжений, токов, мощностей, регистров состояния источников **GENESYS**;  
3. Задание напряжений, токов, параметров защиты источников **GENESYS**;  
4. Публикация данных в сети по протоколу **DIM**;  
5. Протоколирование результатов измерений.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Список сокращений и аббревиатур

Для именования кривых, тегов, сенсоров, окон и других программных объектов
используются следующие **соглашения о наименовании**:
``` ini
Система:
 GENDC      - Название серии
Подсистема:
 GEN1       - Источник питания GENESYS номер 1
 ....       - ................................
 GEN9       - Источник питания GENESYS номер 9
Параметры:
 .POLL_RATE - Частота опроса, Гц                ( POLLing RATE      )
 .ERROR_CNT - Счетчик ошибок                    ( ERROR CouNTer     )
 .ID_IDN    - название модели источника         ( model IDeNtifier  )
 .ID_REV    - версия прошивки источника         ( software REVision )
 .PAR_MC    - измеренный ток                    ( Measure Current   )
 .PAR_MV    - измеренное напряжение             ( Measure Voltage   )
 .PAR_MW    - измеренная мощность               ( Measure Watt      )
 .PAR_PC    - уставка тока                      ( Program Current   )
 .PAR_PV    - уставка напряжения                ( Program Voltage   )
 .PAR_OV    - уставка защиты от перенапряжения  ( Over    Voltage   )
 .PAR_UV    - уставка защиты от падения напр-я  ( Under   Voltage   )
 .PAR_SR    - регистр состояния                 ( Status  Register  )
              Bit 0  CV      - стабилизация по напряжению (const voltage)
              Bit 1  CC      - стабилизация по току       (const current)
              Bit 2  NFLT    - флаг "не было ошибок"      (no faults    )
              Bit 3  FLT     - флаг "обнаружены ошибки"   (faults       )
              Bit 4  AST     - флаг "автостарт разрешен"  (autostart    )
              Bit 5  FDE     - флаг "защита разрешена"    (fold enable  )
              Bit 6  SPARE   - не используется (ноль)     (spare, zero  )
              Bit 7  LCL     - флаг "локальный режим"     (local mode   )
 .PAR_FR    - регистр ошибок и сбоев            ( Faults Register  )
              Bit 0  SPARE   - не используется (ноль)     (spare, zero  )
              Bit 1  AC      - сбой по питанию            (AC fail      )
              Bit 2  OTP     - защита по температуре   (over temp. prot.)
              Bit 3  FOLD    - защита по току            (foldback prot.)
              Bit 4  OVP     - защита по напряжению    (over volt. prot.)
              Bit 5  SO      - shut off
              Bit 6  OFF     - output off
              Bit 7  ENA     - rare panel enable terminals opened
 .BT_OUT    - кнопка/состояние Выхода                   ( BuTton OUTput )
              Bit 0  button  - состояние кнопки
              Bit 1  state   - состояние OUT 
Например:
 GENDC.GEN1.PAR_MV - измеренное напряжение источника - GEN1 в системе GENDC
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>.

---
