---

# Пример DEMO_EC3X32

Программа содержит драйвер для контроллера **Emerson EC3-X32**.

В состав демонстрации входит драйвер **`&EC3X32_DRV`** и симулятор **`&EC3X32_SIM`**.
И драйвер, и симулятор реализованы в виде одной и той же программы **[ec3x32_drv.pas](ec3x32_drv.pas)**,
только драйвер имеет **HostAddr** (**IP** адрес контроллера), а симулятор - не имеет.

В драйвере реализовано только чтение данных контроллера, так как настройка предполагается
через **Web** сервер контроллера. Данные никак не обрабатываются, а просто пересылаются
в виде сообщений устройству **TargetDevice**, с заданным префиксом **TargetMessage**.
Предполагается, что целевое устройство будет само обрабатывать данные контроллера
через консольный интерпретатор.


```
Emerson protocol description:
-----------------------------
1)Open TCP port 1030 as client.
2)Send message "page 0\0" to controller (i.e. 'page 0'+Chr(0) on Pascal).
3)Reply will be long ampersand-separated string looks like that:
  nvomo01=4.29&nvomo02=6.25&nvomo03=10.25&nvomo04=29.37&nvomo05=-3.92&
  nvomo06=1&nvomo07=2&nvomo08=26&nvomo09=29&nvomo10=11&nvomo11=2000&nvomo12=1&
  nvomo13=1&nvomo14=-1&nvomo15=10.0&nvomo16=0&nvomo17=4&nvomo18=129&
4)Ampersand (&) separated fields are:
  Name    | Description              | Units
  -----------------------------------------------
  nvomo01 | Suction pressure         | bar
  nvomo02 | Suction gas temperature  | °C
  nvomo03 | Superheat                | K
  nvomo04 | Valve opening            | %
  nvomo05 | Evaporating temperature  | °C
  nvomo06 | Digital inputs           | 1: Cooling demand
  nvomo07 | Digital outputs          | 1: Alarm, 2:Compressor
  nvomo08 | ?                        | ?
  nvomo09 | ?                        | ?
  nvomo10 | ?                        | ?
  nvomo11 | ?                        | ?
  nvomo12 | ?                        | ?
  nvomo13 | ?                        | ?
  nvomo14 | ?                        | ?
  nvomo15 | Superheat setpoint       | K
  nvomo16 | ?                        | ?
  nvomo17 | ?                        | ?
  nvomo18 | ?                        | ?
```

---
