 {
 ***********************************************************************
 CCTB - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Cmd.LoadIni           - Load tags from custom INI file.
| @Cmd.SaveIni           - Save tags to   custom INI file.
| @MenuCloseConfirmation - for internal use
|********************************************************
[]
 }
program cctb_main_ctrl;          { CCTB - main control program      }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 RatePeriod        = 1000;       { Calculate rate period            }
 NumParams         = 32;         { 0..NumParams-1 of CCTB.PARAM.*   }
 NumAcknos         = 5;          { 0..NumAcknos-1 of CCTB.ACKNO.*   }
 NumSects          = 5;          { Number of sections               }
 NumCards          = 6;          { Number of E140 cards             }          
 sb_BadSensor      = 0;          { Status bit: invalid sensor       }
 sb_FaultFlag      = 1;          { Status bit: external fault flag  }
 sb_UnderRang      = 2;          { Status bit: under low range      }
 sb_OverRange      = 3;          { Status bit: over high range      }
 sb_WireBreak      = 4;          { Status bit: sensor wire break    }
 sb_DeadShort      = 5;          { Status bit: sensor dead short    }
 do_ParamState     = 0;          { DO index of prarameter's state   }
 do_StateReady     = 32;         { DO index of state READY          }
 do_PollRateRx     = 33;         { DO index of modbus poll rate RX  }
 do_PollRateTx     = 34;         { DO index of modbus poll rate TX  }
 do_AdamRateRx     = 35;         { DO index of adam poll rate RX    }
 do_AdamRateTx     = 36;         { DO index of adam poll rate TX    }

type
 TTagRef           = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;
 TValueStateRec    = record Value,Time,mv,ma:Real; Fault,State:Integer; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 CCTB              : record      { All CCTB data                    }
  CMD              : record      { CoMmandDs to control CCTB GUI    }
   HELP            : TTagRef;    { Open Help                        }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   ZERO            : TTagRef;    { Zero all stat. counters          }
   TOOLS           : TTagRef;    { Tools menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
   SAVEINI         : TTagRef;    { Save INI                         }
   LOADINI         : TTagRef;    { Load INI                         }
  end;                           {                                  }
  SEN              : record      { Sensor settings                  }
   LO_IX           : TTagRef;    { Sensor Lo range mA               }
   HI_IX           : TTagRef;    { Sensor Hi range mA               }
   LO_PX           : TTagRef;    { Sensor Lo range kPa              }
   HI_PX           : TTagRef;    { Sensor Hi range kPa              }
   LO_TX           : TTagRef;    { Sensor Lo range °C               }
   HI_TX           : TTagRef;    { Sensor Hi range °C               }
   LO_GX           : TTagRef;    { Sensor Lo range kg/s             }
   HI_GX           : TTagRef;    { Sensor Hi range kg/s             }
   BREAK_MA        : TTagRef;    { Sensor break mA                  }
   SHORT_MV        : TTagRef;    { Sensor dead short mV             }
   TIMEOUT         : TTagRef;    { Sensor poll timeout, ms          }
   NOTIFY          : TTagRef;    { Sensor dialog notification       }
  end;                           {                                  }
  STATE            : record      { State tags                       }
   MODE            : TTagRef;    { Word/simulation                  }
  end;                           {                                  }
  ADAMPOLLC,                     { ADAM poll counter                }
  ADAMPOLLR,                     { ADAM poll rate                   }
  ADAMBYTEC,                     { ADAM byte counter                }
  ADAMBYTER        : record      { ADAM byte rate                   }
   Rx,Tx           : TTagRef;    { Receiver, Transmitter            }
  end;                           {                                  }
  devAdamSimDlg    : Integer;    { ADAM Simulator device            }
  devMainSimDlg    : Integer;    { MAIN Simulator device            }
  devMainSenDlg    : Integer;    { MAIN Sensor params dialog device }
  LastRate         : Real;       { Time of last rate                }
  Param            : array[0..NumParams] of TValueStateRec; { PARAM }
  Ackno            : array[0..NumAcknos] of Integer; { ACKNO.PS*    }
  Ready            : Integer;    { READY state                      }
  PollRateRx       : TTagRef;    { Modbus poll rate RX tag          }
  PollRateTx       : TTagRef;    { Modbus poll rate TX tag          }
  AdamRateRx       : TTagRef;    { Adam   poll rate RX tag          }
  AdamRateTx       : TTagRef;    { Adam   poll rate TX tag          }
  E140Start        : array[1..NumCards] of TTagRef; { E140_N.Start  }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Check if main simulation mode.
 }
 function IsMainSimulation:Boolean;
 begin
  IsMainSimulation:=(CCTB.devMainSimDlg<>0);
 end;
 {
 Check if adam simulation mode.
 }
 function IsAdamSimulation:Boolean;
 begin
  IsAdamSimulation:=(CCTB.devAdamSimDlg<>0);
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Завершить пакет CRW-DAQ' else
  if MenuClose=1 then MenuCloseItem:='Завершить     сеанс DAQ' else
  if MenuClose=2 then MenuCloseItem:='Перезагрузить сеанс DAQ' else
  if MenuClose=3 then MenuCloseItem:='Рестарт сервера '+DatSrv else
  if MenuClose=4 then MenuCloseItem:='Рестарт сервера '+CronSrv else
  if MenuClose=5 then MenuCloseItem:='Рестарт сервера '+ModbusSrv else
  if MenuClose=6 then MenuCloseItem:='Завершить сеанс Windows' else
  if MenuClose=7 then MenuCloseItem:='Перезагрузить компьютер' else
  if MenuClose=8 then MenuCloseItem:='Выключить     компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
 procedure MenuCloseCmnd(MenuClose:Integer);
 begin
  if MenuClose=0  then Cron('@Shutdown Crw Exit');
  if MenuClose=1  then Cron('@Shutdown Daq Exit');
  if MenuClose=2  then Cron('@Shutdown Daq Restart');
  if MenuClose=3  then Cron('@Eval @System @Async @Daq Compile '+DatSrv);
  if MenuClose=4  then Cron('@Eval @System @Async @Daq Compile '+CronSrv);
  if MenuClose=5  then Cron('@Eval @System @Async @Daq Compile '+ModbusSrv);
  if MenuClose=6  then Cron('@Shutdown Win Logout');
  if MenuClose=7  then Cron('@Shutdown Win Restart');
  if MenuClose=8  then Cron('@Shutdown Win Exit');
 end;
 {
 Find comma separated window list where curve is inside.
 }
 function ListWinByCurve(crv:Integer):String;
 var list,win:String; n,m,i,j,t,c:Integer;
 begin
  list:=''; win:='';
  if not IsEmptyStr(CrvName(crv)) then for m:=1 to 2 do begin
   n:=0;
   repeat
    c:=0;
    win:=ParamStr(ExtractWord(m,'CURWINNAME,TABWINNAME')+' '+Str(n)); n:=n+1;
    if not IsEmptyStr(win) then begin
     t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(win,'[',']'));
     for i:=0 to Text_NumLn(t)-1 do
     if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'CurveList') then
     for j:=2 to WordCount(Text_GetLn(t,i)) do
     if IsSameText(ExtractWord(j,Text_GetLn(t,i)),CrvName(crv)) then c:=c+1;
     bNul(Text_Free(t));
     if c>0 then
     if IsEmptyStr(list) then list:=win else list:=list+','+Trim(win);
    end;
   until IsEmptyStr(win);
  end;
  ListWinByCurve:=list;
  list:=''; win:='';
 end;
 {
 Select windows where curve is inside.
 }
 procedure SelectWinByCurve(crv:Integer);
 var list:String; i:Integer;
 begin
  list:='';
  list:=ListWinByCurve(crv);
  for i:=1 to WordCountDelims(list,Dump(',')) do begin
   bNul(WinSelect(ExtractWordDelims(i,list,Dump(','))));
   bNul(WinDraw(ExtractWordDelims(i,list,Dump(','))+'|SelectCurve='+CrvName(crv)));
  end;
  list:='';
 end;
 {
 Adam simulator by curve.
 }
 procedure AdamSimByCurve(crv:Integer; Hint:String);
 var wi,port,addr:Integer;
 begin
  if CCTB.devAdamSimDlg<>0 then begin
   bNul(Action(RefInfo(CCTB.devAdamSimDlg,'Name')));
   wi:=WordIndex('COM',Hint);
   if wi>0 then begin
    port:=Val(ExtractWord(wi+1,Hint));
    addr:=Val(ExtractWord(wi+2,Hint));
    if (port>=1) and (port<=32)
    then bNul(iSetTag(FindTag(ReadIni('tagCCTB')+'.ADAM.SIM.PORT'),port));
    if (addr>=1) and (addr<=255)
    then bNul(sSetTag(FindTag(ReadIni('tagCCTB')+'.ADAM.SIM.REQ'),'#'+HexB(addr)));
   end;
  end;
 end;
 {
 CCTB initialization
 }
 procedure CCTB_INIT;
 var i:Integer;
 begin
  {
  Initialize tags...
  }
  InitDevice(CCTB.devAdamSimDlg, ReadIni('devAdamSimDlg'),            1);
  InitDevice(CCTB.devMainSimDlg, ReadIni('devMainSimDlg'),            1);
  InitDevice(CCTB.devMainSenDlg, ReadIni('devMainSenDlg'),            1);
  InitTag(CCTB.CMD.HELP.tag,     ReadIni('tagCCTB')+'.CMD.HELP',      1);
  InitTag(CCTB.CMD.OPEN.tag,     ReadIni('tagCCTB')+'.CMD.OPEN',      1);
  InitTag(CCTB.CMD.SAVE.tag,     ReadIni('tagCCTB')+'.CMD.SAVE',      1);
  InitTag(CCTB.CMD.ZERO.tag,     ReadIni('tagCCTB')+'.CMD.ZERO',      1);
  InitTag(CCTB.CMD.TOOLS.tag,    ReadIni('tagCCTB')+'.CMD.TOOLS',     1);
  InitTag(CCTB.CMD.SMILE.tag,    ReadIni('tagCCTB')+'.CMD.SMILE',     1);
  InitTag(CCTB.CMD.CLOSE.tag,    ReadIni('tagCCTB')+'.CMD.CLOSE',     1);
  InitTag(CCTB.CMD.SAVEINI.tag,  ReadIni('tagCCTB')+'.CMD.SAVEINI',   1);
  InitTag(CCTB.CMD.LOADINI.tag,  ReadIni('tagCCTB')+'.CMD.LOADINI',   1);
  InitTag(CCTB.STATE.MODE.tag,   ReadIni('tagCCTB')+'.STATE.MODE',    1);
  InitTag(CCTB.SEN.LO_IX.tag,    ReadIni('tagCCTB')+'.SEN.LO_IX',     2);
  InitTag(CCTB.SEN.HI_IX.tag,    ReadIni('tagCCTB')+'.SEN.HI_IX',     2);
  InitTag(CCTB.SEN.LO_PX.tag,    ReadIni('tagCCTB')+'.SEN.LO_PX',     2);
  InitTag(CCTB.SEN.HI_PX.tag,    ReadIni('tagCCTB')+'.SEN.HI_PX',     2);
  InitTag(CCTB.SEN.LO_TX.tag,    ReadIni('tagCCTB')+'.SEN.LO_TX',     2);
  InitTag(CCTB.SEN.HI_TX.tag,    ReadIni('tagCCTB')+'.SEN.HI_TX',     2);
  InitTag(CCTB.SEN.LO_GX.tag,    ReadIni('tagCCTB')+'.SEN.LO_GX',     2);
  InitTag(CCTB.SEN.HI_GX.tag,    ReadIni('tagCCTB')+'.SEN.HI_GX',     2);
  InitTag(CCTB.SEN.BREAK_MA.tag, ReadIni('tagCCTB')+'.SEN.BREAK_MA',  2);
  InitTag(CCTB.SEN.SHORT_MV.tag, ReadIni('tagCCTB')+'.SEN.SHORT_MV',  2);
  InitTag(CCTB.SEN.TIMEOUT.tag,  ReadIni('tagCCTB')+'.SEN.TIMEOUT',   2);
  InitTag(CCTB.SEN.NOTIFY.tag,   ReadIni('tagCCTB')+'.SEN.NOTIFY',    1);
  InitTag(CCTB.ADAMPOLLC.RX.tag, ReadIni('tagCCTB')+'.ADAMPOLLC.RX',  2);
  InitTag(CCTB.ADAMPOLLC.TX.tag, ReadIni('tagCCTB')+'.ADAMPOLLC.TX',  2);
  InitTag(CCTB.ADAMPOLLR.RX.tag, ReadIni('tagCCTB')+'.ADAMPOLLR.RX',  2);
  InitTag(CCTB.ADAMPOLLR.TX.tag, ReadIni('tagCCTB')+'.ADAMPOLLR.TX',  2);
  InitTag(CCTB.ADAMBYTEC.RX.tag, ReadIni('tagCCTB')+'.ADAMBYTEC.RX',  2);
  InitTag(CCTB.ADAMBYTEC.TX.tag, ReadIni('tagCCTB')+'.ADAMBYTEC.TX',  2);
  InitTag(CCTB.ADAMBYTER.RX.tag, ReadIni('tagCCTB')+'.ADAMBYTER.RX',  2);
  InitTag(CCTB.ADAMBYTER.TX.tag, ReadIni('tagCCTB')+'.ADAMBYTER.TX',  2);
  InitTag(CCTB.PollRateRx.tag,   CrvName(RefDo(do_PollRateRx)),       2);
  InitTag(CCTB.PollRateTx.tag,   CrvName(RefDo(do_PollRateTx)),       2);
  InitTag(CCTB.AdamRateRx.tag,   CrvName(RefDo(do_AdamRateRx)),       2);
  InitTag(CCTB.AdamRateTx.tag,   CrvName(RefDo(do_AdamRateTx)),       2);
  for i:=1 to NumCards do begin
   InitTag(CCTB.E140Start[i].tag, StrReplace(ReadIni('tagE140Start'),Dump('#'),Str(i),3), -1);
   CCTB.E140Start[i].val:=iGetTag(CCTB.E140Start[i].tag);
  end;
  {
  Initialize values
  }
  CCTB.CMD.CLOSE.val:=-1;
  CCTB.CMD.SMILE.val:=GetErrCount(-2);
  bNul(rSetTag(CCTB.ADAMPOLLC.RX.tag,0));
  bNul(rSetTag(CCTB.ADAMPOLLC.TX.tag,0));
  bNul(rSetTag(CCTB.ADAMPOLLR.RX.tag,0));
  bNul(rSetTag(CCTB.ADAMPOLLR.TX.tag,0));
  bNul(rSetTag(CCTB.ADAMBYTEC.RX.tag,0));
  bNul(rSetTag(CCTB.ADAMBYTEC.TX.tag,0));
  bNul(rSetTag(CCTB.ADAMBYTER.RX.tag,0));
  bNul(rSetTag(CCTB.ADAMBYTER.TX.tag,0));
  CCTB.LastRate:=0;
  for i:=0 to NumParams-1 do begin
   CCTB.Param[i].mv:=0;
   CCTB.Param[i].ma:=0;
   CCTB.Param[i].Time:=0;
   CCTB.Param[i].Value:=0;
   CCTB.Param[i].State:=0;
   CCTB.Param[i].Fault:=0;
  end;
  for i:=0 to NumAcknos-1 do CCTB.Ackno[i]:=0;
  {
  Load custom INI file tags on start
  }
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRW('R','',2));
 end;
 {
 CCTB finalization
 }
 procedure CCTB_FREE;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
 end;
 {
 Calculate parameter's STATE bits.
 }
 procedure CCTB_CALC_STATE;
 var i:Integer; msElapsed:Real;
     TimeOut,BadSensor,FaultFlag,UnderRang,OverRange,WireBreak,DeadShort:Boolean;
 begin
  {
  Take PARAM's values and FAULT flags.
  }
  for i:=0 to NumParams-1 do begin
   CCTB.Param[i].Time:=GetAi_Xn(i);
   CCTB.Param[i].Value:=GetAi_Yn(i);
   CCTB.Param[i].Fault:=Round(DiWord(i,1));
   CCTB.Param[i].mv:=GetAi_Yn(NumParams+i);
   CCTB.Param[i].ma:=GetAi_Yn(NumParams*2+i);
  end;
  {
  Take ACKNO's flags.
  }
  for i:=0 to NumAcknos-1 do CCTB.Ackno[i]:=Round(DiWord(NumParams+i,1));
  {
  Calculate STATE bits.
  Fault flag?         - Copy external
  Sensor under range? - Current < 4 mA
  Sensor over range?  - Current > 20 mA
  Sensor dead short?  - Current <= 1 mA
  Sensor wire break?  - Voltage >= 2500 mV
  Bad sensor?         - Timeout or dead short or wire break
  }
  for i:=0 to NumParams-1 do begin
   CCTB.Param[i].State:=0;
   FaultFlag:=(CCTB.Param[i].Fault>0);
   msElapsed:=(Time-CCTB.Param[i].Time)*TimeUnits;
   TimeOut:=(msElapsed>rGetTag(CCTB.SEN.TIMEOUT.tag));
   UnderRang:=(CCTB.Param[i].ma<rGetTag(CCTB.SEN.LO_IX.tag));
   OverRange:=(CCTB.Param[i].ma>rGetTag(CCTB.SEN.HI_IX.tag));
   DeadShort:=(CCTB.Param[i].mv>=rGetTag(CCTB.SEN.SHORT_MV.tag));
   WireBreak:=(CCTB.Param[i].ma<=rGetTag(CCTB.SEN.BREAK_MA.tag));
   BadSensor:=TimeOut or WireBreak or DeadShort;
   if i<2*NumSects then begin // Px
    UnderRang:=UnderRang or (CCTB.Param[i].Value<rGetTag(CCTB.SEN.LO_PX.tag));
    OverRange:=OverRange or (CCTB.Param[i].Value>rGetTag(CCTB.SEN.HI_PX.tag));
   end else
   if i<6*NumSects then begin // Tx
    UnderRang:=UnderRang or (CCTB.Param[i].Value<rGetTag(CCTB.SEN.LO_TX.tag));
    OverRange:=OverRange or (CCTB.Param[i].Value>rGetTag(CCTB.SEN.HI_TX.tag));
   end else
   if i<6*NumSects+2 then begin // Gx
    UnderRang:=UnderRang or (CCTB.Param[i].Value<rGetTag(CCTB.SEN.LO_GX.tag));
    OverRange:=OverRange or (CCTB.Param[i].Value>rGetTag(CCTB.SEN.HI_GX.tag));
   end;
   if BadSensor then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_BadSensor));
   if FaultFlag then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_FaultFlag));
   if UnderRang then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_UnderRang));
   if OverRange then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_OverRange));
   if WireBreak then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_WireBreak));
   if DeadShort then CCTB.Param[i].State:=iOr(CCTB.Param[i].State,iShift(1,sb_DeadShort));
  end;
  {
  Calculate READY state.
  }
  CCTB.Ready:=1;
  for i:=0 to NumSects-1 do begin
   if CCTB.Ackno[i]=0 then
   if IsBit(CCTB.Param[i*2+0].State,sb_WireBreak) then
   if IsBit(CCTB.Param[i*2+1].State,sb_WireBreak) then
   if IsBit(CCTB.Param[i*4+2*NumSects+0].State,sb_WireBreak) then
   if IsBit(CCTB.Param[i*4+2*NumSects+1].State,sb_WireBreak) then
   if IsBit(CCTB.Param[i*4+2*NumSects+2].State,sb_WireBreak) then
   if IsBit(CCTB.Param[i*4+2*NumSects+3].State,sb_WireBreak) then
   CCTB.Ready:=iOr(CCTB.Ready,iShift(1,1+i));
  end;
  if iAnd(CCTB.Ready,iNot(1))<>0 then CCTB.Ready:=iAnd(CCTB.Ready,iNot(1));
  {
  Update STATE bits. Update READY state.
  }
  for i:=0 to NumParams-1 do UpdateDo(do_ParamState+i,time,CCTB.Param[i].State);
  UpdateDo(do_StateReady,time,CCTB.Ready);
 end;
 {
 CCTB polling
 }
 procedure CCTB_POLL;
 var errors:Real; i,card,ClickCurve:Integer;
  procedure AdamTraffic(data:String; ms:Real);
  var pctx,bctx,pcrx,bcrx,dt:Real;
   procedure CalcRate(rtag,ctag:Integer; var cval:Real; val,dt:Real);
   begin
    bNul(rSetTag(ctag,val));
    bNul(rSetTag(rtag,1000*(val-cval)/dt));
    cval:=val;
   end;
  begin
   if Length(data)>0 then begin
    dt:=ms-CCTB.LastRate;
    if dt>0 then begin
     pctx:=rValDef(ExtractWord(1,data),0);
     bctx:=rValDef(ExtractWord(2,data),0);
     pcrx:=rValDef(ExtractWord(3,data),0);
     bcrx:=rValDef(ExtractWord(4,data),0);
     CalcRate(CCTB.ADAMPOLLR.TX.tag,CCTB.ADAMPOLLC.TX.tag,CCTB.ADAMPOLLC.TX.val,pctx,dt);
     CalcRate(CCTB.ADAMBYTER.TX.tag,CCTB.ADAMBYTEC.TX.tag,CCTB.ADAMBYTEC.TX.val,bctx,dt);
     CalcRate(CCTB.ADAMPOLLR.RX.tag,CCTB.ADAMPOLLC.RX.tag,CCTB.ADAMPOLLC.RX.val,pcrx,dt);
     CalcRate(CCTB.ADAMBYTER.RX.tag,CCTB.ADAMBYTEC.RX.tag,CCTB.ADAMBYTEC.RX.val,bcrx,dt);
    end;
    CCTB.LastRate:=ms;
   end;
  end;
 begin
  {
  Calculate parameter's STATE (if not simulation)
  }
  if not IsMainSimulation then CCTB_CALC_STATE;
  bNul(iSetTag(CCTB.STATE.MODE.tag,Ord(IsMainSimulation)+2*Ord(IsAdamSimulation)));
  {
  Switch ADAM's OFF/ON if E140 cards ON/OFF
  }
  for card:=1 to NumCards do
  if ShouldRefresh(CCTB.E140Start[card].val,iGetTag(CCTB.E140Start[card].tag))>0 then begin
   for i:=1 to 8 do
   if CCTB.E140Start[card].val>0
   then Cron('@cron.run CCTB.BKS.ADAM.D'+Str((card-1)*8+i)+'.OFF')
   else Cron('@cron.run CCTB.BKS.ADAM.D'+Str((card-1)*8+i)+'.ON');
  end;
  {
  Execute GUI commands.
  }
  if iGetTag(CCTB.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(CCTB.CMD.HELP.tag,0));
  end;
  if iGetTag(CCTB.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(CCTB.CMD.OPEN.tag,0));
  end;
  if iGetTag(CCTB.CMD.ZERO.tag)<>0 then begin
   DevSendCmd(devModbusSrv,'@ZeroPortCounters');
   bNul(iSetTag(CCTB.CMD.ZERO.tag,0));
  end;
  if iGetTag(CCTB.CMD.TOOLS.tag)<>0 then begin
   if IsMainSimulation then bNul(Action(RefInfo(CCTB.devMainSimDlg,'Name')));
   bNul(Action(RefInfo(CCTB.devMainSenDlg,'Name')));
   bNul(iSetTag(CCTB.CMD.TOOLS.tag,0));
  end;
  if iGetTag(CCTB.CMD.CLOSE.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Закрыть"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuCloseItem(0))
              +Edit(' '+MenuCloseItem(1))
              +Edit(' '+MenuCloseItem(2))
              +Edit(' '+MenuCloseItem(3))
              +Edit(' '+MenuCloseItem(4))
              +Edit(' '+MenuCloseItem(5))
              +Edit(' '+MenuCloseItem(6))
              +Edit(' '+MenuCloseItem(7))
              +Edit(' '+MenuCloseItem(8))
              +Edit(')MenuList MENU_'+NameTag(CCTB.CMD.CLOSE.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(CCTB.CMD.CLOSE.tag,0));
   CCTB.CMD.CLOSE.val:=-1;
  end;
  if iGetTag(CCTB.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(CCTB.CMD.SAVEINI.tag,0));
   DevSendCmd(devMySelf,'@Cmd.SaveIni');
  end;
  if iGetTag(CCTB.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(CCTB.CMD.LOADINI.tag,0));
   DevSendCmd(devMySelf,'@Cmd.LoadIni');
  end;
  {
  Handle Smile
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   errors:=GetErrCount(-2);
   if errors>CCTB.CMD.SMILE.val then bNul(iSetTag(CCTB.CMD.SMILE.tag,2)) else
   if iGetTag(CCTB.CMD.SMILE.tag)>1 then bNul(iSetTag(CCTB.CMD.SMILE.tag,1));
   CCTB.CMD.SMILE.val:=errors;
  end;
  {
  Calculate ADAM rate. Update poll rate curves.
  }
  if SysTimer_Pulse(RatePeriod)>0 then begin
   AdamTraffic(ParamStr('AdamTraffic'),mSecNow);
   UpdateDo(do_PollRateRx,time,rGetTag(CCTB.PollRateRx.tag));
   UpdateDo(do_PollRateTx,time,rGetTag(CCTB.PollRateTx.tag));
   UpdateDo(do_AdamRateRx,time,rGetTag(CCTB.AdamRateRx.tag));
   UpdateDo(do_AdamRateTx,time,rGetTag(CCTB.AdamRateTx.tag));
  end;
  {
  Handle dialog SEN.DLG
  }
  if iGetTag(CCTB.SEN.NOTIFY.tag)<>0 then begin
   if iGetTag(CCTB.SEN.NOTIFY.tag)=1 then begin // Ok
   end;
   if iGetTag(CCTB.SEN.NOTIFY.tag)=2 then begin // Cancel
   end;
   bNul(iSetTag(CCTB.SEN.NOTIFY.tag,0));
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then begin
    sNul(Edit(''));
   end;
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then begin
    sNul(Edit(''));
   end;
   {
   CLOSE menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(CCTB.CMD.CLOSE.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     CCTB.CMD.CLOSE.val:=Val(Edit('?ans 1'));
     if CCTB.CMD.CLOSE.val>=0 then
     if (CCTB.CMD.CLOSE.val>2) then begin
      DevSendCmd(devMySelf,'@MenuCloseConfirmation '+UpCaseStr(StrReplace(StrReplace(
                  MenuCloseItem(Round(CCTB.CMD.CLOSE.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuCloseCmnd(Round(CCTB.CMD.CLOSE.val));
      CCTB.CMD.CLOSE.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(CCTB.CMD.CLOSE.tag)) then begin
    if CCTB.CMD.CLOSE.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuCloseCmnd(Round(CCTB.CMD.CLOSE.val));
    CCTB.CMD.CLOSE.val:=-1;
    sNul(Edit(''));
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(CCTB.CMD.HELP.tag,1);
   ClickBitXorLocal(CCTB.CMD.OPEN.tag,1);
   ClickBitXorLocal(CCTB.CMD.SAVE.tag,1);
   ClickBitXorLocal(CCTB.CMD.ZERO.tag,1);
   ClickBitXorLocal(CCTB.CMD.TOOLS.tag,1);
   ClickBitXorLocal(CCTB.CMD.CLOSE.tag,1);
   ClickBitXorLocal(CCTB.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(CCTB.CMD.LOADINI.tag,1);
   if ClickTag=CCTB.CMD.SAVE.tag then DevSendCmd(devDatSrv,'  ');
   {
   Smile face button...
   }
   if ClickTag=CCTB.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(CCTB.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then SelectWinByCurve(ClickCurve);
   if (ClickTag=CCTB.PollRateRx.tag) or (ClickTag=CCTB.PollRateTx.tag)
   or (ClickTag=CCTB.AdamRateRx.tag) or (ClickTag=CCTB.AdamRateTx.tag)
   then SelectWinByCurve(RefFind('Curve '+NameTag(ClickTag)));
   {
   User utilities: @MODxxx
   }
   if Pos('@MOD',ClickSensor)=1 then begin
    DevSendCmd(devModbusSrv,ClickSensor);
    bNul(Voice(snd_Click));
   end;
   if Pos('@E140',ClickSensor)=1 then begin
    Cron('@WinSelect CCTB.'+Copy(ClickSensor,2)+'.CTRL.GUI');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'@CCTB_TESTER') then begin
    Cron('@Run '+DaqFileRef(AdaptExeFileName('..\Utility\cctb_tester\cctb_tester.exe'),''));
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    if IsMainSimulation then bNul(Action(RefInfo(CCTB.devMainSimDlg,'Name'))) else
    if IsAdamSimulation then AdamSimByCurve(ClickCurve,Url_Decode(ClickParams('Hint')));
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  CCTB_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  CCTB_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  CCTB_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Cmd.LoadIni
   }
   if IsSameText(cmd,'@Cmd.LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if IsSameText(cmd,'@Cmd.SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @MenuCloseConfirmation
   }
   if IsSameText(cmd,'@MenuCloseConfirmation') then begin
    if CCTB.CMD.CLOSE.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(CCTB.CMD.CLOSE.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
