 {
 ***********************************************************************
 Daq Pascal application program CCTB_BKS_MIXER.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program cctb_bks_mixer;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxNumAos  = 1024;              { Max.number of AnalogOutputs      }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagMixer   : array[0..MaxNumAos] of Integer; { Mixer tags          }
 LastX      : array[0..MaxNumAos] of Real;    { Last X processed    }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Mixer Reset.
 }
 procedure Mixer_Reset;
 var nao:Integer;
 begin
  for nao:=0 to NumAos-1 do begin
   InitTag(tagMixer[nao],ReadIni('tagMixer#'+Str(nao)),-1);
   if TypeTag(tagMixer[nao])>0 then Success('tagMixer#'+Str(nao)+' = '+NameTag(tagMixer[nao]));
   LastX[nao]:=_MinusInf;
  end;
 end;
 {
 Mixer polling.
 }
 procedure Mixer_Poll;
 var nao,tag,mix,cai,cao,n,i,ia,ib:Integer; x,y:Real;
 begin
  for nao:=0 to NumAos-1 do begin
   tag:=tagMixer[nao];
   if TypeTag(tag)=1 then mix:=iGetTag(tag) else mix:=0;
   cai:=RefAi(NumAos*mix+nao);
   cao:=RefAo(nao);
   if cao<>0 then
   if cai<>0 then begin
    n:=0;
    bNul(CrvLock(cai));
    ib:=Round(CrvLen(cai));
    if ib>0 then begin
     ia:=Round(CrvWhere(cai,LastX[nao]));
     for i:=ia to ib do begin
      x:=CrvX(cai,i);
      if x>LastX[nao] then begin
       LastX[nao]:=x;
       y:=CrvY(cai,i);
       UpdateAo(nao,x,y);
       n:=n+1;
      end;
     end;
    end;
    bNul(CrvUnlock(cai));
    if n>0 then if iAnd(DebugFlags,dfDetails)>0 then
    Details('Update '+Str(n)+' points of '+CrvName(cao)+' from '+CrvName(cai));
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  Mixer_Reset;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  Mixer_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Reset
   }
   if IsSameText(cmd,'@Reset') then begin
    Mixer_Reset;
    Success(cmd+'=1');
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
