@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem **************************************
rem Birger devices config generator
rem **************************************

chcp 65001

:Main
call :InitializeVariables
pushd "%~dp0" && call :BIRGERDevices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a numdev=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=650
set /a CTRL_TOP_STEP=70
set /a TABCRC_TOP=0
set /a TABCRC_STEP=70
set /a TABCRC_LEFT=0
goto :EOF

:BIRGERDevices
call :DeleteFiles %hdwcfg% %simcfg% %tabcrc% %diccfg% %discfg%
rem   Device        Facility DevName Identitier Simulator Port Baudrate Parity DataBits StopBits DevLabel
call :BIRGER_COM    DEMO     BIRGER  LC1        0         2    115200   NONE   8        1        LC1
call :BIRGER_COM    DEMO     BIRGER  LC2        0         2    2400     NONE   8        1        LC2
rem   Device        Facility DevName Identitier Simulator TCPPort IPClient      Polling Priority       TxSize RxSize Timeout Label
call :BIRGER_TCP    DEMO     BIRGER  LC3        0         5300    192.168.0.110 1000    tpTimeCritical 16384  32768  1000    LC3 
call :BIRGER_TCP    DEMO     BIRGER  LC4        0         5301    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    LC4 
call :BIRGER_TCP    DEMO     BIRGER  LC5        0         5302    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    LC5 
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC6        1         5303    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    LC6 
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC7        1         5300    192.168.0.110 1000    tpTimeCritical 16384  32768  1000    LC7 
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC8        1         5301    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    LC8 
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC9        1         5302    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    LC9 
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC10        1         5303    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC10
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC11        1         5300    192.168.0.110 1000    tpTimeCritical 16384  32768  1000   LC11
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC12        1         5301    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC12
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC13        1         5302    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC13
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC14        1         5303    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC14
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC15        1         5302    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC15
rem call :BIRGER_TCP    PRGK100.PRPI1.LCCS     BIRGER  LC16        1         5303    192.168.1.31  1000    tpTimeCritical 16384  32768  1000   LC16
type %hdwcfg%
goto :EOF

:BIRGER_COM
call :BIRGER_SET_COM %*
call :BIRGER_HDW_COM %* >> %hdwcfg%
call :BIRGER_SIM %* >> %simcfg%
call :BIRGER_DIC %* >> %diccfg%
call :BIRGER_DIS %* >> %discfg%
call :BIRGER_TABCRC >> %tabcrc%
set /a numdev=numdev+1
set /a CTRL_TOP+=CTRL_TOP_STEP
if "%numdev%" == "10" ( set /a CTRL_LEFT=CTRL_LEFT+465 )
if "%numdev%" == "10" ( set /a CTRL_TOP=0 )
goto :EOF

:BIRGER_TCP
call :BIRGER_SET_TCP %*
call :BIRGER_HDW_TCP %* >> %hdwcfg%
call :BIRGER_SIM %* >> %simcfg%
call :BIRGER_DIC %* >> %diccfg%
call :BIRGER_DIS %* >> %discfg%
call :BIRGER_TABCRC >> %tabcrc%
set /a numdev=numdev+1
set /a CTRL_TOP+=CTRL_TOP_STEP
if "%numdev%" == "10" ( set /a CTRL_LEFT=CTRL_LEFT+465 )
if "%numdev%" == "10" ( set /a CTRL_TOP=0 )
goto :EOF

:BIRGER_SET_COM
set "FN=%~1"       &shift     & :: Facility name
set "DEV=%~1"      &shift     & :: Device Name
set "IDEN=%~1"     &shift     & :: Identifier
set "SIM=%~1"      &shift     & :: Simulator
set "ComPort=%~1"  &shift     & :: COM Port number
set "Baudrate=%~1" &shift     & :: Baudrate COM
set "Parity=%~1"   &shift     & :: Parity COM
set "DataBits=%~1" &shift     & :: DataBits COM
set "StopBits=%~1" &shift     & :: StopBits COM
set "DevLabel=%~1" &shift     & :: Name device in label
set "FCP=%FN:.=/%"            & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FCF=%FN:.=_%"            & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:BIRGER_SET_TCP
set "FN=%~1"       &shift     & :: Facility name
set "DEV=%~1"      &shift     & :: Device Name
set "IDEN=%~1"     &shift     & :: Device identifier name
set "SIM=%~1"      &shift     & :: Simulator
set "TcpPort=%~1"  &shift     & :: TCP Port number
set "IP=%~1"       &shift     & :: IP
set "Polling=%~1"  &shift     & :: Polling connection
set "Priority=%~1" &shift     & :: Priority connection
set "TxSize=%~1"   &shift     & :: Buffer Tx
set "RxSize=%~1"   &shift     & :: Buffer Rx
set "Timeout=%~1"  &shift     & :: Timeout connection
set "DevLabel=%~1" &shift     & :: Name device in label
set "FCP=%FN:.=/%"            & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FCF=%FN:.=_%"            & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:BIRGER_HDW_COM
echo ;***************************
echo ;***Driver for %DEV%***
echo ;***************************
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.CTRL = device software Program
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Comment = Driver for BIRGER Lens Controller
echo InquiryPeriod = 0
echo DevicePolling = 10, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo Timeout       = 200
echo DebugFlags    = 3
echo OpenConsole   = 2
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FN%.%DEV%.%IDEN%.DIMGUICLICK
echo Simulator     = %SIM%
echo ProgramSource = ..\daqpas\birger_drv.pas
echo tagPrefix     = %FN%.%DEV%.%IDEN%
echo ModeConnect   = COM
echo ComPort       = %ComPort%
echo BaudRate      = %Baudrate%
echo Parity        = %Parity%
echo DataBits      = %DataBits%
echo StopBits      = %StopBits%
echo LenseDBDir    = ..\Data\%FN%_DATA\LENSES_BD\
echo LenseDBIni    = Lenses_BD_%IDEN%.ini
echo LensDBSection = [DataBaseLnsesParametr]
echo AnalogOutputs = 1
echo Link AnalogOutput 0 with curve %FN%.%DEV%.%IDEN%.APERNUM history 1024
echo DigitalOutputs = 9
echo Link DigitalOutput 0 with curve %FN%.%DEV%.%IDEN%.RX        history 1024
echo Link DigitalOutput 1 with curve %FN%.%DEV%.%IDEN%.TX        history 1024
echo Link DigitalOutput 2 with curve %FN%.%DEV%.%IDEN%.APERSTEP  history 1024
echo Link DigitalOutput 3 with curve %FN%.%DEV%.%IDEN%.FOCUSMIN  history 1024
echo Link DigitalOutput 4 with curve %FN%.%DEV%.%IDEN%.FOCUSMAX  history 1024
echo Link DigitalOutput 5 with curve %FN%.%DEV%.%IDEN%.FOCUSCUR  history 1024
echo Link DigitalOutput 6 with curve %FN%.%DEV%.%IDEN%.FOCUSSTEP history 1024
echo Link DigitalOutput 7 with curve %FN%.%DEV%.%IDEN%.STATUS    history 1024
echo Link DigitalOutput 8 with curve %FN%.%DEV%.%IDEN%.ERROR     history 1024
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\%FN%_DATA\%DEV%\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 1
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%DEV%.%IDEN%.POLLEN
echo []
echo [DataBaseLensesParametr]
echo TagList = %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE
echo TagList = %FN%.%DEV%.%IDEN%.APERRANGE
echo TagList = %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR
echo TagList = %FN%.%DEV%.%IDEN%.APERSET
echo []
echo [DataStorage]
echo %FN%.%DEV%.%IDEN%.APERNUM   = Curve 0 1000 Black 0  1 ; Текущее значение апертуры
echo %FN%.%DEV%.%IDEN%.RX        = Curve 0 1000 Black 0  1 ; Скорость приема данных
echo %FN%.%DEV%.%IDEN%.TX        = Curve 0 1000 Black 0  1 ; Скорость отправки данных
echo %FN%.%DEV%.%IDEN%.APERSTEP  = Curve 0 1000 Black 0  1 ; Текущий шаг апертуры
echo %FN%.%DEV%.%IDEN%.FOCUSMIN  = Curve 0 1000 Black 0  1 ; Минимальное значение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMAX  = Curve 0 1000 Black 0  1 ; Максимальное значение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSCUR  = Curve 0 1000 Black 0  1 ; Текущее значение фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSSTEP = Curve 0 1000 Black 0  1 ; Значение пошаговой фокусировки
echo %FN%.%DEV%.%IDEN%.STATUS    = Curve 0 1000 Black 0  1 ; Статус устройства
echo %FN%.%DEV%.%IDEN%.ERROR     = Curve 0 1000 Black 0  1 ; Сообщения об ошибках работы
echo []
echo [TagList]
echo %FN%.%DEV%.%IDEN%.DIMGUICLICK = string  ? ; Обрабочик "кликов" по DIM-серверу ( The DIM click sensor data )
echo %FN%.%DEV%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FN%.%DEV%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo ;Tags of Aperture
echo %FN%.%DEV%.%IDEN%.APEROPEN       = Integer 0;   Открыть диафрагму
echo %FN%.%DEV%.%IDEN%.APERCLOSE      = Integer 0;   Закрыть диафрагму
echo %FN%.%DEV%.%IDEN%.APERINCR       = Integer 0;   Инкрементально двигать диафрагму
echo %FN%.%DEV%.%IDEN%.APERDECR       = Integer 0;   Декрементально
echo %FN%.%DEV%.%IDEN%.APERRANGE      = String Null; Диапазон апертуры
echo %FN%.%DEV%.%IDEN%.APERNUM        = Real 0;      Апертурное число
echo %FN%.%DEV%.%IDEN%.APERSTEP       = Real 0;      Положение диафрагмы
echo %FN%.%DEV%.%IDEN%.APERSET        = String Null; Линейка апертур
echo ;Tags of Focus                                  
echo %FN%.%DEV%.%IDEN%.FOCUSZERO      = Integer 0;   Двигать фокусировку в 0
echo %FN%.%DEV%.%IDEN%.FOCUSINF       = Integer 0;   Двигать фокусировку в бесконечность
echo %FN%.%DEV%.%IDEN%.FOCUSINCR      = Integer 0;   Двигать фокусировку инкрементально
echo %FN%.%DEV%.%IDEN%.FOCUSDECR      = Integer 0;   Двигать фокусировку декрментально
echo %FN%.%DEV%.%IDEN%.FOCUSSTEP      = Real 0;      Шаг фокусировки дли инкремента и декремента
echo %FN%.%DEV%.%IDEN%.FOCUSCUR       = Real 0;      Текущее положения серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSDIST      = String Null; Дистанция фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMIN       = Real 0;      Минимальное положение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMAX       = Real 0;      Максимальное положение сервовдвигателя фокусировки
echo ;Tags info of General Purposes                  
echo %FN%.%DEV%.%IDEN%.LENS.PRES      = Integer 0;   Подключен ли объектив?
echo %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE = String Null; Диапазон увеличения
echo %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR = String Null; Текущая конфигурация объектива
echo %FN%.%DEV%.%IDEN%.SERNUM         = String Null; Серийный номер контроллера
echo %FN%.%DEV%.%IDEN%.LIBVER         = String Null; Версия библиотеки
echo %FN%.%DEV%.%IDEN%.BOOTVER        = String Null; Версия загрузчика
echo %FN%.%DEV%.%IDEN%.HWVER          = String Null; Аппаратная версия устройства
echo %FN%.%DEV%.%IDEN%.RX             = Real 0;      Скорость получения данных
echo %FN%.%DEV%.%IDEN%.TX             = Real 0;      Скорость отправки данных
echo %FN%.%DEV%.%IDEN%.POLLEN         = Integer 0;   Вкл./выкл. опрос устройства
echo %FN%.%DEV%.%IDEN%.STATUS         = Real 0;      Статус устройства
echo %FN%.%DEV%.%IDEN%.ERROR          = Real 0;      Ошибки устройства
echo %FN%.%DEV%.%IDEN%.REINIT         = Integer 0;   Запуск переинициализации объектива
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%DEV%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\birger_ctrl.crc
echo Link sensor %DEV%.LOGO           with                                        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.RX             with curve %FN%.%DEV%.%IDEN%.RX             device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TX             with curve %FN%.%DEV%.%IDEN%.TX             device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LIBVER         with tag   %FN%.%DEV%.%IDEN%.LIBVER         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.SERNUM         with tag   %FN%.%DEV%.%IDEN%.SERNUM         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.BOOTVER        with tag   %FN%.%DEV%.%IDEN%.BOOTVER        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.HWVER          with tag   %FN%.%DEV%.%IDEN%.HWVER          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.PRES      with tag   %FN%.%DEV%.%IDEN%.LENS.PRES      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.ZOOMRANGE with tag   %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.CONFIGCUR with tag   %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APEROPEN       with tag   %FN%.%DEV%.%IDEN%.APEROPEN       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERCLOSE      with tag   %FN%.%DEV%.%IDEN%.APERCLOSE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERINCR       with tag   %FN%.%DEV%.%IDEN%.APERINCR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERDECR       with tag   %FN%.%DEV%.%IDEN%.APERDECR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.APERRANGE with tag   %FN%.%DEV%.%IDEN%.APERRANGE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERNUM        with tag   %FN%.%DEV%.%IDEN%.APERNUM        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERSTEP       with tag   %FN%.%DEV%.%IDEN%.APERSTEP       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSZERO      with tag   %FN%.%DEV%.%IDEN%.FOCUSZERO      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSINF       with tag   %FN%.%DEV%.%IDEN%.FOCUSINF       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSINCR      with tag   %FN%.%DEV%.%IDEN%.FOCUSINCR      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSDECR      with tag   %FN%.%DEV%.%IDEN%.FOCUSDECR      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSSTEP      with tag   %FN%.%DEV%.%IDEN%.FOCUSSTEP      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSCUR       with tag   %FN%.%DEV%.%IDEN%.FOCUSCUR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSDIST      with tag   %FN%.%DEV%.%IDEN%.FOCUSDIST      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSMIN       with tag   %FN%.%DEV%.%IDEN%.FOCUSMIN       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSMAX       with tag   %FN%.%DEV%.%IDEN%.FOCUSMAX       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLLEN         with tag   %FN%.%DEV%.%IDEN%.POLLEN         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.STATUS         with tag   %FN%.%DEV%.%IDEN%.STATUS         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ERROR          with tag   %FN%.%DEV%.%IDEN%.ERROR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.REINIT         with tag   %FN%.%DEV%.%IDEN%.REINIT         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=465^|Height=655
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SHOW @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HIDE @WinHide %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HIDE
echo []
echo [%FN%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT with device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERCUR   with tag %FN%.%DEV%.%IDEN%.APERNUM   device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSCUR  with tag %FN%.%DEV%.%IDEN%.FOCUSCUR  device ^&%FN%.%DEV%.%IDEN%.CTRL
rem echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSSTEP with tag %FN%.%DEV%.%IDEN%.FOCUSSTEP device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSDIST with tag %FN%.%DEV%.%IDEN%.FOCUSDIST device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSINCR with tag %FN%.%DEV%.%IDEN%.FOCUSINCR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSDECR with tag %FN%.%DEV%.%IDEN%.FOCUSDECR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERINCR  with tag %FN%.%DEV%.%IDEN%.APERINCR  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERDECR  with tag %FN%.%DEV%.%IDEN%.APERDECR  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.STATUS    with tag %FN%.%DEV%.%IDEN%.STATUS    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link Sensor SYSTEMMODE                  with tag %FN%.%DEV%.%IDEN%.SERVMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%DEV%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FN%.%DEV%.%IDEN%.APERNUM  
echo CurveList = %FN%.%DEV%.%IDEN%.RX       
echo CurveList = %FN%.%DEV%.%IDEN%.TX       
echo CurveList = %FN%.%DEV%.%IDEN%.APERSTEP 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMIN 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMAX 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSCUR 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSSTEP
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS   
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR    
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FN%.%DEV%.%IDEN%.APERNUM  
echo CurveList = %FN%.%DEV%.%IDEN%.RX       
echo CurveList = %FN%.%DEV%.%IDEN%.TX       
echo CurveList = %FN%.%DEV%.%IDEN%.APERSTEP 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMIN 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMAX 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSCUR 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSSTEP
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS   
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR    
echo []
goto :EOF

:BIRGER_HDW_TCP
echo ;************************
echo ;***Driver for %DEV%***
echo ;************************
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.CTRL = device software Program
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Comment = Driver for BIRGER Lens Controller
echo InquiryPeriod = 0
echo DevicePolling = 10, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo Timeout       = 200
echo DebugFlags    = 3
echo OpenConsole   = 2
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FN%.%DEV%.%IDEN%.DIMGUICLICK
echo Simulator     = %SIM%
echo ProgramSource = ..\daqpas\birger_drv.pas
echo tagPrefix     = %FN%.%DEV%.%IDEN%
echo ModeConnect   = TCP
echo TcpPort       = %TcpPort%
echo ClientIP      = %IP%
echo PipePooling   = %Polling%
echo PipePriority  = %Priority%
echo TxPipeSize    = %TxSize%
echo RxPipeSize    = %RxSize%
echo PipeTimeout   = %Timeout%
echo LenseDBDir    = ..\Data\%FN%_DATA\LENSES_BD\
echo LenseDBIni    = Lenses_BD_%IDEN%.ini
echo LensDBSection = [DataBaseLensesParametr]
echo AnalogOutputs = 1
echo Link AnalogOutput 0 with curve %FN%.%DEV%.%IDEN%.APERNUM history 1024
echo DigitalOutputs = 9
echo Link DigitalOutput 0 with curve %FN%.%DEV%.%IDEN%.RX        history 1024
echo Link DigitalOutput 1 with curve %FN%.%DEV%.%IDEN%.TX        history 1024
echo Link DigitalOutput 2 with curve %FN%.%DEV%.%IDEN%.APERSTEP  history 1024
echo Link DigitalOutput 3 with curve %FN%.%DEV%.%IDEN%.FOCUSMIN  history 1024
echo Link DigitalOutput 4 with curve %FN%.%DEV%.%IDEN%.FOCUSMAX  history 1024
echo Link DigitalOutput 5 with curve %FN%.%DEV%.%IDEN%.FOCUSCUR  history 1024
echo Link DigitalOutput 6 with curve %FN%.%DEV%.%IDEN%.FOCUSSTEP history 1024
echo Link DigitalOutput 7 with curve %FN%.%DEV%.%IDEN%.STATUS    history 1024
echo Link DigitalOutput 8 with curve %FN%.%DEV%.%IDEN%.ERROR     history 1024
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\%FN%_DATA\%DEV%\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 1
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%DEV%.%IDEN%.POLLEN
echo []
echo [DataBaseLensesParametr]
echo TagList = %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE
echo TagList = %FN%.%DEV%.%IDEN%.APERRANGE
echo TagList = %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR
echo TagList = %FN%.%DEV%.%IDEN%.APERSET
echo []
echo [DataStorage]
echo %FN%.%DEV%.%IDEN%.APERNUM   = Curve 0 1000 Black 0  1 ; Текущее значение апертуры
echo %FN%.%DEV%.%IDEN%.RX        = Curve 0 1000 Black 0  1 ; Скорость приема данных
echo %FN%.%DEV%.%IDEN%.TX        = Curve 0 1000 Black 0  1 ; Скорость отправки данных
echo %FN%.%DEV%.%IDEN%.APERSTEP  = Curve 0 1000 Black 0  1 ; Текущий шаг апертуры
echo %FN%.%DEV%.%IDEN%.FOCUSMIN  = Curve 0 1000 Black 0  1 ; Минимальное значение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMAX  = Curve 0 1000 Black 0  1 ; Максимальное значение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSCUR  = Curve 0 1000 Black 0  1 ; Текущее значение фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSSTEP = Curve 0 1000 Black 0  1 ; Значение пошаговой фокусировки
echo %FN%.%DEV%.%IDEN%.STATUS    = Curve 0 1000 Black 0  1 ; Статус устройства
echo %FN%.%DEV%.%IDEN%.ERROR     = Curve 0 1000 Black 0  1 ; Сообщения об ошибках работы
echo []
echo [TagList]
echo %FN%.%DEV%.%IDEN%.DIMGUICLICK = string  ? ; Обрабочик "кликов" по DIM-серверу ( The DIM click sensor data )
echo %FN%.%DEV%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FN%.%DEV%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo ;Tags of Aperture
echo %FN%.%DEV%.%IDEN%.APEROPEN       = Integer 0;   Открыть диафрагму
echo %FN%.%DEV%.%IDEN%.APERCLOSE      = Integer 0;   Закрыть диафрагму
echo %FN%.%DEV%.%IDEN%.APERINCR       = Integer 0;   Инкрементально двигать диафрагму
echo %FN%.%DEV%.%IDEN%.APERDECR       = Integer 0;   Декрементально
echo %FN%.%DEV%.%IDEN%.APERRANGE      = String Null; Диапазон апертуры
echo %FN%.%DEV%.%IDEN%.APERNUM        = Real 0;      Апертурное число
echo %FN%.%DEV%.%IDEN%.APERSTEP       = Real 0;      Положение диафрагмы
echo %FN%.%DEV%.%IDEN%.APERSET        = String Null; Линейка апертур
echo ;Tags of Focus                                  
echo %FN%.%DEV%.%IDEN%.FOCUSZERO      = Integer 0;   Двигать фокусировку в 0
echo %FN%.%DEV%.%IDEN%.FOCUSINF       = Integer 0;   Двигать фокусировку в бесконечность
echo %FN%.%DEV%.%IDEN%.FOCUSINCR      = Integer 0;   Двигать фокусировку инкрементально
echo %FN%.%DEV%.%IDEN%.FOCUSDECR      = Integer 0;   Двигать фокусировку декрментально
echo %FN%.%DEV%.%IDEN%.FOCUSSTEP      = Real 0;      Шаг фокусировки дли инкремента и декремента
echo %FN%.%DEV%.%IDEN%.FOCUSCUR       = Real 0;      Текущее положения серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSDIST      = String Null; Дистанция фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMIN       = Real 0;      Минимальное положение серводвигателя фокусировки
echo %FN%.%DEV%.%IDEN%.FOCUSMAX       = Real 0;      Максимальное положение сервовдвигателя фокусировки
echo ;Tags info of General Purposes                  
echo %FN%.%DEV%.%IDEN%.LENS.PRES      = Integer 0;   Подключен ли объектив?
echo %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE = String Null; Диапазон увеличения
echo %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR = String Null; Текущая конфигурация объектива
echo %FN%.%DEV%.%IDEN%.SERNUM         = String Null; Серийный номер контроллера
echo %FN%.%DEV%.%IDEN%.LIBVER         = String Null; Версия библиотеки
echo %FN%.%DEV%.%IDEN%.BOOTVER        = String Null; Версия загрузчика
echo %FN%.%DEV%.%IDEN%.HWVER          = String Null; Аппаратная версия устройства
echo %FN%.%DEV%.%IDEN%.RX             = Real 0;      Скорость получения данных
echo %FN%.%DEV%.%IDEN%.TX             = Real 0;      Скорость отправки данных
echo %FN%.%DEV%.%IDEN%.POLLEN         = Integer 0;   Вкл./выкл. опрос устройства
echo %FN%.%DEV%.%IDEN%.STATUS         = Real 0;      Статус устройства
echo %FN%.%DEV%.%IDEN%.ERROR          = Real 0;      Ошибки устройства
echo %FN%.%DEV%.%IDEN%.REINIT         = Integer 0;   Запуск переинициализации объектива
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%DEV%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\birger_ctrl.crc
echo Link sensor %DEV%.LOGO           with                                        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.RX             with curve %FN%.%DEV%.%IDEN%.RX             device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TX             with curve %FN%.%DEV%.%IDEN%.TX             device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LIBVER         with tag   %FN%.%DEV%.%IDEN%.LIBVER         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.SERNUM         with tag   %FN%.%DEV%.%IDEN%.SERNUM         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.BOOTVER        with tag   %FN%.%DEV%.%IDEN%.BOOTVER        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.HWVER          with tag   %FN%.%DEV%.%IDEN%.HWVER          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.PRES      with tag   %FN%.%DEV%.%IDEN%.LENS.PRES      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.ZOOMRANGE with tag   %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.CONFIGCUR with tag   %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APEROPEN       with tag   %FN%.%DEV%.%IDEN%.APEROPEN       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERCLOSE      with tag   %FN%.%DEV%.%IDEN%.APERCLOSE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERINCR       with tag   %FN%.%DEV%.%IDEN%.APERINCR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERDECR       with tag   %FN%.%DEV%.%IDEN%.APERDECR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LENS.APERRANGE with tag   %FN%.%DEV%.%IDEN%.APERRANGE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERNUM        with tag   %FN%.%DEV%.%IDEN%.APERNUM        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.APERSTEP       with tag   %FN%.%DEV%.%IDEN%.APERSTEP       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSZERO      with tag   %FN%.%DEV%.%IDEN%.FOCUSZERO      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSINF       with tag   %FN%.%DEV%.%IDEN%.FOCUSINF       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSINCR      with tag   %FN%.%DEV%.%IDEN%.FOCUSINCR      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSDECR      with tag   %FN%.%DEV%.%IDEN%.FOCUSDECR      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSSTEP      with tag   %FN%.%DEV%.%IDEN%.FOCUSSTEP      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSCUR       with tag   %FN%.%DEV%.%IDEN%.FOCUSCUR       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSDIST      with tag   %FN%.%DEV%.%IDEN%.FOCUSDIST      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSMIN       with tag   %FN%.%DEV%.%IDEN%.FOCUSMIN       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FOCUSMAX       with tag   %FN%.%DEV%.%IDEN%.FOCUSMAX       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLLEN         with tag   %FN%.%DEV%.%IDEN%.POLLEN         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.STATUS         with tag   %FN%.%DEV%.%IDEN%.STATUS         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ERROR          with tag   %FN%.%DEV%.%IDEN%.ERROR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.REINIT         with tag   %FN%.%DEV%.%IDEN%.REINIT         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=465^|Height=655
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SHOW @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HIDE @WinHide %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HIDE
echo []
echo [%FN%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT with device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERCUR   with tag %FN%.%DEV%.%IDEN%.APERNUM   device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSCUR  with tag %FN%.%DEV%.%IDEN%.FOCUSCUR  device ^&%FN%.%DEV%.%IDEN%.CTRL
rem echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSSTEP with tag %FN%.%DEV%.%IDEN%.FOCUSSTEP device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSDIST with tag %FN%.%DEV%.%IDEN%.FOCUSDIST device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSINCR with tag %FN%.%DEV%.%IDEN%.FOCUSINCR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.FOCUSDECR with tag %FN%.%DEV%.%IDEN%.FOCUSDECR device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERINCR  with tag %FN%.%DEV%.%IDEN%.APERINCR  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.APERDECR  with tag %FN%.%DEV%.%IDEN%.APERDECR  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.STATUS    with tag %FN%.%DEV%.%IDEN%.STATUS    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link Sensor SYSTEMMODE                  with tag %FN%.%DEV%.%IDEN%.SERVMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%DEV%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FN%.%DEV%.%IDEN%.APERNUM  
echo CurveList = %FN%.%DEV%.%IDEN%.RX       
echo CurveList = %FN%.%DEV%.%IDEN%.TX       
echo CurveList = %FN%.%DEV%.%IDEN%.APERSTEP 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMIN 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMAX 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSCUR 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSSTEP
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS   
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR    
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FN%.%DEV%.%IDEN%.APERNUM  
echo CurveList = %FN%.%DEV%.%IDEN%.RX       
echo CurveList = %FN%.%DEV%.%IDEN%.TX       
echo CurveList = %FN%.%DEV%.%IDEN%.APERSTEP 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMIN 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSMAX 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSCUR 
echo CurveList = %FN%.%DEV%.%IDEN%.FOCUSSTEP
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS   
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR    
echo []
goto :EOF

:BIRGER_SIM
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Simulator = 1
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:BIRGER_DIS
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POLLEN ^
  -n tag        %FN%.%DEV%.%IDEN%.POLLEN ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/REINIT ^
  -n tag        %FN%.%DEV%.%IDEN%.REINIT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/STATUS+ERROR ^
  -n tag        %FN%.%DEV%.%IDEN%.STATUS ^
  -n tag        %FN%.%DEV%.%IDEN%.ERROR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/RX+TX ^
  -n tag        %FN%.%DEV%.%IDEN%.RX ^
  -n tag        %FN%.%DEV%.%IDEN%.TX ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/SERNUM+LIBVER+BOOTVER+HWVER ^
  -n tag        %FN%.%DEV%.%IDEN%.SERNUM ^
  -n tag        %FN%.%DEV%.%IDEN%.LIBVER ^
  -n tag        %FN%.%DEV%.%IDEN%.BOOTVER ^
  -n tag        %FN%.%DEV%.%IDEN%.HWVER ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/LENS/PRES+ZOOMRANGE+CONFIGCUR ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.PRES ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSMIN+FOCUSMAX ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSMIN ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSMAX ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSCUR+FOCUSDIST ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSCUR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSDIST ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSSTEP ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSSTEP ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSDECR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSDECR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSINCR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSINCR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSZERO ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSZERO ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FOCUSINF ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSINF ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERSET ^
  -n tag        %FN%.%DEV%.%IDEN%.APERSET ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERNUM+APERSTEP ^
  -n tag        %FN%.%DEV%.%IDEN%.APERNUM ^
  -n tag        %FN%.%DEV%.%IDEN%.APERSTEP ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERRANGE ^
  -n tag        %FN%.%DEV%.%IDEN%.APERRANGE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERDECR ^
  -n tag        %FN%.%DEV%.%IDEN%.APERDECR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERINCR ^
  -n tag        %FN%.%DEV%.%IDEN%.APERINCR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APERCLOSE ^
  -n tag        %FN%.%DEV%.%IDEN%.APERCLOSE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/APEROPEN ^
  -n tag        %FN%.%DEV%.%IDEN%.APEROPEN ^
  -n end ^
echo.
goto :EOF

:BIRGER_DIC
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POLLEN ^
  -n tag        %FN%.%DEV%.%IDEN%.POLLEN ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.POLLEN" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/REINIT ^
  -n tag        %FN%.%DEV%.%IDEN%.REINIT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.REINIT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/STATUS+ERROR ^
  -n tag        %FN%.%DEV%.%IDEN%.STATUS ^
  -n tag        %FN%.%DEV%.%IDEN%.ERROR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.STATUS" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.ERROR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/RX+TX ^
  -n tag        %FN%.%DEV%.%IDEN%.RX ^
  -n tag        %FN%.%DEV%.%IDEN%.TX ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.RX" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.TX" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/SERNUM+LIBVER+BOOTVER+HWVER ^
  -n tag        %FN%.%DEV%.%IDEN%.SERNUM ^
  -n tag        %FN%.%DEV%.%IDEN%.LIBVER ^
  -n tag        %FN%.%DEV%.%IDEN%.BOOTVER ^
  -n tag        %FN%.%DEV%.%IDEN%.HWVER ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.SERNUM" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.LIBVER" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.BOOTVER" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.HWVER" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/LENS/PRES+ZOOMRANGE+CONFIGCUR ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.PRES ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE ^
  -n tag        %FN%.%DEV%.%IDEN%.LENS.CONFIGCUR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.LENS.PRES" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.LENS.ZOOMRANGE" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.LENS.CONFIGCUR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSMIN+FOCUSMAX ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSMIN ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSMAX ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSMIN" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSMAX" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSCUR+FOCUSDIST ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSCUR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSDIST ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSCUR" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSDIST" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSSTEP ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSSTEP ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSSTEP" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSDECR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSDECR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSDECR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSINCR ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSINCR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSINCR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSZERO ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSZERO ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSZERO" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FOCUSINF ^
  -n tag        %FN%.%DEV%.%IDEN%.FOCUSINF ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FOCUSINF" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERSET ^
  -n tag        %FN%.%DEV%.%IDEN%.APERSET ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERSET" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERNUM+APERSTEP ^
  -n tag        %FN%.%DEV%.%IDEN%.APERNUM ^
  -n tag        %FN%.%DEV%.%IDEN%.APERSTEP ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERNUM" ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERSTEP" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERRANGE ^
  -n tag        %FN%.%DEV%.%IDEN%.APERRANGE ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERRANGE" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERDECR ^
  -n tag        %FN%.%DEV%.%IDEN%.APERDECR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERDECR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERINCR ^
  -n tag        %FN%.%DEV%.%IDEN%.APERINCR ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERINCR" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APERCLOSE ^
  -n tag        %FN%.%DEV%.%IDEN%.APERCLOSE ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APERCLOSE" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/APEROPEN ^
  -n tag        %FN%.%DEV%.%IDEN%.APEROPEN ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.APEROPEN" ^
  -n end ^
echo.
goto :EOF

:BIRGER_TABCRC
set /a YPOS=TABCRC_TOP+70
set /a YPOS1=YPOS+20
set /a YPOS2=YPOS1+20
set /a XPOS=TABCRC_LEFT+10
set /a XPOS1=XPOS+135
set /a XPOS2=XPOS+80
set /a XPOS3=XPOS2+20
set /a XPOS4=XPOS3+80
set /a XPOS5=XPOS4+90
echo [SensorList]
echo Sensor = @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT]
echo Pos = %XPOS%, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_lightsteelblue1.bmp %DevLabel%
echo Hint = Открыть панель управления контроллера объектива %IDEN%
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.STATUS
echo [%FN%.%DEV%.%IDEN%.STATUS]
echo Pos = %XPOS1%, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_silver.bmp Выключен
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_lime.bmp Работает
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_yellow.bmp Объектив+откл.
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_yellow.bmp TimeOut
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_red.bmp Warning
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_red.bmp Refused
echo Tag#7 = 6, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_20_24_yellow.bmp Simulator
echo Hint = Состояние устройства
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.APERCUR.LABEL
echo [%FN%.%DEV%.%IDEN%.APERCUR.LABEL]
echo Pos = %XPOS%, %YPOS1%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clSilver)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_20_24_silver.bmp Диафрагма
echo Hint = Текущее значение апертуры
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSCUR.LABEL
echo [%FN%.%DEV%.%IDEN%.FOCUSCUR.LABEL]
echo Pos = %XPOS3%, %YPOS1%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clSilver)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_20_24_silver.bmp Фокус
echo Hint = Текущее значение фокусировки
echo []
rem echo [SensorList]
rem echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSSTEP.LABEL
rem echo [%FN%.%DEV%.%IDEN%.FOCUSSTEP.LABEL]
rem echo Pos = %XPOS4%, %YPOS1%
rem echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
rem echo Painter(v) = (glBarColor=clSilver)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
rem echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
rem echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_silver.bmp Шаг+фокуса
rem echo Hint = Шаг изменения фокуса
rem echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.APERCUR
echo [%FN%.%DEV%.%IDEN%.APERCUR]
echo Pos = %XPOS%, %YPOS2%
echo LED = 7, 1, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clWhite)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_20_24_white.bmp
echo Hint = Текущее значение апертуры
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.APERINCR
echo [%FN%.%DEV%.%IDEN%.APERINCR]
echo Pos = %XPOS2%, %YPOS1%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_20_24_silver.bmp %%2B
echo Hint = Закрыть диафрагму на 1 щелчок
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.APERDECR
echo [%FN%.%DEV%.%IDEN%.APERDECR]
echo Pos = %XPOS2%, %YPOS2%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_20_24_silver.bmp -
echo Hint = Открыть диафрагму на 1 щелчок
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSCUR
echo [%FN%.%DEV%.%IDEN%.FOCUSCUR]
echo Pos = %XPOS3%, %YPOS2%
echo LED = 7, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clWhite)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_80_20_24_white.bmp
echo Hint = Текущее значение фокусировки
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSDIST.LABEL
echo [%FN%.%DEV%.%IDEN%.FOCUSDIST.LABEL]
echo Pos = %XPOS4%, %YPOS1%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clSilver)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_silver.bmp Дистанция
echo Hint = Дистанция фокусировки
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSDIST
echo [%FN%.%DEV%.%IDEN%.FOCUSDIST]
echo Pos = %XPOS4% %YPOS2%
echo LED = 7, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBarColor=clWhite)
echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Дистанция фокусировки
echo []
rem echo [SensorList]
rem echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSSTEP
rem echo [%FN%.%DEV%.%IDEN%.FOCUSSTEP]
rem echo Pos = %XPOS4% %YPOS2%
rem echo LED = 7, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
rem echo Painter(v) = (glBarColor=clWhite)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleBar]
rem echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
rem echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
rem echo Hint = Шаг изменения фокуса
rem echo []
rem echo [SensorList]
rem echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSINCR
rem echo [%FN%.%DEV%.%IDEN%.FOCUSINCR]
rem echo Pos = %XPOS5%, %YPOS1%
rem echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
rem echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
rem echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_20_24_silver.bmp %%2B
rem echo Hint = Увеличить фокус
rem echo []
rem echo [SensorList]
rem echo Sensor = %FN%.%DEV%.%IDEN%.FOCUSDECR
rem echo [%FN%.%DEV%.%IDEN%.FOCUSDECR]
rem echo Pos = %XPOS5%, %YPOS2%
rem echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
rem echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
rem echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
rem echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_20_24_silver.bmp -
rem echo Hint = Уменьшить фокус
rem echo []
set /a TABCRC_TOP+=TABCRC_STEP
if "%numdev%" == "9" ( set /a TABCRC_TOP=0 )
if "%numdev%" == "9" ( set /a TABCRC_LEFT=310 )
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
