////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWDAQ.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Main project file for crwdaq system.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 1996xxxx - Created by A.K. - Crw16  for DOS DPMI  (BP7), initial           //
// 2001xxxx - Created by A.K. - Crw32  for Win32 (Delphi5), inherited Crw16   //
// 2024xxxx - Created by A.K. - Crwdaq for Win/Unix  (FPC), inherited Crw32   //
////////////////////////////////////////////////////////////////////////////////

program crwdaq; // CuRve(s) in Window(s) - for Data AcQuisition.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

{--$DEFINE CRW_DAQ_TEST}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math, regexpr,
 Interfaces, // this includes the LCL widgetset
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Printers,
 lcltype, lclintf, zcomponent, printer4lazarus,
 _crw_alloc,                           // Memory allocation etc
 _crw_atomic,                          // Atomic counters
 _crw_critsect,                        // Critical sections
 _crw_tslist,                          // Thread safe lists
 _crw_cmdargs,                         // Command line arguments
 _crw_environ,                         // Environment variables
 _crw_fpu,                             // Float point unit
 _crw_ef,                              // Elementary functions
 _crw_zm,                              // ZeroMin
 _crw_svd,                             // Singular Values Decomposition
 _crw_rtc,                             // RealTime Clock
 _crw_fifo,                            // FIFO buffers
 _crw_sort,                            // Sort & search
 _crw_str,                             // String routines
 _crw_utf8,                            // UTF8 routines
 _crw_geoid,                           // Geolocation identification
 _crw_lngid,                           // Language identification
 _crw_fio,                             // File IO routines
 _crw_dbglog,                          // Debug log
 _crw_syslog,                          // System log
 _crw_base64,                          // Base64 encoder
 _crw_base32,                          // Base32 encoder
 _crw_crypt,                           // Cryptography
 pcrelib,                              // PCRE library
 perlregex,                            // PCRE API
 _crw_regexp,                          // Regular expressions
 _crw_bsencode,                        // Baskslash encoder
 _crw_hash,                            // Hash functions
 _crw_meta,                            // Text metadata
 _crw_hl,                              // Hash list
 _crw_pio,                             // CPU Port IO
 _crw_uart,                            // UART - COM ports
 _crw_serio,                           // Serial ports lib
 _crw_sharm,                           // Shared memory blocks
 _crw_pipe,                            // Named pipes
 _crw_lm,                              // LAN manager
 _crw_tcp,                             // TCP sockets
 _crw_pipeio,                          // Pipe API
 _crw_plut,                            // Plot utils
 _crw_colors,                          // Color routines
 _crw_bmpcache,                        // Bitmap cache
 _crw_eldraw,                          // Elementary draw
 _crw_delauna,                         // Delauna algorithm (3D plot)
 _crw_procps,                          // read & parse /proc/pid/stat
 _crw_pscap,                           // Process capabilities (Unix)
 _crw_wmic,                            // WMIC routines (Windows)
 _crw_proc,                            // Process routines
 _crw_assoc,                           // File associations
 _crw_mimeapps,                        // File associations
 _crw_mimeglob,                        // Unix MIME glob
 _crw_polling,                         // Thread based polling via callback
 _crw_task,                            // Task, i.e. process control
 _crw_mmt,                             // MultiMedia Timer
 _crw_wmctrl,                          // Window control routines
 _crw_ee,                              // Expression Evaluator
 _crw_syscal,                          // System Calculator
 _crw_dynar,                           // Dynamic arrays
 _crw_rtdtc,                           // RTD & TC
 _crw_couple,                          // Thermocouples
 _crw_spline,                          // Splines
 _crw_lsqpoly,                         // Least square polynoms
 _crw_funmin,                          // Functions for minimization
 _crw_lsqmin,                          // Functions for least squares
 _crw_simplex,                         // Simplex optimization
 _crw_curves,                          // Curves
 _crw_lttb,                            // Downsampling
 _crw_calib,                           // Calibrations
 _crw_riff,                            // RIFF files
 _crw_snd,                             // Sound
 _crw_spk,                             // Speaker
 _crw_guard,                           // Guard, i.e. user access control
 _crw_spcfld,                          // Special folders
 _crw_fonts,                           // Font routines
 _crw_sysid,                           // System identification
 _crw_deref,                           // Dereference ObjectRegistry handles
 _crw_appforms,                        // TMasterForm
 _crw_apptools,                        // Application tools
 _crw_apputils,                        // Application utils
 _crw_appmodal,                        // Modal dialogs
 _crw_rfadata,                         // RFA database
 _crw_prmstrlst,                       // ParamStr ListOf
 _crw_uri,                             // URI parser
 _crw_sect,                            // Section names
 _crw_gloss,                           // System Glossary
 _crw_daqtags,                         // DAQ tags
 _crw_daqevnt,                         // DAQ events
 _crw_daqsys,                          // DAQ system base
 _crw_crwdaq,                          // DAQ for crwdaq
 _crw_daqdev,                          // DAQ devices
 _crw_adamdev,                         // ADAM devices
 _crw_pcldev,                          // PCL devices
 _crw_i8255,                           // i8255 based devices
 _crw_daqdio144device,                 // DIO144 driver
 _crw_softdev,                         // Software devices
 _crw_softdevscript,                   // DaqScript devices
 _crw_softdevdialog,                   // Dialog devices
 _crw_softdevconstgenerator,           // ConstGenerator devices
 _crw_softdevbitsetgenerator,          // BitsetGenerator devices
 _crw_daqpascaldevice,                 // DaqPascal devices
 _crw_daqpascalcompiler,               // DaqPascal Compiler
 _crw_daqpascalruntime,                // DaqPascal Runtime machine
 _crw_daqreaddat,                      // Read *.dat files
 _crw_peaksearch,                      // Search peaks
 _crw_stopion,                         // Ionization beam physics
 _crw_dcc32,                           // DCC32 support
 _crw_fpcup,                           // Fpcup support
 _crw_crwapi,                          // ICrwApi for plugins
 _crw_if_masters,                      // Inteface routines
 _crw_crwapiserver,                    // ICrwApi implementaation
 _crw_plugin_wrapper,                  // crwdaq DLL Pligins
 _crw_uac,                             // User Access Control (Windows)
 _crw_fsm,                             // Finite state machine
 _crw_wine,                            // WINE detection
 _crw_vbox,                            // VirtualBox detection
 _crw_adodb_tlb,                       // ADO support (Windows)
 _crw_dbapi,                           // Database API
 _crw_dbcon,                           // Database constants
 _crw_lmd,                             // List Mode Data files
 _crw_az,                              // Anti Zombie
 ptembed,                              // Embedded PT fonts (Windows)
 _crw_memo,                            // TMemo routines
 _crw_flgrd,                           // FileGuard for file protection
 _crw_sever,                           // Severity levels
 {$IFDEF SKIP_DRAFT}                   //
 Poligon,                              //
 _crw_intlcks,                         //
 {$ENDIF ~SKIP_DRAFT}                  //
 form_calculator,                      //
 form_uartterminal,                    //
 form_listboxselection,                //
 form_recodecodepagedialog,            //
 form_checklistboxselection,           //
 form_stringgrideditdialog,            //
 form_regexpcalculator,                //
 form_databasebrowser,                 //
 form_secretservice,                   //
 form_logindialog,                     //
 form_calibdialog,                     //
 form_voicepreset,                     //
 form_crwdaqsyschild,                  //
 form_consolewindow,                   //
 form_circuitwindow,                   //
 form_tabwindow,                       //
 form_tabwindowformatdialog,           //
 form_texteditor,                      //
 form_texteditdialog,                  //
 form_textfinddialog,                  //
 form_textreplacedialog,               //
 form_texteditortemplates,             //
 form_curvetools,                      //
 form_curvewindow,                     //
 form_curvebyformula,                  //
 form_curvestyledialog,                //
 form_curverangeselector,              //
 form_curveeditwindowstyledialog,      //
 form_curveeditdownsamplingdialog,     //
 form_curvetoolsrunmacrodialog,        //
 form_curvetoolswritetabledialog,      //
 form_curvetoolsreadtabledialog,       //
 form_curvetoolsrunplugindialog,       //
 form_surfwindow,                      //
 form_surfbyformula,                   //
 form_surfwindowstyledialog,           //
 form_surfwindowclipdialog,            //
 form_surftoolssmoothingdialog,        //
 form_spectrwindow,                    //
 form_daqcontroldialog,                //
 form_daqhistorywarning,               //
 form_daqhelpviewer,                   //
 form_daqdatetimecalculator,           //
 form_daqhistlendialog,                //
 form_daqwinoperdialog,                //
 form_daqopendynamicwindowdialog,      //
 form_daqmedianfilterdialog,           //
 form_daqedittagdialog,                //
 form_daqdevicecontrol,                //
 form_daqdevicecommonpropertydialog,   //
 form_constgeneratorpropertydialog,    //
 form_daqdialogdevice,                 //
 form_daqpascaleditor,                 //
 form_daqpascalpropertydialog,         //
 form_bitsetgeneratorpropertydialog,   //
 form_daqreaddat,                      //
 form_daqpoint2dedit,                  //
 form_daqcurvesmoothing,               //
 form_rfamendeleevtable,               //
 form_spectrdaqwindow,                 //
 form_spectrpikwindow,                 //
 form_spectrpikcontrol,                //
 form_spectrmanfitwindow,              //
 form_spectrmanfitcontrol,             //
 form_spectrmanfitbreaker,             //
 form_spectrzonfitwindow,              //
 form_spectrzonfitcontrol,             //
 form_spectrzonfitroiviewer,           //
 form_spectrzonfitzonviewer,           //
 form_spectrzonfitbreaker,             //
 form_spectrfitpreset,                 //
 form_spectrpeakinpreset,              //
 form_spectrzonfitdiagnos,             //
 form_spectrzonfiteditpeak,            //
 form_spectrzonfiteditground,          //
 form_spectrzonfitroiremovebugs,       //
 form_spectrrfabfpwindow,              //
 form_spectranalysisrfabfpjobwizard,   //
 form_nsiswindow,                      //
 form_termwindow,                      //
 form_delphiprojecteditor,             //
 form_lazarusprojecteditor,            //
 _crw_pascalprojects,                  //
 form_createnewprojectfromsample,      //
 form_createnewdataanalysisplugin,     //
 form_editdataanalysispluginarguments, //
 form_mistimingservice,                //
 unit_keyboardlayout,                  //
 unit_readoldcrwfiles,                 //
 unit_resourcemonitorconsole,          //
 unit_crwdaqmessages,                  //
 unit_systemconsole,                   //
 form_crwdaqwatchdog,                  //
 form_crwdaqbuglist,                   //
 form_crwdaqlogo,                      //
 form_crwdaq,                          //
 _crw_sesman,                          //
 unit_crwdaq_common,                   //
 unit_crwdaq_session;                  //

{$R *.res}

exports GetMemoryManager; // required for using plugins *.dll or *.so

begin
 if not StartSession('$ 1') then
 with SessionManager do begin
  if (DetectRunningPid(0)>0)
  then writeln('SessionManager: ',SessionID,' already running.')
  else writeln('SessionManager: Could not init '+SessionID+'.');
  ExitCode:=1;
  Exit;
 end;
 RequireDerivedFormResource:=True;
 //Application.DoubleBuffered:=adbTrue;
  Application.Scaled:=True;
 Application.Initialize;
 Application.TaskBarBehavior:=tbSingleButton;
 Application.CreateForm(TFormCrwDaq,FormCrwDaq);
 FormCrwDaq.Master:=@FormCrwDaq;
 Application.Run;
end.

//////////////
// END OF FILE
//////////////

