#!/bin/bash

###########################################################
## Copyright (c) 2002-2025 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Ping program with GUI window.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function do_help(){
 local name="$(basename ${BASH_SOURCE[0]})";
 echo "$name version 1.0";
 if [ $1 -eq 0 ]; then return 0; fi;
 echo "Copyright (c) 2002-2025 Alexey Kuryakin daqgroup@mail.ru";
 echo "$name - ping tool with GUI window.";
 echo "Usage:";
 echo " $name [-options]";
 echo "Options:";
 echo " -h,--help        - print help.";
 echo " --version        - print version.";
 echo "Examples:";
 echo " unix $name --help";
 echo " unix $name --version";
 echo " unix $name";
};

function grun_pingwin_lm9(){
 local lm9="$scriptHOME/$scriptbase.lm9";
 local exe="$(unix getapppath CrossMachine -t application/x-diesel -a .lm9)";
 if [ ! -x "$exe" ]; then fatal 1 "$(langstr ru "Ошибка: Не могу найти Дизель Паскаль." en "Error: Could not find Diesel Pascal.")"; fi;
 if [ ! -e "$lm9" ]; then fatal 1 "$(langstr ru "Ошибка: Не могу найти $(basename $lm9)." en "Error: Could not find $(basename $lm9).")"; fi;
 if unix grun $exe $lm9 "$@"; then
  colorize_bold echo -n "Started: "; echo "$exe $lm9 $*";
 else
  fatal 1 "$(langstr ru "Ошибка: Не могу выполнить $(basename $lm9)." en "Error: Could not start $(basename $lm9).")";
 fi;
};

function main(){
 case $1 in
  -version|--version) do_help 0; exit 0; ;;
  -h|-help|--help)    do_help 1; exit 0; ;;
  *)                  grun_pingwin_lm9 "$@"; ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
