#!/bin/bash

function ssh_umount_crw_daq_su()(
 local -r site="/mnt/ssh/crw-daq.su";
 function umount_site(){
  sudo umount $site;
 };
 function cat_mtab(){
  cat /etc/mtab;
 };
 function cat_mtab_site(){
  cat_mtab | grep "$site";
 };
 echo;
 echo "Start $(basename "${BASH_SOURCE[0]}").";
 echo;
 if [[ -n "$(cat_mtab_site)" ]]; then
  if umount_site; then
   echo "umount: succeed";
  else
   echo "umount: failed";
  fi;  
  cat_mtab_site;
 else
  echo "umount: not mounted $site";
  true;
 fi;
 echo;
 echo "Done $(basename "${BASH_SOURCE[0]}").";
 echo;
);
ssh_umount_crw_daq_su "$@";
