---

# Системный монитор Conky

---

[[toc]]

Смотрите статьи:
 [1](https://help.ubuntu.ru/wiki/conky),
 [2](https://redos.red-soft.ru/base/arm/graph-env/conky/),
 [3](http://www.ifxgroup.net/conky.htm).
Исходники и примеры:
 [1](https://github.com/brndnmtthws/conky),
 [2](https://github.com/erikdubois/Aureola).

---

## Что такое Conky

**Conky** - утилита для мониторирования компьютера.
Умеет отображать загрузку процессора, памяти, дисков, сети, температуру сенсоров и другие полезные вещи,
необходимые для пользователей, администраторов и разработчиков.

Отображение происходит на рабочем столе. К сожалению, на панели задач отображение недоступно.
Для наблюдения надо держать хотя бы один рабочий стол относительно свободным, чтобы пользовательские окна
не закрывали область вывода **Conky**.

---

## Инсталляция Conky

Надо (после подключения репозитория) вызвать команды:
``` bash
sudo apt-get install conky-std      - установка Conky
sudo apt-get install lm-sensors     - установка программы чтения сенсоров температуры
sudo apt-get install hddtemp        - установка программы чтения температуры дисков
sudo sensors-detect                 - запуск программы определения сенсоров
sensors;                            - проверка работы программы сенсоров
sudo hddtemp /dev/sda /dev/sdb      - проверка температуры дисков 
conky --help                        - справка по опциям
```
Если все прошло удачно, инсталляция закончена. Остается сконфигурировать **Conky**.
Это непростая процедура, но к счастью есть шаблоны и примеры, которые просто надо
слегка подредактировать.

---

## Конфигурация Conky

Конфигурацию **Conky** надо расположить в файле **`$HOME/.config/conky/conky.conf`**
(или в краткой записи **`~/.config/conky/conky.conf`**).

В конфигурации описывается, что именно надо отображать и в каком виде.
Есть примеры (шаблоны) **conky.conf.minimalist**, **conky.conf.alex**.

> Для работы **Conky** рекомендуется установить шрифт **ConkySymbols.ttf**, который находится в каталоге с этим файлом.
> Без установки этого шрифта внешний вид будет не таким красивым (шрифт содержит изображения).

---

## Запуск и завершение Conky

Для запуска **Conky** вызывается команда **`conky`**:

``` bash
# простой запуск

conky;

# или перезапуск с удалением дубликатов:

killall -w conky; conky;

# или (при вызове из графической оболочки)

bash -c "killall -w conky; conky;"

# или (при вызове в автозагрузке)

bash -c "sleep 20 && { killall -w conky; conky; };"

```
Предполагается, что конфигурация **Conky** уже создана и скопирована в рабочий каталог.

Рекомендуется вызывать **Conky** командой перезапуска **`killall -w conky; conky;`**,
чтобы не возникало случайных дубликатов программы.

Для завершения **Conky** вызывается команда

``` bash
killall -w conky;
```
которая удаляет все запущенные процессы **Conky**.

> **Примечание:** при запуске **Conky** в начале сеанса (через автозагрузку) рекомендуется сделать задержку,
> чтобы графическая система успела инициализироваться.

При вызове в автозагрузке

---

## Примеры Conky

**[conky.conf.minimalist](conky.conf.minimalist)** - хороший пример для начала.   
 ![minimalist](minimalist.png)

**[conky.conf.alex](conky.conf.alex)** - пример, созданный **alex** на основе **minimalist**.  
 ![mini_alex](mini_alex.png)

---

Успешного вам использования **Conky**!

---

> Copyright (c) 2023 Alexey Kuryakin kouriakine@mail.ru

---
