#!/bin/bash

function about(){
 echo "$(basename ${BASH_SOURCE[0]}) version 20250122";
 echo "##############################################################";
 echo "# Shell Installation Script.                                 #";
 echo "# Copyright (c) 2023-2025 Alexey Kuryakin daqgroup@mail.ru   #";
 echo "##############################################################";
};

function note(){ return; };
function skip(){ return; };
function fatal(){ echo -ne "\n$1\n\n"; exit 1; };

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

note "Extract target package name from script name.";
note "#############################################";
readonly targetname="$(echo "$scriptbase" | sed 's/^[a-z]*-//')";

note "The payload directory contains user installer + data archive(s).";
note "################################################################";
readonly payloaddir="$scriptHOME";

note "Include the install-library.sh library source.";
note "##############################################";
readonly installlib="$payloaddir/install-library.sh";
source $installlib || fatal "Error: not found $installlib.";

note "#######################";
note "Install target package.";
note "#######################";
function install_target(){
 echo "";
 echo "Install: $targetname";
 echo "";
 common_predinst;
 note "##################################";
 note "### Begin User Installer code: ###";
 note "##################################";
 
 note "########################################";
 note "Check required packages to be installed.";
 note "########################################";
 check_install_dpkg zenity makeself zip unzip xz-utils p7zip dos2unix;
 note "################################";
 note "Check is CrossMachine available?";
 note "################################";
 if which CrossMachine >/dev/null 2>&1; then
  echo "Found: $(which CrossMachine)";
 else
  fatal "Error: CrossMachine is not found.";
 fi;
 note "#############################";
 note "Unpack archive to target dir.";
 note "#############################";
 check_confirm_iam_user || fatal "Cancel: user mode expected.";
 note "#############################";
 note "Unpack archive to target dir.";
 note "#############################";
 local archive="$targetname.tar";
 local localdir="$HOME/.DieselPascal";
 local sharedir="$(dirname $(realpath $(which CrossMachine)))";
 local targdir="$sharedir";
 for role in root user; do
  if [ "$role" = "user" ]; then local targdir="$localdir"; fi;
  if [ "$role" = "root" ]; then local run="sudo"; else local run=""; fi;
  if [ "$role" = "root" ]; then local usr="root"; else local usr="$USER"; fi;
  tar_list_check_exist $archive $targdir || fatal "Cancel: file already exist.";
  if [ "$role" = "root" ]; then root_mkdir $targdir; else user_mkdir $targdir; fi;
  if [ -e "$targdir/external/" ]; then $run rm -fvr "$targdir/external"; fi;
  unpack_tar $archive $targdir 755 $usr;
  local validator="$targdir/settings/diesel-validate-eol.sh";
  if [ -e "$validator" ]; then skip $validator --default; fi;
 done;
 note "#################################";
 note "Copy examples from share to local";
 note "#################################";
 for exam in $(find $sharedir/examples/*.lm9 -type f -print); do
  cp -fvuH "$exam" "$localdir/examples/";
 done;
 note "################################";
 note "Add default example to run/open.";
 note "################################";
 for exam in tetris.lm9; do
  if [ -e "$localdir/examples/$exam" ]; then
   echo "$localdir/examples/$exam" >> $localdir/run.history;
   echo "$localdir/examples/$exam" >> $localdir/ide.history;
  fi;
 done;
 note "#################################";
 note "Set application/x-diesel -> *.lm9";
 note "#################################";
 if which gio >/dev/null 2>&1; then
  sudo -n gio mime application/x-diesel CrossMachine.desktop;
          gio mime application/x-diesel CrossMachine.desktop;
          gio mime application/x-diesel; note "Query assoc.";
 fi;
 
 note "##################################";
 note "### End of User Installer code ###";
 note "##################################";
 common_postinst;
};

note "########";
note "# Main #";
note "########";
function main(){
 about; print_identification; sleep 1;
 check_sudo_is_avail || fatal "Error: sudo is not available.";
 check_install_package zenity makeself zip unzip xz:xz-utils 7za:p7zip;
 local ask="$(zen_hello_user)\n\n$(zen_do_you_want_to $(langstr en 'Run' ru 'Запустить'))\n";
 ask="$ask\n<big><b><span fgcolor='green'>install-$targetname.sh</span></b>?</big>";
 if ask_zenity 0 --question --text "$ask" --timeout 180 >/dev/null 2>&1; then
  install_target;
  echo -ne "\nDone\n\n";
 else
  echo -ne "\nCancel\n\n";
 fi;
};

mkdir -p $HOME/.local/share/makeself;

main "$@" | tee $HOME/.local/share/makeself/$scriptbase.log;

#############
# END OF FILE
#############
