#!/bin/bash

astra_conky(){
 conky_stop()   { killall -w conky;                                     };
 conky_start()  { sleep $1 && conky -c ~/.config/conky/conky.conf;      };
 conky_usage()  { echo "Usage: $0 {run|start|stop|restart|status}";     };
 conky_status() { echo "$(pgrep -c '^conky$') conky process(es) found"; };
 case $1 in
  run)      { conky_start 0;                    }; ;;
  start)    { conky_start 20;                   }; ;;
  stop)     { conky_stop;                       }; ;;
  restart)  { conky_stop; conky_start 0;        }; ;;
  status)   { conky_status;                     }; ;;
  *)        { conky_usage;                      }; ;;
 esac
};
astra_conky $*;
