#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## DaqGroup downloader.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

declare virtualbox_site="http://download.virtualbox.org";
declare debian_site="http://ftp.debian.org";
debian_site="http://ftp.ru.debian.org";
debian_site="https://mirror.yandex.ru";
debian_site="http://ftp.debian.org";

function download_site(){
 local site="$1"; shift;
 xterm -fa 'PT Mono' -fs 12 -geometry 138x35+90+130 -hold -e wget --no-check-certificate -np -m "$@" $site;
 colorize_bold echo -ne "\n Done download: $site\n\n";
};

function download_wanted_sites(){
 download_site $virtualbox_site/virtualbox/6.1.42/            --reject '*.rpm,*.dmg,*.run,*.p5p,*-SunOS.*,*~Ubuntu~*,*~buster_*,*~bullseye_*';
 download_site $debian_site/debian/pool/main/d/doublecmd/     --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/libm/libmodbus/  --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/m/mbpoll/        --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/g/gtkterm/       --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/g/glogg/         --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/s/ser2net/       --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/w/wmctrl/        --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/z/zenity/        --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/s/sendemail/     --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/t/tcc/           --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb';
 download_site $debian_site/debian/pool/main/x/xdotool/       --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb,*_riscv64*.deb,*_s390x*.deb';
 download_site $debian_site/debian/pool/main/m/mako/          --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb,*_riscv64*.deb,*_s390x*.deb';
 download_site $debian_site/debian/pool/main/m/mako-notifier/ --reject '*_arm*.deb,*_i386.deb,*_ppc*.deb,*_mip*.deb,*_riscv64*.deb,*_s390x*.deb';
 download_site https://github.com/RHVoice/RHVoice/releases/download/1.8.0/rhvoice-1.8.0.tar.gz;
};

function main(){
 if pushd $scriptHOME >/dev/null 2>&1; then
  download_wanted_sites;
  find . -name '*.html?*' -delete;
 fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
