#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Call opcua-cpl.sh - Control Panel for OPC UA utilities.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly optshare="/opt/daqgroup/share";
readonly opcuacpl="$optshare/opcua/scripts/opcua-cpl.sh";

function main(){
 if [[ -x $opcuacpl ]]; then
  exec $opcuacpl "$@";
 else
  fatal 1 "$(langstr ru "Ошибка: не найден $opcuacpl." en "Error: not found $opcuacpl.")";
 fi;
};

main "$@";

##############
## END OF FILE
##############
