#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function usage(){
 local name="$(basename ${BASH_SOURCE[0]})";
 echo "$name version 1.0";
 if [ "$1" = "0" ]; then return; fi;
 echo "Copyright (c) 2024 Alexey Kuryakin daqgroup@mail.ru";
 echo "Convert GIF format image to BMP format.";
 echo "Usage: $name --help";
 echo "       $name --version";
 echo "       $name source.gif target.bmp";
};

function fatal(){
 1>&2 echo "$2";
 exit $1;
};

function do_gif2bmp(){
 case $1 in
  --version) usage 0; exit 0; ;;
  -h|--help) usage 1; exit 0; ;;
  *.gif)     if [ ! -e "$1" ]; then fatal 1 "Error: not found $1"; fi; ;;
  '')        fatal 1 "Error: empty .gif filename. Type $(basename ${BASH_SOURCE[0]}) -h for help."; ;;
  *)         fatal 1 "Error: $1 is not .gif file. Type $(basename ${BASH_SOURCE[0]}) -h for help."; ;;
 esac;
 case $2 in
  *.bmp)     if [ -e "$2" ]; then rm -f "$2"; fi; ;;
  '')        fatal 1 "Error: empty .bmp filename. Type $(basename ${BASH_SOURCE[0]}) -h for help."; ;;
  *)         fatal 1 "Error: $2 is not .bmp file. Type $(basename ${BASH_SOURCE[0]}) -h for help."; ;;
 esac;
 exec convert $1 $2;
};

function main(){
 do_gif2bmp "$@";
};

main "$@";

##############
## END OF FILE
##############
