#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Call flamerobin - database admin tool for Firebird.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly toolname="flamerobin";
readonly optshare="/opt/daqgroup/share";
readonly toolhome="$optshare/flamerobin";
readonly launcher="$toolhome/run_flamerobin.sh";

function main(){
 if [[ -x $launcher ]]; then
  unix grun $launcher "$@";
 else
  fatal 1 "$(langstr ru "Ошибка: не найден $toolname." en "Error: not found $toolname.")";
 fi;
};

main "$@";

##############
## END OF FILE
##############
