#!/bin/bash

############################################################
# Copyright (c) 2021-2023 Alexey Kuryakin kouriakine@mail.ru
# Script uses to start dimmonitor.lm9
############################################################
# Usage: unix dimmonitor
############################################################

function fatal(){
 1>&2 echo -ne "\n$1\n\n";
 exit 1;
};

function run_dimmonitor(){
 local scriptfile="${BASH_SOURCE[0]}";
 local scriptFILE="$(realpath $scriptfile)";
 local scriptHOME="$(dirname  $scriptFILE)";
 local dimmonitor="$scriptHOME/dimmonitor.lm9";
 if which CrossMachine >/dev/null 2>&1; then
  if [ -e "$dimmonitor" ]; then
   CrossMachine $dimmonitor "$@" </dev/null >/dev/null 2>&1 & disown;
  else
   fatal "Error: could not find $dimmonitor.";
  fi;
 else
  fatal "Error: could not find CrossMachine.";
 fi;
};


#######
## MAIN
#######

function main(){
 ##################
 ## Execute command
 ##################
 run_dimmonitor "$@";
};

main "$@";

##############
## END OF FILE
##############
