/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.io.Serializable;
import java.sql.SQLException;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.XcaConnectionEvent;
import org.firebirdsql.jaybird.xca.XcaConnectionEventListener;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;
import org.firebirdsql.jdbc.FirebirdConnection;

final class FBStandAloneConnectionManager
implements XcaConnectionManager,
XcaConnectionEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final System.Logger log = System.getLogger(FBStandAloneConnectionManager.class.getName());

    FBStandAloneConnectionManager() {
    }

    @Override
    public FirebirdConnection allocateConnection(FBManagedConnectionFactory mcf, FBConnectionRequestInfo cxRequestInfo) throws SQLException {
        FBManagedConnection mc = mcf.createManagedConnection(cxRequestInfo);
        mc.setManagedEnvironment(false);
        mc.addConnectionEventListener(this);
        return mc.getConnection();
    }

    @Override
    public void connectionClosed(XcaConnectionEvent ce) {
        this.destroyConnection(ce);
    }

    @Override
    public void connectionErrorOccurred(XcaConnectionEvent ce) {
        log.log(System.Logger.Level.TRACE, "ConnectionErrorOccurred", (Throwable)ce.getException());
        this.destroyConnection(ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnection(XcaConnectionEvent ce) {
        FBManagedConnection mc = ce.getSource();
        try {
            mc.destroy(ce);
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Exception closing unmanaged connection", (Throwable)e);
        }
        finally {
            mc.removeConnectionEventListener(this);
        }
    }
}

