/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.ConnectionPropertyRegistry;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jaybird.xca.FBStandAloneConnectionManager;
import org.firebirdsql.jaybird.xca.FBXAException;
import org.firebirdsql.jaybird.xca.FBXid;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public final class FBManagedConnectionFactory
implements FirebirdConnectionProperties,
Serializable {
    private static final Map<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>> mcfInstances = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>>();
    private static final ReferenceQueue<FBManagedConnectionFactory> mcfReferenceQueue = new ReferenceQueue();
    private static final String DEFAULT_CONNECTION_MANAGER_TYPE = "CONNECTION_MANAGER_TYPE";
    private static final String DB_CREATE_PROPERTY_SUFFIX = "@create";
    private XcaConnectionManager defaultCm;
    private int hashCode;
    private GDSType gdsType;
    private final Map<Xid, FBManagedConnection> xidMap = new ConcurrentHashMap<Xid, FBManagedConnection>();
    private final Object startLock = new Object();
    private boolean started = false;
    private final boolean shared;
    private final FBConnectionProperties connectionProperties;
    private static final int[] ERROR_CODES_NOT_RELATED_TO_DB_EXISTENCE = new int[]{335544472, 335544721, 335544421, 335544726, 335544727, 335544722};
    private static final Set<String> DISALLOW_CREATE_OVERRIDE;

    public FBManagedConnectionFactory() {
        this(true);
    }

    public FBManagedConnectionFactory(boolean shared) {
        this(shared, GDSFactory.getDefaultGDSType(), null);
    }

    public FBManagedConnectionFactory(GDSType gdsType) {
        this(true, gdsType);
    }

    public FBManagedConnectionFactory(boolean shared, GDSType gdsType) {
        this(shared, gdsType, null);
    }

    public FBManagedConnectionFactory(GDSType gdsType, FBConnectionProperties connectionProperties) {
        this(true, gdsType, connectionProperties);
    }

    public FBManagedConnectionFactory(boolean shared, GDSType gdsType, FBConnectionProperties connectionProperties) {
        this.shared = shared;
        this.connectionProperties = connectionProperties != null ? (FBConnectionProperties)connectionProperties.clone() : new FBConnectionProperties();
        this.setType(gdsType.toString());
        this.setDefaultConnectionManager(new FBStandAloneConnectionManager());
    }

    public FbDatabaseFactory getDatabaseFactory() {
        return GDSFactory.getDatabaseFactoryForType(this.getGDSType());
    }

    public GDSType getGDSType() {
        if (this.gdsType != null) {
            return this.gdsType;
        }
        this.gdsType = GDSType.getType(this.getType());
        return this.gdsType;
    }

    public boolean getShared() {
        return this.shared;
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.ensureCanModify(() -> this.connectionProperties.setNonStandardProperty(propertyMapping));
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.ensureCanModify(() -> this.connectionProperties.setTransactionParameters(isolation, tpb));
    }

    public void setDefaultConnectionManager(XcaConnectionManager defaultCm) {
        this.ensureCanModify(() -> {
            this.connectionProperties.setProperty(DEFAULT_CONNECTION_MANAGER_TYPE, defaultCm.getClass().getName());
            this.defaultCm = defaultCm;
        });
    }

    @Override
    public String getProperty(String name) {
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.ensureCanModify(() -> {
            if ("type".equals(name) && this.gdsType != null) {
                throw new IllegalStateException("Cannot change GDS type at runtime.");
            }
            this.connectionProperties.setProperty(name, value);
        });
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.connectionProperties.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.ensureCanModify(() -> this.connectionProperties.setIntProperty(name, value));
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.connectionProperties.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.ensureCanModify(() -> this.connectionProperties.setBooleanProperty(name, value));
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.connectionProperties.connectionPropertyValues();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (!this.started) {
            return this.hashCodeImpl();
        }
        this.hashCode = this.hashCodeImpl();
        return this.hashCode;
    }

    private int hashCodeImpl() {
        int result = this.connectionProperties.hashCode();
        if (result == 0) {
            return 17;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) return false;
        FBManagedConnectionFactory that = (FBManagedConnectionFactory)other;
        if (!this.connectionProperties.equals(that.connectionProperties)) return false;
        return true;
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() throws SQLException {
        return new FBConnectionRequestInfo(this.connectionProperties.asIConnectionProperties().asNewMutable());
    }

    public TransactionParameterBuffer getDefaultTpb() throws SQLException {
        return this.getTpb(this.connectionProperties.getDefaultTransactionIsolation());
    }

    public TransactionParameterBuffer getTpb(int isolation) throws SQLException {
        return this.connectionProperties.getMapper().getMapping(isolation);
    }

    FBTpbMapper getTransactionMappingCopy() throws SQLException {
        return FBTpbMapper.copyOf(this.connectionProperties.getMapper());
    }

    public DataSource createConnectionFactory(XcaConnectionManager connectionManager) {
        this.start();
        return new FBDataSource(this, connectionManager);
    }

    public DataSource createConnectionFactory() {
        return this.createConnectionFactory(this.defaultCm);
    }

    public FBManagedConnection createManagedConnection() throws SQLException {
        return this.createManagedConnection(null);
    }

    public FBManagedConnection createManagedConnection(FBConnectionRequestInfo connectionRequestInfo) throws SQLException {
        this.start();
        if (connectionRequestInfo == null) {
            connectionRequestInfo = this.getDefaultConnectionRequestInfo();
        }
        try {
            return new FBManagedConnection(connectionRequestInfo, this);
        }
        catch (SQLException e) {
            return this.createNewDatabaseIfRequested(connectionRequestInfo, e);
        }
    }

    private FBManagedConnection createNewDatabaseIfRequested(FBConnectionRequestInfo originalCri, SQLException originalConnectionFailure) throws SQLException {
        IConnectionProperties props = originalCri.asIConnectionProperties();
        if (!props.isCreateDatabaseIfNotExist() || !FBManagedConnectionFactory.signalsDatabaseDoesNotExist(originalConnectionFailure)) {
            throw originalConnectionFailure;
        }
        try {
            return new FBManagedConnection(FBManagedConnectionFactory.createDatabaseConnectionRequestInfo(props), this, true);
        }
        catch (SQLException e) {
            e.addSuppressed(originalConnectionFailure);
            throw e;
        }
    }

    private static boolean signalsDatabaseDoesNotExist(SQLException exception) {
        int errorCode = exception.getErrorCode();
        return errorCode == 335544344 || Arrays.binarySearch(ERROR_CODES_NOT_RELATED_TO_DB_EXISTENCE, errorCode) < 0;
    }

    private static FBConnectionRequestInfo createDatabaseConnectionRequestInfo(IConnectionProperties originalProperties) {
        IConnectionProperties newProperties = originalProperties.asNewMutable();
        for (Map.Entry<ConnectionProperty, Object> entry : originalProperties.connectionPropertyValues().entrySet()) {
            FBManagedConnectionFactory.asCreateOverrideProperty(entry.getKey()).map(ConnectionProperty::name).ifPresent(name -> {
                Object value = entry.getValue();
                if (value == null) {
                    newProperties.setProperty((String)name, null);
                } else if (value instanceof String) {
                    String s = (String)value;
                    newProperties.setProperty((String)name, s);
                } else if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    newProperties.setBooleanProperty((String)name, b);
                } else if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    newProperties.setIntProperty((String)name, i);
                } else {
                    newProperties.setProperty((String)name, String.valueOf(value));
                }
            });
        }
        return new FBConnectionRequestInfo(newProperties);
    }

    private static Optional<ConnectionProperty> asCreateOverrideProperty(ConnectionProperty property) {
        String originalName = property.name();
        if (originalName.endsWith(DB_CREATE_PROPERTY_SUFFIX)) {
            String name = originalName.substring(0, originalName.length() - DB_CREATE_PROPERTY_SUFFIX.length());
            ConnectionProperty override = ConnectionPropertyRegistry.getInstance().getOrUnknown(name);
            if (DISALLOW_CREATE_OVERRIDE.contains(override.name())) {
                return Optional.empty();
            }
            return Optional.of(override);
        }
        return Optional.empty();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf;
        System.Logger logger;
        if (!this.shared && (logger = System.getLogger(FBManagedConnectionFactory.class.getName())).isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, "canonicalize called on MCF with shared=false", (Throwable)new RuntimeException("trace exception"));
        }
        if ((mcf = this.internalCanonicalize()) != null) {
            return mcf;
        }
        this.start();
        return this;
    }

    private FBManagedConnectionFactory internalCanonicalize() {
        SoftReference<FBManagedConnectionFactory> factoryReference = mcfInstances.get(this.getCacheKey());
        return factoryReference != null ? factoryReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            if (this.shared) {
                mcfInstances.put(this.getCacheKey(), new SoftReference<FBManagedConnectionFactory>(this, mcfReferenceQueue));
            }
        }
        this.cleanMcfInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCanModify(Runnable runnable) {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started && this.shared) {
                throw new IllegalStateException("Managed connection factory is shared and already started, configuration change not allowed");
            }
            runnable.run();
            this.hashCode = 0;
        }
    }

    private void cleanMcfInstances() {
        Reference<FBManagedConnectionFactory> reference;
        while ((reference = mcfReferenceQueue.poll()) != null) {
            mcfInstances.values().remove(reference);
        }
    }

    void notifyStart(FBManagedConnection mc, Xid xid) {
        this.xidMap.put(xid, mc);
    }

    void notifyEnd(FBManagedConnection mc, Xid xid) {
    }

    int notifyPrepare(FBManagedConnection mc, Xid xid) throws XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        return targetMc.internalPrepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCommit(FBManagedConnection mc, Xid xid, boolean onePhase) throws XAException {
        try {
            FBManagedConnection targetMc = this.xidMap.get(xid);
            if (targetMc == null) {
                this.tryCompleteInLimboTransaction(xid, true);
            } else {
                targetMc.internalCommit(xid, onePhase);
            }
        }
        finally {
            this.forget(mc, xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRollback(FBManagedConnection mc, Xid xid) throws XAException {
        try {
            FBManagedConnection targetMc = this.xidMap.get(xid);
            if (targetMc == null) {
                this.tryCompleteInLimboTransaction(xid, false);
            } else {
                targetMc.internalRollback(xid);
            }
        }
        finally {
            this.forget(mc, xid);
        }
    }

    public void forget(FBManagedConnection mc, Xid xid) {
        this.xidMap.remove(xid);
    }

    public void recover(FBManagedConnection mc, Xid xid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCompleteInLimboTransaction(Xid xid, boolean commit) throws XAException {
        try {
            FBManagedConnection tempMc = null;
            FBLocalTransaction tempLocalTx = null;
            try {
                tempMc = this.createManagedConnection();
                tempLocalTx = tempMc.getLocalTransaction();
                tempLocalTx.begin();
                long fbTransactionId = FBManagedConnectionFactory.findTransaction(tempMc, xid);
                if (fbTransactionId == -1L) {
                    throw new FBXAException((commit ? "Commit" : "Rollback") + " called with unknown transaction.", -4);
                }
                GDSHelper gdsHelper = tempMc.getGDSHelper();
                FBManagedConnectionFactory.completeTransaction(gdsHelper, fbTransactionId, commit);
                this.tryDeleteTransactionInfo(gdsHelper, fbTransactionId);
            }
            catch (SQLException e) {
                throw new FBXAException("unable to complete in limbo transaction", FBManagedConnectionFactory.determineLimboCompletionErrorCode(e), e);
            }
            finally {
                try {
                    if (tempLocalTx != null && tempLocalTx.inTransaction()) {
                        tempLocalTx.commit();
                    }
                }
                finally {
                    if (tempMc != null) {
                        tempMc.destroy();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new FBXAException(-3, ex);
        }
    }

    private static long findTransaction(FBManagedConnection mc, Xid xid) throws SQLException, XAException {
        if (mc.getGDSHelper().compareToVersion(2) < 0) {
            FBXid[] inLimboIds;
            for (FBXid inLimboId : inLimboIds = (FBXid[])mc.getXAResource().recover(0x1000000)) {
                if (!inLimboId.equals(xid)) continue;
                return inLimboId.getFirebirdTransactionId();
            }
        } else {
            FBXid foundXid = (FBXid)mc.findSingleXid(xid);
            if (foundXid != null && foundXid.equals(xid)) {
                return foundXid.getFirebirdTransactionId();
            }
        }
        return -1L;
    }

    private static void completeTransaction(GDSHelper gdsHelper, long fbTransactionId, boolean commit) throws SQLException {
        FbDatabase dbHandle = gdsHelper.getCurrentDatabase();
        FbTransaction trHandle = dbHandle.reconnectTransaction(fbTransactionId);
        if (commit) {
            trHandle.commit();
        } else {
            trHandle.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDeleteTransactionInfo(GDSHelper gdsHelper, long fbTransactionId) throws FBXAException {
        if (gdsHelper.compareToVersion(3) >= 0) {
            return;
        }
        try {
            String query = "delete from rdb$transactions where rdb$transaction_id = " + fbTransactionId;
            FbDatabase dbHandle = gdsHelper.getCurrentDatabase();
            FbTransaction trHandle = dbHandle.startTransaction(this.getDefaultTpb());
            try (FbStatement stmtHandle = dbHandle.createStatement(trHandle);){
                stmtHandle.prepare(query);
                stmtHandle.execute(RowValue.EMPTY_ROW_VALUE);
            }
            finally {
                trHandle.commit();
            }
        }
        catch (SQLException sqle) {
            throw new FBXAException("unable to remove in limbo transaction from rdb$transactions where rdb$transaction_id = " + fbTransactionId, -3);
        }
    }

    private static int determineLimboCompletionErrorCode(SQLException ex) {
        String message;
        if (ex.getErrorCode() == 335544353 && ((message = ex.getMessage()).contains("committed") || message.contains("rolled back"))) {
            return 7;
        }
        return -3;
    }

    FBConnection newConnection(FBManagedConnection mc) throws SQLException {
        Class<?> connectionClass = GDSFactory.getConnectionClass(this.getGDSType());
        return connectionClass == FBConnection.class ? new FBConnection(mc) : FBManagedConnectionFactory.newConnection(mc, connectionClass);
    }

    private static FBConnection newConnection(FBManagedConnection mc, Class<?> connectionClass) throws SQLException {
        if (!FBConnection.class.isAssignableFrom(connectionClass)) {
            throw new IllegalArgumentException("Specified connection class does not extend " + FBConnection.class.getName() + " class");
        }
        try {
            Constructor<?> constructor = connectionClass.getConstructor(FBManagedConnection.class);
            return (FBConnection)constructor.newInstance(mc);
        }
        catch (NoSuchMethodException ex) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248328).messageParameter((Object)connectionClass.getName(), (Object)"no constructor accepting org.firebirdsql.jaybird.xca.FBManagedConnection as single parameter was found").toSQLException();
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            if (cause instanceof SQLException) {
                SQLException sqle = (SQLException)cause;
                throw sqle;
            }
            throw FbExceptionBuilder.forNonTransientConnectionException(337248328).messageParameter((Object)connectionClass.getName(), (Object)ex).cause(ex).toSQLException();
        }
        catch (IllegalAccessException ex) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248328).messageParameter((Object)connectionClass.getName(), (Object)"constructor is not accessible").cause(ex).toSQLException();
        }
        catch (InstantiationException ex) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248328).messageParameter((Object)connectionClass.getName(), (Object)ex).cause(ex).toSQLException();
        }
    }

    public FBConnectionProperties getCacheKey() {
        return (FBConnectionProperties)this.connectionProperties.clone();
    }

    static {
        Arrays.sort(ERROR_CODES_NOT_RELATED_TO_DB_EXISTENCE);
        DISALLOW_CREATE_OVERRIDE = Set.of("attachObjectName", "serverName", "portNumber");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean shared;
        private final XcaConnectionManager fbCm;
        private final String type;
        private final FBConnectionProperties fbConnectionProperties;

        private SerializationProxy(FBManagedConnectionFactory connectionFactory) {
            this.shared = connectionFactory.shared;
            this.fbCm = connectionFactory.defaultCm;
            this.type = connectionFactory.getType();
            this.fbConnectionProperties = connectionFactory.connectionProperties;
        }

        protected Object readResolve() {
            GDSType gdsType = GDSType.getType(this.type);
            if (gdsType == null) {
                gdsType = GDSFactory.getDefaultGDSType();
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(this.shared, gdsType, this.fbConnectionProperties);
            mcf.setDefaultConnectionManager(this.fbCm);
            if (!this.shared) {
                return mcf;
            }
            FBManagedConnectionFactory canonicalizedMcf = mcf.internalCanonicalize();
            return canonicalizedMcf != null ? canonicalizedMcf : mcf;
        }
    }
}

