/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AbstractFbWireBlob;
import org.firebirdsql.gds.ng.wire.AbstractFbWireOutputBlob;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.jaybird.util.ByteArrayHelper;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;

public class V10OutputBlob
extends AbstractFbWireOutputBlob
implements FbWireBlob,
DatabaseListener {
    private static final int OUTSTANDING_PUT_SEGMENT_PACKETS = 8;

    public V10OutputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobClosed();
            this.clearDeferredException();
            if (this.getBlobId() != 0L) {
                throw FbExceptionBuilder.toNonTransientException(335544368);
            }
            this.sendOpen(AbstractFbWireBlob.BlobOpenOperation.OUTPUT_BLOB, true);
            this.receiveOpenResponse();
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void put(byte[] b, int off, int len) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            ByteArrayHelper.validateBufferLength(b, off, len);
            if (len == 0) {
                throw FbExceptionBuilder.toException(337248258);
            }
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            this.batchPutSegment(b, off, len);
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchPutSegment(byte[] b, int off, int len) throws SQLException {
        int requestCount = 0;
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            int count = 0;
            while (count < len) {
                int segmentLength = Math.min(len - count, this.getMaximumSegmentSize());
                xdrOut.writeInt(37);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeInt(segmentLength);
                xdrOut.writeBuffer(b, off + count, segmentLength);
                count += segmentLength;
                if (++requestCount < 8) continue;
                xdrOut.flush();
                try {
                    this.consumePutSegmentResponses(requestCount);
                }
                finally {
                    requestCount = 0;
                }
            }
            xdrOut.flush();
        }
        catch (IOException e) {
            this.getDatabase().consumePackets(requestCount, w -> {});
            throw FbExceptionBuilder.ioWriteError(e);
        }
        this.consumePutSegmentResponses(requestCount);
    }

    protected void consumePutSegmentResponses(int requestCount) throws SQLException {
        if (requestCount == 0) {
            return;
        }
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        try {
            while (requestCount-- > 0) {
                this.consumePutSegmentResponse(chain);
            }
            chain.throwIfPresent();
        }
        catch (IOException e) {
            this.getDatabase().consumePackets(requestCount, w -> {});
            SQLException exception = FbExceptionBuilder.ioReadError(e);
            chain.optException().ifPresent(exception::addSuppressed);
            throw exception;
        }
    }

    private void consumePutSegmentResponse(SQLExceptionChainBuilder chain) throws IOException {
        try {
            this.getDatabase().readResponse(null);
        }
        catch (SQLException e) {
            chain.append(e);
        }
    }
}

