/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt.chacha;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.chacha.ChaChaEncryptionPluginSpi;

public final class ChaChaEncryptionPlugin
implements EncryptionPlugin {
    private static final String CHA_CHA_20_CIPHER_NAME = "ChaCha20";
    private final CryptSessionConfig cryptSessionConfig;

    ChaChaEncryptionPlugin(CryptSessionConfig cryptSessionConfig) {
        this.cryptSessionConfig = cryptSessionConfig;
    }

    @Override
    public EncryptionIdentifier encryptionIdentifier() {
        return ChaChaEncryptionPluginSpi.CHA_CHA_ID;
    }

    @Override
    public EncryptionInitInfo initializeEncryption() {
        ChaChaIV iv = new ChaChaIV();
        try {
            EncryptionInitInfo encryptionInitInfo = EncryptionInitInfo.success(this.encryptionIdentifier(), this.createEncryptionCipher(iv), this.createDecryptionCipher(iv));
            iv.close();
            return encryptionInitInfo;
        }
        catch (Throwable throwable) {
            try {
                try {
                    iv.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                return EncryptionInitInfo.failure(this.encryptionIdentifier(), e);
            }
        }
    }

    private Cipher createEncryptionCipher(ChaChaIV iv) throws SQLException {
        return this.createCipher(1, iv, this.toChaChaKey(this.cryptSessionConfig.encryptKey()));
    }

    private Cipher createDecryptionCipher(ChaChaIV iv) throws SQLException {
        return this.createCipher(2, iv, this.toChaChaKey(this.cryptSessionConfig.decryptKey()));
    }

    private byte[] toChaChaKey(byte[] key) throws SQLException {
        if (key.length < 16) {
            throw FbExceptionBuilder.forNonTransientException(337248282).messageParameter((Object)this.encryptionIdentifier(), (Object)"Key too short").toSQLException();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(key);
        }
        catch (NoSuchAlgorithmException e) {
            throw FbExceptionBuilder.forNonTransientException(337248281).messageParameter((Object)this.encryptionIdentifier()).cause(e).toSQLException();
        }
    }

    private Cipher createCipher(int mode, ChaChaIV iv, byte[] key) throws SQLException {
        try {
            Cipher chaChaCipher = Cipher.getInstance(CHA_CHA_20_CIPHER_NAME);
            chaChaCipher.init(mode, (Key)new SecretKeySpec(key, CHA_CHA_20_CIPHER_NAME), iv.toParameterSpec());
            Cipher cipher = chaChaCipher;
            return cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw FbExceptionBuilder.forNonTransientException(337248281).messageParameter((Object)this.encryptionIdentifier()).cause(e).toSQLException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw FbExceptionBuilder.forNonTransientException(337248282).messageParameter((Object)this.encryptionIdentifier()).cause(e).toSQLException();
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    private class ChaChaIV
    implements AutoCloseable {
        private final byte[] nonce;
        private int counter;

        ChaChaIV() throws SQLException {
            byte[] iv = ChaChaEncryptionPlugin.this.cryptSessionConfig.specificData();
            if (iv == null || iv.length != 12 && iv.length != 16) {
                throw FbExceptionBuilder.forNonTransientException(337248282).messageParameter((Object)ChaChaEncryptionPlugin.this.encryptionIdentifier(), (Object)"Wrong IV length, needs 12 or 16 bytes").toSQLException();
            }
            this.nonce = Arrays.copyOf(iv, 12);
            if (iv.length == 16) {
                this.counter = (iv[12] << 24) + (iv[13] << 16) + (iv[14] << 8) + iv[15];
            }
        }

        ChaCha20ParameterSpec toParameterSpec() {
            return new ChaCha20ParameterSpec(this.nonce, this.counter);
        }

        @Override
        public void close() {
            Arrays.fill(this.nonce, (byte)0);
            this.counter = -1;
        }
    }
}

