/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth.legacy;

import java.sql.SQLException;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPlugin;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.auth.legacy.LegacyHash;

final class LegacyAuthenticationPlugin
implements AuthenticationPlugin {
    private byte[] clientData;
    private boolean hasServerData;

    LegacyAuthenticationPlugin() {
    }

    @Override
    public String getName() {
        return "Legacy_Auth";
    }

    @Override
    public AuthenticationPlugin.AuthStatus authenticate(ClientAuthBlock clientAuthBlock) {
        if (clientAuthBlock.getLogin() == null || clientAuthBlock.getPassword() == null) {
            return AuthenticationPlugin.AuthStatus.AUTH_CONTINUE;
        }
        this.clientData = LegacyHash.fbCrypt(clientAuthBlock.getPassword());
        return AuthenticationPlugin.AuthStatus.AUTH_SUCCESS;
    }

    @Override
    public byte[] getClientData() {
        return this.clientData;
    }

    @Override
    public void setServerData(byte[] serverData) {
        this.hasServerData = serverData != null && serverData.length > 0;
    }

    @Override
    public boolean hasServerData() {
        return this.hasServerData;
    }

    @Override
    public boolean generatesSessionKey() {
        return false;
    }

    @Override
    public byte[] getSessionKey() throws SQLException {
        throw new SQLException("LegacyAuthenticationPlugin cannot generate a session key");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.getName();
    }
}

