/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPluginSpi;
import org.firebirdsql.jaybird.util.PluginLoader;

public final class AuthenticationPluginRegistry {
    private static final Map<String, AuthenticationPluginSpi> PLUGIN_SPI_MAP = Map.copyOf(AuthenticationPluginRegistry.findAuthenticationPluginSpi());

    private AuthenticationPluginRegistry() {
    }

    public static AuthenticationPluginSpi getAuthenticationPluginSpi(String authenticationPluginName) {
        return PLUGIN_SPI_MAP.get(authenticationPluginName);
    }

    private static Map<String, AuthenticationPluginSpi> findAuthenticationPluginSpi() {
        Collection<AuthenticationPluginSpi> pluginSpis = PluginLoader.findPlugins(AuthenticationPluginSpi.class, List.of("org.firebirdsql.gds.ng.wire.auth.legacy.LegacyAuthenticationPluginSpi", "org.firebirdsql.gds.ng.wire.auth.srp.SrpAuthenticationPluginSpi", "org.firebirdsql.gds.ng.wire.auth.srp.Srp224AuthenticationPluginSpi", "org.firebirdsql.gds.ng.wire.auth.srp.Srp256AuthenticationPluginSpi", "org.firebirdsql.gds.ng.wire.auth.srp.Srp384AuthenticationPluginSpi", "org.firebirdsql.gds.ng.wire.auth.srp.Srp512AuthenticationPluginSpi"));
        HashMap<String, AuthenticationPluginSpi> pluginSpiMap = new HashMap<String, AuthenticationPluginSpi>();
        for (AuthenticationPluginSpi pluginSpi : pluginSpis) {
            if (pluginSpiMap.putIfAbsent(pluginSpi.getPluginName(), pluginSpi) == null) continue;
            System.getLogger(AuthenticationPluginRegistry.class.getName()).log(System.Logger.Level.WARNING, "Authentication plugin provider for {0} already registered. Skipping {1}", pluginSpi.getPluginName(), pluginSpi.getClass().getName());
        }
        return pluginSpiMap;
    }
}

