/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.util.function.Function;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireBlob
extends AbstractFbBlob
implements FbWireBlob {
    private int blobHandle;

    protected AbstractFbWireBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public final int getHandle() {
        try (LockCloseable ignored = this.withLock();){
            int n = this.blobHandle;
            return n;
        }
    }

    protected final void setHandle(int blobHandle) {
        try (LockCloseable ignored = this.withLock();){
            this.blobHandle = blobHandle;
        }
    }

    protected void releaseBlob(int releaseOperation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.getState() == AbstractFbBlob.BlobState.DELAYED_OPEN) {
                return;
            }
            this.getDatabase().releaseObject(releaseOperation, this.getHandle());
        }
    }

    protected final void sendOpen(BlobOpenOperation openOperation, boolean flush) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
            if (blobParameterBuffer == null || blobParameterBuffer.isEmpty()) {
                xdrOut.writeInt(openOperation.opCodeWithoutBpb());
            } else {
                xdrOut.writeInt(openOperation.opCodeWithBpb());
                xdrOut.writeTyped(blobParameterBuffer);
            }
            xdrOut.writeInt(this.getTransaction().getHandle());
            xdrOut.writeLong(this.getBlobId());
            if (flush) {
                xdrOut.flush();
            }
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    protected final void receiveOpenResponse() throws SQLException {
        try {
            this.processOpenResponse(this.getDatabase().readGenericResponse(null));
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    protected void processOpenResponse(GenericResponse genericResponse) throws SQLException {
        this.setHandle(genericResponse.objectHandle());
        this.setState(AbstractFbBlob.BlobState.OPEN);
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.releaseBlob(39);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.releaseBlob(38);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkBlobOpen();
            byte[] result = this.getDatabase().getInfo(43, this.getHandle(), requestItems, bufferLength, null);
            this.throwAndClearDeferredException();
            byte[] byArray = result;
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.errorOccurred(e);
                throw e;
            }
        }
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    private XdrStreamAccess getXdrStreamAccess() {
        return this.getDatabase().getXdrStreamAccess();
    }

    protected final <T> DeferredAction wrapDeferredResponse(DeferredResponse<T> deferredResponse, Function<Response, T> responseMapper) {
        return DeferredAction.wrapDeferredResponse(deferredResponse, responseMapper, null, this::deferredExceptionHandler, false);
    }

    private void deferredExceptionHandler(Exception exception) {
        if (exception instanceof SQLException) {
            SQLException sqle = (SQLException)exception;
            this.registerDeferredException(sqle);
            this.exceptionListenerDispatcher.errorOccurred(sqle);
        } else if (exception instanceof IOException) {
            IOException ioe = (IOException)exception;
            this.exceptionListenerDispatcher.errorOccurred(FbExceptionBuilder.ioReadError(ioe));
        }
    }

    protected static enum BlobOpenOperation {
        INPUT_BLOB(35, 56),
        OUTPUT_BLOB(34, 57);

        private final int opCodeWithoutBpb;
        private final int opCodeWithBpb;

        private BlobOpenOperation(int opCodeWithoutBpb, int opCodeWithBpb) {
            this.opCodeWithoutBpb = opCodeWithoutBpb;
            this.opCodeWithBpb = opCodeWithBpb;
        }

        public final int opCodeWithoutBpb() {
            return this.opCodeWithoutBpb;
        }

        public final int opCodeWithBpb() {
            return this.opCodeWithBpb;
        }
    }
}

