/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class OdsVersion
implements Comparable<OdsVersion> {
    private static final Map<Integer, OdsVersion> ODS_VERSION_CACHE = new ConcurrentHashMap<Integer, OdsVersion>();
    private final int major;
    private final int minor;

    private OdsVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static OdsVersion of(int major, int minor) {
        return ODS_VERSION_CACHE.computeIfAbsent(OdsVersion.key(major, minor), ignored -> new OdsVersion(major, minor));
    }

    private static int key(int major, int minor) {
        return major & 0x1F | (minor & 0xFFFF) << 5 | (major & 0xFFE0) << 16;
    }

    public static OdsVersion none() {
        return OdsVersion.of(0, 0);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public OdsVersion withMajor(int major) {
        return this.major != major ? OdsVersion.of(major, this.minor) : this;
    }

    public OdsVersion withMinor(int minor) {
        return this.minor != minor ? OdsVersion.of(this.major, minor) : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OdsVersion)) return false;
        OdsVersion that = (OdsVersion)obj;
        if (this.major != that.major) return false;
        if (this.minor != that.minor) return false;
        return true;
    }

    public int hashCode() {
        return OdsVersion.key(this.major, this.minor);
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    @Override
    public int compareTo(OdsVersion o) {
        int majorDiff = Integer.compare(this.major, o.major);
        if (majorDiff != 0) {
            return majorDiff;
        }
        return Integer.compare(this.minor, o.minor);
    }
}

