/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbAttachment;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.listeners.ServiceListener;
import org.firebirdsql.gds.ng.listeners.ServiceListenerDispatcher;

public abstract class AbstractFbService<T extends AbstractConnection<IServiceProperties, ? extends FbService>>
extends AbstractFbAttachment<T>
implements FbService {
    private static final System.Logger log = System.getLogger(AbstractFbService.class.getName());
    protected final ServiceListenerDispatcher serviceListenerDispatcher = new ServiceListenerDispatcher();
    private final WarningMessageCallback serviceWarningCallback = warning -> this.serviceListenerDispatcher.warningReceived(this, warning);

    protected AbstractFbService(T connection, DatatypeCoder datatypeCoder) {
        super(connection, datatypeCoder);
    }

    public final <R> R getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int bufferLength, InfoProcessor<R> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getServiceInfo(serviceParameterBuffer, serviceRequestBuffer, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void addServiceListener(ServiceListener listener) {
        this.serviceListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeServiceListener(ServiceListener listener) {
        this.serviceListenerDispatcher.removeListener(listener);
    }

    protected abstract void internalDetach() throws SQLException;

    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkConnected();
            this.serviceListenerDispatcher.detaching(this);
            try {
                this.internalDetach();
            }
            finally {
                this.serviceListenerDispatcher.detached(this);
                this.serviceListenerDispatcher.shutdown();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected final WarningMessageCallback getServiceWarningCallback() {
        return this.serviceWarningCallback;
    }

    protected ServiceRequestBuffer getDescribeServiceRequestBuffer() {
        ServiceRequestBuffer srb = this.createServiceRequestBuffer();
        srb.addArgument(55);
        return srb;
    }

    protected InfoProcessor<FbService> getServiceInformationProcessor() {
        return new ServiceInformationProcessor();
    }

    private class ServiceInformationProcessor
    implements InfoProcessor<FbService> {
        private ServiceInformationProcessor() {
        }

        @Override
        public FbService process(byte[] info) throws SQLException {
            if (info.length == 0) {
                throw FbExceptionBuilder.forException(337248307).messageParameter((Object)"service").toSQLException();
            }
            int i = 0;
            block4: while (info[i] != 1) {
                switch (info[i++]) {
                    case 55: {
                        int len = VaxEncoding.iscVaxInteger2(info, i);
                        String firebirdVersion = new String(info, i += 2, len, StandardCharsets.UTF_8);
                        i += len;
                        AbstractFbService.this.setServerVersion(firebirdVersion);
                        continue block4;
                    }
                    case 2: {
                        log.log(System.Logger.Level.DEBUG, "Received isc_info_truncated");
                        return AbstractFbService.this;
                    }
                }
                throw FbExceptionBuilder.toException(335544341);
            }
            return AbstractFbService.this;
        }
    }
}

