/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.gds.impl.wire.FbCipherInputStream;
import org.firebirdsql.gds.impl.wire.FbInflaterInputStream;
import org.firebirdsql.jaybird.util.ByteArrayHelper;

public final class XdrInputStream
extends FilterInputStream
implements EncryptedStreamSupport {
    private static final int MIN_BUF_SIZE = 1024;
    private static final int DEFAULT_BUF_SIZE = 16384;
    private static final int BUF_SIZE = Math.max(1024, JaybirdSystemProperties.getWireInputBufferSize(16384));
    private boolean compressed;
    private boolean encrypted;
    private final byte[] readBuffer = new byte[8];

    public XdrInputStream(InputStream in) {
        this(in, BUF_SIZE);
    }

    public XdrInputStream(InputStream in, int size) {
        super(new BufferedInputStream(in, size));
    }

    public void skipPadding(int len) throws IOException {
        this.skipNBytes(4 - len & 3);
    }

    public byte[] readBuffer() throws IOException {
        return this.readBuffer(this.readInt());
    }

    public byte[] readBuffer(int len) throws IOException {
        if (len == 0) {
            return ByteArrayHelper.emptyByteArray();
        }
        byte[] buffer = this.readRawBuffer(len);
        this.skipPadding(len);
        return buffer;
    }

    public void skipBuffer() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            this.skipNBytes(len + (4 - len & 3));
        }
    }

    public byte[] readRawBuffer(int len) throws IOException {
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        return buffer;
    }

    public String readString(Encoding encoding) throws IOException {
        return encoding.decodeFromCharset(this.readBuffer());
    }

    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return (long)this.readBuffer[0] << 56 | ((long)this.readBuffer[1] & 0xFFL) << 48 | ((long)this.readBuffer[2] & 0xFFL) << 40 | ((long)this.readBuffer[3] & 0xFFL) << 32 | ((long)this.readBuffer[4] & 0xFFL) << 24 | ((long)this.readBuffer[5] & 0xFFL) << 16 | ((long)this.readBuffer[6] & 0xFFL) << 8 | (long)this.readBuffer[7] & 0xFFL;
    }

    public int readInt() throws IOException {
        this.readFully(this.readBuffer, 0, 4);
        return this.readBuffer[0] << 24 | (this.readBuffer[1] & 0xFF) << 16 | (this.readBuffer[2] & 0xFF) << 8 | this.readBuffer[3] & 0xFF;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.readNBytes(b, off, len) < len) {
            throw new EOFException();
        }
    }

    public void enableDecompression() throws IOException {
        if (this.compressed) {
            throw new IOException("Input stream already compressed");
        }
        this.in = new FbInflaterInputStream(this.in);
        this.compressed = true;
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Input stream already encrypted");
        }
        InputStream currentStream = this.in;
        if (currentStream instanceof EncryptedStreamSupport) {
            EncryptedStreamSupport encryptedStreamSupport = (EncryptedStreamSupport)((Object)currentStream);
            encryptedStreamSupport.setCipher(cipher);
        } else {
            this.in = new FbCipherInputStream(currentStream, cipher);
        }
        this.encrypted = true;
    }
}

