/*
 * $Id: adddev.c,v 1.40 2011/12/15 06:17:12 vfrolov Exp $
 *
 * Copyright (c) 2004-2011 Vyacheslav Frolov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * $Log: adddev.c,v $
 * Revision 1.40  2011/12/15 06:17:12  vfrolov
 * Removed usage undocumented PDRIVER_OBJECT->Type
 *
 * Revision 1.39  2011/12/06 16:03:22  vfrolov
 * Added cleaning high data bits for less then 8 bit data
 * Added AllDataBits option to force 8 bit data
 *
 * Revision 1.38  2010/08/09 06:02:40  vfrolov
 * Eliminated accessing undocumented structure members
 *
 * Revision 1.37  2010/05/27 11:16:46  vfrolov
 * Added ability to put the port to the Ports class
 *
 * Revision 1.36  2008/12/02 16:10:08  vfrolov
 * Separated tracing and debuging
 *
 * Revision 1.35  2008/09/17 07:58:32  vfrolov
 * Added AddRTTO and AddRITO parameters
 *
 * Revision 1.34  2008/06/26 13:37:10  vfrolov
 * Implemented noise emulation
 *
 * Revision 1.33  2008/05/04 09:51:44  vfrolov
 * Implemented HiddenMode option
 *
 * Revision 1.32  2008/03/14 15:28:39  vfrolov
 * Implemented ability to get paired port settings with
 * extended IOCTL_SERIAL_LSRMST_INSERT
 *
 * Revision 1.31  2007/10/19 16:03:41  vfrolov
 * Added default values
 *
 * Revision 1.30  2007/09/26 10:12:13  vfrolov
 * Added checks of DeviceExtension for zero
 *
 * Revision 1.29  2007/07/20 08:00:22  vfrolov
 * Implemented TX buffer
 *
 * Revision 1.28  2007/07/03 14:35:17  vfrolov
 * Implemented pinout customization
 *
 * Revision 1.27  2007/06/05 12:15:08  vfrolov
 * Fixed memory leak
 *
 * Revision 1.26  2007/06/01 16:22:40  vfrolov
 * Implemented plug-in and exclusive modes
 *
 * Revision 1.25  2007/06/01 08:36:26  vfrolov
 * Changed parameter type for SetWriteDelay()
 *
 * Revision 1.24  2007/01/11 14:50:28  vfrolov
 * Pool functions replaced by
 *   C0C_ALLOCATE_POOL()
 *   C0C_ALLOCATE_POOL_WITH_QUOTA()
 *   C0C_FREE_POOL()
 *
 * Revision 1.23  2006/11/23 11:10:10  vfrolov
 * Strict usage fixed port numbers
 *
 * Revision 1.22  2006/11/03 13:13:26  vfrolov
 * CopyStrW() now gets size in characters (not in bytes)
 *
 * Revision 1.21  2006/11/02 16:04:50  vfrolov
 * Added using fixed port numbers
 *
 * Revision 1.20  2006/10/16 08:30:45  vfrolov
 * Added the device interface registration
 *
 * Revision 1.19  2006/10/13 10:22:22  vfrolov
 * Changed name of device object (for WMI)
 *
 * Revision 1.18  2006/10/10 15:18:15  vfrolov
 * Added PortName value setting for WMI
 *
 * Revision 1.17  2006/08/23 13:48:12  vfrolov
 * Implemented WMI functionality
 *
 * Revision 1.16  2006/06/23 11:44:52  vfrolov
 * Mass replacement pDevExt by pIoPort
 *
 * Revision 1.15  2006/06/21 16:23:57  vfrolov
 * Fixed possible BSOD after one port of pair removal
 *
 * Revision 1.14  2006/03/29 09:39:28  vfrolov
 * Fixed possible usage uninitialized portName
 *
 * Revision 1.13  2006/03/27 09:38:23  vfrolov
 * Utilized StrAppendDeviceProperty()
 *
 * Revision 1.12  2006/02/26 08:35:55  vfrolov
 * Added check for start/stop queue matching
 *
 * Revision 1.11  2006/01/10 10:17:23  vfrolov
 * Implemented flow control and handshaking
 * Implemented IOCTL_SERIAL_SET_XON and IOCTL_SERIAL_SET_XOFF
 * Added setting of HoldReasons, WaitForImmediate and AmountInOutQueue
 *   fields of SERIAL_STATUS for IOCTL_SERIAL_GET_COMMSTATUS
 *
 * Revision 1.10  2005/09/27 16:41:01  vfrolov
 * Fixed DeviceType
 *
 * Revision 1.9  2005/09/06 07:23:44  vfrolov
 * Implemented overrun emulation
 *
 * Revision 1.8  2005/08/23 15:49:21  vfrolov
 * Implemented baudrate emulation
 *
 * Revision 1.7  2005/08/16 16:36:33  vfrolov
 * Hidden timeout functions
 *
 * Revision 1.6  2005/07/14 13:51:08  vfrolov
 * Replaced ASSERT by HALT_UNLESS
 *
 * Revision 1.5  2005/07/13 16:12:36  vfrolov
 * Added c0cGlobal struct for global driver's data
 *
 * Revision 1.4  2005/06/28 12:17:12  vfrolov
 * Added pBusExt to C0C_PDOPORT_EXTENSION
 *
 * Revision 1.3  2005/05/20 12:06:05  vfrolov
 * Improved port numbering
 *
 * Revision 1.2  2005/05/12 07:41:27  vfrolov
 * Added ability to change the port names
 *
 * Revision 1.1  2005/01/26 12:18:54  vfrolov
 * Initial revision
 *
 */

#include "precomp.h"
#include <initguid.h>
#include <ntddser.h>
#include "timeout.h"
#include "delay.h"
#include "bufutils.h"
#include "strutils.h"
#include "showport.h"

/*
 * FILE_ID used by HALT_UNLESS to put it on BSOD
 */
#define FILE_ID 6

/********************************************************************/
NTSTATUS InitCommonExt(
    PC0C_COMMON_EXTENSION pDevExt,
    IN PDEVICE_OBJECT pDevObj,
    short doType,
    PWCHAR pPortName)
{
  pDevExt->pDevObj = pDevObj;
  pDevExt->doType = doType;
  return CopyStrW(pDevExt->portName, sizeof(pDevExt->portName)/sizeof(pDevExt->portName[0]), pPortName);
}
/********************************************************************/
VOID RemoveFdoPort(IN PC0C_FDOPORT_EXTENSION pDevExt)
{
  if (pDevExt->pIoPortLocal) {
    FreeTimeouts(pDevExt->pIoPortLocal);
    FreeWriteDelay(pDevExt->pIoPortLocal);
    pDevExt->pIoPortLocal->plugInMode = FALSE;
    pDevExt->pIoPortLocal->exclusiveMode = FALSE;
    pDevExt->pIoPortLocal->pDevExt = NULL;
    FreeTxBuffer(&pDevExt->pIoPortLocal->txBuf);
    pDevExt->pIoPortLocal->brokeChars = 0;  /* reset on idle */
  }

  if (!HidePort(pDevExt))
    SysLogDev(pDevExt->pDevObj, STATUS_UNSUCCESSFUL, L"RemoveFdoPort HidePort FAIL");

  if (pDevExt->symbolicLinkName.Buffer)
    RtlFreeUnicodeString(&pDevExt->symbolicLinkName);

  StrFree(&pDevExt->ntDeviceName);
  StrFree(&pDevExt->win32DeviceName);

  if (pDevExt->pLowDevObj)
    IoDetachDevice(pDevExt->pLowDevObj);

  Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"RemoveFdoPort");

  IoDeleteDevice(pDevExt->pDevObj);
}

NTSTATUS AddFdoPort(IN PDRIVER_OBJECT pDrvObj, IN PDEVICE_OBJECT pPhDevObj)
{
  NTSTATUS status;
  UNICODE_STRING portName;
  PDEVICE_OBJECT pNewDevObj;
  PC0C_FDOPORT_EXTENSION pDevExt;
  PC0C_PDOPORT_EXTENSION pPhDevExt;
  ULONG emuBR, emuOverrun, plugInMode, exclusiveMode, hiddenMode, allDataBits;
  ULONG brokeCharsProbability;
  ULONG addRTTO, addRITO;
  ULONG pinCTS, pinDSR, pinDCD, pinRI;
  UNICODE_STRING ntDeviceName;
  PWCHAR pPhPortName;

  status = STATUS_SUCCESS;
  pDevExt = NULL;
  RtlInitUnicodeString(&portName, NULL);
  RtlInitUnicodeString(&ntDeviceName, NULL);

  StrAppendDeviceProperty(&status, &ntDeviceName, pPhDevObj, DevicePropertyPhysicalDeviceObjectName);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pPhDevObj, status, L"AddFdoPort IoGetDeviceProperty FAIL");
    goto clean;
  }

  pPhDevExt = (PC0C_PDOPORT_EXTENSION)pPhDevObj->DeviceExtension;

  if (!pPhDevExt || pPhDevExt->doType != C0C_DOTYPE_PP) {
    status = STATUS_UNSUCCESSFUL;
    SysLogDev(pPhDevObj, status, L"AddFdoPort FAIL. Type  of PDO is not PP");
    goto clean;
  }

  Trace00((PC0C_COMMON_EXTENSION)pPhDevExt, L"AddFdoPort for ", ntDeviceName.Buffer);

  pPhPortName = pPhDevExt->portName;

  if (!*pPhPortName) {
    status = STATUS_UNSUCCESSFUL;
    SysLogDev(pPhDevObj, status, L"AddFdoPort FAIL. The PDO has invalid port name");
    goto clean;
  }

  {
    UNICODE_STRING portRegistryPath;

    RtlInitUnicodeString(&portRegistryPath, NULL);
    StrAppendPortParametersRegistryPath(&status, &portRegistryPath, pPhPortName);

    if (!NT_SUCCESS(status)) {
    }
    else
    if (pPhDevExt->pIoPortLocal->isComClass) {
      HANDLE hKey;

      status = IoOpenDeviceRegistryKey(pPhDevObj,
                                       PLUGPLAY_REGKEY_DEVICE,
                                       STANDARD_RIGHTS_READ,
                                       &hKey);

      if (NT_SUCCESS(status)) {
        UNICODE_STRING keyName;
        PKEY_VALUE_FULL_INFORMATION pInfo;
        ULONG len;

        RtlInitUnicodeString(&keyName, L"PortName");

        len = sizeof(*pInfo) + sizeof(L"PortName") + (C0C_PORT_NAME_LEN + 1) * sizeof(WCHAR);

        pInfo = C0C_ALLOCATE_POOL(PagedPool, len);

        if (pInfo) {
          status = ZwQueryValueKey(hKey, &keyName, KeyValueFullInformation, pInfo, len, &len);

          if (NT_SUCCESS(status) && pInfo->DataLength <= ((C0C_PORT_NAME_LEN + 1) * sizeof(WCHAR))) {
            StrAppendStr(
                &status,
                &portName,
                (PWCHAR)(((PUCHAR)pInfo) + pInfo->DataOffset),
                (USHORT)(pInfo->DataLength - sizeof(WCHAR)));
          }

          C0C_FREE_POOL(pInfo);
        }

        ZwClose(hKey);
      }

      if (!portName.Length) {
        Trace0((PC0C_COMMON_EXTENSION)pPhDevExt, L"WARNING: Can't get PortName from COM class device node");
        status = STATUS_SUCCESS;
        StrAppendStr0(&status, &portName, pPhPortName);
      } else {
        Trace00((PC0C_COMMON_EXTENSION)pPhDevExt, L"PortName set to ", portName.Buffer);
      }
    }
    else {
      StrAppendParameterPortName(&status, &portName, portRegistryPath.Buffer);

      if (NT_SUCCESS(status) && portName.Length) {
        Trace00((PC0C_COMMON_EXTENSION)pPhDevExt, L"PortName set to ", portName.Buffer);
      } else {
        status = STATUS_SUCCESS;
        StrAppendStr0(&status, &portName, pPhPortName);
      }
    }

    emuBR = C0C_DEFAULT_EMUBR;
    emuOverrun = C0C_DEFAULT_EMUOVERRUN;
    plugInMode = C0C_DEFAULT_PLUGINMODE;
    exclusiveMode = C0C_DEFAULT_EXCLUSIVEMODE;
    hiddenMode = C0C_DEFAULT_HIDDENMODE;
    allDataBits = C0C_DEFAULT_ALLDATABITS;
    pinCTS = C0C_DEFAULT_PIN_CTS;
    pinDSR = C0C_DEFAULT_PIN_DSR;
    pinDCD = C0C_DEFAULT_PIN_DCD;
    pinRI = C0C_DEFAULT_PIN_RI;
    brokeCharsProbability = C0C_DEFAULT_EMUNOISE;
    addRTTO = C0C_DEFAULT_ADDRTTO;
    addRITO = C0C_DEFAULT_ADDRITO;

    if (NT_SUCCESS(status)) {
      RTL_QUERY_REGISTRY_TABLE queryTable[14];
      int i;

      RtlZeroMemory(queryTable, sizeof(queryTable));

      for (i = 0 ; i < (sizeof(queryTable)/sizeof(queryTable[0]) - 1) ; i++) {
        queryTable[i].Flags         = RTL_QUERY_REGISTRY_DIRECT;
        queryTable[i].DefaultType   = REG_DWORD;
        queryTable[i].DefaultLength = sizeof(ULONG);
      }

      i = 0;
      queryTable[i].Name          = L"EmuBR";
      queryTable[i].EntryContext  = &emuBR;
      queryTable[i].DefaultData   = &emuBR;

      i++;
      queryTable[i].Name          = L"EmuOverrun";
      queryTable[i].EntryContext  = &emuOverrun;
      queryTable[i].DefaultData   = &emuOverrun;

      i++;
      queryTable[i].Name          = L"PlugInMode";
      queryTable[i].EntryContext  = &plugInMode;
      queryTable[i].DefaultData   = &plugInMode;

      i++;
      queryTable[i].Name          = L"ExclusiveMode";
      queryTable[i].EntryContext  = &exclusiveMode;
      queryTable[i].DefaultData   = &exclusiveMode;

      i++;
      queryTable[i].Name          = L"HiddenMode";
      queryTable[i].EntryContext  = &hiddenMode;
      queryTable[i].DefaultData   = &hiddenMode;

      i++;
      queryTable[i].Name          = L"AllDataBits";
      queryTable[i].EntryContext  = &allDataBits;
      queryTable[i].DefaultData   = &allDataBits;

      i++;
      queryTable[i].Name          = L"cts";
      queryTable[i].EntryContext  = &pinCTS;
      queryTable[i].DefaultData   = &pinCTS;

      i++;
      queryTable[i].Name          = L"dsr";
      queryTable[i].EntryContext  = &pinDSR;
      queryTable[i].DefaultData   = &pinDSR;

      i++;
      queryTable[i].Name          = L"dcd";
      queryTable[i].EntryContext  = &pinDCD;
      queryTable[i].DefaultData   = &pinDCD;

      i++;
      queryTable[i].Name          = L"ri";
      queryTable[i].EntryContext  = &pinRI;
      queryTable[i].DefaultData   = &pinRI;

      i++;
      queryTable[i].Name          = L"EmuNoise";
      queryTable[i].EntryContext  = &brokeCharsProbability;
      queryTable[i].DefaultData   = &brokeCharsProbability;

      i++;
      queryTable[i].Name          = L"AddRTTO";
      queryTable[i].EntryContext  = &addRTTO;
      queryTable[i].DefaultData   = &addRTTO;

      i++;
      queryTable[i].Name          = L"AddRITO";
      queryTable[i].EntryContext  = &addRITO;
      queryTable[i].DefaultData   = &addRITO;

      RtlQueryRegistryValues(
          RTL_REGISTRY_ABSOLUTE,
          portRegistryPath.Buffer,
          queryTable,
          NULL,
          NULL);
    }

    StrFree(&portRegistryPath);
  }

  if (!NT_SUCCESS(status)) {
    SysLogDev(pPhDevObj, status, L"AddFdoPort FAIL");
    goto clean;
  }

  status = IoCreateDevice(pDrvObj,
                          sizeof(*pDevExt),
                          NULL,
                          FILE_DEVICE_SERIAL_PORT,
                          FILE_DEVICE_SECURE_OPEN,
                          TRUE,
                          &pNewDevObj);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pPhDevObj, status, L"AddFdoPort IoCreateDevice FAIL");
    goto clean;
  }

  HALT_UNLESS(pNewDevObj);
  pDevExt = pNewDevObj->DeviceExtension;
  HALT_UNLESS(pDevExt);
  RtlZeroMemory(pDevExt, sizeof(*pDevExt));
  pDevExt->pIoPortLocal = pPhDevExt->pIoPortLocal;
  status = InitCommonExt((PC0C_COMMON_EXTENSION)pDevExt, pNewDevObj, C0C_DOTYPE_FP, portName.Buffer);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pPhDevObj, status, L"AddFdoPort FAIL");
    goto clean;
  }

  pDevExt->pIoPortLocal->pDevExt = pDevExt;

  if (emuBR) {
    if (NT_SUCCESS(AllocWriteDelay(pDevExt->pIoPortLocal)))
      Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled baudrate emulation");
    else
      SysLogDev(pPhDevObj, status, L"AddFdoPort AllocWriteDelay FAIL");
  } else {
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled baudrate emulation");
  }

  if (emuOverrun) {
    pDevExt->pIoPortLocal->emuOverrun = TRUE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled overrun emulation");
  } else {
    pDevExt->pIoPortLocal->emuOverrun = FALSE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled overrun emulation");
  }

  if (plugInMode) {
    pDevExt->pIoPortLocal->plugInMode = TRUE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled plug-in mode");
  } else {
    pDevExt->pIoPortLocal->plugInMode = FALSE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled plug-in mode");
  }

  if (exclusiveMode) {
    pDevExt->pIoPortLocal->exclusiveMode = TRUE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled exclusive mode");
  } else {
    pDevExt->pIoPortLocal->exclusiveMode = FALSE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled exclusive mode");
  }

  if (allDataBits) {
    pDevExt->pIoPortLocal->allDataBits = TRUE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled all data bits");
  } else {
    pDevExt->pIoPortLocal->allDataBits = FALSE;
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled all data bits");
  }

  SetHiddenMode(pDevExt, hiddenMode);

  pDevExt->pIoPortLocal->addRTTO = addRTTO;

#if ENABLE_TRACING
  if (addRTTO)
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled ReadTotalTimeoutConstant increase");
#endif /* ENABLE_TRACING */

  pDevExt->pIoPortLocal->addRITO = addRITO;

#if ENABLE_TRACING
  if (addRITO)
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled ReadIntervalTimeout increase");
#endif /* ENABLE_TRACING */

  AllocTimeouts(pDevExt->pIoPortLocal);

  RtlZeroMemory(&pDevExt->pIoPortLocal->specialChars, sizeof(pDevExt->pIoPortLocal->specialChars));
  pDevExt->pIoPortLocal->specialChars.XonChar      = 0x11;
  pDevExt->pIoPortLocal->specialChars.XoffChar     = 0x13;

  RtlZeroMemory(&pDevExt->pIoPortLocal->handFlow, sizeof(pDevExt->pIoPortLocal->handFlow));
  pDevExt->pIoPortLocal->handFlow.ControlHandShake = SERIAL_DTR_CONTROL;
  pDevExt->pIoPortLocal->handFlow.FlowReplace      = SERIAL_RTS_CONTROL;

  pDevExt->pIoPortLocal->lineControl.WordLength    = 7;
  pDevExt->pIoPortLocal->lineControl.Parity        = EVEN_PARITY;
  pDevExt->pIoPortLocal->lineControl.StopBits      = STOP_BIT_1;
  pDevExt->pIoPortLocal->baudRate.BaudRate         = 1200;

  SetWriteDelay(pDevExt->pIoPortLocal);

  SetTxBuffer(&pDevExt->pIoPortLocal->txBuf, 1, TRUE);

  pDevExt->pIoPortLocal->modemControl |= C0C_MCR_OUT2;

  PinMap(pDevExt->pIoPortLocal, pinCTS, pinDSR, pinDCD, pinRI);

  pDevExt->pIoPortLocal->brokeCharsProbability = brokeCharsProbability;

#if ENABLE_TRACING
  if (brokeCharsProbability)
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Enabled noise emulation");
  else
    Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"Disabled noise emulation");
#endif /* ENABLE_TRACING */

  pDevExt->pLowDevObj = IoAttachDeviceToDeviceStack(pNewDevObj, pPhDevObj);

  if (!pDevExt->pLowDevObj) {
    status = STATUS_NO_SUCH_DEVICE;
    SysLogDev(pPhDevObj, status, L"AddFdoPort IoAttachDeviceToDeviceStack FAIL");
    goto clean;
  }

  pNewDevObj->Flags &= ~DO_DEVICE_INITIALIZING;
  pNewDevObj->Flags |= DO_BUFFERED_IO;

  /* Create symbolic links to device */

  RtlInitUnicodeString(&pDevExt->ntDeviceName, NULL);
  StrAppendStr0(&status, &pDevExt->ntDeviceName, ntDeviceName.Buffer);

  RtlInitUnicodeString(&pDevExt->win32DeviceName, NULL);
  StrAppendStr0(&status, &pDevExt->win32DeviceName, C0C_PREF_WIN32_DEVICE_NAME);
  StrAppendStr0(&status, &pDevExt->win32DeviceName, portName.Buffer);

  if (!NT_SUCCESS(status)) {
    StrFree(&pDevExt->win32DeviceName);
    StrFree(&pDevExt->ntDeviceName);

    SysLogDev(pPhDevObj, status, L"AddFdoPort StrAppendStr0 FAIL");
  }

  status = IoRegisterDeviceInterface(pPhDevObj,
                                     (LPGUID)&GUID_CLASS_COMPORT,
                                     NULL,
                                     &pDevExt->symbolicLinkName);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pPhDevObj, status, L"AddFdoPort IoRegisterDeviceInterface FAIL");
    pDevExt->symbolicLinkName.Buffer = NULL;
  }

  if (!pDevExt->pIoPortLocal->plugInMode || pDevExt->pIoPortLocal->pIoPortRemote->isOpen) {
    if (!ShowPort(pDevExt))
      SysLogDev(pDevExt->pDevObj, STATUS_UNSUCCESSFUL, L"AddFdoPort ShowPort FAIL");
  } else {
    HidePortName(pDevExt);
  }

  status = STATUS_SUCCESS;

  Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"AddFdoPort OK");

clean:

  if (!NT_SUCCESS(status) && pDevExt)
    RemoveFdoPort(pDevExt);

  StrFree(&ntDeviceName);
  StrFree(&portName);

  return status;
}
/********************************************************************/
VOID RemovePdoPort(IN PC0C_PDOPORT_EXTENSION pDevExt)
{
  Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"RemovePdoPort");

  IoDeleteDevice(pDevExt->pDevObj);
}

NTSTATUS AddPdoPort(
    IN PDRIVER_OBJECT pDrvObj,
    IN ULONG num,
    IN BOOLEAN isA,
    IN PC0C_FDOBUS_EXTENSION pBusExt,
    IN PC0C_IO_PORT pIoPortLocal,
    OUT PC0C_PDOPORT_EXTENSION *ppDevExt)
{
  NTSTATUS status;
  UNICODE_STRING portName;
  PDEVICE_OBJECT pNewDevObj;
  UNICODE_STRING ntDeviceName;
  PC0C_PDOPORT_EXTENSION pDevExt = NULL;

  status = STATUS_SUCCESS;

  RtlInitUnicodeString(&portName, NULL);
  StrAppendStr0(&status, &portName, isA ? C0C_PREF_PORT_NAME_A : C0C_PREF_PORT_NAME_B);
  StrAppendNum(&status, &portName, num, 10);

  RtlInitUnicodeString(&ntDeviceName, NULL);
  StrAppendStr0(&status, &ntDeviceName, isA ? C0C_PREF_DEVICE_NAME_A : C0C_PREF_DEVICE_NAME_B);
  StrAppendNum(&status, &ntDeviceName, num, 10);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pBusExt->pDevObj, status, L"AddPdoPort FAIL");
    goto clean;
  }

  status = IoCreateDevice(pDrvObj,
                          sizeof(*pDevExt),
                          &ntDeviceName,
                          FILE_DEVICE_SERIAL_PORT,
                          FILE_DEVICE_SECURE_OPEN,
                          TRUE,
                          &pNewDevObj);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pBusExt->pDevObj, status, L"AddPdoPort IoCreateDevice FAIL");
    goto clean;
  }

  HALT_UNLESS(pNewDevObj);
  pIoPortLocal->pPhDevObj = pNewDevObj;
  pDevExt = (pNewDevObj)->DeviceExtension;
  HALT_UNLESS(pDevExt);
  RtlZeroMemory(pDevExt, sizeof(*pDevExt));
  status = InitCommonExt((PC0C_COMMON_EXTENSION)pDevExt, pNewDevObj, C0C_DOTYPE_PP, portName.Buffer);

  if (!NT_SUCCESS(status)) {
    SysLogDev(pBusExt->pDevObj, status, L"AddPdoPort FAIL");
    goto clean;
  }

  pDevExt->pBusExt = pBusExt;
  pDevExt->pIoPortLocal = pIoPortLocal;

  Trace00((PC0C_COMMON_EXTENSION)pDevExt, L"AddPdoPort OK - ", ntDeviceName.Buffer);

clean:

  if (!NT_SUCCESS(status) && pDevExt) {
    RemovePdoPort(pDevExt);
    pDevExt = NULL;
  }

  StrFree(&ntDeviceName);
  StrFree(&portName);

  *ppDevExt = pDevExt;

  return status;
}
/********************************************************************/
ULONG ListFdoBusGetFreeNum()
{
  ULONG numNext;
  KIRQL oldIrql;
  PLIST_ENTRY Flink;

  numNext = 0;

  KeAcquireSpinLock(&c0cGlobal.listFdoBusLock, &oldIrql);

  for (Flink = c0cGlobal.listFdoBus.Flink ;; Flink = Flink->Flink) {
    ULONG num;

    if (Flink == &c0cGlobal.listFdoBus)
      break;

    num = CONTAINING_RECORD(Flink, C0C_FDOBUS_EXTENSION, listEntry)->portNum;

    if (numNext < num)
      break;

    numNext = num + 1;
  }

  KeReleaseSpinLock(&c0cGlobal.listFdoBusLock, oldIrql);

  return numNext;
}

VOID ListFdoBusInsert(PC0C_FDOBUS_EXTENSION pDevExt)
{
  KIRQL oldIrql;
  PLIST_ENTRY Flink;

  KeAcquireSpinLock(&c0cGlobal.listFdoBusLock, &oldIrql);

  for (Flink = c0cGlobal.listFdoBus.Flink ;; Flink = Flink->Flink) {
    if (Flink == &c0cGlobal.listFdoBus ||
        pDevExt->portNum <= CONTAINING_RECORD(Flink, C0C_FDOBUS_EXTENSION, listEntry)->portNum)
    {
      InsertHeadList(Flink, &pDevExt->listEntry);
      KeReleaseSpinLock(&c0cGlobal.listFdoBusLock, oldIrql);
      return;
    }
  }
}

VOID ListFdoBusRemove(PC0C_FDOBUS_EXTENSION pDevExt)
{
  KIRQL oldIrql;

  KeAcquireSpinLock(&c0cGlobal.listFdoBusLock, &oldIrql);

  RemoveEntryList(&pDevExt->listEntry);

  KeReleaseSpinLock(&c0cGlobal.listFdoBusLock, oldIrql);
}

VOID RemoveFdoBus(IN PC0C_FDOBUS_EXTENSION pDevExt)
{
  int i;

  for (i = 0 ; i < 2 ; i++) {
    if (pDevExt->childs[i].pDevExt)
      RemovePdoPort(pDevExt->childs[i].pDevExt);
  }

  if (pDevExt->pLowDevObj)
    IoDetachDevice(pDevExt->pLowDevObj);

  ListFdoBusRemove(pDevExt);

  Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"RemoveFdoBus");

  IoDeleteDevice(pDevExt->pDevObj);
}

ULONG GetPortNum(IN PDEVICE_OBJECT pPhDevObj)
{
  ULONG num;
  HANDLE hKey;
  NTSTATUS status;

  status = IoOpenDeviceRegistryKey(pPhDevObj,
                                   PLUGPLAY_REGKEY_DEVICE,
                                   STANDARD_RIGHTS_READ,
                                   &hKey);

  if (NT_SUCCESS(status)) {
    UNICODE_STRING keyName;
    PKEY_VALUE_PARTIAL_INFORMATION pInfo;
    ULONG len;

    RtlInitUnicodeString(&keyName, C0C_REGSTR_VAL_PORT_NUM);

    len = sizeof(*pInfo) + sizeof(ULONG);

    num = (ULONG)-1;

    pInfo = C0C_ALLOCATE_POOL(PagedPool, len);

    if (pInfo) {
      status = ZwQueryValueKey(hKey, &keyName, KeyValuePartialInformation, pInfo, len, &len);

      if (NT_SUCCESS(status) && pInfo->DataLength == sizeof(ULONG))
        num = *(PULONG)pInfo->Data;

      C0C_FREE_POOL(pInfo);
    }

    if (num == (ULONG)-1) {
      num = ListFdoBusGetFreeNum();

      status = ZwSetValueKey(hKey, &keyName, 0, REG_DWORD, &num, sizeof(num));

      if (!NT_SUCCESS(status))
        SysLogDev(pPhDevObj, status, L"ZwSetValueKey(PortName) FAIL");
    }

    ZwClose(hKey);
  } else {
    SysLogDev(pPhDevObj, status, L"GetPortNum IoOpenDeviceRegistryKey(PLUGPLAY_REGKEY_DEVICE) FAIL");

    num = ListFdoBusGetFreeNum();
  }

  return num;
}

NTSTATUS AddFdoBus(IN PDRIVER_OBJECT pDrvObj, IN PDEVICE_OBJECT pPhDevObj)
{
  NTSTATUS status = STATUS_SUCCESS;
  UNICODE_STRING portName;
  UNICODE_STRING ntDeviceName;
  PDEVICE_OBJECT pNewDevObj;
  PC0C_FDOBUS_EXTENSION pDevExt = NULL;
  ULONG num;
  int i;

  num = GetPortNum(pPhDevObj);

  RtlInitUnicodeString(&portName, NULL);
  StrAppendStr0(&status, &portName, C0C_PREF_BUS_NAME);
  StrAppendNum(&status, &portName, num, 10);

  RtlInitUnicodeString(&ntDeviceName, NULL);
  StrAppendStr0(&status, &ntDeviceName, C0C_PREF_NT_DEVICE_NAME);
  StrAppendStr(&status, &ntDeviceName, portName.Buffer, portName.Length);

  if (!NT_SUCCESS(status)) {
    SysLogDrv(pDrvObj, status, L"AddFdoBus FAIL");
    goto clean;
  }

  status = IoCreateDevice(pDrvObj,
                          sizeof(*pDevExt),
                          &ntDeviceName,
                          FILE_DEVICE_BUS_EXTENDER,
                          0,
                          TRUE,
                          &pNewDevObj);

  if (!NT_SUCCESS(status)) {
    SysLogDrv(pDrvObj, status, L"AddFdoBus IoCreateDevice FAIL");
    goto clean;
  }

  HALT_UNLESS(pNewDevObj);
  pDevExt = pNewDevObj->DeviceExtension;
  HALT_UNLESS(pDevExt);
  RtlZeroMemory(pDevExt, sizeof(*pDevExt));
  pDevExt->portNum = num;
  ListFdoBusInsert(pDevExt);
  status = InitCommonExt((PC0C_COMMON_EXTENSION)pDevExt, pNewDevObj, C0C_DOTYPE_FB, portName.Buffer);

  if (!NT_SUCCESS(status)) {
    SysLogDrv(pDrvObj, status, L"AddFdoBus InitCommonExt FAIL");
    goto clean;
  }

  pDevExt->pLowDevObj = IoAttachDeviceToDeviceStack(pNewDevObj, pPhDevObj);

  if (!pDevExt->pLowDevObj) {
    status = STATUS_NO_SUCH_DEVICE;
    SysLogDev(pNewDevObj, status, L"AddFdoBus IoAttachDeviceToDeviceStack FAIL");
    goto clean;
  }

  pNewDevObj->Flags &= ~DO_DEVICE_INITIALIZING;
  KeInitializeSpinLock(&pDevExt->ioLock);

  for (i = 0 ; i < 2 ; i++) {
    PC0C_IO_PORT pIoPort;
    int j;

    pIoPort = &pDevExt->childs[i].ioPort;

    pIoPort->pIoLock = &pDevExt->ioLock;

    for (j = 0 ; j < C0C_QUEUE_SIZE ; j++) {
      InitializeListHead(&pIoPort->irpQueues[j].queue);
      pIoPort->irpQueues[j].pCurrent = NULL;
#if DBG
      pIoPort->irpQueues[j].started = FALSE;
#endif /* DBG */
    }

    pIoPort->pIoPortRemote = &pDevExt->childs[(i + 1) % 2].ioPort;

    status = AddPdoPort(pDrvObj,
                        num,
                        (BOOLEAN)(i ? FALSE : TRUE),
                        pDevExt,
                        pIoPort,
                        &pDevExt->childs[i].pDevExt);

    if (!NT_SUCCESS(status)) {
      SysLogDev(pNewDevObj, status, L"AddFdoBus AddPdoPort FAIL");
      pDevExt->childs[i].pDevExt = NULL;
      goto clean;
    }
  }

  Trace0((PC0C_COMMON_EXTENSION)pDevExt, L"AddFdoBus OK");

clean:

  if (!NT_SUCCESS(status) && pDevExt)
    RemoveFdoBus(pDevExt);

  StrFree(&ntDeviceName);
  StrFree(&portName);

  return status;
}
/********************************************************************/
NTSTATUS c0cAddDevice(IN PDRIVER_OBJECT pDrvObj, IN PDEVICE_OBJECT pPhDevObj)
{
  NTSTATUS status;
  UNICODE_STRING property;

  status = STATUS_SUCCESS;
  RtlInitUnicodeString(&property, NULL);

  StrAppendDeviceProperty(&status, &property, pPhDevObj, DevicePropertyHardwareID);

  if (NT_SUCCESS(status))
    Trace00(NULL, L"c0cAddDevice for ", property.Buffer);
  else {
    SysLogDrv(pDrvObj, status, L"c0cAddDevice IoGetDeviceProperty FAIL");
    return status;
  }

  if (!_wcsicmp(C0C_PORT_DEVICE_ID, property.Buffer)) {
    StrFree(&property);
    status = AddFdoPort(pDrvObj, pPhDevObj);
  }
  else
  if (!_wcsicmp(C0C_BUS_DEVICE_ID, property.Buffer)) {
    StrFree(&property);
    status = AddFdoBus(pDrvObj, pPhDevObj);
  }
  else {
    StrFree(&property);
    status = STATUS_UNSUCCESSFUL;
    SysLogDrv(pDrvObj, status, L"c0cAddDevice unknown HardwareID");
  }

  return status;
}
/********************************************************************/
