{*********************************************************}
{                                                         }
{                 Zeos Database Objects                   }
{            Interfaces for Native Plain Drivers          }
{                                                         }
{          Originally distributed by firebird.org         }
{                  ported by EgonHugeist                  }
{                                                         }
{*********************************************************}

{@********************************************************}
{    Copyright (c) 1999-2020 Zeos Development Group       }
{                                                         }
{ License Agreement:                                      }
{                                                         }
{ This library is distributed in the hope that it will be }
{ useful, but WITHOUT ANY WARRANTY; without even the      }
{ implied warranty of MERCHANTABILITY or FITNESS FOR      }
{ A PARTICULAR PURPOSE.  See the GNU Lesser General       }
{ Public License for more details.                        }
{                                                         }
{ The source code of the ZEOS Libraries and packages are  }
{ distributed under the Library GNU General Public        }
{ License (see the file COPYING / COPYING.ZEOS)           }
{ with the following  modification:                       }
{ As a special exception, the copyright holders of this   }
{ library give you permission to link this library with   }
{ independent modules to produce an executable,           }
{ regardless of the license terms of these independent    }
{ modules, and to copy and distribute the resulting       }
{ executable under terms of your choice, provided that    }
{ you also meet, for each linked independent module,      }
{ the terms and conditions of the license of that module. }
{ An independent module is a module which is not derived  }
{ from or based on this library. If you modify this       }
{ library, you may extend this exception to your version  }
{ of the library, but you are not obligated to do so.     }
{ If you do not wish to do so, delete this exception      }
{ statement from your version.                            }
{                                                         }
{                                                         }
{ The project web site is located on:                     }
{   https://zeoslib.sourceforge.io/ (FORUM)               }
{   http://sourceforge.net/p/zeoslib/tickets/ (BUGTRACKER)}
{   svn://svn.code.sf.net/p/zeoslib/code-0/trunk (SVN)    }
{                                                         }
{   http://www.sourceforge.net/projects/zeoslib.          }
{                                                         }
{                                                         }
{                                 Zeos Development Group. }
{********************************************************@}

{ This file was autogenerated by cloop - Cross Language Object Oriented Programming }

{ the original file shipped by Firebird 3.0
1. to get it running with FPC: add the "INTERFACES CORBA" macro
and add "OBJECTCHECKS OFF"
2. to get it running with D7..D2007:
comment all error checks original like FbException.checkException(status);
and stricly follow step 3
Those compiler (including FPC < v3) do not support class consts so we add
replacements using the WITH_CLASS_CONST define
3. genaral: comment all try .. except block they leave ugly warnings,
slowing down the code executable code and finally D7 crash an each call
with multiple parameters.
So we do the error checks @all
4. comment the FBException. The error details are not interpreted..
just a comment: it also would be possible to implement the interface of FB
directly. but this means our inheritence model won't work for the driver
because we need the version field and the VTable in our object ...

5. to avoid overdozed rtti, add the "public" and "protected" keywords to all
  VTable and Impl(dispatcher) objects
6. Make a string replace : QWord -> UInt64 etc

}
unit ZPlainFirebird;

interface

{$I ZPlain.inc}

{$IFNDEF ZEOS_DISABLE_FIREBIRD}  //if set we've a empty unit

uses ZCompatibility, ZPlainFirebirdInterbaseDriver;

  {$IFDEF FPC}
  {$INTERFACES CORBA}
  {$OBJECTCHECKS OFF}
  {$ENDIF}

{$IFNDEF WITH_CLASS_CONST}
const
  IStatus_VERSION = 10;
  IStatus_STATE_WARNINGS = Cardinal(1);
  IStatus_STATE_ERRORS = Cardinal(2);
  IStatus_RESULT_ERROR = Integer(-1);
  IStatus_RESULT_OK = Integer(0);
  IStatus_RESULT_NO_DATA = Integer(1);
  IStatus_RESULT_SEGMENT = Integer(2);

  IStatement_PREPARE_PREFETCH_NONE = Cardinal(0);
  IStatement_PREPARE_PREFETCH_TYPE = Cardinal(1);
  IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS = Cardinal(2);
  IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS = Cardinal(4);
  IStatement_PREPARE_PREFETCH_LEGACY_PLAN = Cardinal(8);
  IStatement_PREPARE_PREFETCH_DETAILED_PLAN = Cardinal(16);
  IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS = Cardinal(32);
  IStatement_PREPARE_PREFETCH_FLAGS = Cardinal(64);
  IStatement_PREPARE_PREFETCH_METADATA = Cardinal(IStatement_PREPARE_PREFETCH_TYPE or IStatement_PREPARE_PREFETCH_FLAGS or IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS or IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS);
  IStatement_PREPARE_PREFETCH_ALL = Cardinal(IStatement_PREPARE_PREFETCH_METADATA or IStatement_PREPARE_PREFETCH_LEGACY_PLAN or IStatement_PREPARE_PREFETCH_DETAILED_PLAN or IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS);
  IStatement_FLAG_HAS_CURSOR = Cardinal(1);
  IStatement_FLAG_REPEAT_EXECUTE = Cardinal(2);
  IStatement_CURSOR_TYPE_SCROLLABLE = Cardinal(1);

  IXpbBuilder_VERSION = 3;
  IXpbBuilder_DPB = Cardinal(1);
  IXpbBuilder_SPB_ATTACH = Cardinal(2);
  IXpbBuilder_SPB_START = Cardinal(3);
  IXpbBuilder_TPB = Cardinal(4);
  IXpbBuilder_BATCH = Cardinal(5);
  IXpbBuilder_BPB = Cardinal(6);
  IXpbBuilder_SPB_SEND = Cardinal(7);
  IXpbBuilder_SPB_RECEIVE = Cardinal(8);
  IXpbBuilder_SPB_RESPONSE = Cardinal(9);

  IBatch_VERSION = Cardinal(3);
  IBatch_VERSION1 = Byte(1);
  IBatch_TAG_MULTIERROR = Byte(1);
  IBatch_TAG_RECORD_COUNTS = Byte(2);
  IBatch_TAG_BUFFER_BYTES_SIZE = Byte(3);
  IBatch_TAG_BLOB_POLICY = Byte(4);
  IBatch_TAG_DETAILED_ERRORS = Byte(5);
  IBatch_BLOB_NONE = Byte(0);
  IBatch_BLOB_ID_ENGINE = Byte(1);
  IBatch_BLOB_ID_USER = Byte(2);
  IBatch_BLOB_STREAM = Byte(3);
  IBatch_BLOB_SEGHDR_ALIGN = Cardinal(2);

  IBatchCompletionState_VERSION = Cardinal(3);
  IBatchCompletionState_EXECUTE_FAILED = Integer(-1);
  IBatchCompletionState_SUCCESS_NO_INFO = Integer(-2);
  IBatchCompletionState_NO_MORE_ERRORS = Cardinal(-1);

  IDecFloat16_STRING_SIZE = Cardinal(24);
  IDecFloat34_STRING_SIZE = Cardinal(43);
  IInt128_STRING_SIZE = Cardinal(46);
{$ENDIF WITH_CLASS_CONST}

type
  IVersioned = class;
  IReferenceCounted = class;
  IDisposable = class;
  IStatus = class;
  IMaster = class;
  IPluginBase = class;
  IPluginSet = class;
  IConfigEntry = class;
  IConfig = class;
  IFirebirdConf = class;
  IPluginConfig = class;
  IPluginFactory = class;
  IPluginModule = class;
  IPluginManager = class;
  ICryptKey = class;
  IConfigManager = class;
  IEventCallback = class;
  IBlob = class;
  ITransaction = class;
  IMessageMetadata = class;
  IMetadataBuilder = class;
  IResultSet = class;
  IStatement = class;
  IBatch = class; {FB4}
  IBatchCompletionState = class; {FB4}
  IReplicator = class; {FB4}
  IRequest = class;
  IEvents = class;
  IAttachment = class;
  IService = class;
  IProvider = class;
  IDtcStart = class;
  IDtc = class;
  IAuth = class;
  IWriter = class;
  IServerBlock = class;
  IClientBlock = class;
  IServer = class;
  IClient = class;
  IUserField = class;
  ICharUserField = class;
  IIntUserField = class;
  IUser = class;
  IListUsers = class;
  ILogonInfo = class;
  IManagement = class;
  IAuthBlock = class; {FB4}
  IWireCryptPlugin = class;
  ICryptKeyCallback = class;
  IKeyHolderPlugin = class;
  IDbCryptInfo = class;
  IDbCryptPlugin = class;
  IExternalContext = class;
  IExternalResultSet = class;
  IExternalFunction = class;
  IExternalProcedure = class;
  IExternalTrigger = class;
  IRoutineMetadata = class;
  IExternalEngine = class;
  ITimer = class;
  ITimerControl = class;
  IVersionCallback = class;
  IUtil = class;
  IOffsetsCallback = class;
  IXpbBuilder = class;
  ITraceConnection = class;
  ITraceDatabaseConnection = class;
  ITraceTransaction = class;
  ITraceParams = class;
  ITraceStatement = class;
  ITraceSQLStatement = class;
  ITraceBLRStatement = class;
  ITraceDYNRequest = class;
  ITraceContextVariable = class;
  ITraceProcedure = class;
  ITraceFunction = class;
  ITraceTrigger = class;
  ITraceServiceConnection = class;
  ITraceStatusVector = class;
  ITraceSweepInfo = class;
  ITraceLogWriter = class;
  ITraceInitInfo = class;
  ITracePlugin = class;
  ITraceFactory = class;
  IUdrFunctionFactory = class;
  IUdrProcedureFactory = class;
  IUdrTriggerFactory = class;
  IUdrPlugin = class;
  IDecFloat16 = class; {FB4}
  IDecFloat34 = class;{FB4}
  IInt128 = class; {FB4}
  IReplicatedRecord = class; {FB4}
  IReplicatedField = class; {FB4}
  IReplicatedTransaction = class; {FB4}
  IReplicatedSession = class; {FB4}

  BooleanPtr = ^Boolean;
  PIKeyHolderPlugin = ^IKeyHolderPlugin;

  IReferenceCounted_addRefPtr = procedure(this: IReferenceCounted); cdecl;
  IReferenceCounted_releasePtr = function(this: IReferenceCounted): Integer; cdecl;
  IDisposable_disposePtr = procedure(this: IDisposable); cdecl;
  IStatus_initPtr = procedure(this: IStatus); cdecl;
  IStatus_getStatePtr = function(this: IStatus): Cardinal; cdecl;
  IStatus_setErrors2Ptr = procedure(this: IStatus; length: Cardinal; value: PNativeInt); cdecl;
  IStatus_setWarnings2Ptr = procedure(this: IStatus; length: Cardinal; value: PNativeInt); cdecl;
  IStatus_setErrorsPtr = procedure(this: IStatus; value: PNativeInt); cdecl;
  IStatus_setWarningsPtr = procedure(this: IStatus; value: PNativeInt); cdecl;
  IStatus_getErrorsPtr = function(this: IStatus): PNativeInt; cdecl;
  IStatus_getWarningsPtr = function(this: IStatus): PNativeInt; cdecl;
  IStatus_clonePtr = function(this: IStatus): IStatus; cdecl;
  IMaster_getStatusPtr = function(this: IMaster): IStatus; cdecl;
  IMaster_getDispatcherPtr = function(this: IMaster): IProvider; cdecl;
  IMaster_getPluginManagerPtr = function(this: IMaster): IPluginManager; cdecl;
  IMaster_getTimerControlPtr = function(this: IMaster): ITimerControl; cdecl;
  IMaster_getDtcPtr = function(this: IMaster): IDtc; cdecl;
  IMaster_registerAttachmentPtr = function(this: IMaster; provider: IProvider; attachment: IAttachment): IAttachment; cdecl;
  IMaster_registerTransactionPtr = function(this: IMaster; attachment: IAttachment; transaction: ITransaction): ITransaction; cdecl;
  IMaster_getMetadataBuilderPtr = function(this: IMaster; status: IStatus; fieldCount: Cardinal): IMetadataBuilder; cdecl;
  IMaster_serverModePtr = function(this: IMaster; mode: Integer): Integer; cdecl;
  IMaster_getUtilInterfacePtr = function(this: IMaster): IUtil; cdecl;
  IMaster_getConfigManagerPtr = function(this: IMaster): IConfigManager; cdecl;
  IMaster_getProcessExitingPtr = function(this: IMaster): Boolean; cdecl;
  IPluginBase_setOwnerPtr = procedure(this: IPluginBase; r: IReferenceCounted); cdecl;
  IPluginBase_getOwnerPtr = function(this: IPluginBase): IReferenceCounted; cdecl;
  IPluginSet_getNamePtr = function(this: IPluginSet): PAnsiChar; cdecl;
  IPluginSet_getModuleNamePtr = function(this: IPluginSet): PAnsiChar; cdecl;
  IPluginSet_getPluginPtr = function(this: IPluginSet; status: IStatus): IPluginBase; cdecl;
  IPluginSet_nextPtr = procedure(this: IPluginSet; status: IStatus); cdecl;
  IPluginSet_set_Ptr = procedure(this: IPluginSet; status: IStatus; s: PAnsiChar); cdecl;
  IConfigEntry_getNamePtr = function(this: IConfigEntry): PAnsiChar; cdecl;
  IConfigEntry_getValuePtr = function(this: IConfigEntry): PAnsiChar; cdecl;
  IConfigEntry_getIntValuePtr = function(this: IConfigEntry): Int64; cdecl;
  IConfigEntry_getBoolValuePtr = function(this: IConfigEntry): Boolean; cdecl;
  IConfigEntry_getSubConfigPtr = function(this: IConfigEntry; status: IStatus): IConfig; cdecl;
  IConfig_findPtr = function(this: IConfig; status: IStatus; name: PAnsiChar): IConfigEntry; cdecl;
  IConfig_findValuePtr = function(this: IConfig; status: IStatus; name: PAnsiChar; value: PAnsiChar): IConfigEntry; cdecl;
  IConfig_findPosPtr = function(this: IConfig; status: IStatus; name: PAnsiChar; pos: Cardinal): IConfigEntry; cdecl;
  IFirebirdConf_getKeyPtr = function(this: IFirebirdConf; name: PAnsiChar): Cardinal; cdecl;
  IFirebirdConf_asIntegerPtr = function(this: IFirebirdConf; key: Cardinal): Int64; cdecl;
  IFirebirdConf_asStringPtr = function(this: IFirebirdConf; key: Cardinal): PAnsiChar; cdecl;
  IFirebirdConf_asBooleanPtr = function(this: IFirebirdConf; key: Cardinal): Boolean; cdecl;
  IFirebirdConf_getVersionPtr = function(this: IFirebirdConf; status: IStatus): Cardinal; cdecl;
  IPluginConfig_getConfigFileNamePtr = function(this: IPluginConfig): PAnsiChar; cdecl;
  IPluginConfig_getDefaultConfigPtr = function(this: IPluginConfig; status: IStatus): IConfig; cdecl;
  IPluginConfig_getFirebirdConfPtr = function(this: IPluginConfig; status: IStatus): IFirebirdConf; cdecl;
  IPluginConfig_setReleaseDelayPtr = procedure(this: IPluginConfig; status: IStatus; microSeconds: UInt64); cdecl;
  IPluginFactory_createPluginPtr = function(this: IPluginFactory; status: IStatus; factoryParameter: IPluginConfig): IPluginBase; cdecl;
  IPluginModule_doCleanPtr = procedure(this: IPluginModule); cdecl;
  {FB4}IPluginModule_threadDetachPtr = procedure(this: IPluginModule); cdecl;
  IPluginManager_registerPluginFactoryPtr = procedure(this: IPluginManager; pluginType: Cardinal; defaultName: PAnsiChar; factory: IPluginFactory); cdecl;
  IPluginManager_registerModulePtr = procedure(this: IPluginManager; cleanup: IPluginModule); cdecl;
  IPluginManager_unregisterModulePtr = procedure(this: IPluginManager; cleanup: IPluginModule); cdecl;
  IPluginManager_getPluginsPtr = function(this: IPluginManager; status: IStatus; pluginType: Cardinal; namesList: PAnsiChar; firebirdConf: IFirebirdConf): IPluginSet; cdecl;
  IPluginManager_getConfigPtr = function(this: IPluginManager; status: IStatus; filename: PAnsiChar): IConfig; cdecl;
  IPluginManager_releasePluginPtr = procedure(this: IPluginManager; plugin: IPluginBase); cdecl;
  ICryptKey_setSymmetricPtr = procedure(this: ICryptKey; status: IStatus; type_: PAnsiChar; keyLength: Cardinal; key: Pointer); cdecl;
  ICryptKey_setAsymmetricPtr = procedure(this: ICryptKey; status: IStatus; type_: PAnsiChar; encryptKeyLength: Cardinal; encryptKey: Pointer; decryptKeyLength: Cardinal; decryptKey: Pointer); cdecl;
  ICryptKey_getEncryptKeyPtr = function(this: ICryptKey; length: PCardinal): Pointer; cdecl;
  ICryptKey_getDecryptKeyPtr = function(this: ICryptKey; length: PCardinal): Pointer; cdecl;
  IConfigManager_getDirectoryPtr = function(this: IConfigManager; code: Cardinal): PAnsiChar; cdecl;
  IConfigManager_getFirebirdConfPtr = function(this: IConfigManager): IFirebirdConf; cdecl;
  IConfigManager_getDatabaseConfPtr = function(this: IConfigManager; dbName: PAnsiChar): IFirebirdConf; cdecl;
  IConfigManager_getPluginConfigPtr = function(this: IConfigManager; configuredPlugin: PAnsiChar): IConfig; cdecl;
  IConfigManager_getInstallDirectoryPtr = function(this: IConfigManager): PAnsiChar; cdecl;
  IConfigManager_getRootDirectoryPtr = function(this: IConfigManager): PAnsiChar; cdecl;
  IConfigManager_getDefaultSecurityDbPtr = function(this: IConfigManager): PAnsiChar; cdecl;
  IEventCallback_eventCallbackFunctionPtr = procedure(this: IEventCallback; length: Cardinal; events: PByte); cdecl;
  IBlob_getInfoPtr = procedure(this: IBlob; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  IBlob_getSegmentPtr = function(this: IBlob; status: IStatus; bufferLength: Cardinal; buffer: Pointer; segmentLength: PCardinal): Integer; cdecl;
  IBlob_putSegmentPtr = procedure(this: IBlob; status: IStatus; length: Cardinal; buffer: Pointer); cdecl;
  IBlob_cancelPtr = procedure(this: IBlob; status: IStatus); cdecl;
  IBlob_closePtr = procedure(this: IBlob; status: IStatus); cdecl;
  IBlob_seekPtr = function(this: IBlob; status: IStatus; mode: Integer; offset: Integer): Integer; cdecl;
  ITransaction_getInfoPtr = procedure(this: ITransaction; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  ITransaction_preparePtr = procedure(this: ITransaction; status: IStatus; msgLength: Cardinal; message: PByte); cdecl;
  ITransaction_commitPtr = procedure(this: ITransaction; status: IStatus); cdecl;
  ITransaction_commitRetainingPtr = procedure(this: ITransaction; status: IStatus); cdecl;
  ITransaction_rollbackPtr = procedure(this: ITransaction; status: IStatus); cdecl;
  ITransaction_rollbackRetainingPtr = procedure(this: ITransaction; status: IStatus); cdecl;
  ITransaction_disconnectPtr = procedure(this: ITransaction; status: IStatus); cdecl;
  ITransaction_joinPtr = function(this: ITransaction; status: IStatus; transaction: ITransaction): ITransaction; cdecl;
  ITransaction_validatePtr = function(this: ITransaction; status: IStatus; attachment: IAttachment): ITransaction; cdecl;
  ITransaction_enterDtcPtr = function(this: ITransaction; status: IStatus): ITransaction; cdecl;
  IMessageMetadata_getCountPtr = function(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
  IMessageMetadata_getFieldPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
  IMessageMetadata_getRelationPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
  IMessageMetadata_getOwnerPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
  IMessageMetadata_getAliasPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
  IMessageMetadata_getTypePtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
  IMessageMetadata_isNullablePtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Boolean; cdecl;
  IMessageMetadata_getSubTypePtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Integer; cdecl;
  IMessageMetadata_getLengthPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
  IMessageMetadata_getScalePtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Integer; cdecl;
  IMessageMetadata_getCharSetPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
  IMessageMetadata_getOffsetPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
  IMessageMetadata_getNullOffsetPtr = function(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
  IMessageMetadata_getBuilderPtr = function(this: IMessageMetadata; status: IStatus): IMetadataBuilder; cdecl;
  IMessageMetadata_getMessageLengthPtr = function(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
  IMessageMetadata_getAlignmentPtr = function(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
  IMessageMetadata_getAlignedLengthPtr = function(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
  IMetadataBuilder_setTypePtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; type_: Cardinal); cdecl;
  IMetadataBuilder_setSubTypePtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; subType: Integer); cdecl;
  IMetadataBuilder_setLengthPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; length: Cardinal); cdecl;
  IMetadataBuilder_setCharSetPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; charSet: Cardinal); cdecl;
  IMetadataBuilder_setScalePtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; scale: Integer); cdecl;
  IMetadataBuilder_truncatePtr = procedure(this: IMetadataBuilder; status: IStatus; count: Cardinal); cdecl;
  IMetadataBuilder_moveNameToIndexPtr = procedure(this: IMetadataBuilder; status: IStatus; name: PAnsiChar; index: Cardinal); cdecl;
  IMetadataBuilder_removePtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal); cdecl;
  IMetadataBuilder_addFieldPtr = function(this: IMetadataBuilder; status: IStatus): Cardinal; cdecl;
  IMetadataBuilder_getMetadataPtr = function(this: IMetadataBuilder; status: IStatus): IMessageMetadata; cdecl;
  IMetadataBuilder_setFieldPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; field: PAnsiChar); cdecl;
  IMetadataBuilder_setRelationPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; relation: PAnsiChar); cdecl;
  IMetadataBuilder_setOwnerPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; owner: PAnsiChar); cdecl;
  IMetadataBuilder_setAliasPtr = procedure(this: IMetadataBuilder; status: IStatus; index: Cardinal; alias: PAnsiChar); cdecl;
  IResultSet_fetchNextPtr = function(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
  IResultSet_fetchPriorPtr = function(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
  IResultSet_fetchFirstPtr = function(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
  IResultSet_fetchLastPtr = function(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
  IResultSet_fetchAbsolutePtr = function(this: IResultSet; status: IStatus; position: Integer; message: Pointer): Integer; cdecl;
  IResultSet_fetchRelativePtr = function(this: IResultSet; status: IStatus; offset: Integer; message: Pointer): Integer; cdecl;
  IResultSet_isEofPtr = function(this: IResultSet; status: IStatus): Boolean; cdecl;
  IResultSet_isBofPtr = function(this: IResultSet; status: IStatus): Boolean; cdecl;
  IResultSet_getMetadataPtr = function(this: IResultSet; status: IStatus): IMessageMetadata; cdecl;
  IResultSet_closePtr = procedure(this: IResultSet; status: IStatus); cdecl;
  IResultSet_setDelayedOutputFormatPtr = procedure(this: IResultSet; status: IStatus; format: IMessageMetadata); cdecl;
  IStatement_getInfoPtr = procedure(this: IStatement; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  IStatement_getTypePtr = function(this: IStatement; status: IStatus): Cardinal; cdecl;
  IStatement_getPlanPtr = function(this: IStatement; status: IStatus; detailed: Boolean): PAnsiChar; cdecl;
  IStatement_getAffectedRecordsPtr = function(this: IStatement; status: IStatus): UInt64; cdecl;
  IStatement_getInputMetadataPtr = function(this: IStatement; status: IStatus): IMessageMetadata; cdecl;
  IStatement_getOutputMetadataPtr = function(this: IStatement; status: IStatus): IMessageMetadata; cdecl;
  IStatement_executePtr = function(this: IStatement; status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; cdecl;
  IStatement_openCursorPtr = function(this: IStatement; status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; flags: Cardinal): IResultSet; cdecl;
  IStatement_setCursorNamePtr = procedure(this: IStatement; status: IStatus; name: PAnsiChar); cdecl;
  IStatement_freePtr = procedure(this: IStatement; status: IStatus); cdecl;
  IStatement_getFlagsPtr = function(this: IStatement; status: IStatus): Cardinal; cdecl;
  IStatement_getTimeoutPtr = function(this: IStatement; status: IStatus): Cardinal; cdecl;
  IStatement_setTimeoutPtr = procedure(this: IStatement; status: IStatus; timeOut: Cardinal); cdecl;
  IStatement_createBatchPtr = function(this: IStatement; status: IStatus; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; cdecl;
  IBatch_addPtr = procedure(this: IBatch; status: IStatus; count: Cardinal; inBuffer: Pointer); cdecl;
  IBatch_addBlobPtr = procedure(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer; blobId: PISC_QUAD; parLength: Cardinal; par: PByte); cdecl;
  IBatch_appendBlobDataPtr = procedure(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer); cdecl;
  IBatch_addBlobStreamPtr = procedure(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer); cdecl;
  IBatch_registerBlobPtr = procedure(this: IBatch; status: IStatus; existingBlob: PISC_QUAD; blobId: PISC_QUAD); cdecl;
  IBatch_executePtr = function(this: IBatch; status: IStatus; transaction: ITransaction): IBatchCompletionState; cdecl;
  IBatch_cancelPtr = procedure(this: IBatch; status: IStatus); cdecl;
  IBatch_getBlobAlignmentPtr = function(this: IBatch; status: IStatus): Cardinal; cdecl;
  IBatch_getMetadataPtr = function(this: IBatch; status: IStatus): IMessageMetadata; cdecl;
  IBatch_setDefaultBpbPtr = procedure(this: IBatch; status: IStatus; parLength: Cardinal; par: PByte); cdecl;
  IBatchCompletionState_getSizePtr = function(this: IBatchCompletionState; status: IStatus): Cardinal; cdecl;
  IBatchCompletionState_getStatePtr = function(this: IBatchCompletionState; status: IStatus; pos: Cardinal): Integer; cdecl;
  IBatchCompletionState_findErrorPtr = function(this: IBatchCompletionState; status: IStatus; pos: Cardinal): Cardinal; cdecl;
  IBatchCompletionState_getStatusPtr = procedure(this: IBatchCompletionState; status: IStatus; to_: IStatus; pos: Cardinal); cdecl;
  IReplicator_processPtr = procedure(this: IReplicator; status: IStatus; length: Cardinal; data: PByte); cdecl;
  IReplicator_closePtr = procedure(this: IReplicator; status: IStatus); cdecl;
  IRequest_receivePtr = procedure(this: IRequest; status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
  IRequest_sendPtr = procedure(this: IRequest; status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
  IRequest_getInfoPtr = procedure(this: IRequest; status: IStatus; level: Integer; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  IRequest_startPtr = procedure(this: IRequest; status: IStatus; tra: ITransaction; level: Integer); cdecl;
  IRequest_startAndSendPtr = procedure(this: IRequest; status: IStatus; tra: ITransaction; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
  IRequest_unwindPtr = procedure(this: IRequest; status: IStatus; level: Integer); cdecl;
  IRequest_freePtr = procedure(this: IRequest; status: IStatus); cdecl;
  IEvents_cancelPtr = procedure(this: IEvents; status: IStatus); cdecl;
  IAttachment_getInfoPtr = procedure(this: IAttachment; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  IAttachment_startTransactionPtr = function(this: IAttachment; status: IStatus; tpbLength: Cardinal; tpb: PByte): ITransaction; cdecl;
  IAttachment_reconnectTransactionPtr = function(this: IAttachment; status: IStatus; length: Cardinal; id: PByte): ITransaction; cdecl;
  IAttachment_compileRequestPtr = function(this: IAttachment; status: IStatus; blrLength: Cardinal; blr: PByte): IRequest; cdecl;
  IAttachment_transactRequestPtr = procedure(this: IAttachment; status: IStatus; transaction: ITransaction; blrLength: Cardinal; blr: PByte; inMsgLength: Cardinal; inMsg: PByte; outMsgLength: Cardinal; outMsg: PByte); cdecl;
  IAttachment_createBlobPtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; cdecl;
  IAttachment_openBlobPtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; cdecl;
  IAttachment_getSlicePtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte): Integer; cdecl;
  IAttachment_putSlicePtr = procedure(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte); cdecl;
  IAttachment_executeDynPtr = procedure(this: IAttachment; status: IStatus; transaction: ITransaction; length: Cardinal; dyn: PByte); cdecl;
  IAttachment_preparePtr = function(this: IAttachment; status: IStatus; tra: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; flags: Cardinal): IStatement; cdecl;
  IAttachment_executePtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; cdecl;
  IAttachment_openCursorPtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; cursorName: PAnsiChar; cursorFlags: Cardinal): IResultSet; cdecl;
  IAttachment_queEventsPtr = function(this: IAttachment; status: IStatus; callback: IEventCallback; length: Cardinal; events: PByte): IEvents; cdecl;
  IAttachment_cancelOperationPtr = procedure(this: IAttachment; status: IStatus; option: Integer); cdecl;
  IAttachment_pingPtr = procedure(this: IAttachment; status: IStatus); cdecl;
  IAttachment_detachPtr = procedure(this: IAttachment; status: IStatus); cdecl;
  IAttachment_dropDatabasePtr = procedure(this: IAttachment; status: IStatus); cdecl;
  IAttachment_getIdleTimeoutPtr = function(this: IAttachment; status: IStatus): Cardinal; cdecl;
  IAttachment_setIdleTimeoutPtr = procedure(this: IAttachment; status: IStatus; timeOut: Cardinal); cdecl;
  IAttachment_getStatementTimeoutPtr = function(this: IAttachment; status: IStatus): Cardinal; cdecl;
  IAttachment_setStatementTimeoutPtr = procedure(this: IAttachment; status: IStatus; timeOut: Cardinal); cdecl;
  IAttachment_createBatchPtr = function(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; cdecl;
  IAttachment_createReplicatorPtr = function(this: IAttachment; status: IStatus): IReplicator; cdecl;
  IService_detachPtr = procedure(this: IService; status: IStatus); cdecl;
  IService_queryPtr = procedure(this: IService; status: IStatus; sendLength: Cardinal; sendItems: PByte; receiveLength: Cardinal; receiveItems: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
  IService_startPtr = procedure(this: IService; status: IStatus; spbLength: Cardinal; spb: PByte); cdecl;
  IProvider_attachDatabasePtr = function(this: IProvider; status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; cdecl;
  IProvider_createDatabasePtr = function(this: IProvider; status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; cdecl;
  IProvider_attachServiceManagerPtr = function(this: IProvider; status: IStatus; service: PAnsiChar; spbLength: Cardinal; spb: PByte): IService; cdecl;
  IProvider_shutdownPtr = procedure(this: IProvider; status: IStatus; timeout: Cardinal; reason: Integer); cdecl;
  IProvider_setDbCryptCallbackPtr = procedure(this: IProvider; status: IStatus; cryptCallback: ICryptKeyCallback); cdecl;
  IDtcStart_addAttachmentPtr = procedure(this: IDtcStart; status: IStatus; att: IAttachment); cdecl;
  IDtcStart_addWithTpbPtr = procedure(this: IDtcStart; status: IStatus; att: IAttachment; length: Cardinal; tpb: PByte); cdecl;
  IDtcStart_startPtr = function(this: IDtcStart; status: IStatus): ITransaction; cdecl;
  IDtc_joinPtr = function(this: IDtc; status: IStatus; one: ITransaction; two: ITransaction): ITransaction; cdecl;
  IDtc_startBuilderPtr = function(this: IDtc; status: IStatus): IDtcStart; cdecl;
  IWriter_resetPtr = procedure(this: IWriter); cdecl;
  IWriter_addPtr = procedure(this: IWriter; status: IStatus; name: PAnsiChar); cdecl;
  IWriter_setTypePtr = procedure(this: IWriter; status: IStatus; value: PAnsiChar); cdecl;
  IWriter_setDbPtr = procedure(this: IWriter; status: IStatus; value: PAnsiChar); cdecl;
  IServerBlock_getLoginPtr = function(this: IServerBlock): PAnsiChar; cdecl;
  IServerBlock_getDataPtr = function(this: IServerBlock; length: PCardinal): PByte; cdecl;
  IServerBlock_putDataPtr = procedure(this: IServerBlock; status: IStatus; length: Cardinal; data: Pointer); cdecl;
  IServerBlock_newKeyPtr = function(this: IServerBlock; status: IStatus): ICryptKey; cdecl;
  IClientBlock_getLoginPtr = function(this: IClientBlock): PAnsiChar; cdecl;
  IClientBlock_getPasswordPtr = function(this: IClientBlock): PAnsiChar; cdecl;
  IClientBlock_getDataPtr = function(this: IClientBlock; length: PCardinal): PByte; cdecl;
  IClientBlock_putDataPtr = procedure(this: IClientBlock; status: IStatus; length: Cardinal; data: Pointer); cdecl;
  IClientBlock_newKeyPtr = function(this: IClientBlock; status: IStatus): ICryptKey; cdecl;
  IClientBlock_getAuthBlockPtr = function(this: IClientBlock; status: IStatus): IAuthBlock; cdecl;
  IServer_authenticatePtr = function(this: IServer; status: IStatus; sBlock: IServerBlock; writerInterface: IWriter): Integer; cdecl;
  IServer_setDbCryptCallbackPtr = procedure(this: IServer; status: IStatus; cryptCallback: ICryptKeyCallback); cdecl;
  IClient_authenticatePtr = function(this: IClient; status: IStatus; cBlock: IClientBlock): Integer; cdecl;
  IUserField_enteredPtr = function(this: IUserField): Integer; cdecl;
  IUserField_specifiedPtr = function(this: IUserField): Integer; cdecl;
  IUserField_setEnteredPtr = procedure(this: IUserField; status: IStatus; newValue: Integer); cdecl;
  ICharUserField_getPtr = function(this: ICharUserField): PAnsiChar; cdecl;
  ICharUserField_set_Ptr = procedure(this: ICharUserField; status: IStatus; newValue: PAnsiChar); cdecl;
  IIntUserField_getPtr = function(this: IIntUserField): Integer; cdecl;
  IIntUserField_set_Ptr = procedure(this: IIntUserField; status: IStatus; newValue: Integer); cdecl;
  IUser_operationPtr = function(this: IUser): Cardinal; cdecl;
  IUser_userNamePtr = function(this: IUser): ICharUserField; cdecl;
  IUser_passwordPtr = function(this: IUser): ICharUserField; cdecl;
  IUser_firstNamePtr = function(this: IUser): ICharUserField; cdecl;
  IUser_lastNamePtr = function(this: IUser): ICharUserField; cdecl;
  IUser_middleNamePtr = function(this: IUser): ICharUserField; cdecl;
  IUser_commentPtr = function(this: IUser): ICharUserField; cdecl;
  IUser_attributesPtr = function(this: IUser): ICharUserField; cdecl;
  IUser_activePtr = function(this: IUser): IIntUserField; cdecl;
  IUser_adminPtr = function(this: IUser): IIntUserField; cdecl;
  IUser_clearPtr = procedure(this: IUser; status: IStatus); cdecl;
  IListUsers_listPtr = procedure(this: IListUsers; status: IStatus; user: IUser); cdecl;
  ILogonInfo_namePtr = function(this: ILogonInfo): PAnsiChar; cdecl;
  ILogonInfo_rolePtr = function(this: ILogonInfo): PAnsiChar; cdecl;
  ILogonInfo_networkProtocolPtr = function(this: ILogonInfo): PAnsiChar; cdecl;
  ILogonInfo_remoteAddressPtr = function(this: ILogonInfo): PAnsiChar; cdecl;
  ILogonInfo_authBlockPtr = function(this: ILogonInfo; length: PCardinal): PByte; cdecl;
  ILogonInfo_attachmentPtr = function(this: ILogonInfo; status: IStatus): IAttachment; cdecl;
  ILogonInfo_transactionPtr = function(this: ILogonInfo; status: IStatus): ITransaction; cdecl;
  IManagement_startPtr = procedure(this: IManagement; status: IStatus; logonInfo: ILogonInfo); cdecl;
  IManagement_executePtr = function(this: IManagement; status: IStatus; user: IUser; callback: IListUsers): Integer; cdecl;
  IManagement_commitPtr = procedure(this: IManagement; status: IStatus); cdecl;
  IManagement_rollbackPtr = procedure(this: IManagement; status: IStatus); cdecl;
  IAuthBlock_getTypePtr = function(this: IAuthBlock): PAnsiChar; cdecl;
  IAuthBlock_getNamePtr = function(this: IAuthBlock): PAnsiChar; cdecl;
  IAuthBlock_getPluginPtr = function(this: IAuthBlock): PAnsiChar; cdecl;
  IAuthBlock_getSecurityDbPtr = function(this: IAuthBlock): PAnsiChar; cdecl;
  IAuthBlock_getOriginalPluginPtr = function(this: IAuthBlock): PAnsiChar; cdecl;
  IAuthBlock_nextPtr = function(this: IAuthBlock; status: IStatus): Boolean; cdecl;
  IAuthBlock_firstPtr = function(this: IAuthBlock; status: IStatus): Boolean; cdecl;
  IWireCryptPlugin_getKnownTypesPtr = function(this: IWireCryptPlugin; status: IStatus): PAnsiChar; cdecl;
  IWireCryptPlugin_setKeyPtr = procedure(this: IWireCryptPlugin; status: IStatus; key: ICryptKey); cdecl;
  IWireCryptPlugin_encryptPtr = procedure(this: IWireCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
  IWireCryptPlugin_decryptPtr = procedure(this: IWireCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
  IWireCryptPlugin_getSpecificDataPtr = function(this: IWireCryptPlugin; status: IStatus; keyType: PAnsiChar; length: PCardinal): PByte; cdecl;
  IWireCryptPlugin_setSpecificDataPtr = procedure(this: IWireCryptPlugin; status: IStatus; keyType: PAnsiChar; length: Cardinal; data: PByte); cdecl;
  ICryptKeyCallback_callbackPtr = function(this: ICryptKeyCallback; dataLength: Cardinal; data: Pointer; bufferLength: Cardinal; buffer: Pointer): Cardinal; cdecl;
  IKeyHolderPlugin_keyCallbackPtr = function(this: IKeyHolderPlugin; status: IStatus; callback: ICryptKeyCallback): Integer; cdecl;
  IKeyHolderPlugin_keyHandlePtr = function(this: IKeyHolderPlugin; status: IStatus; keyName: PAnsiChar): ICryptKeyCallback; cdecl;
  IKeyHolderPlugin_useOnlyOwnKeysPtr = function(this: IKeyHolderPlugin; status: IStatus): Boolean; cdecl;
  IKeyHolderPlugin_chainHandlePtr = function(this: IKeyHolderPlugin; status: IStatus): ICryptKeyCallback; cdecl;
  IDbCryptInfo_getDatabaseFullPathPtr = function(this: IDbCryptInfo; status: IStatus): PAnsiChar; cdecl;
  IDbCryptPlugin_setKeyPtr = procedure(this: IDbCryptPlugin; status: IStatus; length: Cardinal; sources: PIKeyHolderPlugin; keyName: PAnsiChar); cdecl;
  IDbCryptPlugin_encryptPtr = procedure(this: IDbCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
  IDbCryptPlugin_decryptPtr = procedure(this: IDbCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
  IDbCryptPlugin_setInfoPtr = procedure(this: IDbCryptPlugin; status: IStatus; info: IDbCryptInfo); cdecl;
  IExternalContext_getMasterPtr = function(this: IExternalContext): IMaster; cdecl;
  IExternalContext_getEnginePtr = function(this: IExternalContext; status: IStatus): IExternalEngine; cdecl;
  IExternalContext_getAttachmentPtr = function(this: IExternalContext; status: IStatus): IAttachment; cdecl;
  IExternalContext_getTransactionPtr = function(this: IExternalContext; status: IStatus): ITransaction; cdecl;
  IExternalContext_getUserNamePtr = function(this: IExternalContext): PAnsiChar; cdecl;
  IExternalContext_getDatabaseNamePtr = function(this: IExternalContext): PAnsiChar; cdecl;
  IExternalContext_getClientCharSetPtr = function(this: IExternalContext): PAnsiChar; cdecl;
  IExternalContext_obtainInfoCodePtr = function(this: IExternalContext): Integer; cdecl;
  IExternalContext_getInfoPtr = function(this: IExternalContext; code: Integer): Pointer; cdecl;
  IExternalContext_setInfoPtr = function(this: IExternalContext; code: Integer; value: Pointer): Pointer; cdecl;
  IExternalResultSet_fetchPtr = function(this: IExternalResultSet; status: IStatus): Boolean; cdecl;
  IExternalFunction_getCharSetPtr = procedure(this: IExternalFunction; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
  IExternalFunction_executePtr = procedure(this: IExternalFunction; status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer); cdecl;
  IExternalProcedure_getCharSetPtr = procedure(this: IExternalProcedure; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
  IExternalProcedure_openPtr = function(this: IExternalProcedure; status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer): IExternalResultSet; cdecl;
  IExternalTrigger_getCharSetPtr = procedure(this: IExternalTrigger; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
  IExternalTrigger_executePtr = procedure(this: IExternalTrigger; status: IStatus; context: IExternalContext; action: Cardinal; oldMsg: Pointer; newMsg: Pointer); cdecl;
  IRoutineMetadata_getPackagePtr = function(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
  IRoutineMetadata_getNamePtr = function(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
  IRoutineMetadata_getEntryPointPtr = function(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
  IRoutineMetadata_getBodyPtr = function(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
  IRoutineMetadata_getInputMetadataPtr = function(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
  IRoutineMetadata_getOutputMetadataPtr = function(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
  IRoutineMetadata_getTriggerMetadataPtr = function(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
  IRoutineMetadata_getTriggerTablePtr = function(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
  IRoutineMetadata_getTriggerTypePtr = function(this: IRoutineMetadata; status: IStatus): Cardinal; cdecl;
  IExternalEngine_openPtr = procedure(this: IExternalEngine; status: IStatus; context: IExternalContext; charSet: PAnsiChar; charSetSize: Cardinal); cdecl;
  IExternalEngine_openAttachmentPtr = procedure(this: IExternalEngine; status: IStatus; context: IExternalContext); cdecl;
  IExternalEngine_closeAttachmentPtr = procedure(this: IExternalEngine; status: IStatus; context: IExternalContext); cdecl;
  IExternalEngine_makeFunctionPtr = function(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalFunction; cdecl;
  IExternalEngine_makeProcedurePtr = function(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalProcedure; cdecl;
  IExternalEngine_makeTriggerPtr = function(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder): IExternalTrigger; cdecl;
  ITimer_handlerPtr = procedure(this: ITimer); cdecl;
  ITimerControl_startPtr = procedure(this: ITimerControl; status: IStatus; timer: ITimer; microSeconds: UInt64); cdecl;
  ITimerControl_stopPtr = procedure(this: ITimerControl; status: IStatus; timer: ITimer); cdecl;
  IVersionCallback_callbackPtr = procedure(this: IVersionCallback; status: IStatus; text: PAnsiChar); cdecl;
  IUtil_getFbVersionPtr = procedure(this: IUtil; status: IStatus; att: IAttachment; callback: IVersionCallback); cdecl;
  IUtil_loadBlobPtr = procedure(this: IUtil; status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); cdecl;
  IUtil_dumpBlobPtr = procedure(this: IUtil; status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); cdecl;
  IUtil_getPerfCountersPtr = procedure(this: IUtil; status: IStatus; att: IAttachment; countersSet: PAnsiChar; counters: PInt64); cdecl;
  IUtil_executeCreateDatabasePtr = function(this: IUtil; status: IStatus; stmtLength: Cardinal; creatDBstatement: PAnsiChar; dialect: Cardinal; stmtIsCreateDb: BooleanPtr): IAttachment; cdecl;
  IUtil_decodeDatePtr = procedure(this: IUtil; date: TISC_DATE; year: PCardinal; month: PCardinal; day: PCardinal); cdecl;
  IUtil_decodeTimePtr = procedure(this: IUtil; time: TISC_TIME; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal); cdecl;
  IUtil_encodeDatePtr = function(this: IUtil; year: Cardinal; month: Cardinal; day: Cardinal): TISC_DATE; cdecl;
  IUtil_encodeTimePtr = function(this: IUtil; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal): TISC_TIME; cdecl;
  IUtil_formatStatusPtr = function(this: IUtil; buffer: PAnsiChar; bufferSize: Cardinal; status: IStatus): Cardinal; cdecl;
  IUtil_getClientVersionPtr = function(this: IUtil): Cardinal; cdecl;
  IUtil_getXpbBuilderPtr = function(this: IUtil; status: IStatus; kind: Cardinal; buf: PByte; len: Cardinal): IXpbBuilder; cdecl;
  IUtil_setOffsetsPtr = function(this: IUtil; status: IStatus; metadata: IMessageMetadata; callback: IOffsetsCallback): Cardinal; cdecl;
  IUtil_getDecFloat16Ptr = function(this: IUtil; status: IStatus): IDecFloat16; cdecl;
  IUtil_getDecFloat34Ptr = function(this: IUtil; status: IStatus): IDecFloat34; cdecl;
  IUtil_decodeTimeTzPtr = procedure(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
  IUtil_decodeTimeStampTzPtr = procedure(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
  IUtil_encodeTimeTzPtr = procedure(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); cdecl;
  IUtil_encodeTimeStampTzPtr = procedure(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: Cardinal; month: Cardinal; day: Cardinal; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); cdecl;
  IUtil_getInt128Ptr = function(this: IUtil; status: IStatus): IInt128; cdecl;
  IUtil_decodeTimeTzExPtr = procedure(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ_EX; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
  IUtil_decodeTimeStampTzExPtr = procedure(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ_EX; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
  IOffsetsCallback_setOffsetPtr = procedure(this: IOffsetsCallback; status: IStatus; index: Cardinal; offset: Cardinal; nullOffset: Cardinal); cdecl;
  IXpbBuilder_clearPtr = procedure(this: IXpbBuilder; status: IStatus); cdecl;
  IXpbBuilder_removeCurrentPtr = procedure(this: IXpbBuilder; status: IStatus); cdecl;
  IXpbBuilder_insertIntPtr = procedure(this: IXpbBuilder; status: IStatus; tag: Byte; value: Integer); cdecl;
  IXpbBuilder_insertBigIntPtr = procedure(this: IXpbBuilder; status: IStatus; tag: Byte; value: Int64); cdecl;
  IXpbBuilder_insertBytesPtr = procedure(this: IXpbBuilder; status: IStatus; tag: Byte; bytes: Pointer; length: Cardinal); cdecl;
  IXpbBuilder_insertStringPtr = procedure(this: IXpbBuilder; status: IStatus; tag: Byte; str: PAnsiChar); cdecl;
  IXpbBuilder_insertTagPtr = procedure(this: IXpbBuilder; status: IStatus; tag: Byte); cdecl;
  IXpbBuilder_isEofPtr = function(this: IXpbBuilder; status: IStatus): Boolean; cdecl;
  IXpbBuilder_moveNextPtr = procedure(this: IXpbBuilder; status: IStatus); cdecl;
  IXpbBuilder_rewindPtr = procedure(this: IXpbBuilder; status: IStatus); cdecl;
  IXpbBuilder_findFirstPtr = function(this: IXpbBuilder; status: IStatus; tag: Byte): Boolean; cdecl;
  IXpbBuilder_findNextPtr = function(this: IXpbBuilder; status: IStatus): Boolean; cdecl;
  IXpbBuilder_getTagPtr = function(this: IXpbBuilder; status: IStatus): Byte; cdecl;
  IXpbBuilder_getLengthPtr = function(this: IXpbBuilder; status: IStatus): Cardinal; cdecl;
  IXpbBuilder_getIntPtr = function(this: IXpbBuilder; status: IStatus): Integer; cdecl;
  IXpbBuilder_getBigIntPtr = function(this: IXpbBuilder; status: IStatus): Int64; cdecl;
  IXpbBuilder_getStringPtr = function(this: IXpbBuilder; status: IStatus): PAnsiChar; cdecl;
  IXpbBuilder_getBytesPtr = function(this: IXpbBuilder; status: IStatus): PByte; cdecl;
  IXpbBuilder_getBufferLengthPtr = function(this: IXpbBuilder; status: IStatus): Cardinal; cdecl;
  IXpbBuilder_getBufferPtr = function(this: IXpbBuilder; status: IStatus): PByte; cdecl;
  ITraceConnection_getKindPtr = function(this: ITraceConnection): Cardinal; cdecl;
  ITraceConnection_getProcessIDPtr = function(this: ITraceConnection): Integer; cdecl;
  ITraceConnection_getUserNamePtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceConnection_getRoleNamePtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceConnection_getCharSetPtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceConnection_getRemoteProtocolPtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceConnection_getRemoteAddressPtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceConnection_getRemoteProcessIDPtr = function(this: ITraceConnection): Integer; cdecl;
  ITraceConnection_getRemoteProcessNamePtr = function(this: ITraceConnection): PAnsiChar; cdecl;
  ITraceDatabaseConnection_getConnectionIDPtr = function(this: ITraceDatabaseConnection): Int64; cdecl;
  ITraceDatabaseConnection_getDatabaseNamePtr = function(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
  ITraceTransaction_getTransactionIDPtr = function(this: ITraceTransaction): Int64; cdecl;
  ITraceTransaction_getReadOnlyPtr = function(this: ITraceTransaction): Boolean; cdecl;
  ITraceTransaction_getWaitPtr = function(this: ITraceTransaction): Integer; cdecl;
  ITraceTransaction_getIsolationPtr = function(this: ITraceTransaction): Cardinal; cdecl;
  ITraceTransaction_getPerfPtr = function(this: ITraceTransaction): PPerformanceInfo; cdecl;
  ITraceTransaction_getInitialIDPtr = function(this: ITraceTransaction): Int64; cdecl;
  ITraceTransaction_getPreviousIDPtr = function(this: ITraceTransaction): Int64; cdecl;
  ITraceParams_getCountPtr = function(this: ITraceParams): Cardinal; cdecl;
  ITraceParams_getParamPtr = function(this: ITraceParams; idx: Cardinal): Pdsc; cdecl;
  ITraceParams_getTextUTF8Ptr = function(this: ITraceParams; status: IStatus; idx: Cardinal): PAnsiChar; cdecl;
  ITraceStatement_getStmtIDPtr = function(this: ITraceStatement): Int64; cdecl;
  ITraceStatement_getPerfPtr = function(this: ITraceStatement): PPerformanceInfo; cdecl;
  ITraceSQLStatement_getTextPtr = function(this: ITraceSQLStatement): PAnsiChar; cdecl;
  ITraceSQLStatement_getPlanPtr = function(this: ITraceSQLStatement): PAnsiChar; cdecl;
  ITraceSQLStatement_getInputsPtr = function(this: ITraceSQLStatement): ITraceParams; cdecl;
  ITraceSQLStatement_getTextUTF8Ptr = function(this: ITraceSQLStatement): PAnsiChar; cdecl;
  ITraceSQLStatement_getExplainedPlanPtr = function(this: ITraceSQLStatement): PAnsiChar; cdecl;
  ITraceBLRStatement_getDataPtr = function(this: ITraceBLRStatement): PByte; cdecl;
  ITraceBLRStatement_getDataLengthPtr = function(this: ITraceBLRStatement): Cardinal; cdecl;
  ITraceBLRStatement_getTextPtr = function(this: ITraceBLRStatement): PAnsiChar; cdecl;
  ITraceDYNRequest_getDataPtr = function(this: ITraceDYNRequest): PByte; cdecl;
  ITraceDYNRequest_getDataLengthPtr = function(this: ITraceDYNRequest): Cardinal; cdecl;
  ITraceDYNRequest_getTextPtr = function(this: ITraceDYNRequest): PAnsiChar; cdecl;
  ITraceContextVariable_getNameSpacePtr = function(this: ITraceContextVariable): PAnsiChar; cdecl;
  ITraceContextVariable_getVarNamePtr = function(this: ITraceContextVariable): PAnsiChar; cdecl;
  ITraceContextVariable_getVarValuePtr = function(this: ITraceContextVariable): PAnsiChar; cdecl;
  ITraceProcedure_getProcNamePtr = function(this: ITraceProcedure): PAnsiChar; cdecl;
  ITraceProcedure_getInputsPtr = function(this: ITraceProcedure): ITraceParams; cdecl;
  ITraceProcedure_getPerfPtr = function(this: ITraceProcedure): PPerformanceInfo; cdecl;
  ITraceFunction_getFuncNamePtr = function(this: ITraceFunction): PAnsiChar; cdecl;
  ITraceFunction_getInputsPtr = function(this: ITraceFunction): ITraceParams; cdecl;
  ITraceFunction_getResultPtr = function(this: ITraceFunction): ITraceParams; cdecl;
  ITraceFunction_getPerfPtr = function(this: ITraceFunction): PPerformanceInfo; cdecl;
  ITraceTrigger_getTriggerNamePtr = function(this: ITraceTrigger): PAnsiChar; cdecl;
  ITraceTrigger_getRelationNamePtr = function(this: ITraceTrigger): PAnsiChar; cdecl;
  ITraceTrigger_getActionPtr = function(this: ITraceTrigger): Integer; cdecl;
  ITraceTrigger_getWhichPtr = function(this: ITraceTrigger): Integer; cdecl;
  ITraceTrigger_getPerfPtr = function(this: ITraceTrigger): PPerformanceInfo; cdecl;
  ITraceServiceConnection_getServiceIDPtr = function(this: ITraceServiceConnection): Pointer; cdecl;
  ITraceServiceConnection_getServiceMgrPtr = function(this: ITraceServiceConnection): PAnsiChar; cdecl;
  ITraceServiceConnection_getServiceNamePtr = function(this: ITraceServiceConnection): PAnsiChar; cdecl;
  ITraceStatusVector_hasErrorPtr = function(this: ITraceStatusVector): Boolean; cdecl;
  ITraceStatusVector_hasWarningPtr = function(this: ITraceStatusVector): Boolean; cdecl;
  ITraceStatusVector_getStatusPtr = function(this: ITraceStatusVector): IStatus; cdecl;
  ITraceStatusVector_getTextPtr = function(this: ITraceStatusVector): PAnsiChar; cdecl;
  ITraceSweepInfo_getOITPtr = function(this: ITraceSweepInfo): Int64; cdecl;
  ITraceSweepInfo_getOSTPtr = function(this: ITraceSweepInfo): Int64; cdecl;
  ITraceSweepInfo_getOATPtr = function(this: ITraceSweepInfo): Int64; cdecl;
  ITraceSweepInfo_getNextPtr = function(this: ITraceSweepInfo): Int64; cdecl;
  ITraceSweepInfo_getPerfPtr = function(this: ITraceSweepInfo): PPerformanceInfo; cdecl;
  ITraceLogWriter_writePtr = function(this: ITraceLogWriter; buf: Pointer; size: Cardinal): Cardinal; cdecl;
  ITraceLogWriter_write_sPtr = function(this: ITraceLogWriter; status: IStatus; buf: Pointer; size: Cardinal): Cardinal; cdecl;
  ITraceInitInfo_getConfigTextPtr = function(this: ITraceInitInfo): PAnsiChar; cdecl;
  ITraceInitInfo_getTraceSessionIDPtr = function(this: ITraceInitInfo): Integer; cdecl;
  ITraceInitInfo_getTraceSessionNamePtr = function(this: ITraceInitInfo): PAnsiChar; cdecl;
  ITraceInitInfo_getFirebirdRootDirectoryPtr = function(this: ITraceInitInfo): PAnsiChar; cdecl;
  ITraceInitInfo_getDatabaseNamePtr = function(this: ITraceInitInfo): PAnsiChar; cdecl;
  ITraceInitInfo_getConnectionPtr = function(this: ITraceInitInfo): ITraceDatabaseConnection; cdecl;
  ITraceInitInfo_getLogWriterPtr = function(this: ITraceInitInfo): ITraceLogWriter; cdecl;
  ITracePlugin_trace_get_errorPtr = function(this: ITracePlugin): PAnsiChar; cdecl;
  ITracePlugin_trace_attachPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; create_db: Boolean; att_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_detachPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; drop_db: Boolean): Boolean; cdecl;
  ITracePlugin_trace_transaction_startPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; tpb_length: Cardinal; tpb: PByte; tra_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_transaction_endPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; commit: Boolean; retain_context: Boolean; tra_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_proc_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; procedure_: ITraceProcedure; started: Boolean; proc_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_trigger_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; trigger: ITraceTrigger; started: Boolean; trig_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_set_contextPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; variable: ITraceContextVariable): Boolean; cdecl;
  ITracePlugin_trace_dsql_preparePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_dsql_freePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; statement: ITraceSQLStatement; option: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_dsql_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; started: Boolean; req_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_blr_compilePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_blr_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; req_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_dyn_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; request: ITraceDYNRequest; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_service_attachPtr = function(this: ITracePlugin; service: ITraceServiceConnection; att_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_service_startPtr = function(this: ITracePlugin; service: ITraceServiceConnection; switches_length: Cardinal; switches: PAnsiChar; start_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_service_queryPtr = function(this: ITracePlugin; service: ITraceServiceConnection; send_item_length: Cardinal; send_items: PByte; recv_item_length: Cardinal; recv_items: PByte; query_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_service_detachPtr = function(this: ITracePlugin; service: ITraceServiceConnection; detach_result: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_event_errorPtr = function(this: ITracePlugin; connection: ITraceConnection; status: ITraceStatusVector; function_: PAnsiChar): Boolean; cdecl;
  ITracePlugin_trace_event_sweepPtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; sweep: ITraceSweepInfo; sweep_state: Cardinal): Boolean; cdecl;
  ITracePlugin_trace_func_executePtr = function(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; function_: ITraceFunction; started: Boolean; func_result: Cardinal): Boolean; cdecl;
  ITraceFactory_trace_needsPtr = function(this: ITraceFactory): UInt64; cdecl;
  ITraceFactory_trace_createPtr = function(this: ITraceFactory; status: IStatus; init_info: ITraceInitInfo): ITracePlugin; cdecl;
  IUdrFunctionFactory_setupPtr = procedure(this: IUdrFunctionFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); cdecl;
  IUdrFunctionFactory_newItemPtr = function(this: IUdrFunctionFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalFunction; cdecl;
  IUdrProcedureFactory_setupPtr = procedure(this: IUdrProcedureFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); cdecl;
  IUdrProcedureFactory_newItemPtr = function(this: IUdrProcedureFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalProcedure; cdecl;
  IUdrTriggerFactory_setupPtr = procedure(this: IUdrTriggerFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder); cdecl;
  IUdrTriggerFactory_newItemPtr = function(this: IUdrTriggerFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalTrigger; cdecl;
  IUdrPlugin_getMasterPtr = function(this: IUdrPlugin): IMaster; cdecl;
  IUdrPlugin_registerFunctionPtr = procedure(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrFunctionFactory); cdecl;
  IUdrPlugin_registerProcedurePtr = procedure(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrProcedureFactory); cdecl;
  IUdrPlugin_registerTriggerPtr = procedure(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrTriggerFactory); cdecl;
  IDecFloat16_toBcdPtr = procedure(this: IDecFloat16; from: PFB_DEC16; sign: PInteger; bcd: PByte; exp: PInteger); cdecl;
  IDecFloat16_toStringPtr = procedure(this: IDecFloat16; status: IStatus; from: PFB_DEC16; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
  IDecFloat16_fromBcdPtr = procedure(this: IDecFloat16; sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC16); cdecl;
  IDecFloat16_fromStringPtr = procedure(this: IDecFloat16; status: IStatus; from: PAnsiChar; to_: PFB_DEC16); cdecl;
  IDecFloat34_toBcdPtr = procedure(this: IDecFloat34; from: PFB_DEC34; sign: PInteger; bcd: PByte; exp: PInteger); cdecl;
  IDecFloat34_toStringPtr = procedure(this: IDecFloat34; status: IStatus; from: PFB_DEC34; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
  IDecFloat34_fromBcdPtr = procedure(this: IDecFloat34; sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC34); cdecl;
  IDecFloat34_fromStringPtr = procedure(this: IDecFloat34; status: IStatus; from: PAnsiChar; to_: PFB_DEC34); cdecl;
  IInt128_toStringPtr = procedure(this: IInt128; status: IStatus; from: PFB_I128; scale: Integer; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
  IInt128_fromStringPtr = procedure(this: IInt128; status: IStatus; scale: Integer; from: PAnsiChar; to_: PFB_I128); cdecl;
  IReplicatedField_getNamePtr = function(this: IReplicatedField): PAnsiChar; cdecl;
  IReplicatedField_getTypePtr = function(this: IReplicatedField): Cardinal; cdecl;
  IReplicatedField_getSubTypePtr = function(this: IReplicatedField): Integer; cdecl;
  IReplicatedField_getScalePtr = function(this: IReplicatedField): Integer; cdecl;
  IReplicatedField_getLengthPtr = function(this: IReplicatedField): Cardinal; cdecl;
  IReplicatedField_getCharSetPtr = function(this: IReplicatedField): Cardinal; cdecl;
  IReplicatedField_getDataPtr = function(this: IReplicatedField): Pointer; cdecl;
  IReplicatedRecord_getCountPtr = function(this: IReplicatedRecord): Cardinal; cdecl;
  IReplicatedRecord_getFieldPtr = function(this: IReplicatedRecord; index: Cardinal): IReplicatedField; cdecl;
  IReplicatedRecord_getRawLengthPtr = function(this: IReplicatedRecord): Cardinal; cdecl;
  IReplicatedRecord_getRawDataPtr = function(this: IReplicatedRecord): PByte; cdecl;
  IReplicatedTransaction_preparePtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_commitPtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_rollbackPtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_startSavepointPtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_releaseSavepointPtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_rollbackSavepointPtr = procedure(this: IReplicatedTransaction; status: IStatus); cdecl;
  IReplicatedTransaction_insertRecordPtr = procedure(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); cdecl;
  IReplicatedTransaction_updateRecordPtr = procedure(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; orgRecord: IReplicatedRecord; newRecord: IReplicatedRecord); cdecl;
  IReplicatedTransaction_deleteRecordPtr = procedure(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); cdecl;
  IReplicatedTransaction_executeSqlPtr = procedure(this: IReplicatedTransaction; status: IStatus; sql: PAnsiChar); cdecl;
  IReplicatedTransaction_executeSqlIntlPtr = procedure(this: IReplicatedTransaction; status: IStatus; charset: Cardinal; sql: PAnsiChar); cdecl;
  IReplicatedSession_setAttachmentPtr = procedure(this: IReplicatedSession; attachment: IAttachment); cdecl;
  IReplicatedSession_startTransactionPtr = function(this: IReplicatedSession; status: IStatus; transaction: ITransaction; number: Int64): IReplicatedTransaction; cdecl;
  IReplicatedSession_cleanupTransactionPtr = procedure(this: IReplicatedSession; status: IStatus; number: Int64); cdecl;
  IReplicatedSession_setSequencePtr = procedure(this: IReplicatedSession; status: IStatus; name: PAnsiChar; value: Int64); cdecl;

  VersionedVTable = class
  public
    version: NativeInt;
  end;

  IVersioned = class
  public
    vTable: VersionedVTable;
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 1;
    {$ENDIF WITH_CLASS_CONST}
  end;

  IVersionedImpl = class(IVersioned)
  public
    constructor create;
  end;

  ReferenceCountedVTable = class(VersionedVTable)
  protected
    addRef: IReferenceCounted_addRefPtr;
    release: IReferenceCounted_releasePtr;
  end;

  IReferenceCounted = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}

    procedure addRef();
    function release(): Integer;
  end;

  IReferenceCountedImpl = class(IReferenceCounted)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
  end;

  DisposableVTable = class(VersionedVTable)
  protected
    dispose: IDisposable_disposePtr;
  end;

  IDisposable = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure dispose();
  end;

  IDisposableImpl = class(IDisposable)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
  end;

  StatusVTable = class(DisposableVTable)
  protected
    init: IStatus_initPtr;
    getState: IStatus_getStatePtr;
    setErrors2: IStatus_setErrors2Ptr;
    setWarnings2: IStatus_setWarnings2Ptr;
    setErrors: IStatus_setErrorsPtr;
    setWarnings: IStatus_setWarningsPtr;
    getErrors: IStatus_getErrorsPtr;
    getWarnings: IStatus_getWarningsPtr;
    clone: IStatus_clonePtr;
  end;

  IStatus = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const STATE_WARNINGS = Cardinal($1);
    const STATE_ERRORS = Cardinal($2);
    const RESULT_ERROR = Integer(-1);
    const RESULT_OK = Integer(0);
    const RESULT_NO_DATA = Integer(1);
    const RESULT_SEGMENT = Integer(2);
    {$ENDIF WITH_CLASS_CONST}
    procedure init();
    function getState(): Cardinal;
    procedure setErrors2(length: Cardinal; value: PNativeInt);
    procedure setWarnings2(length: Cardinal; value: PNativeInt);
    procedure setErrors(value: PNativeInt);
    procedure setWarnings(value: PNativeInt);
    function getErrors(): PNativeInt;
    function getWarnings(): PNativeInt;
    function clone(): IStatus;
  end;

  IStatusImpl = class(IStatus)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure init(); virtual; abstract;
    function getState(): Cardinal; virtual; abstract;
    procedure setErrors2(length: Cardinal; value: PNativeInt); virtual; abstract;
    procedure setWarnings2(length: Cardinal; value: PNativeInt); virtual; abstract;
    procedure setErrors(value: PNativeInt); virtual; abstract;
    procedure setWarnings(value: PNativeInt); virtual; abstract;
    function getErrors(): PNativeInt; virtual; abstract;
    function getWarnings(): PNativeInt; virtual; abstract;
    function clone(): IStatus; virtual; abstract;
  end;

  MasterVTable = class(VersionedVTable)
  protected
    getStatus: IMaster_getStatusPtr;
    getDispatcher: IMaster_getDispatcherPtr;
    getPluginManager: IMaster_getPluginManagerPtr;
    getTimerControl: IMaster_getTimerControlPtr;
    getDtc: IMaster_getDtcPtr;
    registerAttachment: IMaster_registerAttachmentPtr;
    registerTransaction: IMaster_registerTransactionPtr;
    getMetadataBuilder: IMaster_getMetadataBuilderPtr;
    serverMode: IMaster_serverModePtr;
    getUtilInterface: IMaster_getUtilInterfacePtr;
    getConfigManager: IMaster_getConfigManagerPtr;
    getProcessExiting: IMaster_getProcessExitingPtr;
  end;

  IMaster = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getStatus(): IStatus;
    function getDispatcher(): IProvider;
    function getPluginManager(): IPluginManager;
    function getTimerControl(): ITimerControl;
    function getDtc(): IDtc;
    function registerAttachment(provider: IProvider; attachment: IAttachment): IAttachment;
    function registerTransaction(attachment: IAttachment; transaction: ITransaction): ITransaction;
    function getMetadataBuilder(status: IStatus; fieldCount: Cardinal): IMetadataBuilder;
    function serverMode(mode: Integer): Integer;
    function getUtilInterface(): IUtil;
    function getConfigManager(): IConfigManager;
    function getProcessExiting(): Boolean;
  end;

  IMasterImpl = class(IMaster)
  public
    constructor create;
  protected
    function getStatus(): IStatus; virtual; abstract;
    function getDispatcher(): IProvider; virtual; abstract;
    function getPluginManager(): IPluginManager; virtual; abstract;
    function getTimerControl(): ITimerControl; virtual; abstract;
    function getDtc(): IDtc; virtual; abstract;
    function registerAttachment(provider: IProvider; attachment: IAttachment): IAttachment; virtual; abstract;
    function registerTransaction(attachment: IAttachment; transaction: ITransaction): ITransaction; virtual; abstract;
    function getMetadataBuilder(status: IStatus; fieldCount: Cardinal): IMetadataBuilder; virtual; abstract;
    function serverMode(mode: Integer): Integer; virtual; abstract;
    function getUtilInterface(): IUtil; virtual; abstract;
    function getConfigManager(): IConfigManager; virtual; abstract;
    function getProcessExiting(): Boolean; virtual; abstract;
  end;

  PluginBaseVTable = class(ReferenceCountedVTable)
  protected
    setOwner: IPluginBase_setOwnerPtr;
    getOwner: IPluginBase_getOwnerPtr;
  end;

  IPluginBase = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure setOwner(r: IReferenceCounted);
    function getOwner(): IReferenceCounted;
  end;

  IPluginBaseImpl = class(IPluginBase)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
  end;

  PluginSetVTable = class(ReferenceCountedVTable)
  protected
    getName: IPluginSet_getNamePtr;
    getModuleName: IPluginSet_getModuleNamePtr;
    getPlugin: IPluginSet_getPluginPtr;
    next: IPluginSet_nextPtr;
    set_: IPluginSet_set_Ptr;
  end;

  IPluginSet = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getName(): PAnsiChar;
    function getModuleName(): PAnsiChar;
    function getPlugin(status: IStatus): IPluginBase;
    procedure next(status: IStatus);
    procedure set_(status: IStatus; s: PAnsiChar);
  end;

  IPluginSetImpl = class(IPluginSet)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getName(): PAnsiChar; virtual; abstract;
    function getModuleName(): PAnsiChar; virtual; abstract;
    function getPlugin(status: IStatus): IPluginBase; virtual; abstract;
    procedure next(status: IStatus); virtual; abstract;
    procedure set_(status: IStatus; s: PAnsiChar); virtual; abstract;
  end;

  ConfigEntryVTable = class(ReferenceCountedVTable)
  protected
    getName: IConfigEntry_getNamePtr;
    getValue: IConfigEntry_getValuePtr;
    getIntValue: IConfigEntry_getIntValuePtr;
    getBoolValue: IConfigEntry_getBoolValuePtr;
    getSubConfig: IConfigEntry_getSubConfigPtr;
  end;

  IConfigEntry = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getName(): PAnsiChar;
    function getValue(): PAnsiChar;
    function getIntValue(): Int64;
    function getBoolValue(): Boolean;
    function getSubConfig(status: IStatus): IConfig;
  end;

  IConfigEntryImpl = class(IConfigEntry)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getName(): PAnsiChar; virtual; abstract;
    function getValue(): PAnsiChar; virtual; abstract;
    function getIntValue(): Int64; virtual; abstract;
    function getBoolValue(): Boolean; virtual; abstract;
    function getSubConfig(status: IStatus): IConfig; virtual; abstract;
  end;

  ConfigVTable = class(ReferenceCountedVTable)
  protected
    find: IConfig_findPtr;
    findValue: IConfig_findValuePtr;
    findPos: IConfig_findPosPtr;
  end;

  IConfig = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function find(status: IStatus; name: PAnsiChar): IConfigEntry;
    function findValue(status: IStatus; name: PAnsiChar; value: PAnsiChar): IConfigEntry;
    function findPos(status: IStatus; name: PAnsiChar; pos: Cardinal): IConfigEntry;
  end;

  IConfigImpl = class(IConfig)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function find(status: IStatus; name: PAnsiChar): IConfigEntry; virtual; abstract;
    function findValue(status: IStatus; name: PAnsiChar; value: PAnsiChar): IConfigEntry; virtual; abstract;
    function findPos(status: IStatus; name: PAnsiChar; pos: Cardinal): IConfigEntry; virtual; abstract;
  end;

  FirebirdConfVTable = class(ReferenceCountedVTable)
  protected
    getKey: IFirebirdConf_getKeyPtr;
    asInteger: IFirebirdConf_asIntegerPtr;
    asString: IFirebirdConf_asStringPtr;
    asBoolean: IFirebirdConf_asBooleanPtr;
    getVersion: IFirebirdConf_getVersionPtr;
  end;

  IFirebirdConf = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    function getKey(name: PAnsiChar): Cardinal;
    function asInteger(key: Cardinal): Int64;
    function asString(key: Cardinal): PAnsiChar;
    function asBoolean(key: Cardinal): Boolean;
    function getVersion(status: IStatus): Cardinal;
  end;

  IFirebirdConfImpl = class(IFirebirdConf)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getKey(name: PAnsiChar): Cardinal; virtual; abstract;
    function asInteger(key: Cardinal): Int64; virtual; abstract;
    function asString(key: Cardinal): PAnsiChar; virtual; abstract;
    function asBoolean(key: Cardinal): Boolean; virtual; abstract;
    function getVersion(status: IStatus): Cardinal; virtual; abstract;
  end;

  PluginConfigVTable = class(ReferenceCountedVTable)
  protected
    getConfigFileName: IPluginConfig_getConfigFileNamePtr;
    getDefaultConfig: IPluginConfig_getDefaultConfigPtr;
    getFirebirdConf: IPluginConfig_getFirebirdConfPtr;
    setReleaseDelay: IPluginConfig_setReleaseDelayPtr;
  end;

  IPluginConfig = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getConfigFileName(): PAnsiChar;
    function getDefaultConfig(status: IStatus): IConfig;
    function getFirebirdConf(status: IStatus): IFirebirdConf;
    procedure setReleaseDelay(status: IStatus; microSeconds: UInt64);
  end;

  IPluginConfigImpl = class(IPluginConfig)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getConfigFileName(): PAnsiChar; virtual; abstract;
    function getDefaultConfig(status: IStatus): IConfig; virtual; abstract;
    function getFirebirdConf(status: IStatus): IFirebirdConf; virtual; abstract;
    procedure setReleaseDelay(status: IStatus; microSeconds: UInt64); virtual; abstract;
  end;

  PluginFactoryVTable = class(VersionedVTable)
  protected
    createPlugin: IPluginFactory_createPluginPtr;
  end;

  IPluginFactory = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function createPlugin(status: IStatus; factoryParameter: IPluginConfig): IPluginBase;
  end;

  IPluginFactoryImpl = class(IPluginFactory)
  public
    constructor create;
  protected
    function createPlugin(status: IStatus; factoryParameter: IPluginConfig): IPluginBase; virtual; abstract;
  end;

  PluginModuleVTable = class(VersionedVTable)
  protected
    doClean: IPluginModule_doCleanPtr;
    threadDetach: IPluginModule_threadDetachPtr;{FB4}
  end;

  IPluginModule = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure doClean();
    procedure threadDetach();{FB4}
  end;

  IPluginModuleImpl = class(IPluginModule)
  public
    constructor create;
  protected
    procedure doClean(); virtual; abstract;
    procedure threadDetach(); virtual; abstract;
  end;

  PluginManagerVTable = class(VersionedVTable)
  protected
    registerPluginFactory: IPluginManager_registerPluginFactoryPtr;
    registerModule: IPluginManager_registerModulePtr;
    unregisterModule: IPluginManager_unregisterModulePtr;
    getPlugins: IPluginManager_getPluginsPtr;
    getConfig: IPluginManager_getConfigPtr;
    releasePlugin: IPluginManager_releasePluginPtr;
  end;

  IPluginManager = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const TYPE_PROVIDER = Cardinal(1);
    const TYPE_FIRST_NON_LIB = Cardinal(2);
    const TYPE_AUTH_SERVER = Cardinal(3);
    const TYPE_AUTH_CLIENT = Cardinal(4);
    const TYPE_AUTH_USER_MANAGEMENT = Cardinal(5);
    const TYPE_EXTERNAL_ENGINE = Cardinal(6);
    const TYPE_TRACE = Cardinal(7);
    const TYPE_WIRE_CRYPT = Cardinal(8);
    const TYPE_DB_CRYPT = Cardinal(9);
    const TYPE_KEY_HOLDER = Cardinal(10);
    const TYPE_REPLICATOR = Cardinal(11);
    const TYPE_COUNT = Cardinal(12);
    {$ENDIF WITH_CLASS_CONST}
    procedure registerPluginFactory(pluginType: Cardinal; defaultName: PAnsiChar; factory: IPluginFactory);
    procedure registerModule(cleanup: IPluginModule);
    procedure unregisterModule(cleanup: IPluginModule);
    function getPlugins(status: IStatus; pluginType: Cardinal; namesList: PAnsiChar; firebirdConf: IFirebirdConf): IPluginSet;
    function getConfig(status: IStatus; filename: PAnsiChar): IConfig;
    procedure releasePlugin(plugin: IPluginBase);
  end;

  IPluginManagerImpl = class(IPluginManager)
  public
    constructor create;
  protected
    procedure registerPluginFactory(pluginType: Cardinal; defaultName: PAnsiChar; factory: IPluginFactory); virtual; abstract;
    procedure registerModule(cleanup: IPluginModule); virtual; abstract;
    procedure unregisterModule(cleanup: IPluginModule); virtual; abstract;
    function getPlugins(status: IStatus; pluginType: Cardinal; namesList: PAnsiChar; firebirdConf: IFirebirdConf): IPluginSet; virtual; abstract;
    function getConfig(status: IStatus; filename: PAnsiChar): IConfig; virtual; abstract;
    procedure releasePlugin(plugin: IPluginBase); virtual; abstract;
  end;

  CryptKeyVTable = class(VersionedVTable)
  protected
    setSymmetric: ICryptKey_setSymmetricPtr;
    setAsymmetric: ICryptKey_setAsymmetricPtr;
    getEncryptKey: ICryptKey_getEncryptKeyPtr;
    getDecryptKey: ICryptKey_getDecryptKeyPtr;
  end;

  ICryptKey = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure setSymmetric(status: IStatus; type_: PAnsiChar; keyLength: Cardinal; key: Pointer);
    procedure setAsymmetric(status: IStatus; type_: PAnsiChar; encryptKeyLength: Cardinal; encryptKey: Pointer; decryptKeyLength: Cardinal; decryptKey: Pointer);
    function getEncryptKey(length: PCardinal): Pointer;
    function getDecryptKey(length: PCardinal): Pointer;
  end;

  ICryptKeyImpl = class(ICryptKey)
  public
    constructor create;
  protected
    procedure setSymmetric(status: IStatus; type_: PAnsiChar; keyLength: Cardinal; key: Pointer); virtual; abstract;
    procedure setAsymmetric(status: IStatus; type_: PAnsiChar; encryptKeyLength: Cardinal; encryptKey: Pointer; decryptKeyLength: Cardinal; decryptKey: Pointer); virtual; abstract;
    function getEncryptKey(length: PCardinal): Pointer; virtual; abstract;
    function getDecryptKey(length: PCardinal): Pointer; virtual; abstract;
  end;

  ConfigManagerVTable = class(VersionedVTable)
  protected
    getDirectory: IConfigManager_getDirectoryPtr;
    getFirebirdConf: IConfigManager_getFirebirdConfPtr;
    getDatabaseConf: IConfigManager_getDatabaseConfPtr;
    getPluginConfig: IConfigManager_getPluginConfigPtr;
    getInstallDirectory: IConfigManager_getInstallDirectoryPtr;
    getRootDirectory: IConfigManager_getRootDirectoryPtr;
    getDefaultSecurityDb: IConfigManager_getDefaultSecurityDbPtr;
  end;

  IConfigManager = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const DIR_BIN = Cardinal(0);
    const DIR_SBIN = Cardinal(1);
    const DIR_CONF = Cardinal(2);
    const DIR_LIB = Cardinal(3);
    const DIR_INC = Cardinal(4);
    const DIR_DOC = Cardinal(5);
    const DIR_UDF = Cardinal(6);
    const DIR_SAMPLE = Cardinal(7);
    const DIR_SAMPLEDB = Cardinal(8);
    const DIR_HELP = Cardinal(9);
    const DIR_INTL = Cardinal(10);
    const DIR_MISC = Cardinal(11);
    const DIR_SECDB = Cardinal(12);
    const DIR_MSG = Cardinal(13);
    const DIR_LOG = Cardinal(14);
    const DIR_GUARD = Cardinal(15);
    const DIR_PLUGINS = Cardinal(16);
    const DIR_TZDATA = Cardinal(17);
    const DIR_COUNT = Cardinal(18);
    {$ENDIF WITH_CLASS_CONST}
    function getDirectory(code: Cardinal): PAnsiChar;
    function getFirebirdConf(): IFirebirdConf;
    function getDatabaseConf(dbName: PAnsiChar): IFirebirdConf;
    function getPluginConfig(configuredPlugin: PAnsiChar): IConfig;
    function getInstallDirectory(): PAnsiChar;
    function getRootDirectory(): PAnsiChar;
    function getDefaultSecurityDb(): PAnsiChar;
  end;

  IConfigManagerImpl = class(IConfigManager)
  public
    constructor create;
  protected
    function getDirectory(code: Cardinal): PAnsiChar; virtual; abstract;
    function getFirebirdConf(): IFirebirdConf; virtual; abstract;
    function getDatabaseConf(dbName: PAnsiChar): IFirebirdConf; virtual; abstract;
    function getPluginConfig(configuredPlugin: PAnsiChar): IConfig; virtual; abstract;
    function getInstallDirectory(): PAnsiChar; virtual; abstract;
    function getRootDirectory(): PAnsiChar; virtual; abstract;
    function getDefaultSecurityDb(): PAnsiChar; virtual; abstract;
  end;

  EventCallbackVTable = class(ReferenceCountedVTable)
  protected
    eventCallbackFunction: IEventCallback_eventCallbackFunctionPtr;
  end;

  IEventCallback = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure eventCallbackFunction(length: Cardinal; events: PByte);
  end;

  IEventCallbackImpl = class(IEventCallback)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure eventCallbackFunction(length: Cardinal; events: PByte); virtual; abstract;
  end;

  BlobVTable = class(ReferenceCountedVTable)
  protected
    getInfo: IBlob_getInfoPtr;
    getSegment: IBlob_getSegmentPtr;
    putSegment: IBlob_putSegmentPtr;
    cancel: IBlob_cancelPtr;
    close: IBlob_closePtr;
    seek: IBlob_seekPtr;
  end;

  IBlob = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
    function getSegment(status: IStatus; bufferLength: Cardinal; buffer: Pointer; segmentLength: PCardinal): Integer;
    procedure putSegment(status: IStatus; length: Cardinal; buffer: Pointer);
    procedure cancel(status: IStatus);
    procedure close(status: IStatus);
    function seek(status: IStatus; mode: Integer; offset: Integer): Integer;
  end;

  IBlobImpl = class(IBlob)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    function getSegment(status: IStatus; bufferLength: Cardinal; buffer: Pointer; segmentLength: PCardinal): Integer; virtual; abstract;
    procedure putSegment(status: IStatus; length: Cardinal; buffer: Pointer); virtual; abstract;
    procedure cancel(status: IStatus); virtual; abstract;
    procedure close(status: IStatus); virtual; abstract;
    function seek(status: IStatus; mode: Integer; offset: Integer): Integer; virtual; abstract;
  end;

  TransactionVTable = class(ReferenceCountedVTable)
  protected
    getInfo: ITransaction_getInfoPtr;
    prepare: ITransaction_preparePtr;
    commit: ITransaction_commitPtr;
    commitRetaining: ITransaction_commitRetainingPtr;
    rollback: ITransaction_rollbackPtr;
    rollbackRetaining: ITransaction_rollbackRetainingPtr;
    disconnect: ITransaction_disconnectPtr;
    join: ITransaction_joinPtr;
    validate: ITransaction_validatePtr;
    enterDtc: ITransaction_enterDtcPtr;
  end;

  ITransaction = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
    procedure prepare(status: IStatus; msgLength: Cardinal; message: PByte);
    procedure commit(status: IStatus);
    procedure commitRetaining(status: IStatus);
    procedure rollback(status: IStatus);
    procedure rollbackRetaining(status: IStatus);
    procedure disconnect(status: IStatus);
    function join(status: IStatus; transaction: ITransaction): ITransaction;
    function validate(status: IStatus; attachment: IAttachment): ITransaction;
    function enterDtc(status: IStatus): ITransaction;
  end;

  ITransactionImpl = class(ITransaction)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    procedure prepare(status: IStatus; msgLength: Cardinal; message: PByte); virtual; abstract;
    procedure commit(status: IStatus); virtual; abstract;
    procedure commitRetaining(status: IStatus); virtual; abstract;
    procedure rollback(status: IStatus); virtual; abstract;
    procedure rollbackRetaining(status: IStatus); virtual; abstract;
    procedure disconnect(status: IStatus); virtual; abstract;
    function join(status: IStatus; transaction: ITransaction): ITransaction; virtual; abstract;
    function validate(status: IStatus; attachment: IAttachment): ITransaction; virtual; abstract;
    function enterDtc(status: IStatus): ITransaction; virtual; abstract;
  end;

  MessageMetadataVTable = class(ReferenceCountedVTable)
  protected
    getCount: IMessageMetadata_getCountPtr;
    getField: IMessageMetadata_getFieldPtr;
    getRelation: IMessageMetadata_getRelationPtr;
    getOwner: IMessageMetadata_getOwnerPtr;
    getAlias: IMessageMetadata_getAliasPtr;
    getType: IMessageMetadata_getTypePtr;
    isNullable: IMessageMetadata_isNullablePtr;
    getSubType: IMessageMetadata_getSubTypePtr;
    getLength: IMessageMetadata_getLengthPtr;
    getScale: IMessageMetadata_getScalePtr;
    getCharSet: IMessageMetadata_getCharSetPtr;
    getOffset: IMessageMetadata_getOffsetPtr;
    getNullOffset: IMessageMetadata_getNullOffsetPtr;
    getBuilder: IMessageMetadata_getBuilderPtr;
    getMessageLength: IMessageMetadata_getMessageLengthPtr;
    getAlignment: IMessageMetadata_getAlignmentPtr;
    getAlignedLength: IMessageMetadata_getAlignedLengthPtr;
  end;

  IMessageMetadata = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    function getCount(status: IStatus): Cardinal;
    function getField(status: IStatus; index: Cardinal): PAnsiChar;
    function getRelation(status: IStatus; index: Cardinal): PAnsiChar;
    function getOwner(status: IStatus; index: Cardinal): PAnsiChar;
    function getAlias(status: IStatus; index: Cardinal): PAnsiChar;
    function getType(status: IStatus; index: Cardinal): Cardinal;
    function isNullable(status: IStatus; index: Cardinal): Boolean;
    function getSubType(status: IStatus; index: Cardinal): Integer;
    function getLength(status: IStatus; index: Cardinal): Cardinal;
    function getScale(status: IStatus; index: Cardinal): Integer;
    function getCharSet(status: IStatus; index: Cardinal): Cardinal;
    function getOffset(status: IStatus; index: Cardinal): Cardinal;
    function getNullOffset(status: IStatus; index: Cardinal): Cardinal;
    function getBuilder(status: IStatus): IMetadataBuilder;
    function getMessageLength(status: IStatus): Cardinal;
    function getAlignment(status: IStatus): Cardinal;
    function getAlignedLength(status: IStatus): Cardinal;
  end;

  IMessageMetadataImpl = class(IMessageMetadata)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getCount(status: IStatus): Cardinal; virtual; abstract;
    function getField(status: IStatus; index: Cardinal): PAnsiChar; virtual; abstract;
    function getRelation(status: IStatus; index: Cardinal): PAnsiChar; virtual; abstract;
    function getOwner(status: IStatus; index: Cardinal): PAnsiChar; virtual; abstract;
    function getAlias(status: IStatus; index: Cardinal): PAnsiChar; virtual; abstract;
    function getType(status: IStatus; index: Cardinal): Cardinal; virtual; abstract;
    function isNullable(status: IStatus; index: Cardinal): Boolean; virtual; abstract;
    function getSubType(status: IStatus; index: Cardinal): Integer; virtual; abstract;
    function getLength(status: IStatus; index: Cardinal): Cardinal; virtual; abstract;
    function getScale(status: IStatus; index: Cardinal): Integer; virtual; abstract;
    function getCharSet(status: IStatus; index: Cardinal): Cardinal; virtual; abstract;
    function getOffset(status: IStatus; index: Cardinal): Cardinal; virtual; abstract;
    function getNullOffset(status: IStatus; index: Cardinal): Cardinal; virtual; abstract;
    function getBuilder(status: IStatus): IMetadataBuilder; virtual; abstract;
    function getMessageLength(status: IStatus): Cardinal; virtual; abstract;
    function getAlignment(status: IStatus): Cardinal; virtual; abstract;
    function getAlignedLength(status: IStatus): Cardinal; virtual; abstract;
  end;

  MetadataBuilderVTable = class(ReferenceCountedVTable)
  protected
    setType: IMetadataBuilder_setTypePtr;
    setSubType: IMetadataBuilder_setSubTypePtr;
    setLength: IMetadataBuilder_setLengthPtr;
    setCharSet: IMetadataBuilder_setCharSetPtr;
    setScale: IMetadataBuilder_setScalePtr;
    truncate: IMetadataBuilder_truncatePtr;
    moveNameToIndex: IMetadataBuilder_moveNameToIndexPtr;
    remove: IMetadataBuilder_removePtr;
    addField: IMetadataBuilder_addFieldPtr;
    getMetadata: IMetadataBuilder_getMetadataPtr;
    setField: IMetadataBuilder_setFieldPtr;
    setRelation: IMetadataBuilder_setRelationPtr;
    setOwner: IMetadataBuilder_setOwnerPtr;
    setAlias: IMetadataBuilder_setAliasPtr;
  end;

  IMetadataBuilder = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure setType(status: IStatus; index: Cardinal; type_: Cardinal);
    procedure setSubType(status: IStatus; index: Cardinal; subType: Integer);
    procedure setLength(status: IStatus; index: Cardinal; length: Cardinal);
    procedure setCharSet(status: IStatus; index: Cardinal; charSet: Cardinal);
    procedure setScale(status: IStatus; index: Cardinal; scale: Integer);
    procedure truncate(status: IStatus; count: Cardinal);
    procedure moveNameToIndex(status: IStatus; name: PAnsiChar; index: Cardinal);
    procedure remove(status: IStatus; index: Cardinal);
    function addField(status: IStatus): Cardinal;
    function getMetadata(status: IStatus): IMessageMetadata;
    procedure setField(status: IStatus; index: Cardinal; field: PAnsiChar);
    procedure setRelation(status: IStatus; index: Cardinal; relation: PAnsiChar);
    procedure setOwner(status: IStatus; index: Cardinal; owner: PAnsiChar);
    procedure setAlias(status: IStatus; index: Cardinal; alias: PAnsiChar);
  end;

  IMetadataBuilderImpl = class(IMetadataBuilder)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setType(status: IStatus; index: Cardinal; type_: Cardinal); virtual; abstract;
    procedure setSubType(status: IStatus; index: Cardinal; subType: Integer); virtual; abstract;
    procedure setLength(status: IStatus; index: Cardinal; length: Cardinal); virtual; abstract;
    procedure setCharSet(status: IStatus; index: Cardinal; charSet: Cardinal); virtual; abstract;
    procedure setScale(status: IStatus; index: Cardinal; scale: Integer); virtual; abstract;
    procedure truncate(status: IStatus; count: Cardinal); virtual; abstract;
    procedure moveNameToIndex(status: IStatus; name: PAnsiChar; index: Cardinal); virtual; abstract;
    procedure remove(status: IStatus; index: Cardinal); virtual; abstract;
    function addField(status: IStatus): Cardinal; virtual; abstract;
    function getMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    procedure setField(status: IStatus; index: Cardinal; field: PAnsiChar); virtual; abstract;
    procedure setRelation(status: IStatus; index: Cardinal; relation: PAnsiChar); virtual; abstract;
    procedure setOwner(status: IStatus; index: Cardinal; owner: PAnsiChar); virtual; abstract;
    procedure setAlias(status: IStatus; index: Cardinal; alias: PAnsiChar); virtual; abstract;
  end;

  ResultSetVTable = class(ReferenceCountedVTable)
  protected
    fetchNext: IResultSet_fetchNextPtr;
    fetchPrior: IResultSet_fetchPriorPtr;
    fetchFirst: IResultSet_fetchFirstPtr;
    fetchLast: IResultSet_fetchLastPtr;
    fetchAbsolute: IResultSet_fetchAbsolutePtr;
    fetchRelative: IResultSet_fetchRelativePtr;
    isEof: IResultSet_isEofPtr;
    isBof: IResultSet_isBofPtr;
    getMetadata: IResultSet_getMetadataPtr;
    close: IResultSet_closePtr;
    setDelayedOutputFormat: IResultSet_setDelayedOutputFormatPtr;
  end;

  IResultSet = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function fetchNext(status: IStatus; message: Pointer): Integer;
    function fetchPrior(status: IStatus; message: Pointer): Integer;
    function fetchFirst(status: IStatus; message: Pointer): Integer;
    function fetchLast(status: IStatus; message: Pointer): Integer;
    function fetchAbsolute(status: IStatus; position: Integer; message: Pointer): Integer;
    function fetchRelative(status: IStatus; offset: Integer; message: Pointer): Integer;
    function isEof(status: IStatus): Boolean;
    function isBof(status: IStatus): Boolean;
    function getMetadata(status: IStatus): IMessageMetadata;
    procedure close(status: IStatus);
    procedure setDelayedOutputFormat(status: IStatus; format: IMessageMetadata);
  end;

  IResultSetImpl = class(IResultSet)
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function fetchNext(status: IStatus; message: Pointer): Integer; virtual; abstract;
    function fetchPrior(status: IStatus; message: Pointer): Integer; virtual; abstract;
    function fetchFirst(status: IStatus; message: Pointer): Integer; virtual; abstract;
    function fetchLast(status: IStatus; message: Pointer): Integer; virtual; abstract;
    function fetchAbsolute(status: IStatus; position: Integer; message: Pointer): Integer; virtual; abstract;
    function fetchRelative(status: IStatus; offset: Integer; message: Pointer): Integer; virtual; abstract;
    function isEof(status: IStatus): Boolean; virtual; abstract;
    function isBof(status: IStatus): Boolean; virtual; abstract;
    function getMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    procedure close(status: IStatus); virtual; abstract;
    procedure setDelayedOutputFormat(status: IStatus; format: IMessageMetadata); virtual; abstract;
  end;

  StatementVTable = class(ReferenceCountedVTable)
  protected
    getInfo: IStatement_getInfoPtr;
    getType: IStatement_getTypePtr;
    getPlan: IStatement_getPlanPtr;
    getAffectedRecords: IStatement_getAffectedRecordsPtr;
    getInputMetadata: IStatement_getInputMetadataPtr;
    getOutputMetadata: IStatement_getOutputMetadataPtr;
    execute: IStatement_executePtr;
    openCursor: IStatement_openCursorPtr;
    setCursorName: IStatement_setCursorNamePtr;
    free: IStatement_freePtr;
    getFlags: IStatement_getFlagsPtr;
    getTimeout: IStatement_getTimeoutPtr;
    setTimeout: IStatement_setTimeoutPtr;
    createBatch: IStatement_createBatchPtr;
  end;

  IStatement = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    const PREPARE_PREFETCH_NONE = Cardinal($0);
    const PREPARE_PREFETCH_TYPE = Cardinal($1);
    const PREPARE_PREFETCH_INPUT_PARAMETERS = Cardinal($2);
    const PREPARE_PREFETCH_OUTPUT_PARAMETERS = Cardinal($4);
    const PREPARE_PREFETCH_LEGACY_PLAN = Cardinal($8);
    const PREPARE_PREFETCH_DETAILED_PLAN = Cardinal($10);
    const PREPARE_PREFETCH_AFFECTED_RECORDS = Cardinal($20);
    const PREPARE_PREFETCH_FLAGS = Cardinal($40);
    const PREPARE_PREFETCH_METADATA = Cardinal(IStatement.PREPARE_PREFETCH_TYPE or IStatement.PREPARE_PREFETCH_FLAGS or IStatement.PREPARE_PREFETCH_INPUT_PARAMETERS or IStatement.PREPARE_PREFETCH_OUTPUT_PARAMETERS);
    const PREPARE_PREFETCH_ALL = Cardinal(IStatement.PREPARE_PREFETCH_METADATA or IStatement.PREPARE_PREFETCH_LEGACY_PLAN or IStatement.PREPARE_PREFETCH_DETAILED_PLAN or IStatement.PREPARE_PREFETCH_AFFECTED_RECORDS);
    const FLAG_HAS_CURSOR = Cardinal($1);
    const FLAG_REPEAT_EXECUTE = Cardinal($2);
    const CURSOR_TYPE_SCROLLABLE = Cardinal($1);
    {$ENDIF WITH_CLASS_CONST}
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
    function getType(status: IStatus): Cardinal;
    function getPlan(status: IStatus; detailed: Boolean): PAnsiChar;
    function getAffectedRecords(status: IStatus): UInt64;
    function getInputMetadata(status: IStatus): IMessageMetadata;
    function getOutputMetadata(status: IStatus): IMessageMetadata;
    function execute(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction;
    function openCursor(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; flags: Cardinal): IResultSet;
    procedure setCursorName(status: IStatus; name: PAnsiChar);
    procedure free(status: IStatus);
    function getFlags(status: IStatus): Cardinal;
    //Added by FB4+
    function getTimeout(status: IStatus): Cardinal;
    procedure setTimeout(status: IStatus; timeOut: Cardinal);
    function createBatch(status: IStatus; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch;
  end;

  IStatementImpl = class(IStatement)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    function getType(status: IStatus): Cardinal; virtual; abstract;
    function getPlan(status: IStatus; detailed: Boolean): PAnsiChar; virtual; abstract;
    function getAffectedRecords(status: IStatus): UInt64; virtual; abstract;
    function getInputMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    function getOutputMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    function execute(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; virtual; abstract;
    function openCursor(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; flags: Cardinal): IResultSet; virtual; abstract;
    procedure setCursorName(status: IStatus; name: PAnsiChar); virtual; abstract;
    procedure free(status: IStatus); virtual; abstract;
    function getFlags(status: IStatus): Cardinal; virtual; abstract;
    function getTimeout(status: IStatus): Cardinal; virtual; abstract;
    procedure setTimeout(status: IStatus; timeOut: Cardinal); virtual; abstract;
    function createBatch(status: IStatus; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; virtual; abstract;
  end;

  BatchVTable = class(ReferenceCountedVTable)
  protected
    add: IBatch_addPtr;
    addBlob: IBatch_addBlobPtr;
    appendBlobData: IBatch_appendBlobDataPtr;
    addBlobStream: IBatch_addBlobStreamPtr;
    registerBlob: IBatch_registerBlobPtr;
    execute: IBatch_executePtr;
    cancel: IBatch_cancelPtr;
    getBlobAlignment: IBatch_getBlobAlignmentPtr;
    getMetadata: IBatch_getMetadataPtr;
    setDefaultBpb: IBatch_setDefaultBpbPtr;
  end;

  IBatch = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const VERSION1 = Byte(1);
    const TAG_MULTIERROR = Byte(1);
    const TAG_RECORD_COUNTS = Byte(2);
    const TAG_BUFFER_BYTES_SIZE = Byte(3);
    const TAG_BLOB_POLICY = Byte(4);
    const TAG_DETAILED_ERRORS = Byte(5);
    const BLOB_NONE = Byte(0);
    const BLOB_ID_ENGINE = Byte(1);
    const BLOB_ID_USER = Byte(2);
    const BLOB_STREAM = Byte(3);
    const BLOB_SEGHDR_ALIGN = Cardinal(2);
    {$ENDIF WITH_CLASS_CONST}
    procedure add(status: IStatus; count: Cardinal; inBuffer: Pointer);
    procedure addBlob(status: IStatus; length: Cardinal; inBuffer: Pointer; blobId: PISC_QUAD; parLength: Cardinal; par: PByte);
    procedure appendBlobData(status: IStatus; length: Cardinal; inBuffer: Pointer);
    procedure addBlobStream(status: IStatus; length: Cardinal; inBuffer: Pointer);
    procedure registerBlob(status: IStatus; existingBlob: PISC_QUAD; blobId: PISC_QUAD);
    function execute(status: IStatus; transaction: ITransaction): IBatchCompletionState;
    procedure cancel(status: IStatus);
    function getBlobAlignment(status: IStatus): Cardinal;
    function getMetadata(status: IStatus): IMessageMetadata;
    procedure setDefaultBpb(status: IStatus; parLength: Cardinal; par: PByte);
  end;

  IBatchImpl = class(IBatch)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure add(status: IStatus; count: Cardinal; inBuffer: Pointer); virtual; abstract;
    procedure addBlob(status: IStatus; length: Cardinal; inBuffer: Pointer; blobId: PISC_QUAD; parLength: Cardinal; par: PByte); virtual; abstract;
    procedure appendBlobData(status: IStatus; length: Cardinal; inBuffer: Pointer); virtual; abstract;
    procedure addBlobStream(status: IStatus; length: Cardinal; inBuffer: Pointer); virtual; abstract;
    procedure registerBlob(status: IStatus; existingBlob: PISC_QUAD; blobId: PISC_QUAD); virtual; abstract;
    function execute(status: IStatus; transaction: ITransaction): IBatchCompletionState; virtual; abstract;
    procedure cancel(status: IStatus); virtual; abstract;
    function getBlobAlignment(status: IStatus): Cardinal; virtual; abstract;
    function getMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    procedure setDefaultBpb(status: IStatus; parLength: Cardinal; par: PByte); virtual; abstract;
  end;

  BatchCompletionStateVTable = class(DisposableVTable)
  protected
    getSize: IBatchCompletionState_getSizePtr;
    getState: IBatchCompletionState_getStatePtr;
    findError: IBatchCompletionState_findErrorPtr;
    getStatus: IBatchCompletionState_getStatusPtr;
  end;

  IBatchCompletionState = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const EXECUTE_FAILED = Integer(-1);
    const SUCCESS_NO_INFO = Integer(-2);
    const NO_MORE_ERRORS = Cardinal($ffffffff);
    {$ENDIF WITH_CLASS_CONST}
    function getSize(status: IStatus): Cardinal;
    function getState(status: IStatus; pos: Cardinal): Integer;
    function findError(status: IStatus; pos: Cardinal): Cardinal;
    procedure getStatus(status: IStatus; to_: IStatus; pos: Cardinal);
  end;

  IBatchCompletionStateImpl = class(IBatchCompletionState)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    function getSize(status: IStatus): Cardinal; virtual; abstract;
    function getState(status: IStatus; pos: Cardinal): Integer; virtual; abstract;
    function findError(status: IStatus; pos: Cardinal): Cardinal; virtual; abstract;
    procedure getStatus(status: IStatus; to_: IStatus; pos: Cardinal); virtual; abstract;
  end;

  ReplicatorVTable = class(ReferenceCountedVTable)
  protected
    process: IReplicator_processPtr;
    close: IReplicator_closePtr;
  end;

  IReplicator = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure process(status: IStatus; length: Cardinal; data: PByte);
    procedure close(status: IStatus);
  end;

  IReplicatorImpl = class(IReplicator)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure process(status: IStatus; length: Cardinal; data: PByte); virtual; abstract;
    procedure close(status: IStatus); virtual; abstract;
  end;

  RequestVTable = class(ReferenceCountedVTable)
  protected
    receive: IRequest_receivePtr;
    send: IRequest_sendPtr;
    getInfo: IRequest_getInfoPtr;
    start: IRequest_startPtr;
    startAndSend: IRequest_startAndSendPtr;
    unwind: IRequest_unwindPtr;
    free: IRequest_freePtr;
  end;

  IRequest = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure receive(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
    procedure send(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
    procedure getInfo(status: IStatus; level: Integer; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
    procedure start(status: IStatus; tra: ITransaction; level: Integer);
    procedure startAndSend(status: IStatus; tra: ITransaction; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
    procedure unwind(status: IStatus; level: Integer);
    procedure free(status: IStatus);
  end;

  IRequestImpl = class(IRequest)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure receive(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); virtual; abstract;
    procedure send(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); virtual; abstract;
    procedure getInfo(status: IStatus; level: Integer; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    procedure start(status: IStatus; tra: ITransaction; level: Integer); virtual; abstract;
    procedure startAndSend(status: IStatus; tra: ITransaction; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); virtual; abstract;
    procedure unwind(status: IStatus; level: Integer); virtual; abstract;
    procedure free(status: IStatus); virtual; abstract;
  end;

  EventsVTable = class(ReferenceCountedVTable)
  protected
    cancel: IEvents_cancelPtr;
  end;

  IEvents = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure cancel(status: IStatus);
  end;

  IEventsImpl = class(IEvents)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure cancel(status: IStatus); virtual; abstract;
  end;

  AttachmentVTable = class(ReferenceCountedVTable)
  protected
    getInfo: IAttachment_getInfoPtr;
    startTransaction: IAttachment_startTransactionPtr;
    reconnectTransaction: IAttachment_reconnectTransactionPtr;
    compileRequest: IAttachment_compileRequestPtr;
    transactRequest: IAttachment_transactRequestPtr;
    createBlob: IAttachment_createBlobPtr;
    openBlob: IAttachment_openBlobPtr;
    getSlice: IAttachment_getSlicePtr;
    putSlice: IAttachment_putSlicePtr;
    executeDyn: IAttachment_executeDynPtr;
    prepare: IAttachment_preparePtr;
    execute: IAttachment_executePtr;
    openCursor: IAttachment_openCursorPtr;
    queEvents: IAttachment_queEventsPtr;
    cancelOperation: IAttachment_cancelOperationPtr;
    ping: IAttachment_pingPtr;
    detach: IAttachment_detachPtr;
    dropDatabase: IAttachment_dropDatabasePtr;
    getIdleTimeout: IAttachment_getIdleTimeoutPtr;
    setIdleTimeout: IAttachment_setIdleTimeoutPtr;
    getStatementTimeout: IAttachment_getStatementTimeoutPtr;
    setStatementTimeout: IAttachment_setStatementTimeoutPtr;
    createBatch: IAttachment_createBatchPtr;
    createReplicator: IAttachment_createReplicatorPtr;
  end;

  IAttachment = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
    function startTransaction(status: IStatus; tpbLength: Cardinal; tpb: PByte): ITransaction;
    function reconnectTransaction(status: IStatus; length: Cardinal; id: PByte): ITransaction;
    function compileRequest(status: IStatus; blrLength: Cardinal; blr: PByte): IRequest;
    procedure transactRequest(status: IStatus; transaction: ITransaction; blrLength: Cardinal; blr: PByte; inMsgLength: Cardinal; inMsg: PByte; outMsgLength: Cardinal; outMsg: PByte);
    function createBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob;
    function openBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob;
    function getSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte): Integer;
    procedure putSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte);
    procedure executeDyn(status: IStatus; transaction: ITransaction; length: Cardinal; dyn: PByte);
    function prepare(status: IStatus; tra: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; flags: Cardinal): IStatement;
    function execute(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction;
    function openCursor(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; cursorName: PAnsiChar; cursorFlags: Cardinal): IResultSet;
    function queEvents(status: IStatus; callback: IEventCallback; length: Cardinal; events: PByte): IEvents;
    procedure cancelOperation(status: IStatus; option: Integer);
    procedure ping(status: IStatus);
    procedure detach(status: IStatus);
    procedure dropDatabase(status: IStatus);
    //added in FB4+
    function getIdleTimeout(status: IStatus): Cardinal;
    procedure setIdleTimeout(status: IStatus; timeOut: Cardinal);
    function getStatementTimeout(status: IStatus): Cardinal;
    procedure setStatementTimeout(status: IStatus; timeOut: Cardinal);
    function createBatch(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch;
    function createReplicator(status: IStatus): IReplicator;
  end;

  IAttachmentImpl = class(IAttachment)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    function startTransaction(status: IStatus; tpbLength: Cardinal; tpb: PByte): ITransaction; virtual; abstract;
    function reconnectTransaction(status: IStatus; length: Cardinal; id: PByte): ITransaction; virtual; abstract;
    function compileRequest(status: IStatus; blrLength: Cardinal; blr: PByte): IRequest; virtual; abstract;
    procedure transactRequest(status: IStatus; transaction: ITransaction; blrLength: Cardinal; blr: PByte; inMsgLength: Cardinal; inMsg: PByte; outMsgLength: Cardinal; outMsg: PByte); virtual; abstract;
    function createBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; virtual; abstract;
    function openBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; virtual; abstract;
    function getSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte): Integer; virtual; abstract;
    procedure putSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte); virtual; abstract;
    procedure executeDyn(status: IStatus; transaction: ITransaction; length: Cardinal; dyn: PByte); virtual; abstract;
    function prepare(status: IStatus; tra: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; flags: Cardinal): IStatement; virtual; abstract;
    function execute(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; virtual; abstract;
    function openCursor(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; cursorName: PAnsiChar; cursorFlags: Cardinal): IResultSet; virtual; abstract;
    function queEvents(status: IStatus; callback: IEventCallback; length: Cardinal; events: PByte): IEvents; virtual; abstract;
    procedure cancelOperation(status: IStatus; option: Integer); virtual; abstract;
    procedure ping(status: IStatus); virtual; abstract;
    procedure detach(status: IStatus); virtual; abstract;
    procedure dropDatabase(status: IStatus); virtual; abstract;
    function getIdleTimeout(status: IStatus): Cardinal; virtual; abstract;
    procedure setIdleTimeout(status: IStatus; timeOut: Cardinal); virtual; abstract;
    function getStatementTimeout(status: IStatus): Cardinal; virtual; abstract;
    procedure setStatementTimeout(status: IStatus; timeOut: Cardinal); virtual; abstract;
    function createBatch(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; virtual; abstract;
    function createReplicator(status: IStatus): IReplicator; virtual; abstract;
  end;

  ServiceVTable = class(ReferenceCountedVTable)
  protected
    detach: IService_detachPtr;
    query: IService_queryPtr;
    start: IService_startPtr;
  end;

  IService = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure detach(status: IStatus);
    procedure query(status: IStatus; sendLength: Cardinal; sendItems: PByte; receiveLength: Cardinal; receiveItems: PByte; bufferLength: Cardinal; buffer: PByte);
    procedure start(status: IStatus; spbLength: Cardinal; spb: PByte);
  end;

  IServiceImpl = class(IService)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure detach(status: IStatus); virtual; abstract;
    procedure query(status: IStatus; sendLength: Cardinal; sendItems: PByte; receiveLength: Cardinal; receiveItems: PByte; bufferLength: Cardinal; buffer: PByte); virtual; abstract;
    procedure start(status: IStatus; spbLength: Cardinal; spb: PByte); virtual; abstract;
  end;

  ProviderVTable = class(PluginBaseVTable)
  protected
    attachDatabase: IProvider_attachDatabasePtr;
    createDatabase: IProvider_createDatabasePtr;
    attachServiceManager: IProvider_attachServiceManagerPtr;
    shutdown: IProvider_shutdownPtr;
    setDbCryptCallback: IProvider_setDbCryptCallbackPtr;
  end;

  IProvider = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    function attachDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment;
    function createDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment;
    function attachServiceManager(status: IStatus; service: PAnsiChar; spbLength: Cardinal; spb: PByte): IService;
    procedure shutdown(status: IStatus; timeout: Cardinal; reason: Integer);
    procedure setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback);
  end;

  IProviderImpl = class(IProvider)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function attachDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; virtual; abstract;
    function createDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; virtual; abstract;
    function attachServiceManager(status: IStatus; service: PAnsiChar; spbLength: Cardinal; spb: PByte): IService; virtual; abstract;
    procedure shutdown(status: IStatus; timeout: Cardinal; reason: Integer); virtual; abstract;
    procedure setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback); virtual; abstract;
  end;

  DtcStartVTable = class(DisposableVTable)
  protected
    addAttachment: IDtcStart_addAttachmentPtr;
    addWithTpb: IDtcStart_addWithTpbPtr;
    start: IDtcStart_startPtr;
  end;

  IDtcStart = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure addAttachment(status: IStatus; att: IAttachment);
    procedure addWithTpb(status: IStatus; att: IAttachment; length: Cardinal; tpb: PByte);
    function start(status: IStatus): ITransaction;
  end;

  IDtcStartImpl = class(IDtcStart)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure addAttachment(status: IStatus; att: IAttachment); virtual; abstract;
    procedure addWithTpb(status: IStatus; att: IAttachment; length: Cardinal; tpb: PByte); virtual; abstract;
    function start(status: IStatus): ITransaction; virtual; abstract;
  end;

  DtcVTable = class(VersionedVTable)
  protected
    join: IDtc_joinPtr;
    startBuilder: IDtc_startBuilderPtr;
  end;

  IDtc = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function join(status: IStatus; one: ITransaction; two: ITransaction): ITransaction;
    function startBuilder(status: IStatus): IDtcStart;
  end;

  IDtcImpl = class(IDtc)
  public
    constructor create;
  protected
    function join(status: IStatus; one: ITransaction; two: ITransaction): ITransaction; virtual; abstract;
    function startBuilder(status: IStatus): IDtcStart; virtual; abstract;
  end;

  AuthVTable = class(PluginBaseVTable)
  protected
  end;

  IAuth = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    const AUTH_FAILED = Integer(-1);
    const AUTH_SUCCESS = Integer(0);
    const AUTH_MORE_DATA = Integer(1);
    const AUTH_CONTINUE = Integer(2);
    {$ENDIF WITH_CLASS_CONST}
  end;

  IAuthImpl = class(IAuth)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
  end;

  WriterVTable = class(VersionedVTable)
  protected
    reset: IWriter_resetPtr;
    add: IWriter_addPtr;
    setType: IWriter_setTypePtr;
    setDb: IWriter_setDbPtr;
  end;

  IWriter = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure reset();
    procedure add(status: IStatus; name: PAnsiChar);
    procedure setType(status: IStatus; value: PAnsiChar);
    procedure setDb(status: IStatus; value: PAnsiChar);
  end;

  IWriterImpl = class(IWriter)
  public
    constructor create;
  protected
    procedure reset(); virtual; abstract;
    procedure add(status: IStatus; name: PAnsiChar); virtual; abstract;
    procedure setType(status: IStatus; value: PAnsiChar); virtual; abstract;
    procedure setDb(status: IStatus; value: PAnsiChar); virtual; abstract;
  end;

  ServerBlockVTable = class(VersionedVTable)
  protected
    getLogin: IServerBlock_getLoginPtr;
    getData: IServerBlock_getDataPtr;
    putData: IServerBlock_putDataPtr;
    newKey: IServerBlock_newKeyPtr;
  end;

  IServerBlock = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getLogin(): PAnsiChar;
    function getData(length: PCardinal): PByte;
    procedure putData(status: IStatus; length: Cardinal; data: Pointer);
    function newKey(status: IStatus): ICryptKey;
  end;

  IServerBlockImpl = class(IServerBlock)
  public
    constructor create;
  protected
    function getLogin(): PAnsiChar; virtual; abstract;
    function getData(length: Cardinal): PByte; virtual; abstract;
    procedure putData(status: IStatus; length: Cardinal; data: Pointer); virtual; abstract;
    function newKey(status: IStatus): ICryptKey; virtual; abstract;
  end;

  ClientBlockVTable = class(ReferenceCountedVTable)
  protected
    getLogin: IClientBlock_getLoginPtr;
    getPassword: IClientBlock_getPasswordPtr;
    getData: IClientBlock_getDataPtr;
    putData: IClientBlock_putDataPtr;
    newKey: IClientBlock_newKeyPtr;
    getAuthBlock: IClientBlock_getAuthBlockPtr;
  end;

  IClientBlock = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    function getLogin(): PAnsiChar;
    function getPassword(): PAnsiChar;
    function getData(length: PCardinal): PByte;
    procedure putData(status: IStatus; length: Cardinal; data: Pointer);
    function newKey(status: IStatus): ICryptKey;
    //Added in FB4+
    function getAuthBlock(status: IStatus): IAuthBlock;
  end;

  IClientBlockImpl = class(IClientBlock)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getLogin(): PAnsiChar; virtual; abstract;
    function getPassword(): PAnsiChar; virtual; abstract;
    function getData(length: Cardinal): PByte; virtual; abstract;
    procedure putData(status: IStatus; length: Cardinal; data: Pointer); virtual; abstract;
    function newKey(status: IStatus): ICryptKey; virtual; abstract;
    function getAuthBlock(status: IStatus): IAuthBlock; virtual; abstract;
  end;

  ServerVTable = class(AuthVTable)
  protected
    authenticate: IServer_authenticatePtr;
    setDbCryptCallback: IServer_setDbCryptCallbackPtr;
  end;

  IServer = class(IAuth)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 6;
    {$ENDIF WITH_CLASS_CONST}
    function authenticate(status: IStatus; sBlock: IServerBlock; writerInterface: IWriter): Integer;
    procedure setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback);
  end;

  IServerImpl = class(IServer)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function authenticate(status: IStatus; sBlock: IServerBlock; writerInterface: IWriter): Integer; virtual; abstract;
    procedure setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback); virtual; abstract;
  end;

  ClientVTable = class(AuthVTable)
  protected
    authenticate: IClient_authenticatePtr;
  end;

  IClient = class(IAuth)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 5;
    {$ENDIF WITH_CLASS_CONST}
    function authenticate(status: IStatus; cBlock: IClientBlock): Integer;
  end;

  IClientImpl = class(IClient)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function authenticate(status: IStatus; cBlock: IClientBlock): Integer; virtual; abstract;
  end;

  UserFieldVTable = class(VersionedVTable)
  protected
    entered: IUserField_enteredPtr;
    specified: IUserField_specifiedPtr;
    setEntered: IUserField_setEnteredPtr;
  end;

  IUserField = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function entered(): Integer;
    function specified(): Integer;
    procedure setEntered(status: IStatus; newValue: Integer);
  end;

  IUserFieldImpl = class(IUserField)
  public
    constructor create;
  protected
    function entered(): Integer; virtual; abstract;
    function specified(): Integer; virtual; abstract;
    procedure setEntered(status: IStatus; newValue: Integer); virtual; abstract;
  end;

  CharUserFieldVTable = class(UserFieldVTable)
  protected
    get: ICharUserField_getPtr;
    set_: ICharUserField_set_Ptr;
  end;

  ICharUserField = class(IUserField)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function get(): PAnsiChar;
    procedure set_(status: IStatus; newValue: PAnsiChar);
  end;

  ICharUserFieldImpl = class(ICharUserField)
  public
    constructor create;
  protected
    function entered(): Integer; virtual; abstract;
    function specified(): Integer; virtual; abstract;
    procedure setEntered(status: IStatus; newValue: Integer); virtual; abstract;
    function get(): PAnsiChar; virtual; abstract;
    procedure set_(status: IStatus; newValue: PAnsiChar); virtual; abstract;
  end;

  IntUserFieldVTable = class(UserFieldVTable)
  protected
    get: IIntUserField_getPtr;
    set_: IIntUserField_set_Ptr;
  end;

  IIntUserField = class(IUserField)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function get(): Integer;
    procedure set_(status: IStatus; newValue: Integer);
  end;

  IIntUserFieldImpl = class(IIntUserField)
  public
    constructor create;
  protected
    function entered(): Integer; virtual; abstract;
    function specified(): Integer; virtual; abstract;
    procedure setEntered(status: IStatus; newValue: Integer); virtual; abstract;
    function get(): Integer; virtual; abstract;
    procedure set_(status: IStatus; newValue: Integer); virtual; abstract;
  end;

  UserVTable = class(VersionedVTable)
  protected
    operation: IUser_operationPtr;
    userName: IUser_userNamePtr;
    password: IUser_passwordPtr;
    firstName: IUser_firstNamePtr;
    lastName: IUser_lastNamePtr;
    middleName: IUser_middleNamePtr;
    comment: IUser_commentPtr;
    attributes: IUser_attributesPtr;
    active: IUser_activePtr;
    admin: IUser_adminPtr;
    clear: IUser_clearPtr;
  end;

  IUser = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const OP_USER_ADD = Cardinal(1);
    const OP_USER_MODIFY = Cardinal(2);
    const OP_USER_DELETE = Cardinal(3);
    const OP_USER_DISPLAY = Cardinal(4);
    const OP_USER_SET_MAP = Cardinal(5);
    const OP_USER_DROP_MAP = Cardinal(6);
    {$ENDIF WITH_CLASS_CONST}
    function operation(): Cardinal;
    function userName(): ICharUserField;
    function password(): ICharUserField;
    function firstName(): ICharUserField;
    function lastName(): ICharUserField;
    function middleName(): ICharUserField;
    function comment(): ICharUserField;
    function attributes(): ICharUserField;
    function active(): IIntUserField;
    function admin(): IIntUserField;
    procedure clear(status: IStatus);
  end;

  IUserImpl = class(IUser)
  public
    constructor create;
  protected
    function operation(): Cardinal; virtual; abstract;
    function userName(): ICharUserField; virtual; abstract;
    function password(): ICharUserField; virtual; abstract;
    function firstName(): ICharUserField; virtual; abstract;
    function lastName(): ICharUserField; virtual; abstract;
    function middleName(): ICharUserField; virtual; abstract;
    function comment(): ICharUserField; virtual; abstract;
    function attributes(): ICharUserField; virtual; abstract;
    function active(): IIntUserField; virtual; abstract;
    function admin(): IIntUserField; virtual; abstract;
    procedure clear(status: IStatus); virtual; abstract;
  end;

  ListUsersVTable = class(VersionedVTable)
  protected
    list: IListUsers_listPtr;
  end;

  IListUsers = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure list(status: IStatus; user: IUser);
  end;

  IListUsersImpl = class(IListUsers)
  public
    constructor create;
  protected
    procedure list(status: IStatus; user: IUser); virtual; abstract;
  end;

  LogonInfoVTable = class(VersionedVTable)
  protected
    name: ILogonInfo_namePtr;
    role: ILogonInfo_rolePtr;
    networkProtocol: ILogonInfo_networkProtocolPtr;
    remoteAddress: ILogonInfo_remoteAddressPtr;
    authBlock: ILogonInfo_authBlockPtr;
    attachment: ILogonInfo_attachmentPtr;
    transaction: ILogonInfo_transactionPtr;
  end;

  ILogonInfo = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function name(): PAnsiChar;
    function role(): PAnsiChar;
    function networkProtocol(): PAnsiChar;
    function remoteAddress(): PAnsiChar;
    function authBlock(length: PCardinal): PByte;
    function attachment(status: IStatus): IAttachment;
    function transaction(status: IStatus): ITransaction;
  end;

  ILogonInfoImpl = class(ILogonInfo)
  public
    constructor create;
  protected
    function name(): PAnsiChar; virtual; abstract;
    function role(): PAnsiChar; virtual; abstract;
    function networkProtocol(): PAnsiChar; virtual; abstract;
    function remoteAddress(): PAnsiChar; virtual; abstract;
    function authBlock(length: PCardinal): PByte; virtual; abstract;
    function attachment(status: IStatus): IAttachment; virtual; abstract;
    function transaction(status: IStatus): ITransaction; virtual; abstract;
  end;

  ManagementVTable = class(PluginBaseVTable)
  protected
    start: IManagement_startPtr;
    execute: IManagement_executePtr;
    commit: IManagement_commitPtr;
    rollback: IManagement_rollbackPtr;
  end;

  IManagement = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure start(status: IStatus; logonInfo: ILogonInfo);
    function execute(status: IStatus; user: IUser; callback: IListUsers): Integer;
    procedure commit(status: IStatus);
    procedure rollback(status: IStatus);
  end;

  IManagementImpl = class(IManagement)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    procedure start(status: IStatus; logonInfo: ILogonInfo); virtual; abstract;
    function execute(status: IStatus; user: IUser; callback: IListUsers): Integer; virtual; abstract;
    procedure commit(status: IStatus); virtual; abstract;
    procedure rollback(status: IStatus); virtual; abstract;
  end;

  AuthBlockVTable = class(VersionedVTable)
  protected
    getType: IAuthBlock_getTypePtr;
    getName: IAuthBlock_getNamePtr;
    getPlugin: IAuthBlock_getPluginPtr;
    getSecurityDb: IAuthBlock_getSecurityDbPtr;
    getOriginalPlugin: IAuthBlock_getOriginalPluginPtr;
    next: IAuthBlock_nextPtr;
    first: IAuthBlock_firstPtr;
  end;

  IAuthBlock = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getType(): PAnsiChar;
    function getName(): PAnsiChar;
    function getPlugin(): PAnsiChar;
    function getSecurityDb(): PAnsiChar;
    function getOriginalPlugin(): PAnsiChar;
    function next(status: IStatus): Boolean;
    function first(status: IStatus): Boolean;
  end;

  IAuthBlockImpl = class(IAuthBlock)
  public
    constructor create;
  protected
    function getType(): PAnsiChar; virtual; abstract;
    function getName(): PAnsiChar; virtual; abstract;
    function getPlugin(): PAnsiChar; virtual; abstract;
    function getSecurityDb(): PAnsiChar; virtual; abstract;
    function getOriginalPlugin(): PAnsiChar; virtual; abstract;
    function next(status: IStatus): Boolean; virtual; abstract;
    function first(status: IStatus): Boolean; virtual; abstract;
  end;

  WireCryptPluginVTable = class(PluginBaseVTable)
  protected
    getKnownTypes: IWireCryptPlugin_getKnownTypesPtr;
    setKey: IWireCryptPlugin_setKeyPtr;
    encrypt: IWireCryptPlugin_encryptPtr;
    decrypt: IWireCryptPlugin_decryptPtr;
    //add in FB4
    getSpecificData: IWireCryptPlugin_getSpecificDataPtr;
    setSpecificData: IWireCryptPlugin_setSpecificDataPtr;
  end;

  IWireCryptPlugin = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 5;
    {$ENDIF WITH_CLASS_CONST}
    function getKnownTypes(status: IStatus): PAnsiChar;
    procedure setKey(status: IStatus; key: ICryptKey);
    procedure encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
    procedure decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
    //add in FB4
    function getSpecificData(status: IStatus; keyType: PAnsiChar; length: PCardinal): PByte;
    procedure setSpecificData(status: IStatus; keyType: PAnsiChar; length: Cardinal; data: PByte);
  end;

  IWireCryptPluginImpl = class(IWireCryptPlugin)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function getKnownTypes(status: IStatus): PAnsiChar; virtual; abstract;
    procedure setKey(status: IStatus; key: ICryptKey); virtual; abstract;
    procedure encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); virtual; abstract;
    procedure decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); virtual; abstract;
    function getSpecificData(status: IStatus; keyType: PAnsiChar; length: Cardinal): PByte; virtual; abstract;
    procedure setSpecificData(status: IStatus; keyType: PAnsiChar; length: Cardinal; data: PByte); virtual; abstract;
  end;

  CryptKeyCallbackVTable = class(VersionedVTable)
  protected
    callback: ICryptKeyCallback_callbackPtr;
  end;

  ICryptKeyCallback = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function callback(dataLength: Cardinal; data: Pointer; bufferLength: Cardinal; buffer: Pointer): Cardinal;
  end;

  ICryptKeyCallbackImpl = class(ICryptKeyCallback)
    constructor create;
  protected
    function callback(dataLength: Cardinal; data: Pointer; bufferLength: Cardinal; buffer: Pointer): Cardinal; virtual; abstract;
  end;

  KeyHolderPluginVTable = class(PluginBaseVTable)
  protected
    keyCallback: IKeyHolderPlugin_keyCallbackPtr;
    keyHandle: IKeyHolderPlugin_keyHandlePtr;
    useOnlyOwnKeys: IKeyHolderPlugin_useOnlyOwnKeysPtr;
    chainHandle: IKeyHolderPlugin_chainHandlePtr;
  end;

  IKeyHolderPlugin = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 5;
    {$ENDIF WITH_CLASS_CONST}
    function keyCallback(status: IStatus; callback: ICryptKeyCallback): Integer;
    function keyHandle(status: IStatus; keyName: PAnsiChar): ICryptKeyCallback;
    function useOnlyOwnKeys(status: IStatus): Boolean;
    function chainHandle(status: IStatus): ICryptKeyCallback;
  end;

  IKeyHolderPluginImpl = class(IKeyHolderPlugin)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function keyCallback(status: IStatus; callback: ICryptKeyCallback): Integer; virtual; abstract;
    function keyHandle(status: IStatus; keyName: PAnsiChar): ICryptKeyCallback; virtual; abstract;
    function useOnlyOwnKeys(status: IStatus): Boolean; virtual; abstract;
    function chainHandle(status: IStatus): ICryptKeyCallback; virtual; abstract;
  end;

  DbCryptInfoVTable = class(ReferenceCountedVTable)
  protected
    getDatabaseFullPath: IDbCryptInfo_getDatabaseFullPathPtr;
  end;

  IDbCryptInfo = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getDatabaseFullPath(status: IStatus): PAnsiChar;
  end;

  IDbCryptInfoImpl = class(IDbCryptInfo)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function getDatabaseFullPath(status: IStatus): PAnsiChar; virtual; abstract;
  end;

  DbCryptPluginVTable = class(PluginBaseVTable)
  protected
    setKey: IDbCryptPlugin_setKeyPtr;
    encrypt: IDbCryptPlugin_encryptPtr;
    decrypt: IDbCryptPlugin_decryptPtr;
    setInfo: IDbCryptPlugin_setInfoPtr;
  end;

  IDbCryptPlugin = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 5;
    {$ENDIF WITH_CLASS_CONST}
    procedure setKey(status: IStatus; length: Cardinal; sources: PIKeyHolderPlugin; keyName: PAnsiChar);
    procedure encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
    procedure decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
    procedure setInfo(status: IStatus; info: IDbCryptInfo);
  end;

  IDbCryptPluginImpl = class(IDbCryptPlugin)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    procedure setKey(status: IStatus; length: Cardinal; sources: PIKeyHolderPlugin; keyName: PAnsiChar); virtual; abstract;
    procedure encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); virtual; abstract;
    procedure decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); virtual; abstract;
    procedure setInfo(status: IStatus; info: IDbCryptInfo); virtual; abstract;
  end;

  ExternalContextVTable = class(VersionedVTable)
  protected
    getMaster: IExternalContext_getMasterPtr;
    getEngine: IExternalContext_getEnginePtr;
    getAttachment: IExternalContext_getAttachmentPtr;
    getTransaction: IExternalContext_getTransactionPtr;
    getUserName: IExternalContext_getUserNamePtr;
    getDatabaseName: IExternalContext_getDatabaseNamePtr;
    getClientCharSet: IExternalContext_getClientCharSetPtr;
    obtainInfoCode: IExternalContext_obtainInfoCodePtr;
    getInfo: IExternalContext_getInfoPtr;
    setInfo: IExternalContext_setInfoPtr;
  end;

  IExternalContext = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getMaster(): IMaster;
    function getEngine(status: IStatus): IExternalEngine;
    function getAttachment(status: IStatus): IAttachment;
    function getTransaction(status: IStatus): ITransaction;
    function getUserName(): PAnsiChar;
    function getDatabaseName(): PAnsiChar;
    function getClientCharSet(): PAnsiChar;
    function obtainInfoCode(): Integer;
    function getInfo(code: Integer): Pointer;
    function setInfo(code: Integer; value: Pointer): Pointer;
  end;

  IExternalContextImpl = class(IExternalContext)
  public
    constructor create;
  protected
    function getMaster(): IMaster; virtual; abstract;
    function getEngine(status: IStatus): IExternalEngine; virtual; abstract;
    function getAttachment(status: IStatus): IAttachment; virtual; abstract;
    function getTransaction(status: IStatus): ITransaction; virtual; abstract;
    function getUserName(): PAnsiChar; virtual; abstract;
    function getDatabaseName(): PAnsiChar; virtual; abstract;
    function getClientCharSet(): PAnsiChar; virtual; abstract;
    function obtainInfoCode(): Integer; virtual; abstract;
    function getInfo(code: Integer): Pointer; virtual; abstract;
    function setInfo(code: Integer; value: Pointer): Pointer; virtual; abstract;
  end;

  ExternalResultSetVTable = class(DisposableVTable)
  protected
    fetch: IExternalResultSet_fetchPtr;
  end;

  IExternalResultSet = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function fetch(status: IStatus): Boolean;
  end;

  IExternalResultSetImpl = class(IExternalResultSet)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    function fetch(status: IStatus): Boolean; virtual; abstract;
  end;

  ExternalFunctionVTable = class(DisposableVTable)
  protected
    getCharSet: IExternalFunction_getCharSetPtr;
    execute: IExternalFunction_executePtr;
  end;

  IExternalFunction = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
    procedure execute(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer);
  end;

  IExternalFunctionImpl = class(IExternalFunction)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); virtual; abstract;
    procedure execute(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer); virtual; abstract;
  end;

  ExternalProcedureVTable = class(DisposableVTable)
  protected
    getCharSet: IExternalProcedure_getCharSetPtr;
    open: IExternalProcedure_openPtr;
  end;

  IExternalProcedure = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
    function open(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer): IExternalResultSet;
  end;

  IExternalProcedureImpl = class(IExternalProcedure)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); virtual; abstract;
    function open(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer): IExternalResultSet; virtual; abstract;
  end;

  ExternalTriggerVTable = class(DisposableVTable)
  protected
    getCharSet: IExternalTrigger_getCharSetPtr;
    execute: IExternalTrigger_executePtr;
  end;

  IExternalTrigger = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const TYPE_BEFORE = Cardinal(1);
    const TYPE_AFTER = Cardinal(2);
    const TYPE_DATABASE = Cardinal(3);
    const ACTION_INSERT = Cardinal(1);
    const ACTION_UPDATE = Cardinal(2);
    const ACTION_DELETE = Cardinal(3);
    const ACTION_CONNECT = Cardinal(4);
    const ACTION_DISCONNECT = Cardinal(5);
    const ACTION_TRANS_START = Cardinal(6);
    const ACTION_TRANS_COMMIT = Cardinal(7);
    const ACTION_TRANS_ROLLBACK = Cardinal(8);
    const ACTION_DDL = Cardinal(9);
    {$ENDIF WITH_CLASS_CONST}
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
    procedure execute(status: IStatus; context: IExternalContext; action: Cardinal; oldMsg: Pointer; newMsg: Pointer);
  end;

  IExternalTriggerImpl = class(IExternalTrigger)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); virtual; abstract;
    procedure execute(status: IStatus; context: IExternalContext; action: Cardinal; oldMsg: Pointer; newMsg: Pointer); virtual; abstract;
  end;

  RoutineMetadataVTable = class(VersionedVTable)
  protected
    getPackage: IRoutineMetadata_getPackagePtr;
    getName: IRoutineMetadata_getNamePtr;
    getEntryPoint: IRoutineMetadata_getEntryPointPtr;
    getBody: IRoutineMetadata_getBodyPtr;
    getInputMetadata: IRoutineMetadata_getInputMetadataPtr;
    getOutputMetadata: IRoutineMetadata_getOutputMetadataPtr;
    getTriggerMetadata: IRoutineMetadata_getTriggerMetadataPtr;
    getTriggerTable: IRoutineMetadata_getTriggerTablePtr;
    getTriggerType: IRoutineMetadata_getTriggerTypePtr;
  end;

  IRoutineMetadata = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getPackage(status: IStatus): PAnsiChar;
    function getName(status: IStatus): PAnsiChar;
    function getEntryPoint(status: IStatus): PAnsiChar;
    function getBody(status: IStatus): PAnsiChar;
    function getInputMetadata(status: IStatus): IMessageMetadata;
    function getOutputMetadata(status: IStatus): IMessageMetadata;
    function getTriggerMetadata(status: IStatus): IMessageMetadata;
    function getTriggerTable(status: IStatus): PAnsiChar;
    function getTriggerType(status: IStatus): Cardinal;
  end;

  IRoutineMetadataImpl = class(IRoutineMetadata)
  public
    constructor create;
  protected
    function getPackage(status: IStatus): PAnsiChar; virtual; abstract;
    function getName(status: IStatus): PAnsiChar; virtual; abstract;
    function getEntryPoint(status: IStatus): PAnsiChar; virtual; abstract;
    function getBody(status: IStatus): PAnsiChar; virtual; abstract;
    function getInputMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    function getOutputMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    function getTriggerMetadata(status: IStatus): IMessageMetadata; virtual; abstract;
    function getTriggerTable(status: IStatus): PAnsiChar; virtual; abstract;
    function getTriggerType(status: IStatus): Cardinal; virtual; abstract;
  end;

  ExternalEngineVTable = class(PluginBaseVTable)
  protected
    open: IExternalEngine_openPtr;
    openAttachment: IExternalEngine_openAttachmentPtr;
    closeAttachment: IExternalEngine_closeAttachmentPtr;
    makeFunction: IExternalEngine_makeFunctionPtr;
    makeProcedure: IExternalEngine_makeProcedurePtr;
    makeTrigger: IExternalEngine_makeTriggerPtr;
  end;

  IExternalEngine = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure open(status: IStatus; context: IExternalContext; charSet: PAnsiChar; charSetSize: Cardinal);
    procedure openAttachment(status: IStatus; context: IExternalContext);
    procedure closeAttachment(status: IStatus; context: IExternalContext);
    function makeFunction(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalFunction;
    function makeProcedure(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalProcedure;
    function makeTrigger(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder): IExternalTrigger;
  end;

  IExternalEngineImpl = class(IExternalEngine)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    procedure open(status: IStatus; context: IExternalContext; charSet: PAnsiChar; charSetSize: Cardinal); virtual; abstract;
    procedure openAttachment(status: IStatus; context: IExternalContext); virtual; abstract;
    procedure closeAttachment(status: IStatus; context: IExternalContext); virtual; abstract;
    function makeFunction(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalFunction; virtual; abstract;
    function makeProcedure(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalProcedure; virtual; abstract;
    function makeTrigger(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder): IExternalTrigger; virtual; abstract;
  end;

  TimerVTable = class(ReferenceCountedVTable)
  protected
    handler: ITimer_handlerPtr;
  end;

  ITimer = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure handler();
  end;

  ITimerImpl = class(ITimer)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure handler(); virtual; abstract;
  end;

  TimerControlVTable = class(VersionedVTable)
  protected
    start: ITimerControl_startPtr;
    stop: ITimerControl_stopPtr;
  end;

  ITimerControl = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure start(status: IStatus; timer: ITimer; microSeconds: UInt64);
    procedure stop(status: IStatus; timer: ITimer);
  end;

  ITimerControlImpl = class(ITimerControl)
  public
    constructor create;
  protected
    procedure start(status: IStatus; timer: ITimer; microSeconds: UInt64); virtual; abstract;
    procedure stop(status: IStatus; timer: ITimer); virtual; abstract;
  end;

  VersionCallbackVTable = class(VersionedVTable)
  protected
    callback: IVersionCallback_callbackPtr;
  end;

  IVersionCallback = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure callback(status: IStatus; text: PAnsiChar);
  end;

  IVersionCallbackImpl = class(IVersionCallback)
  public
    constructor create;
  protected
    procedure callback(status: IStatus; text: PAnsiChar); virtual; abstract;
  end;

  UtilVTable = class(VersionedVTable)
  protected
    getFbVersion: IUtil_getFbVersionPtr;
    loadBlob: IUtil_loadBlobPtr;
    dumpBlob: IUtil_dumpBlobPtr;
    getPerfCounters: IUtil_getPerfCountersPtr;
    executeCreateDatabase: IUtil_executeCreateDatabasePtr;
    decodeDate: IUtil_decodeDatePtr;
    decodeTime: IUtil_decodeTimePtr;
    encodeDate: IUtil_encodeDatePtr;
    encodeTime: IUtil_encodeTimePtr;
    formatStatus: IUtil_formatStatusPtr;
    getClientVersion: IUtil_getClientVersionPtr;
    getXpbBuilder: IUtil_getXpbBuilderPtr;
    setOffsets: IUtil_setOffsetsPtr;
    getDecFloat16: IUtil_getDecFloat16Ptr;
    getDecFloat34: IUtil_getDecFloat34Ptr;
    decodeTimeTz: IUtil_decodeTimeTzPtr;
    decodeTimeStampTz: IUtil_decodeTimeStampTzPtr;
    encodeTimeTz: IUtil_encodeTimeTzPtr;
    encodeTimeStampTz: IUtil_encodeTimeStampTzPtr;
    getInt128: IUtil_getInt128Ptr;
    decodeTimeTzEx: IUtil_decodeTimeTzExPtr;
    decodeTimeStampTzEx: IUtil_decodeTimeStampTzExPtr;
  end;

  IUtil = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure getFbVersion(status: IStatus; att: IAttachment; callback: IVersionCallback);
    procedure loadBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean);
    procedure dumpBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean);
    procedure getPerfCounters(status: IStatus; att: IAttachment; countersSet: PAnsiChar; counters: PInt64);
    function executeCreateDatabase(status: IStatus; stmtLength: Cardinal; creatDBstatement: PAnsiChar; dialect: Cardinal; stmtIsCreateDb: BooleanPtr): IAttachment;
    procedure decodeDate(date: TISC_DATE; year: PCardinal; month: PCardinal; day: PCardinal);
    procedure decodeTime(time: TISC_TIME; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal);
    function encodeDate(year: Cardinal; month: Cardinal; day: Cardinal): TISC_DATE;
    function encodeTime(hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal): TISC_TIME;
    function formatStatus(buffer: PAnsiChar; bufferSize: Cardinal; status: IStatus): Cardinal;
    function getClientVersion(): Cardinal;
    function getXpbBuilder(status: IStatus; kind: Cardinal; buf: PByte; len: Cardinal): IXpbBuilder;
    function setOffsets(status: IStatus; metadata: IMessageMetadata; callback: IOffsetsCallback): Cardinal;
    //Added in FB4
    function getDecFloat16(status: IStatus): IDecFloat16;
    function getDecFloat34(status: IStatus): IDecFloat34;
    procedure decodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
    procedure decodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
    procedure encodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar);
    procedure encodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: Cardinal; month: Cardinal; day: Cardinal; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar);
    function getInt128(status: IStatus): IInt128;
    procedure decodeTimeTzEx(status: IStatus; timeTz: PISC_TIME_TZ_EX; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
    procedure decodeTimeStampTzEx(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ_EX; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
  end;

  IUtilImpl = class(IUtil)
  public
    constructor create;
  protected
    procedure getFbVersion(status: IStatus; att: IAttachment; callback: IVersionCallback); virtual; abstract;
    procedure loadBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); virtual; abstract;
    procedure dumpBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); virtual; abstract;
    procedure getPerfCounters(status: IStatus; att: IAttachment; countersSet: PAnsiChar; counters: PInt64); virtual; abstract;
    function executeCreateDatabase(status: IStatus; stmtLength: Cardinal; creatDBstatement: PAnsiChar; dialect: Cardinal; stmtIsCreateDb: BooleanPtr): IAttachment; virtual; abstract;
    procedure decodeDate(date: TISC_DATE; year: Cardinal; month: Cardinal; day: Cardinal); virtual; abstract;
    procedure decodeTime(time: TISC_TIME; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal); virtual; abstract;
    function encodeDate(year: Cardinal; month: Cardinal; day: Cardinal): TISC_DATE; virtual; abstract;
    function encodeTime(hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal): TISC_TIME; virtual; abstract;
    function formatStatus(buffer: PAnsiChar; bufferSize: Cardinal; status: IStatus): Cardinal; virtual; abstract;
    function getClientVersion(): Cardinal; virtual; abstract;
    function getXpbBuilder(status: IStatus; kind: Cardinal; buf: PByte; len: Cardinal): IXpbBuilder; virtual; abstract;
    function setOffsets(status: IStatus; metadata: IMessageMetadata; callback: IOffsetsCallback): Cardinal; virtual; abstract;
    function getDecFloat16(status: IStatus): IDecFloat16; virtual; abstract;
    function getDecFloat34(status: IStatus): IDecFloat34; virtual; abstract;
    procedure decodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); virtual; abstract;
    procedure decodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); virtual; abstract;
    procedure encodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); virtual; abstract;
    procedure encodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: Cardinal; month: Cardinal; day: Cardinal; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); virtual; abstract;
    function getInt128(status: IStatus): IInt128; virtual; abstract;
    procedure decodeTimeTzEx(status: IStatus; timeTz: PISC_TIME_TZ_EX; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); virtual; abstract;
    procedure decodeTimeStampTzEx(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ_EX; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); virtual; abstract;
  end;

  OffsetsCallbackVTable = class(VersionedVTable)
  protected
    setOffset: IOffsetsCallback_setOffsetPtr;
  end;

  IOffsetsCallback = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    procedure setOffset(status: IStatus; index: Cardinal; offset: Cardinal; nullOffset: Cardinal);
  end;

  IOffsetsCallbackImpl = class(IOffsetsCallback)
  public
    constructor create;
  protected
    procedure setOffset(status: IStatus; index: Cardinal; offset: Cardinal; nullOffset: Cardinal); virtual; abstract;
  end;

  XpbBuilderVTable = class(DisposableVTable)
  protected
    clear: IXpbBuilder_clearPtr;
    removeCurrent: IXpbBuilder_removeCurrentPtr;
    insertInt: IXpbBuilder_insertIntPtr;
    insertBigInt: IXpbBuilder_insertBigIntPtr;
    insertBytes: IXpbBuilder_insertBytesPtr;
    insertString: IXpbBuilder_insertStringPtr;
    insertTag: IXpbBuilder_insertTagPtr;
    isEof: IXpbBuilder_isEofPtr;
    moveNext: IXpbBuilder_moveNextPtr;
    rewind: IXpbBuilder_rewindPtr;
    findFirst: IXpbBuilder_findFirstPtr;
    findNext: IXpbBuilder_findNextPtr;
    getTag: IXpbBuilder_getTagPtr;
    getLength: IXpbBuilder_getLengthPtr;
    getInt: IXpbBuilder_getIntPtr;
    getBigInt: IXpbBuilder_getBigIntPtr;
    getString: IXpbBuilder_getStringPtr;
    getBytes: IXpbBuilder_getBytesPtr;
    getBufferLength: IXpbBuilder_getBufferLengthPtr;
    getBuffer: IXpbBuilder_getBufferPtr;
  end;

  IXpbBuilder = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const DPB = Cardinal(1);
    const SPB_ATTACH = Cardinal(2);
    const SPB_START = Cardinal(3);
    const TPB = Cardinal(4);
    const BATCH = Cardinal(5);
    const BPB = Cardinal(6);
    const SPB_SEND = Cardinal(7);
    const SPB_RECEIVE = Cardinal(8);
    const SPB_RESPONSE = Cardinal(9);
    {$ENDIF WITH_CLASS_CONST}
    procedure clear(status: IStatus);
    procedure removeCurrent(status: IStatus);
    procedure insertInt(status: IStatus; tag: Byte; value: Integer);
    procedure insertBigInt(status: IStatus; tag: Byte; value: Int64);
    procedure insertBytes(status: IStatus; tag: Byte; bytes: Pointer; length: Cardinal);
    procedure insertString(status: IStatus; tag: Byte; str: PAnsiChar);
    procedure insertTag(status: IStatus; tag: Byte);
    function isEof(status: IStatus): Boolean;
    procedure moveNext(status: IStatus);
    procedure rewind(status: IStatus);
    function findFirst(status: IStatus; tag: Byte): Boolean;
    function findNext(status: IStatus): Boolean;
    function getTag(status: IStatus): Byte;
    function getLength(status: IStatus): Cardinal;
    function getInt(status: IStatus): Integer;
    function getBigInt(status: IStatus): Int64;
    function getString(status: IStatus): PAnsiChar;
    function getBytes(status: IStatus): PByte;
    function getBufferLength(status: IStatus): Cardinal;
    function getBuffer(status: IStatus): PByte;
  end;

  IXpbBuilderImpl = class(IXpbBuilder)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure clear(status: IStatus); virtual; abstract;
    procedure removeCurrent(status: IStatus); virtual; abstract;
    procedure insertInt(status: IStatus; tag: Byte; value: Integer); virtual; abstract;
    procedure insertBigInt(status: IStatus; tag: Byte; value: Int64); virtual; abstract;
    procedure insertBytes(status: IStatus; tag: Byte; bytes: Pointer; length: Cardinal); virtual; abstract;
    procedure insertString(status: IStatus; tag: Byte; str: PAnsiChar); virtual; abstract;
    procedure insertTag(status: IStatus; tag: Byte); virtual; abstract;
    function isEof(status: IStatus): Boolean; virtual; abstract;
    procedure moveNext(status: IStatus); virtual; abstract;
    procedure rewind(status: IStatus); virtual; abstract;
    function findFirst(status: IStatus; tag: Byte): Boolean; virtual; abstract;
    function findNext(status: IStatus): Boolean; virtual; abstract;
    function getTag(status: IStatus): Byte; virtual; abstract;
    function getLength(status: IStatus): Cardinal; virtual; abstract;
    function getInt(status: IStatus): Integer; virtual; abstract;
    function getBigInt(status: IStatus): Int64; virtual; abstract;
    function getString(status: IStatus): PAnsiChar; virtual; abstract;
    function getBytes(status: IStatus): PByte; virtual; abstract;
    function getBufferLength(status: IStatus): Cardinal; virtual; abstract;
    function getBuffer(status: IStatus): PByte; virtual; abstract;
  end;

  TraceConnectionVTable = class(VersionedVTable)
  protected
    getKind: ITraceConnection_getKindPtr;
    getProcessID: ITraceConnection_getProcessIDPtr;
    getUserName: ITraceConnection_getUserNamePtr;
    getRoleName: ITraceConnection_getRoleNamePtr;
    getCharSet: ITraceConnection_getCharSetPtr;
    getRemoteProtocol: ITraceConnection_getRemoteProtocolPtr;
    getRemoteAddress: ITraceConnection_getRemoteAddressPtr;
    getRemoteProcessID: ITraceConnection_getRemoteProcessIDPtr;
    getRemoteProcessName: ITraceConnection_getRemoteProcessNamePtr;
  end;

  ITraceConnection = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const KIND_DATABASE = Cardinal(1);
    const KIND_SERVICE = Cardinal(2);
    {$ENDIF WITH_CLASS_CONST}
    function getKind(): Cardinal;
    function getProcessID(): Integer;
    function getUserName(): PAnsiChar;
    function getRoleName(): PAnsiChar;
    function getCharSet(): PAnsiChar;
    function getRemoteProtocol(): PAnsiChar;
    function getRemoteAddress(): PAnsiChar;
    function getRemoteProcessID(): Integer;
    function getRemoteProcessName(): PAnsiChar;
  end;

  ITraceConnectionImpl = class(ITraceConnection)
  public
    constructor create;
  protected
    function getKind(): Cardinal; virtual; abstract;
    function getProcessID(): Integer; virtual; abstract;
    function getUserName(): PAnsiChar; virtual; abstract;
    function getRoleName(): PAnsiChar; virtual; abstract;
    function getCharSet(): PAnsiChar; virtual; abstract;
    function getRemoteProtocol(): PAnsiChar; virtual; abstract;
    function getRemoteAddress(): PAnsiChar; virtual; abstract;
    function getRemoteProcessID(): Integer; virtual; abstract;
    function getRemoteProcessName(): PAnsiChar; virtual; abstract;
  end;

  TraceDatabaseConnectionVTable = class(TraceConnectionVTable)
  protected
    getConnectionID: ITraceDatabaseConnection_getConnectionIDPtr;
    getDatabaseName: ITraceDatabaseConnection_getDatabaseNamePtr;
  end;

  ITraceDatabaseConnection = class(ITraceConnection)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getConnectionID(): Int64;
    function getDatabaseName(): PAnsiChar;
  end;

  ITraceDatabaseConnectionImpl = class(ITraceDatabaseConnection)
  public
    constructor create;
  protected
    function getKind(): Cardinal; virtual; abstract;
    function getProcessID(): Integer; virtual; abstract;
    function getUserName(): PAnsiChar; virtual; abstract;
    function getRoleName(): PAnsiChar; virtual; abstract;
    function getCharSet(): PAnsiChar; virtual; abstract;
    function getRemoteProtocol(): PAnsiChar; virtual; abstract;
    function getRemoteAddress(): PAnsiChar; virtual; abstract;
    function getRemoteProcessID(): Integer; virtual; abstract;
    function getRemoteProcessName(): PAnsiChar; virtual; abstract;
    function getConnectionID(): Int64; virtual; abstract;
    function getDatabaseName(): PAnsiChar; virtual; abstract;
  end;

  TraceTransactionVTable = class(VersionedVTable)
  protected
    getTransactionID: ITraceTransaction_getTransactionIDPtr;
    getReadOnly: ITraceTransaction_getReadOnlyPtr;
    getWait: ITraceTransaction_getWaitPtr;
    getIsolation: ITraceTransaction_getIsolationPtr;
    getPerf: ITraceTransaction_getPerfPtr;
    getInitialID: ITraceTransaction_getInitialIDPtr;
    getPreviousID: ITraceTransaction_getPreviousIDPtr;
  end;

  ITraceTransaction = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const ISOLATION_CONSISTENCY = Cardinal(1);
    const ISOLATION_CONCURRENCY = Cardinal(2);
    const ISOLATION_READ_COMMITTED_RECVER = Cardinal(3);
    const ISOLATION_READ_COMMITTED_NORECVER = Cardinal(4);
    const ISOLATION_READ_COMMITTED_READ_CONSISTENCY = Cardinal(5);
    {$ENDIF WITH_CLASS_CONST}
    function getTransactionID(): Int64;
    function getReadOnly(): Boolean;
    function getWait(): Integer;
    function getIsolation(): Cardinal;
    function getPerf(): PPerformanceInfo;
    //Added in FB4
    function getInitialID(): Int64;
    function getPreviousID(): Int64;
  end;

  ITraceTransactionImpl = class(ITraceTransaction)
  public
    constructor create;
  protected
    function getTransactionID(): Int64; virtual; abstract;
    function getReadOnly(): Boolean; virtual; abstract;
    function getWait(): Integer; virtual; abstract;
    function getIsolation(): Cardinal; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
    function getInitialID(): Int64; virtual; abstract;
    function getPreviousID(): Int64; virtual; abstract;
  end;

  TraceParamsVTable = class(VersionedVTable)
  protected
    getCount: ITraceParams_getCountPtr;
    getParam: ITraceParams_getParamPtr;
    getTextUTF8: ITraceParams_getTextUTF8Ptr;
  end;

  ITraceParams = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getCount(): Cardinal;
    function getParam(idx: Cardinal): Pdsc;
    function getTextUTF8(status: IStatus; idx: Cardinal): PAnsiChar;
  end;

  ITraceParamsImpl = class(ITraceParams)
  public
    constructor create;
  protected
    function getCount(): Cardinal; virtual; abstract;
    function getParam(idx: Cardinal): Pdsc; virtual; abstract;
    function getTextUTF8(status: IStatus; idx: Cardinal): PAnsiChar; virtual; abstract;
  end;

  TraceStatementVTable = class(VersionedVTable)
  protected
    getStmtID: ITraceStatement_getStmtIDPtr;
    getPerf: ITraceStatement_getPerfPtr;
  end;

  ITraceStatement = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getStmtID(): Int64;
    function getPerf(): PPerformanceInfo;
  end;

  ITraceStatementImpl = class(ITraceStatement)
  public
    constructor create;
  protected
    function getStmtID(): Int64; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
  end;

  TraceSQLStatementVTable = class(TraceStatementVTable)
  protected
    getText: ITraceSQLStatement_getTextPtr;
    getPlan: ITraceSQLStatement_getPlanPtr;
    getInputs: ITraceSQLStatement_getInputsPtr;
    getTextUTF8: ITraceSQLStatement_getTextUTF8Ptr;
    getExplainedPlan: ITraceSQLStatement_getExplainedPlanPtr;
  end;

  ITraceSQLStatement = class(ITraceStatement)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getText(): PAnsiChar;
    function getPlan(): PAnsiChar;
    function getInputs(): ITraceParams;
    function getTextUTF8(): PAnsiChar;
    function getExplainedPlan(): PAnsiChar;
  end;

  ITraceSQLStatementImpl = class(ITraceSQLStatement)
  public
    constructor create;
  protected
    function getStmtID(): Int64; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
    function getText(): PAnsiChar; virtual; abstract;
    function getPlan(): PAnsiChar; virtual; abstract;
    function getInputs(): ITraceParams; virtual; abstract;
    function getTextUTF8(): PAnsiChar; virtual; abstract;
    function getExplainedPlan(): PAnsiChar; virtual; abstract;
  end;

  TraceBLRStatementVTable = class(TraceStatementVTable)
  protected
    getData: ITraceBLRStatement_getDataPtr;
    getDataLength: ITraceBLRStatement_getDataLengthPtr;
    getText: ITraceBLRStatement_getTextPtr;
  end;

  ITraceBLRStatement = class(ITraceStatement)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getData(): PByte;
    function getDataLength(): Cardinal;
    function getText(): PAnsiChar;
  end;

  ITraceBLRStatementImpl = class(ITraceBLRStatement)
  public
    constructor create;
  protected
    function getStmtID(): Int64; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
    function getData(): PByte; virtual; abstract;
    function getDataLength(): Cardinal; virtual; abstract;
    function getText(): PAnsiChar; virtual; abstract;
  end;

  TraceDYNRequestVTable = class(VersionedVTable)
  protected
    getData: ITraceDYNRequest_getDataPtr;
    getDataLength: ITraceDYNRequest_getDataLengthPtr;
    getText: ITraceDYNRequest_getTextPtr;
  end;

  ITraceDYNRequest = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getData(): PByte;
    function getDataLength(): Cardinal;
    function getText(): PAnsiChar;
  end;

  ITraceDYNRequestImpl = class(ITraceDYNRequest)
  public
    constructor create;
  protected
    function getData(): PByte; virtual; abstract;
    function getDataLength(): Cardinal; virtual; abstract;
    function getText(): PAnsiChar; virtual; abstract;
  end;

  TraceContextVariableVTable = class(VersionedVTable)
  protected
    getNameSpace: ITraceContextVariable_getNameSpacePtr;
    getVarName: ITraceContextVariable_getVarNamePtr;
    getVarValue: ITraceContextVariable_getVarValuePtr;
  end;

  ITraceContextVariable = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getNameSpace(): PAnsiChar;
    function getVarName(): PAnsiChar;
    function getVarValue(): PAnsiChar;
  end;

  ITraceContextVariableImpl = class(ITraceContextVariable)
  public
    constructor create;
  protected
    function getNameSpace(): PAnsiChar; virtual; abstract;
    function getVarName(): PAnsiChar; virtual; abstract;
    function getVarValue(): PAnsiChar; virtual; abstract;
  end;

  TraceProcedureVTable = class(VersionedVTable)
  protected
    getProcName: ITraceProcedure_getProcNamePtr;
    getInputs: ITraceProcedure_getInputsPtr;
    getPerf: ITraceProcedure_getPerfPtr;
  end;

  ITraceProcedure = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getProcName(): PAnsiChar;
    function getInputs(): ITraceParams;
    function getPerf(): PPerformanceInfo;
  end;

  ITraceProcedureImpl = class(ITraceProcedure)
  public
    constructor create;
  protected
    function getProcName(): PAnsiChar; virtual; abstract;
    function getInputs(): ITraceParams; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
  end;

  TraceFunctionVTable = class(VersionedVTable)
  protected
    getFuncName: ITraceFunction_getFuncNamePtr;
    getInputs: ITraceFunction_getInputsPtr;
    getResult: ITraceFunction_getResultPtr;
    getPerf: ITraceFunction_getPerfPtr;
  end;

  ITraceFunction = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getFuncName(): PAnsiChar;
    function getInputs(): ITraceParams;
    function getResult(): ITraceParams;
    function getPerf(): PPerformanceInfo;
  end;

  ITraceFunctionImpl = class(ITraceFunction)
  public
    constructor create;
  protected
    function getFuncName(): PAnsiChar; virtual; abstract;
    function getInputs(): ITraceParams; virtual; abstract;
    function getResult(): ITraceParams; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
  end;

  TraceTriggerVTable = class(VersionedVTable)
  protected
    getTriggerName: ITraceTrigger_getTriggerNamePtr;
    getRelationName: ITraceTrigger_getRelationNamePtr;
    getAction: ITraceTrigger_getActionPtr;
    getWhich: ITraceTrigger_getWhichPtr;
    getPerf: ITraceTrigger_getPerfPtr;
  end;

  ITraceTrigger = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const TYPE_ALL = Cardinal(0);
    const TYPE_BEFORE = Cardinal(1);
    const TYPE_AFTER = Cardinal(2);
    {$ENDIF WITH_CLASS_CONST}
    function getTriggerName(): PAnsiChar;
    function getRelationName(): PAnsiChar;
    function getAction(): Integer;
    function getWhich(): Integer;
    function getPerf(): PPerformanceInfo;
  end;

  ITraceTriggerImpl = class(ITraceTrigger)
  public
    constructor create;
  protected
    function getTriggerName(): PAnsiChar; virtual; abstract;
    function getRelationName(): PAnsiChar; virtual; abstract;
    function getAction(): Integer; virtual; abstract;
    function getWhich(): Integer; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
  end;

  TraceServiceConnectionVTable = class(TraceConnectionVTable)
  protected
    getServiceID: ITraceServiceConnection_getServiceIDPtr;
    getServiceMgr: ITraceServiceConnection_getServiceMgrPtr;
    getServiceName: ITraceServiceConnection_getServiceNamePtr;
  end;

  ITraceServiceConnection = class(ITraceConnection)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    function getServiceID(): Pointer;
    function getServiceMgr(): PAnsiChar;
    function getServiceName(): PAnsiChar;
  end;

  ITraceServiceConnectionImpl = class(ITraceServiceConnection)
  public
    constructor create;
  protected
    function getKind(): Cardinal; virtual; abstract;
    function getProcessID(): Integer; virtual; abstract;
    function getUserName(): PAnsiChar; virtual; abstract;
    function getRoleName(): PAnsiChar; virtual; abstract;
    function getCharSet(): PAnsiChar; virtual; abstract;
    function getRemoteProtocol(): PAnsiChar; virtual; abstract;
    function getRemoteAddress(): PAnsiChar; virtual; abstract;
    function getRemoteProcessID(): Integer; virtual; abstract;
    function getRemoteProcessName(): PAnsiChar; virtual; abstract;
    function getServiceID(): Pointer; virtual; abstract;
    function getServiceMgr(): PAnsiChar; virtual; abstract;
    function getServiceName(): PAnsiChar; virtual; abstract;
  end;

  TraceStatusVectorVTable = class(VersionedVTable)
  protected
    hasError: ITraceStatusVector_hasErrorPtr;
    hasWarning: ITraceStatusVector_hasWarningPtr;
    getStatus: ITraceStatusVector_getStatusPtr;
    getText: ITraceStatusVector_getTextPtr;
  end;

  ITraceStatusVector = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function hasError(): Boolean;
    function hasWarning(): Boolean;
    function getStatus(): IStatus;
    function getText(): PAnsiChar;
  end;

  ITraceStatusVectorImpl = class(ITraceStatusVector)
  public
    constructor create;
  protected
    function hasError(): Boolean; virtual; abstract;
    function hasWarning(): Boolean; virtual; abstract;
    function getStatus(): IStatus; virtual; abstract;
    function getText(): PAnsiChar; virtual; abstract;
  end;

  TraceSweepInfoVTable = class(VersionedVTable)
  protected
    getOIT: ITraceSweepInfo_getOITPtr;
    getOST: ITraceSweepInfo_getOSTPtr;
    getOAT: ITraceSweepInfo_getOATPtr;
    getNext: ITraceSweepInfo_getNextPtr;
    getPerf: ITraceSweepInfo_getPerfPtr;
  end;

  ITraceSweepInfo = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getOIT(): Int64;
    function getOST(): Int64;
    function getOAT(): Int64;
    function getNext(): Int64;
    function getPerf(): PPerformanceInfo;
  end;

  ITraceSweepInfoImpl = class(ITraceSweepInfo)
  public
    constructor create;
  protected
    function getOIT(): Int64; virtual; abstract;
    function getOST(): Int64; virtual; abstract;
    function getOAT(): Int64; virtual; abstract;
    function getNext(): Int64; virtual; abstract;
    function getPerf(): PPerformanceInfo; virtual; abstract;
  end;

  TraceLogWriterVTable = class(ReferenceCountedVTable)
  protected
    write: ITraceLogWriter_writePtr;
    write_s: ITraceLogWriter_write_sPtr;
  end;

  ITraceLogWriter = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    function write(buf: Pointer; size: Cardinal): Cardinal;
    //added in FB4
    function write_s(status: IStatus; buf: Pointer; size: Cardinal): Cardinal;
  end;

  ITraceLogWriterImpl = class(ITraceLogWriter)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function write(buf: Pointer; size: Cardinal): Cardinal; virtual; abstract;
    function write_s(status: IStatus; buf: Pointer; size: Cardinal): Cardinal; virtual; abstract;
  end;

  TraceInitInfoVTable = class(VersionedVTable)
  protected
    getConfigText: ITraceInitInfo_getConfigTextPtr;
    getTraceSessionID: ITraceInitInfo_getTraceSessionIDPtr;
    getTraceSessionName: ITraceInitInfo_getTraceSessionNamePtr;
    getFirebirdRootDirectory: ITraceInitInfo_getFirebirdRootDirectoryPtr;
    getDatabaseName: ITraceInitInfo_getDatabaseNamePtr;
    getConnection: ITraceInitInfo_getConnectionPtr;
    getLogWriter: ITraceInitInfo_getLogWriterPtr;
  end;

  ITraceInitInfo = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getConfigText(): PAnsiChar;
    function getTraceSessionID(): Integer;
    function getTraceSessionName(): PAnsiChar;
    function getFirebirdRootDirectory(): PAnsiChar;
    function getDatabaseName(): PAnsiChar;
    function getConnection(): ITraceDatabaseConnection;
    function getLogWriter(): ITraceLogWriter;
  end;

  ITraceInitInfoImpl = class(ITraceInitInfo)
  public
    constructor create;
  protected
    function getConfigText(): PAnsiChar; virtual; abstract;
    function getTraceSessionID(): Integer; virtual; abstract;
    function getTraceSessionName(): PAnsiChar; virtual; abstract;
    function getFirebirdRootDirectory(): PAnsiChar; virtual; abstract;
    function getDatabaseName(): PAnsiChar; virtual; abstract;
    function getConnection(): ITraceDatabaseConnection; virtual; abstract;
    function getLogWriter(): ITraceLogWriter; virtual; abstract;
  end;

  TracePluginVTable = class(ReferenceCountedVTable)
  protected
    trace_get_error: ITracePlugin_trace_get_errorPtr;
    trace_attach: ITracePlugin_trace_attachPtr;
    trace_detach: ITracePlugin_trace_detachPtr;
    trace_transaction_start: ITracePlugin_trace_transaction_startPtr;
    trace_transaction_end: ITracePlugin_trace_transaction_endPtr;
    trace_proc_execute: ITracePlugin_trace_proc_executePtr;
    trace_trigger_execute: ITracePlugin_trace_trigger_executePtr;
    trace_set_context: ITracePlugin_trace_set_contextPtr;
    trace_dsql_prepare: ITracePlugin_trace_dsql_preparePtr;
    trace_dsql_free: ITracePlugin_trace_dsql_freePtr;
    trace_dsql_execute: ITracePlugin_trace_dsql_executePtr;
    trace_blr_compile: ITracePlugin_trace_blr_compilePtr;
    trace_blr_execute: ITracePlugin_trace_blr_executePtr;
    trace_dyn_execute: ITracePlugin_trace_dyn_executePtr;
    trace_service_attach: ITracePlugin_trace_service_attachPtr;
    trace_service_start: ITracePlugin_trace_service_startPtr;
    trace_service_query: ITracePlugin_trace_service_queryPtr;
    trace_service_detach: ITracePlugin_trace_service_detachPtr;
    trace_event_error: ITracePlugin_trace_event_errorPtr;
    trace_event_sweep: ITracePlugin_trace_event_sweepPtr;
    trace_func_execute: ITracePlugin_trace_func_executePtr;
  end;

  ITracePlugin = class(IReferenceCounted)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    const RESULT_SUCCESS = Cardinal(0);
    const RESULT_FAILED = Cardinal(1);
    const RESULT_UNAUTHORIZED = Cardinal(2);
    const SWEEP_STATE_STARTED = Cardinal(1);
    const SWEEP_STATE_FINISHED = Cardinal(2);
    const SWEEP_STATE_FAILED = Cardinal(3);
    const SWEEP_STATE_PROGRESS = Cardinal(4);
    {$ENDIF WITH_CLASS_CONST}
    function trace_get_error(): PAnsiChar;
    function trace_attach(connection: ITraceDatabaseConnection; create_db: Boolean; att_result: Cardinal): Boolean;
    function trace_detach(connection: ITraceDatabaseConnection; drop_db: Boolean): Boolean;
    function trace_transaction_start(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; tpb_length: Cardinal; tpb: PByte; tra_result: Cardinal): Boolean;
    function trace_transaction_end(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; commit: Boolean; retain_context: Boolean; tra_result: Cardinal): Boolean;
    function trace_proc_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; procedure_: ITraceProcedure; started: Boolean; proc_result: Cardinal): Boolean;
    function trace_trigger_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; trigger: ITraceTrigger; started: Boolean; trig_result: Cardinal): Boolean;
    function trace_set_context(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; variable: ITraceContextVariable): Boolean;
    function trace_dsql_prepare(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; time_millis: Int64; req_result: Cardinal): Boolean;
    function trace_dsql_free(connection: ITraceDatabaseConnection; statement: ITraceSQLStatement; option: Cardinal): Boolean;
    function trace_dsql_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; started: Boolean; req_result: Cardinal): Boolean;
    function trace_blr_compile(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; time_millis: Int64; req_result: Cardinal): Boolean;
    function trace_blr_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; req_result: Cardinal): Boolean;
    function trace_dyn_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; request: ITraceDYNRequest; time_millis: Int64; req_result: Cardinal): Boolean;
    function trace_service_attach(service: ITraceServiceConnection; att_result: Cardinal): Boolean;
    function trace_service_start(service: ITraceServiceConnection; switches_length: Cardinal; switches: PAnsiChar; start_result: Cardinal): Boolean;
    function trace_service_query(service: ITraceServiceConnection; send_item_length: Cardinal; send_items: PByte; recv_item_length: Cardinal; recv_items: PByte; query_result: Cardinal): Boolean;
    function trace_service_detach(service: ITraceServiceConnection; detach_result: Cardinal): Boolean;
    function trace_event_error(connection: ITraceConnection; status: ITraceStatusVector; function_: PAnsiChar): Boolean;
    function trace_event_sweep(connection: ITraceDatabaseConnection; sweep: ITraceSweepInfo; sweep_state: Cardinal): Boolean;
    function trace_func_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; function_: ITraceFunction; started: Boolean; func_result: Cardinal): Boolean;
  end;

  ITracePluginImpl = class(ITracePlugin)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    function trace_get_error(): PAnsiChar; virtual; abstract;
    function trace_attach(connection: ITraceDatabaseConnection; create_db: Boolean; att_result: Cardinal): Boolean; virtual; abstract;
    function trace_detach(connection: ITraceDatabaseConnection; drop_db: Boolean): Boolean; virtual; abstract;
    function trace_transaction_start(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; tpb_length: Cardinal; tpb: PByte; tra_result: Cardinal): Boolean; virtual; abstract;
    function trace_transaction_end(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; commit: Boolean; retain_context: Boolean; tra_result: Cardinal): Boolean; virtual; abstract;
    function trace_proc_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; procedure_: ITraceProcedure; started: Boolean; proc_result: Cardinal): Boolean; virtual; abstract;
    function trace_trigger_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; trigger: ITraceTrigger; started: Boolean; trig_result: Cardinal): Boolean; virtual; abstract;
    function trace_set_context(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; variable: ITraceContextVariable): Boolean; virtual; abstract;
    function trace_dsql_prepare(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; time_millis: Int64; req_result: Cardinal): Boolean; virtual; abstract;
    function trace_dsql_free(connection: ITraceDatabaseConnection; statement: ITraceSQLStatement; option: Cardinal): Boolean; virtual; abstract;
    function trace_dsql_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; started: Boolean; req_result: Cardinal): Boolean; virtual; abstract;
    function trace_blr_compile(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; time_millis: Int64; req_result: Cardinal): Boolean; virtual; abstract;
    function trace_blr_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; req_result: Cardinal): Boolean; virtual; abstract;
    function trace_dyn_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; request: ITraceDYNRequest; time_millis: Int64; req_result: Cardinal): Boolean; virtual; abstract;
    function trace_service_attach(service: ITraceServiceConnection; att_result: Cardinal): Boolean; virtual; abstract;
    function trace_service_start(service: ITraceServiceConnection; switches_length: Cardinal; switches: PAnsiChar; start_result: Cardinal): Boolean; virtual; abstract;
    function trace_service_query(service: ITraceServiceConnection; send_item_length: Cardinal; send_items: PByte; recv_item_length: Cardinal; recv_items: PByte; query_result: Cardinal): Boolean; virtual; abstract;
    function trace_service_detach(service: ITraceServiceConnection; detach_result: Cardinal): Boolean; virtual; abstract;
    function trace_event_error(connection: ITraceConnection; status: ITraceStatusVector; function_: PAnsiChar): Boolean; virtual; abstract;
    function trace_event_sweep(connection: ITraceDatabaseConnection; sweep: ITraceSweepInfo; sweep_state: Cardinal): Boolean; virtual; abstract;
    function trace_func_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; function_: ITraceFunction; started: Boolean; func_result: Cardinal): Boolean; virtual; abstract;
  end;

  TraceFactoryVTable = class(PluginBaseVTable)
  protected
    trace_needs: ITraceFactory_trace_needsPtr;
    trace_create: ITraceFactory_trace_createPtr;
  end;

  ITraceFactory = class(IPluginBase)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    const TRACE_EVENT_ATTACH = Cardinal(0);
    const TRACE_EVENT_DETACH = Cardinal(1);
    const TRACE_EVENT_TRANSACTION_START = Cardinal(2);
    const TRACE_EVENT_TRANSACTION_END = Cardinal(3);
    const TRACE_EVENT_SET_CONTEXT = Cardinal(4);
    const TRACE_EVENT_PROC_EXECUTE = Cardinal(5);
    const TRACE_EVENT_TRIGGER_EXECUTE = Cardinal(6);
    const TRACE_EVENT_DSQL_PREPARE = Cardinal(7);
    const TRACE_EVENT_DSQL_FREE = Cardinal(8);
    const TRACE_EVENT_DSQL_EXECUTE = Cardinal(9);
    const TRACE_EVENT_BLR_COMPILE = Cardinal(10);
    const TRACE_EVENT_BLR_EXECUTE = Cardinal(11);
    const TRACE_EVENT_DYN_EXECUTE = Cardinal(12);
    const TRACE_EVENT_SERVICE_ATTACH = Cardinal(13);
    const TRACE_EVENT_SERVICE_START = Cardinal(14);
    const TRACE_EVENT_SERVICE_QUERY = Cardinal(15);
    const TRACE_EVENT_SERVICE_DETACH = Cardinal(16);
    const TRACE_EVENT_ERROR = Cardinal(17);
    const TRACE_EVENT_SWEEP = Cardinal(18);
    const TRACE_EVENT_FUNC_EXECUTE = Cardinal(19);
    const TRACE_EVENT_MAX = Cardinal(20);
    {$ENDIF WITH_CLASS_CONST}
    function trace_needs(): UInt64;
    function trace_create(status: IStatus; init_info: ITraceInitInfo): ITracePlugin;
  end;

  ITraceFactoryImpl = class(ITraceFactory)
  public
    constructor create;
  protected
    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    function trace_needs(): UInt64; virtual; abstract;
    function trace_create(status: IStatus; init_info: ITraceInitInfo): ITracePlugin; virtual; abstract;
  end;

  UdrFunctionFactoryVTable = class(DisposableVTable)
  protected
    setup: IUdrFunctionFactory_setupPtr;
    newItem: IUdrFunctionFactory_newItemPtr;
  end;

  IUdrFunctionFactory = class(IDisposable)
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder);
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalFunction;
  end;

  IUdrFunctionFactoryImpl = class(IUdrFunctionFactory)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); virtual; abstract;
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalFunction; virtual; abstract;
  end;

  UdrProcedureFactoryVTable = class(DisposableVTable)
  protected
    setup: IUdrProcedureFactory_setupPtr;
    newItem: IUdrProcedureFactory_newItemPtr;
  end;

  IUdrProcedureFactory = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder);
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalProcedure;
  end;

  IUdrProcedureFactoryImpl = class(IUdrProcedureFactory)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); virtual; abstract;
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalProcedure; virtual; abstract;
  end;

  UdrTriggerFactoryVTable = class(DisposableVTable)
  protected
    setup: IUdrTriggerFactory_setupPtr;
    newItem: IUdrTriggerFactory_newItemPtr;
  end;

  IUdrTriggerFactory = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder);
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalTrigger;
  end;

  IUdrTriggerFactoryImpl = class(IUdrTriggerFactory)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder); virtual; abstract;
    function newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalTrigger; virtual; abstract;
  end;

  UdrPluginVTable = class(VersionedVTable)
  protected
    getMaster: IUdrPlugin_getMasterPtr;
    registerFunction: IUdrPlugin_registerFunctionPtr;
    registerProcedure: IUdrPlugin_registerProcedurePtr;
    registerTrigger: IUdrPlugin_registerTriggerPtr;
  end;

  IUdrPlugin = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getMaster(): IMaster;
    procedure registerFunction(status: IStatus; name: PAnsiChar; factory: IUdrFunctionFactory);
    procedure registerProcedure(status: IStatus; name: PAnsiChar; factory: IUdrProcedureFactory);
    procedure registerTrigger(status: IStatus; name: PAnsiChar; factory: IUdrTriggerFactory);
  end;

  IUdrPluginImpl = class(IUdrPlugin)
  public
    constructor create;
  protected
    function getMaster(): IMaster; virtual; abstract;
    procedure registerFunction(status: IStatus; name: PAnsiChar; factory: IUdrFunctionFactory); virtual; abstract;
    procedure registerProcedure(status: IStatus; name: PAnsiChar; factory: IUdrProcedureFactory); virtual; abstract;
    procedure registerTrigger(status: IStatus; name: PAnsiChar; factory: IUdrTriggerFactory); virtual; abstract;
  end;

  DecFloat16VTable = class(VersionedVTable)
  protected
    toBcd: IDecFloat16_toBcdPtr;
    toString: IDecFloat16_toStringPtr;
    fromBcd: IDecFloat16_fromBcdPtr;
    fromString: IDecFloat16_fromStringPtr;
  end;

  IDecFloat16 = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const BCD_SIZE = Cardinal(16);
    const STRING_SIZE = Cardinal(24);
    {$ENDIF WITH_CLASS_CONST}
    procedure toBcd(from: PFB_DEC16; sign: PInteger; bcd: PByte; exp: PInteger);
    procedure toString(status: IStatus; from: PFB_DEC16; bufferLength: Cardinal; buffer: PAnsiChar); reintroduce;
    procedure fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC16);
    procedure fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC16);
  end;

  IDecFloat16Impl = class(IDecFloat16)
  public
    constructor create;
  protected
    procedure toBcd(from: PFB_DEC16; sign: PInteger; bcd: PByte; exp: PInteger); virtual; abstract;
    procedure toString(status: IStatus; from: PFB_DEC16; bufferLength: Cardinal; buffer: PAnsiChar); virtual; abstract;
    procedure fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC16); virtual; abstract;
    procedure fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC16); virtual; abstract;
  end;

  DecFloat34VTable = class(VersionedVTable)
  protected
    toBcd: IDecFloat34_toBcdPtr;
    toString: IDecFloat34_toStringPtr;
    fromBcd: IDecFloat34_fromBcdPtr;
    fromString: IDecFloat34_fromStringPtr;
  end;

  IDecFloat34 = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const BCD_SIZE = Cardinal(34);
    const STRING_SIZE = Cardinal(43);
    {$ENDIF WITH_CLASS_CONST}
    procedure toBcd(from: PFB_DEC34; sign: PInteger; bcd: PByte; exp: PInteger);
    procedure toString(status: IStatus; from: PFB_DEC34; bufferLength: Cardinal; buffer: PAnsiChar); reintroduce;
    procedure fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC34);
    procedure fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC34);
  end;

  IDecFloat34Impl = class(IDecFloat34)
  public
    constructor create;
  protected
    procedure toBcd(from: PFB_DEC34; sign: PInteger; bcd: PByte; exp: PInteger); virtual; abstract;
    procedure toString(status: IStatus; from: PFB_DEC34; bufferLength: Cardinal; buffer: PAnsiChar); virtual; abstract;
    procedure fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC34); virtual; abstract;
    procedure fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC34); virtual; abstract;
  end;

  Int128VTable = class(VersionedVTable)
  protected
    toString: IInt128_toStringPtr;
    fromString: IInt128_fromStringPtr;
  end;

  IInt128 = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    const STRING_SIZE = Cardinal(46);
    {$ENDIF WITH_CLASS_CONST}
    procedure toString(status: IStatus; from: PFB_I128; scale: Integer; bufferLength: Cardinal; buffer: PAnsiChar); reintroduce;
    procedure fromString(status: IStatus; scale: Integer; from: PAnsiChar; to_: PFB_I128);
  end;

  IInt128Impl = class(IInt128)
  public
    constructor create;
  protected
    procedure toString(status: IStatus; from: PFB_I128; scale: Integer; bufferLength: Cardinal; buffer: PAnsiChar); virtual; abstract;
    procedure fromString(status: IStatus; scale: Integer; from: PAnsiChar; to_: PFB_I128); virtual; abstract;
  end;

  ReplicatedFieldVTable = class(VersionedVTable)
    getName: IReplicatedField_getNamePtr;
    getType: IReplicatedField_getTypePtr;
    getSubType: IReplicatedField_getSubTypePtr;
    getScale: IReplicatedField_getScalePtr;
    getLength: IReplicatedField_getLengthPtr;
    getCharSet: IReplicatedField_getCharSetPtr;
    getData: IReplicatedField_getDataPtr;
  end;

  IReplicatedField = class(IVersioned)
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getName(): PAnsiChar;
    function getType(): Cardinal;
    function getSubType(): Integer;
    function getScale(): Integer;
    function getLength(): Cardinal;
    function getCharSet(): Cardinal;
    function getData(): Pointer;
  end;

  IReplicatedFieldImpl = class(IReplicatedField)
    constructor create;

    function getName(): PAnsiChar; virtual; abstract;
    function getType(): Cardinal; virtual; abstract;
    function getSubType(): Integer; virtual; abstract;
    function getScale(): Integer; virtual; abstract;
    function getLength(): Cardinal; virtual; abstract;
    function getCharSet(): Cardinal; virtual; abstract;
    function getData(): Pointer; virtual; abstract;
  end;

  ReplicatedRecordVTable = class(VersionedVTable)
  protected
    getCount: IReplicatedRecord_getCountPtr;
    getField: IReplicatedRecord_getFieldPtr;
    getRawLength: IReplicatedRecord_getRawLengthPtr;
    getRawData: IReplicatedRecord_getRawDataPtr;
  end;

  IReplicatedRecord = class(IVersioned)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 2;
    {$ENDIF WITH_CLASS_CONST}
    function getCount(): Cardinal;
    function getField(index: Cardinal): IReplicatedField;
    function getRawLength(): Cardinal;
    function getRawData(): PByte;
  end;

  IReplicatedRecordImpl = class(IReplicatedRecord)
  public
    constructor create;
  protected
    function getCount(): Cardinal; virtual; abstract;
    function getField(index: Cardinal): IReplicatedField; virtual; abstract;
    function getRawLength(): Cardinal; virtual; abstract;
    function getRawData(): PByte; virtual; abstract;
  end;

  ReplicatedTransactionVTable = class(DisposableVTable)
  protected
    prepare: IReplicatedTransaction_preparePtr;
    commit: IReplicatedTransaction_commitPtr;
    rollback: IReplicatedTransaction_rollbackPtr;
    startSavepoint: IReplicatedTransaction_startSavepointPtr;
    releaseSavepoint: IReplicatedTransaction_releaseSavepointPtr;
    rollbackSavepoint: IReplicatedTransaction_rollbackSavepointPtr;
    insertRecord: IReplicatedTransaction_insertRecordPtr;
    updateRecord: IReplicatedTransaction_updateRecordPtr;
    deleteRecord: IReplicatedTransaction_deleteRecordPtr;
    executeSql: IReplicatedTransaction_executeSqlPtr;
    executeSqlIntl: IReplicatedTransaction_executeSqlIntlPtr;
  end;

  IReplicatedTransaction = class(IDisposable)
  public
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 3;
    {$ENDIF WITH_CLASS_CONST}
    procedure prepare(status: IStatus);
    procedure commit(status: IStatus);
    procedure rollback(status: IStatus);
    procedure startSavepoint(status: IStatus);
    procedure releaseSavepoint(status: IStatus);
    procedure rollbackSavepoint(status: IStatus);
    procedure insertRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord);
    procedure updateRecord(status: IStatus; name: PAnsiChar; orgRecord: IReplicatedRecord; newRecord: IReplicatedRecord);
    procedure deleteRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord);
    procedure executeSql(status: IStatus; sql: PAnsiChar);
    procedure executeSqlIntl(status: IStatus; charset: Cardinal; sql: PAnsiChar);
  end;

  IReplicatedTransactionImpl = class(IReplicatedTransaction)
  public
    constructor create;
  protected
    procedure dispose(); virtual; abstract;
    procedure prepare(status: IStatus); virtual; abstract;
    procedure commit(status: IStatus); virtual; abstract;
    procedure rollback(status: IStatus); virtual; abstract;
    procedure startSavepoint(status: IStatus); virtual; abstract;
    procedure releaseSavepoint(status: IStatus); virtual; abstract;
    procedure rollbackSavepoint(status: IStatus); virtual; abstract;
    procedure insertRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); virtual; abstract;
    procedure updateRecord(status: IStatus; name: PAnsiChar; orgRecord: IReplicatedRecord; newRecord: IReplicatedRecord); virtual; abstract;
    procedure deleteRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); virtual; abstract;
    procedure executeSql(status: IStatus; sql: PAnsiChar); virtual; abstract;
    procedure executeSqlIntl(status: IStatus; charset: Cardinal; sql: PAnsiChar); virtual; abstract;
  end;

  ReplicatedSessionVTable = class(PluginBaseVTable)
    setAttachment: IReplicatedSession_setAttachmentPtr;
    startTransaction: IReplicatedSession_startTransactionPtr;
    cleanupTransaction: IReplicatedSession_cleanupTransactionPtr;
    setSequence: IReplicatedSession_setSequencePtr;
  end;

  IReplicatedSession = class(IPluginBase)
    {$IFDEF WITH_CLASS_CONST}
    const VERSION = 4;
    {$ENDIF WITH_CLASS_CONST}
    procedure setAttachment(attachment: IAttachment);
    function startTransaction(status: IStatus; transaction: ITransaction; number: Int64): IReplicatedTransaction;
    procedure cleanupTransaction(status: IStatus; number: Int64);
    procedure setSequence(status: IStatus; name: PAnsiChar; value: Int64);
  end;

  IReplicatedSessionImpl = class(IReplicatedSession)
    constructor create;

    procedure addRef(); virtual; abstract;
    function release(): Integer; virtual; abstract;
    procedure setOwner(r: IReferenceCounted); virtual; abstract;
    function getOwner(): IReferenceCounted; virtual; abstract;
    procedure setAttachment(attachment: IAttachment); virtual; abstract;
    function startTransaction(status: IStatus; transaction: ITransaction; number: Int64): IReplicatedTransaction; virtual; abstract;
    procedure cleanupTransaction(status: IStatus; number: Int64); virtual; abstract;
    procedure setSequence(status: IStatus; name: PAnsiChar; value: Int64); virtual; abstract;
  end;

  //function fb_get_master_interface : IMaster; cdecl; external 'fbclient';

const
  RDB_system = byte(1);
  RDB_id_assigned = byte(2);

implementation

const IntfErrors: array[0..2] of NativeInt = (isc_ib_error, isc_interface_version_too_old, isc_arg_end);

procedure SetIntfToOldVersionError(status: IStatus);
begin
  Status.setErrors2(2, @IntfErrors[0]);
end;

procedure IReferenceCounted.addRef();
begin
  ReferenceCountedVTable(vTable).addRef(Self);
end;

function IReferenceCounted.release(): Integer;
begin
  Result := ReferenceCountedVTable(vTable).release(Self);
end;

procedure IDisposable.dispose();
begin
  DisposableVTable(vTable).dispose(Self);
end;

procedure IStatus.init();
begin
  StatusVTable(vTable).init(Self);
end;

function IStatus.getState(): Cardinal;
begin
  Result := StatusVTable(vTable).getState(Self);
end;

procedure IStatus.setErrors2(length: Cardinal; value: PNativeInt);
begin
  StatusVTable(vTable).setErrors2(Self, length, value);
end;

procedure IStatus.setWarnings2(length: Cardinal; value: PNativeInt);
begin
  StatusVTable(vTable).setWarnings2(Self, length, value);
end;

procedure IStatus.setErrors(value: PNativeInt);
begin
  StatusVTable(vTable).setErrors(Self, value);
end;

procedure IStatus.setWarnings(value: PNativeInt);
begin
  StatusVTable(vTable).setWarnings(Self, value);
end;

function IStatus.getErrors(): PNativeInt;
begin
  Result := StatusVTable(vTable).getErrors(Self);
end;

function IStatus.getWarnings(): PNativeInt;
begin
  Result := StatusVTable(vTable).getWarnings(Self);
end;

function IStatus.clone(): IStatus;
begin
  Result := StatusVTable(vTable).clone(Self);
end;

function IMaster.getStatus(): IStatus;
begin
  Result := MasterVTable(vTable).getStatus(Self);
end;

function IMaster.getDispatcher(): IProvider;
begin
  Result := MasterVTable(vTable).getDispatcher(Self);
end;

function IMaster.getPluginManager(): IPluginManager;
begin
  Result := MasterVTable(vTable).getPluginManager(Self);
end;

function IMaster.getTimerControl(): ITimerControl;
begin
  Result := MasterVTable(vTable).getTimerControl(Self);
end;

function IMaster.getDtc(): IDtc;
begin
  Result := MasterVTable(vTable).getDtc(Self);
end;

function IMaster.registerAttachment(provider: IProvider; attachment: IAttachment): IAttachment;
begin
  Result := MasterVTable(vTable).registerAttachment(Self, provider, attachment);
end;

function IMaster.registerTransaction(attachment: IAttachment; transaction: ITransaction): ITransaction;
begin
  Result := MasterVTable(vTable).registerTransaction(Self, attachment, transaction);
end;

function IMaster.getMetadataBuilder(status: IStatus; fieldCount: Cardinal): IMetadataBuilder;
begin
  Result := MasterVTable(vTable).getMetadataBuilder(Self, status, fieldCount);
end;

function IMaster.serverMode(mode: Integer): Integer;
begin
  Result := MasterVTable(vTable).serverMode(Self, mode);
end;

function IMaster.getUtilInterface(): IUtil;
begin
  Result := MasterVTable(vTable).getUtilInterface(Self);
end;

function IMaster.getConfigManager(): IConfigManager;
begin
  Result := MasterVTable(vTable).getConfigManager(Self);
end;

function IMaster.getProcessExiting(): Boolean;
begin
  Result := MasterVTable(vTable).getProcessExiting(Self);
end;

procedure IPluginBase.setOwner(r: IReferenceCounted);
begin
  PluginBaseVTable(vTable).setOwner(Self, r);
end;

function IPluginBase.getOwner(): IReferenceCounted;
begin
  Result := PluginBaseVTable(vTable).getOwner(Self);
end;

function IPluginSet.getName(): PAnsiChar;
begin
  Result := PluginSetVTable(vTable).getName(Self);
end;

function IPluginSet.getModuleName(): PAnsiChar;
begin
  Result := PluginSetVTable(vTable).getModuleName(Self);
end;

function IPluginSet.getPlugin(status: IStatus): IPluginBase;
begin
  Result := PluginSetVTable(vTable).getPlugin(Self, status);
end;

procedure IPluginSet.next(status: IStatus);
begin
  PluginSetVTable(vTable).next(Self, status);
end;

procedure IPluginSet.set_(status: IStatus; s: PAnsiChar);
begin
  PluginSetVTable(vTable).set_(Self, status, s);
end;

function IConfigEntry.getName(): PAnsiChar;
begin
  Result := ConfigEntryVTable(vTable).getName(Self);
end;

function IConfigEntry.getValue(): PAnsiChar;
begin
  Result := ConfigEntryVTable(vTable).getValue(Self);
end;

function IConfigEntry.getIntValue(): Int64;
begin
  Result := ConfigEntryVTable(vTable).getIntValue(Self);
end;

function IConfigEntry.getBoolValue(): Boolean;
begin
  Result := ConfigEntryVTable(vTable).getBoolValue(Self);
end;

function IConfigEntry.getSubConfig(status: IStatus): IConfig;
begin
  Result := ConfigEntryVTable(vTable).getSubConfig(Self, status);
end;

function IConfig.find(status: IStatus; name: PAnsiChar): IConfigEntry;
begin
  Result := ConfigVTable(vTable).find(Self, status, name);
end;

function IConfig.findValue(status: IStatus; name: PAnsiChar; value: PAnsiChar): IConfigEntry;
begin
  Result := ConfigVTable(vTable).findValue(Self, status, name, value);
end;

function IConfig.findPos(status: IStatus; name: PAnsiChar; pos: Cardinal): IConfigEntry;
begin
  Result := ConfigVTable(vTable).findPos(Self, status, name, pos);
end;

function IFirebirdConf.getKey(name: PAnsiChar): Cardinal;
begin
  Result := FirebirdConfVTable(vTable).getKey(Self, name);
end;

function IFirebirdConf.asInteger(key: Cardinal): Int64;
begin
  Result := FirebirdConfVTable(vTable).asInteger(Self, key);
end;

function IFirebirdConf.asString(key: Cardinal): PAnsiChar;
begin
  Result := FirebirdConfVTable(vTable).asString(Self, key);
end;

function IFirebirdConf.asBoolean(key: Cardinal): Boolean;
begin
  Result := FirebirdConfVTable(vTable).asBoolean(Self, key);
end;

function IFirebirdConf.getVersion(status: IStatus): Cardinal;
begin
  Result := FirebirdConfVTable(vTable).getVersion(Self, status);
end;

function IPluginConfig.getConfigFileName(): PAnsiChar;
begin
  Result := PluginConfigVTable(vTable).getConfigFileName(Self);
end;

function IPluginConfig.getDefaultConfig(status: IStatus): IConfig;
begin
  Result := PluginConfigVTable(vTable).getDefaultConfig(Self, status);
end;

function IPluginConfig.getFirebirdConf(status: IStatus): IFirebirdConf;
begin
  Result := PluginConfigVTable(vTable).getFirebirdConf(Self, status);
end;

procedure IPluginConfig.setReleaseDelay(status: IStatus; microSeconds: UInt64);
begin
  PluginConfigVTable(vTable).setReleaseDelay(Self, status, microSeconds);
end;

function IPluginFactory.createPlugin(status: IStatus; factoryParameter: IPluginConfig): IPluginBase;
begin
  Result := PluginFactoryVTable(vTable).createPlugin(Self, status, factoryParameter);
end;

procedure IPluginModule.doClean();
begin
  PluginModuleVTable(vTable).doClean(Self);
end;

procedure IPluginModule.threadDetach();
begin
  if vTable.version >= 3 then //since FB4
    PluginModuleVTable(vTable).threadDetach(Self);
end;

procedure IPluginManager.registerPluginFactory(pluginType: Cardinal; defaultName: PAnsiChar; factory: IPluginFactory);
begin
  PluginManagerVTable(vTable).registerPluginFactory(Self, pluginType, defaultName, factory);
end;

procedure IPluginManager.registerModule(cleanup: IPluginModule);
begin
  PluginManagerVTable(vTable).registerModule(Self, cleanup);
end;

procedure IPluginManager.unregisterModule(cleanup: IPluginModule);
begin
  PluginManagerVTable(vTable).unregisterModule(Self, cleanup);
end;

function IPluginManager.getPlugins(status: IStatus; pluginType: Cardinal; namesList: PAnsiChar; firebirdConf: IFirebirdConf): IPluginSet;
begin
  Result := PluginManagerVTable(vTable).getPlugins(Self, status, pluginType, namesList, firebirdConf);
end;

function IPluginManager.getConfig(status: IStatus; filename: PAnsiChar): IConfig;
begin
  Result := PluginManagerVTable(vTable).getConfig(Self, status, filename);
end;

procedure IPluginManager.releasePlugin(plugin: IPluginBase);
begin
  PluginManagerVTable(vTable).releasePlugin(Self, plugin);
end;

procedure ICryptKey.setSymmetric(status: IStatus; type_: PAnsiChar; keyLength: Cardinal; key: Pointer);
begin
  CryptKeyVTable(vTable).setSymmetric(Self, status, type_, keyLength, key);
end;

procedure ICryptKey.setAsymmetric(status: IStatus; type_: PAnsiChar; encryptKeyLength: Cardinal; encryptKey: Pointer; decryptKeyLength: Cardinal; decryptKey: Pointer);
begin
  CryptKeyVTable(vTable).setAsymmetric(Self, status, type_, encryptKeyLength, encryptKey, decryptKeyLength, decryptKey);
end;

function ICryptKey.getEncryptKey(length: PCardinal): Pointer;
begin
  Result := CryptKeyVTable(vTable).getEncryptKey(Self, length);
end;

function ICryptKey.getDecryptKey(length: PCardinal): Pointer;
begin
  Result := CryptKeyVTable(vTable).getDecryptKey(Self, length);
end;

function IConfigManager.getDirectory(code: Cardinal): PAnsiChar;
begin
  Result := ConfigManagerVTable(vTable).getDirectory(Self, code);
end;

function IConfigManager.getFirebirdConf(): IFirebirdConf;
begin
  Result := ConfigManagerVTable(vTable).getFirebirdConf(Self);
end;

function IConfigManager.getDatabaseConf(dbName: PAnsiChar): IFirebirdConf;
begin
  Result := ConfigManagerVTable(vTable).getDatabaseConf(Self, dbName);
end;

function IConfigManager.getPluginConfig(configuredPlugin: PAnsiChar): IConfig;
begin
  Result := ConfigManagerVTable(vTable).getPluginConfig(Self, configuredPlugin);
end;

function IConfigManager.getInstallDirectory(): PAnsiChar;
begin
  Result := ConfigManagerVTable(vTable).getInstallDirectory(Self);
end;

function IConfigManager.getRootDirectory(): PAnsiChar;
begin
  Result := ConfigManagerVTable(vTable).getRootDirectory(Self);
end;

function IConfigManager.getDefaultSecurityDb(): PAnsiChar;
begin
  Result := ConfigManagerVTable(vTable).getDefaultSecurityDb(Self);
end;

procedure IEventCallback.eventCallbackFunction(length: Cardinal; events: PByte);
begin
  EventCallbackVTable(vTable).eventCallbackFunction(Self, length, events);
end;

procedure IBlob.getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  BlobVTable(vTable).getInfo(Self, status, itemsLength, items, bufferLength, buffer);
end;

function IBlob.getSegment(status: IStatus; bufferLength: Cardinal; buffer: Pointer; segmentLength: PCardinal): Integer;
begin
  Result := BlobVTable(vTable).getSegment(Self, status, bufferLength, buffer, segmentLength);
end;

procedure IBlob.putSegment(status: IStatus; length: Cardinal; buffer: Pointer);
begin
  BlobVTable(vTable).putSegment(Self, status, length, buffer);
end;

procedure IBlob.cancel(status: IStatus);
begin
  BlobVTable(vTable).cancel(Self, status);
end;

procedure IBlob.close(status: IStatus);
begin
  BlobVTable(vTable).close(Self, status);
end;

function IBlob.seek(status: IStatus; mode: Integer; offset: Integer): Integer;
begin
  Result := BlobVTable(vTable).seek(Self, status, mode, offset);
end;

procedure ITransaction.getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  TransactionVTable(vTable).getInfo(Self, status, itemsLength, items, bufferLength, buffer);
end;

procedure ITransaction.prepare(status: IStatus; msgLength: Cardinal; message: PByte);
begin
  TransactionVTable(vTable).prepare(Self, status, msgLength, message);
end;

procedure ITransaction.commit(status: IStatus);
begin
  TransactionVTable(vTable).commit(Self, status);
end;

procedure ITransaction.commitRetaining(status: IStatus);
begin
  TransactionVTable(vTable).commitRetaining(Self, status);
end;

procedure ITransaction.rollback(status: IStatus);
begin
  TransactionVTable(vTable).rollback(Self, status);
end;

procedure ITransaction.rollbackRetaining(status: IStatus);
begin
  TransactionVTable(vTable).rollbackRetaining(Self, status);
end;

procedure ITransaction.disconnect(status: IStatus);
begin
  TransactionVTable(vTable).disconnect(Self, status);
end;

function ITransaction.join(status: IStatus; transaction: ITransaction): ITransaction;
begin
  Result := TransactionVTable(vTable).join(Self, status, transaction);
end;

function ITransaction.validate(status: IStatus; attachment: IAttachment): ITransaction;
begin
  Result := TransactionVTable(vTable).validate(Self, status, attachment);
end;

function ITransaction.enterDtc(status: IStatus): ITransaction;
begin
  Result := TransactionVTable(vTable).enterDtc(Self, status);
end;

function IMessageMetadata.getCount(status: IStatus): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getCount(Self, status);
end;

function IMessageMetadata.getField(status: IStatus; index: Cardinal): PAnsiChar;
begin
  Result := MessageMetadataVTable(vTable).getField(Self, status, index);
end;

function IMessageMetadata.getRelation(status: IStatus; index: Cardinal): PAnsiChar;
begin
  Result := MessageMetadataVTable(vTable).getRelation(Self, status, index);
end;

function IMessageMetadata.getOwner(status: IStatus; index: Cardinal): PAnsiChar;
begin
  Result := MessageMetadataVTable(vTable).getOwner(Self, status, index);
end;

function IMessageMetadata.getAlias(status: IStatus; index: Cardinal): PAnsiChar;
begin
  Result := MessageMetadataVTable(vTable).getAlias(Self, status, index);
end;

function IMessageMetadata.getType(status: IStatus; index: Cardinal): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getType(Self, status, index);
end;

function IMessageMetadata.isNullable(status: IStatus; index: Cardinal): Boolean;
begin
  Result := MessageMetadataVTable(vTable).isNullable(Self, status, index);
end;

function IMessageMetadata.getSubType(status: IStatus; index: Cardinal): Integer;
begin
  Result := MessageMetadataVTable(vTable).getSubType(Self, status, index);
end;

function IMessageMetadata.getLength(status: IStatus; index: Cardinal): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getLength(Self, status, index);
end;

function IMessageMetadata.getScale(status: IStatus; index: Cardinal): Integer;
begin
  Result := MessageMetadataVTable(vTable).getScale(Self, status, index);
end;

function IMessageMetadata.getCharSet(status: IStatus; index: Cardinal): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getCharSet(Self, status, index);
end;

function IMessageMetadata.getOffset(status: IStatus; index: Cardinal): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getOffset(Self, status, index);
end;

function IMessageMetadata.getNullOffset(status: IStatus; index: Cardinal): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getNullOffset(Self, status, index);
end;

function IMessageMetadata.getBuilder(status: IStatus): IMetadataBuilder;
begin
  Result := MessageMetadataVTable(vTable).getBuilder(Self, status);
end;

function IMessageMetadata.getMessageLength(status: IStatus): Cardinal;
begin
  Result := MessageMetadataVTable(vTable).getMessageLength(Self, status);
end;

function IMessageMetadata.getAlignment(status: IStatus): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := MessageMetadataVTable(vTable).getAlignment(Self, status);
end;

function IMessageMetadata.getAlignedLength(status: IStatus): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := MessageMetadataVTable(vTable).getAlignedLength(Self, status);
end;

procedure IMetadataBuilder.setType(status: IStatus; index: Cardinal; type_: Cardinal);
begin
  MetadataBuilderVTable(vTable).setType(Self, status, index, type_);
end;

procedure IMetadataBuilder.setSubType(status: IStatus; index: Cardinal; subType: Integer);
begin
  MetadataBuilderVTable(vTable).setSubType(Self, status, index, subType);
end;

procedure IMetadataBuilder.setLength(status: IStatus; index: Cardinal; length: Cardinal);
begin
  MetadataBuilderVTable(vTable).setLength(Self, status, index, length);
end;

procedure IMetadataBuilder.setCharSet(status: IStatus; index: Cardinal; charSet: Cardinal);
begin
  MetadataBuilderVTable(vTable).setCharSet(Self, status, index, charSet);
end;

procedure IMetadataBuilder.setScale(status: IStatus; index: Cardinal; scale: Integer);
begin
  MetadataBuilderVTable(vTable).setScale(Self, status, index, scale);
end;

procedure IMetadataBuilder.truncate(status: IStatus; count: Cardinal);
begin
  MetadataBuilderVTable(vTable).truncate(Self, status, count);
end;

procedure IMetadataBuilder.moveNameToIndex(status: IStatus; name: PAnsiChar; index: Cardinal);
begin
  MetadataBuilderVTable(vTable).moveNameToIndex(Self, status, name, index);
end;

procedure IMetadataBuilder.remove(status: IStatus; index: Cardinal);
begin
  MetadataBuilderVTable(vTable).remove(Self, status, index);
end;

function IMetadataBuilder.addField(status: IStatus): Cardinal;
begin
  Result := MetadataBuilderVTable(vTable).addField(Self, status);
end;

function IMetadataBuilder.getMetadata(status: IStatus): IMessageMetadata;
begin
  Result := MetadataBuilderVTable(vTable).getMetadata(Self, status);
end;

procedure IMetadataBuilder.setField(status: IStatus; index: Cardinal; field: PAnsiChar);
begin
  MetadataBuilderVTable(vTable).setField(Self, status, index, field);
end;

procedure IMetadataBuilder.setRelation(status: IStatus; index: Cardinal; relation: PAnsiChar);
begin
  MetadataBuilderVTable(vTable).setRelation(Self, status, index, relation);
end;

procedure IMetadataBuilder.setOwner(status: IStatus; index: Cardinal; owner: PAnsiChar);
begin
  MetadataBuilderVTable(vTable).setOwner(Self, status, index, owner);
end;

procedure IMetadataBuilder.setAlias(status: IStatus; index: Cardinal; alias: PAnsiChar);
begin
  MetadataBuilderVTable(vTable).setAlias(Self, status, index, alias);
end;

function IResultSet.fetchNext(status: IStatus; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchNext(Self, status, message);
end;

function IResultSet.fetchPrior(status: IStatus; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchPrior(Self, status, message);
end;

function IResultSet.fetchFirst(status: IStatus; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchFirst(Self, status, message);
end;

function IResultSet.fetchLast(status: IStatus; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchLast(Self, status, message);
end;

function IResultSet.fetchAbsolute(status: IStatus; position: Integer; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchAbsolute(Self, status, position, message);
end;

function IResultSet.fetchRelative(status: IStatus; offset: Integer; message: Pointer): Integer;
begin
  Result := ResultSetVTable(vTable).fetchRelative(Self, status, offset, message);
end;

function IResultSet.isEof(status: IStatus): Boolean;
begin
  Result := ResultSetVTable(vTable).isEof(Self, status);
end;

function IResultSet.isBof(status: IStatus): Boolean;
begin
  Result := ResultSetVTable(vTable).isBof(Self, status);
end;

function IResultSet.getMetadata(status: IStatus): IMessageMetadata;
begin
  Result := ResultSetVTable(vTable).getMetadata(Self, status);
end;

procedure IResultSet.close(status: IStatus);
begin
  ResultSetVTable(vTable).close(Self, status);
end;

procedure IResultSet.setDelayedOutputFormat(status: IStatus; format: IMessageMetadata);
begin
  ResultSetVTable(vTable).setDelayedOutputFormat(Self, status, format);
end;

procedure IStatement.getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  StatementVTable(vTable).getInfo(Self, status, itemsLength, items, bufferLength, buffer);
end;

function IStatement.getType(status: IStatus): Cardinal;
begin
  Result := StatementVTable(vTable).getType(Self, status);
end;

function IStatement.getPlan(status: IStatus; detailed: Boolean): PAnsiChar;
begin
  Result := StatementVTable(vTable).getPlan(Self, status, detailed);
end;

function IStatement.getAffectedRecords(status: IStatus): UInt64;
begin
  Result := StatementVTable(vTable).getAffectedRecords(Self, status);
end;

function IStatement.getInputMetadata(status: IStatus): IMessageMetadata;
begin
  Result := StatementVTable(vTable).getInputMetadata(Self, status);
end;

function IStatement.getOutputMetadata(status: IStatus): IMessageMetadata;
begin
  Result := StatementVTable(vTable).getOutputMetadata(Self, status);
end;

function IStatement.execute(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction;
begin
  Result := StatementVTable(vTable).execute(Self, status, transaction, inMetadata, inBuffer, outMetadata, outBuffer);
end;

function IStatement.openCursor(status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; flags: Cardinal): IResultSet;
begin
  Result := StatementVTable(vTable).openCursor(Self, status, transaction, inMetadata, inBuffer, outMetadata, flags);
end;

procedure IStatement.setCursorName(status: IStatus; name: PAnsiChar);
begin
  StatementVTable(vTable).setCursorName(Self, status, name);
end;

procedure IStatement.free(status: IStatus);
begin
  StatementVTable(vTable).free(Self, status);
end;

function IStatement.getFlags(status: IStatus): Cardinal;
begin
  Result := StatementVTable(vTable).getFlags(Self, status);
end;

function IStatement.getTimeout(status: IStatus): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := StatementVTable(vTable).getTimeout(Self, status);
end;

procedure IStatement.setTimeout(status: IStatus; timeOut: Cardinal);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else StatementVTable(vTable).setTimeout(Self, status, timeOut);
end;

function IStatement.createBatch(status: IStatus; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := StatementVTable(vTable).createBatch(Self, status, inMetadata, parLength, par);
end;

procedure IBatch.add(status: IStatus; count: Cardinal; inBuffer: Pointer);
begin
  BatchVTable(vTable).add(Self, status, count, inBuffer);
end;

procedure IBatch.addBlob(status: IStatus; length: Cardinal; inBuffer: Pointer; blobId: PISC_QUAD; parLength: Cardinal; par: PByte);
begin
  BatchVTable(vTable).addBlob(Self, status, length, inBuffer, blobId, parLength, par);
end;

procedure IBatch.appendBlobData(status: IStatus; length: Cardinal; inBuffer: Pointer);
begin
  BatchVTable(vTable).appendBlobData(Self, status, length, inBuffer);
end;

procedure IBatch.addBlobStream(status: IStatus; length: Cardinal; inBuffer: Pointer);
begin
  BatchVTable(vTable).addBlobStream(Self, status, length, inBuffer);
end;

procedure IBatch.registerBlob(status: IStatus; existingBlob: PISC_QUAD; blobId: PISC_QUAD);
begin
  BatchVTable(vTable).registerBlob(Self, status, existingBlob, blobId);
end;

function IBatch.execute(status: IStatus; transaction: ITransaction): IBatchCompletionState;
begin
  Result := BatchVTable(vTable).execute(Self, status, transaction);
end;

procedure IBatch.cancel(status: IStatus);
begin
  BatchVTable(vTable).cancel(Self, status);
end;

function IBatch.getBlobAlignment(status: IStatus): Cardinal;
begin
  Result := BatchVTable(vTable).getBlobAlignment(Self, status);
end;

function IBatch.getMetadata(status: IStatus): IMessageMetadata;
begin
  Result := BatchVTable(vTable).getMetadata(Self, status);
end;

procedure IBatch.setDefaultBpb(status: IStatus; parLength: Cardinal; par: PByte);
begin
  BatchVTable(vTable).setDefaultBpb(Self, status, parLength, par);
end;

function IBatchCompletionState.getSize(status: IStatus): Cardinal;
begin
  Result := BatchCompletionStateVTable(vTable).getSize(Self, status);
end;

function IBatchCompletionState.getState(status: IStatus; pos: Cardinal): Integer;
begin
  Result := BatchCompletionStateVTable(vTable).getState(Self, status, pos);
end;

function IBatchCompletionState.findError(status: IStatus; pos: Cardinal): Cardinal;
begin
  Result := BatchCompletionStateVTable(vTable).findError(Self, status, pos);
end;

procedure IBatchCompletionState.getStatus(status: IStatus; to_: IStatus; pos: Cardinal);
begin
  BatchCompletionStateVTable(vTable).getStatus(Self, status, to_, pos);
end;

procedure IReplicator.process(status: IStatus; length: Cardinal; data: PByte);
begin
  ReplicatorVTable(vTable).process(Self, status, length, data);
end;

procedure IReplicator.close(status: IStatus);
begin
  ReplicatorVTable(vTable).close(Self, status);
end;

procedure IRequest.receive(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
begin
  RequestVTable(vTable).receive(Self, status, level, msgType, length, message);
end;

procedure IRequest.send(status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
begin
  RequestVTable(vTable).send(Self, status, level, msgType, length, message);
end;

procedure IRequest.getInfo(status: IStatus; level: Integer; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  RequestVTable(vTable).getInfo(Self, status, level, itemsLength, items, bufferLength, buffer);
end;

procedure IRequest.start(status: IStatus; tra: ITransaction; level: Integer);
begin
  RequestVTable(vTable).start(Self, status, tra, level);
end;

procedure IRequest.startAndSend(status: IStatus; tra: ITransaction; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer);
begin
  RequestVTable(vTable).startAndSend(Self, status, tra, level, msgType, length, message);
end;

procedure IRequest.unwind(status: IStatus; level: Integer);
begin
  RequestVTable(vTable).unwind(Self, status, level);
end;

procedure IRequest.free(status: IStatus);
begin
  RequestVTable(vTable).free(Self, status);
end;

procedure IEvents.cancel(status: IStatus);
begin
  EventsVTable(vTable).cancel(Self, status);
end;

procedure IAttachment.getInfo(status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  AttachmentVTable(vTable).getInfo(Self, status, itemsLength, items, bufferLength, buffer);
end;

function IAttachment.startTransaction(status: IStatus; tpbLength: Cardinal; tpb: PByte): ITransaction;
begin
  Result := AttachmentVTable(vTable).startTransaction(Self, status, tpbLength, tpb);
end;

function IAttachment.reconnectTransaction(status: IStatus; length: Cardinal; id: PByte): ITransaction;
begin
  Result := AttachmentVTable(vTable).reconnectTransaction(Self, status, length, id);
end;

function IAttachment.compileRequest(status: IStatus; blrLength: Cardinal; blr: PByte): IRequest;
begin
  Result := AttachmentVTable(vTable).compileRequest(Self, status, blrLength, blr);
end;

procedure IAttachment.transactRequest(status: IStatus; transaction: ITransaction; blrLength: Cardinal; blr: PByte; inMsgLength: Cardinal; inMsg: PByte; outMsgLength: Cardinal; outMsg: PByte);
begin
  AttachmentVTable(vTable).transactRequest(Self, status, transaction, blrLength, blr, inMsgLength, inMsg, outMsgLength, outMsg);
end;

function IAttachment.createBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob;
begin
  Result := AttachmentVTable(vTable).createBlob(Self, status, transaction, id, bpbLength, bpb);
end;

function IAttachment.openBlob(status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob;
begin
  Result := AttachmentVTable(vTable).openBlob(Self, status, transaction, id, bpbLength, bpb);
end;

function IAttachment.getSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte): Integer;
begin
  Result := AttachmentVTable(vTable).getSlice(Self, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
end;

procedure IAttachment.putSlice(status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte);
begin
  AttachmentVTable(vTable).putSlice(Self, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
end;

procedure IAttachment.executeDyn(status: IStatus; transaction: ITransaction; length: Cardinal; dyn: PByte);
begin
  AttachmentVTable(vTable).executeDyn(Self, status, transaction, length, dyn);
end;

function IAttachment.prepare(status: IStatus; tra: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; flags: Cardinal): IStatement;
begin
  Result := AttachmentVTable(vTable).prepare(Self, status, tra, stmtLength, sqlStmt, dialect, flags);
end;

function IAttachment.execute(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction;
begin
  Result := AttachmentVTable(vTable).execute(Self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, outBuffer);
end;

function IAttachment.openCursor(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; cursorName: PAnsiChar; cursorFlags: Cardinal): IResultSet;
begin
  Result := AttachmentVTable(vTable).openCursor(Self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, cursorName, cursorFlags);
end;

function IAttachment.queEvents(status: IStatus; callback: IEventCallback; length: Cardinal; events: PByte): IEvents;
begin
  Result := AttachmentVTable(vTable).queEvents(Self, status, callback, length, events);
end;

procedure IAttachment.cancelOperation(status: IStatus; option: Integer);
begin
  AttachmentVTable(vTable).cancelOperation(Self, status, option);
end;

procedure IAttachment.ping(status: IStatus);
begin
  AttachmentVTable(vTable).ping(Self, status);
end;

procedure IAttachment.detach(status: IStatus);
begin
  AttachmentVTable(vTable).detach(Self, status);
end;

procedure IAttachment.dropDatabase(status: IStatus);
begin
  AttachmentVTable(vTable).dropDatabase(Self, status);
end;

function IAttachment.getIdleTimeout(status: IStatus): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := AttachmentVTable(vTable).getIdleTimeout(Self, status);
end;

procedure IAttachment.setIdleTimeout(status: IStatus; timeOut: Cardinal);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else AttachmentVTable(vTable).setIdleTimeout(Self, status, timeOut);
end;

function IAttachment.getStatementTimeout(status: IStatus): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := AttachmentVTable(vTable).getStatementTimeout(Self, status);
end;

procedure IAttachment.setStatementTimeout(status: IStatus; timeOut: Cardinal);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else AttachmentVTable(vTable).setStatementTimeout(Self, status, timeOut);
end;

function IAttachment.createBatch(status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := AttachmentVTable(vTable).createBatch(Self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, parLength, par);
end;

function IAttachment.createReplicator(status: IStatus): IReplicator;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := AttachmentVTable(vTable).createReplicator(Self, status);
end;

procedure IService.detach(status: IStatus);
begin
  ServiceVTable(vTable).detach(Self, status);
end;

procedure IService.query(status: IStatus; sendLength: Cardinal; sendItems: PByte; receiveLength: Cardinal; receiveItems: PByte; bufferLength: Cardinal; buffer: PByte);
begin
  ServiceVTable(vTable).query(Self, status, sendLength, sendItems, receiveLength, receiveItems, bufferLength, buffer);
end;

procedure IService.start(status: IStatus; spbLength: Cardinal; spb: PByte);
begin
  ServiceVTable(vTable).start(Self, status, spbLength, spb);
end;

function IProvider.attachDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment;
begin
  Result := ProviderVTable(vTable).attachDatabase(Self, status, fileName, dpbLength, dpb);
end;

function IProvider.createDatabase(status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment;
begin
  Result := ProviderVTable(vTable).createDatabase(Self, status, fileName, dpbLength, dpb);
end;

function IProvider.attachServiceManager(status: IStatus; service: PAnsiChar; spbLength: Cardinal; spb: PByte): IService;
begin
  Result := ProviderVTable(vTable).attachServiceManager(Self, status, service, spbLength, spb);
end;

procedure IProvider.shutdown(status: IStatus; timeout: Cardinal; reason: Integer);
begin
  ProviderVTable(vTable).shutdown(Self, status, timeout, reason);
end;

procedure IProvider.setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback);
begin
  ProviderVTable(vTable).setDbCryptCallback(Self, status, cryptCallback);
end;

procedure IDtcStart.addAttachment(status: IStatus; att: IAttachment);
begin
  DtcStartVTable(vTable).addAttachment(Self, status, att);
end;

procedure IDtcStart.addWithTpb(status: IStatus; att: IAttachment; length: Cardinal; tpb: PByte);
begin
  DtcStartVTable(vTable).addWithTpb(Self, status, att, length, tpb);
end;

function IDtcStart.start(status: IStatus): ITransaction;
begin
  Result := DtcStartVTable(vTable).start(Self, status);
end;

function IDtc.join(status: IStatus; one: ITransaction; two: ITransaction): ITransaction;
begin
  Result := DtcVTable(vTable).join(Self, status, one, two);
end;

function IDtc.startBuilder(status: IStatus): IDtcStart;
begin
  Result := DtcVTable(vTable).startBuilder(Self, status);
end;

procedure IWriter.reset();
begin
  WriterVTable(vTable).reset(Self);
end;

procedure IWriter.add(status: IStatus; name: PAnsiChar);
begin
  WriterVTable(vTable).add(Self, status, name);
end;

procedure IWriter.setType(status: IStatus; value: PAnsiChar);
begin
  WriterVTable(vTable).setType(Self, status, value);
end;

procedure IWriter.setDb(status: IStatus; value: PAnsiChar);
begin
  WriterVTable(vTable).setDb(Self, status, value);
end;

function IServerBlock.getLogin(): PAnsiChar;
begin
  Result := ServerBlockVTable(vTable).getLogin(Self);
end;

function IServerBlock.getData(length: PCardinal): PByte;
begin
  Result := ServerBlockVTable(vTable).getData(Self, length);
end;

procedure IServerBlock.putData(status: IStatus; length: Cardinal; data: Pointer);
begin
  ServerBlockVTable(vTable).putData(Self, status, length, data);
end;

function IServerBlock.newKey(status: IStatus): ICryptKey;
begin
  Result := ServerBlockVTable(vTable).newKey(Self, status);
end;

function IClientBlock.getLogin(): PAnsiChar;
begin
  Result := ClientBlockVTable(vTable).getLogin(Self);
end;

function IClientBlock.getPassword(): PAnsiChar;
begin
  Result := ClientBlockVTable(vTable).getPassword(Self);
end;

function IClientBlock.getData(length: PCardinal): PByte;
begin
  Result := ClientBlockVTable(vTable).getData(Self, length);
end;

procedure IClientBlock.putData(status: IStatus; length: Cardinal; data: Pointer);
begin
  ClientBlockVTable(vTable).putData(Self, status, length, data);
end;

function IClientBlock.newKey(status: IStatus): ICryptKey;
begin
  Result := ClientBlockVTable(vTable).newKey(Self, status);
end;

function IClientBlock.getAuthBlock(status: IStatus): IAuthBlock;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := ClientBlockVTable(vTable).getAuthBlock(Self, status);
end;

function IServer.authenticate(status: IStatus; sBlock: IServerBlock; writerInterface: IWriter): Integer;
begin
  Result := ServerVTable(vTable).authenticate(Self, status, sBlock, writerInterface);
end;

procedure IServer.setDbCryptCallback(status: IStatus; cryptCallback: ICryptKeyCallback);
begin
  ServerVTable(vTable).setDbCryptCallback(Self, status, cryptCallback);
end;

function IClient.authenticate(status: IStatus; cBlock: IClientBlock): Integer;
begin
  Result := ClientVTable(vTable).authenticate(Self, status, cBlock);
end;

function IUserField.entered(): Integer;
begin
  Result := UserFieldVTable(vTable).entered(Self);
end;

function IUserField.specified(): Integer;
begin
  Result := UserFieldVTable(vTable).specified(Self);
end;

procedure IUserField.setEntered(status: IStatus; newValue: Integer);
begin
  UserFieldVTable(vTable).setEntered(Self, status, newValue);
end;

function ICharUserField.get(): PAnsiChar;
begin
  Result := CharUserFieldVTable(vTable).get(Self);
end;

procedure ICharUserField.set_(status: IStatus; newValue: PAnsiChar);
begin
  CharUserFieldVTable(vTable).set_(Self, status, newValue);
end;

function IIntUserField.get(): Integer;
begin
  Result := IntUserFieldVTable(vTable).get(Self);
end;

procedure IIntUserField.set_(status: IStatus; newValue: Integer);
begin
  IntUserFieldVTable(vTable).set_(Self, status, newValue);
end;

function IUser.operation(): Cardinal;
begin
  Result := UserVTable(vTable).operation(Self);
end;

function IUser.userName(): ICharUserField;
begin
  Result := UserVTable(vTable).userName(Self);
end;

function IUser.password(): ICharUserField;
begin
  Result := UserVTable(vTable).password(Self);
end;

function IUser.firstName(): ICharUserField;
begin
  Result := UserVTable(vTable).firstName(Self);
end;

function IUser.lastName(): ICharUserField;
begin
  Result := UserVTable(vTable).lastName(Self);
end;

function IUser.middleName(): ICharUserField;
begin
  Result := UserVTable(vTable).middleName(Self);
end;

function IUser.comment(): ICharUserField;
begin
  Result := UserVTable(vTable).comment(Self);
end;

function IUser.attributes(): ICharUserField;
begin
  Result := UserVTable(vTable).attributes(Self);
end;

function IUser.active(): IIntUserField;
begin
  Result := UserVTable(vTable).active(Self);
end;

function IUser.admin(): IIntUserField;
begin
  Result := UserVTable(vTable).admin(Self);
end;

procedure IUser.clear(status: IStatus);
begin
  UserVTable(vTable).clear(Self, status);
end;

procedure IListUsers.list(status: IStatus; user: IUser);
begin
  ListUsersVTable(vTable).list(Self, status, user);
end;

function ILogonInfo.name(): PAnsiChar;
begin
  Result := LogonInfoVTable(vTable).name(Self);
end;

function ILogonInfo.role(): PAnsiChar;
begin
  Result := LogonInfoVTable(vTable).role(Self);
end;

function ILogonInfo.networkProtocol(): PAnsiChar;
begin
  Result := LogonInfoVTable(vTable).networkProtocol(Self);
end;

function ILogonInfo.remoteAddress(): PAnsiChar;
begin
  Result := LogonInfoVTable(vTable).remoteAddress(Self);
end;

function ILogonInfo.authBlock(length: PCardinal): PByte;
begin
  Result := LogonInfoVTable(vTable).authBlock(Self, length);
end;

function ILogonInfo.attachment(status: IStatus): IAttachment;
begin
  Result := LogonInfoVTable(vTable).attachment(Self, status);
end;

function ILogonInfo.transaction(status: IStatus): ITransaction;
begin
  Result := LogonInfoVTable(vTable).transaction(Self, status);
end;

procedure IManagement.start(status: IStatus; logonInfo: ILogonInfo);
begin
  ManagementVTable(vTable).start(Self, status, logonInfo);
end;

function IManagement.execute(status: IStatus; user: IUser; callback: IListUsers): Integer;
begin
  Result := ManagementVTable(vTable).execute(Self, status, user, callback);
end;

procedure IManagement.commit(status: IStatus);
begin
  ManagementVTable(vTable).commit(Self, status);
end;

procedure IManagement.rollback(status: IStatus);
begin
  ManagementVTable(vTable).rollback(Self, status);
end;

function IAuthBlock.getType(): PAnsiChar;
begin
  Result := AuthBlockVTable(vTable).getType(Self);
end;

function IAuthBlock.getName(): PAnsiChar;
begin
  Result := AuthBlockVTable(vTable).getName(Self);
end;

function IAuthBlock.getPlugin(): PAnsiChar;
begin
  Result := AuthBlockVTable(vTable).getPlugin(Self);
end;

function IAuthBlock.getSecurityDb(): PAnsiChar;
begin
  Result := AuthBlockVTable(vTable).getSecurityDb(Self);
end;

function IAuthBlock.getOriginalPlugin(): PAnsiChar;
begin
  Result := AuthBlockVTable(vTable).getOriginalPlugin(Self);
end;

function IAuthBlock.next(status: IStatus): Boolean;
begin
  Result := AuthBlockVTable(vTable).next(Self, status);
end;

function IAuthBlock.first(status: IStatus): Boolean;
begin
  Result := AuthBlockVTable(vTable).first(Self, status);
end;

function IWireCryptPlugin.getKnownTypes(status: IStatus): PAnsiChar;
begin
  Result := WireCryptPluginVTable(vTable).getKnownTypes(Self, status);
end;

procedure IWireCryptPlugin.setKey(status: IStatus; key: ICryptKey);
begin
  WireCryptPluginVTable(vTable).setKey(Self, status, key);
end;

procedure IWireCryptPlugin.encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
begin
  WireCryptPluginVTable(vTable).encrypt(Self, status, length, from, to_);
end;

procedure IWireCryptPlugin.decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
begin
  WireCryptPluginVTable(vTable).decrypt(Self, status, length, from, to_);
end;

function IWireCryptPlugin.getSpecificData(status: IStatus; keyType: PAnsiChar; length: PCardinal): PByte;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := WireCryptPluginVTable(vTable).getSpecificData(Self, status, keyType, length);
end;

procedure IWireCryptPlugin.setSpecificData(status: IStatus; keyType: PAnsiChar; length: Cardinal; data: PByte);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else WireCryptPluginVTable(vTable).setSpecificData(Self, status, keyType, length, data);
end;

function ICryptKeyCallback.callback(dataLength: Cardinal; data: Pointer; bufferLength: Cardinal; buffer: Pointer): Cardinal;
begin
  Result := CryptKeyCallbackVTable(vTable).callback(Self, dataLength, data, bufferLength, buffer);
end;

function IKeyHolderPlugin.keyCallback(status: IStatus; callback: ICryptKeyCallback): Integer;
begin
  Result := KeyHolderPluginVTable(vTable).keyCallback(Self, status, callback);
end;

function IKeyHolderPlugin.keyHandle(status: IStatus; keyName: PAnsiChar): ICryptKeyCallback;
begin
  Result := KeyHolderPluginVTable(vTable).keyHandle(Self, status, keyName);
end;

function IKeyHolderPlugin.useOnlyOwnKeys(status: IStatus): Boolean;
begin
  Result := KeyHolderPluginVTable(vTable).useOnlyOwnKeys(Self, status);
end;

function IKeyHolderPlugin.chainHandle(status: IStatus): ICryptKeyCallback;
begin
  Result := KeyHolderPluginVTable(vTable).chainHandle(Self, status);
end;

function IDbCryptInfo.getDatabaseFullPath(status: IStatus): PAnsiChar;
begin
  Result := DbCryptInfoVTable(vTable).getDatabaseFullPath(Self, status);
end;

procedure IDbCryptPlugin.setKey(status: IStatus; length: Cardinal; sources: PIKeyHolderPlugin; keyName: PAnsiChar);
begin
  DbCryptPluginVTable(vTable).setKey(Self, status, length, sources, keyName);
end;

procedure IDbCryptPlugin.encrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
begin
  DbCryptPluginVTable(vTable).encrypt(Self, status, length, from, to_);
end;

procedure IDbCryptPlugin.decrypt(status: IStatus; length: Cardinal; from: Pointer; to_: Pointer);
begin
  DbCryptPluginVTable(vTable).decrypt(Self, status, length, from, to_);
end;

procedure IDbCryptPlugin.setInfo(status: IStatus; info: IDbCryptInfo);
begin
  DbCryptPluginVTable(vTable).setInfo(Self, status, info);
end;

function IExternalContext.getMaster(): IMaster;
begin
  Result := ExternalContextVTable(vTable).getMaster(Self);
end;

function IExternalContext.getEngine(status: IStatus): IExternalEngine;
begin
  Result := ExternalContextVTable(vTable).getEngine(Self, status);
end;

function IExternalContext.getAttachment(status: IStatus): IAttachment;
begin
  Result := ExternalContextVTable(vTable).getAttachment(Self, status);
end;

function IExternalContext.getTransaction(status: IStatus): ITransaction;
begin
  Result := ExternalContextVTable(vTable).getTransaction(Self, status);
end;

function IExternalContext.getUserName(): PAnsiChar;
begin
  Result := ExternalContextVTable(vTable).getUserName(Self);
end;

function IExternalContext.getDatabaseName(): PAnsiChar;
begin
  Result := ExternalContextVTable(vTable).getDatabaseName(Self);
end;

function IExternalContext.getClientCharSet(): PAnsiChar;
begin
  Result := ExternalContextVTable(vTable).getClientCharSet(Self);
end;

function IExternalContext.obtainInfoCode(): Integer;
begin
  Result := ExternalContextVTable(vTable).obtainInfoCode(Self);
end;

function IExternalContext.getInfo(code: Integer): Pointer;
begin
  Result := ExternalContextVTable(vTable).getInfo(Self, code);
end;

function IExternalContext.setInfo(code: Integer; value: Pointer): Pointer;
begin
  Result := ExternalContextVTable(vTable).setInfo(Self, code, value);
end;

function IExternalResultSet.fetch(status: IStatus): Boolean;
begin
  Result := ExternalResultSetVTable(vTable).fetch(Self, status);
end;

procedure IExternalFunction.getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
begin
  ExternalFunctionVTable(vTable).getCharSet(Self, status, context, name, nameSize);
end;

procedure IExternalFunction.execute(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer);
begin
  ExternalFunctionVTable(vTable).execute(Self, status, context, inMsg, outMsg);
end;

procedure IExternalProcedure.getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
begin
  ExternalProcedureVTable(vTable).getCharSet(Self, status, context, name, nameSize);
end;

function IExternalProcedure.open(status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer): IExternalResultSet;
begin
  Result := ExternalProcedureVTable(vTable).open(Self, status, context, inMsg, outMsg);
end;

procedure IExternalTrigger.getCharSet(status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal);
begin
  ExternalTriggerVTable(vTable).getCharSet(Self, status, context, name, nameSize);
end;

procedure IExternalTrigger.execute(status: IStatus; context: IExternalContext; action: Cardinal; oldMsg: Pointer; newMsg: Pointer);
begin
  ExternalTriggerVTable(vTable).execute(Self, status, context, action, oldMsg, newMsg);
end;

function IRoutineMetadata.getPackage(status: IStatus): PAnsiChar;
begin
  Result := RoutineMetadataVTable(vTable).getPackage(Self, status);
end;

function IRoutineMetadata.getName(status: IStatus): PAnsiChar;
begin
  Result := RoutineMetadataVTable(vTable).getName(Self, status);
end;

function IRoutineMetadata.getEntryPoint(status: IStatus): PAnsiChar;
begin
  Result := RoutineMetadataVTable(vTable).getEntryPoint(Self, status);
end;

function IRoutineMetadata.getBody(status: IStatus): PAnsiChar;
begin
  Result := RoutineMetadataVTable(vTable).getBody(Self, status);
end;

function IRoutineMetadata.getInputMetadata(status: IStatus): IMessageMetadata;
begin
  Result := RoutineMetadataVTable(vTable).getInputMetadata(Self, status);
end;

function IRoutineMetadata.getOutputMetadata(status: IStatus): IMessageMetadata;
begin
  Result := RoutineMetadataVTable(vTable).getOutputMetadata(Self, status);
end;

function IRoutineMetadata.getTriggerMetadata(status: IStatus): IMessageMetadata;
begin
  Result := RoutineMetadataVTable(vTable).getTriggerMetadata(Self, status);
end;

function IRoutineMetadata.getTriggerTable(status: IStatus): PAnsiChar;
begin
  Result := RoutineMetadataVTable(vTable).getTriggerTable(Self, status);
end;

function IRoutineMetadata.getTriggerType(status: IStatus): Cardinal;
begin
  Result := RoutineMetadataVTable(vTable).getTriggerType(Self, status);
end;

procedure IExternalEngine.open(status: IStatus; context: IExternalContext; charSet: PAnsiChar; charSetSize: Cardinal);
begin
  ExternalEngineVTable(vTable).open(Self, status, context, charSet, charSetSize);
end;

procedure IExternalEngine.openAttachment(status: IStatus; context: IExternalContext);
begin
  ExternalEngineVTable(vTable).openAttachment(Self, status, context);
end;

procedure IExternalEngine.closeAttachment(status: IStatus; context: IExternalContext);
begin
  ExternalEngineVTable(vTable).closeAttachment(Self, status, context);
end;

function IExternalEngine.makeFunction(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalFunction;
begin
  Result := ExternalEngineVTable(vTable).makeFunction(Self, status, context, metadata, inBuilder, outBuilder);
end;

function IExternalEngine.makeProcedure(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalProcedure;
begin
  Result := ExternalEngineVTable(vTable).makeProcedure(Self, status, context, metadata, inBuilder, outBuilder);
end;

function IExternalEngine.makeTrigger(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder): IExternalTrigger;
begin
  Result := ExternalEngineVTable(vTable).makeTrigger(Self, status, context, metadata, fieldsBuilder);
end;

procedure ITimer.handler();
begin
  TimerVTable(vTable).handler(Self);
end;

procedure ITimerControl.start(status: IStatus; timer: ITimer; microSeconds: UInt64);
begin
  TimerControlVTable(vTable).start(Self, status, timer, microSeconds);
end;

procedure ITimerControl.stop(status: IStatus; timer: ITimer);
begin
  TimerControlVTable(vTable).stop(Self, status, timer);
end;

procedure IVersionCallback.callback(status: IStatus; text: PAnsiChar);
begin
  VersionCallbackVTable(vTable).callback(Self, status, text);
end;

procedure IUtil.getFbVersion(status: IStatus; att: IAttachment; callback: IVersionCallback);
begin
  UtilVTable(vTable).getFbVersion(Self, status, att, callback);
end;

procedure IUtil.loadBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean);
begin
  UtilVTable(vTable).loadBlob(Self, status, blobId, att, tra, file_, txt);
end;

procedure IUtil.dumpBlob(status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean);
begin
  UtilVTable(vTable).dumpBlob(Self, status, blobId, att, tra, file_, txt);
end;

procedure IUtil.getPerfCounters(status: IStatus; att: IAttachment; countersSet: PAnsiChar; counters: PInt64);
begin
  UtilVTable(vTable).getPerfCounters(Self, status, att, countersSet, counters);
end;

function IUtil.executeCreateDatabase(status: IStatus; stmtLength: Cardinal; creatDBstatement: PAnsiChar; dialect: Cardinal; stmtIsCreateDb: BooleanPtr): IAttachment;
begin
  Result := UtilVTable(vTable).executeCreateDatabase(Self, status, stmtLength, creatDBstatement, dialect, stmtIsCreateDb);
end;

procedure IUtil.decodeDate(date: TISC_DATE; year: PCardinal; month: PCardinal; day: PCardinal);
begin
  UtilVTable(vTable).decodeDate(Self, date, year, month, day);
end;

procedure IUtil.decodeTime(time: TISC_TIME; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal);
begin
  UtilVTable(vTable).decodeTime(Self, time, hours, minutes, seconds, fractions);
end;

function IUtil.encodeDate(year: Cardinal; month: Cardinal; day: Cardinal): TISC_DATE;
begin
  Result := UtilVTable(vTable).encodeDate(Self, year, month, day);
end;

function IUtil.encodeTime(hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal): TISC_TIME;
begin
  Result := UtilVTable(vTable).encodeTime(Self, hours, minutes, seconds, fractions);
end;

function IUtil.formatStatus(buffer: PAnsiChar; bufferSize: Cardinal; status: IStatus): Cardinal;
begin
  Result := UtilVTable(vTable).formatStatus(Self, buffer, bufferSize, status);
end;

function IUtil.getClientVersion(): Cardinal;
begin
  Result := UtilVTable(vTable).getClientVersion(Self);
end;

function IUtil.getXpbBuilder(status: IStatus; kind: Cardinal; buf: PByte; len: Cardinal): IXpbBuilder;
begin
  Result := UtilVTable(vTable).getXpbBuilder(Self, status, kind, buf, len);
end;

function IUtil.setOffsets(status: IStatus; metadata: IMessageMetadata; callback: IOffsetsCallback): Cardinal;
begin
  Result := UtilVTable(vTable).setOffsets(Self, status, metadata, callback);
end;

function IUtil.getDecFloat16(status: IStatus): IDecFloat16;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := UtilVTable(vTable).getDecFloat16(Self, status);
end;

function IUtil.getDecFloat34(status: IStatus): IDecFloat34;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := UtilVTable(vTable).getDecFloat34(Self, status);
end;

procedure IUtil.decodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).decodeTimeTz(Self, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtil.decodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).decodeTimeStampTz(Self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtil.encodeTimeTz(status: IStatus; timeTz: PISC_TIME_TZ; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).encodeTimeTz(Self, status, timeTz, hours, minutes, seconds, fractions, timeZone);
end;

procedure IUtil.encodeTimeStampTz(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: Cardinal; month: Cardinal; day: Cardinal; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).encodeTimeStampTz(Self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZone);
end;

function IUtil.getInt128(status: IStatus): IInt128;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := nil;
  end else
    Result := UtilVTable(vTable).getInt128(Self, status);
end;

procedure IUtil.decodeTimeTzEx(status: IStatus; timeTz: PISC_TIME_TZ_EX; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).decodeTimeTzEx(Self, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtil.decodeTimeStampTzEx(status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ_EX; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar);
begin
  if vTable.version < 4
  then SetIntfToOldVersionError(status)
  else UtilVTable(vTable).decodeTimeStampTzEx(Self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IOffsetsCallback.setOffset(status: IStatus; index: Cardinal; offset: Cardinal; nullOffset: Cardinal);
begin
  OffsetsCallbackVTable(vTable).setOffset(Self, status, index, offset, nullOffset);
end;

procedure IXpbBuilder.clear(status: IStatus);
begin
  XpbBuilderVTable(vTable).clear(Self, status);
end;

procedure IXpbBuilder.removeCurrent(status: IStatus);
begin
  XpbBuilderVTable(vTable).removeCurrent(Self, status);
end;

procedure IXpbBuilder.insertInt(status: IStatus; tag: Byte; value: Integer);
begin
  XpbBuilderVTable(vTable).insertInt(Self, status, tag, value);
end;

procedure IXpbBuilder.insertBigInt(status: IStatus; tag: Byte; value: Int64);
begin
  XpbBuilderVTable(vTable).insertBigInt(Self, status, tag, value);
end;

procedure IXpbBuilder.insertBytes(status: IStatus; tag: Byte; bytes: Pointer; length: Cardinal);
begin
  XpbBuilderVTable(vTable).insertBytes(Self, status, tag, bytes, length);
end;

procedure IXpbBuilder.insertString(status: IStatus; tag: Byte; str: PAnsiChar);
begin
  XpbBuilderVTable(vTable).insertString(Self, status, tag, str);
end;

procedure IXpbBuilder.insertTag(status: IStatus; tag: Byte);
begin
  XpbBuilderVTable(vTable).insertTag(Self, status, tag);
end;

function IXpbBuilder.isEof(status: IStatus): Boolean;
begin
  Result := XpbBuilderVTable(vTable).isEof(Self, status);
end;

procedure IXpbBuilder.moveNext(status: IStatus);
begin
  XpbBuilderVTable(vTable).moveNext(Self, status);
end;

procedure IXpbBuilder.rewind(status: IStatus);
begin
  XpbBuilderVTable(vTable).rewind(Self, status);
end;

function IXpbBuilder.findFirst(status: IStatus; tag: Byte): Boolean;
begin
  Result := XpbBuilderVTable(vTable).findFirst(Self, status, tag);
end;

function IXpbBuilder.findNext(status: IStatus): Boolean;
begin
  Result := XpbBuilderVTable(vTable).findNext(Self, status);
end;

function IXpbBuilder.getTag(status: IStatus): Byte;
begin
  Result := XpbBuilderVTable(vTable).getTag(Self, status);
end;

function IXpbBuilder.getLength(status: IStatus): Cardinal;
begin
  Result := XpbBuilderVTable(vTable).getLength(Self, status);
end;

function IXpbBuilder.getInt(status: IStatus): Integer;
begin
  Result := XpbBuilderVTable(vTable).getInt(Self, status);
end;

function IXpbBuilder.getBigInt(status: IStatus): Int64;
begin
  Result := XpbBuilderVTable(vTable).getBigInt(Self, status);
end;

function IXpbBuilder.getString(status: IStatus): PAnsiChar;
begin
  Result := XpbBuilderVTable(vTable).getString(Self, status);
end;

function IXpbBuilder.getBytes(status: IStatus): PByte;
begin
  Result := XpbBuilderVTable(vTable).getBytes(Self, status);
end;

function IXpbBuilder.getBufferLength(status: IStatus): Cardinal;
begin
  Result := XpbBuilderVTable(vTable).getBufferLength(Self, status);
end;

function IXpbBuilder.getBuffer(status: IStatus): PByte;
begin
  Result := XpbBuilderVTable(vTable).getBuffer(Self, status);
end;

function ITraceConnection.getKind(): Cardinal;
begin
  Result := TraceConnectionVTable(vTable).getKind(Self);
end;

function ITraceConnection.getProcessID(): Integer;
begin
  Result := TraceConnectionVTable(vTable).getProcessID(Self);
end;

function ITraceConnection.getUserName(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getUserName(Self);
end;

function ITraceConnection.getRoleName(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getRoleName(Self);
end;

function ITraceConnection.getCharSet(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getCharSet(Self);
end;

function ITraceConnection.getRemoteProtocol(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getRemoteProtocol(Self);
end;

function ITraceConnection.getRemoteAddress(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getRemoteAddress(Self);
end;

function ITraceConnection.getRemoteProcessID(): Integer;
begin
  Result := TraceConnectionVTable(vTable).getRemoteProcessID(Self);
end;

function ITraceConnection.getRemoteProcessName(): PAnsiChar;
begin
  Result := TraceConnectionVTable(vTable).getRemoteProcessName(Self);
end;

function ITraceDatabaseConnection.getConnectionID(): Int64;
begin
  Result := TraceDatabaseConnectionVTable(vTable).getConnectionID(Self);
end;

function ITraceDatabaseConnection.getDatabaseName(): PAnsiChar;
begin
  Result := TraceDatabaseConnectionVTable(vTable).getDatabaseName(Self);
end;

function ITraceTransaction.getTransactionID(): Int64;
begin
  Result := TraceTransactionVTable(vTable).getTransactionID(Self);
end;

function ITraceTransaction.getReadOnly(): Boolean;
begin
  Result := TraceTransactionVTable(vTable).getReadOnly(Self);
end;

function ITraceTransaction.getWait(): Integer;
begin
  Result := TraceTransactionVTable(vTable).getWait(Self);
end;

function ITraceTransaction.getIsolation(): Cardinal;
begin
  Result := TraceTransactionVTable(vTable).getIsolation(Self);
end;

function ITraceTransaction.getPerf(): PPerformanceInfo;
begin
  Result := TraceTransactionVTable(vTable).getPerf(Self);
end;

function ITraceTransaction.getInitialID(): Int64;
begin
  if vTable.version < 4
  then Result := 0
  else Result := TraceTransactionVTable(vTable).getInitialID(Self);
end;

function ITraceTransaction.getPreviousID(): Int64;
begin
  if vTable.version < 4
  then Result := 0
  else Result := TraceTransactionVTable(vTable).getPreviousID(Self);
end;

function ITraceParams.getCount(): Cardinal;
begin
  Result := TraceParamsVTable(vTable).getCount(Self);
end;

function ITraceParams.getParam(idx: Cardinal): Pdsc;
begin
  Result := TraceParamsVTable(vTable).getParam(Self, idx);
end;

function ITraceParams.getTextUTF8(status: IStatus; idx: Cardinal): PAnsiChar;
begin
  Result := TraceParamsVTable(vTable).getTextUTF8(Self, status, idx);
end;

function ITraceStatement.getStmtID(): Int64;
begin
  Result := TraceStatementVTable(vTable).getStmtID(Self);
end;

function ITraceStatement.getPerf(): PPerformanceInfo;
begin
  Result := TraceStatementVTable(vTable).getPerf(Self);
end;

function ITraceSQLStatement.getText(): PAnsiChar;
begin
  Result := TraceSQLStatementVTable(vTable).getText(Self);
end;

function ITraceSQLStatement.getPlan(): PAnsiChar;
begin
  Result := TraceSQLStatementVTable(vTable).getPlan(Self);
end;

function ITraceSQLStatement.getInputs(): ITraceParams;
begin
  Result := TraceSQLStatementVTable(vTable).getInputs(Self);
end;

function ITraceSQLStatement.getTextUTF8(): PAnsiChar;
begin
  Result := TraceSQLStatementVTable(vTable).getTextUTF8(Self);
end;

function ITraceSQLStatement.getExplainedPlan(): PAnsiChar;
begin
  Result := TraceSQLStatementVTable(vTable).getExplainedPlan(Self);
end;

function ITraceBLRStatement.getData(): PByte;
begin
  Result := TraceBLRStatementVTable(vTable).getData(Self);
end;

function ITraceBLRStatement.getDataLength(): Cardinal;
begin
  Result := TraceBLRStatementVTable(vTable).getDataLength(Self);
end;

function ITraceBLRStatement.getText(): PAnsiChar;
begin
  Result := TraceBLRStatementVTable(vTable).getText(Self);
end;

function ITraceDYNRequest.getData(): PByte;
begin
  Result := TraceDYNRequestVTable(vTable).getData(Self);
end;

function ITraceDYNRequest.getDataLength(): Cardinal;
begin
  Result := TraceDYNRequestVTable(vTable).getDataLength(Self);
end;

function ITraceDYNRequest.getText(): PAnsiChar;
begin
  Result := TraceDYNRequestVTable(vTable).getText(Self);
end;

function ITraceContextVariable.getNameSpace(): PAnsiChar;
begin
  Result := TraceContextVariableVTable(vTable).getNameSpace(Self);
end;

function ITraceContextVariable.getVarName(): PAnsiChar;
begin
  Result := TraceContextVariableVTable(vTable).getVarName(Self);
end;

function ITraceContextVariable.getVarValue(): PAnsiChar;
begin
  Result := TraceContextVariableVTable(vTable).getVarValue(Self);
end;

function ITraceProcedure.getProcName(): PAnsiChar;
begin
  Result := TraceProcedureVTable(vTable).getProcName(Self);
end;

function ITraceProcedure.getInputs(): ITraceParams;
begin
  Result := TraceProcedureVTable(vTable).getInputs(Self);
end;

function ITraceProcedure.getPerf(): PPerformanceInfo;
begin
  Result := TraceProcedureVTable(vTable).getPerf(Self);
end;

function ITraceFunction.getFuncName(): PAnsiChar;
begin
  Result := TraceFunctionVTable(vTable).getFuncName(Self);
end;

function ITraceFunction.getInputs(): ITraceParams;
begin
  Result := TraceFunctionVTable(vTable).getInputs(Self);
end;

function ITraceFunction.getResult(): ITraceParams;
begin
  Result := TraceFunctionVTable(vTable).getResult(Self);
end;

function ITraceFunction.getPerf(): PPerformanceInfo;
begin
  Result := TraceFunctionVTable(vTable).getPerf(Self);
end;

function ITraceTrigger.getTriggerName(): PAnsiChar;
begin
  Result := TraceTriggerVTable(vTable).getTriggerName(Self);
end;

function ITraceTrigger.getRelationName(): PAnsiChar;
begin
  Result := TraceTriggerVTable(vTable).getRelationName(Self);
end;

function ITraceTrigger.getAction(): Integer;
begin
  Result := TraceTriggerVTable(vTable).getAction(Self);
end;

function ITraceTrigger.getWhich(): Integer;
begin
  Result := TraceTriggerVTable(vTable).getWhich(Self);
end;

function ITraceTrigger.getPerf(): PPerformanceInfo;
begin
  Result := TraceTriggerVTable(vTable).getPerf(Self);
end;

function ITraceServiceConnection.getServiceID(): Pointer;
begin
  Result := TraceServiceConnectionVTable(vTable).getServiceID(Self);
end;

function ITraceServiceConnection.getServiceMgr(): PAnsiChar;
begin
  Result := TraceServiceConnectionVTable(vTable).getServiceMgr(Self);
end;

function ITraceServiceConnection.getServiceName(): PAnsiChar;
begin
  Result := TraceServiceConnectionVTable(vTable).getServiceName(Self);
end;

function ITraceStatusVector.hasError(): Boolean;
begin
  Result := TraceStatusVectorVTable(vTable).hasError(Self);
end;

function ITraceStatusVector.hasWarning(): Boolean;
begin
  Result := TraceStatusVectorVTable(vTable).hasWarning(Self);
end;

function ITraceStatusVector.getStatus(): IStatus;
begin
  Result := TraceStatusVectorVTable(vTable).getStatus(Self);
end;

function ITraceStatusVector.getText(): PAnsiChar;
begin
  Result := TraceStatusVectorVTable(vTable).getText(Self);
end;

function ITraceSweepInfo.getOIT(): Int64;
begin
  Result := TraceSweepInfoVTable(vTable).getOIT(Self);
end;

function ITraceSweepInfo.getOST(): Int64;
begin
  Result := TraceSweepInfoVTable(vTable).getOST(Self);
end;

function ITraceSweepInfo.getOAT(): Int64;
begin
  Result := TraceSweepInfoVTable(vTable).getOAT(Self);
end;

function ITraceSweepInfo.getNext(): Int64;
begin
  Result := TraceSweepInfoVTable(vTable).getNext(Self);
end;

function ITraceSweepInfo.getPerf(): PPerformanceInfo;
begin
  Result := TraceSweepInfoVTable(vTable).getPerf(Self);
end;

function ITraceLogWriter.write(buf: Pointer; size: Cardinal): Cardinal;
begin
  Result := TraceLogWriterVTable(vTable).write(Self, buf, size);
end;

function ITraceLogWriter.write_s(status: IStatus; buf: Pointer; size: Cardinal): Cardinal;
begin
  if vTable.version < 4 then begin
    SetIntfToOldVersionError(status);
    Result := 0;
  end else
    Result := TraceLogWriterVTable(vTable).write_s(Self, status, buf, size);
end;

function ITraceInitInfo.getConfigText(): PAnsiChar;
begin
  Result := TraceInitInfoVTable(vTable).getConfigText(Self);
end;

function ITraceInitInfo.getTraceSessionID(): Integer;
begin
  Result := TraceInitInfoVTable(vTable).getTraceSessionID(Self);
end;

function ITraceInitInfo.getTraceSessionName(): PAnsiChar;
begin
  Result := TraceInitInfoVTable(vTable).getTraceSessionName(Self);
end;

function ITraceInitInfo.getFirebirdRootDirectory(): PAnsiChar;
begin
  Result := TraceInitInfoVTable(vTable).getFirebirdRootDirectory(Self);
end;

function ITraceInitInfo.getDatabaseName(): PAnsiChar;
begin
  Result := TraceInitInfoVTable(vTable).getDatabaseName(Self);
end;

function ITraceInitInfo.getConnection(): ITraceDatabaseConnection;
begin
  Result := TraceInitInfoVTable(vTable).getConnection(Self);
end;

function ITraceInitInfo.getLogWriter(): ITraceLogWriter;
begin
  Result := TraceInitInfoVTable(vTable).getLogWriter(Self);
end;

function ITracePlugin.trace_get_error(): PAnsiChar;
begin
  Result := TracePluginVTable(vTable).trace_get_error(Self);
end;

function ITracePlugin.trace_attach(connection: ITraceDatabaseConnection; create_db: Boolean; att_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_attach(Self, connection, create_db, att_result);
end;

function ITracePlugin.trace_detach(connection: ITraceDatabaseConnection; drop_db: Boolean): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_detach(Self, connection, drop_db);
end;

function ITracePlugin.trace_transaction_start(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; tpb_length: Cardinal; tpb: PByte; tra_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_transaction_start(Self, connection, transaction, tpb_length, tpb, tra_result);
end;

function ITracePlugin.trace_transaction_end(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; commit: Boolean; retain_context: Boolean; tra_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_transaction_end(Self, connection, transaction, commit, retain_context, tra_result);
end;

function ITracePlugin.trace_proc_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; procedure_: ITraceProcedure; started: Boolean; proc_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_proc_execute(Self, connection, transaction, procedure_, started, proc_result);
end;

function ITracePlugin.trace_trigger_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; trigger: ITraceTrigger; started: Boolean; trig_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_trigger_execute(Self, connection, transaction, trigger, started, trig_result);
end;

function ITracePlugin.trace_set_context(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; variable: ITraceContextVariable): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_set_context(Self, connection, transaction, variable);
end;

function ITracePlugin.trace_dsql_prepare(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; time_millis: Int64; req_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_dsql_prepare(Self, connection, transaction, statement, time_millis, req_result);
end;

function ITracePlugin.trace_dsql_free(connection: ITraceDatabaseConnection; statement: ITraceSQLStatement; option: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_dsql_free(Self, connection, statement, option);
end;

function ITracePlugin.trace_dsql_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; started: Boolean; req_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_dsql_execute(Self, connection, transaction, statement, started, req_result);
end;

function ITracePlugin.trace_blr_compile(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; time_millis: Int64; req_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_blr_compile(Self, connection, transaction, statement, time_millis, req_result);
end;

function ITracePlugin.trace_blr_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; req_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_blr_execute(Self, connection, transaction, statement, req_result);
end;

function ITracePlugin.trace_dyn_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; request: ITraceDYNRequest; time_millis: Int64; req_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_dyn_execute(Self, connection, transaction, request, time_millis, req_result);
end;

function ITracePlugin.trace_service_attach(service: ITraceServiceConnection; att_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_service_attach(Self, service, att_result);
end;

function ITracePlugin.trace_service_start(service: ITraceServiceConnection; switches_length: Cardinal; switches: PAnsiChar; start_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_service_start(Self, service, switches_length, switches, start_result);
end;

function ITracePlugin.trace_service_query(service: ITraceServiceConnection; send_item_length: Cardinal; send_items: PByte; recv_item_length: Cardinal; recv_items: PByte; query_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_service_query(Self, service, send_item_length, send_items, recv_item_length, recv_items, query_result);
end;

function ITracePlugin.trace_service_detach(service: ITraceServiceConnection; detach_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_service_detach(Self, service, detach_result);
end;

function ITracePlugin.trace_event_error(connection: ITraceConnection; status: ITraceStatusVector; function_: PAnsiChar): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_event_error(Self, connection, status, function_);
end;

function ITracePlugin.trace_event_sweep(connection: ITraceDatabaseConnection; sweep: ITraceSweepInfo; sweep_state: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_event_sweep(Self, connection, sweep, sweep_state);
end;

function ITracePlugin.trace_func_execute(connection: ITraceDatabaseConnection; transaction: ITraceTransaction; function_: ITraceFunction; started: Boolean; func_result: Cardinal): Boolean;
begin
  Result := TracePluginVTable(vTable).trace_func_execute(Self, connection, transaction, function_, started, func_result);
end;

function ITraceFactory.trace_needs(): UInt64;
begin
  Result := TraceFactoryVTable(vTable).trace_needs(Self);
end;

function ITraceFactory.trace_create(status: IStatus; init_info: ITraceInitInfo): ITracePlugin;
begin
  Result := TraceFactoryVTable(vTable).trace_create(Self, status, init_info);
end;

procedure IUdrFunctionFactory.setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder);
begin
  UdrFunctionFactoryVTable(vTable).setup(Self, status, context, metadata, inBuilder, outBuilder);
end;

function IUdrFunctionFactory.newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalFunction;
begin
  Result := UdrFunctionFactoryVTable(vTable).newItem(Self, status, context, metadata);
end;

procedure IUdrProcedureFactory.setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder);
begin
  UdrProcedureFactoryVTable(vTable).setup(Self, status, context, metadata, inBuilder, outBuilder);
end;

function IUdrProcedureFactory.newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalProcedure;
begin
  Result := UdrProcedureFactoryVTable(vTable).newItem(Self, status, context, metadata);
end;

procedure IUdrTriggerFactory.setup(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder);
begin
  UdrTriggerFactoryVTable(vTable).setup(Self, status, context, metadata, fieldsBuilder);
end;

function IUdrTriggerFactory.newItem(status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalTrigger;
begin
  Result := UdrTriggerFactoryVTable(vTable).newItem(Self, status, context, metadata);
end;

function IUdrPlugin.getMaster(): IMaster;
begin
  Result := UdrPluginVTable(vTable).getMaster(Self);
end;

procedure IUdrPlugin.registerFunction(status: IStatus; name: PAnsiChar; factory: IUdrFunctionFactory);
begin
  UdrPluginVTable(vTable).registerFunction(Self, status, name, factory);
end;

procedure IUdrPlugin.registerProcedure(status: IStatus; name: PAnsiChar; factory: IUdrProcedureFactory);
begin
  UdrPluginVTable(vTable).registerProcedure(Self, status, name, factory);
end;

procedure IUdrPlugin.registerTrigger(status: IStatus; name: PAnsiChar; factory: IUdrTriggerFactory);
begin
  UdrPluginVTable(vTable).registerTrigger(Self, status, name, factory);
end;

procedure IDecFloat16.toBcd(from: PFB_DEC16; sign: PInteger; bcd: PByte; exp: PInteger);
begin
  DecFloat16VTable(vTable).toBcd(Self, from, sign, bcd, exp);
end;

procedure IDecFloat16.toString(status: IStatus; from: PFB_DEC16; bufferLength: Cardinal; buffer: PAnsiChar);
begin
  DecFloat16VTable(vTable).toString(Self, status, from, bufferLength, buffer);
end;

procedure IDecFloat16.fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC16);
begin
  DecFloat16VTable(vTable).fromBcd(Self, sign, bcd, exp, to_);
end;

procedure IDecFloat16.fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC16);
begin
  DecFloat16VTable(vTable).fromString(Self, status, from, to_);
end;

procedure IDecFloat34.toBcd(from: PFB_DEC34; sign: PInteger; bcd: PByte; exp: PInteger);
begin
  DecFloat34VTable(vTable).toBcd(Self, from, sign, bcd, exp);
end;

procedure IDecFloat34.toString(status: IStatus; from: PFB_DEC34; bufferLength: Cardinal; buffer: PAnsiChar);
begin
  DecFloat34VTable(vTable).toString(Self, status, from, bufferLength, buffer);
end;

procedure IDecFloat34.fromBcd(sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC34);
begin
  DecFloat34VTable(vTable).fromBcd(Self, sign, bcd, exp, to_);
end;

procedure IDecFloat34.fromString(status: IStatus; from: PAnsiChar; to_: PFB_DEC34);
begin
  DecFloat34VTable(vTable).fromString(Self, status, from, to_);
end;

procedure IInt128.toString(status: IStatus; from: PFB_I128; scale: Integer; bufferLength: Cardinal; buffer: PAnsiChar);
begin
  Int128VTable(vTable).toString(Self, status, from, scale, bufferLength, buffer);
end;

procedure IInt128.fromString(status: IStatus; scale: Integer; from: PAnsiChar; to_: PFB_I128);
begin
  Int128VTable(vTable).fromString(Self, status, scale, from, to_);
end;

function IReplicatedField.getName(): PAnsiChar;
begin
  Result := ReplicatedFieldVTable(vTable).getName(Self);
end;

function IReplicatedField.getType(): Cardinal;
begin
  Result := ReplicatedFieldVTable(vTable).getType(Self);
end;

function IReplicatedField.getSubType(): Integer;
begin
  Result := ReplicatedFieldVTable(vTable).getSubType(Self);
end;

function IReplicatedField.getScale(): Integer;
begin
  Result := ReplicatedFieldVTable(vTable).getScale(Self);
end;

function IReplicatedField.getLength(): Cardinal;
begin
  Result := ReplicatedFieldVTable(vTable).getLength(Self);
end;

function IReplicatedField.getCharSet(): Cardinal;
begin
  Result := ReplicatedFieldVTable(vTable).getCharSet(Self);
end;

function IReplicatedField.getData(): Pointer;
begin
  Result := ReplicatedFieldVTable(vTable).getData(Self);
end;

function IReplicatedRecord.getCount(): Cardinal;
begin
  Result := ReplicatedRecordVTable(vTable).getCount(Self);
end;

function IReplicatedRecord.getField(index: Cardinal): IReplicatedField;
begin
  Result := ReplicatedRecordVTable(vTable).getField(Self, index);
end;

function IReplicatedRecord.getRawLength(): Cardinal;
begin
  Result := ReplicatedRecordVTable(vTable).getRawLength(Self);
end;

function IReplicatedRecord.getRawData(): PByte;
begin
  Result := ReplicatedRecordVTable(vTable).getRawData(Self);
end;

procedure IReplicatedTransaction.prepare(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).prepare(Self, status);
end;

procedure IReplicatedTransaction.commit(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).commit(Self, status);
end;

procedure IReplicatedTransaction.rollback(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).rollback(Self, status);
end;

procedure IReplicatedTransaction.startSavepoint(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).startSavepoint(Self, status);
end;

procedure IReplicatedTransaction.releaseSavepoint(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).releaseSavepoint(Self, status);
end;

procedure IReplicatedTransaction.rollbackSavepoint(status: IStatus);
begin
  ReplicatedTransactionVTable(vTable).rollbackSavepoint(Self, status);
end;

procedure IReplicatedTransaction.insertRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord);
begin
  ReplicatedTransactionVTable(vTable).insertRecord(Self, status, name, record_);
end;

procedure IReplicatedTransaction.updateRecord(status: IStatus; name: PAnsiChar; orgRecord: IReplicatedRecord; newRecord: IReplicatedRecord);
begin
  ReplicatedTransactionVTable(vTable).updateRecord(Self, status, name, orgRecord, newRecord);
end;

procedure IReplicatedTransaction.deleteRecord(status: IStatus; name: PAnsiChar; record_: IReplicatedRecord);
begin
  ReplicatedTransactionVTable(vTable).deleteRecord(Self, status, name, record_);
end;

procedure IReplicatedTransaction.executeSql(status: IStatus; sql: PAnsiChar);
begin
  ReplicatedTransactionVTable(vTable).executeSql(Self, status, sql);
end;

procedure IReplicatedTransaction.executeSqlIntl(status: IStatus; charset: Cardinal; sql: PAnsiChar);
begin
  ReplicatedTransactionVTable(vTable).executeSqlIntl(Self, status, charset, sql);
end;

procedure IReplicatedSession.setAttachment(attachment: IAttachment);
begin
  ReplicatedSessionVTable(vTable).setAttachment(Self, attachment);
end;

function IReplicatedSession.startTransaction(status: IStatus; transaction: ITransaction; number: Int64): IReplicatedTransaction;
begin
  Result := ReplicatedSessionVTable(vTable).startTransaction(Self, status, transaction, number);
end;

procedure IReplicatedSession.cleanupTransaction(status: IStatus; number: Int64);
begin
  ReplicatedSessionVTable(vTable).cleanupTransaction(Self, status, number);
end;

procedure IReplicatedSession.setSequence(status: IStatus; name: PAnsiChar; value: Int64);
begin
  ReplicatedSessionVTable(vTable).setSequence(Self, status, name, value);
end;

var
  IVersionedImpl_vTable: VersionedVTable;

constructor IVersionedImpl.create;
begin
  vTable := IVersionedImpl_vTable;
end;

procedure IReferenceCountedImpl_addRefDispatcher(this: IReferenceCounted); cdecl;
begin
  IReferenceCountedImpl(this).addRef();
end;

function IReferenceCountedImpl_releaseDispatcher(this: IReferenceCounted): Integer; cdecl;
begin
  Result := IReferenceCountedImpl(this).release();
end;

var
  IReferenceCountedImpl_vTable: ReferenceCountedVTable;

constructor IReferenceCountedImpl.create;
begin
  vTable := IReferenceCountedImpl_vTable;
end;

procedure IDisposableImpl_disposeDispatcher(this: IDisposable); cdecl;
begin
  IDisposableImpl(this).dispose();
end;

var
  IDisposableImpl_vTable: DisposableVTable;

constructor IDisposableImpl.create;
begin
  vTable := IDisposableImpl_vTable;
end;

procedure IStatusImpl_disposeDispatcher(this: IStatus); cdecl;
begin
  IStatusImpl(this).dispose();
end;

procedure IStatusImpl_initDispatcher(this: IStatus); cdecl;
begin
  IStatusImpl(this).init();
end;

function IStatusImpl_getStateDispatcher(this: IStatus): Cardinal; cdecl;
begin
  Result := IStatusImpl(this).getState();
end;

procedure IStatusImpl_setErrors2Dispatcher(this: IStatus; length: Cardinal; value: PNativeInt); cdecl;
begin
  IStatusImpl(this).setErrors2(length, value);
end;

procedure IStatusImpl_setWarnings2Dispatcher(this: IStatus; length: Cardinal; value: PNativeInt); cdecl;
begin
  IStatusImpl(this).setWarnings2(length, value);
end;

procedure IStatusImpl_setErrorsDispatcher(this: IStatus; value: PNativeInt); cdecl;
begin
  IStatusImpl(this).setErrors(value);
end;

procedure IStatusImpl_setWarningsDispatcher(this: IStatus; value: PNativeInt); cdecl;
begin
  IStatusImpl(this).setWarnings(value);
end;

function IStatusImpl_getErrorsDispatcher(this: IStatus): PNativeInt; cdecl;
begin
  Result := IStatusImpl(this).getErrors();
end;

function IStatusImpl_getWarningsDispatcher(this: IStatus): PNativeInt; cdecl;
begin
  Result := IStatusImpl(this).getWarnings();
end;

function IStatusImpl_cloneDispatcher(this: IStatus): IStatus; cdecl;
begin
  Result := IStatusImpl(this).clone();
end;

var
  IStatusImpl_vTable: StatusVTable;

constructor IStatusImpl.create;
begin
  vTable := IStatusImpl_vTable;
end;

function IMasterImpl_getStatusDispatcher(this: IMaster): IStatus; cdecl;
begin
  Result := IMasterImpl(this).getStatus();
end;

function IMasterImpl_getDispatcherDispatcher(this: IMaster): IProvider; cdecl;
begin
  Result := IMasterImpl(this).getDispatcher();
end;

function IMasterImpl_getPluginManagerDispatcher(this: IMaster): IPluginManager; cdecl;
begin
  Result := IMasterImpl(this).getPluginManager();
end;

function IMasterImpl_getTimerControlDispatcher(this: IMaster): ITimerControl; cdecl;
begin
  Result := IMasterImpl(this).getTimerControl();
end;

function IMasterImpl_getDtcDispatcher(this: IMaster): IDtc; cdecl;
begin
  Result := IMasterImpl(this).getDtc();
end;

function IMasterImpl_registerAttachmentDispatcher(this: IMaster; provider: IProvider; attachment: IAttachment): IAttachment; cdecl;
begin
  Result := IMasterImpl(this).registerAttachment(provider, attachment);
end;

function IMasterImpl_registerTransactionDispatcher(this: IMaster; attachment: IAttachment; transaction: ITransaction): ITransaction; cdecl;
begin
  Result := IMasterImpl(this).registerTransaction(attachment, transaction);
end;

function IMasterImpl_getMetadataBuilderDispatcher(this: IMaster; status: IStatus; fieldCount: Cardinal): IMetadataBuilder; cdecl;
begin
  Result := IMasterImpl(this).getMetadataBuilder(status, fieldCount);
end;

function IMasterImpl_serverModeDispatcher(this: IMaster; mode: Integer): Integer; cdecl;
begin
  Result := IMasterImpl(this).serverMode(mode);
end;

function IMasterImpl_getUtilInterfaceDispatcher(this: IMaster): IUtil; cdecl;
begin
  Result := IMasterImpl(this).getUtilInterface();
end;

function IMasterImpl_getConfigManagerDispatcher(this: IMaster): IConfigManager; cdecl;
begin
  Result := IMasterImpl(this).getConfigManager();
end;

function IMasterImpl_getProcessExitingDispatcher(this: IMaster): Boolean; cdecl;
begin
  Result := IMasterImpl(this).getProcessExiting();
end;

var
  IMasterImpl_vTable: MasterVTable;

constructor IMasterImpl.create;
begin
  vTable := IMasterImpl_vTable;
end;

procedure IPluginBaseImpl_addRefDispatcher(this: IPluginBase); cdecl;
begin
  IPluginBaseImpl(this).addRef();
end;

function IPluginBaseImpl_releaseDispatcher(this: IPluginBase): Integer; cdecl;
begin
  Result := IPluginBaseImpl(this).release();
end;

procedure IPluginBaseImpl_setOwnerDispatcher(this: IPluginBase; r: IReferenceCounted); cdecl;
begin
  IPluginBaseImpl(this).setOwner(r);
end;

function IPluginBaseImpl_getOwnerDispatcher(this: IPluginBase): IReferenceCounted; cdecl;
begin
  Result := IPluginBaseImpl(this).getOwner();
end;

var
  IPluginBaseImpl_vTable: PluginBaseVTable;

constructor IPluginBaseImpl.create;
begin
  vTable := IPluginBaseImpl_vTable;
end;

procedure IPluginSetImpl_addRefDispatcher(this: IPluginSet); cdecl;
begin
  IPluginSetImpl(this).addRef();
end;

function IPluginSetImpl_releaseDispatcher(this: IPluginSet): Integer; cdecl;
begin
  Result := IPluginSetImpl(this).release();
end;

function IPluginSetImpl_getNameDispatcher(this: IPluginSet): PAnsiChar; cdecl;
begin
  Result := IPluginSetImpl(this).getName();
end;

function IPluginSetImpl_getModuleNameDispatcher(this: IPluginSet): PAnsiChar; cdecl;
begin
  Result := IPluginSetImpl(this).getModuleName();
end;

function IPluginSetImpl_getPluginDispatcher(this: IPluginSet; status: IStatus): IPluginBase; cdecl;
begin
  Result := IPluginSetImpl(this).getPlugin(status);
end;

procedure IPluginSetImpl_nextDispatcher(this: IPluginSet; status: IStatus); cdecl;
begin
  IPluginSetImpl(this).next(status);
end;

procedure IPluginSetImpl_set_Dispatcher(this: IPluginSet; status: IStatus; s: PAnsiChar); cdecl;
begin
  IPluginSetImpl(this).set_(status, s);
end;

var
  IPluginSetImpl_vTable: PluginSetVTable;

constructor IPluginSetImpl.create;
begin
  vTable := IPluginSetImpl_vTable;
end;

procedure IConfigEntryImpl_addRefDispatcher(this: IConfigEntry); cdecl;
begin
  IConfigEntryImpl(this).addRef();
end;

function IConfigEntryImpl_releaseDispatcher(this: IConfigEntry): Integer; cdecl;
begin
  Result := IConfigEntryImpl(this).release();
end;

function IConfigEntryImpl_getNameDispatcher(this: IConfigEntry): PAnsiChar; cdecl;
begin
  Result := IConfigEntryImpl(this).getName();
end;

function IConfigEntryImpl_getValueDispatcher(this: IConfigEntry): PAnsiChar; cdecl;
begin
  Result := IConfigEntryImpl(this).getValue();
end;

function IConfigEntryImpl_getIntValueDispatcher(this: IConfigEntry): Int64; cdecl;
begin
  Result := IConfigEntryImpl(this).getIntValue();
end;

function IConfigEntryImpl_getBoolValueDispatcher(this: IConfigEntry): Boolean; cdecl;
begin
  Result := IConfigEntryImpl(this).getBoolValue();
end;

function IConfigEntryImpl_getSubConfigDispatcher(this: IConfigEntry; status: IStatus): IConfig; cdecl;
begin
  Result := IConfigEntryImpl(this).getSubConfig(status);
end;

var
  IConfigEntryImpl_vTable: ConfigEntryVTable;

constructor IConfigEntryImpl.create;
begin
  vTable := IConfigEntryImpl_vTable;
end;

procedure IConfigImpl_addRefDispatcher(this: IConfig); cdecl;
begin
  IConfigImpl(this).addRef();
end;

function IConfigImpl_releaseDispatcher(this: IConfig): Integer; cdecl;
begin
  Result := IConfigImpl(this).release();
end;

function IConfigImpl_findDispatcher(this: IConfig; status: IStatus; name: PAnsiChar): IConfigEntry; cdecl;
begin
  Result := IConfigImpl(this).find(status, name);
end;

function IConfigImpl_findValueDispatcher(this: IConfig; status: IStatus; name: PAnsiChar; value: PAnsiChar): IConfigEntry; cdecl;
begin
  Result := IConfigImpl(this).findValue(status, name, value);
end;

function IConfigImpl_findPosDispatcher(this: IConfig; status: IStatus; name: PAnsiChar; pos: Cardinal): IConfigEntry; cdecl;
begin
  Result := IConfigImpl(this).findPos(status, name, pos);
end;

var
  IConfigImpl_vTable: ConfigVTable;

constructor IConfigImpl.create;
begin
  vTable := IConfigImpl_vTable;
end;

procedure IFirebirdConfImpl_addRefDispatcher(this: IFirebirdConf); cdecl;
begin
  IFirebirdConfImpl(this).addRef();
end;

function IFirebirdConfImpl_releaseDispatcher(this: IFirebirdConf): Integer; cdecl;
begin
  Result := IFirebirdConfImpl(this).release();
end;

function IFirebirdConfImpl_getKeyDispatcher(this: IFirebirdConf; name: PAnsiChar): Cardinal; cdecl;
begin
  Result := IFirebirdConfImpl(this).getKey(name);
end;

function IFirebirdConfImpl_asIntegerDispatcher(this: IFirebirdConf; key: Cardinal): Int64; cdecl;
begin
  Result := IFirebirdConfImpl(this).asInteger(key);
end;

function IFirebirdConfImpl_asStringDispatcher(this: IFirebirdConf; key: Cardinal): PAnsiChar; cdecl;
begin
  Result := IFirebirdConfImpl(this).asString(key);
end;

function IFirebirdConfImpl_asBooleanDispatcher(this: IFirebirdConf; key: Cardinal): Boolean; cdecl;
begin
  Result := IFirebirdConfImpl(this).asBoolean(key);
end;

function IFirebirdConfImpl_getVersionDispatcher(this: IFirebirdConf; status: IStatus): Cardinal; cdecl;
begin
  Result := IFirebirdConfImpl(this).getVersion(status);
end;

var
  IFirebirdConfImpl_vTable: FirebirdConfVTable;

constructor IFirebirdConfImpl.create;
begin
  vTable := IFirebirdConfImpl_vTable;
end;

procedure IPluginConfigImpl_addRefDispatcher(this: IPluginConfig); cdecl;
begin
  IPluginConfigImpl(this).addRef();
end;

function IPluginConfigImpl_releaseDispatcher(this: IPluginConfig): Integer; cdecl;
begin
  Result := IPluginConfigImpl(this).release();
end;

function IPluginConfigImpl_getConfigFileNameDispatcher(this: IPluginConfig): PAnsiChar; cdecl;
begin
  Result := IPluginConfigImpl(this).getConfigFileName();
end;

function IPluginConfigImpl_getDefaultConfigDispatcher(this: IPluginConfig; status: IStatus): IConfig; cdecl;
begin
  Result := IPluginConfigImpl(this).getDefaultConfig(status);
end;

function IPluginConfigImpl_getFirebirdConfDispatcher(this: IPluginConfig; status: IStatus): IFirebirdConf; cdecl;
begin
  Result := IPluginConfigImpl(this).getFirebirdConf(status);
end;

procedure IPluginConfigImpl_setReleaseDelayDispatcher(this: IPluginConfig; status: IStatus; microSeconds: UInt64); cdecl;
begin
  IPluginConfigImpl(this).setReleaseDelay(status, microSeconds);
end;

var
  IPluginConfigImpl_vTable: PluginConfigVTable;

constructor IPluginConfigImpl.create;
begin
  vTable := IPluginConfigImpl_vTable;
end;

function IPluginFactoryImpl_createPluginDispatcher(this: IPluginFactory; status: IStatus; factoryParameter: IPluginConfig): IPluginBase; cdecl;
begin
  Result := IPluginFactoryImpl(this).createPlugin(status, factoryParameter);
end;

var
  IPluginFactoryImpl_vTable: PluginFactoryVTable;

constructor IPluginFactoryImpl.create;
begin
  vTable := IPluginFactoryImpl_vTable;
end;

procedure IPluginModuleImpl_doCleanDispatcher(this: IPluginModule); cdecl;
begin
  IPluginModuleImpl(this).doClean();
end;

procedure IPluginModuleImpl_threadDetachDispatcher(this: IPluginModule); cdecl;
begin
  IPluginModuleImpl(this).threadDetach();
end;

var
  IPluginModuleImpl_vTable: PluginModuleVTable;

constructor IPluginModuleImpl.create;
begin
  vTable := IPluginModuleImpl_vTable;
end;

procedure IPluginManagerImpl_registerPluginFactoryDispatcher(this: IPluginManager; pluginType: Cardinal; defaultName: PAnsiChar; factory: IPluginFactory); cdecl;
begin
  IPluginManagerImpl(this).registerPluginFactory(pluginType, defaultName, factory);
end;

procedure IPluginManagerImpl_registerModuleDispatcher(this: IPluginManager; cleanup: IPluginModule); cdecl;
begin
  IPluginManagerImpl(this).registerModule(cleanup);
end;

procedure IPluginManagerImpl_unregisterModuleDispatcher(this: IPluginManager; cleanup: IPluginModule); cdecl;
begin
  IPluginManagerImpl(this).unregisterModule(cleanup);
end;

function IPluginManagerImpl_getPluginsDispatcher(this: IPluginManager; status: IStatus; pluginType: Cardinal; namesList: PAnsiChar; firebirdConf: IFirebirdConf): IPluginSet; cdecl;
begin
  Result := IPluginManagerImpl(this).getPlugins(status, pluginType, namesList, firebirdConf);
end;

function IPluginManagerImpl_getConfigDispatcher(this: IPluginManager; status: IStatus; filename: PAnsiChar): IConfig; cdecl;
begin
  Result := IPluginManagerImpl(this).getConfig(status, filename);
end;

procedure IPluginManagerImpl_releasePluginDispatcher(this: IPluginManager; plugin: IPluginBase); cdecl;
begin
  IPluginManagerImpl(this).releasePlugin(plugin);
end;

var
  IPluginManagerImpl_vTable: PluginManagerVTable;

constructor IPluginManagerImpl.create;
begin
  vTable := IPluginManagerImpl_vTable;
end;

procedure ICryptKeyImpl_setSymmetricDispatcher(this: ICryptKey; status: IStatus; type_: PAnsiChar; keyLength: Cardinal; key: Pointer); cdecl;
begin
  ICryptKeyImpl(this).setSymmetric(status, type_, keyLength, key);
end;

procedure ICryptKeyImpl_setAsymmetricDispatcher(this: ICryptKey; status: IStatus; type_: PAnsiChar; encryptKeyLength: Cardinal; encryptKey: Pointer; decryptKeyLength: Cardinal; decryptKey: Pointer); cdecl;
begin
  ICryptKeyImpl(this).setAsymmetric(status, type_, encryptKeyLength, encryptKey, decryptKeyLength, decryptKey);
end;

function ICryptKeyImpl_getEncryptKeyDispatcher(this: ICryptKey; length: PCardinal): Pointer; cdecl;
begin
  Result := ICryptKeyImpl(this).getEncryptKey(length);
end;

function ICryptKeyImpl_getDecryptKeyDispatcher(this: ICryptKey; length: PCardinal): Pointer; cdecl;
begin
  Result := ICryptKeyImpl(this).getDecryptKey(length);
end;

var
  ICryptKeyImpl_vTable: CryptKeyVTable;

constructor ICryptKeyImpl.create;
begin
  vTable := ICryptKeyImpl_vTable;
end;

function IConfigManagerImpl_getDirectoryDispatcher(this: IConfigManager; code: Cardinal): PAnsiChar; cdecl;
begin
  Result := IConfigManagerImpl(this).getDirectory(code);
end;

function IConfigManagerImpl_getFirebirdConfDispatcher(this: IConfigManager): IFirebirdConf; cdecl;
begin
  Result := IConfigManagerImpl(this).getFirebirdConf();
end;

function IConfigManagerImpl_getDatabaseConfDispatcher(this: IConfigManager; dbName: PAnsiChar): IFirebirdConf; cdecl;
begin
  Result := IConfigManagerImpl(this).getDatabaseConf(dbName);
end;

function IConfigManagerImpl_getPluginConfigDispatcher(this: IConfigManager; configuredPlugin: PAnsiChar): IConfig; cdecl;
begin
  Result := IConfigManagerImpl(this).getPluginConfig(configuredPlugin);
end;

function IConfigManagerImpl_getInstallDirectoryDispatcher(this: IConfigManager): PAnsiChar; cdecl;
begin
  Result := IConfigManagerImpl(this).getInstallDirectory();
end;

function IConfigManagerImpl_getRootDirectoryDispatcher(this: IConfigManager): PAnsiChar; cdecl;
begin
  Result := IConfigManagerImpl(this).getRootDirectory();
end;

function IConfigManagerImpl_getDefaultSecurityDbDispatcher(this: IConfigManager): PAnsiChar; cdecl;
begin
  Result := IConfigManagerImpl(this).getDefaultSecurityDb();
end;

var
  IConfigManagerImpl_vTable: ConfigManagerVTable;

constructor IConfigManagerImpl.create;
begin
  vTable := IConfigManagerImpl_vTable;
end;

procedure IEventCallbackImpl_addRefDispatcher(this: IEventCallback); cdecl;
begin
  IEventCallbackImpl(this).addRef();
end;

function IEventCallbackImpl_releaseDispatcher(this: IEventCallback): Integer; cdecl;
begin
  Result := IEventCallbackImpl(this).release();
end;

procedure IEventCallbackImpl_eventCallbackFunctionDispatcher(this: IEventCallback; length: Cardinal; events: PByte); cdecl;
begin
  IEventCallbackImpl(this).eventCallbackFunction(length, events);
end;

var
  IEventCallbackImpl_vTable: EventCallbackVTable;

constructor IEventCallbackImpl.create;
begin
  vTable := IEventCallbackImpl_vTable;
end;

procedure IBlobImpl_addRefDispatcher(this: IBlob); cdecl;
begin
  IBlobImpl(this).addRef();
end;

function IBlobImpl_releaseDispatcher(this: IBlob): Integer; cdecl;
begin
  Result := IBlobImpl(this).release();
end;

procedure IBlobImpl_getInfoDispatcher(this: IBlob; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  IBlobImpl(this).getInfo(status, itemsLength, items, bufferLength, buffer);
end;

function IBlobImpl_getSegmentDispatcher(this: IBlob; status: IStatus; bufferLength: Cardinal; buffer: Pointer; segmentLength: PCardinal): Integer; cdecl;
begin
  Result := IBlobImpl(this).getSegment(status, bufferLength, buffer, segmentLength);
end;

procedure IBlobImpl_putSegmentDispatcher(this: IBlob; status: IStatus; length: Cardinal; buffer: Pointer); cdecl;
begin
  IBlobImpl(this).putSegment(status, length, buffer);
end;

procedure IBlobImpl_cancelDispatcher(this: IBlob; status: IStatus); cdecl;
begin
  IBlobImpl(this).cancel(status);
end;

procedure IBlobImpl_closeDispatcher(this: IBlob; status: IStatus); cdecl;
begin
  IBlobImpl(this).close(status);
end;

function IBlobImpl_seekDispatcher(this: IBlob; status: IStatus; mode: Integer; offset: Integer): Integer; cdecl;
begin
  Result := IBlobImpl(this).seek(status, mode, offset);
end;

var
  IBlobImpl_vTable: BlobVTable;

constructor IBlobImpl.create;
begin
  vTable := IBlobImpl_vTable;
end;

procedure ITransactionImpl_addRefDispatcher(this: ITransaction); cdecl;
begin
  ITransactionImpl(this).addRef();
end;

function ITransactionImpl_releaseDispatcher(this: ITransaction): Integer; cdecl;
begin
  Result := ITransactionImpl(this).release();
end;

procedure ITransactionImpl_getInfoDispatcher(this: ITransaction; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  ITransactionImpl(this).getInfo(status, itemsLength, items, bufferLength, buffer);
end;

procedure ITransactionImpl_prepareDispatcher(this: ITransaction; status: IStatus; msgLength: Cardinal; message: PByte); cdecl;
begin
  ITransactionImpl(this).prepare(status, msgLength, message);
end;

procedure ITransactionImpl_commitDispatcher(this: ITransaction; status: IStatus); cdecl;
begin
  ITransactionImpl(this).commit(status);
end;

procedure ITransactionImpl_commitRetainingDispatcher(this: ITransaction; status: IStatus); cdecl;
begin
  ITransactionImpl(this).commitRetaining(status);
end;

procedure ITransactionImpl_rollbackDispatcher(this: ITransaction; status: IStatus); cdecl;
begin
  ITransactionImpl(this).rollback(status);
end;

procedure ITransactionImpl_rollbackRetainingDispatcher(this: ITransaction; status: IStatus); cdecl;
begin
  ITransactionImpl(this).rollbackRetaining(status);
end;

procedure ITransactionImpl_disconnectDispatcher(this: ITransaction; status: IStatus); cdecl;
begin
  ITransactionImpl(this).disconnect(status);
end;

function ITransactionImpl_joinDispatcher(this: ITransaction; status: IStatus; transaction: ITransaction): ITransaction; cdecl;
begin
  Result := ITransactionImpl(this).join(status, transaction);
end;

function ITransactionImpl_validateDispatcher(this: ITransaction; status: IStatus; attachment: IAttachment): ITransaction; cdecl;
begin
  Result := ITransactionImpl(this).validate(status, attachment);
end;

function ITransactionImpl_enterDtcDispatcher(this: ITransaction; status: IStatus): ITransaction; cdecl;
begin
  Result := ITransactionImpl(this).enterDtc(status);
end;

var
  ITransactionImpl_vTable: TransactionVTable;

constructor ITransactionImpl.create;
begin
  vTable := ITransactionImpl_vTable;
end;

procedure IMessageMetadataImpl_addRefDispatcher(this: IMessageMetadata); cdecl;
begin
  IMessageMetadataImpl(this).addRef();
end;

function IMessageMetadataImpl_releaseDispatcher(this: IMessageMetadata): Integer; cdecl;
begin
  Result := IMessageMetadataImpl(this).release();
end;

function IMessageMetadataImpl_getCountDispatcher(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getCount(status);
end;

function IMessageMetadataImpl_getFieldDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
begin
  Result := IMessageMetadataImpl(this).getField(status, index);
end;

function IMessageMetadataImpl_getRelationDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
begin
  Result := IMessageMetadataImpl(this).getRelation(status, index);
end;

function IMessageMetadataImpl_getOwnerDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
begin
  Result := IMessageMetadataImpl(this).getOwner(status, index);
end;

function IMessageMetadataImpl_getAliasDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): PAnsiChar; cdecl;
begin
  Result := IMessageMetadataImpl(this).getAlias(status, index);
end;

function IMessageMetadataImpl_getTypeDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getType(status, index);
end;

function IMessageMetadataImpl_isNullableDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Boolean; cdecl;
begin
  Result := IMessageMetadataImpl(this).isNullable(status, index);
end;

function IMessageMetadataImpl_getSubTypeDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Integer; cdecl;
begin
  Result := IMessageMetadataImpl(this).getSubType(status, index);
end;

function IMessageMetadataImpl_getLengthDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getLength(status, index);
end;

function IMessageMetadataImpl_getScaleDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Integer; cdecl;
begin
  Result := IMessageMetadataImpl(this).getScale(status, index);
end;

function IMessageMetadataImpl_getCharSetDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getCharSet(status, index);
end;

function IMessageMetadataImpl_getOffsetDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getOffset(status, index);
end;

function IMessageMetadataImpl_getNullOffsetDispatcher(this: IMessageMetadata; status: IStatus; index: Cardinal): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getNullOffset(status, index);
end;

function IMessageMetadataImpl_getBuilderDispatcher(this: IMessageMetadata; status: IStatus): IMetadataBuilder; cdecl;
begin
  Result := IMessageMetadataImpl(this).getBuilder(status);
end;

function IMessageMetadataImpl_getMessageLengthDispatcher(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getMessageLength(status);
end;

function IMessageMetadataImpl_getAlignmentDispatcher(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getAlignment(status);
end;

function IMessageMetadataImpl_getAlignedLengthDispatcher(this: IMessageMetadata; status: IStatus): Cardinal; cdecl;
begin
  Result := IMessageMetadataImpl(this).getAlignedLength(status);
end;

var
  IMessageMetadataImpl_vTable: MessageMetadataVTable;

constructor IMessageMetadataImpl.create;
begin
  vTable := IMessageMetadataImpl_vTable;
end;

procedure IMetadataBuilderImpl_addRefDispatcher(this: IMetadataBuilder); cdecl;
begin
  IMetadataBuilderImpl(this).addRef();
end;

function IMetadataBuilderImpl_releaseDispatcher(this: IMetadataBuilder): Integer; cdecl;
begin
  Result := IMetadataBuilderImpl(this).release();
end;

procedure IMetadataBuilderImpl_setTypeDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; type_: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).setType(status, index, type_);
end;

procedure IMetadataBuilderImpl_setSubTypeDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; subType: Integer); cdecl;
begin
  IMetadataBuilderImpl(this).setSubType(status, index, subType);
end;

procedure IMetadataBuilderImpl_setLengthDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; length: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).setLength(status, index, length);
end;

procedure IMetadataBuilderImpl_setCharSetDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; charSet: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).setCharSet(status, index, charSet);
end;

procedure IMetadataBuilderImpl_setScaleDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; scale: Integer); cdecl;
begin
  IMetadataBuilderImpl(this).setScale(status, index, scale);
end;

procedure IMetadataBuilderImpl_truncateDispatcher(this: IMetadataBuilder; status: IStatus; count: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).truncate(status, count);
end;

procedure IMetadataBuilderImpl_moveNameToIndexDispatcher(this: IMetadataBuilder; status: IStatus; name: PAnsiChar; index: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).moveNameToIndex(status, name, index);
end;

procedure IMetadataBuilderImpl_removeDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal); cdecl;
begin
  IMetadataBuilderImpl(this).remove(status, index);
end;

function IMetadataBuilderImpl_addFieldDispatcher(this: IMetadataBuilder; status: IStatus): Cardinal; cdecl;
begin
  Result := IMetadataBuilderImpl(this).addField(status);
end;

function IMetadataBuilderImpl_getMetadataDispatcher(this: IMetadataBuilder; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IMetadataBuilderImpl(this).getMetadata(status);
end;

procedure IMetadataBuilderImpl_setFieldDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; field: PAnsiChar); cdecl;
begin
  IMetadataBuilderImpl(this).setField(status, index, field);
end;

procedure IMetadataBuilderImpl_setRelationDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; relation: PAnsiChar); cdecl;
begin
  IMetadataBuilderImpl(this).setRelation(status, index, relation);
end;

procedure IMetadataBuilderImpl_setOwnerDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; owner: PAnsiChar); cdecl;
begin
  IMetadataBuilderImpl(this).setOwner(status, index, owner);
end;

procedure IMetadataBuilderImpl_setAliasDispatcher(this: IMetadataBuilder; status: IStatus; index: Cardinal; alias: PAnsiChar); cdecl;
begin
  IMetadataBuilderImpl(this).setAlias(status, index, alias);
end;

var
  IMetadataBuilderImpl_vTable: MetadataBuilderVTable;

constructor IMetadataBuilderImpl.create;
begin
  vTable := IMetadataBuilderImpl_vTable;
end;

procedure IResultSetImpl_addRefDispatcher(this: IResultSet); cdecl;
begin
  IResultSetImpl(this).addRef();
end;

function IResultSetImpl_releaseDispatcher(this: IResultSet): Integer; cdecl;
begin
  Result := IResultSetImpl(this).release();
end;

function IResultSetImpl_fetchNextDispatcher(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchNext(status, message);
end;

function IResultSetImpl_fetchPriorDispatcher(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchPrior(status, message);
end;

function IResultSetImpl_fetchFirstDispatcher(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchFirst(status, message);
end;

function IResultSetImpl_fetchLastDispatcher(this: IResultSet; status: IStatus; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchLast(status, message);
end;

function IResultSetImpl_fetchAbsoluteDispatcher(this: IResultSet; status: IStatus; position: Integer; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchAbsolute(status, position, message);
end;

function IResultSetImpl_fetchRelativeDispatcher(this: IResultSet; status: IStatus; offset: Integer; message: Pointer): Integer; cdecl;
begin
  Result := IResultSetImpl(this).fetchRelative(status, offset, message);
end;

function IResultSetImpl_isEofDispatcher(this: IResultSet; status: IStatus): Boolean; cdecl;
begin
  Result := IResultSetImpl(this).isEof(status);
end;

function IResultSetImpl_isBofDispatcher(this: IResultSet; status: IStatus): Boolean; cdecl;
begin
  Result := IResultSetImpl(this).isBof(status);
end;

function IResultSetImpl_getMetadataDispatcher(this: IResultSet; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IResultSetImpl(this).getMetadata(status);
end;

procedure IResultSetImpl_closeDispatcher(this: IResultSet; status: IStatus); cdecl;
begin
  IResultSetImpl(this).close(status);
end;

procedure IResultSetImpl_setDelayedOutputFormatDispatcher(this: IResultSet; status: IStatus; format: IMessageMetadata); cdecl;
begin
  IResultSetImpl(this).setDelayedOutputFormat(status, format);
end;

var
  IResultSetImpl_vTable: ResultSetVTable;

constructor IResultSetImpl.create;
begin
  vTable := IResultSetImpl_vTable;
end;

procedure IStatementImpl_addRefDispatcher(this: IStatement); cdecl;
begin
  IStatementImpl(this).addRef();
end;

function IStatementImpl_releaseDispatcher(this: IStatement): Integer; cdecl;
begin
  Result := IStatementImpl(this).release();
end;

procedure IStatementImpl_getInfoDispatcher(this: IStatement; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  IStatementImpl(this).getInfo(status, itemsLength, items, bufferLength, buffer);
end;

function IStatementImpl_getTypeDispatcher(this: IStatement; status: IStatus): Cardinal; cdecl;
begin
  Result := IStatementImpl(this).getType(status);
end;

function IStatementImpl_getPlanDispatcher(this: IStatement; status: IStatus; detailed: Boolean): PAnsiChar; cdecl;
begin
  Result := IStatementImpl(this).getPlan(status, detailed);
end;

function IStatementImpl_getAffectedRecordsDispatcher(this: IStatement; status: IStatus): UInt64; cdecl;
begin
  Result := IStatementImpl(this).getAffectedRecords(status);
end;

function IStatementImpl_getInputMetadataDispatcher(this: IStatement; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IStatementImpl(this).getInputMetadata(status);
end;

function IStatementImpl_getOutputMetadataDispatcher(this: IStatement; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IStatementImpl(this).getOutputMetadata(status);
end;

function IStatementImpl_executeDispatcher(this: IStatement; status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; cdecl;
begin
  Result := IStatementImpl(this).execute(status, transaction, inMetadata, inBuffer, outMetadata, outBuffer);
end;

function IStatementImpl_openCursorDispatcher(this: IStatement; status: IStatus; transaction: ITransaction; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; flags: Cardinal): IResultSet; cdecl;
begin
  Result := IStatementImpl(this).openCursor(status, transaction, inMetadata, inBuffer, outMetadata, flags);
end;

procedure IStatementImpl_setCursorNameDispatcher(this: IStatement; status: IStatus; name: PAnsiChar); cdecl;
begin
  IStatementImpl(this).setCursorName(status, name);
end;

procedure IStatementImpl_freeDispatcher(this: IStatement; status: IStatus); cdecl;
begin
  IStatementImpl(this).free(status);
end;

function IStatementImpl_getFlagsDispatcher(this: IStatement; status: IStatus): Cardinal; cdecl;
begin
  Result := IStatementImpl(this).getFlags(status);
end;

function IStatementImpl_getTimeoutDispatcher(this: IStatement; status: IStatus): Cardinal; cdecl;
begin
  Result := IStatementImpl(this).getTimeout(status);
end;

procedure IStatementImpl_setTimeoutDispatcher(this: IStatement; status: IStatus; timeOut: Cardinal); cdecl;
begin
  IStatementImpl(this).setTimeout(status, timeOut);
end;

function IStatementImpl_createBatchDispatcher(this: IStatement; status: IStatus; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; cdecl;
begin
  Result := IStatementImpl(this).createBatch(status, inMetadata, parLength, par);
end;

var
  IStatementImpl_vTable: StatementVTable;

constructor IStatementImpl.create;
begin
  vTable := IStatementImpl_vTable;
end;

procedure IBatchImpl_addRefDispatcher(this: IBatch); cdecl;
begin
  IBatchImpl(this).addRef();
end;

function IBatchImpl_releaseDispatcher(this: IBatch): Integer; cdecl;
begin
  Result := IBatchImpl(this).release();
end;

procedure IBatchImpl_addDispatcher(this: IBatch; status: IStatus; count: Cardinal; inBuffer: Pointer); cdecl;
begin
  IBatchImpl(this).add(status, count, inBuffer);
end;

procedure IBatchImpl_addBlobDispatcher(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer; blobId: PISC_QUAD; parLength: Cardinal; par: PByte); cdecl;
begin
  IBatchImpl(this).addBlob(status, length, inBuffer, blobId, parLength, par);
end;

procedure IBatchImpl_appendBlobDataDispatcher(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer); cdecl;
begin
  IBatchImpl(this).appendBlobData(status, length, inBuffer);
end;

procedure IBatchImpl_addBlobStreamDispatcher(this: IBatch; status: IStatus; length: Cardinal; inBuffer: Pointer); cdecl;
begin
  IBatchImpl(this).addBlobStream(status, length, inBuffer);
end;

procedure IBatchImpl_registerBlobDispatcher(this: IBatch; status: IStatus; existingBlob: PISC_QUAD; blobId: PISC_QUAD); cdecl;
begin
  IBatchImpl(this).registerBlob(status, existingBlob, blobId);
end;

function IBatchImpl_executeDispatcher(this: IBatch; status: IStatus; transaction: ITransaction): IBatchCompletionState; cdecl;
begin
  Result := IBatchImpl(this).execute(status, transaction);
end;

procedure IBatchImpl_cancelDispatcher(this: IBatch; status: IStatus); cdecl;
begin
  IBatchImpl(this).cancel(status);
end;

function IBatchImpl_getBlobAlignmentDispatcher(this: IBatch; status: IStatus): Cardinal; cdecl;
begin
  Result := IBatchImpl(this).getBlobAlignment(status);
end;

function IBatchImpl_getMetadataDispatcher(this: IBatch; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IBatchImpl(this).getMetadata(status);
end;

procedure IBatchImpl_setDefaultBpbDispatcher(this: IBatch; status: IStatus; parLength: Cardinal; par: PByte); cdecl;
begin
  IBatchImpl(this).setDefaultBpb(status, parLength, par);
end;

var
  IBatchImpl_vTable: BatchVTable;

constructor IBatchImpl.create;
begin
  vTable := IBatchImpl_vTable;
end;

procedure IBatchCompletionStateImpl_disposeDispatcher(this: IBatchCompletionState); cdecl;
begin
  IBatchCompletionStateImpl(this).dispose();
end;

function IBatchCompletionStateImpl_getSizeDispatcher(this: IBatchCompletionState; status: IStatus): Cardinal; cdecl;
begin
  Result := IBatchCompletionStateImpl(this).getSize(status);
end;

function IBatchCompletionStateImpl_getStateDispatcher(this: IBatchCompletionState; status: IStatus; pos: Cardinal): Integer; cdecl;
begin
  Result := IBatchCompletionStateImpl(this).getState(status, pos);
end;

function IBatchCompletionStateImpl_findErrorDispatcher(this: IBatchCompletionState; status: IStatus; pos: Cardinal): Cardinal; cdecl;
begin
  Result := IBatchCompletionStateImpl(this).findError(status, pos);
end;

procedure IBatchCompletionStateImpl_getStatusDispatcher(this: IBatchCompletionState; status: IStatus; to_: IStatus; pos: Cardinal); cdecl;
begin
  IBatchCompletionStateImpl(this).getStatus(status, to_, pos);
end;

var
  IBatchCompletionStateImpl_vTable: BatchCompletionStateVTable;

constructor IBatchCompletionStateImpl.create;
begin
  vTable := IBatchCompletionStateImpl_vTable;
end;

procedure IReplicatorImpl_addRefDispatcher(this: IReplicator); cdecl;
begin
  IReplicatorImpl(this).addRef();
end;

function IReplicatorImpl_releaseDispatcher(this: IReplicator): Integer; cdecl;
begin
  Result := IReplicatorImpl(this).release();
end;

procedure IReplicatorImpl_processDispatcher(this: IReplicator; status: IStatus; length: Cardinal; data: PByte); cdecl;
begin
  IReplicatorImpl(this).process(status, length, data);
end;

procedure IReplicatorImpl_closeDispatcher(this: IReplicator; status: IStatus); cdecl;
begin
  IReplicatorImpl(this).close(status);
end;

var
  IReplicatorImpl_vTable: ReplicatorVTable;

constructor IReplicatorImpl.create;
begin
  vTable := IReplicatorImpl_vTable;
end;

procedure IRequestImpl_addRefDispatcher(this: IRequest); cdecl;
begin
  IRequestImpl(this).addRef();
end;

function IRequestImpl_releaseDispatcher(this: IRequest): Integer; cdecl;
begin
  Result := IRequestImpl(this).release();
end;

procedure IRequestImpl_receiveDispatcher(this: IRequest; status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
begin
  IRequestImpl(this).receive(status, level, msgType, length, message);
end;

procedure IRequestImpl_sendDispatcher(this: IRequest; status: IStatus; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
begin
  IRequestImpl(this).send(status, level, msgType, length, message);
end;

procedure IRequestImpl_getInfoDispatcher(this: IRequest; status: IStatus; level: Integer; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  IRequestImpl(this).getInfo(status, level, itemsLength, items, bufferLength, buffer);
end;

procedure IRequestImpl_startDispatcher(this: IRequest; status: IStatus; tra: ITransaction; level: Integer); cdecl;
begin
  IRequestImpl(this).start(status, tra, level);
end;

procedure IRequestImpl_startAndSendDispatcher(this: IRequest; status: IStatus; tra: ITransaction; level: Integer; msgType: Cardinal; length: Cardinal; message: Pointer); cdecl;
begin
  IRequestImpl(this).startAndSend(status, tra, level, msgType, length, message);
end;

procedure IRequestImpl_unwindDispatcher(this: IRequest; status: IStatus; level: Integer); cdecl;
begin
  IRequestImpl(this).unwind(status, level);
end;

procedure IRequestImpl_freeDispatcher(this: IRequest; status: IStatus); cdecl;
begin
  IRequestImpl(this).free(status);
end;

var
  IRequestImpl_vTable: RequestVTable;

constructor IRequestImpl.create;
begin
  vTable := IRequestImpl_vTable;
end;

procedure IEventsImpl_addRefDispatcher(this: IEvents); cdecl;
begin
  IEventsImpl(this).addRef();
end;

function IEventsImpl_releaseDispatcher(this: IEvents): Integer; cdecl;
begin
  Result := IEventsImpl(this).release();
end;

procedure IEventsImpl_cancelDispatcher(this: IEvents; status: IStatus); cdecl;
begin
  IEventsImpl(this).cancel(status);
end;

var
  IEventsImpl_vTable: EventsVTable;

constructor IEventsImpl.create;
begin
  vTable := IEventsImpl_vTable;
end;

procedure IAttachmentImpl_addRefDispatcher(this: IAttachment); cdecl;
begin
  IAttachmentImpl(this).addRef();
end;

function IAttachmentImpl_releaseDispatcher(this: IAttachment): Integer; cdecl;
begin
  Result := IAttachmentImpl(this).release();
end;

procedure IAttachmentImpl_getInfoDispatcher(this: IAttachment; status: IStatus; itemsLength: Cardinal; items: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  IAttachmentImpl(this).getInfo(status, itemsLength, items, bufferLength, buffer);
end;

function IAttachmentImpl_startTransactionDispatcher(this: IAttachment; status: IStatus; tpbLength: Cardinal; tpb: PByte): ITransaction; cdecl;
begin
  Result := IAttachmentImpl(this).startTransaction(status, tpbLength, tpb);
end;

function IAttachmentImpl_reconnectTransactionDispatcher(this: IAttachment; status: IStatus; length: Cardinal; id: PByte): ITransaction; cdecl;
begin
  Result := IAttachmentImpl(this).reconnectTransaction(status, length, id);
end;

function IAttachmentImpl_compileRequestDispatcher(this: IAttachment; status: IStatus; blrLength: Cardinal; blr: PByte): IRequest; cdecl;
begin
  Result := IAttachmentImpl(this).compileRequest(status, blrLength, blr);
end;

procedure IAttachmentImpl_transactRequestDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; blrLength: Cardinal; blr: PByte; inMsgLength: Cardinal; inMsg: PByte; outMsgLength: Cardinal; outMsg: PByte); cdecl;
begin
  IAttachmentImpl(this).transactRequest(status, transaction, blrLength, blr, inMsgLength, inMsg, outMsgLength, outMsg);
end;

function IAttachmentImpl_createBlobDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; cdecl;
begin
  Result := IAttachmentImpl(this).createBlob(status, transaction, id, bpbLength, bpb);
end;

function IAttachmentImpl_openBlobDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; bpbLength: Cardinal; bpb: PByte): IBlob; cdecl;
begin
  Result := IAttachmentImpl(this).openBlob(status, transaction, id, bpbLength, bpb);
end;

function IAttachmentImpl_getSliceDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte): Integer; cdecl;
begin
  Result := IAttachmentImpl(this).getSlice(status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
end;

procedure IAttachmentImpl_putSliceDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; id: PISC_QUAD; sdlLength: Cardinal; sdl: PByte; paramLength: Cardinal; param: PByte; sliceLength: Integer; slice: PByte); cdecl;
begin
  IAttachmentImpl(this).putSlice(status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
end;

procedure IAttachmentImpl_executeDynDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; length: Cardinal; dyn: PByte); cdecl;
begin
  IAttachmentImpl(this).executeDyn(status, transaction, length, dyn);
end;

function IAttachmentImpl_prepareDispatcher(this: IAttachment; status: IStatus; tra: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; flags: Cardinal): IStatement; cdecl;
begin
  Result := IAttachmentImpl(this).prepare(status, tra, stmtLength, sqlStmt, dialect, flags);
end;

function IAttachmentImpl_executeDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; outBuffer: Pointer): ITransaction; cdecl;
begin
  Result := IAttachmentImpl(this).execute(status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, outBuffer);
end;

function IAttachmentImpl_openCursorDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; inBuffer: Pointer; outMetadata: IMessageMetadata; cursorName: PAnsiChar; cursorFlags: Cardinal): IResultSet; cdecl;
begin
  Result := IAttachmentImpl(this).openCursor(status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, cursorName, cursorFlags);
end;

function IAttachmentImpl_queEventsDispatcher(this: IAttachment; status: IStatus; callback: IEventCallback; length: Cardinal; events: PByte): IEvents; cdecl;
begin
  Result := IAttachmentImpl(this).queEvents(status, callback, length, events);
end;

procedure IAttachmentImpl_cancelOperationDispatcher(this: IAttachment; status: IStatus; option: Integer); cdecl;
begin
  IAttachmentImpl(this).cancelOperation(status, option);
end;

procedure IAttachmentImpl_pingDispatcher(this: IAttachment; status: IStatus); cdecl;
begin
  IAttachmentImpl(this).ping(status);
end;

procedure IAttachmentImpl_detachDispatcher(this: IAttachment; status: IStatus); cdecl;
begin
  IAttachmentImpl(this).detach(status);
end;

procedure IAttachmentImpl_dropDatabaseDispatcher(this: IAttachment; status: IStatus); cdecl;
begin
  IAttachmentImpl(this).dropDatabase(status);
end;

function IAttachmentImpl_getIdleTimeoutDispatcher(this: IAttachment; status: IStatus): Cardinal; cdecl;
begin
  Result := IAttachmentImpl(this).getIdleTimeout(status);
end;

procedure IAttachmentImpl_setIdleTimeoutDispatcher(this: IAttachment; status: IStatus; timeOut: Cardinal); cdecl;
begin
  IAttachmentImpl(this).setIdleTimeout(status, timeOut);
end;

function IAttachmentImpl_getStatementTimeoutDispatcher(this: IAttachment; status: IStatus): Cardinal; cdecl;
begin
  Result := IAttachmentImpl(this).getStatementTimeout(status);
end;

procedure IAttachmentImpl_setStatementTimeoutDispatcher(this: IAttachment; status: IStatus; timeOut: Cardinal); cdecl;
begin
  IAttachmentImpl(this).setStatementTimeout(status, timeOut);
end;

function IAttachmentImpl_createBatchDispatcher(this: IAttachment; status: IStatus; transaction: ITransaction; stmtLength: Cardinal; sqlStmt: PAnsiChar; dialect: Cardinal; inMetadata: IMessageMetadata; parLength: Cardinal; par: PByte): IBatch; cdecl;
begin
  Result := IAttachmentImpl(this).createBatch(status, transaction, stmtLength, sqlStmt, dialect, inMetadata, parLength, par);
end;

function IAttachmentImpl_createReplicatorDispatcher(this: IAttachment; status: IStatus): IReplicator; cdecl;
begin
  Result := IAttachmentImpl(this).createReplicator(status);
end;

var
  IAttachmentImpl_vTable: AttachmentVTable;

constructor IAttachmentImpl.create;
begin
  vTable := IAttachmentImpl_vTable;
end;

procedure IServiceImpl_addRefDispatcher(this: IService); cdecl;
begin
  IServiceImpl(this).addRef();
end;

function IServiceImpl_releaseDispatcher(this: IService): Integer; cdecl;
begin
  Result := IServiceImpl(this).release();
end;

procedure IServiceImpl_detachDispatcher(this: IService; status: IStatus); cdecl;
begin
  IServiceImpl(this).detach(status);
end;

procedure IServiceImpl_queryDispatcher(this: IService; status: IStatus; sendLength: Cardinal; sendItems: PByte; receiveLength: Cardinal; receiveItems: PByte; bufferLength: Cardinal; buffer: PByte); cdecl;
begin
  IServiceImpl(this).query(status, sendLength, sendItems, receiveLength, receiveItems, bufferLength, buffer);
end;

procedure IServiceImpl_startDispatcher(this: IService; status: IStatus; spbLength: Cardinal; spb: PByte); cdecl;
begin
  IServiceImpl(this).start(status, spbLength, spb);
end;

var
  IServiceImpl_vTable: ServiceVTable;

constructor IServiceImpl.create;
begin
  vTable := IServiceImpl_vTable;
end;

procedure IProviderImpl_addRefDispatcher(this: IProvider); cdecl;
begin
  IProviderImpl(this).addRef();
end;

function IProviderImpl_releaseDispatcher(this: IProvider): Integer; cdecl;
begin
  Result := IProviderImpl(this).release();
end;

procedure IProviderImpl_setOwnerDispatcher(this: IProvider; r: IReferenceCounted); cdecl;
begin
  IProviderImpl(this).setOwner(r);
end;

function IProviderImpl_getOwnerDispatcher(this: IProvider): IReferenceCounted; cdecl;
begin
  Result := IProviderImpl(this).getOwner();
end;

function IProviderImpl_attachDatabaseDispatcher(this: IProvider; status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; cdecl;
begin
  Result := IProviderImpl(this).attachDatabase(status, fileName, dpbLength, dpb);
end;

function IProviderImpl_createDatabaseDispatcher(this: IProvider; status: IStatus; fileName: PAnsiChar; dpbLength: Cardinal; dpb: PByte): IAttachment; cdecl;
begin
  Result := IProviderImpl(this).createDatabase(status, fileName, dpbLength, dpb);
end;

function IProviderImpl_attachServiceManagerDispatcher(this: IProvider; status: IStatus; service: PAnsiChar; spbLength: Cardinal; spb: PByte): IService; cdecl;
begin
  Result := IProviderImpl(this).attachServiceManager(status, service, spbLength, spb);
end;

procedure IProviderImpl_shutdownDispatcher(this: IProvider; status: IStatus; timeout: Cardinal; reason: Integer); cdecl;
begin
  IProviderImpl(this).shutdown(status, timeout, reason);
end;

procedure IProviderImpl_setDbCryptCallbackDispatcher(this: IProvider; status: IStatus; cryptCallback: ICryptKeyCallback); cdecl;
begin
  IProviderImpl(this).setDbCryptCallback(status, cryptCallback);
end;

var
  IProviderImpl_vTable: ProviderVTable;

constructor IProviderImpl.create;
begin
  vTable := IProviderImpl_vTable;
end;

procedure IDtcStartImpl_disposeDispatcher(this: IDtcStart); cdecl;
begin
  IDtcStartImpl(this).dispose();
end;

procedure IDtcStartImpl_addAttachmentDispatcher(this: IDtcStart; status: IStatus; att: IAttachment); cdecl;
begin
  IDtcStartImpl(this).addAttachment(status, att);
end;

procedure IDtcStartImpl_addWithTpbDispatcher(this: IDtcStart; status: IStatus; att: IAttachment; length: Cardinal; tpb: PByte); cdecl;
begin
  IDtcStartImpl(this).addWithTpb(status, att, length, tpb);
end;

function IDtcStartImpl_startDispatcher(this: IDtcStart; status: IStatus): ITransaction; cdecl;
begin
  Result := IDtcStartImpl(this).start(status);
end;

var
  IDtcStartImpl_vTable: DtcStartVTable;

constructor IDtcStartImpl.create;
begin
  vTable := IDtcStartImpl_vTable;
end;

function IDtcImpl_joinDispatcher(this: IDtc; status: IStatus; one: ITransaction; two: ITransaction): ITransaction; cdecl;
begin
  Result := IDtcImpl(this).join(status, one, two);
end;

function IDtcImpl_startBuilderDispatcher(this: IDtc; status: IStatus): IDtcStart; cdecl;
begin
  Result := IDtcImpl(this).startBuilder(status);
end;

var
  IDtcImpl_vTable: DtcVTable;

constructor IDtcImpl.create;
begin
  vTable := IDtcImpl_vTable;
end;

procedure IAuthImpl_addRefDispatcher(this: IAuth); cdecl;
begin
  IAuthImpl(this).addRef();
end;

function IAuthImpl_releaseDispatcher(this: IAuth): Integer; cdecl;
begin
  Result := IAuthImpl(this).release();
end;

procedure IAuthImpl_setOwnerDispatcher(this: IAuth; r: IReferenceCounted); cdecl;
begin
  IAuthImpl(this).setOwner(r);
end;

function IAuthImpl_getOwnerDispatcher(this: IAuth): IReferenceCounted; cdecl;
begin
  Result := IAuthImpl(this).getOwner();
end;

var
  IAuthImpl_vTable: AuthVTable;

constructor IAuthImpl.create;
begin
  vTable := IAuthImpl_vTable;
end;

procedure IWriterImpl_resetDispatcher(this: IWriter); cdecl;
begin
  IWriterImpl(this).reset();
end;

procedure IWriterImpl_addDispatcher(this: IWriter; status: IStatus; name: PAnsiChar); cdecl;
begin
  IWriterImpl(this).add(status, name);
end;

procedure IWriterImpl_setTypeDispatcher(this: IWriter; status: IStatus; value: PAnsiChar); cdecl;
begin
  IWriterImpl(this).setType(status, value);
end;

procedure IWriterImpl_setDbDispatcher(this: IWriter; status: IStatus; value: PAnsiChar); cdecl;
begin
  IWriterImpl(this).setDb(status, value);
end;

var
  IWriterImpl_vTable: WriterVTable;

constructor IWriterImpl.create;
begin
  vTable := IWriterImpl_vTable;
end;

function IServerBlockImpl_getLoginDispatcher(this: IServerBlock): PAnsiChar; cdecl;
begin
  Result := IServerBlockImpl(this).getLogin();
end;

function IServerBlockImpl_getDataDispatcher(this: IServerBlock; length: Cardinal): PByte; cdecl;
begin
  Result := IServerBlockImpl(this).getData(length);
end;

procedure IServerBlockImpl_putDataDispatcher(this: IServerBlock; status: IStatus; length: Cardinal; data: Pointer); cdecl;
begin
  IServerBlockImpl(this).putData(status, length, data);
end;

function IServerBlockImpl_newKeyDispatcher(this: IServerBlock; status: IStatus): ICryptKey; cdecl;
begin
  Result := IServerBlockImpl(this).newKey(status);
end;

var
  IServerBlockImpl_vTable: ServerBlockVTable;

constructor IServerBlockImpl.create;
begin
  vTable := IServerBlockImpl_vTable;
end;

procedure IClientBlockImpl_addRefDispatcher(this: IClientBlock); cdecl;
begin
  IClientBlockImpl(this).addRef();
end;

function IClientBlockImpl_releaseDispatcher(this: IClientBlock): Integer; cdecl;
begin
  Result := IClientBlockImpl(this).release();
end;

function IClientBlockImpl_getLoginDispatcher(this: IClientBlock): PAnsiChar; cdecl;
begin
  Result := IClientBlockImpl(this).getLogin();
end;

function IClientBlockImpl_getPasswordDispatcher(this: IClientBlock): PAnsiChar; cdecl;
begin
  Result := IClientBlockImpl(this).getPassword();
end;

function IClientBlockImpl_getDataDispatcher(this: IClientBlock; length: Cardinal): PByte; cdecl;
begin
  Result := IClientBlockImpl(this).getData(length);
end;

procedure IClientBlockImpl_putDataDispatcher(this: IClientBlock; status: IStatus; length: Cardinal; data: Pointer); cdecl;
begin
  IClientBlockImpl(this).putData(status, length, data);
end;

function IClientBlockImpl_newKeyDispatcher(this: IClientBlock; status: IStatus): ICryptKey; cdecl;
begin
  Result := IClientBlockImpl(this).newKey(status);
end;

function IClientBlockImpl_getAuthBlockDispatcher(this: IClientBlock; status: IStatus): IAuthBlock; cdecl;
begin
  Result := IClientBlockImpl(this).getAuthBlock(status);
end;

var
  IClientBlockImpl_vTable: ClientBlockVTable;

constructor IClientBlockImpl.create;
begin
  vTable := IClientBlockImpl_vTable;
end;

procedure IServerImpl_addRefDispatcher(this: IServer); cdecl;
begin
  IServerImpl(this).addRef();
end;

function IServerImpl_releaseDispatcher(this: IServer): Integer; cdecl;
begin
  Result := IServerImpl(this).release();
end;

procedure IServerImpl_setOwnerDispatcher(this: IServer; r: IReferenceCounted); cdecl;
begin
  IServerImpl(this).setOwner(r);
end;

function IServerImpl_getOwnerDispatcher(this: IServer): IReferenceCounted; cdecl;
begin
  Result := IServerImpl(this).getOwner();
end;

function IServerImpl_authenticateDispatcher(this: IServer; status: IStatus; sBlock: IServerBlock; writerInterface: IWriter): Integer; cdecl;
begin
  Result := IServerImpl(this).authenticate(status, sBlock, writerInterface);
end;

procedure IServerImpl_setDbCryptCallbackDispatcher(this: IServer; status: IStatus; cryptCallback: ICryptKeyCallback); cdecl;
begin
  IServerImpl(this).setDbCryptCallback(status, cryptCallback);
end;

var
  IServerImpl_vTable: ServerVTable;

constructor IServerImpl.create;
begin
  vTable := IServerImpl_vTable;
end;

procedure IClientImpl_addRefDispatcher(this: IClient); cdecl;
begin
  IClientImpl(this).addRef();
end;

function IClientImpl_releaseDispatcher(this: IClient): Integer; cdecl;
begin
  Result := IClientImpl(this).release();
end;

procedure IClientImpl_setOwnerDispatcher(this: IClient; r: IReferenceCounted); cdecl;
begin
  IClientImpl(this).setOwner(r);
end;

function IClientImpl_getOwnerDispatcher(this: IClient): IReferenceCounted; cdecl;
begin
  Result := IClientImpl(this).getOwner();
end;

function IClientImpl_authenticateDispatcher(this: IClient; status: IStatus; cBlock: IClientBlock): Integer; cdecl;
begin
  Result := IClientImpl(this).authenticate(status, cBlock);
end;

var
  IClientImpl_vTable: ClientVTable;

constructor IClientImpl.create;
begin
  vTable := IClientImpl_vTable;
end;

function IUserFieldImpl_enteredDispatcher(this: IUserField): Integer; cdecl;
begin
  Result := IUserFieldImpl(this).entered();
end;

function IUserFieldImpl_specifiedDispatcher(this: IUserField): Integer; cdecl;
begin
  Result := IUserFieldImpl(this).specified();
end;

procedure IUserFieldImpl_setEnteredDispatcher(this: IUserField; status: IStatus; newValue: Integer); cdecl;
begin
  IUserFieldImpl(this).setEntered(status, newValue);
end;

var
  IUserFieldImpl_vTable: UserFieldVTable;

constructor IUserFieldImpl.create;
begin
  vTable := IUserFieldImpl_vTable;
end;

function ICharUserFieldImpl_enteredDispatcher(this: ICharUserField): Integer; cdecl;
begin
  Result := ICharUserFieldImpl(this).entered();
end;

function ICharUserFieldImpl_specifiedDispatcher(this: ICharUserField): Integer; cdecl;
begin
  Result := ICharUserFieldImpl(this).specified();
end;

procedure ICharUserFieldImpl_setEnteredDispatcher(this: ICharUserField; status: IStatus; newValue: Integer); cdecl;
begin
  ICharUserFieldImpl(this).setEntered(status, newValue);
end;

function ICharUserFieldImpl_getDispatcher(this: ICharUserField): PAnsiChar; cdecl;
begin
  Result := ICharUserFieldImpl(this).get();
end;

procedure ICharUserFieldImpl_set_Dispatcher(this: ICharUserField; status: IStatus; newValue: PAnsiChar); cdecl;
begin
  ICharUserFieldImpl(this).set_(status, newValue);
end;

var
  ICharUserFieldImpl_vTable: CharUserFieldVTable;

constructor ICharUserFieldImpl.create;
begin
  vTable := ICharUserFieldImpl_vTable;
end;

function IIntUserFieldImpl_enteredDispatcher(this: IIntUserField): Integer; cdecl;
begin
  Result := IIntUserFieldImpl(this).entered();
end;

function IIntUserFieldImpl_specifiedDispatcher(this: IIntUserField): Integer; cdecl;
begin
  Result := IIntUserFieldImpl(this).specified();
end;

procedure IIntUserFieldImpl_setEnteredDispatcher(this: IIntUserField; status: IStatus; newValue: Integer); cdecl;
begin
  IIntUserFieldImpl(this).setEntered(status, newValue);
end;

function IIntUserFieldImpl_getDispatcher(this: IIntUserField): Integer; cdecl;
begin
  Result := IIntUserFieldImpl(this).get();
end;

procedure IIntUserFieldImpl_set_Dispatcher(this: IIntUserField; status: IStatus; newValue: Integer); cdecl;
begin
  IIntUserFieldImpl(this).set_(status, newValue);
end;

var
  IIntUserFieldImpl_vTable: IntUserFieldVTable;

constructor IIntUserFieldImpl.create;
begin
  vTable := IIntUserFieldImpl_vTable;
end;

function IUserImpl_operationDispatcher(this: IUser): Cardinal; cdecl;
begin
  Result := IUserImpl(this).operation();
end;

function IUserImpl_userNameDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).userName();
end;

function IUserImpl_passwordDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).password();
end;

function IUserImpl_firstNameDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).firstName();
end;

function IUserImpl_lastNameDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).lastName();
end;

function IUserImpl_middleNameDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).middleName();
end;

function IUserImpl_commentDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).comment();
end;

function IUserImpl_attributesDispatcher(this: IUser): ICharUserField; cdecl;
begin
  Result := IUserImpl(this).attributes();
end;

function IUserImpl_activeDispatcher(this: IUser): IIntUserField; cdecl;
begin
  Result := IUserImpl(this).active();
end;

function IUserImpl_adminDispatcher(this: IUser): IIntUserField; cdecl;
begin
  Result := IUserImpl(this).admin();
end;

procedure IUserImpl_clearDispatcher(this: IUser; status: IStatus); cdecl;
begin
  IUserImpl(this).clear(status);
end;

var
  IUserImpl_vTable: UserVTable;

constructor IUserImpl.create;
begin
  vTable := IUserImpl_vTable;
end;

procedure IListUsersImpl_listDispatcher(this: IListUsers; status: IStatus; user: IUser); cdecl;
begin
  IListUsersImpl(this).list(status, user);
end;

var
  IListUsersImpl_vTable: ListUsersVTable;

constructor IListUsersImpl.create;
begin
  vTable := IListUsersImpl_vTable;
end;

function ILogonInfoImpl_nameDispatcher(this: ILogonInfo): PAnsiChar; cdecl;
begin
  Result := ILogonInfoImpl(this).name();
end;

function ILogonInfoImpl_roleDispatcher(this: ILogonInfo): PAnsiChar; cdecl;
begin
  Result := ILogonInfoImpl(this).role();
end;

function ILogonInfoImpl_networkProtocolDispatcher(this: ILogonInfo): PAnsiChar; cdecl;
begin
  Result := ILogonInfoImpl(this).networkProtocol();
end;

function ILogonInfoImpl_remoteAddressDispatcher(this: ILogonInfo): PAnsiChar; cdecl;
begin
  Result := ILogonInfoImpl(this).remoteAddress();
end;

function ILogonInfoImpl_authBlockDispatcher(this: ILogonInfo; length: PCardinal): PByte; cdecl;
begin
  Result := ILogonInfoImpl(this).authBlock(length);
end;

function ILogonInfoImpl_attachmentDispatcher(this: ILogonInfo; status: IStatus): IAttachment; cdecl;
begin
  Result := ILogonInfoImpl(this).attachment(status);
end;

function ILogonInfoImpl_transactionDispatcher(this: ILogonInfo; status: IStatus): ITransaction; cdecl;
begin
  Result := ILogonInfoImpl(this).transaction(status);
end;

var
  ILogonInfoImpl_vTable: LogonInfoVTable;

constructor ILogonInfoImpl.create;
begin
  vTable := ILogonInfoImpl_vTable;
end;

procedure IManagementImpl_addRefDispatcher(this: IManagement); cdecl;
begin
  IManagementImpl(this).addRef();
end;

function IManagementImpl_releaseDispatcher(this: IManagement): Integer; cdecl;
begin
  Result := IManagementImpl(this).release();
end;

procedure IManagementImpl_setOwnerDispatcher(this: IManagement; r: IReferenceCounted); cdecl;
begin
  IManagementImpl(this).setOwner(r);
end;

function IManagementImpl_getOwnerDispatcher(this: IManagement): IReferenceCounted; cdecl;
begin
  Result := IManagementImpl(this).getOwner();
end;

procedure IManagementImpl_startDispatcher(this: IManagement; status: IStatus; logonInfo: ILogonInfo); cdecl;
begin
  IManagementImpl(this).start(status, logonInfo);
end;

function IManagementImpl_executeDispatcher(this: IManagement; status: IStatus; user: IUser; callback: IListUsers): Integer; cdecl;
begin
  Result := IManagementImpl(this).execute(status, user, callback);
end;

procedure IManagementImpl_commitDispatcher(this: IManagement; status: IStatus); cdecl;
begin
  IManagementImpl(this).commit(status);
end;

procedure IManagementImpl_rollbackDispatcher(this: IManagement; status: IStatus); cdecl;
begin
  IManagementImpl(this).rollback(status);
end;

var
  IManagementImpl_vTable: ManagementVTable;

constructor IManagementImpl.create;
begin
  vTable := IManagementImpl_vTable;
end;

function IAuthBlockImpl_getTypeDispatcher(this: IAuthBlock): PAnsiChar; cdecl;
begin
  Result := IAuthBlockImpl(this).getType();
end;

function IAuthBlockImpl_getNameDispatcher(this: IAuthBlock): PAnsiChar; cdecl;
begin
  Result := IAuthBlockImpl(this).getName();
end;

function IAuthBlockImpl_getPluginDispatcher(this: IAuthBlock): PAnsiChar; cdecl;
begin
  Result := IAuthBlockImpl(this).getPlugin();
end;

function IAuthBlockImpl_getSecurityDbDispatcher(this: IAuthBlock): PAnsiChar; cdecl;
begin
  Result := IAuthBlockImpl(this).getSecurityDb();
end;

function IAuthBlockImpl_getOriginalPluginDispatcher(this: IAuthBlock): PAnsiChar; cdecl;
begin
  Result := IAuthBlockImpl(this).getOriginalPlugin();
end;

function IAuthBlockImpl_nextDispatcher(this: IAuthBlock; status: IStatus): Boolean; cdecl;
begin
  Result := IAuthBlockImpl(this).next(status);
end;

function IAuthBlockImpl_firstDispatcher(this: IAuthBlock; status: IStatus): Boolean; cdecl;
begin
  Result := IAuthBlockImpl(this).first(status);
end;

var
  IAuthBlockImpl_vTable: AuthBlockVTable;

constructor IAuthBlockImpl.create;
begin
  vTable := IAuthBlockImpl_vTable;
end;

procedure IWireCryptPluginImpl_addRefDispatcher(this: IWireCryptPlugin); cdecl;
begin
  IWireCryptPluginImpl(this).addRef();
end;

function IWireCryptPluginImpl_releaseDispatcher(this: IWireCryptPlugin): Integer; cdecl;
begin
  Result := IWireCryptPluginImpl(this).release();
end;

procedure IWireCryptPluginImpl_setOwnerDispatcher(this: IWireCryptPlugin; r: IReferenceCounted); cdecl;
begin
  IWireCryptPluginImpl(this).setOwner(r);
end;

function IWireCryptPluginImpl_getOwnerDispatcher(this: IWireCryptPlugin): IReferenceCounted; cdecl;
begin
  Result := IWireCryptPluginImpl(this).getOwner();
end;

function IWireCryptPluginImpl_getKnownTypesDispatcher(this: IWireCryptPlugin; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IWireCryptPluginImpl(this).getKnownTypes(status);
end;

procedure IWireCryptPluginImpl_setKeyDispatcher(this: IWireCryptPlugin; status: IStatus; key: ICryptKey); cdecl;
begin
  IWireCryptPluginImpl(this).setKey(status, key);
end;

procedure IWireCryptPluginImpl_encryptDispatcher(this: IWireCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
begin
  IWireCryptPluginImpl(this).encrypt(status, length, from, to_);
end;

procedure IWireCryptPluginImpl_decryptDispatcher(this: IWireCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
begin
  IWireCryptPluginImpl(this).decrypt(status, length, from, to_);
end;

function IWireCryptPluginImpl_getSpecificDataDispatcher(this: IWireCryptPlugin; status: IStatus; keyType: PAnsiChar; length: Cardinal): PByte; cdecl;
begin
  Result := IWireCryptPluginImpl(this).getSpecificData(status, keyType, length);
end;

procedure IWireCryptPluginImpl_setSpecificDataDispatcher(this: IWireCryptPlugin; status: IStatus; keyType: PAnsiChar; length: Cardinal; data: PByte); cdecl;
begin
  IWireCryptPluginImpl(this).setSpecificData(status, keyType, length, data);
end;

var
  IWireCryptPluginImpl_vTable: WireCryptPluginVTable;

constructor IWireCryptPluginImpl.create;
begin
  vTable := IWireCryptPluginImpl_vTable;
end;

function ICryptKeyCallbackImpl_callbackDispatcher(this: ICryptKeyCallback; dataLength: Cardinal; data: Pointer; bufferLength: Cardinal; buffer: Pointer): Cardinal; cdecl;
begin
  Result := ICryptKeyCallbackImpl(this).callback(dataLength, data, bufferLength, buffer);
end;

var
  ICryptKeyCallbackImpl_vTable: CryptKeyCallbackVTable;

constructor ICryptKeyCallbackImpl.create;
begin
  vTable := ICryptKeyCallbackImpl_vTable;
end;

procedure IKeyHolderPluginImpl_addRefDispatcher(this: IKeyHolderPlugin); cdecl;
begin
  IKeyHolderPluginImpl(this).addRef();
end;

function IKeyHolderPluginImpl_releaseDispatcher(this: IKeyHolderPlugin): Integer; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).release();
end;

procedure IKeyHolderPluginImpl_setOwnerDispatcher(this: IKeyHolderPlugin; r: IReferenceCounted); cdecl;
begin
  IKeyHolderPluginImpl(this).setOwner(r);
end;

function IKeyHolderPluginImpl_getOwnerDispatcher(this: IKeyHolderPlugin): IReferenceCounted; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).getOwner();
end;

function IKeyHolderPluginImpl_keyCallbackDispatcher(this: IKeyHolderPlugin; status: IStatus; callback: ICryptKeyCallback): Integer; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).keyCallback(status, callback);
end;

function IKeyHolderPluginImpl_keyHandleDispatcher(this: IKeyHolderPlugin; status: IStatus; keyName: PAnsiChar): ICryptKeyCallback; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).keyHandle(status, keyName);
end;

function IKeyHolderPluginImpl_useOnlyOwnKeysDispatcher(this: IKeyHolderPlugin; status: IStatus): Boolean; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).useOnlyOwnKeys(status);
end;

function IKeyHolderPluginImpl_chainHandleDispatcher(this: IKeyHolderPlugin; status: IStatus): ICryptKeyCallback; cdecl;
begin
  Result := IKeyHolderPluginImpl(this).chainHandle(status);
end;

var
  IKeyHolderPluginImpl_vTable: KeyHolderPluginVTable;

constructor IKeyHolderPluginImpl.create;
begin
  vTable := IKeyHolderPluginImpl_vTable;
end;

procedure IDbCryptInfoImpl_addRefDispatcher(this: IDbCryptInfo); cdecl;
begin
  IDbCryptInfoImpl(this).addRef();
end;

function IDbCryptInfoImpl_releaseDispatcher(this: IDbCryptInfo): Integer; cdecl;
begin
  Result := IDbCryptInfoImpl(this).release();
end;

function IDbCryptInfoImpl_getDatabaseFullPathDispatcher(this: IDbCryptInfo; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IDbCryptInfoImpl(this).getDatabaseFullPath(status);
end;

var
  IDbCryptInfoImpl_vTable: DbCryptInfoVTable;

constructor IDbCryptInfoImpl.create;
begin
  vTable := IDbCryptInfoImpl_vTable;
end;

procedure IDbCryptPluginImpl_addRefDispatcher(this: IDbCryptPlugin); cdecl;
begin
  IDbCryptPluginImpl(this).addRef();
end;

function IDbCryptPluginImpl_releaseDispatcher(this: IDbCryptPlugin): Integer; cdecl;
begin
  Result := IDbCryptPluginImpl(this).release();
end;

procedure IDbCryptPluginImpl_setOwnerDispatcher(this: IDbCryptPlugin; r: IReferenceCounted); cdecl;
begin
  IDbCryptPluginImpl(this).setOwner(r);
end;

function IDbCryptPluginImpl_getOwnerDispatcher(this: IDbCryptPlugin): IReferenceCounted; cdecl;
begin
  Result := IDbCryptPluginImpl(this).getOwner();
end;

procedure IDbCryptPluginImpl_setKeyDispatcher(this: IDbCryptPlugin; status: IStatus; length: Cardinal; sources: PIKeyHolderPlugin; keyName: PAnsiChar); cdecl;
begin
  IDbCryptPluginImpl(this).setKey(status, length, sources, keyName);
end;

procedure IDbCryptPluginImpl_encryptDispatcher(this: IDbCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
begin
  IDbCryptPluginImpl(this).encrypt(status, length, from, to_);
end;

procedure IDbCryptPluginImpl_decryptDispatcher(this: IDbCryptPlugin; status: IStatus; length: Cardinal; from: Pointer; to_: Pointer); cdecl;
begin
  IDbCryptPluginImpl(this).decrypt(status, length, from, to_);
end;

procedure IDbCryptPluginImpl_setInfoDispatcher(this: IDbCryptPlugin; status: IStatus; info: IDbCryptInfo); cdecl;
begin
  IDbCryptPluginImpl(this).setInfo(status, info);
end;

var
  IDbCryptPluginImpl_vTable: DbCryptPluginVTable;

constructor IDbCryptPluginImpl.create;
begin
  vTable := IDbCryptPluginImpl_vTable;
end;

function IExternalContextImpl_getMasterDispatcher(this: IExternalContext): IMaster; cdecl;
begin
  Result := IExternalContextImpl(this).getMaster();
end;

function IExternalContextImpl_getEngineDispatcher(this: IExternalContext; status: IStatus): IExternalEngine; cdecl;
begin
  Result := IExternalContextImpl(this).getEngine(status);
end;

function IExternalContextImpl_getAttachmentDispatcher(this: IExternalContext; status: IStatus): IAttachment; cdecl;
begin
  Result := IExternalContextImpl(this).getAttachment(status);
end;

function IExternalContextImpl_getTransactionDispatcher(this: IExternalContext; status: IStatus): ITransaction; cdecl;
begin
  Result := IExternalContextImpl(this).getTransaction(status);
end;

function IExternalContextImpl_getUserNameDispatcher(this: IExternalContext): PAnsiChar; cdecl;
begin
  Result := IExternalContextImpl(this).getUserName();
end;

function IExternalContextImpl_getDatabaseNameDispatcher(this: IExternalContext): PAnsiChar; cdecl;
begin
  Result := IExternalContextImpl(this).getDatabaseName();
end;

function IExternalContextImpl_getClientCharSetDispatcher(this: IExternalContext): PAnsiChar; cdecl;
begin
  Result := IExternalContextImpl(this).getClientCharSet();
end;

function IExternalContextImpl_obtainInfoCodeDispatcher(this: IExternalContext): Integer; cdecl;
begin
  Result := IExternalContextImpl(this).obtainInfoCode();
end;

function IExternalContextImpl_getInfoDispatcher(this: IExternalContext; code: Integer): Pointer; cdecl;
begin
  Result := IExternalContextImpl(this).getInfo(code);
end;

function IExternalContextImpl_setInfoDispatcher(this: IExternalContext; code: Integer; value: Pointer): Pointer; cdecl;
begin
  Result := IExternalContextImpl(this).setInfo(code, value);
end;

var
  IExternalContextImpl_vTable: ExternalContextVTable;

constructor IExternalContextImpl.create;
begin
  vTable := IExternalContextImpl_vTable;
end;

procedure IExternalResultSetImpl_disposeDispatcher(this: IExternalResultSet); cdecl;
begin
  IExternalResultSetImpl(this).dispose();
end;

function IExternalResultSetImpl_fetchDispatcher(this: IExternalResultSet; status: IStatus): Boolean; cdecl;
begin
  Result := IExternalResultSetImpl(this).fetch(status);
end;

var
  IExternalResultSetImpl_vTable: ExternalResultSetVTable;

constructor IExternalResultSetImpl.create;
begin
  vTable := IExternalResultSetImpl_vTable;
end;

procedure IExternalFunctionImpl_disposeDispatcher(this: IExternalFunction); cdecl;
begin
  IExternalFunctionImpl(this).dispose();
end;

procedure IExternalFunctionImpl_getCharSetDispatcher(this: IExternalFunction; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
begin
  IExternalFunctionImpl(this).getCharSet(status, context, name, nameSize);
end;

procedure IExternalFunctionImpl_executeDispatcher(this: IExternalFunction; status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer); cdecl;
begin
  IExternalFunctionImpl(this).execute(status, context, inMsg, outMsg);
end;

var
  IExternalFunctionImpl_vTable: ExternalFunctionVTable;

constructor IExternalFunctionImpl.create;
begin
  vTable := IExternalFunctionImpl_vTable;
end;

procedure IExternalProcedureImpl_disposeDispatcher(this: IExternalProcedure); cdecl;
begin
  IExternalProcedureImpl(this).dispose();
end;

procedure IExternalProcedureImpl_getCharSetDispatcher(this: IExternalProcedure; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
begin
  IExternalProcedureImpl(this).getCharSet(status, context, name, nameSize);
end;

function IExternalProcedureImpl_openDispatcher(this: IExternalProcedure; status: IStatus; context: IExternalContext; inMsg: Pointer; outMsg: Pointer): IExternalResultSet; cdecl;
begin
  Result := IExternalProcedureImpl(this).open(status, context, inMsg, outMsg);
end;

var
  IExternalProcedureImpl_vTable: ExternalProcedureVTable;

constructor IExternalProcedureImpl.create;
begin
  vTable := IExternalProcedureImpl_vTable;
end;

procedure IExternalTriggerImpl_disposeDispatcher(this: IExternalTrigger); cdecl;
begin
  IExternalTriggerImpl(this).dispose();
end;

procedure IExternalTriggerImpl_getCharSetDispatcher(this: IExternalTrigger; status: IStatus; context: IExternalContext; name: PAnsiChar; nameSize: Cardinal); cdecl;
begin
  IExternalTriggerImpl(this).getCharSet(status, context, name, nameSize);
end;

procedure IExternalTriggerImpl_executeDispatcher(this: IExternalTrigger; status: IStatus; context: IExternalContext; action: Cardinal; oldMsg: Pointer; newMsg: Pointer); cdecl;
begin
  IExternalTriggerImpl(this).execute(status, context, action, oldMsg, newMsg);
end;

var
  IExternalTriggerImpl_vTable: ExternalTriggerVTable;

constructor IExternalTriggerImpl.create;
begin
  vTable := IExternalTriggerImpl_vTable;
end;

function IRoutineMetadataImpl_getPackageDispatcher(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getPackage(status);
end;

function IRoutineMetadataImpl_getNameDispatcher(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getName(status);
end;

function IRoutineMetadataImpl_getEntryPointDispatcher(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getEntryPoint(status);
end;

function IRoutineMetadataImpl_getBodyDispatcher(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getBody(status);
end;

function IRoutineMetadataImpl_getInputMetadataDispatcher(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getInputMetadata(status);
end;

function IRoutineMetadataImpl_getOutputMetadataDispatcher(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getOutputMetadata(status);
end;

function IRoutineMetadataImpl_getTriggerMetadataDispatcher(this: IRoutineMetadata; status: IStatus): IMessageMetadata; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getTriggerMetadata(status);
end;

function IRoutineMetadataImpl_getTriggerTableDispatcher(this: IRoutineMetadata; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getTriggerTable(status);
end;

function IRoutineMetadataImpl_getTriggerTypeDispatcher(this: IRoutineMetadata; status: IStatus): Cardinal; cdecl;
begin
  Result := IRoutineMetadataImpl(this).getTriggerType(status);
end;

var
  IRoutineMetadataImpl_vTable: RoutineMetadataVTable;

constructor IRoutineMetadataImpl.create;
begin
  vTable := IRoutineMetadataImpl_vTable;
end;

procedure IExternalEngineImpl_addRefDispatcher(this: IExternalEngine); cdecl;
begin
  IExternalEngineImpl(this).addRef();
end;

function IExternalEngineImpl_releaseDispatcher(this: IExternalEngine): Integer; cdecl;
begin
  Result := IExternalEngineImpl(this).release();
end;

procedure IExternalEngineImpl_setOwnerDispatcher(this: IExternalEngine; r: IReferenceCounted); cdecl;
begin
  IExternalEngineImpl(this).setOwner(r);
end;

function IExternalEngineImpl_getOwnerDispatcher(this: IExternalEngine): IReferenceCounted; cdecl;
begin
  Result := IExternalEngineImpl(this).getOwner();
end;

procedure IExternalEngineImpl_openDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext; charSet: PAnsiChar; charSetSize: Cardinal); cdecl;
begin
  IExternalEngineImpl(this).open(status, context, charSet, charSetSize);
end;

procedure IExternalEngineImpl_openAttachmentDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext); cdecl;
begin
  IExternalEngineImpl(this).openAttachment(status, context);
end;

procedure IExternalEngineImpl_closeAttachmentDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext); cdecl;
begin
  IExternalEngineImpl(this).closeAttachment(status, context);
end;

function IExternalEngineImpl_makeFunctionDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalFunction; cdecl;
begin
  Result := IExternalEngineImpl(this).makeFunction(status, context, metadata, inBuilder, outBuilder);
end;

function IExternalEngineImpl_makeProcedureDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder): IExternalProcedure; cdecl;
begin
  Result := IExternalEngineImpl(this).makeProcedure(status, context, metadata, inBuilder, outBuilder);
end;

function IExternalEngineImpl_makeTriggerDispatcher(this: IExternalEngine; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder): IExternalTrigger; cdecl;
begin
  Result := IExternalEngineImpl(this).makeTrigger(status, context, metadata, fieldsBuilder);
end;

var
  IExternalEngineImpl_vTable: ExternalEngineVTable;

constructor IExternalEngineImpl.create;
begin
  vTable := IExternalEngineImpl_vTable;
end;

procedure ITimerImpl_addRefDispatcher(this: ITimer); cdecl;
begin
  ITimerImpl(this).addRef();
end;

function ITimerImpl_releaseDispatcher(this: ITimer): Integer; cdecl;
begin
  Result := ITimerImpl(this).release();
end;

procedure ITimerImpl_handlerDispatcher(this: ITimer); cdecl;
begin
  ITimerImpl(this).handler();
end;

var
  ITimerImpl_vTable: TimerVTable;

constructor ITimerImpl.create;
begin
  vTable := ITimerImpl_vTable;
end;

procedure ITimerControlImpl_startDispatcher(this: ITimerControl; status: IStatus; timer: ITimer; microSeconds: UInt64); cdecl;
begin
  ITimerControlImpl(this).start(status, timer, microSeconds);
end;

procedure ITimerControlImpl_stopDispatcher(this: ITimerControl; status: IStatus; timer: ITimer); cdecl;
begin
  ITimerControlImpl(this).stop(status, timer);
end;

var
  ITimerControlImpl_vTable: TimerControlVTable;

constructor ITimerControlImpl.create;
begin
  vTable := ITimerControlImpl_vTable;
end;

procedure IVersionCallbackImpl_callbackDispatcher(this: IVersionCallback; status: IStatus; text: PAnsiChar); cdecl;
begin
  IVersionCallbackImpl(this).callback(status, text);
end;

var
  IVersionCallbackImpl_vTable: VersionCallbackVTable;

constructor IVersionCallbackImpl.create;
begin
  vTable := IVersionCallbackImpl_vTable;
end;

procedure IUtilImpl_getFbVersionDispatcher(this: IUtil; status: IStatus; att: IAttachment; callback: IVersionCallback); cdecl;
begin
  IUtilImpl(this).getFbVersion(status, att, callback);
end;

procedure IUtilImpl_loadBlobDispatcher(this: IUtil; status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); cdecl;
begin
  IUtilImpl(this).loadBlob(status, blobId, att, tra, file_, txt);
end;

procedure IUtilImpl_dumpBlobDispatcher(this: IUtil; status: IStatus; blobId: PISC_QUAD; att: IAttachment; tra: ITransaction; file_: PAnsiChar; txt: Boolean); cdecl;
begin
  IUtilImpl(this).dumpBlob(status, blobId, att, tra, file_, txt);
end;

procedure IUtilImpl_getPerfCountersDispatcher(this: IUtil; status: IStatus; att: IAttachment; countersSet: PAnsiChar; counters: PInt64); cdecl;
begin
  IUtilImpl(this).getPerfCounters(status, att, countersSet, counters);
end;

function IUtilImpl_executeCreateDatabaseDispatcher(this: IUtil; status: IStatus; stmtLength: Cardinal; creatDBstatement: PAnsiChar; dialect: Cardinal; stmtIsCreateDb: BooleanPtr): IAttachment; cdecl;
begin
  Result := IUtilImpl(this).executeCreateDatabase(status, stmtLength, creatDBstatement, dialect, stmtIsCreateDb);
end;

procedure IUtilImpl_decodeDateDispatcher(this: IUtil; date: TISC_DATE; year: Cardinal; month: Cardinal; day: Cardinal); cdecl;
begin
  IUtilImpl(this).decodeDate(date, year, month, day);
end;

procedure IUtilImpl_decodeTimeDispatcher(this: IUtil; time: TISC_TIME; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal); cdecl;
begin
  IUtilImpl(this).decodeTime(time, hours, minutes, seconds, fractions);
end;

function IUtilImpl_encodeDateDispatcher(this: IUtil; year: Cardinal; month: Cardinal; day: Cardinal): TISC_DATE; cdecl;
begin
  Result := IUtilImpl(this).encodeDate(year, month, day);
end;

function IUtilImpl_encodeTimeDispatcher(this: IUtil; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal): TISC_TIME; cdecl;
begin
  Result := IUtilImpl(this).encodeTime(hours, minutes, seconds, fractions);
end;

function IUtilImpl_formatStatusDispatcher(this: IUtil; buffer: PAnsiChar; bufferSize: Cardinal; status: IStatus): Cardinal; cdecl;
begin
  Result := IUtilImpl(this).formatStatus(buffer, bufferSize, status);
end;

function IUtilImpl_getClientVersionDispatcher(this: IUtil): Cardinal; cdecl;
begin
  Result := IUtilImpl(this).getClientVersion();
end;

function IUtilImpl_getXpbBuilderDispatcher(this: IUtil; status: IStatus; kind: Cardinal; buf: PByte; len: Cardinal): IXpbBuilder; cdecl;
begin
  Result := IUtilImpl(this).getXpbBuilder(status, kind, buf, len);
end;

function IUtilImpl_setOffsetsDispatcher(this: IUtil; status: IStatus; metadata: IMessageMetadata; callback: IOffsetsCallback): Cardinal; cdecl;
begin
  Result := IUtilImpl(this).setOffsets(status, metadata, callback);
end;

function IUtilImpl_getDecFloat16Dispatcher(this: IUtil; status: IStatus): IDecFloat16; cdecl;
begin
  Result := IUtilImpl(this).getDecFloat16(status);
end;

function IUtilImpl_getDecFloat34Dispatcher(this: IUtil; status: IStatus): IDecFloat34; cdecl;
begin
  Result := IUtilImpl(this).getDecFloat34(status);
end;

procedure IUtilImpl_decodeTimeTzDispatcher(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
begin
  IUtilImpl(this).decodeTimeTz(status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtilImpl_decodeTimeStampTzDispatcher(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
begin
  IUtilImpl(this).decodeTimeStampTz(status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtilImpl_encodeTimeTzDispatcher(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); cdecl;
begin
  IUtilImpl(this).encodeTimeTz(status, timeTz, hours, minutes, seconds, fractions, timeZone);
end;

procedure IUtilImpl_encodeTimeStampTzDispatcher(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ; year: Cardinal; month: Cardinal; day: Cardinal; hours: Cardinal; minutes: Cardinal; seconds: Cardinal; fractions: Cardinal; timeZone: PAnsiChar); cdecl;
begin
  IUtilImpl(this).encodeTimeStampTz(status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZone);
end;

function IUtilImpl_getInt128Dispatcher(this: IUtil; status: IStatus): IInt128; cdecl;
begin
  Result := IUtilImpl(this).getInt128(status);
end;

procedure IUtilImpl_decodeTimeTzExDispatcher(this: IUtil; status: IStatus; timeTz: PISC_TIME_TZ_EX; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
begin
  IUtilImpl(this).decodeTimeTzEx(status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

procedure IUtilImpl_decodeTimeStampTzExDispatcher(this: IUtil; status: IStatus; timeStampTz: PISC_TIMESTAMP_TZ_EX; year: PCardinal; month: PCardinal; day: PCardinal; hours: PCardinal; minutes: PCardinal; seconds: PCardinal; fractions: PCardinal; timeZoneBufferLength: Cardinal; timeZoneBuffer: PAnsiChar); cdecl;
begin
  IUtilImpl(this).decodeTimeStampTzEx(status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
end;

var
  IUtilImpl_vTable: UtilVTable;

constructor IUtilImpl.create;
begin
  vTable := IUtilImpl_vTable;
end;

procedure IOffsetsCallbackImpl_setOffsetDispatcher(this: IOffsetsCallback; status: IStatus; index: Cardinal; offset: Cardinal; nullOffset: Cardinal); cdecl;
begin
  IOffsetsCallbackImpl(this).setOffset(status, index, offset, nullOffset);
end;

var
  IOffsetsCallbackImpl_vTable: OffsetsCallbackVTable;

constructor IOffsetsCallbackImpl.create;
begin
  vTable := IOffsetsCallbackImpl_vTable;
end;

procedure IXpbBuilderImpl_disposeDispatcher(this: IXpbBuilder); cdecl;
begin
  IXpbBuilderImpl(this).dispose();
end;

procedure IXpbBuilderImpl_clearDispatcher(this: IXpbBuilder; status: IStatus); cdecl;
begin
  IXpbBuilderImpl(this).clear(status);
end;

procedure IXpbBuilderImpl_removeCurrentDispatcher(this: IXpbBuilder; status: IStatus); cdecl;
begin
  IXpbBuilderImpl(this).removeCurrent(status);
end;

procedure IXpbBuilderImpl_insertIntDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte; value: Integer); cdecl;
begin
  IXpbBuilderImpl(this).insertInt(status, tag, value);
end;

procedure IXpbBuilderImpl_insertBigIntDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte; value: Int64); cdecl;
begin
  IXpbBuilderImpl(this).insertBigInt(status, tag, value);
end;

procedure IXpbBuilderImpl_insertBytesDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte; bytes: Pointer; length: Cardinal); cdecl;
begin
  IXpbBuilderImpl(this).insertBytes(status, tag, bytes, length);
end;

procedure IXpbBuilderImpl_insertStringDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte; str: PAnsiChar); cdecl;
begin
  IXpbBuilderImpl(this).insertString(status, tag, str);
end;

procedure IXpbBuilderImpl_insertTagDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte); cdecl;
begin
  IXpbBuilderImpl(this).insertTag(status, tag);
end;

function IXpbBuilderImpl_isEofDispatcher(this: IXpbBuilder; status: IStatus): Boolean; cdecl;
begin
  Result := IXpbBuilderImpl(this).isEof(status);
end;

procedure IXpbBuilderImpl_moveNextDispatcher(this: IXpbBuilder; status: IStatus); cdecl;
begin
  IXpbBuilderImpl(this).moveNext(status);
end;

procedure IXpbBuilderImpl_rewindDispatcher(this: IXpbBuilder; status: IStatus); cdecl;
begin
  IXpbBuilderImpl(this).rewind(status);
end;

function IXpbBuilderImpl_findFirstDispatcher(this: IXpbBuilder; status: IStatus; tag: Byte): Boolean; cdecl;
begin
  Result := IXpbBuilderImpl(this).findFirst(status, tag);
end;

function IXpbBuilderImpl_findNextDispatcher(this: IXpbBuilder; status: IStatus): Boolean; cdecl;
begin
  Result := IXpbBuilderImpl(this).findNext(status);
end;

function IXpbBuilderImpl_getTagDispatcher(this: IXpbBuilder; status: IStatus): Byte; cdecl;
begin
  Result := IXpbBuilderImpl(this).getTag(status);
end;

function IXpbBuilderImpl_getLengthDispatcher(this: IXpbBuilder; status: IStatus): Cardinal; cdecl;
begin
  Result := IXpbBuilderImpl(this).getLength(status);
end;

function IXpbBuilderImpl_getIntDispatcher(this: IXpbBuilder; status: IStatus): Integer; cdecl;
begin
  Result := IXpbBuilderImpl(this).getInt(status);
end;

function IXpbBuilderImpl_getBigIntDispatcher(this: IXpbBuilder; status: IStatus): Int64; cdecl;
begin
  Result := IXpbBuilderImpl(this).getBigInt(status);
end;

function IXpbBuilderImpl_getStringDispatcher(this: IXpbBuilder; status: IStatus): PAnsiChar; cdecl;
begin
  Result := IXpbBuilderImpl(this).getString(status);
end;

function IXpbBuilderImpl_getBytesDispatcher(this: IXpbBuilder; status: IStatus): PByte; cdecl;
begin
  Result := IXpbBuilderImpl(this).getBytes(status);
end;

function IXpbBuilderImpl_getBufferLengthDispatcher(this: IXpbBuilder; status: IStatus): Cardinal; cdecl;
begin
  Result := IXpbBuilderImpl(this).getBufferLength(status);
end;

function IXpbBuilderImpl_getBufferDispatcher(this: IXpbBuilder; status: IStatus): PByte; cdecl;
begin
  Result := IXpbBuilderImpl(this).getBuffer(status);
end;

var
  IXpbBuilderImpl_vTable: XpbBuilderVTable;

constructor IXpbBuilderImpl.create;
begin
  vTable := IXpbBuilderImpl_vTable;
end;

function ITraceConnectionImpl_getKindDispatcher(this: ITraceConnection): Cardinal; cdecl;
begin
  Result := ITraceConnectionImpl(this).getKind();
end;

function ITraceConnectionImpl_getProcessIDDispatcher(this: ITraceConnection): Integer; cdecl;
begin
  Result := ITraceConnectionImpl(this).getProcessID();
end;

function ITraceConnectionImpl_getUserNameDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getUserName();
end;

function ITraceConnectionImpl_getRoleNameDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getRoleName();
end;

function ITraceConnectionImpl_getCharSetDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getCharSet();
end;

function ITraceConnectionImpl_getRemoteProtocolDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getRemoteProtocol();
end;

function ITraceConnectionImpl_getRemoteAddressDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getRemoteAddress();
end;

function ITraceConnectionImpl_getRemoteProcessIDDispatcher(this: ITraceConnection): Integer; cdecl;
begin
  Result := ITraceConnectionImpl(this).getRemoteProcessID();
end;

function ITraceConnectionImpl_getRemoteProcessNameDispatcher(this: ITraceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceConnectionImpl(this).getRemoteProcessName();
end;

var
  ITraceConnectionImpl_vTable: TraceConnectionVTable;

constructor ITraceConnectionImpl.create;
begin
  vTable := ITraceConnectionImpl_vTable;
end;

function ITraceDatabaseConnectionImpl_getKindDispatcher(this: ITraceDatabaseConnection): Cardinal; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getKind();
end;

function ITraceDatabaseConnectionImpl_getProcessIDDispatcher(this: ITraceDatabaseConnection): Integer; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getProcessID();
end;

function ITraceDatabaseConnectionImpl_getUserNameDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getUserName();
end;

function ITraceDatabaseConnectionImpl_getRoleNameDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getRoleName();
end;

function ITraceDatabaseConnectionImpl_getCharSetDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getCharSet();
end;

function ITraceDatabaseConnectionImpl_getRemoteProtocolDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getRemoteProtocol();
end;

function ITraceDatabaseConnectionImpl_getRemoteAddressDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getRemoteAddress();
end;

function ITraceDatabaseConnectionImpl_getRemoteProcessIDDispatcher(this: ITraceDatabaseConnection): Integer; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getRemoteProcessID();
end;

function ITraceDatabaseConnectionImpl_getRemoteProcessNameDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getRemoteProcessName();
end;

function ITraceDatabaseConnectionImpl_getConnectionIDDispatcher(this: ITraceDatabaseConnection): Int64; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getConnectionID();
end;

function ITraceDatabaseConnectionImpl_getDatabaseNameDispatcher(this: ITraceDatabaseConnection): PAnsiChar; cdecl;
begin
  Result := ITraceDatabaseConnectionImpl(this).getDatabaseName();
end;

var
  ITraceDatabaseConnectionImpl_vTable: TraceDatabaseConnectionVTable;

constructor ITraceDatabaseConnectionImpl.create;
begin
  vTable := ITraceDatabaseConnectionImpl_vTable;
end;

function ITraceTransactionImpl_getTransactionIDDispatcher(this: ITraceTransaction): Int64; cdecl;
begin
  Result := ITraceTransactionImpl(this).getTransactionID();
end;

function ITraceTransactionImpl_getReadOnlyDispatcher(this: ITraceTransaction): Boolean; cdecl;
begin
  Result := ITraceTransactionImpl(this).getReadOnly();
end;

function ITraceTransactionImpl_getWaitDispatcher(this: ITraceTransaction): Integer; cdecl;
begin
  Result := ITraceTransactionImpl(this).getWait();
end;

function ITraceTransactionImpl_getIsolationDispatcher(this: ITraceTransaction): Cardinal; cdecl;
begin
  Result := ITraceTransactionImpl(this).getIsolation();
end;

function ITraceTransactionImpl_getPerfDispatcher(this: ITraceTransaction): PPerformanceInfo; cdecl;
begin
  Result := ITraceTransactionImpl(this).getPerf();
end;

function ITraceTransactionImpl_getInitialIDDispatcher(this: ITraceTransaction): Int64; cdecl;
begin
  Result := ITraceTransactionImpl(this).getInitialID();
end;

function ITraceTransactionImpl_getPreviousIDDispatcher(this: ITraceTransaction): Int64; cdecl;
begin
  Result := ITraceTransactionImpl(this).getPreviousID();
end;

var
  ITraceTransactionImpl_vTable: TraceTransactionVTable;

constructor ITraceTransactionImpl.create;
begin
  vTable := ITraceTransactionImpl_vTable;
end;

function ITraceParamsImpl_getCountDispatcher(this: ITraceParams): Cardinal; cdecl;
begin
  Result := ITraceParamsImpl(this).getCount();
end;

function ITraceParamsImpl_getParamDispatcher(this: ITraceParams; idx: Cardinal): Pdsc; cdecl;
begin
  Result := ITraceParamsImpl(this).getParam(idx);
end;

function ITraceParamsImpl_getTextUTF8Dispatcher(this: ITraceParams; status: IStatus; idx: Cardinal): PAnsiChar; cdecl;
begin
  Result := ITraceParamsImpl(this).getTextUTF8(status, idx);
end;

var
  ITraceParamsImpl_vTable: TraceParamsVTable;

constructor ITraceParamsImpl.create;
begin
  vTable := ITraceParamsImpl_vTable;
end;

function ITraceStatementImpl_getStmtIDDispatcher(this: ITraceStatement): Int64; cdecl;
begin
  Result := ITraceStatementImpl(this).getStmtID();
end;

function ITraceStatementImpl_getPerfDispatcher(this: ITraceStatement): PPerformanceInfo; cdecl;
begin
  Result := ITraceStatementImpl(this).getPerf();
end;

var
  ITraceStatementImpl_vTable: TraceStatementVTable;

constructor ITraceStatementImpl.create;
begin
  vTable := ITraceStatementImpl_vTable;
end;

function ITraceSQLStatementImpl_getStmtIDDispatcher(this: ITraceSQLStatement): Int64; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getStmtID();
end;

function ITraceSQLStatementImpl_getPerfDispatcher(this: ITraceSQLStatement): PPerformanceInfo; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getPerf();
end;

function ITraceSQLStatementImpl_getTextDispatcher(this: ITraceSQLStatement): PAnsiChar; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getText();
end;

function ITraceSQLStatementImpl_getPlanDispatcher(this: ITraceSQLStatement): PAnsiChar; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getPlan();
end;

function ITraceSQLStatementImpl_getInputsDispatcher(this: ITraceSQLStatement): ITraceParams; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getInputs();
end;

function ITraceSQLStatementImpl_getTextUTF8Dispatcher(this: ITraceSQLStatement): PAnsiChar; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getTextUTF8();
end;

function ITraceSQLStatementImpl_getExplainedPlanDispatcher(this: ITraceSQLStatement): PAnsiChar; cdecl;
begin
  Result := ITraceSQLStatementImpl(this).getExplainedPlan();
end;

var
  ITraceSQLStatementImpl_vTable: TraceSQLStatementVTable;

constructor ITraceSQLStatementImpl.create;
begin
  vTable := ITraceSQLStatementImpl_vTable;
end;

function ITraceBLRStatementImpl_getStmtIDDispatcher(this: ITraceBLRStatement): Int64; cdecl;
begin
  Result := ITraceBLRStatementImpl(this).getStmtID();
end;

function ITraceBLRStatementImpl_getPerfDispatcher(this: ITraceBLRStatement): PPerformanceInfo; cdecl;
begin
  Result := ITraceBLRStatementImpl(this).getPerf();
end;

function ITraceBLRStatementImpl_getDataDispatcher(this: ITraceBLRStatement): PByte; cdecl;
begin
  Result := ITraceBLRStatementImpl(this).getData();
end;

function ITraceBLRStatementImpl_getDataLengthDispatcher(this: ITraceBLRStatement): Cardinal; cdecl;
begin
  Result := ITraceBLRStatementImpl(this).getDataLength();
end;

function ITraceBLRStatementImpl_getTextDispatcher(this: ITraceBLRStatement): PAnsiChar; cdecl;
begin
  Result := ITraceBLRStatementImpl(this).getText();
end;

var
  ITraceBLRStatementImpl_vTable: TraceBLRStatementVTable;

constructor ITraceBLRStatementImpl.create;
begin
  vTable := ITraceBLRStatementImpl_vTable;
end;

function ITraceDYNRequestImpl_getDataDispatcher(this: ITraceDYNRequest): PByte; cdecl;
begin
  Result := ITraceDYNRequestImpl(this).getData();
end;

function ITraceDYNRequestImpl_getDataLengthDispatcher(this: ITraceDYNRequest): Cardinal; cdecl;
begin
  Result := ITraceDYNRequestImpl(this).getDataLength();
end;

function ITraceDYNRequestImpl_getTextDispatcher(this: ITraceDYNRequest): PAnsiChar; cdecl;
begin
  Result := ITraceDYNRequestImpl(this).getText();
end;

var
  ITraceDYNRequestImpl_vTable: TraceDYNRequestVTable;

constructor ITraceDYNRequestImpl.create;
begin
  vTable := ITraceDYNRequestImpl_vTable;
end;

function ITraceContextVariableImpl_getNameSpaceDispatcher(this: ITraceContextVariable): PAnsiChar; cdecl;
begin
  Result := ITraceContextVariableImpl(this).getNameSpace();
end;

function ITraceContextVariableImpl_getVarNameDispatcher(this: ITraceContextVariable): PAnsiChar; cdecl;
begin
  Result := ITraceContextVariableImpl(this).getVarName();
end;

function ITraceContextVariableImpl_getVarValueDispatcher(this: ITraceContextVariable): PAnsiChar; cdecl;
begin
  Result := ITraceContextVariableImpl(this).getVarValue();
end;

var
  ITraceContextVariableImpl_vTable: TraceContextVariableVTable;

constructor ITraceContextVariableImpl.create;
begin
  vTable := ITraceContextVariableImpl_vTable;
end;

function ITraceProcedureImpl_getProcNameDispatcher(this: ITraceProcedure): PAnsiChar; cdecl;
begin
  Result := ITraceProcedureImpl(this).getProcName();
end;

function ITraceProcedureImpl_getInputsDispatcher(this: ITraceProcedure): ITraceParams; cdecl;
begin
  Result := ITraceProcedureImpl(this).getInputs();
end;

function ITraceProcedureImpl_getPerfDispatcher(this: ITraceProcedure): PPerformanceInfo; cdecl;
begin
  Result := ITraceProcedureImpl(this).getPerf();
end;

var
  ITraceProcedureImpl_vTable: TraceProcedureVTable;

constructor ITraceProcedureImpl.create;
begin
  vTable := ITraceProcedureImpl_vTable;
end;

function ITraceFunctionImpl_getFuncNameDispatcher(this: ITraceFunction): PAnsiChar; cdecl;
begin
  Result := ITraceFunctionImpl(this).getFuncName();
end;

function ITraceFunctionImpl_getInputsDispatcher(this: ITraceFunction): ITraceParams; cdecl;
begin
  Result := ITraceFunctionImpl(this).getInputs();
end;

function ITraceFunctionImpl_getResultDispatcher(this: ITraceFunction): ITraceParams; cdecl;
begin
  Result := ITraceFunctionImpl(this).getResult();
end;

function ITraceFunctionImpl_getPerfDispatcher(this: ITraceFunction): PPerformanceInfo; cdecl;
begin
  Result := ITraceFunctionImpl(this).getPerf();
end;

var
  ITraceFunctionImpl_vTable: TraceFunctionVTable;

constructor ITraceFunctionImpl.create;
begin
  vTable := ITraceFunctionImpl_vTable;
end;

function ITraceTriggerImpl_getTriggerNameDispatcher(this: ITraceTrigger): PAnsiChar; cdecl;
begin
  Result := ITraceTriggerImpl(this).getTriggerName();
end;

function ITraceTriggerImpl_getRelationNameDispatcher(this: ITraceTrigger): PAnsiChar; cdecl;
begin
  Result := ITraceTriggerImpl(this).getRelationName();
end;

function ITraceTriggerImpl_getActionDispatcher(this: ITraceTrigger): Integer; cdecl;
begin
  Result := ITraceTriggerImpl(this).getAction();
end;

function ITraceTriggerImpl_getWhichDispatcher(this: ITraceTrigger): Integer; cdecl;
begin
  Result := ITraceTriggerImpl(this).getWhich();
end;

function ITraceTriggerImpl_getPerfDispatcher(this: ITraceTrigger): PPerformanceInfo; cdecl;
begin
  Result := ITraceTriggerImpl(this).getPerf();
end;

var
  ITraceTriggerImpl_vTable: TraceTriggerVTable;

constructor ITraceTriggerImpl.create;
begin
  vTable := ITraceTriggerImpl_vTable;
end;

function ITraceServiceConnectionImpl_getKindDispatcher(this: ITraceServiceConnection): Cardinal; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getKind();
end;

function ITraceServiceConnectionImpl_getProcessIDDispatcher(this: ITraceServiceConnection): Integer; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getProcessID();
end;

function ITraceServiceConnectionImpl_getUserNameDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getUserName();
end;

function ITraceServiceConnectionImpl_getRoleNameDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getRoleName();
end;

function ITraceServiceConnectionImpl_getCharSetDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getCharSet();
end;

function ITraceServiceConnectionImpl_getRemoteProtocolDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getRemoteProtocol();
end;

function ITraceServiceConnectionImpl_getRemoteAddressDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getRemoteAddress();
end;

function ITraceServiceConnectionImpl_getRemoteProcessIDDispatcher(this: ITraceServiceConnection): Integer; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getRemoteProcessID();
end;

function ITraceServiceConnectionImpl_getRemoteProcessNameDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getRemoteProcessName();
end;

function ITraceServiceConnectionImpl_getServiceIDDispatcher(this: ITraceServiceConnection): Pointer; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getServiceID();
end;

function ITraceServiceConnectionImpl_getServiceMgrDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getServiceMgr();
end;

function ITraceServiceConnectionImpl_getServiceNameDispatcher(this: ITraceServiceConnection): PAnsiChar; cdecl;
begin
  Result := ITraceServiceConnectionImpl(this).getServiceName();
end;

var
  ITraceServiceConnectionImpl_vTable: TraceServiceConnectionVTable;

constructor ITraceServiceConnectionImpl.create;
begin
  vTable := ITraceServiceConnectionImpl_vTable;
end;

function ITraceStatusVectorImpl_hasErrorDispatcher(this: ITraceStatusVector): Boolean; cdecl;
begin
  Result := ITraceStatusVectorImpl(this).hasError();
end;

function ITraceStatusVectorImpl_hasWarningDispatcher(this: ITraceStatusVector): Boolean; cdecl;
begin
  Result := ITraceStatusVectorImpl(this).hasWarning();
end;

function ITraceStatusVectorImpl_getStatusDispatcher(this: ITraceStatusVector): IStatus; cdecl;
begin
  Result := ITraceStatusVectorImpl(this).getStatus();
end;

function ITraceStatusVectorImpl_getTextDispatcher(this: ITraceStatusVector): PAnsiChar; cdecl;
begin
  Result := ITraceStatusVectorImpl(this).getText();
end;

var
  ITraceStatusVectorImpl_vTable: TraceStatusVectorVTable;

constructor ITraceStatusVectorImpl.create;
begin
  vTable := ITraceStatusVectorImpl_vTable;
end;

function ITraceSweepInfoImpl_getOITDispatcher(this: ITraceSweepInfo): Int64; cdecl;
begin
  Result := ITraceSweepInfoImpl(this).getOIT();
end;

function ITraceSweepInfoImpl_getOSTDispatcher(this: ITraceSweepInfo): Int64; cdecl;
begin
  Result := ITraceSweepInfoImpl(this).getOST();
end;

function ITraceSweepInfoImpl_getOATDispatcher(this: ITraceSweepInfo): Int64; cdecl;
begin
  Result := ITraceSweepInfoImpl(this).getOAT();
end;

function ITraceSweepInfoImpl_getNextDispatcher(this: ITraceSweepInfo): Int64; cdecl;
begin
  Result := ITraceSweepInfoImpl(this).getNext();
end;

function ITraceSweepInfoImpl_getPerfDispatcher(this: ITraceSweepInfo): PPerformanceInfo; cdecl;
begin
  Result := ITraceSweepInfoImpl(this).getPerf();
end;

var
  ITraceSweepInfoImpl_vTable: TraceSweepInfoVTable;

constructor ITraceSweepInfoImpl.create;
begin
  vTable := ITraceSweepInfoImpl_vTable;
end;

procedure ITraceLogWriterImpl_addRefDispatcher(this: ITraceLogWriter); cdecl;
begin
  ITraceLogWriterImpl(this).addRef();
end;

function ITraceLogWriterImpl_releaseDispatcher(this: ITraceLogWriter): Integer; cdecl;
begin
  Result := ITraceLogWriterImpl(this).release();
end;

function ITraceLogWriterImpl_writeDispatcher(this: ITraceLogWriter; buf: Pointer; size: Cardinal): Cardinal; cdecl;
begin
  Result := ITraceLogWriterImpl(this).write(buf, size);
end;

function ITraceLogWriterImpl_write_sDispatcher(this: ITraceLogWriter; status: IStatus; buf: Pointer; size: Cardinal): Cardinal; cdecl;
begin
  Result := ITraceLogWriterImpl(this).write_s(status, buf, size);
end;

var
  ITraceLogWriterImpl_vTable: TraceLogWriterVTable;

constructor ITraceLogWriterImpl.create;
begin
  vTable := ITraceLogWriterImpl_vTable;
end;

function ITraceInitInfoImpl_getConfigTextDispatcher(this: ITraceInitInfo): PAnsiChar; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getConfigText();
end;

function ITraceInitInfoImpl_getTraceSessionIDDispatcher(this: ITraceInitInfo): Integer; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getTraceSessionID();
end;

function ITraceInitInfoImpl_getTraceSessionNameDispatcher(this: ITraceInitInfo): PAnsiChar; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getTraceSessionName();
end;

function ITraceInitInfoImpl_getFirebirdRootDirectoryDispatcher(this: ITraceInitInfo): PAnsiChar; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getFirebirdRootDirectory();
end;

function ITraceInitInfoImpl_getDatabaseNameDispatcher(this: ITraceInitInfo): PAnsiChar; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getDatabaseName();
end;

function ITraceInitInfoImpl_getConnectionDispatcher(this: ITraceInitInfo): ITraceDatabaseConnection; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getConnection();
end;

function ITraceInitInfoImpl_getLogWriterDispatcher(this: ITraceInitInfo): ITraceLogWriter; cdecl;
begin
  Result := ITraceInitInfoImpl(this).getLogWriter();
end;

var
  ITraceInitInfoImpl_vTable: TraceInitInfoVTable;

constructor ITraceInitInfoImpl.create;
begin
  vTable := ITraceInitInfoImpl_vTable;
end;

procedure ITracePluginImpl_addRefDispatcher(this: ITracePlugin); cdecl;
begin
  ITracePluginImpl(this).addRef();
end;

function ITracePluginImpl_releaseDispatcher(this: ITracePlugin): Integer; cdecl;
begin
  Result := ITracePluginImpl(this).release();
end;

function ITracePluginImpl_trace_get_errorDispatcher(this: ITracePlugin): PAnsiChar; cdecl;
begin
  Result := ITracePluginImpl(this).trace_get_error();
end;

function ITracePluginImpl_trace_attachDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; create_db: Boolean; att_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_attach(connection, create_db, att_result);
end;

function ITracePluginImpl_trace_detachDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; drop_db: Boolean): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_detach(connection, drop_db);
end;

function ITracePluginImpl_trace_transaction_startDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; tpb_length: Cardinal; tpb: PByte; tra_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_transaction_start(connection, transaction, tpb_length, tpb, tra_result);
end;

function ITracePluginImpl_trace_transaction_endDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; commit: Boolean; retain_context: Boolean; tra_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_transaction_end(connection, transaction, commit, retain_context, tra_result);
end;

function ITracePluginImpl_trace_proc_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; procedure_: ITraceProcedure; started: Boolean; proc_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_proc_execute(connection, transaction, procedure_, started, proc_result);
end;

function ITracePluginImpl_trace_trigger_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; trigger: ITraceTrigger; started: Boolean; trig_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_trigger_execute(connection, transaction, trigger, started, trig_result);
end;

function ITracePluginImpl_trace_set_contextDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; variable: ITraceContextVariable): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_set_context(connection, transaction, variable);
end;

function ITracePluginImpl_trace_dsql_prepareDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_dsql_prepare(connection, transaction, statement, time_millis, req_result);
end;

function ITracePluginImpl_trace_dsql_freeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; statement: ITraceSQLStatement; option: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_dsql_free(connection, statement, option);
end;

function ITracePluginImpl_trace_dsql_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceSQLStatement; started: Boolean; req_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_dsql_execute(connection, transaction, statement, started, req_result);
end;

function ITracePluginImpl_trace_blr_compileDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_blr_compile(connection, transaction, statement, time_millis, req_result);
end;

function ITracePluginImpl_trace_blr_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; statement: ITraceBLRStatement; req_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_blr_execute(connection, transaction, statement, req_result);
end;

function ITracePluginImpl_trace_dyn_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; request: ITraceDYNRequest; time_millis: Int64; req_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_dyn_execute(connection, transaction, request, time_millis, req_result);
end;

function ITracePluginImpl_trace_service_attachDispatcher(this: ITracePlugin; service: ITraceServiceConnection; att_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_service_attach(service, att_result);
end;

function ITracePluginImpl_trace_service_startDispatcher(this: ITracePlugin; service: ITraceServiceConnection; switches_length: Cardinal; switches: PAnsiChar; start_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_service_start(service, switches_length, switches, start_result);
end;

function ITracePluginImpl_trace_service_queryDispatcher(this: ITracePlugin; service: ITraceServiceConnection; send_item_length: Cardinal; send_items: PByte; recv_item_length: Cardinal; recv_items: PByte; query_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_service_query(service, send_item_length, send_items, recv_item_length, recv_items, query_result);
end;

function ITracePluginImpl_trace_service_detachDispatcher(this: ITracePlugin; service: ITraceServiceConnection; detach_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_service_detach(service, detach_result);
end;

function ITracePluginImpl_trace_event_errorDispatcher(this: ITracePlugin; connection: ITraceConnection; status: ITraceStatusVector; function_: PAnsiChar): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_event_error(connection, status, function_);
end;

function ITracePluginImpl_trace_event_sweepDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; sweep: ITraceSweepInfo; sweep_state: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_event_sweep(connection, sweep, sweep_state);
end;

function ITracePluginImpl_trace_func_executeDispatcher(this: ITracePlugin; connection: ITraceDatabaseConnection; transaction: ITraceTransaction; function_: ITraceFunction; started: Boolean; func_result: Cardinal): Boolean; cdecl;
begin
  Result := ITracePluginImpl(this).trace_func_execute(connection, transaction, function_, started, func_result);
end;

var
  ITracePluginImpl_vTable: TracePluginVTable;

constructor ITracePluginImpl.create;
begin
  vTable := ITracePluginImpl_vTable;
end;

procedure ITraceFactoryImpl_addRefDispatcher(this: ITraceFactory); cdecl;
begin
  ITraceFactoryImpl(this).addRef();
end;

function ITraceFactoryImpl_releaseDispatcher(this: ITraceFactory): Integer; cdecl;
begin
  Result := ITraceFactoryImpl(this).release();
end;

procedure ITraceFactoryImpl_setOwnerDispatcher(this: ITraceFactory; r: IReferenceCounted); cdecl;
begin
  ITraceFactoryImpl(this).setOwner(r);
end;

function ITraceFactoryImpl_getOwnerDispatcher(this: ITraceFactory): IReferenceCounted; cdecl;
begin
  Result := ITraceFactoryImpl(this).getOwner();
end;

function ITraceFactoryImpl_trace_needsDispatcher(this: ITraceFactory): UInt64; cdecl;
begin
  Result := ITraceFactoryImpl(this).trace_needs();
end;

function ITraceFactoryImpl_trace_createDispatcher(this: ITraceFactory; status: IStatus; init_info: ITraceInitInfo): ITracePlugin; cdecl;
begin
  Result := ITraceFactoryImpl(this).trace_create(status, init_info);
end;

var
  ITraceFactoryImpl_vTable: TraceFactoryVTable;

constructor ITraceFactoryImpl.create;
begin
  vTable := ITraceFactoryImpl_vTable;
end;

procedure IUdrFunctionFactoryImpl_disposeDispatcher(this: IUdrFunctionFactory); cdecl;
begin
  IUdrFunctionFactoryImpl(this).dispose();
end;

procedure IUdrFunctionFactoryImpl_setupDispatcher(this: IUdrFunctionFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); cdecl;
begin
  IUdrFunctionFactoryImpl(this).setup(status, context, metadata, inBuilder, outBuilder);
end;

function IUdrFunctionFactoryImpl_newItemDispatcher(this: IUdrFunctionFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalFunction; cdecl;
begin
  Result := IUdrFunctionFactoryImpl(this).newItem(status, context, metadata);
end;

var
  IUdrFunctionFactoryImpl_vTable: UdrFunctionFactoryVTable;

constructor IUdrFunctionFactoryImpl.create;
begin
  vTable := IUdrFunctionFactoryImpl_vTable;
end;

procedure IUdrProcedureFactoryImpl_disposeDispatcher(this: IUdrProcedureFactory); cdecl;
begin
  IUdrProcedureFactoryImpl(this).dispose();
end;

procedure IUdrProcedureFactoryImpl_setupDispatcher(this: IUdrProcedureFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; inBuilder: IMetadataBuilder; outBuilder: IMetadataBuilder); cdecl;
begin
  IUdrProcedureFactoryImpl(this).setup(status, context, metadata, inBuilder, outBuilder);
end;

function IUdrProcedureFactoryImpl_newItemDispatcher(this: IUdrProcedureFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalProcedure; cdecl;
begin
  Result := IUdrProcedureFactoryImpl(this).newItem(status, context, metadata);
end;

var
  IUdrProcedureFactoryImpl_vTable: UdrProcedureFactoryVTable;

constructor IUdrProcedureFactoryImpl.create;
begin
  vTable := IUdrProcedureFactoryImpl_vTable;
end;

procedure IUdrTriggerFactoryImpl_disposeDispatcher(this: IUdrTriggerFactory); cdecl;
begin
  IUdrTriggerFactoryImpl(this).dispose();
end;

procedure IUdrTriggerFactoryImpl_setupDispatcher(this: IUdrTriggerFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata; fieldsBuilder: IMetadataBuilder); cdecl;
begin
  IUdrTriggerFactoryImpl(this).setup(status, context, metadata, fieldsBuilder);
end;

function IUdrTriggerFactoryImpl_newItemDispatcher(this: IUdrTriggerFactory; status: IStatus; context: IExternalContext; metadata: IRoutineMetadata): IExternalTrigger; cdecl;
begin
  Result := IUdrTriggerFactoryImpl(this).newItem(status, context, metadata);
end;

var
  IUdrTriggerFactoryImpl_vTable: UdrTriggerFactoryVTable;

constructor IUdrTriggerFactoryImpl.create;
begin
  vTable := IUdrTriggerFactoryImpl_vTable;
end;

function IUdrPluginImpl_getMasterDispatcher(this: IUdrPlugin): IMaster; cdecl;
begin
  Result := IUdrPluginImpl(this).getMaster();
end;

procedure IUdrPluginImpl_registerFunctionDispatcher(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrFunctionFactory); cdecl;
begin
  IUdrPluginImpl(this).registerFunction(status, name, factory);
end;

procedure IUdrPluginImpl_registerProcedureDispatcher(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrProcedureFactory); cdecl;
begin
  IUdrPluginImpl(this).registerProcedure(status, name, factory);
end;

procedure IUdrPluginImpl_registerTriggerDispatcher(this: IUdrPlugin; status: IStatus; name: PAnsiChar; factory: IUdrTriggerFactory); cdecl;
begin
  IUdrPluginImpl(this).registerTrigger(status, name, factory);
end;

var
  IUdrPluginImpl_vTable: UdrPluginVTable;

constructor IUdrPluginImpl.create;
begin
  vTable := IUdrPluginImpl_vTable;
end;

procedure IDecFloat16Impl_toBcdDispatcher(this: IDecFloat16; from: PFB_DEC16; sign: PInteger; bcd: PByte; exp: PInteger); cdecl;
begin
  IDecFloat16Impl(this).toBcd(from, sign, bcd, exp);
end;

procedure IDecFloat16Impl_toStringDispatcher(this: IDecFloat16; status: IStatus; from: PFB_DEC16; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
begin
  IDecFloat16Impl(this).toString(status, from, bufferLength, buffer);
end;

procedure IDecFloat16Impl_fromBcdDispatcher(this: IDecFloat16; sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC16); cdecl;
begin
  IDecFloat16Impl(this).fromBcd(sign, bcd, exp, to_);
end;

procedure IDecFloat16Impl_fromStringDispatcher(this: IDecFloat16; status: IStatus; from: PAnsiChar; to_: PFB_DEC16); cdecl;
begin
  IDecFloat16Impl(this).fromString(status, from, to_);
end;

var
  IDecFloat16Impl_vTable: DecFloat16VTable;

constructor IDecFloat16Impl.create;
begin
  vTable := IDecFloat16Impl_vTable;
end;

procedure IDecFloat34Impl_toBcdDispatcher(this: IDecFloat34; from: PFB_DEC34; sign: PInteger; bcd: PByte; exp: PInteger); cdecl;
begin
  IDecFloat34Impl(this).toBcd(from, sign, bcd, exp);
end;

procedure IDecFloat34Impl_toStringDispatcher(this: IDecFloat34; status: IStatus; from: PFB_DEC34; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
begin
  IDecFloat34Impl(this).toString(status, from, bufferLength, buffer);
end;

procedure IDecFloat34Impl_fromBcdDispatcher(this: IDecFloat34; sign: Integer; bcd: PByte; exp: Integer; to_: PFB_DEC34); cdecl;
begin
  IDecFloat34Impl(this).fromBcd(sign, bcd, exp, to_);
end;

procedure IDecFloat34Impl_fromStringDispatcher(this: IDecFloat34; status: IStatus; from: PAnsiChar; to_: PFB_DEC34); cdecl;
begin
  IDecFloat34Impl(this).fromString(status, from, to_);
end;

var
  IDecFloat34Impl_vTable: DecFloat34VTable;

constructor IDecFloat34Impl.create;
begin
  vTable := IDecFloat34Impl_vTable;
end;

procedure IInt128Impl_toStringDispatcher(this: IInt128; status: IStatus; from: PFB_I128; scale: Integer; bufferLength: Cardinal; buffer: PAnsiChar); cdecl;
begin
  IInt128Impl(this).toString(status, from, scale, bufferLength, buffer);
end;

procedure IInt128Impl_fromStringDispatcher(this: IInt128; status: IStatus; scale: Integer; from: PAnsiChar; to_: PFB_I128); cdecl;
begin
  IInt128Impl(this).fromString(status, scale, from, to_);
end;

var
  IInt128Impl_vTable: Int128VTable;

constructor IInt128Impl.create;
begin
  vTable := IInt128Impl_vTable;
end;

function IReplicatedFieldImpl_getNameDispatcher(this: IReplicatedField): PAnsiChar; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getName();
end;

function IReplicatedFieldImpl_getTypeDispatcher(this: IReplicatedField): Cardinal; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getType();
end;

function IReplicatedFieldImpl_getSubTypeDispatcher(this: IReplicatedField): Integer; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getSubType();
end;

function IReplicatedFieldImpl_getScaleDispatcher(this: IReplicatedField): Integer; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getScale();
end;

function IReplicatedFieldImpl_getLengthDispatcher(this: IReplicatedField): Cardinal; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getLength();
end;

function IReplicatedFieldImpl_getCharSetDispatcher(this: IReplicatedField): Cardinal; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getCharSet();
end;

function IReplicatedFieldImpl_getDataDispatcher(this: IReplicatedField): Pointer; cdecl;
begin
  Result := IReplicatedFieldImpl(this).getData();
end;

var
  IReplicatedFieldImpl_vTable: ReplicatedFieldVTable;

constructor IReplicatedFieldImpl.create;
begin
  vTable := IReplicatedFieldImpl_vTable;
end;

function IReplicatedRecordImpl_getCountDispatcher(this: IReplicatedRecord): Cardinal; cdecl;
begin
  Result := IReplicatedRecordImpl(this).getCount();
end;

function IReplicatedRecordImpl_getFieldDispatcher(this: IReplicatedRecord; index: Cardinal): IReplicatedField; cdecl;
begin
  Result := IReplicatedRecordImpl(this).getField(index);
end;

function IReplicatedRecordImpl_getRawLengthDispatcher(this: IReplicatedRecord): Cardinal; cdecl;
begin
  Result := IReplicatedRecordImpl(this).getRawLength();
end;

function IReplicatedRecordImpl_getRawDataDispatcher(this: IReplicatedRecord): PByte; cdecl;
begin
  Result := IReplicatedRecordImpl(this).getRawData();
end;

var
  IReplicatedRecordImpl_vTable: ReplicatedRecordVTable;

constructor IReplicatedRecordImpl.create;
begin
  vTable := IReplicatedRecordImpl_vTable;
end;

procedure IReplicatedTransactionImpl_disposeDispatcher(this: IReplicatedTransaction); cdecl;
begin
  IReplicatedTransactionImpl(this).dispose();
end;

procedure IReplicatedTransactionImpl_prepareDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).prepare(status);
end;

procedure IReplicatedTransactionImpl_commitDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).commit(status);
end;

procedure IReplicatedTransactionImpl_rollbackDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).rollback(status);
end;

procedure IReplicatedTransactionImpl_startSavepointDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).startSavepoint(status);
end;

procedure IReplicatedTransactionImpl_releaseSavepointDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).releaseSavepoint(status);
end;

procedure IReplicatedTransactionImpl_rollbackSavepointDispatcher(this: IReplicatedTransaction; status: IStatus); cdecl;
begin
  IReplicatedTransactionImpl(this).rollbackSavepoint(status);
end;

procedure IReplicatedTransactionImpl_insertRecordDispatcher(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); cdecl;
begin
  IReplicatedTransactionImpl(this).insertRecord(status, name, record_);
end;

procedure IReplicatedTransactionImpl_updateRecordDispatcher(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; orgRecord: IReplicatedRecord; newRecord: IReplicatedRecord); cdecl;
begin
  IReplicatedTransactionImpl(this).updateRecord(status, name, orgRecord, newRecord);
end;

procedure IReplicatedTransactionImpl_deleteRecordDispatcher(this: IReplicatedTransaction; status: IStatus; name: PAnsiChar; record_: IReplicatedRecord); cdecl;
begin
  IReplicatedTransactionImpl(this).deleteRecord(status, name, record_);
end;

procedure IReplicatedTransactionImpl_executeSqlDispatcher(this: IReplicatedTransaction; status: IStatus; sql: PAnsiChar); cdecl;
begin
  IReplicatedTransactionImpl(this).executeSql(status, sql);
end;

procedure IReplicatedTransactionImpl_executeSqlIntlDispatcher(this: IReplicatedTransaction; status: IStatus; charset: Cardinal; sql: PAnsiChar); cdecl;
begin
  IReplicatedTransactionImpl(this).executeSqlIntl(status, charset, sql);
end;

var
  IReplicatedTransactionImpl_vTable: ReplicatedTransactionVTable;

constructor IReplicatedTransactionImpl.create;
begin
  vTable := IReplicatedTransactionImpl_vTable;
end;

procedure IReplicatedSessionImpl_addRefDispatcher(this: IReplicatedSession); cdecl;
begin
  IReplicatedSessionImpl(this).addRef();
end;

function IReplicatedSessionImpl_releaseDispatcher(this: IReplicatedSession): Integer; cdecl;
begin
  Result := IReplicatedSessionImpl(this).release();
end;

procedure IReplicatedSessionImpl_setOwnerDispatcher(this: IReplicatedSession; r: IReferenceCounted); cdecl;
begin
  IReplicatedSessionImpl(this).setOwner(r);
end;

function IReplicatedSessionImpl_getOwnerDispatcher(this: IReplicatedSession): IReferenceCounted; cdecl;
begin
  Result := IReplicatedSessionImpl(this).getOwner();
end;

procedure IReplicatedSessionImpl_setAttachmentDispatcher(this: IReplicatedSession; attachment: IAttachment); cdecl;
begin
  IReplicatedSessionImpl(this).setAttachment(attachment);
end;

function IReplicatedSessionImpl_startTransactionDispatcher(this: IReplicatedSession; status: IStatus; transaction: ITransaction; number: Int64): IReplicatedTransaction; cdecl;
begin
  Result := IReplicatedSessionImpl(this).startTransaction(status, transaction, number);
end;

procedure IReplicatedSessionImpl_cleanupTransactionDispatcher(this: IReplicatedSession; status: IStatus; number: Int64); cdecl;
begin
  IReplicatedSessionImpl(this).cleanupTransaction(status, number);
end;

procedure IReplicatedSessionImpl_setSequenceDispatcher(this: IReplicatedSession; status: IStatus; name: PAnsiChar; value: Int64); cdecl;
begin
  IReplicatedSessionImpl(this).setSequence(status, name, value);
end;

var
  IReplicatedSessionImpl_vTable: ReplicatedSessionVTable;

constructor IReplicatedSessionImpl.create;
begin
  vTable := IReplicatedSessionImpl_vTable;
end;

initialization
  IVersionedImpl_vTable := VersionedVTable.create;
  IVersionedImpl_vTable.version := 1;

  IReferenceCountedImpl_vTable := ReferenceCountedVTable.create;
  IReferenceCountedImpl_vTable.version := 2;
  IReferenceCountedImpl_vTable.addRef := @IReferenceCountedImpl_addRefDispatcher;
  IReferenceCountedImpl_vTable.release := @IReferenceCountedImpl_releaseDispatcher;

  IDisposableImpl_vTable := DisposableVTable.create;
  IDisposableImpl_vTable.version := 2;
  IDisposableImpl_vTable.dispose := @IDisposableImpl_disposeDispatcher;

  IStatusImpl_vTable := StatusVTable.create;
  IStatusImpl_vTable.version := 3;
  IStatusImpl_vTable.dispose := @IStatusImpl_disposeDispatcher;
  IStatusImpl_vTable.init := @IStatusImpl_initDispatcher;
  IStatusImpl_vTable.getState := @IStatusImpl_getStateDispatcher;
  IStatusImpl_vTable.setErrors2 := @IStatusImpl_setErrors2Dispatcher;
  IStatusImpl_vTable.setWarnings2 := @IStatusImpl_setWarnings2Dispatcher;
  IStatusImpl_vTable.setErrors := @IStatusImpl_setErrorsDispatcher;
  IStatusImpl_vTable.setWarnings := @IStatusImpl_setWarningsDispatcher;
  IStatusImpl_vTable.getErrors := @IStatusImpl_getErrorsDispatcher;
  IStatusImpl_vTable.getWarnings := @IStatusImpl_getWarningsDispatcher;
  IStatusImpl_vTable.clone := @IStatusImpl_cloneDispatcher;

  IMasterImpl_vTable := MasterVTable.create;
  IMasterImpl_vTable.version := 2;
  IMasterImpl_vTable.getStatus := @IMasterImpl_getStatusDispatcher;
  IMasterImpl_vTable.getDispatcher := @IMasterImpl_getDispatcherDispatcher;
  IMasterImpl_vTable.getPluginManager := @IMasterImpl_getPluginManagerDispatcher;
  IMasterImpl_vTable.getTimerControl := @IMasterImpl_getTimerControlDispatcher;
  IMasterImpl_vTable.getDtc := @IMasterImpl_getDtcDispatcher;
  IMasterImpl_vTable.registerAttachment := @IMasterImpl_registerAttachmentDispatcher;
  IMasterImpl_vTable.registerTransaction := @IMasterImpl_registerTransactionDispatcher;
  IMasterImpl_vTable.getMetadataBuilder := @IMasterImpl_getMetadataBuilderDispatcher;
  IMasterImpl_vTable.serverMode := @IMasterImpl_serverModeDispatcher;
  IMasterImpl_vTable.getUtilInterface := @IMasterImpl_getUtilInterfaceDispatcher;
  IMasterImpl_vTable.getConfigManager := @IMasterImpl_getConfigManagerDispatcher;
  IMasterImpl_vTable.getProcessExiting := @IMasterImpl_getProcessExitingDispatcher;

  IPluginBaseImpl_vTable := PluginBaseVTable.create;
  IPluginBaseImpl_vTable.version := 3;
  IPluginBaseImpl_vTable.addRef := @IPluginBaseImpl_addRefDispatcher;
  IPluginBaseImpl_vTable.release := @IPluginBaseImpl_releaseDispatcher;
  IPluginBaseImpl_vTable.setOwner := @IPluginBaseImpl_setOwnerDispatcher;
  IPluginBaseImpl_vTable.getOwner := @IPluginBaseImpl_getOwnerDispatcher;

  IPluginSetImpl_vTable := PluginSetVTable.create;
  IPluginSetImpl_vTable.version := 3;
  IPluginSetImpl_vTable.addRef := @IPluginSetImpl_addRefDispatcher;
  IPluginSetImpl_vTable.release := @IPluginSetImpl_releaseDispatcher;
  IPluginSetImpl_vTable.getName := @IPluginSetImpl_getNameDispatcher;
  IPluginSetImpl_vTable.getModuleName := @IPluginSetImpl_getModuleNameDispatcher;
  IPluginSetImpl_vTable.getPlugin := @IPluginSetImpl_getPluginDispatcher;
  IPluginSetImpl_vTable.next := @IPluginSetImpl_nextDispatcher;
  IPluginSetImpl_vTable.set_ := @IPluginSetImpl_set_Dispatcher;

  IConfigEntryImpl_vTable := ConfigEntryVTable.create;
  IConfigEntryImpl_vTable.version := 3;
  IConfigEntryImpl_vTable.addRef := @IConfigEntryImpl_addRefDispatcher;
  IConfigEntryImpl_vTable.release := @IConfigEntryImpl_releaseDispatcher;
  IConfigEntryImpl_vTable.getName := @IConfigEntryImpl_getNameDispatcher;
  IConfigEntryImpl_vTable.getValue := @IConfigEntryImpl_getValueDispatcher;
  IConfigEntryImpl_vTable.getIntValue := @IConfigEntryImpl_getIntValueDispatcher;
  IConfigEntryImpl_vTable.getBoolValue := @IConfigEntryImpl_getBoolValueDispatcher;
  IConfigEntryImpl_vTable.getSubConfig := @IConfigEntryImpl_getSubConfigDispatcher;

  IConfigImpl_vTable := ConfigVTable.create;
  IConfigImpl_vTable.version := 3;
  IConfigImpl_vTable.addRef := @IConfigImpl_addRefDispatcher;
  IConfigImpl_vTable.release := @IConfigImpl_releaseDispatcher;
  IConfigImpl_vTable.find := @IConfigImpl_findDispatcher;
  IConfigImpl_vTable.findValue := @IConfigImpl_findValueDispatcher;
  IConfigImpl_vTable.findPos := @IConfigImpl_findPosDispatcher;

  IFirebirdConfImpl_vTable := FirebirdConfVTable.create;
  IFirebirdConfImpl_vTable.version := 4;
  IFirebirdConfImpl_vTable.addRef := @IFirebirdConfImpl_addRefDispatcher;
  IFirebirdConfImpl_vTable.release := @IFirebirdConfImpl_releaseDispatcher;
  IFirebirdConfImpl_vTable.getKey := @IFirebirdConfImpl_getKeyDispatcher;
  IFirebirdConfImpl_vTable.asInteger := @IFirebirdConfImpl_asIntegerDispatcher;
  IFirebirdConfImpl_vTable.asString := @IFirebirdConfImpl_asStringDispatcher;
  IFirebirdConfImpl_vTable.asBoolean := @IFirebirdConfImpl_asBooleanDispatcher;
  IFirebirdConfImpl_vTable.getVersion := @IFirebirdConfImpl_getVersionDispatcher;

  IPluginConfigImpl_vTable := PluginConfigVTable.create;
  IPluginConfigImpl_vTable.version := 3;
  IPluginConfigImpl_vTable.addRef := @IPluginConfigImpl_addRefDispatcher;
  IPluginConfigImpl_vTable.release := @IPluginConfigImpl_releaseDispatcher;
  IPluginConfigImpl_vTable.getConfigFileName := @IPluginConfigImpl_getConfigFileNameDispatcher;
  IPluginConfigImpl_vTable.getDefaultConfig := @IPluginConfigImpl_getDefaultConfigDispatcher;
  IPluginConfigImpl_vTable.getFirebirdConf := @IPluginConfigImpl_getFirebirdConfDispatcher;
  IPluginConfigImpl_vTable.setReleaseDelay := @IPluginConfigImpl_setReleaseDelayDispatcher;

  IPluginFactoryImpl_vTable := PluginFactoryVTable.create;
  IPluginFactoryImpl_vTable.version := 2;
  IPluginFactoryImpl_vTable.createPlugin := @IPluginFactoryImpl_createPluginDispatcher;

  IPluginModuleImpl_vTable := PluginModuleVTable.create;
  IPluginModuleImpl_vTable.version := 3;
  IPluginModuleImpl_vTable.doClean := @IPluginModuleImpl_doCleanDispatcher;
  IPluginModuleImpl_vTable.threadDetach := @IPluginModuleImpl_threadDetachDispatcher;

  IPluginManagerImpl_vTable := PluginManagerVTable.create;
  IPluginManagerImpl_vTable.version := 2;
  IPluginManagerImpl_vTable.registerPluginFactory := @IPluginManagerImpl_registerPluginFactoryDispatcher;
  IPluginManagerImpl_vTable.registerModule := @IPluginManagerImpl_registerModuleDispatcher;
  IPluginManagerImpl_vTable.unregisterModule := @IPluginManagerImpl_unregisterModuleDispatcher;
  IPluginManagerImpl_vTable.getPlugins := @IPluginManagerImpl_getPluginsDispatcher;
  IPluginManagerImpl_vTable.getConfig := @IPluginManagerImpl_getConfigDispatcher;
  IPluginManagerImpl_vTable.releasePlugin := @IPluginManagerImpl_releasePluginDispatcher;

  ICryptKeyImpl_vTable := CryptKeyVTable.create;
  ICryptKeyImpl_vTable.version := 3;
  ICryptKeyImpl_vTable.setSymmetric := @ICryptKeyImpl_setSymmetricDispatcher;
  ICryptKeyImpl_vTable.setAsymmetric := @ICryptKeyImpl_setAsymmetricDispatcher;
  ICryptKeyImpl_vTable.getEncryptKey := @ICryptKeyImpl_getEncryptKeyDispatcher;
  ICryptKeyImpl_vTable.getDecryptKey := @ICryptKeyImpl_getDecryptKeyDispatcher;

  IConfigManagerImpl_vTable := ConfigManagerVTable.create;
  IConfigManagerImpl_vTable.version := 7;
  IConfigManagerImpl_vTable.getDirectory := @IConfigManagerImpl_getDirectoryDispatcher;
  IConfigManagerImpl_vTable.getFirebirdConf := @IConfigManagerImpl_getFirebirdConfDispatcher;
  IConfigManagerImpl_vTable.getDatabaseConf := @IConfigManagerImpl_getDatabaseConfDispatcher;
  IConfigManagerImpl_vTable.getPluginConfig := @IConfigManagerImpl_getPluginConfigDispatcher;
  IConfigManagerImpl_vTable.getInstallDirectory := @IConfigManagerImpl_getInstallDirectoryDispatcher;
  IConfigManagerImpl_vTable.getRootDirectory := @IConfigManagerImpl_getRootDirectoryDispatcher;
  IConfigManagerImpl_vTable.getDefaultSecurityDb := @IConfigManagerImpl_getDefaultSecurityDbDispatcher;

  IEventCallbackImpl_vTable := EventCallbackVTable.create;
  IEventCallbackImpl_vTable.version := 3;
  IEventCallbackImpl_vTable.addRef := @IEventCallbackImpl_addRefDispatcher;
  IEventCallbackImpl_vTable.release := @IEventCallbackImpl_releaseDispatcher;
  IEventCallbackImpl_vTable.eventCallbackFunction := @IEventCallbackImpl_eventCallbackFunctionDispatcher;

  IBlobImpl_vTable := BlobVTable.create;
  IBlobImpl_vTable.version := 3;
  IBlobImpl_vTable.addRef := @IBlobImpl_addRefDispatcher;
  IBlobImpl_vTable.release := @IBlobImpl_releaseDispatcher;
  IBlobImpl_vTable.getInfo := @IBlobImpl_getInfoDispatcher;
  IBlobImpl_vTable.getSegment := @IBlobImpl_getSegmentDispatcher;
  IBlobImpl_vTable.putSegment := @IBlobImpl_putSegmentDispatcher;
  IBlobImpl_vTable.cancel := @IBlobImpl_cancelDispatcher;
  IBlobImpl_vTable.close := @IBlobImpl_closeDispatcher;
  IBlobImpl_vTable.seek := @IBlobImpl_seekDispatcher;

  ITransactionImpl_vTable := TransactionVTable.create;
  ITransactionImpl_vTable.version := 3;
  ITransactionImpl_vTable.addRef := @ITransactionImpl_addRefDispatcher;
  ITransactionImpl_vTable.release := @ITransactionImpl_releaseDispatcher;
  ITransactionImpl_vTable.getInfo := @ITransactionImpl_getInfoDispatcher;
  ITransactionImpl_vTable.prepare := @ITransactionImpl_prepareDispatcher;
  ITransactionImpl_vTable.commit := @ITransactionImpl_commitDispatcher;
  ITransactionImpl_vTable.commitRetaining := @ITransactionImpl_commitRetainingDispatcher;
  ITransactionImpl_vTable.rollback := @ITransactionImpl_rollbackDispatcher;
  ITransactionImpl_vTable.rollbackRetaining := @ITransactionImpl_rollbackRetainingDispatcher;
  ITransactionImpl_vTable.disconnect := @ITransactionImpl_disconnectDispatcher;
  ITransactionImpl_vTable.join := @ITransactionImpl_joinDispatcher;
  ITransactionImpl_vTable.validate := @ITransactionImpl_validateDispatcher;
  ITransactionImpl_vTable.enterDtc := @ITransactionImpl_enterDtcDispatcher;

  IMessageMetadataImpl_vTable := MessageMetadataVTable.create;
  IMessageMetadataImpl_vTable.version := 4;
  IMessageMetadataImpl_vTable.addRef := @IMessageMetadataImpl_addRefDispatcher;
  IMessageMetadataImpl_vTable.release := @IMessageMetadataImpl_releaseDispatcher;
  IMessageMetadataImpl_vTable.getCount := @IMessageMetadataImpl_getCountDispatcher;
  IMessageMetadataImpl_vTable.getField := @IMessageMetadataImpl_getFieldDispatcher;
  IMessageMetadataImpl_vTable.getRelation := @IMessageMetadataImpl_getRelationDispatcher;
  IMessageMetadataImpl_vTable.getOwner := @IMessageMetadataImpl_getOwnerDispatcher;
  IMessageMetadataImpl_vTable.getAlias := @IMessageMetadataImpl_getAliasDispatcher;
  IMessageMetadataImpl_vTable.getType := @IMessageMetadataImpl_getTypeDispatcher;
  IMessageMetadataImpl_vTable.isNullable := @IMessageMetadataImpl_isNullableDispatcher;
  IMessageMetadataImpl_vTable.getSubType := @IMessageMetadataImpl_getSubTypeDispatcher;
  IMessageMetadataImpl_vTable.getLength := @IMessageMetadataImpl_getLengthDispatcher;
  IMessageMetadataImpl_vTable.getScale := @IMessageMetadataImpl_getScaleDispatcher;
  IMessageMetadataImpl_vTable.getCharSet := @IMessageMetadataImpl_getCharSetDispatcher;
  IMessageMetadataImpl_vTable.getOffset := @IMessageMetadataImpl_getOffsetDispatcher;
  IMessageMetadataImpl_vTable.getNullOffset := @IMessageMetadataImpl_getNullOffsetDispatcher;
  IMessageMetadataImpl_vTable.getBuilder := @IMessageMetadataImpl_getBuilderDispatcher;
  IMessageMetadataImpl_vTable.getMessageLength := @IMessageMetadataImpl_getMessageLengthDispatcher;
  IMessageMetadataImpl_vTable.getAlignment := @IMessageMetadataImpl_getAlignmentDispatcher;
  IMessageMetadataImpl_vTable.getAlignedLength := @IMessageMetadataImpl_getAlignedLengthDispatcher;

  IMetadataBuilderImpl_vTable := MetadataBuilderVTable.create;
  IMetadataBuilderImpl_vTable.version := 4;
  IMetadataBuilderImpl_vTable.addRef := @IMetadataBuilderImpl_addRefDispatcher;
  IMetadataBuilderImpl_vTable.release := @IMetadataBuilderImpl_releaseDispatcher;
  IMetadataBuilderImpl_vTable.setType := @IMetadataBuilderImpl_setTypeDispatcher;
  IMetadataBuilderImpl_vTable.setSubType := @IMetadataBuilderImpl_setSubTypeDispatcher;
  IMetadataBuilderImpl_vTable.setLength := @IMetadataBuilderImpl_setLengthDispatcher;
  IMetadataBuilderImpl_vTable.setCharSet := @IMetadataBuilderImpl_setCharSetDispatcher;
  IMetadataBuilderImpl_vTable.setScale := @IMetadataBuilderImpl_setScaleDispatcher;
  IMetadataBuilderImpl_vTable.truncate := @IMetadataBuilderImpl_truncateDispatcher;
  IMetadataBuilderImpl_vTable.moveNameToIndex := @IMetadataBuilderImpl_moveNameToIndexDispatcher;
  IMetadataBuilderImpl_vTable.remove := @IMetadataBuilderImpl_removeDispatcher;
  IMetadataBuilderImpl_vTable.addField := @IMetadataBuilderImpl_addFieldDispatcher;
  IMetadataBuilderImpl_vTable.getMetadata := @IMetadataBuilderImpl_getMetadataDispatcher;
  IMetadataBuilderImpl_vTable.setField := @IMetadataBuilderImpl_setFieldDispatcher;
  IMetadataBuilderImpl_vTable.setRelation := @IMetadataBuilderImpl_setRelationDispatcher;
  IMetadataBuilderImpl_vTable.setOwner := @IMetadataBuilderImpl_setOwnerDispatcher;
  IMetadataBuilderImpl_vTable.setAlias := @IMetadataBuilderImpl_setAliasDispatcher;

  IResultSetImpl_vTable := ResultSetVTable.create;
  IResultSetImpl_vTable.version := 3;
  IResultSetImpl_vTable.addRef := @IResultSetImpl_addRefDispatcher;
  IResultSetImpl_vTable.release := @IResultSetImpl_releaseDispatcher;
  IResultSetImpl_vTable.fetchNext := @IResultSetImpl_fetchNextDispatcher;
  IResultSetImpl_vTable.fetchPrior := @IResultSetImpl_fetchPriorDispatcher;
  IResultSetImpl_vTable.fetchFirst := @IResultSetImpl_fetchFirstDispatcher;
  IResultSetImpl_vTable.fetchLast := @IResultSetImpl_fetchLastDispatcher;
  IResultSetImpl_vTable.fetchAbsolute := @IResultSetImpl_fetchAbsoluteDispatcher;
  IResultSetImpl_vTable.fetchRelative := @IResultSetImpl_fetchRelativeDispatcher;
  IResultSetImpl_vTable.isEof := @IResultSetImpl_isEofDispatcher;
  IResultSetImpl_vTable.isBof := @IResultSetImpl_isBofDispatcher;
  IResultSetImpl_vTable.getMetadata := @IResultSetImpl_getMetadataDispatcher;
  IResultSetImpl_vTable.close := @IResultSetImpl_closeDispatcher;
  IResultSetImpl_vTable.setDelayedOutputFormat := @IResultSetImpl_setDelayedOutputFormatDispatcher;

  IStatementImpl_vTable := StatementVTable.create;
  IStatementImpl_vTable.version := 4;
  IStatementImpl_vTable.addRef := @IStatementImpl_addRefDispatcher;
  IStatementImpl_vTable.release := @IStatementImpl_releaseDispatcher;
  IStatementImpl_vTable.getInfo := @IStatementImpl_getInfoDispatcher;
  IStatementImpl_vTable.getType := @IStatementImpl_getTypeDispatcher;
  IStatementImpl_vTable.getPlan := @IStatementImpl_getPlanDispatcher;
  IStatementImpl_vTable.getAffectedRecords := @IStatementImpl_getAffectedRecordsDispatcher;
  IStatementImpl_vTable.getInputMetadata := @IStatementImpl_getInputMetadataDispatcher;
  IStatementImpl_vTable.getOutputMetadata := @IStatementImpl_getOutputMetadataDispatcher;
  IStatementImpl_vTable.execute := @IStatementImpl_executeDispatcher;
  IStatementImpl_vTable.openCursor := @IStatementImpl_openCursorDispatcher;
  IStatementImpl_vTable.setCursorName := @IStatementImpl_setCursorNameDispatcher;
  IStatementImpl_vTable.free := @IStatementImpl_freeDispatcher;
  IStatementImpl_vTable.getFlags := @IStatementImpl_getFlagsDispatcher;
  IStatementImpl_vTable.getTimeout := @IStatementImpl_getTimeoutDispatcher;
  IStatementImpl_vTable.setTimeout := @IStatementImpl_setTimeoutDispatcher;
  IStatementImpl_vTable.createBatch := @IStatementImpl_createBatchDispatcher;

  IBatchImpl_vTable := BatchVTable.create;
  IBatchImpl_vTable.version := 3;
  IBatchImpl_vTable.addRef := @IBatchImpl_addRefDispatcher;
  IBatchImpl_vTable.release := @IBatchImpl_releaseDispatcher;
  IBatchImpl_vTable.add := @IBatchImpl_addDispatcher;
  IBatchImpl_vTable.addBlob := @IBatchImpl_addBlobDispatcher;
  IBatchImpl_vTable.appendBlobData := @IBatchImpl_appendBlobDataDispatcher;
  IBatchImpl_vTable.addBlobStream := @IBatchImpl_addBlobStreamDispatcher;
  IBatchImpl_vTable.registerBlob := @IBatchImpl_registerBlobDispatcher;
  IBatchImpl_vTable.execute := @IBatchImpl_executeDispatcher;
  IBatchImpl_vTable.cancel := @IBatchImpl_cancelDispatcher;
  IBatchImpl_vTable.getBlobAlignment := @IBatchImpl_getBlobAlignmentDispatcher;
  IBatchImpl_vTable.getMetadata := @IBatchImpl_getMetadataDispatcher;
  IBatchImpl_vTable.setDefaultBpb := @IBatchImpl_setDefaultBpbDispatcher;

  IBatchCompletionStateImpl_vTable := BatchCompletionStateVTable.create;
  IBatchCompletionStateImpl_vTable.version := 3;
  IBatchCompletionStateImpl_vTable.dispose := @IBatchCompletionStateImpl_disposeDispatcher;
  IBatchCompletionStateImpl_vTable.getSize := @IBatchCompletionStateImpl_getSizeDispatcher;
  IBatchCompletionStateImpl_vTable.getState := @IBatchCompletionStateImpl_getStateDispatcher;
  IBatchCompletionStateImpl_vTable.findError := @IBatchCompletionStateImpl_findErrorDispatcher;
  IBatchCompletionStateImpl_vTable.getStatus := @IBatchCompletionStateImpl_getStatusDispatcher;

  IReplicatorImpl_vTable := ReplicatorVTable.create;
  IReplicatorImpl_vTable.version := 3;
  IReplicatorImpl_vTable.addRef := @IReplicatorImpl_addRefDispatcher;
  IReplicatorImpl_vTable.release := @IReplicatorImpl_releaseDispatcher;
  IReplicatorImpl_vTable.process := @IReplicatorImpl_processDispatcher;
  IReplicatorImpl_vTable.close := @IReplicatorImpl_closeDispatcher;

  IRequestImpl_vTable := RequestVTable.create;
  IRequestImpl_vTable.version := 3;
  IRequestImpl_vTable.addRef := @IRequestImpl_addRefDispatcher;
  IRequestImpl_vTable.release := @IRequestImpl_releaseDispatcher;
  IRequestImpl_vTable.receive := @IRequestImpl_receiveDispatcher;
  IRequestImpl_vTable.send := @IRequestImpl_sendDispatcher;
  IRequestImpl_vTable.getInfo := @IRequestImpl_getInfoDispatcher;
  IRequestImpl_vTable.start := @IRequestImpl_startDispatcher;
  IRequestImpl_vTable.startAndSend := @IRequestImpl_startAndSendDispatcher;
  IRequestImpl_vTable.unwind := @IRequestImpl_unwindDispatcher;
  IRequestImpl_vTable.free := @IRequestImpl_freeDispatcher;

  IEventsImpl_vTable := EventsVTable.create;
  IEventsImpl_vTable.version := 3;
  IEventsImpl_vTable.addRef := @IEventsImpl_addRefDispatcher;
  IEventsImpl_vTable.release := @IEventsImpl_releaseDispatcher;
  IEventsImpl_vTable.cancel := @IEventsImpl_cancelDispatcher;

  IAttachmentImpl_vTable := AttachmentVTable.create;
  IAttachmentImpl_vTable.version := 4;
  IAttachmentImpl_vTable.addRef := @IAttachmentImpl_addRefDispatcher;
  IAttachmentImpl_vTable.release := @IAttachmentImpl_releaseDispatcher;
  IAttachmentImpl_vTable.getInfo := @IAttachmentImpl_getInfoDispatcher;
  IAttachmentImpl_vTable.startTransaction := @IAttachmentImpl_startTransactionDispatcher;
  IAttachmentImpl_vTable.reconnectTransaction := @IAttachmentImpl_reconnectTransactionDispatcher;
  IAttachmentImpl_vTable.compileRequest := @IAttachmentImpl_compileRequestDispatcher;
  IAttachmentImpl_vTable.transactRequest := @IAttachmentImpl_transactRequestDispatcher;
  IAttachmentImpl_vTable.createBlob := @IAttachmentImpl_createBlobDispatcher;
  IAttachmentImpl_vTable.openBlob := @IAttachmentImpl_openBlobDispatcher;
  IAttachmentImpl_vTable.getSlice := @IAttachmentImpl_getSliceDispatcher;
  IAttachmentImpl_vTable.putSlice := @IAttachmentImpl_putSliceDispatcher;
  IAttachmentImpl_vTable.executeDyn := @IAttachmentImpl_executeDynDispatcher;
  IAttachmentImpl_vTable.prepare := @IAttachmentImpl_prepareDispatcher;
  IAttachmentImpl_vTable.execute := @IAttachmentImpl_executeDispatcher;
  IAttachmentImpl_vTable.openCursor := @IAttachmentImpl_openCursorDispatcher;
  IAttachmentImpl_vTable.queEvents := @IAttachmentImpl_queEventsDispatcher;
  IAttachmentImpl_vTable.cancelOperation := @IAttachmentImpl_cancelOperationDispatcher;
  IAttachmentImpl_vTable.ping := @IAttachmentImpl_pingDispatcher;
  IAttachmentImpl_vTable.detach := @IAttachmentImpl_detachDispatcher;
  IAttachmentImpl_vTable.dropDatabase := @IAttachmentImpl_dropDatabaseDispatcher;
  IAttachmentImpl_vTable.getIdleTimeout := @IAttachmentImpl_getIdleTimeoutDispatcher;
  IAttachmentImpl_vTable.setIdleTimeout := @IAttachmentImpl_setIdleTimeoutDispatcher;
  IAttachmentImpl_vTable.getStatementTimeout := @IAttachmentImpl_getStatementTimeoutDispatcher;
  IAttachmentImpl_vTable.setStatementTimeout := @IAttachmentImpl_setStatementTimeoutDispatcher;
  IAttachmentImpl_vTable.createBatch := @IAttachmentImpl_createBatchDispatcher;
  IAttachmentImpl_vTable.createReplicator := @IAttachmentImpl_createReplicatorDispatcher;

  IServiceImpl_vTable := ServiceVTable.create;
  IServiceImpl_vTable.version := 3;
  IServiceImpl_vTable.addRef := @IServiceImpl_addRefDispatcher;
  IServiceImpl_vTable.release := @IServiceImpl_releaseDispatcher;
  IServiceImpl_vTable.detach := @IServiceImpl_detachDispatcher;
  IServiceImpl_vTable.query := @IServiceImpl_queryDispatcher;
  IServiceImpl_vTable.start := @IServiceImpl_startDispatcher;

  IProviderImpl_vTable := ProviderVTable.create;
  IProviderImpl_vTable.version := 4;
  IProviderImpl_vTable.addRef := @IProviderImpl_addRefDispatcher;
  IProviderImpl_vTable.release := @IProviderImpl_releaseDispatcher;
  IProviderImpl_vTable.setOwner := @IProviderImpl_setOwnerDispatcher;
  IProviderImpl_vTable.getOwner := @IProviderImpl_getOwnerDispatcher;
  IProviderImpl_vTable.attachDatabase := @IProviderImpl_attachDatabaseDispatcher;
  IProviderImpl_vTable.createDatabase := @IProviderImpl_createDatabaseDispatcher;
  IProviderImpl_vTable.attachServiceManager := @IProviderImpl_attachServiceManagerDispatcher;
  IProviderImpl_vTable.shutdown := @IProviderImpl_shutdownDispatcher;
  IProviderImpl_vTable.setDbCryptCallback := @IProviderImpl_setDbCryptCallbackDispatcher;

  IDtcStartImpl_vTable := DtcStartVTable.create;
  IDtcStartImpl_vTable.version := 3;
  IDtcStartImpl_vTable.dispose := @IDtcStartImpl_disposeDispatcher;
  IDtcStartImpl_vTable.addAttachment := @IDtcStartImpl_addAttachmentDispatcher;
  IDtcStartImpl_vTable.addWithTpb := @IDtcStartImpl_addWithTpbDispatcher;
  IDtcStartImpl_vTable.start := @IDtcStartImpl_startDispatcher;

  IDtcImpl_vTable := DtcVTable.create;
  IDtcImpl_vTable.version := 2;
  IDtcImpl_vTable.join := @IDtcImpl_joinDispatcher;
  IDtcImpl_vTable.startBuilder := @IDtcImpl_startBuilderDispatcher;

  IAuthImpl_vTable := AuthVTable.create;
  IAuthImpl_vTable.version := 4;
  IAuthImpl_vTable.addRef := @IAuthImpl_addRefDispatcher;
  IAuthImpl_vTable.release := @IAuthImpl_releaseDispatcher;
  IAuthImpl_vTable.setOwner := @IAuthImpl_setOwnerDispatcher;
  IAuthImpl_vTable.getOwner := @IAuthImpl_getOwnerDispatcher;

  IWriterImpl_vTable := WriterVTable.create;
  IWriterImpl_vTable.version := 2;
  IWriterImpl_vTable.reset := @IWriterImpl_resetDispatcher;
  IWriterImpl_vTable.add := @IWriterImpl_addDispatcher;
  IWriterImpl_vTable.setType := @IWriterImpl_setTypeDispatcher;
  IWriterImpl_vTable.setDb := @IWriterImpl_setDbDispatcher;

  IServerBlockImpl_vTable := ServerBlockVTable.create;
  IServerBlockImpl_vTable.version := 2;
  IServerBlockImpl_vTable.getLogin := @IServerBlockImpl_getLoginDispatcher;
  IServerBlockImpl_vTable.getData := @IServerBlockImpl_getDataDispatcher;
  IServerBlockImpl_vTable.putData := @IServerBlockImpl_putDataDispatcher;
  IServerBlockImpl_vTable.newKey := @IServerBlockImpl_newKeyDispatcher;

  IClientBlockImpl_vTable := ClientBlockVTable.create;
  IClientBlockImpl_vTable.version := 4;
  IClientBlockImpl_vTable.addRef := @IClientBlockImpl_addRefDispatcher;
  IClientBlockImpl_vTable.release := @IClientBlockImpl_releaseDispatcher;
  IClientBlockImpl_vTable.getLogin := @IClientBlockImpl_getLoginDispatcher;
  IClientBlockImpl_vTable.getPassword := @IClientBlockImpl_getPasswordDispatcher;
  IClientBlockImpl_vTable.getData := @IClientBlockImpl_getDataDispatcher;
  IClientBlockImpl_vTable.putData := @IClientBlockImpl_putDataDispatcher;
  IClientBlockImpl_vTable.newKey := @IClientBlockImpl_newKeyDispatcher;
  IClientBlockImpl_vTable.getAuthBlock := @IClientBlockImpl_getAuthBlockDispatcher;

  IServerImpl_vTable := ServerVTable.create;
  IServerImpl_vTable.version := 6;
  IServerImpl_vTable.addRef := @IServerImpl_addRefDispatcher;
  IServerImpl_vTable.release := @IServerImpl_releaseDispatcher;
  IServerImpl_vTable.setOwner := @IServerImpl_setOwnerDispatcher;
  IServerImpl_vTable.getOwner := @IServerImpl_getOwnerDispatcher;
  IServerImpl_vTable.authenticate := @IServerImpl_authenticateDispatcher;
  IServerImpl_vTable.setDbCryptCallback := @IServerImpl_setDbCryptCallbackDispatcher;

  IClientImpl_vTable := ClientVTable.create;
  IClientImpl_vTable.version := 5;
  IClientImpl_vTable.addRef := @IClientImpl_addRefDispatcher;
  IClientImpl_vTable.release := @IClientImpl_releaseDispatcher;
  IClientImpl_vTable.setOwner := @IClientImpl_setOwnerDispatcher;
  IClientImpl_vTable.getOwner := @IClientImpl_getOwnerDispatcher;
  IClientImpl_vTable.authenticate := @IClientImpl_authenticateDispatcher;

  IUserFieldImpl_vTable := UserFieldVTable.create;
  IUserFieldImpl_vTable.version := 2;
  IUserFieldImpl_vTable.entered := @IUserFieldImpl_enteredDispatcher;
  IUserFieldImpl_vTable.specified := @IUserFieldImpl_specifiedDispatcher;
  IUserFieldImpl_vTable.setEntered := @IUserFieldImpl_setEnteredDispatcher;

  ICharUserFieldImpl_vTable := CharUserFieldVTable.create;
  ICharUserFieldImpl_vTable.version := 3;
  ICharUserFieldImpl_vTable.entered := @ICharUserFieldImpl_enteredDispatcher;
  ICharUserFieldImpl_vTable.specified := @ICharUserFieldImpl_specifiedDispatcher;
  ICharUserFieldImpl_vTable.setEntered := @ICharUserFieldImpl_setEnteredDispatcher;
  ICharUserFieldImpl_vTable.get := @ICharUserFieldImpl_getDispatcher;
  ICharUserFieldImpl_vTable.set_ := @ICharUserFieldImpl_set_Dispatcher;

  IIntUserFieldImpl_vTable := IntUserFieldVTable.create;
  IIntUserFieldImpl_vTable.version := 3;
  IIntUserFieldImpl_vTable.entered := @IIntUserFieldImpl_enteredDispatcher;
  IIntUserFieldImpl_vTable.specified := @IIntUserFieldImpl_specifiedDispatcher;
  IIntUserFieldImpl_vTable.setEntered := @IIntUserFieldImpl_setEnteredDispatcher;
  IIntUserFieldImpl_vTable.get := @IIntUserFieldImpl_getDispatcher;
  IIntUserFieldImpl_vTable.set_ := @IIntUserFieldImpl_set_Dispatcher;

  IUserImpl_vTable := UserVTable.create;
  IUserImpl_vTable.version := 2;
  IUserImpl_vTable.operation := @IUserImpl_operationDispatcher;
  IUserImpl_vTable.userName := @IUserImpl_userNameDispatcher;
  IUserImpl_vTable.password := @IUserImpl_passwordDispatcher;
  IUserImpl_vTable.firstName := @IUserImpl_firstNameDispatcher;
  IUserImpl_vTable.lastName := @IUserImpl_lastNameDispatcher;
  IUserImpl_vTable.middleName := @IUserImpl_middleNameDispatcher;
  IUserImpl_vTable.comment := @IUserImpl_commentDispatcher;
  IUserImpl_vTable.attributes := @IUserImpl_attributesDispatcher;
  IUserImpl_vTable.active := @IUserImpl_activeDispatcher;
  IUserImpl_vTable.admin := @IUserImpl_adminDispatcher;
  IUserImpl_vTable.clear := @IUserImpl_clearDispatcher;

  IListUsersImpl_vTable := ListUsersVTable.create;
  IListUsersImpl_vTable.version := 2;
  IListUsersImpl_vTable.list := @IListUsersImpl_listDispatcher;

  ILogonInfoImpl_vTable := LogonInfoVTable.create;
  ILogonInfoImpl_vTable.version := 3;
  ILogonInfoImpl_vTable.name := @ILogonInfoImpl_nameDispatcher;
  ILogonInfoImpl_vTable.role := @ILogonInfoImpl_roleDispatcher;
  ILogonInfoImpl_vTable.networkProtocol := @ILogonInfoImpl_networkProtocolDispatcher;
  ILogonInfoImpl_vTable.remoteAddress := @ILogonInfoImpl_remoteAddressDispatcher;
  ILogonInfoImpl_vTable.authBlock := @ILogonInfoImpl_authBlockDispatcher;
  ILogonInfoImpl_vTable.attachment := @ILogonInfoImpl_attachmentDispatcher;
  ILogonInfoImpl_vTable.transaction := @ILogonInfoImpl_transactionDispatcher;

  IManagementImpl_vTable := ManagementVTable.create;
  IManagementImpl_vTable.version := 4;
  IManagementImpl_vTable.addRef := @IManagementImpl_addRefDispatcher;
  IManagementImpl_vTable.release := @IManagementImpl_releaseDispatcher;
  IManagementImpl_vTable.setOwner := @IManagementImpl_setOwnerDispatcher;
  IManagementImpl_vTable.getOwner := @IManagementImpl_getOwnerDispatcher;
  IManagementImpl_vTable.start := @IManagementImpl_startDispatcher;
  IManagementImpl_vTable.execute := @IManagementImpl_executeDispatcher;
  IManagementImpl_vTable.commit := @IManagementImpl_commitDispatcher;
  IManagementImpl_vTable.rollback := @IManagementImpl_rollbackDispatcher;

  IAuthBlockImpl_vTable := AuthBlockVTable.create;
  IAuthBlockImpl_vTable.version := 3;
  IAuthBlockImpl_vTable.getType := @IAuthBlockImpl_getTypeDispatcher;
  IAuthBlockImpl_vTable.getName := @IAuthBlockImpl_getNameDispatcher;
  IAuthBlockImpl_vTable.getPlugin := @IAuthBlockImpl_getPluginDispatcher;
  IAuthBlockImpl_vTable.getSecurityDb := @IAuthBlockImpl_getSecurityDbDispatcher;
  IAuthBlockImpl_vTable.getOriginalPlugin := @IAuthBlockImpl_getOriginalPluginDispatcher;
  IAuthBlockImpl_vTable.next := @IAuthBlockImpl_nextDispatcher;
  IAuthBlockImpl_vTable.first := @IAuthBlockImpl_firstDispatcher;

  IWireCryptPluginImpl_vTable := WireCryptPluginVTable.create;
  IWireCryptPluginImpl_vTable.version := 5;
  IWireCryptPluginImpl_vTable.addRef := @IWireCryptPluginImpl_addRefDispatcher;
  IWireCryptPluginImpl_vTable.release := @IWireCryptPluginImpl_releaseDispatcher;
  IWireCryptPluginImpl_vTable.setOwner := @IWireCryptPluginImpl_setOwnerDispatcher;
  IWireCryptPluginImpl_vTable.getOwner := @IWireCryptPluginImpl_getOwnerDispatcher;
  IWireCryptPluginImpl_vTable.getKnownTypes := @IWireCryptPluginImpl_getKnownTypesDispatcher;
  IWireCryptPluginImpl_vTable.setKey := @IWireCryptPluginImpl_setKeyDispatcher;
  IWireCryptPluginImpl_vTable.encrypt := @IWireCryptPluginImpl_encryptDispatcher;
  IWireCryptPluginImpl_vTable.decrypt := @IWireCryptPluginImpl_decryptDispatcher;
  IWireCryptPluginImpl_vTable.getSpecificData := @IWireCryptPluginImpl_getSpecificDataDispatcher;
  IWireCryptPluginImpl_vTable.setSpecificData := @IWireCryptPluginImpl_setSpecificDataDispatcher;

  ICryptKeyCallbackImpl_vTable := CryptKeyCallbackVTable.create;
  ICryptKeyCallbackImpl_vTable.version := 2;
  ICryptKeyCallbackImpl_vTable.callback := @ICryptKeyCallbackImpl_callbackDispatcher;

  IKeyHolderPluginImpl_vTable := KeyHolderPluginVTable.create;
  IKeyHolderPluginImpl_vTable.version := 5;
  IKeyHolderPluginImpl_vTable.addRef := @IKeyHolderPluginImpl_addRefDispatcher;
  IKeyHolderPluginImpl_vTable.release := @IKeyHolderPluginImpl_releaseDispatcher;
  IKeyHolderPluginImpl_vTable.setOwner := @IKeyHolderPluginImpl_setOwnerDispatcher;
  IKeyHolderPluginImpl_vTable.getOwner := @IKeyHolderPluginImpl_getOwnerDispatcher;
  IKeyHolderPluginImpl_vTable.keyCallback := @IKeyHolderPluginImpl_keyCallbackDispatcher;
  IKeyHolderPluginImpl_vTable.keyHandle := @IKeyHolderPluginImpl_keyHandleDispatcher;
  IKeyHolderPluginImpl_vTable.useOnlyOwnKeys := @IKeyHolderPluginImpl_useOnlyOwnKeysDispatcher;
  IKeyHolderPluginImpl_vTable.chainHandle := @IKeyHolderPluginImpl_chainHandleDispatcher;

  IDbCryptInfoImpl_vTable := DbCryptInfoVTable.create;
  IDbCryptInfoImpl_vTable.version := 3;
  IDbCryptInfoImpl_vTable.addRef := @IDbCryptInfoImpl_addRefDispatcher;
  IDbCryptInfoImpl_vTable.release := @IDbCryptInfoImpl_releaseDispatcher;
  IDbCryptInfoImpl_vTable.getDatabaseFullPath := @IDbCryptInfoImpl_getDatabaseFullPathDispatcher;

  IDbCryptPluginImpl_vTable := DbCryptPluginVTable.create;
  IDbCryptPluginImpl_vTable.version := 5;
  IDbCryptPluginImpl_vTable.addRef := @IDbCryptPluginImpl_addRefDispatcher;
  IDbCryptPluginImpl_vTable.release := @IDbCryptPluginImpl_releaseDispatcher;
  IDbCryptPluginImpl_vTable.setOwner := @IDbCryptPluginImpl_setOwnerDispatcher;
  IDbCryptPluginImpl_vTable.getOwner := @IDbCryptPluginImpl_getOwnerDispatcher;
  IDbCryptPluginImpl_vTable.setKey := @IDbCryptPluginImpl_setKeyDispatcher;
  IDbCryptPluginImpl_vTable.encrypt := @IDbCryptPluginImpl_encryptDispatcher;
  IDbCryptPluginImpl_vTable.decrypt := @IDbCryptPluginImpl_decryptDispatcher;
  IDbCryptPluginImpl_vTable.setInfo := @IDbCryptPluginImpl_setInfoDispatcher;

  IExternalContextImpl_vTable := ExternalContextVTable.create;
  IExternalContextImpl_vTable.version := 2;
  IExternalContextImpl_vTable.getMaster := @IExternalContextImpl_getMasterDispatcher;
  IExternalContextImpl_vTable.getEngine := @IExternalContextImpl_getEngineDispatcher;
  IExternalContextImpl_vTable.getAttachment := @IExternalContextImpl_getAttachmentDispatcher;
  IExternalContextImpl_vTable.getTransaction := @IExternalContextImpl_getTransactionDispatcher;
  IExternalContextImpl_vTable.getUserName := @IExternalContextImpl_getUserNameDispatcher;
  IExternalContextImpl_vTable.getDatabaseName := @IExternalContextImpl_getDatabaseNameDispatcher;
  IExternalContextImpl_vTable.getClientCharSet := @IExternalContextImpl_getClientCharSetDispatcher;
  IExternalContextImpl_vTable.obtainInfoCode := @IExternalContextImpl_obtainInfoCodeDispatcher;
  IExternalContextImpl_vTable.getInfo := @IExternalContextImpl_getInfoDispatcher;
  IExternalContextImpl_vTable.setInfo := @IExternalContextImpl_setInfoDispatcher;

  IExternalResultSetImpl_vTable := ExternalResultSetVTable.create;
  IExternalResultSetImpl_vTable.version := 3;
  IExternalResultSetImpl_vTable.dispose := @IExternalResultSetImpl_disposeDispatcher;
  IExternalResultSetImpl_vTable.fetch := @IExternalResultSetImpl_fetchDispatcher;

  IExternalFunctionImpl_vTable := ExternalFunctionVTable.create;
  IExternalFunctionImpl_vTable.version := 3;
  IExternalFunctionImpl_vTable.dispose := @IExternalFunctionImpl_disposeDispatcher;
  IExternalFunctionImpl_vTable.getCharSet := @IExternalFunctionImpl_getCharSetDispatcher;
  IExternalFunctionImpl_vTable.execute := @IExternalFunctionImpl_executeDispatcher;

  IExternalProcedureImpl_vTable := ExternalProcedureVTable.create;
  IExternalProcedureImpl_vTable.version := 3;
  IExternalProcedureImpl_vTable.dispose := @IExternalProcedureImpl_disposeDispatcher;
  IExternalProcedureImpl_vTable.getCharSet := @IExternalProcedureImpl_getCharSetDispatcher;
  IExternalProcedureImpl_vTable.open := @IExternalProcedureImpl_openDispatcher;

  IExternalTriggerImpl_vTable := ExternalTriggerVTable.create;
  IExternalTriggerImpl_vTable.version := 3;
  IExternalTriggerImpl_vTable.dispose := @IExternalTriggerImpl_disposeDispatcher;
  IExternalTriggerImpl_vTable.getCharSet := @IExternalTriggerImpl_getCharSetDispatcher;
  IExternalTriggerImpl_vTable.execute := @IExternalTriggerImpl_executeDispatcher;

  IRoutineMetadataImpl_vTable := RoutineMetadataVTable.create;
  IRoutineMetadataImpl_vTable.version := 2;
  IRoutineMetadataImpl_vTable.getPackage := @IRoutineMetadataImpl_getPackageDispatcher;
  IRoutineMetadataImpl_vTable.getName := @IRoutineMetadataImpl_getNameDispatcher;
  IRoutineMetadataImpl_vTable.getEntryPoint := @IRoutineMetadataImpl_getEntryPointDispatcher;
  IRoutineMetadataImpl_vTable.getBody := @IRoutineMetadataImpl_getBodyDispatcher;
  IRoutineMetadataImpl_vTable.getInputMetadata := @IRoutineMetadataImpl_getInputMetadataDispatcher;
  IRoutineMetadataImpl_vTable.getOutputMetadata := @IRoutineMetadataImpl_getOutputMetadataDispatcher;
  IRoutineMetadataImpl_vTable.getTriggerMetadata := @IRoutineMetadataImpl_getTriggerMetadataDispatcher;
  IRoutineMetadataImpl_vTable.getTriggerTable := @IRoutineMetadataImpl_getTriggerTableDispatcher;
  IRoutineMetadataImpl_vTable.getTriggerType := @IRoutineMetadataImpl_getTriggerTypeDispatcher;

  IExternalEngineImpl_vTable := ExternalEngineVTable.create;
  IExternalEngineImpl_vTable.version := 4;
  IExternalEngineImpl_vTable.addRef := @IExternalEngineImpl_addRefDispatcher;
  IExternalEngineImpl_vTable.release := @IExternalEngineImpl_releaseDispatcher;
  IExternalEngineImpl_vTable.setOwner := @IExternalEngineImpl_setOwnerDispatcher;
  IExternalEngineImpl_vTable.getOwner := @IExternalEngineImpl_getOwnerDispatcher;
  IExternalEngineImpl_vTable.open := @IExternalEngineImpl_openDispatcher;
  IExternalEngineImpl_vTable.openAttachment := @IExternalEngineImpl_openAttachmentDispatcher;
  IExternalEngineImpl_vTable.closeAttachment := @IExternalEngineImpl_closeAttachmentDispatcher;
  IExternalEngineImpl_vTable.makeFunction := @IExternalEngineImpl_makeFunctionDispatcher;
  IExternalEngineImpl_vTable.makeProcedure := @IExternalEngineImpl_makeProcedureDispatcher;
  IExternalEngineImpl_vTable.makeTrigger := @IExternalEngineImpl_makeTriggerDispatcher;

  ITimerImpl_vTable := TimerVTable.create;
  ITimerImpl_vTable.version := 3;
  ITimerImpl_vTable.addRef := @ITimerImpl_addRefDispatcher;
  ITimerImpl_vTable.release := @ITimerImpl_releaseDispatcher;
  ITimerImpl_vTable.handler := @ITimerImpl_handlerDispatcher;

  ITimerControlImpl_vTable := TimerControlVTable.create;
  ITimerControlImpl_vTable.version := 2;
  ITimerControlImpl_vTable.start := @ITimerControlImpl_startDispatcher;
  ITimerControlImpl_vTable.stop := @ITimerControlImpl_stopDispatcher;

  IVersionCallbackImpl_vTable := VersionCallbackVTable.create;
  IVersionCallbackImpl_vTable.version := 2;
  IVersionCallbackImpl_vTable.callback := @IVersionCallbackImpl_callbackDispatcher;

  IUtilImpl_vTable := UtilVTable.create;
  IUtilImpl_vTable.version := 4;
  IUtilImpl_vTable.getFbVersion := @IUtilImpl_getFbVersionDispatcher;
  IUtilImpl_vTable.loadBlob := @IUtilImpl_loadBlobDispatcher;
  IUtilImpl_vTable.dumpBlob := @IUtilImpl_dumpBlobDispatcher;
  IUtilImpl_vTable.getPerfCounters := @IUtilImpl_getPerfCountersDispatcher;
  IUtilImpl_vTable.executeCreateDatabase := @IUtilImpl_executeCreateDatabaseDispatcher;
  IUtilImpl_vTable.decodeDate := @IUtilImpl_decodeDateDispatcher;
  IUtilImpl_vTable.decodeTime := @IUtilImpl_decodeTimeDispatcher;
  IUtilImpl_vTable.encodeDate := @IUtilImpl_encodeDateDispatcher;
  IUtilImpl_vTable.encodeTime := @IUtilImpl_encodeTimeDispatcher;
  IUtilImpl_vTable.formatStatus := @IUtilImpl_formatStatusDispatcher;
  IUtilImpl_vTable.getClientVersion := @IUtilImpl_getClientVersionDispatcher;
  IUtilImpl_vTable.getXpbBuilder := @IUtilImpl_getXpbBuilderDispatcher;
  IUtilImpl_vTable.setOffsets := @IUtilImpl_setOffsetsDispatcher;
  IUtilImpl_vTable.getDecFloat16 := @IUtilImpl_getDecFloat16Dispatcher;
  IUtilImpl_vTable.getDecFloat34 := @IUtilImpl_getDecFloat34Dispatcher;
  IUtilImpl_vTable.decodeTimeTz := @IUtilImpl_decodeTimeTzDispatcher;
  IUtilImpl_vTable.decodeTimeStampTz := @IUtilImpl_decodeTimeStampTzDispatcher;
  IUtilImpl_vTable.encodeTimeTz := @IUtilImpl_encodeTimeTzDispatcher;
  IUtilImpl_vTable.encodeTimeStampTz := @IUtilImpl_encodeTimeStampTzDispatcher;
  IUtilImpl_vTable.getInt128 := @IUtilImpl_getInt128Dispatcher;
  IUtilImpl_vTable.decodeTimeTzEx := @IUtilImpl_decodeTimeTzExDispatcher;
  IUtilImpl_vTable.decodeTimeStampTzEx := @IUtilImpl_decodeTimeStampTzExDispatcher;

  IOffsetsCallbackImpl_vTable := OffsetsCallbackVTable.create;
  IOffsetsCallbackImpl_vTable.version := 2;
  IOffsetsCallbackImpl_vTable.setOffset := @IOffsetsCallbackImpl_setOffsetDispatcher;

  IXpbBuilderImpl_vTable := XpbBuilderVTable.create;
  IXpbBuilderImpl_vTable.version := 3;
  IXpbBuilderImpl_vTable.dispose := @IXpbBuilderImpl_disposeDispatcher;
  IXpbBuilderImpl_vTable.clear := @IXpbBuilderImpl_clearDispatcher;
  IXpbBuilderImpl_vTable.removeCurrent := @IXpbBuilderImpl_removeCurrentDispatcher;
  IXpbBuilderImpl_vTable.insertInt := @IXpbBuilderImpl_insertIntDispatcher;
  IXpbBuilderImpl_vTable.insertBigInt := @IXpbBuilderImpl_insertBigIntDispatcher;
  IXpbBuilderImpl_vTable.insertBytes := @IXpbBuilderImpl_insertBytesDispatcher;
  IXpbBuilderImpl_vTable.insertString := @IXpbBuilderImpl_insertStringDispatcher;
  IXpbBuilderImpl_vTable.insertTag := @IXpbBuilderImpl_insertTagDispatcher;
  IXpbBuilderImpl_vTable.isEof := @IXpbBuilderImpl_isEofDispatcher;
  IXpbBuilderImpl_vTable.moveNext := @IXpbBuilderImpl_moveNextDispatcher;
  IXpbBuilderImpl_vTable.rewind := @IXpbBuilderImpl_rewindDispatcher;
  IXpbBuilderImpl_vTable.findFirst := @IXpbBuilderImpl_findFirstDispatcher;
  IXpbBuilderImpl_vTable.findNext := @IXpbBuilderImpl_findNextDispatcher;
  IXpbBuilderImpl_vTable.getTag := @IXpbBuilderImpl_getTagDispatcher;
  IXpbBuilderImpl_vTable.getLength := @IXpbBuilderImpl_getLengthDispatcher;
  IXpbBuilderImpl_vTable.getInt := @IXpbBuilderImpl_getIntDispatcher;
  IXpbBuilderImpl_vTable.getBigInt := @IXpbBuilderImpl_getBigIntDispatcher;
  IXpbBuilderImpl_vTable.getString := @IXpbBuilderImpl_getStringDispatcher;
  IXpbBuilderImpl_vTable.getBytes := @IXpbBuilderImpl_getBytesDispatcher;
  IXpbBuilderImpl_vTable.getBufferLength := @IXpbBuilderImpl_getBufferLengthDispatcher;
  IXpbBuilderImpl_vTable.getBuffer := @IXpbBuilderImpl_getBufferDispatcher;

  ITraceConnectionImpl_vTable := TraceConnectionVTable.create;
  ITraceConnectionImpl_vTable.version := 2;
  ITraceConnectionImpl_vTable.getKind := @ITraceConnectionImpl_getKindDispatcher;
  ITraceConnectionImpl_vTable.getProcessID := @ITraceConnectionImpl_getProcessIDDispatcher;
  ITraceConnectionImpl_vTable.getUserName := @ITraceConnectionImpl_getUserNameDispatcher;
  ITraceConnectionImpl_vTable.getRoleName := @ITraceConnectionImpl_getRoleNameDispatcher;
  ITraceConnectionImpl_vTable.getCharSet := @ITraceConnectionImpl_getCharSetDispatcher;
  ITraceConnectionImpl_vTable.getRemoteProtocol := @ITraceConnectionImpl_getRemoteProtocolDispatcher;
  ITraceConnectionImpl_vTable.getRemoteAddress := @ITraceConnectionImpl_getRemoteAddressDispatcher;
  ITraceConnectionImpl_vTable.getRemoteProcessID := @ITraceConnectionImpl_getRemoteProcessIDDispatcher;
  ITraceConnectionImpl_vTable.getRemoteProcessName := @ITraceConnectionImpl_getRemoteProcessNameDispatcher;

  ITraceDatabaseConnectionImpl_vTable := TraceDatabaseConnectionVTable.create;
  ITraceDatabaseConnectionImpl_vTable.version := 3;
  ITraceDatabaseConnectionImpl_vTable.getKind := @ITraceDatabaseConnectionImpl_getKindDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getProcessID := @ITraceDatabaseConnectionImpl_getProcessIDDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getUserName := @ITraceDatabaseConnectionImpl_getUserNameDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getRoleName := @ITraceDatabaseConnectionImpl_getRoleNameDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getCharSet := @ITraceDatabaseConnectionImpl_getCharSetDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getRemoteProtocol := @ITraceDatabaseConnectionImpl_getRemoteProtocolDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getRemoteAddress := @ITraceDatabaseConnectionImpl_getRemoteAddressDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getRemoteProcessID := @ITraceDatabaseConnectionImpl_getRemoteProcessIDDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getRemoteProcessName := @ITraceDatabaseConnectionImpl_getRemoteProcessNameDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getConnectionID := @ITraceDatabaseConnectionImpl_getConnectionIDDispatcher;
  ITraceDatabaseConnectionImpl_vTable.getDatabaseName := @ITraceDatabaseConnectionImpl_getDatabaseNameDispatcher;

  ITraceTransactionImpl_vTable := TraceTransactionVTable.create;
  ITraceTransactionImpl_vTable.version := 3;
  ITraceTransactionImpl_vTable.getTransactionID := @ITraceTransactionImpl_getTransactionIDDispatcher;
  ITraceTransactionImpl_vTable.getReadOnly := @ITraceTransactionImpl_getReadOnlyDispatcher;
  ITraceTransactionImpl_vTable.getWait := @ITraceTransactionImpl_getWaitDispatcher;
  ITraceTransactionImpl_vTable.getIsolation := @ITraceTransactionImpl_getIsolationDispatcher;
  ITraceTransactionImpl_vTable.getPerf := @ITraceTransactionImpl_getPerfDispatcher;
  ITraceTransactionImpl_vTable.getInitialID := @ITraceTransactionImpl_getInitialIDDispatcher;
  ITraceTransactionImpl_vTable.getPreviousID := @ITraceTransactionImpl_getPreviousIDDispatcher;

  ITraceParamsImpl_vTable := TraceParamsVTable.create;
  ITraceParamsImpl_vTable.version := 3;
  ITraceParamsImpl_vTable.getCount := @ITraceParamsImpl_getCountDispatcher;
  ITraceParamsImpl_vTable.getParam := @ITraceParamsImpl_getParamDispatcher;
  ITraceParamsImpl_vTable.getTextUTF8 := @ITraceParamsImpl_getTextUTF8Dispatcher;

  ITraceStatementImpl_vTable := TraceStatementVTable.create;
  ITraceStatementImpl_vTable.version := 2;
  ITraceStatementImpl_vTable.getStmtID := @ITraceStatementImpl_getStmtIDDispatcher;
  ITraceStatementImpl_vTable.getPerf := @ITraceStatementImpl_getPerfDispatcher;

  ITraceSQLStatementImpl_vTable := TraceSQLStatementVTable.create;
  ITraceSQLStatementImpl_vTable.version := 3;
  ITraceSQLStatementImpl_vTable.getStmtID := @ITraceSQLStatementImpl_getStmtIDDispatcher;
  ITraceSQLStatementImpl_vTable.getPerf := @ITraceSQLStatementImpl_getPerfDispatcher;
  ITraceSQLStatementImpl_vTable.getText := @ITraceSQLStatementImpl_getTextDispatcher;
  ITraceSQLStatementImpl_vTable.getPlan := @ITraceSQLStatementImpl_getPlanDispatcher;
  ITraceSQLStatementImpl_vTable.getInputs := @ITraceSQLStatementImpl_getInputsDispatcher;
  ITraceSQLStatementImpl_vTable.getTextUTF8 := @ITraceSQLStatementImpl_getTextUTF8Dispatcher;
  ITraceSQLStatementImpl_vTable.getExplainedPlan := @ITraceSQLStatementImpl_getExplainedPlanDispatcher;

  ITraceBLRStatementImpl_vTable := TraceBLRStatementVTable.create;
  ITraceBLRStatementImpl_vTable.version := 3;
  ITraceBLRStatementImpl_vTable.getStmtID := @ITraceBLRStatementImpl_getStmtIDDispatcher;
  ITraceBLRStatementImpl_vTable.getPerf := @ITraceBLRStatementImpl_getPerfDispatcher;
  ITraceBLRStatementImpl_vTable.getData := @ITraceBLRStatementImpl_getDataDispatcher;
  ITraceBLRStatementImpl_vTable.getDataLength := @ITraceBLRStatementImpl_getDataLengthDispatcher;
  ITraceBLRStatementImpl_vTable.getText := @ITraceBLRStatementImpl_getTextDispatcher;

  ITraceDYNRequestImpl_vTable := TraceDYNRequestVTable.create;
  ITraceDYNRequestImpl_vTable.version := 2;
  ITraceDYNRequestImpl_vTable.getData := @ITraceDYNRequestImpl_getDataDispatcher;
  ITraceDYNRequestImpl_vTable.getDataLength := @ITraceDYNRequestImpl_getDataLengthDispatcher;
  ITraceDYNRequestImpl_vTable.getText := @ITraceDYNRequestImpl_getTextDispatcher;

  ITraceContextVariableImpl_vTable := TraceContextVariableVTable.create;
  ITraceContextVariableImpl_vTable.version := 2;
  ITraceContextVariableImpl_vTable.getNameSpace := @ITraceContextVariableImpl_getNameSpaceDispatcher;
  ITraceContextVariableImpl_vTable.getVarName := @ITraceContextVariableImpl_getVarNameDispatcher;
  ITraceContextVariableImpl_vTable.getVarValue := @ITraceContextVariableImpl_getVarValueDispatcher;

  ITraceProcedureImpl_vTable := TraceProcedureVTable.create;
  ITraceProcedureImpl_vTable.version := 2;
  ITraceProcedureImpl_vTable.getProcName := @ITraceProcedureImpl_getProcNameDispatcher;
  ITraceProcedureImpl_vTable.getInputs := @ITraceProcedureImpl_getInputsDispatcher;
  ITraceProcedureImpl_vTable.getPerf := @ITraceProcedureImpl_getPerfDispatcher;

  ITraceFunctionImpl_vTable := TraceFunctionVTable.create;
  ITraceFunctionImpl_vTable.version := 2;
  ITraceFunctionImpl_vTable.getFuncName := @ITraceFunctionImpl_getFuncNameDispatcher;
  ITraceFunctionImpl_vTable.getInputs := @ITraceFunctionImpl_getInputsDispatcher;
  ITraceFunctionImpl_vTable.getResult := @ITraceFunctionImpl_getResultDispatcher;
  ITraceFunctionImpl_vTable.getPerf := @ITraceFunctionImpl_getPerfDispatcher;

  ITraceTriggerImpl_vTable := TraceTriggerVTable.create;
  ITraceTriggerImpl_vTable.version := 2;
  ITraceTriggerImpl_vTable.getTriggerName := @ITraceTriggerImpl_getTriggerNameDispatcher;
  ITraceTriggerImpl_vTable.getRelationName := @ITraceTriggerImpl_getRelationNameDispatcher;
  ITraceTriggerImpl_vTable.getAction := @ITraceTriggerImpl_getActionDispatcher;
  ITraceTriggerImpl_vTable.getWhich := @ITraceTriggerImpl_getWhichDispatcher;
  ITraceTriggerImpl_vTable.getPerf := @ITraceTriggerImpl_getPerfDispatcher;

  ITraceServiceConnectionImpl_vTable := TraceServiceConnectionVTable.create;
  ITraceServiceConnectionImpl_vTable.version := 3;
  ITraceServiceConnectionImpl_vTable.getKind := @ITraceServiceConnectionImpl_getKindDispatcher;
  ITraceServiceConnectionImpl_vTable.getProcessID := @ITraceServiceConnectionImpl_getProcessIDDispatcher;
  ITraceServiceConnectionImpl_vTable.getUserName := @ITraceServiceConnectionImpl_getUserNameDispatcher;
  ITraceServiceConnectionImpl_vTable.getRoleName := @ITraceServiceConnectionImpl_getRoleNameDispatcher;
  ITraceServiceConnectionImpl_vTable.getCharSet := @ITraceServiceConnectionImpl_getCharSetDispatcher;
  ITraceServiceConnectionImpl_vTable.getRemoteProtocol := @ITraceServiceConnectionImpl_getRemoteProtocolDispatcher;
  ITraceServiceConnectionImpl_vTable.getRemoteAddress := @ITraceServiceConnectionImpl_getRemoteAddressDispatcher;
  ITraceServiceConnectionImpl_vTable.getRemoteProcessID := @ITraceServiceConnectionImpl_getRemoteProcessIDDispatcher;
  ITraceServiceConnectionImpl_vTable.getRemoteProcessName := @ITraceServiceConnectionImpl_getRemoteProcessNameDispatcher;
  ITraceServiceConnectionImpl_vTable.getServiceID := @ITraceServiceConnectionImpl_getServiceIDDispatcher;
  ITraceServiceConnectionImpl_vTable.getServiceMgr := @ITraceServiceConnectionImpl_getServiceMgrDispatcher;
  ITraceServiceConnectionImpl_vTable.getServiceName := @ITraceServiceConnectionImpl_getServiceNameDispatcher;

  ITraceStatusVectorImpl_vTable := TraceStatusVectorVTable.create;
  ITraceStatusVectorImpl_vTable.version := 2;
  ITraceStatusVectorImpl_vTable.hasError := @ITraceStatusVectorImpl_hasErrorDispatcher;
  ITraceStatusVectorImpl_vTable.hasWarning := @ITraceStatusVectorImpl_hasWarningDispatcher;
  ITraceStatusVectorImpl_vTable.getStatus := @ITraceStatusVectorImpl_getStatusDispatcher;
  ITraceStatusVectorImpl_vTable.getText := @ITraceStatusVectorImpl_getTextDispatcher;

  ITraceSweepInfoImpl_vTable := TraceSweepInfoVTable.create;
  ITraceSweepInfoImpl_vTable.version := 2;
  ITraceSweepInfoImpl_vTable.getOIT := @ITraceSweepInfoImpl_getOITDispatcher;
  ITraceSweepInfoImpl_vTable.getOST := @ITraceSweepInfoImpl_getOSTDispatcher;
  ITraceSweepInfoImpl_vTable.getOAT := @ITraceSweepInfoImpl_getOATDispatcher;
  ITraceSweepInfoImpl_vTable.getNext := @ITraceSweepInfoImpl_getNextDispatcher;
  ITraceSweepInfoImpl_vTable.getPerf := @ITraceSweepInfoImpl_getPerfDispatcher;

  ITraceLogWriterImpl_vTable := TraceLogWriterVTable.create;
  ITraceLogWriterImpl_vTable.version := 4;
  ITraceLogWriterImpl_vTable.addRef := @ITraceLogWriterImpl_addRefDispatcher;
  ITraceLogWriterImpl_vTable.release := @ITraceLogWriterImpl_releaseDispatcher;
  ITraceLogWriterImpl_vTable.write := @ITraceLogWriterImpl_writeDispatcher;
  ITraceLogWriterImpl_vTable.write_s := @ITraceLogWriterImpl_write_sDispatcher;

  ITraceInitInfoImpl_vTable := TraceInitInfoVTable.create;
  ITraceInitInfoImpl_vTable.version := 2;
  ITraceInitInfoImpl_vTable.getConfigText := @ITraceInitInfoImpl_getConfigTextDispatcher;
  ITraceInitInfoImpl_vTable.getTraceSessionID := @ITraceInitInfoImpl_getTraceSessionIDDispatcher;
  ITraceInitInfoImpl_vTable.getTraceSessionName := @ITraceInitInfoImpl_getTraceSessionNameDispatcher;
  ITraceInitInfoImpl_vTable.getFirebirdRootDirectory := @ITraceInitInfoImpl_getFirebirdRootDirectoryDispatcher;
  ITraceInitInfoImpl_vTable.getDatabaseName := @ITraceInitInfoImpl_getDatabaseNameDispatcher;
  ITraceInitInfoImpl_vTable.getConnection := @ITraceInitInfoImpl_getConnectionDispatcher;
  ITraceInitInfoImpl_vTable.getLogWriter := @ITraceInitInfoImpl_getLogWriterDispatcher;

  ITracePluginImpl_vTable := TracePluginVTable.create;
  ITracePluginImpl_vTable.version := 3;
  ITracePluginImpl_vTable.addRef := @ITracePluginImpl_addRefDispatcher;
  ITracePluginImpl_vTable.release := @ITracePluginImpl_releaseDispatcher;
  ITracePluginImpl_vTable.trace_get_error := @ITracePluginImpl_trace_get_errorDispatcher;
  ITracePluginImpl_vTable.trace_attach := @ITracePluginImpl_trace_attachDispatcher;
  ITracePluginImpl_vTable.trace_detach := @ITracePluginImpl_trace_detachDispatcher;
  ITracePluginImpl_vTable.trace_transaction_start := @ITracePluginImpl_trace_transaction_startDispatcher;
  ITracePluginImpl_vTable.trace_transaction_end := @ITracePluginImpl_trace_transaction_endDispatcher;
  ITracePluginImpl_vTable.trace_proc_execute := @ITracePluginImpl_trace_proc_executeDispatcher;
  ITracePluginImpl_vTable.trace_trigger_execute := @ITracePluginImpl_trace_trigger_executeDispatcher;
  ITracePluginImpl_vTable.trace_set_context := @ITracePluginImpl_trace_set_contextDispatcher;
  ITracePluginImpl_vTable.trace_dsql_prepare := @ITracePluginImpl_trace_dsql_prepareDispatcher;
  ITracePluginImpl_vTable.trace_dsql_free := @ITracePluginImpl_trace_dsql_freeDispatcher;
  ITracePluginImpl_vTable.trace_dsql_execute := @ITracePluginImpl_trace_dsql_executeDispatcher;
  ITracePluginImpl_vTable.trace_blr_compile := @ITracePluginImpl_trace_blr_compileDispatcher;
  ITracePluginImpl_vTable.trace_blr_execute := @ITracePluginImpl_trace_blr_executeDispatcher;
  ITracePluginImpl_vTable.trace_dyn_execute := @ITracePluginImpl_trace_dyn_executeDispatcher;
  ITracePluginImpl_vTable.trace_service_attach := @ITracePluginImpl_trace_service_attachDispatcher;
  ITracePluginImpl_vTable.trace_service_start := @ITracePluginImpl_trace_service_startDispatcher;
  ITracePluginImpl_vTable.trace_service_query := @ITracePluginImpl_trace_service_queryDispatcher;
  ITracePluginImpl_vTable.trace_service_detach := @ITracePluginImpl_trace_service_detachDispatcher;
  ITracePluginImpl_vTable.trace_event_error := @ITracePluginImpl_trace_event_errorDispatcher;
  ITracePluginImpl_vTable.trace_event_sweep := @ITracePluginImpl_trace_event_sweepDispatcher;
  ITracePluginImpl_vTable.trace_func_execute := @ITracePluginImpl_trace_func_executeDispatcher;

  ITraceFactoryImpl_vTable := TraceFactoryVTable.create;
  ITraceFactoryImpl_vTable.version := 4;
  ITraceFactoryImpl_vTable.addRef := @ITraceFactoryImpl_addRefDispatcher;
  ITraceFactoryImpl_vTable.release := @ITraceFactoryImpl_releaseDispatcher;
  ITraceFactoryImpl_vTable.setOwner := @ITraceFactoryImpl_setOwnerDispatcher;
  ITraceFactoryImpl_vTable.getOwner := @ITraceFactoryImpl_getOwnerDispatcher;
  ITraceFactoryImpl_vTable.trace_needs := @ITraceFactoryImpl_trace_needsDispatcher;
  ITraceFactoryImpl_vTable.trace_create := @ITraceFactoryImpl_trace_createDispatcher;

  IUdrFunctionFactoryImpl_vTable := UdrFunctionFactoryVTable.create;
  IUdrFunctionFactoryImpl_vTable.version := 3;
  IUdrFunctionFactoryImpl_vTable.dispose := @IUdrFunctionFactoryImpl_disposeDispatcher;
  IUdrFunctionFactoryImpl_vTable.setup := @IUdrFunctionFactoryImpl_setupDispatcher;
  IUdrFunctionFactoryImpl_vTable.newItem := @IUdrFunctionFactoryImpl_newItemDispatcher;

  IUdrProcedureFactoryImpl_vTable := UdrProcedureFactoryVTable.create;
  IUdrProcedureFactoryImpl_vTable.version := 3;
  IUdrProcedureFactoryImpl_vTable.dispose := @IUdrProcedureFactoryImpl_disposeDispatcher;
  IUdrProcedureFactoryImpl_vTable.setup := @IUdrProcedureFactoryImpl_setupDispatcher;
  IUdrProcedureFactoryImpl_vTable.newItem := @IUdrProcedureFactoryImpl_newItemDispatcher;

  IUdrTriggerFactoryImpl_vTable := UdrTriggerFactoryVTable.create;
  IUdrTriggerFactoryImpl_vTable.version := 3;
  IUdrTriggerFactoryImpl_vTable.dispose := @IUdrTriggerFactoryImpl_disposeDispatcher;
  IUdrTriggerFactoryImpl_vTable.setup := @IUdrTriggerFactoryImpl_setupDispatcher;
  IUdrTriggerFactoryImpl_vTable.newItem := @IUdrTriggerFactoryImpl_newItemDispatcher;

  IUdrPluginImpl_vTable := UdrPluginVTable.create;
  IUdrPluginImpl_vTable.version := 2;
  IUdrPluginImpl_vTable.getMaster := @IUdrPluginImpl_getMasterDispatcher;
  IUdrPluginImpl_vTable.registerFunction := @IUdrPluginImpl_registerFunctionDispatcher;
  IUdrPluginImpl_vTable.registerProcedure := @IUdrPluginImpl_registerProcedureDispatcher;
  IUdrPluginImpl_vTable.registerTrigger := @IUdrPluginImpl_registerTriggerDispatcher;

  IDecFloat16Impl_vTable := DecFloat16VTable.create;
  IDecFloat16Impl_vTable.version := 2;
  IDecFloat16Impl_vTable.toBcd := @IDecFloat16Impl_toBcdDispatcher;
  IDecFloat16Impl_vTable.toString := @IDecFloat16Impl_toStringDispatcher;
  IDecFloat16Impl_vTable.fromBcd := @IDecFloat16Impl_fromBcdDispatcher;
  IDecFloat16Impl_vTable.fromString := @IDecFloat16Impl_fromStringDispatcher;

  IDecFloat34Impl_vTable := DecFloat34VTable.create;
  IDecFloat34Impl_vTable.version := 2;
  IDecFloat34Impl_vTable.toBcd := @IDecFloat34Impl_toBcdDispatcher;
  IDecFloat34Impl_vTable.toString := @IDecFloat34Impl_toStringDispatcher;
  IDecFloat34Impl_vTable.fromBcd := @IDecFloat34Impl_fromBcdDispatcher;
  IDecFloat34Impl_vTable.fromString := @IDecFloat34Impl_fromStringDispatcher;

  IInt128Impl_vTable := Int128VTable.create;
  IInt128Impl_vTable.version := 2;
  IInt128Impl_vTable.toString := @IInt128Impl_toStringDispatcher;
  IInt128Impl_vTable.fromString := @IInt128Impl_fromStringDispatcher;

  IReplicatedFieldImpl_vTable := ReplicatedFieldVTable.create;
  IReplicatedFieldImpl_vTable.version := 2;
  IReplicatedFieldImpl_vTable.getName := @IReplicatedFieldImpl_getNameDispatcher;
  IReplicatedFieldImpl_vTable.getType := @IReplicatedFieldImpl_getTypeDispatcher;
  IReplicatedFieldImpl_vTable.getSubType := @IReplicatedFieldImpl_getSubTypeDispatcher;
  IReplicatedFieldImpl_vTable.getScale := @IReplicatedFieldImpl_getScaleDispatcher;
  IReplicatedFieldImpl_vTable.getLength := @IReplicatedFieldImpl_getLengthDispatcher;
  IReplicatedFieldImpl_vTable.getCharSet := @IReplicatedFieldImpl_getCharSetDispatcher;
  IReplicatedFieldImpl_vTable.getData := @IReplicatedFieldImpl_getDataDispatcher;

  IReplicatedRecordImpl_vTable := ReplicatedRecordVTable.create;
  IReplicatedRecordImpl_vTable.version := 2;
  IReplicatedRecordImpl_vTable.getCount := @IReplicatedRecordImpl_getCountDispatcher;
  IReplicatedRecordImpl_vTable.getField := @IReplicatedRecordImpl_getFieldDispatcher;
  IReplicatedRecordImpl_vTable.getRawLength := @IReplicatedRecordImpl_getRawLengthDispatcher;
  IReplicatedRecordImpl_vTable.getRawData := @IReplicatedRecordImpl_getRawDataDispatcher;

  IReplicatedTransactionImpl_vTable := ReplicatedTransactionVTable.create;
  IReplicatedTransactionImpl_vTable.version := 3;
  IReplicatedTransactionImpl_vTable.dispose := @IReplicatedTransactionImpl_disposeDispatcher;
  IReplicatedTransactionImpl_vTable.prepare := @IReplicatedTransactionImpl_prepareDispatcher;
  IReplicatedTransactionImpl_vTable.commit := @IReplicatedTransactionImpl_commitDispatcher;
  IReplicatedTransactionImpl_vTable.rollback := @IReplicatedTransactionImpl_rollbackDispatcher;
  IReplicatedTransactionImpl_vTable.startSavepoint := @IReplicatedTransactionImpl_startSavepointDispatcher;
  IReplicatedTransactionImpl_vTable.releaseSavepoint := @IReplicatedTransactionImpl_releaseSavepointDispatcher;
  IReplicatedTransactionImpl_vTable.rollbackSavepoint := @IReplicatedTransactionImpl_rollbackSavepointDispatcher;
  IReplicatedTransactionImpl_vTable.insertRecord := @IReplicatedTransactionImpl_insertRecordDispatcher;
  IReplicatedTransactionImpl_vTable.updateRecord := @IReplicatedTransactionImpl_updateRecordDispatcher;
  IReplicatedTransactionImpl_vTable.deleteRecord := @IReplicatedTransactionImpl_deleteRecordDispatcher;
  IReplicatedTransactionImpl_vTable.executeSql := @IReplicatedTransactionImpl_executeSqlDispatcher;
  IReplicatedTransactionImpl_vTable.executeSqlIntl := @IReplicatedTransactionImpl_executeSqlIntlDispatcher;

  IReplicatedSessionImpl_vTable := ReplicatedSessionVTable.create;
  IReplicatedSessionImpl_vTable.version := 4;
  IReplicatedSessionImpl_vTable.addRef := @IReplicatedSessionImpl_addRefDispatcher;
  IReplicatedSessionImpl_vTable.release := @IReplicatedSessionImpl_releaseDispatcher;
  IReplicatedSessionImpl_vTable.setOwner := @IReplicatedSessionImpl_setOwnerDispatcher;
  IReplicatedSessionImpl_vTable.getOwner := @IReplicatedSessionImpl_getOwnerDispatcher;
  IReplicatedSessionImpl_vTable.setAttachment := @IReplicatedSessionImpl_setAttachmentDispatcher;
  IReplicatedSessionImpl_vTable.startTransaction := @IReplicatedSessionImpl_startTransactionDispatcher;
  IReplicatedSessionImpl_vTable.cleanupTransaction := @IReplicatedSessionImpl_cleanupTransactionDispatcher;
  IReplicatedSessionImpl_vTable.setSequence := @IReplicatedSessionImpl_setSequenceDispatcher;

finalization
  IVersionedImpl_vTable.destroy;
  IReferenceCountedImpl_vTable.destroy;
  IDisposableImpl_vTable.destroy;
  IStatusImpl_vTable.destroy;
  IMasterImpl_vTable.destroy;
  IPluginBaseImpl_vTable.destroy;
  IPluginSetImpl_vTable.destroy;
  IConfigEntryImpl_vTable.destroy;
  IConfigImpl_vTable.destroy;
  IFirebirdConfImpl_vTable.destroy;
  IPluginConfigImpl_vTable.destroy;
  IPluginFactoryImpl_vTable.destroy;
  IPluginModuleImpl_vTable.destroy;
  IPluginManagerImpl_vTable.destroy;
  ICryptKeyImpl_vTable.destroy;
  IConfigManagerImpl_vTable.destroy;
  IEventCallbackImpl_vTable.destroy;
  IBlobImpl_vTable.destroy;
  ITransactionImpl_vTable.destroy;
  IMessageMetadataImpl_vTable.destroy;
  IMetadataBuilderImpl_vTable.destroy;
  IResultSetImpl_vTable.destroy;
  IStatementImpl_vTable.destroy;
  IBatchImpl_vTable.destroy;
  IBatchCompletionStateImpl_vTable.destroy;
  IReplicatorImpl_vTable.destroy;
  IRequestImpl_vTable.destroy;
  IEventsImpl_vTable.destroy;
  IAttachmentImpl_vTable.destroy;
  IServiceImpl_vTable.destroy;
  IProviderImpl_vTable.destroy;
  IDtcStartImpl_vTable.destroy;
  IDtcImpl_vTable.destroy;
  IAuthImpl_vTable.destroy;
  IWriterImpl_vTable.destroy;
  IServerBlockImpl_vTable.destroy;
  IClientBlockImpl_vTable.destroy;
  IServerImpl_vTable.destroy;
  IClientImpl_vTable.destroy;
  IUserFieldImpl_vTable.destroy;
  ICharUserFieldImpl_vTable.destroy;
  IIntUserFieldImpl_vTable.destroy;
  IUserImpl_vTable.destroy;
  IListUsersImpl_vTable.destroy;
  ILogonInfoImpl_vTable.destroy;
  IManagementImpl_vTable.destroy;
  IAuthBlockImpl_vTable.destroy;
  IWireCryptPluginImpl_vTable.destroy;
  ICryptKeyCallbackImpl_vTable.destroy;
  IKeyHolderPluginImpl_vTable.destroy;
  IDbCryptInfoImpl_vTable.destroy;
  IDbCryptPluginImpl_vTable.destroy;
  IExternalContextImpl_vTable.destroy;
  IExternalResultSetImpl_vTable.destroy;
  IExternalFunctionImpl_vTable.destroy;
  IExternalProcedureImpl_vTable.destroy;
  IExternalTriggerImpl_vTable.destroy;
  IRoutineMetadataImpl_vTable.destroy;
  IExternalEngineImpl_vTable.destroy;
  ITimerImpl_vTable.destroy;
  ITimerControlImpl_vTable.destroy;
  IVersionCallbackImpl_vTable.destroy;
  IUtilImpl_vTable.destroy;
  IOffsetsCallbackImpl_vTable.destroy;
  IXpbBuilderImpl_vTable.destroy;
  ITraceConnectionImpl_vTable.destroy;
  ITraceDatabaseConnectionImpl_vTable.destroy;
  ITraceTransactionImpl_vTable.destroy;
  ITraceParamsImpl_vTable.destroy;
  ITraceStatementImpl_vTable.destroy;
  ITraceSQLStatementImpl_vTable.destroy;
  ITraceBLRStatementImpl_vTable.destroy;
  ITraceDYNRequestImpl_vTable.destroy;
  ITraceContextVariableImpl_vTable.destroy;
  ITraceProcedureImpl_vTable.destroy;
  ITraceFunctionImpl_vTable.destroy;
  ITraceTriggerImpl_vTable.destroy;
  ITraceServiceConnectionImpl_vTable.destroy;
  ITraceStatusVectorImpl_vTable.destroy;
  ITraceSweepInfoImpl_vTable.destroy;
  ITraceLogWriterImpl_vTable.destroy;
  ITraceInitInfoImpl_vTable.destroy;
  ITracePluginImpl_vTable.destroy;
  ITraceFactoryImpl_vTable.destroy;
  IUdrFunctionFactoryImpl_vTable.destroy;
  IUdrProcedureFactoryImpl_vTable.destroy;
  IUdrTriggerFactoryImpl_vTable.destroy;
  IUdrPluginImpl_vTable.destroy;
  IDecFloat16Impl_vTable.destroy;
  IDecFloat34Impl_vTable.destroy;
  IInt128Impl_vTable.destroy;
  IReplicatedFieldImpl_vTable.destroy;
  IReplicatedRecordImpl_vTable.destroy;
  IReplicatedTransactionImpl_vTable.destroy;
  IReplicatedSessionImpl_vTable.destroy;
{$ENDIF ZEOS_DISABLE_FIREBIRD}
end.
