////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Manual Fit Breaker.                                            //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrmanfitbreaker; // Form Spectr Manual Fit Breaker

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_SpectrManFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrManFitBreaker = class(TMasterForm)
    ButtonBreak: TButton;
    Timer: TTimer;
    procedure TimerTimer(Sender: TObject);
    procedure ButtonBreakClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Win : TFormSpectrManFitWindow;
  end;

procedure FormSpectrManFitBreakerExecute(Win:TFormSpectrManFitWindow);

implementation

{$R *.lfm}

procedure FormSpectrManFitBreakerExecute(Win:TFormSpectrManFitWindow);
var Form:TFormSpectrManFitBreaker;
begin
 if Win.Ok then begin
  Application.CreateForm(TFormSpectrManFitBreaker, Form);
  Form.Win:=Win;
  Form.Caption:=Format(RusEng('Минимизация [%s]','Minimization [%s]'),[Win.Caption]);
  mrVoice(Form.ShowModal);
  Kill(TObject(Form));
 end;
end;

procedure TFormSpectrManFitBreaker.TimerTimer(Sender: TObject);
begin
 if Win.ManFit.UserBreak then ModalResult:=mrOk;
end;

procedure TFormSpectrManFitBreaker.ButtonBreakClick(Sender: TObject);
begin
 Win.ManFit.UserBreak:=true;
end;

procedure TFormSpectrManFitBreaker.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 ButtonBreak.Caption:=RusEng('Остановить минимизацию','Break minimization');
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrmanfitbreaker;
begin
end;

procedure Free_form_spectrmanfitbreaker;
begin
end;

initialization

 Init_form_spectrmanfitbreaker;

finalization

 Free_form_spectrmanfitbreaker;

end.

//////////////
// END OF FILE
//////////////

