////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Point2D Edit.                                                     //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231202 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqpoint2dedit; // Form DAQ Point2D Edit

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 Form_CrwDaqSysChild,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_ef,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqPoint2DEdit = class(TMasterForm)
    LabelX: TLabel;
    LabelY: TLabel;
    EditX: TEdit;
    EditY: TEdit;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure FormDaqPoint2DEditExecute(var P:TPoint2D; const Params:LongString='');

implementation

{$R *.lfm}

const TheForm : TFormDaqPoint2DEdit = nil;

procedure FormDaqPoint2DEditExecute(var P:TPoint2D; const Params:LongString='');
var Q:TPoint2D;
begin
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormDaqPoint2DEdit, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   TheForm.EditX.Text:=Format('%g',[P.X]);
   TheForm.EditY.Text:=Format('%g',[P.Y]);
   if IsNonEmptyStr(Params)
   then TheForm.ApplyParams(Params)
   else TheForm.LocateToCenterOfScreen;
   if (mrVoice(TheForm.ShowModal)=mrOk) then begin
    if Str2Real(TheForm.EditX.Text,Q.X) and Str2Real(TheForm.EditY.Text,Q.Y) then begin
     if not SameText(Format('%g',[P.X]),Format('%g',[Q.X])) then P.X:=Q.X;
     if not SameText(Format('%g',[P.Y]),Format('%g',[Q.Y])) then P.Y:=Q.Y;
    end else Error(RusEng('Ошибка формата числа!','Numerical format error.'));
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqPoint2DEditExecute');
 end;
end;

procedure TFormDaqPoint2DEdit.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Редакция точки кривой','Edit curve point');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqpoint2dedit;
begin
end;

procedure Free_form_daqpoint2dedit;
begin
end;

initialization

 Init_form_daqpoint2dedit;

finalization

 Free_form_daqpoint2dedit;

end.

//////////////
// END OF FILE
//////////////

