////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Open Dynamic Window Dialog.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqopendynamicwindowdialog; // Form DAQ Open Dynamic Window Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormDaqOpenDynamicWindowDialog }

  TFormDaqOpenDynamicWindowDialog = class(TMasterForm)
    BitBtnDaqLoadWindowsDialog: TBitBtn;
    ComboBoxCaption: TComboBox;
    ComboBoxLegend: TComboBox;
    ComboBoxTitle: TComboBox;
    GroupBoxOpenNew: TGroupBox;
    GroupBoxLoadCfg: TGroupBox;
    LabelCaption: TLabel;
    LabelLegend: TLabel;
    LabelTitle: TLabel;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    PanelParams: TPanel;
    RadioGroupType: TRadioGroup;
    procedure BitBtnDaqLoadWindowsDialogClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelCaptionClick(Sender: TObject);
    procedure LabelTitleClick(Sender: TObject);
    procedure LabelLegendClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function  FormDaqOpenDynamicWindowDialogExecute(var aCaption,aTitle,aLegend:LongString;
            var aType:Integer; const Params:LongString=''):Integer;
procedure KillFormDaqOpenDynamicWindowDialog;

const
 DynamicCurWinNumber : Integer = 0;
 DynamicTabWinNumber : Integer = 0;

implementation

{$R *.lfm}

const
 FormDaqOpenDynamicWindowDialog : TFormDaqOpenDynamicWindowDialog = nil;

function FormDaqOpenDynamicWindowDialogExecute(var aCaption,aTitle,aLegend:LongString;
           var aType:Integer; const Params:LongString=''):Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormDaqOpenDynamicWindowDialog) then
 try
  if not Assigned(FormDaqOpenDynamicWindowDialog) then begin
   Application.CreateForm(TFormDaqOpenDynamicWindowDialog, FormDaqOpenDynamicWindowDialog);
   FormDaqOpenDynamicWindowDialog.Master:=@FormDaqOpenDynamicWindowDialog;
  end;
  if FormDaqOpenDynamicWindowDialog.Ok then with FormDaqOpenDynamicWindowDialog do begin
   ComboBoxCaption.Text:=aCaption;
   ComboBoxTitle.Text:=aTitle;
   ComboBoxLegend.Text:=aLegend;
   RadioGroupType.ItemIndex:=aType mod 2;
   if IsNonEmptyStr(Params) then ApplyParams(Params);
   if mrVoice(ShowModal)=mrOk then begin
    Result:=mrOk;
    aCaption:=ComboBoxCaption.Text;
    aTitle:=ComboBoxTitle.Text;
    aLegend:=ComboBoxLegend.Text;
    aType:=RadioGroupType.ItemIndex;
    RecordComboBoxHistory(ComboBoxCaption,50);
    RecordComboBoxHistory(ComboBoxTitle,50);
    RecordComboBoxHistory(ComboBoxLegend,50);
    if SameText(aCaption,RusEng('Новое окно DAQ','New DAQ Window')) then begin
     if (aType=0) then begin
      inc(DynamicCurWinNumber);
      aCaption:='DAQ.CURVE_WINDOW_'+IntToStr(DynamicCurWinNumber);
     end;
     if (aType=1) then begin
      inc(DynamicTabWinNumber);
      aCaption:='DAQ.TAB_WINDOW_'+IntToStr(DynamicTabWinNumber);
     end;
    end;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqOpenDynamicWindowDialogExecute');
 end;
end;

procedure KillFormDaqOpenDynamicWindowDialog;
begin
 Kill(TObject(FormDaqOpenDynamicWindowDialog));
end;

procedure TFormDaqOpenDynamicWindowDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Открыть/Загрузить новое окно DAQ','Open/Load new DAQ window');
 LabelCaption.Caption:=RusEng('Имя окна','Caption');
 LabelTitle.Caption:=RusEng('Заголовок','Title');
 LabelLegend.Caption:=RusEng('Легенда','Legend');
 RadioGroupType.Caption:=RusEng('Тип окна','Window type');
 RadioGroupType.Items.Text:=RusEng('График кривых'+EOL+'Таблица','Curve plot'+EOL+'Table');
 GroupBoxOpenNew.Caption:=RusEng('Открыть новое окно DAQ','Open new DAQ Window');
 GroupBoxLoadCfg.Caption:=RusEng('Загрузить окно из конфигурации','Load window from configuration');
 BitBtnDaqLoadWindowsDialog.Caption:=RusEng('Загрузить окно DAQ [Windows]','Load window from DAQ [Windows]');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

procedure TFormDaqOpenDynamicWindowDialog.BitBtnDaqLoadWindowsDialogClick(Sender: TObject);
begin
 SendToMainConsole('@daq LoadWindowsDialog'+EOL);
 ModalResult:=mrYes;
end;

procedure TFormDaqOpenDynamicWindowDialog.LabelCaptionClick(Sender: TObject);
begin
 SmartFocus(ComboBoxCaption);
end;

procedure TFormDaqOpenDynamicWindowDialog.LabelTitleClick(Sender: TObject);
begin
 SmartFocus(ComboBoxTitle);
end;

procedure TFormDaqOpenDynamicWindowDialog.LabelLegendClick(Sender: TObject);
begin
 SmartFocus(ComboBoxLegend);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqopendynamicwindowdialog;
begin
end;

procedure Free_form_daqopendynamicwindowdialog;
begin
end;

initialization

 Init_form_daqopendynamicwindowdialog;

finalization

 Free_form_daqopendynamicwindowdialog;

end.

//////////////
// END OF FILE
//////////////

