import socket
import sys
import time
from datetime import datetime

def calculate_crc(data):
    """Расчет простой суммы байтов с маской FF (как в примере)"""
    checksum = 0
    for byte in data:
        checksum += byte
    return checksum & 0xFF

def main():
    if len(sys.argv) != 4:
        print("Использование: python serial_over_network.py <ip> <port> <log_file>")
        return
    
    ip = sys.argv[1]
    port = int(sys.argv[2])
    log_file = sys.argv[3]
    
    # Создаем TCP сокет
    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(0.15)  # Таймаут соединения 0.25 секунды
        sock.connect((ip, port))
        print(f"Подключено к {ip}:{port}")
    except Exception as e:
        print(f"Ошибка подключения: {e}")
        return
    
    # Открываем файл лога для записи
    with open(log_file, 'w', encoding='utf-8') as f:
        print(f"Лог будет сохранен в {log_file}")
        print("=" * 60)
        print("Результаты запросов:")
        print("=" * 60)
        
        # Циклическая отправка команд (0x00 - 0xFF)
        for i in range(256):
            cmd_data = f"${i:02X}M"
            
            try:
                print(f"\n--- Обработка адреса ${i:02X} ---")
                
                # Запрос с контрольной суммой
                data_for_crc = cmd_data.encode('utf-8')
                crc_value = calculate_crc(data_for_crc)
                crc_hex = f"{crc_value:02X}"
                full_cmd = cmd_data + crc_hex + "\r"
                
                print(f"Запрос с CRC: {full_cmd.strip()}")
                sock.send(full_cmd.encode('utf-8'))
                
                # Читаем ответ (с контрольной суммой)
                response1 = sock.recv(1024)
                if response1:
                    resp_str1 = response1.decode('utf-8', errors='ignore').strip()
                    print(f"Ответ с CRC: {resp_str1}")
                    
                    # Сохраняем в лог
                    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                    log_line = f"[{timestamp}] С CRC: {cmd_data} -> {resp_str1}\n"
                    f.write(log_line)
                    
                    # Дублируем результат на экран
                    print(f"Результат: {cmd_data} = {resp_str1}")
                
                # Запрос без контрольной суммы
                print(f"Запрос без CRC: {cmd_data}")
                sock.send(cmd_data.encode('utf-8'))
                response2 = sock.recv(1024)
                if response2:
                    resp_str2 = response2.decode('utf-8', errors='ignore').strip()
                    print(f"Ответ без CRC: {resp_str2}")
                    
                    # Сохраняем в лог
                    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                    log_line = f"[{timestamp}] Без CRC: {cmd_data} -> {resp_str2}\n"
                    f.write(log_line)
                    
                    # Дублируем результат на экран
                    print(f"Результат: {cmd_data} = {resp_str2}")
                        
            except socket.timeout:
                print(f"Таймаут при работе с адресом ${i:02X}")
            except Exception as e:
                print(f"Ошибка при работе с адресом ${i:02X}: {e}")
                
            time.sleep(0.1)  # Задержка между командами (100 мс)
    
    sock.close()
    print("\n" + "=" * 60)
    print("Завершено. Результаты сохранены в файл.")
    print("=" * 60)

if __name__ == "__main__":
    main()