#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# Open MODBUS help reference directory.
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly dir="$(realpath $scriptHOME/../modbus/reference)";
readonly htm="$(realpath $scriptHOME/../modbus/reference/modbus.htm)";

function main(){
 if [ -e "$htm" ]; then
  exec unix getapppath -e firefox -t text/html -a .html --run $htm;
 fi;
 if [ -d "$dir" ] && which xdg-open >/dev/null 2>&1; then
  exec xdg-open "$dir/";
 else
  fatal 1 "$(langstr ru "Не могу открыть modbus/reference." en "Could not open modbus/reference.")";
 fi;
};

main "$@";

#############
# END OF FILE
#############
