@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Time-Diff
if /I "%~1" == ""       goto :Help
if /I "%~1" == "/?"     goto :Help
if /I "%~1" == "-h"     goto :Help
if /I "%~1" == "--help" goto :Help
::call net session 1>nul 2>nul || ( call :AccessDenied & goto :EOF )
call :SetOrEditNtpServer %1
call :IsPingReply %NtpServer% || ( call :PingFailed %NtpServer% & goto :EOF )
call :Print "Service W32Time Status         : " & call :IsServiceRunning W32Time || echo Service W32Time is STOPPED.
                                                  call :IsServiceRunning W32Time && echo Service W32Time is RUNNING.
call :Print "Uses time source NTP servers   : " & call :QuerySntpSource
call :TimeMonitor %NtpServer%
goto :EOF

:AccessDenied
echo Access denied to user "%UserName%". Admin rights required.
call :SetErrorLevel 1
goto :EOF

:PingFailed
echo Could not ping server: %1
call :SetErrorLevel 1
goto :EOF

:Help
echo Copyright^(c^) Alex Kuryakin 2018 kouriakine@mail.ru
echo %~n0 - compare localhost time with remote NTP server
echo Syntax:
echo  %~n0 server       - compare local time with server
echo  %~n0 server?      - edit server name before compare
echo Example:
echo  %~n0 time.windows.com
echo  %~n0 ru.pool.ntp.org
echo  %~n0 pool.ntp.org
echo  %~n0 simply.dep0404.ru
echo  %~n0 172.21.4.55
echo  %~n0 archive?
goto :EOF

:SetOrEditNtpServer
set "NtpServer=%~1"
if not "%NtpServer:?=%" == "%NtpServer%" call :EditNtpServer %NtpServer:?=%
set "NtpServer=%NtpServer:?=%"
goto :EOF

:EditNtpServer
call inputbox -h 1>nul 2>nul || ( set /p "NtpServer=Please set NTP Server Name or IP (like %~1) to compare with : " & goto :EOF )
for /f "usebackq tokens=1" %%i in (`call inputbox "Compare local time with NTP server..." "Please set NTP Server Name or IP to compare with..." "%~1" 2^>nul`) do set "NtpServer=%%i"
goto :EOF

:QuerySntpSource
call w32tm /query /source 1>nul 2>nul && goto :QuerySntpByW32tm
call net time /querysntp  1>nul 2>nul && goto :QuerySntpByNetTime
goto :EOF
:QuerySntpByNetTime
:: This works on WinXP
for /f "usebackq tokens=1* delims=:" %%i in (`net time /querysntp ^| findstr /i /c:"sntp:"`) do call :PrintSntpSource %%j
goto :EOF
:QuerySntpByW32tm
:: This works on Win10
for /f "usebackq tokens=* delims=" %%i in (`w32tm /query /source`) do call :PrintSntpSource %%i
goto :EOF
:PrintSntpSource
echo.%1
goto :EOF

:IsServiceRunning
if "%~1" == "" goto :EOF
for /f "usebackq tokens=* delims=" %%i in (`sc query %~1 ^| findstr /i /c:"RUNNING"`) do ( call :SetErrorLevel 0 & goto :EOF )
call :SetErrorLevel 1
goto :EOF

:DetectNoWarnOption
set NoWarnOption= 
for /f "usebackq tokens=* delims=" %%i in (`w32tm ^| findstr /i /c:"/nowarn"`) do set NoWarnOption=/nowarn
goto :EOF

:TimeMonitor
call :DetectNoWarnOption
echo Compare local time with server : %~1
call w32tm /monitor /computers:%~1 %NoWarnOption%
goto :EOF

:IsPingReply
call ping -n 1 %1 1>nul 2>nul
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :Print %2
if not "%~3" == "" ( for /L %%i in (1,1,%1) do ( call :Sleep 1 & call :Print %~3 ) ) else ( call ping -n %PingCount% 127.0.0.1 1>nul 2>nul  )
EndLocal
goto :EOF

:ExecPrint
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
call :Print %1 & echo %~2
for /f "usebackq tokens=* delims=" %%i in (` %~2 2^>^&1 `) do ( call :Print %1 & echo.%%~i )
EndLocal
goto :EOF

:Print
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p "_=%~1"
EndLocal
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
