 {
 ****************************************************************************
 CRW32 project
 Copyright (C) by Kuryakin Alexey, Sarov, Russia, 2001, <kouriakine@mail.ru>
         
 .     ( 
  )      x.
 Modifications:
 20011225 - Creation (uses CRW16)
 2001226  - Test ok.
 ****************************************************************************
 }
unit _couple;

{$I _sysdef}

interface

uses
 sysutils, windows, classes, contnrs, math, _alloc, _fpu, _zm, _ef, _spline,
 _str, _fio, _dynar, _plut;

 {
 *******************************************************************************
 Thermocouple  Relashionship     
 ,    .    
  (,        ).
 *******************************************************************************
      [DataBase]   CRW32.INI.
 *******************************************************************************
 ThermoCoupleount        
 ThermoCoupleName          CoupleID
 ThermoCoupleRange         CoupleID
 ThermoCouple              CoupleID
                         Inverted=false:
                         Argument=(X) ThermoCouple=(Y)
                         Inverted=true:
                         Argument=(Y)    ThermoCouple=(X)
 FindThermoCouple          
 InitCouples                 ini-
 ReadThermoCoupleList     
 *******************************************************************************
    :
 [ThermoCoupleList]
 ThermoCouple = HrAl
 ThermoCouple = HrCp
 [HrAl]
 FitMethod = Spline
 Smooth = 20
 Data Celsius     mV  RelErr
         -270 -6.458       1
         -269 -6.457       1
         -268 -6.456       1
 End Data
 [HrCp]
 FitMethod = Spline
 Smooth = 20
 Data Celsius     mV  RelErr
         -270 -6.458       1
         -269 -6.457       1
         -268 -6.456       1
 End Data
 *******************************************************************************
 }
function  ThermoCoupleCount:Integer;
function  ThermoCoupleName(CoupleID:Integer):ShortString;
function  ThermoCoupleRange(CoupleID:Integer):TRect2D;
function  ThermoCouple(CoupleID:Integer; Argument:Double; Inverted:Boolean):Double;
function  FindThermoCouple(const CoupleName:ShortString):Integer;
procedure InitCouples(const IniFile,Section,Name:ShortString; DebugId:Integer=-1);
procedure ReadThermoCoupleList(const IniFile:ShortString; DebugId:Integer=-1);

 {
 *******************************************************************************
 C    (Relationship).
       .
 *******************************************************************************
    :
 [RelationshipList]
 Relationship = R1
 Relationship = R2
 [R1]
 FitMethod = Spline
 Smooth = 20
 Data       X      Y  RelErr
         -270 -6.458       1
         -269 -6.457       1
         -268 -6.456       1
 End Data
 [R2]
 FitMethod = Spline
 Smooth = 20
 Data       X      Y  RelErr
         -270 -6.458       1
         -269 -6.457       1
         -268 -6.456       1
 End Data
 *******************************************************************************
 }
function  RelationshipCount:Integer;
function  RelationshipName(RelationID:Integer):ShortString;
function  RelationshipRange(RelationID:Integer):TRect2D;
function  Relationship(RelationID:Integer; Argument:Double; Inverted:Boolean):Double;
function  FindRelationship(const RelationName:ShortString):Integer;
procedure InitRelationships(const IniFile,Section,Name:ShortString; DebugId:Integer=-1);
procedure ReadRelationshipList(const IniFile:ShortString; DebugId:Integer=-1);

implementation

const
 CoupleList   : TObjectStorage = nil; {   }
 RelationList : TObjectStorage = nil; {   }

 {
      [ax,bx].
      .
 }
function ExpandSpline(ax,bx:Double; Spline:TReinschSpline; x:Double):Double;
begin
 Result:=0;
 if Spline.Ok then
 if x<ax then Result:=Spline.Get(ax)+(x-ax)*Spline.Get(ax,1) else
 if x>bx then Result:=Spline.Get(bx)+(x-bx)*Spline.Get(bx,1) else
 Result:=Spline.Get(x);
end;

 {
      F(x)=Y   .
 }
type
 TFRec=record
  S : TReinschSpline;
  Y : Double;
 end;

function F(x:Double; Custom:Pointer):Double;
begin
 with TFRec(Custom^) do Result:=S.Get(x)-Y;
end;

 {
  x=InvertSpline(ax,bx,Spline,y)   x 
  ExpandSpline(ax,bx,Spline,x)=y (. ExpandSpline)
 Spline     [ax,bx].
 }
function InvertSpline(ax,bx:Double; Spline:TReinschSpline; y:Double):Double;
var ay,by:Double; FRec:TFRec;
begin
 Result:=0;
 if Spline.Ok then begin
  FRec.S:=Spline;
  FRec.Y:=y;
  ay:=Spline.Get(ax);
  by:=Spline.Get(bx);
  if ay<by then begin
   if y<ay then Result:=ax+(y-ay)/Spline.Get(ax,1) else
   if y>by then Result:=bx+(y-by)/Spline.Get(bx,1) else
   Result:=FindZero(F,ax,bx,MachEps*10,@FRec);
  end else begin
   if y<by then Result:=bx+(y-by)/Spline.Get(bx,1) else
   if y>ay then Result:=ax+(y-ay)/Spline.Get(ax,1) else
   Result:=FindZero(F,ax,bx,MachEps*10,@FRec);
  end;
 end;
end;

 {
    y(x)
 }
type
 TRelation=class(TMasterObject)
 private
  myName      : ShortString;    { }
  myRange     : TRect2D;        {}
  mySpline    : TReinschSpline; {  ()}
 protected
  function    CheckOk:Boolean; override;
  function    GetName:ShortString;
  function    GetRange:TRect2D;
  function    GetSpline:TReinschSpline;
 public
  constructor Create(const IniFile,SectionName,xName,yName,wName:ShortString);
  destructor  Destroy; override;
  function    Get(Argument:Double; Inverted:Boolean):Double;
 public
  property    Name   : ShortString    read GetName;
  property    Range  : TRect2D        read GetRange;
  property    Spline : TReinschSpline read GetSpline;
 end;

function TRelation.CheckOk:Boolean;
begin
 Result:=mySpline.Ok and not IsEmptyStr(myName);
end;

function TRelation.GetName:ShortString;
begin
 if Assigned(Self) then Result:=myName else Result:='';
end;

function TRelation.GetRange:TRect2D;
begin
 if Assigned(Self) then Result:=myRange else Result:=Rect2D(0,0,0,0);
end;

function TRelation.GetSpline:TReinschSpline;
begin
 if Assigned(Self) then Result:=mySpline else Result:=nil;
end;

constructor TRelation.Create(const IniFile,SectionName,xName,yName,wName:ShortString);
label
 Ok,Fault;
var
 x,y,w:PDoubleArray; Smooth,rx,ry,rw:Double; i,ix,iy,iw,NumPoints:Integer;
 s:ShortString; P:PChar; Section:LongString;
 function CheckMem(var v:PDoubleArray; N:Integer):Boolean;
 begin
  if AllocSize(v)<(N+1)*sizeof(Double)
  then Result:=Reallocate(Pointer(v),AdjustBufferSize(N+1,4096)*sizeof(Double))
  else Result:=true;
 end;
begin
 inherited Create;
 myName:='';
 myRange:=Rect2D(0,0,1,1);
 mySpline:=nil;
 x:=nil;
 y:=nil;
 w:=nil;
 NumPoints:=0;
 Section:='';
 if not FileExists(IniFile) then goto Fault;
 Section:=ExtractTextSection(IniFile,SectionName,efConfig);
 if Section='' then goto Fault;
 if ScanVar(svConfig,PChar(Section),'Smooth%f',Smooth)=nil then goto Fault;
 P:=StrPass(ScanVar(svConfig,PChar(Section),'Data%s',s),[CR,LF]);
 if P=nil then goto Fault;
 ix:=0;
 iy:=0;
 iw:=0;
 for i:=1 to WordCount(s,[' ']) do begin
  if UnifyAlias(ExtractWord(i,s,[' ']))=UnifyAlias(xName) then ix:=i;
  if UnifyAlias(ExtractWord(i,s,[' ']))=UnifyAlias(yName) then iy:=i;
  if UnifyAlias(ExtractWord(i,s,[' ']))=UnifyAlias(wName) then iw:=i;
 end;
 if (ix<1) or (iy<1) then goto Fault;
 while P<>nil do begin
  P:=StrPass(ScanVar(svAsIs,P,'%s',s),[CR,LF]);
  if P<>nil then begin
   if Pos('END DATA',UpcaseStr(s))>0 then break;
   rx:=0;
   ry:=0;
   rw:=1;
   if (ix>0) and not Str2Real(ExtractWord(ix,s,[' ']),rx) then continue;
   if (iy>0) and not Str2Real(ExtractWord(iy,s,[' ']),ry) then continue;
   if (iw>0) and not Str2Real(ExtractWord(iw,s,[' ']),rw) then continue;
   if not CheckMem(x,NumPoints) then goto Fault;
   if not CheckMem(y,NumPoints) then goto Fault;
   if not CheckMem(w,NumPoints) then goto Fault;
   x[NumPoints]:=rx;
   y[NumPoints]:=ry;
   w[NumPoints]:=rw*Smooth;
   inc(NumPoints);
  end;
 end;
 if NumPoints<3 then goto Fault;
 for i:=1 to NumPoints-1 do if x[i-1]>=x[i] then goto Fault;
 myName:=UnifyAlias(TrimChars(SectionName,['['],[']']));
 mySpline:=NewReinschSpline(x^,y^,w^,NumPoints,2,0,2,0);
 if not mySpline.Ok then goto Fault;
 if mySpline.N<NumPoints then goto Fault;
 with myRange do begin
  a.x:=x[0];
  b.x:=x[NumPoints-1];
  a.y:=min(mySpline.Get(a.x),mySpline.Get(b.x));
  b.y:=max(mySpline.Get(a.x),mySpline.Get(b.x));
 end;
Ok:
 Deallocate(Pointer(x));
 Deallocate(Pointer(y));
 Deallocate(Pointer(w));
 Section:='';
 exit;
Fault:
 Deallocate(Pointer(x));
 Deallocate(Pointer(y));
 Deallocate(Pointer(w));
 Section:='';
 myName:='';
 myRange:=Rect2D(0,0,1,1);
 Kill(mySpline);
end;

destructor TRelation.Destroy;
begin
 myName:='';
 myRange:=Rect2D(0,0,1,1);
 Kill(mySpline);
 inherited Destroy;
end;

function TRelation.Get(Argument:Double; Inverted:Boolean):Double;
begin
 if Assigned(Self) then with myRange do begin
  if Inverted
  then Result:=InvertSpline(a.x,b.x,mySpline,Argument)
  else Result:=ExpandSpline(a.x,b.x,mySpline,Argument);
 end else Result:=0;
end;

 {
 *******************************************************************************
     
 *******************************************************************************
 }
function ThermoCoupleCount:Integer;
begin
 Result:=CoupleList.Count;
end;

function ThermoCoupleName(CoupleID:Integer):ShortString;
begin
 Result:=UnifyAlias(TRelation(CoupleList[CoupleID]).Name);
end;

function ThermoCoupleRange(CoupleID:Integer):TRect2D;
begin
 Result:=RectValidate(TRelation(CoupleList[CoupleID]).Range);
end;

function ThermoCouple(CoupleID:Integer; Argument:Double; Inverted:Boolean):Double;
begin
 Result:=TRelation(CoupleList[CoupleID]).Get(Argument,Inverted);
end;

function FindThermoCouple(const CoupleName:ShortString):Integer;
var i:Integer;
begin
 Result:=-1;
 if UnifyAlias(CoupleName)<>'' then
 for i:=0 to ThermoCoupleCount-1 do
 if UnifyAlias(ThermoCoupleName(i))=UnifyAlias(CoupleName) then begin
  Result:=i;
  break;
 end;
end;

procedure InitCouples(const IniFile,Section,Name:ShortString; DebugId:Integer=-1);
var Path:ShortString;
begin
 if ReadIniFilePath(IniFile,Section,Name,ExtractFilePath(IniFile),Path) then begin
  if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                             'Reading thermocouple database ')+Path);
  ReadThermoCoupleList(Path,DebugID);
  if ThermoCoupleCount=0 then
  if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                             'Not found thermocouple database in ')+Path);
 end else begin
  if DebugID>=0 then DebugOut(DebugID,RusEng('     ',
                                             'Not found database ')+IniFile+' '+Section+' '+Name);
 end;
end;

procedure ReadThermoCoupleList(const IniFile:ShortString; DebugID:Integer=-1);
label Ok,Fault;
var Section:LongString; P:PChar; CoupleName:ShortString; Couple:TRelation;
begin
 Section:='';
 CoupleList.Count:=0;
 if not FileExists(IniFile) then goto Fault;
 Section:=ExtractTextSection(IniFile,'[ThermoCoupleList]',efConfig);
 if (Section='') then goto Fault;
 P:=StrPass(ScanVar(svConfig,PChar(Section),'ThermoCouple%a',CoupleName),[CR,LF]);
 while Assigned(P) do begin
  Couple:=TRelation.Create(IniFile,UnifySection(CoupleName),'Celsius','mV','RelErr');
  if Couple.Ok then begin
   CoupleList.Add(Couple);
   if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                              'Read Ok thermocouple ')+CoupleName);
  end else begin
   if DebugID>=0 then DebugOut(DebugID,RusEng('     ',
                                              'Read fail thermocouple ')+CoupleName);
   Kill(TObject(Couple));
  end;
  P:=StrPass(ScanVar(svConfig,P,'ThermoCouple%a',CoupleName),[CR,LF]);
 end;
Ok:
 Section:='';
 exit;
Fault:
 Section:='';
 CoupleList.Count:=0;
end;

 {
 *******************************************************************************
     
 *******************************************************************************
 }
function RelationshipCount:Integer;
begin
 RelationshipCount:=RelationList.Count;
end;

function RelationshipName(RelationID:Integer):ShortString;
begin
 Result:=UnifyAlias(TRelation(RelationList[RelationID]).Name);
end;

function RelationshipRange(RelationID:Integer):TRect2D;
begin
 Result:=RectValidate(TRelation(RelationList[RelationID]).Range);
end;

function Relationship(RelationID:Integer; Argument:Double; Inverted:Boolean):Double;
begin
 Result:=TRelation(RelationList[RelationID]).Get(Argument,Inverted);
end;

function FindRelationship(const RelationName:ShortString):Integer;
var i:Integer;
begin
 Result:=-1;
 if UnifyAlias(RelationName)<>'' then
 for i:=0 to RelationshipCount-1 do
 if UnifyAlias(RelationshipName(i))=UnifyAlias(RelationName) then begin
  Result:=i;
  break;
 end;
end;

procedure InitRelationships(const IniFile,Section,Name:ShortString; DebugID:Integer=-1);
var Path:ShortString;
begin
 if ReadIniFilePath(IniFile,Section,Name,ExtractFilePath(IniFile),Path) then begin
  if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                             'Reading relationship database ')+Path);
  ReadRelationshipList(Path,DebugID);
  if RelationshipCount=0 then
  if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                             'Not found relationship database in ')+Path);
 end else begin
  if DebugID>=0 then DebugOut(DebugID,RusEng('      ',
                                             'Not found relationship database ')+IniFile+' '+Section+' '+Name);
 end;
end;

procedure ReadRelationshipList(const IniFile:ShortString; DebugID:Integer=-1);
label Ok,Fault;
var Section:LongString; P:PChar; RelationName:ShortString; Relation:TRelation;
begin
 Section:='';
 RelationList.Count:=0;
 if not FileExists(IniFile) then goto Fault;
 Section:=ExtractTextSection(IniFile,'[RelationshipList]',efConfig);
 if Section='' then goto fault;
 P:=StrPass(ScanVar(svConfig,PChar(Section),'Relationship%a',RelationName),[CR,LF]);
 while Assigned(P) do begin
  Relation:=TRelation.Create(IniFile,UnifySection(RelationName),'X','Y','RelErr');
  if Relation.Ok then begin
   RelationList.Add(Relation);
   if DebugID>=0 then DebugOut(DebugID,RusEng('    ',
                                              'Read Ok Relation ')+RelationName);
  end else begin
   if DebugID>=0 then DebugOut(DebugID,RusEng('     ',
                                              'Read fail Relation ')+RelationName);
   Kill(TObject(Relation));
  end;
  P:=StrPass(ScanVar(svConfig,P,'Relationship%a',RelationName),[CR,LF]);
 end;
Ok:
  Section:='';
  exit;
Fault:
 Section:='';
 RelationList.Count:=0;
end;

initialization

 CoupleList:=NewObjectStorage;
 RelationList:=NewObjectStorage;

finalization

 Kill(CoupleList);
 Kill(RelationList);

end.
