////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Для тестовых целей.
[]
[Manual.Eng]
For tests only.
[]
[Arguments.Rus]
[]
Аргумент1 = 1
Аргумент2 = 2
[]
[Arguments.Eng]
[]
Argument1 = 1
Argument2 = 2
[]
}

library test_crwapi;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
 M=5;
 N=3;
var
 x : IDoubleVectorWrap;
 y : IDoubleVectorWrap;
 a : IDoubleMatrixWrap;
 p : IDoubleMatrixWrap;
 s : ISVDWrap;
 r : Integer;
 c : Integer;
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  if not WindowExists(swin)
  then Raise EDanApi.Create(RusEng('Не найдено окно - источник!','Source window not found!'));
  if not WindowExists(twin)
  then Raise EDanApi.Create(RusEng('Не найдено окно - приемник!','Target window not found!'));
  if CurvesCount[swin]=0
  then Raise EDanApi.Create(RusEng('Нет данных для обработки!','No input data curves found!'));
  p:=nil;
  s:=nil;
  x:=CreateDoubleVector(N);
  y:=CreateDoubleVector(M);
  a:=CreateDoubleMatrix(M,N);
  try
   for r:=0 to M-1 do for c:=0 to N-1 do a[r,c]:=r+1+c*M;
   for r:=0 to a.Rows-1 do begin
    for c:=0 to a.Cols-1 do write(' ',a[r,c]:8:5);
    writeln;
   end;
   s:=CreateSingularDecomposition(a);
   writeln('W=');
   for r:=0 to s.N-1 do write(' ',s.W[r]:8:5);
   writeln;
   writeln('U=');
   for r:=0 to s.M-1 do begin
    for c:=0 to s.N-1 do write(' ',s.U[r,c]:8:5);
    writeln;
   end;
   writeln('V=');
   for r:=0 to s.N-1 do begin
   for c:=0 to s.N-1 do write(' ',s.V[r,c]:8:5);
    writeln;
   end;
   writeln('Rank=',s.Rank(0,1E-10));
   y[0]:=5; y[1]:=5; y[2]:=5; y[3]:=5; y[4]:=5;
   writeln('Solve test');
   if s.Solve(X,Y,0,1e-10) then for r:=0 to N-1 do write(X[r]:8:5,' ');
   writeln;
   writeln('PInvert:');
   p:=s.pinvert(0,1E-10);
   for r:=0 to p.Rows-1 do begin
    for c:=0 to p.Cols-1 do write(' ',p[r,c]:8:5);
    writeln;
   end;
  finally
   Kill(s);
   Kill(x);
   Kill(y);
   Kill(a);
   Kill(p);
  end;
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!'));
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
